/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import net.gdface.utils.MiscellaneousUtils;

public class ConditionChecks {
    private ConditionChecks() {
    }

    public static <X extends Throwable> void checkTrue(boolean b, Class<X> declareType, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) throws X {
        if (!b) {
            try {
                throw (Throwable)ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]).getConstructor(String.class).newInstance(ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <X extends Throwable> void checkTrue(boolean b, Class<X> declareType, @Nullable String errorMessageTemplate, @Nullable Object p1) throws X {
        if (!b) {
            try {
                throw (Throwable)ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]).getConstructor(String.class).newInstance(ConditionChecks.format(errorMessageTemplate, p1));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <X extends Throwable> void checkTrue(boolean b, Class<X> declareType, Object ctorArg, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) throws X {
        if (!b) {
            try {
                ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]);
                ConditionChecks.checkNotNull(ctorArg, "ctorArg is null", new Object[0]);
                try {
                    throw (Throwable)MiscellaneousUtils.getConstructor(declareType, ctorArg.getClass(), String.class).newInstance(ctorArg, ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
                }
                catch (NoSuchMethodException e) {
                    throw (Throwable)MiscellaneousUtils.getConstructor(declareType, String.class, ctorArg.getClass()).newInstance(ConditionChecks.format(errorMessageTemplate, errorMessageArgs), ctorArg);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <X extends Throwable> void checkTrue(boolean b, Class<X> declareType, Object ctorArg, @Nullable String errorMessageTemplate, @Nullable Object p1) throws X {
        if (!b) {
            try {
                ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]);
                ConditionChecks.checkNotNull(ctorArg, "ctorArg is null", new Object[0]);
                try {
                    throw (Throwable)MiscellaneousUtils.getConstructor(declareType, ctorArg.getClass(), String.class).newInstance(ctorArg, ConditionChecks.format(errorMessageTemplate, p1));
                }
                catch (NoSuchMethodException e) {
                    throw (Throwable)MiscellaneousUtils.getConstructor(declareType, String.class, ctorArg.getClass()).newInstance(ConditionChecks.format(errorMessageTemplate, p1), ctorArg);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <X extends Throwable> void checkTrue(boolean b, Class<X> declareType, Object ctorArg) throws X {
        if (!b) {
            try {
                ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]);
                ConditionChecks.checkNotNull(ctorArg, "ctorArg is null", new Object[0]);
                throw (Throwable)MiscellaneousUtils.getConstructor(declareType, ctorArg.getClass()).newInstance(ctorArg);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @CanIgnoreReturnValue
    public static <T, X extends Throwable> T checkNotNull(T reference, Class<X> declareType, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) throws X {
        if (null == reference) {
            try {
                throw (Throwable)ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]).getConstructor(String.class).newInstance(ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T, X extends Throwable> T checkNotNull(T reference, Class<X> declareType, @Nullable String errorMessageTemplate, @Nullable Object p1) throws X {
        if (null == reference) {
            try {
                throw (Throwable)ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]).getConstructor(String.class).newInstance(ConditionChecks.format(errorMessageTemplate, p1));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T, X extends Throwable> T checkNotNull(T reference, Class<X> declareType, Object ctorArg, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) throws X {
        if (null == reference) {
            try {
                ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]);
                ConditionChecks.checkNotNull(ctorArg, "ctorArg is null", new Object[0]);
                try {
                    throw (Throwable)MiscellaneousUtils.getConstructor(declareType, ctorArg.getClass(), String.class).newInstance(ctorArg, ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
                }
                catch (NoSuchMethodException e) {
                    throw (Throwable)MiscellaneousUtils.getConstructor(declareType, String.class, ctorArg.getClass()).newInstance(ConditionChecks.format(errorMessageTemplate, errorMessageArgs), ctorArg);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T, X extends Throwable> T checkNotNull(T reference, Class<X> declareType, Object ctorArg, @Nullable String errorMessageTemplate, @Nullable Object p1) throws X {
        if (null == reference) {
            try {
                ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]);
                ConditionChecks.checkNotNull(ctorArg, "ctorArg is null", new Object[0]);
                try {
                    throw (Throwable)MiscellaneousUtils.getConstructor(declareType, ctorArg.getClass(), String.class).newInstance(ctorArg, ConditionChecks.format(errorMessageTemplate, p1));
                }
                catch (NoSuchMethodException e) {
                    throw (Throwable)MiscellaneousUtils.getConstructor(declareType, String.class, ctorArg.getClass()).newInstance(ConditionChecks.format(errorMessageTemplate, p1), ctorArg);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T, X extends Throwable> T checkNotNull(T reference, Class<X> declareType, Object ctorArg) throws X {
        if (null == reference) {
            try {
                ConditionChecks.checkNotNull(declareType, "declareType is null", new Object[0]);
                ConditionChecks.checkNotNull(ctorArg, "ctorArg is null", new Object[0]);
                throw (Throwable)MiscellaneousUtils.getConstructor(declareType, ctorArg.getClass()).newInstance(ctorArg);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return reference;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

