/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import net.gdface.utils.Assert;
import net.gdface.utils.Base64Utils;
import net.gdface.utils.FaceUtilitsX;
import net.gdface.utils.Judge;

public class FaceUtilits {
    private static final String MD5_REGEX = "^[a-fA-F0-9]{32}$";
    private static final String HEX_REGEX = "^([a-fA-F0-9]{2})+$";

    public static byte[] getMD5(byte[] source) {
        if (Judge.isNull(source)) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(source);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytesInBuffer(ByteBuffer buffer) {
        if (null == buffer) {
            return null;
        }
        int pos = buffer.position();
        try {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            buffer.position(pos);
        }
    }

    public static ByteBuffer getMD5(ByteBuffer source) {
        return null == source ? null : ByteBuffer.wrap(FaceUtilits.getMD5(FaceUtilits.getBytesInBuffer(source)));
    }

    public static String toHex(byte[] buffer) {
        if (Judge.isNull(buffer)) {
            return null;
        }
        StringBuffer sb = new StringBuffer(buffer.length * 2);
        for (int i = 0; i < buffer.length; ++i) {
            sb.append(Character.forDigit((buffer[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(buffer[i] & 0xF, 16));
        }
        return sb.toString();
    }

    public static String toHex(ByteBuffer buffer) {
        return FaceUtilits.toHex(FaceUtilits.getBytesInBuffer(buffer));
    }

    public boolean validHEX(String input) {
        return input != null && input.matches(HEX_REGEX);
    }

    public static byte[] hex2Bytes(String src) {
        if (null == src) {
            return null;
        }
        byte[] res = new byte[src.length() / 2];
        char[] chs = src.toCharArray();
        int[] b = new int[2];
        int i = 0;
        int c = 0;
        while (i < chs.length) {
            for (int j = 0; j < 2; ++j) {
                if (chs[i + j] >= '0' && chs[i + j] <= '9') {
                    b[j] = chs[i + j] - 48;
                    continue;
                }
                if (chs[i + j] >= 'A' && chs[i + j] <= 'F') {
                    b[j] = chs[i + j] - 65 + 10;
                    continue;
                }
                if (chs[i + j] < 'a' || chs[i + j] > 'f') continue;
                b[j] = chs[i + j] - 97 + 10;
            }
            b[0] = (b[0] & 0xF) << 4;
            b[1] = b[1] & 0xF;
            res[c] = (byte)(b[0] | b[1]);
            i += 2;
            ++c;
        }
        return res;
    }

    public static ByteBuffer hex2ByteBuffer(String src) {
        return null == src ? null : ByteBuffer.wrap(FaceUtilits.hex2Bytes(src));
    }

    public static String getMD5String(byte[] source) {
        return FaceUtilits.toHex(FaceUtilits.getMD5(source));
    }

    public static String getMD5String(ByteBuffer source) {
        return FaceUtilits.toHex(FaceUtilits.getMD5(source));
    }

    public static final boolean validMd5(String md5) {
        return null != md5 && md5.matches(MD5_REGEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException, IllegalArgumentException {
        Assert.notNull(in, "in");
        if (in instanceof FileInputStream) {
            return FaceUtilits.readBytes((FileInputStream)in);
        }
        try {
            int buffSize = Math.max(in.available(), 8192);
            byte[] temp = new byte[buffSize];
            ByteArrayOutputStream out = new ByteArrayOutputStream(buffSize);
            int size = 0;
            while ((size = in.read(temp)) != -1) {
                out.write(temp, 0, size);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(FileInputStream fin) throws IOException {
        Assert.notNull(fin, "fin");
        FileChannel fc = fin.getChannel();
        try {
            ByteBuffer bb = ByteBuffer.allocate((int)fc.size());
            fc.read(bb);
            bb.flip();
            byte[] byArray = bb.array();
            return byArray;
        }
        finally {
            if (null != fc) {
                fc.close();
            }
            fin.close();
        }
    }

    public static <T> InputStream getInputStream(T src) throws IOException, IllegalArgumentException {
        Assert.notNull(src, "src");
        if (src instanceof InputStream) {
            return (InputStream)src;
        }
        if (src instanceof String) {
            return new ByteArrayInputStream(Base64Utils.decode((String)src));
        }
        if (src instanceof byte[]) {
            return new ByteArrayInputStream((byte[])src);
        }
        if (src instanceof ByteBuffer) {
            return new ByteArrayInputStream(FaceUtilits.getBytesInBuffer((ByteBuffer)src));
        }
        if (src instanceof File) {
            return new FileInputStream((File)src);
        }
        if (src instanceof URL) {
            return ((URL)src).openStream();
        }
        if (src instanceof URI) {
            return ((URI)src).toURL().openStream();
        }
        throw new IllegalArgumentException(String.format("Can't get inputstream from [%s]", src.getClass().getCanonicalName()));
    }

    public static final <T> byte[] getBytes(T src) throws IOException, IllegalArgumentException {
        Assert.notNull(src, "src");
        if (src instanceof byte[]) {
            return (byte[])src;
        }
        if (src instanceof String) {
            return Base64Utils.decode((String)src);
        }
        if (src instanceof ByteBuffer) {
            return FaceUtilits.getBytesInBuffer((ByteBuffer)src);
        }
        if (src instanceof FileInputStream) {
            return FaceUtilits.readBytes((FileInputStream)src);
        }
        if (src instanceof File) {
            return FaceUtilits.readBytes(new FileInputStream((File)src));
        }
        return FaceUtilits.readBytes(FaceUtilits.getInputStream(src));
    }

    public static final <T> byte[] getBytesOrNull(T src) throws IOException, IllegalArgumentException {
        return src == null ? null : FaceUtilits.getBytes(src);
    }

    public static final <T> byte[] getBytesNotEmpty(T src) throws IOException, IllegalArgumentException {
        byte[] imgData = FaceUtilits.getBytes(src);
        if (Judge.isEmpty(imgData)) {
            throw new IOException(String.format("return null or zero length from %s", src.getClass().getSimpleName()));
        }
        return imgData;
    }

    public static final <T> ByteBuffer getByteBuffer(T src) throws IOException, IllegalArgumentException {
        return ByteBuffer.wrap(FaceUtilits.getBytes(src));
    }

    public static final <T> ByteBuffer getByteBufferOrNull(T src) throws IOException, IllegalArgumentException {
        return null == src ? null : ByteBuffer.wrap(FaceUtilits.getBytes(src));
    }

    public static final <T> ByteBuffer getByteBufferNotEmpty(T src) throws IOException, IllegalArgumentException {
        return ByteBuffer.wrap(FaceUtilits.getBytesNotEmpty(src));
    }

    public static File saveImageAutoName(byte[] img, File folder) throws IOException, IllegalArgumentException {
        Assert.notEmpty(img, "img");
        File file = new File(folder, FaceUtilits.getMD5String(img) + "." + FaceUtilitsX.getFormatName(img).toLowerCase());
        return FaceUtilits.saveBytes(img, file, file.exists() && file.isFile() && 0L == file.length());
    }

    public static File saveImage(InputStream img, File folder) throws IOException, IllegalArgumentException {
        Assert.notNull(img, "img");
        byte[] imgData = FaceUtilits.readBytes(img);
        return Judge.isEmpty(imgData) ? null : FaceUtilits.saveImageAutoName(imgData, folder);
    }

    public static URI createURI(String urlStr) throws MalformedURLException {
        try {
            return new URI(urlStr);
        }
        catch (URISyntaxException e) {
            try {
                URL url = new URL(urlStr);
                return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveBytes(byte[] data, File file, boolean overwrite) throws IOException, IllegalArgumentException {
        Assert.notNull(data, "data");
        FileOutputStream out = null;
        AbstractInterruptibleChannel fc = null;
        try {
            long free;
            File folder = file.getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if ((free = folder.getFreeSpace() >> 20) < 10L) {
                throw new IOException(String.format("DISK ALMOST FULL(\u78c1\u76d8\u7a7a\u95f4\u4e0d\u8db3) FREE %dMB,%s", free, folder.getAbsolutePath()));
            }
            if (!file.exists() || !file.isFile() || overwrite) {
                out = new FileOutputStream(file);
                fc = out.getChannel();
                ByteBuffer bb = ByteBuffer.wrap(data);
                ((FileChannel)fc).write(bb);
            }
            File file2 = file;
            return file2;
        }
        finally {
            if (null != fc) {
                fc.close();
            }
            if (null != out) {
                out.close();
            }
        }
    }

    public static Class<?>[] getParameterizedTypeNoThrow(Class<?> clazz) {
        try {
            Class<?>[] types = FaceUtilits.getParameterizedType(clazz);
            return types;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?>[] getParameterizedType(Class<?> clazz) throws MalformedParameterizedTypeException, IllegalArgumentException {
        Type superType = clazz.getGenericSuperclass();
        if (!(superType instanceof ParameterizedType)) {
            throw new IllegalArgumentException(String.format("superclass of %s  not ParameterizedType(\u8d85\u7c7b\u4e0d\u662f\u6cdb\u578b\u7c7b)", clazz.getName()));
        }
        Type[] types = ((ParameterizedType)superType).getActualTypeArguments();
        Class[] paramClass = new Class[types.length];
        for (int i = 0; i < paramClass.length; ++i) {
            if (!(types[i] instanceof Class)) {
                System.err.printf("cant'not get class for ParameterizedType (\u65e0\u6cd5\u83b7\u53d6\u5b9e\u9645\u6cdb\u578b\u53c2\u6570\u5bf9\u8c61\u7c7b\u578b(Class)) %s", types[i]);
                throw new MalformedParameterizedTypeException();
            }
            paramClass[i] = (Class)types[i];
        }
        return paramClass;
    }

    public static final Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return FaceUtilits.getRawClass(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException(String.format("invalid type %s", type));
    }

    public static final Class<?>[] getRawClassOfSuperPamamType(Class<?> type) {
        Type superType = type.getGenericSuperclass();
        if (!(superType instanceof ParameterizedType)) {
            throw new IllegalArgumentException(String.format("superclass of %s  not ParameterizedType(\u8d85\u7c7b\u4e0d\u662f\u6cdb\u578b\u7c7b)", type.getName()));
        }
        Type[] types = ((ParameterizedType)superType).getActualTypeArguments();
        Class[] paramClass = new Class[types.length];
        for (int i = 0; i < paramClass.length; ++i) {
            paramClass[i] = FaceUtilits.getRawClass(types[i]);
        }
        return paramClass;
    }

    public static final Class<?>[] getRawClassOfSuperPamamType(Object obj) {
        return FaceUtilits.getRawClassOfSuperPamamType(obj.getClass());
    }

    public static final Throwable getCause(Throwable e) {
        return e == null ? null : (e.getCause() == null ? e : e.getCause());
    }

    public static final Throwable stripThrowableShell(Throwable e, Class<? extends Throwable> shellClass) {
        if (!Judge.hasNull(e, e.getCause()) && e.getClass() == shellClass) {
            return FaceUtilits.stripThrowableShell(e.getCause(), shellClass);
        }
        return e;
    }

    public static final boolean isNetworkError(Throwable e) {
        return e instanceof SocketTimeoutException || e instanceof ConnectException || null != e && FaceUtilits.isNetworkError(e.getCause());
    }

    public static void storeSortedMap(Map<String, String> map, Writer writer, String lineSeparator) throws IOException {
        Assert.notNull(writer, "writer");
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        if (null != map) {
            sortedMap.putAll(map);
        }
        BufferedWriter bw = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        for (Map.Entry e : sortedMap.entrySet()) {
            bw.write((String)e.getKey() + "=" + (String)e.getValue());
            if (null == lineSeparator) {
                bw.newLine();
                continue;
            }
            bw.write("\n");
        }
        bw.flush();
    }

    public static void storeSortedSet(Collection<String> collection, Writer writer, String lineSeparator) throws IOException {
        Assert.notNull(writer, "writer");
        TreeSet<String> sortedSet = new TreeSet<String>();
        if (null != collection) {
            sortedSet.addAll(collection);
        }
        BufferedWriter bw = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        for (String e : sortedSet) {
            bw.write(e);
            if (null == lineSeparator) {
                bw.newLine();
                continue;
            }
            bw.write("\n");
        }
        bw.flush();
    }

    public static <K, V> boolean equals(Map<K, V> m1, Map<K, V> m2) {
        if (m1 == m2) {
            return true;
        }
        if (null == m1 || null == m2) {
            return false;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            V v2;
            K key = entry.getKey();
            if (!m2.containsKey(key)) {
                return false;
            }
            V v1 = entry.getValue();
            if (v1 == (v2 = m2.get(key))) continue;
            if (null == v1 || null == v2) {
                return false;
            }
            if (v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public static List<String> elementsOf(String input) {
        ArrayList<String> list = new ArrayList<String>();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input, " ,;\t\n\r\f");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }
}

