/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import net.gdface.utils.NetworkUtil;

public class MultiCastDispatcher
implements Runnable {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final InetAddress group;
    private final int port;
    private final Predicate<byte[]> processor;
    private final Predicate<Throwable> onerr;
    private Boolean stopListener = null;
    private final byte[] message;
    private DatagramSocket datagramSocket;

    public MultiCastDispatcher(InetAddress group, int port, int bufferSize, Predicate<byte[]> processor, Predicate<Throwable> onerr) {
        Preconditions.checkArgument(null != group, "group is null");
        Preconditions.checkArgument(group.isMulticastAddress() || NetworkUtil.isBroadcast(group), "group %s is not a multicast or broadcast address", (Object)group);
        this.group = group;
        this.port = port;
        this.processor = Preconditions.checkNotNull(processor, "processor is null");
        this.onerr = MoreObjects.firstNonNull(onerr, Predicates.alwaysTrue());
        this.message = new byte[bufferSize <= 0 ? 1024 : bufferSize];
    }

    public MultiCastDispatcher(String bindaddr, int port, int bufferSize, Predicate<byte[]> processor, Predicate<Throwable> onerr) throws UnknownHostException {
        this(InetAddress.getByName(Preconditions.checkNotNull(Strings.emptyToNull(bindaddr), "bindaddr is null or empty")), port, bufferSize, processor, onerr);
    }

    public MultiCastDispatcher(String hostPort, int bufferSize, Predicate<byte[]> processor, Predicate<Throwable> onerr) throws UnknownHostException {
        this(HostAndPort.fromString(hostPort).getHost(), HostAndPort.fromString(hostPort).getPort(), bufferSize, processor, onerr);
    }

    public MultiCastDispatcher init() throws IOException {
        if (null == this.datagramSocket) {
            if (NetworkUtil.isBroadcast(this.group)) {
                this.datagramSocket = new DatagramSocket(this.port);
                this.datagramSocket.setBroadcast(true);
            } else {
                MulticastSocket multicastSocket = new MulticastSocket(this.port);
                for (NetworkInterface nic : NetworkUtil.getNICs(NetworkUtil.Filter.UP, NetworkUtil.Filter.ETH_NIC)) {
                    InetSocketAddress inetAddr = new InetSocketAddress(this.group, 0);
                    multicastSocket.joinGroup(inetAddr, nic);
                }
                this.datagramSocket = multicastSocket;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.stopListener = Boolean.FALSE;
        DatagramPacket packet = new DatagramPacket(this.message, this.message.length);
        try {
            while (!Boolean.TRUE.equals(this.stopListener)) {
                try {
                    Preconditions.checkArgument(this.datagramSocket != null, "multicastSocket is uninitizlied");
                    this.datagramSocket.receive(packet);
                    byte[] recevied = new byte[packet.getLength()];
                    System.arraycopy(this.message, 0, recevied, 0, packet.getLength());
                    if (this.processor.apply(recevied)) continue;
                }
                catch (Exception e) {
                    if (this.onerr.apply(e)) continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.datagramSocket instanceof MulticastSocket) {
                    for (NetworkInterface nic : NetworkUtil.getNICs(NetworkUtil.Filter.UP, NetworkUtil.Filter.PHYICAL_ONLY)) {
                        InetSocketAddress inetAddr = new InetSocketAddress(this.group, 0);
                        ((MulticastSocket)this.datagramSocket).leaveGroup(inetAddr, nic);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.datagramSocket.close();
            this.datagramSocket = null;
            this.stopListener = null;
            throw throwable;
        }
        try {
            if (this.datagramSocket instanceof MulticastSocket) {
                for (NetworkInterface nic : NetworkUtil.getNICs(NetworkUtil.Filter.UP, NetworkUtil.Filter.PHYICAL_ONLY)) {
                    InetSocketAddress inetAddr = new InetSocketAddress(this.group, 0);
                    ((MulticastSocket)this.datagramSocket).leaveGroup(inetAddr, nic);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.datagramSocket.close();
        this.datagramSocket = null;
        this.stopListener = null;
    }

    public boolean isRunning() {
        return Boolean.FALSE.equals(this.stopListener);
    }

    public MultiCastDispatcher running() {
        this.stopListener = Boolean.FALSE;
        return this;
    }

    public synchronized void stop() {
        this.stopListener = Boolean.TRUE;
    }

    public InetAddress getGroup() {
        return this.group;
    }

    public int getPort() {
        return this.port;
    }
}

