/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ForwardingMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ReflectionUtils {
    public static final String PROP_CLASSNAME = "className";
    public static final String PROP_STATICMETHODNAME = "staticMethodName";
    public static final String PROP_PARAMETERTYPES = "parameterTypes";
    public static final String PROP_CONSTRUCTORARGS = "constructorArgs";
    public static final String PROP_CONSTRUCTORPARAMS = "constructorParams";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Set<String> overridableObjectMethods = new HashSet<String>(Arrays.asList("clone", "finalize", "hashCode", "equals", "toString"));

    public static <T> Class<? extends T> getInstanceClass(Class<T> superClass, String instanceClassName) throws ClassNotFoundException {
        Preconditions.checkArgument(null != superClass && !Strings.isNullOrEmpty(instanceClassName));
        Class<?> instanceClass = Class.forName(instanceClassName);
        ReflectionUtils.checkInstanceClass(superClass, instanceClass);
        return instanceClass;
    }

    public static <T> T getInstance(Class<T> superClass, Map<String, Object> params) throws NoSuchMethodException, ClassNotFoundException {
        ParameterMap paramMap = new ParameterMap(params);
        String clazzName = (String)paramMap.of(PROP_CLASSNAME);
        Class<T> instanceClass = ReflectionUtils.getInstanceClass(superClass, clazzName);
        String staticMethodName = (String)paramMap.of(PROP_STATICMETHODNAME);
        if (null != staticMethodName) {
            try {
                return ReflectionUtils.getInstanceByStaticMethod(superClass, instanceClass, staticMethodName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (paramMap.containsKey(PROP_CONSTRUCTORPARAMS)) {
            LinkedHashMap constructorParams = (LinkedHashMap)paramMap.of(PROP_CONSTRUCTORPARAMS);
            return ReflectionUtils.getInstanceByConstructor(superClass, instanceClass, constructorParams);
        }
        Class[] parameterTypes = (Class[])paramMap.of(PROP_PARAMETERTYPES);
        Object[] ctorArgs = (Object[])paramMap.of(PROP_CONSTRUCTORARGS);
        return ReflectionUtils.getInstanceByConstructor(superClass, instanceClass, parameterTypes, ctorArgs);
    }

    private static void checkInstanceClass(Class<?> superClass, Class<?> instanceClass) {
        Preconditions.checkArgument(null != superClass && null != instanceClass);
        Preconditions.checkArgument(!instanceClass.isInterface() && superClass.isAssignableFrom(instanceClass), "%s not a implemenation of %s", (Object)instanceClass.getName(), (Object)superClass.getSimpleName());
        Preconditions.checkArgument(!Modifier.isAbstract(instanceClass.getModifiers()), "%s is abstract class", (Object)instanceClass.getName());
        Preconditions.checkArgument(Modifier.isStatic(instanceClass.getModifiers()) || null == instanceClass.getDeclaringClass(), "%s is not static class", (Object)instanceClass.getName());
    }

    public static <T> T getInstanceByConstructor(Class<T> superClass, Class<? extends T> instanceClass, Class<?>[] parameterTypes, Object[] constructorArgs) throws NoSuchMethodException {
        ReflectionUtils.checkInstanceClass(superClass, instanceClass);
        parameterTypes = MoreObjects.firstNonNull(parameterTypes, EMPTY_CLASS_ARRAY);
        constructorArgs = MoreObjects.firstNonNull(constructorArgs, EMPTY_OBJECT_ARRAY);
        Preconditions.checkArgument(parameterTypes.length == constructorArgs.length);
        Constructor<T> ctor = instanceClass.getConstructor(parameterTypes);
        try {
            return ctor.newInstance(constructorArgs);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T getInstanceByConstructor(Class<T> superClass, Class<? extends T> instanceClass, LinkedHashMap<Class<?>, Object> constructorParams) throws NoSuchMethodException {
        ReflectionUtils.checkInstanceClass(superClass, instanceClass);
        constructorParams = MoreObjects.firstNonNull(constructorParams, new LinkedHashMap());
        Class[] parameterTypes = constructorParams.keySet().toArray(new Class[constructorParams.size()]);
        Object[] initargs = constructorParams.values().toArray(new Object[constructorParams.size()]);
        Constructor<T> ctor = instanceClass.getConstructor(parameterTypes);
        try {
            return ctor.newInstance(initargs);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked(e.getTargetException());
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T getInstanceByStaticMethod(Class<T> superClass, Class<? extends T> instanceClass, String staticMethodName) throws NoSuchMethodException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(staticMethodName));
        ReflectionUtils.checkInstanceClass(superClass, instanceClass);
        try {
            Method method = instanceClass.getMethod(staticMethodName, new Class[0]);
            Preconditions.checkArgument(Modifier.isStatic(method.getModifiers()), "%s is not a static method", (Object)method.toString());
            Preconditions.checkArgument(superClass.isAssignableFrom(method.getReturnType()), "unexpect return type %s", (Object)method.getReturnType().toString());
            try {
                return (T)method.invoke(null, new Object[0]);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("invalid return type of static method %s caused by %s", method.toString(), e.getMessage()));
            }
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T valueOfField(Object object, String name) {
        try {
            Field field = Preconditions.checkNotNull(object, "object is null").getClass().getDeclaredField(Preconditions.checkNotNull(name, "name is null"));
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static void setValueOfField(Object object, String name, Object value) {
        try {
            Field modifiers;
            Field field = Preconditions.checkNotNull(object, "object is null").getClass().getDeclaredField(Preconditions.checkNotNull(name, "name is null"));
            field.setAccessible(true);
            boolean isfinal = (field.getModifiers() & 0x10) == 16;
            String modifiersName = "modifiers";
            if (isfinal) {
                modifiers = field.getClass().getDeclaredField(modifiersName);
                modifiers.setAccessible(true);
                modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.set(object, value);
            if (isfinal) {
                modifiers = field.getClass().getDeclaredField(modifiersName);
                modifiers.setInt(field, field.getModifiers() | 0x10);
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static void setValueOfStaticField(Class<?> clazz, String name, Object value) {
        try {
            Field modifiers;
            Field field = Preconditions.checkNotNull(clazz, "clazz is null").getDeclaredField(Preconditions.checkNotNull(name, "name is null"));
            field.setAccessible(true);
            boolean isfinal = (field.getModifiers() & 0x10) == 16;
            String modifiersName = "modifiers";
            if (isfinal) {
                modifiers = field.getClass().getDeclaredField(modifiersName);
                modifiers.setAccessible(true);
                modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.set(clazz, value);
            if (isfinal) {
                modifiers = field.getClass().getDeclaredField(modifiersName);
                modifiers.setAccessible(true);
                modifiers.setInt(field, field.getModifiers() | 0x10);
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static Method getOverride(Method input) {
        if (input == null) {
            return null;
        }
        int modifier = input.getModifiers();
        if (Modifier.isStatic(modifier) || Modifier.isPrivate(modifier)) {
            return null;
        }
        Class<?> declaringClass = input.getDeclaringClass();
        if (Object.class.equals(declaringClass)) {
            return null;
        }
        Method om = ReflectionUtils.getOverrideObjectMethod(input);
        if (om != null) {
            return om;
        }
        try {
            Method self = declaringClass.getMethod(input.getName(), input.getParameterTypes());
            if (self.equals(input)) {
                return declaringClass.getSuperclass().getMethod(input.getName(), input.getParameterTypes());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static Method getOverrideTop(Method input) {
        Method sm;
        Method om = input;
        while ((sm = ReflectionUtils.getOverride(om)) != null) {
            om = sm;
        }
        if (Objects.equal(om, input)) {
            return null;
        }
        return om;
    }

    public static Method overrideTopOrSelf(Method input) {
        Method om = ReflectionUtils.getOverrideTop(input);
        return om == null ? input : om;
    }

    public static Method getOverrideObjectMethod(Method input) {
        if (input == null) {
            return null;
        }
        int modifier = input.getModifiers();
        if (Modifier.isStatic(modifier) || Modifier.isPrivate(modifier)) {
            return null;
        }
        String name = input.getName();
        if (!overridableObjectMethods.contains(name)) {
            return null;
        }
        try {
            Method om = Object.class.getDeclaredMethod(name, input.getParameterTypes());
            if (om.getReturnType().equals(input.getReturnType())) {
                return om;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isOverrideObjectMethod(Method input) {
        return ReflectionUtils.getOverrideObjectMethod(input) != null;
    }

    public static boolean isOverrideShadow(Method input) {
        if (input != null) {
            Class<?> declaringClass = input.getDeclaringClass();
            if (Object.class.equals(declaringClass)) {
                return false;
            }
            try {
                Method self = declaringClass.getMethod(input.getName(), input.getParameterTypes());
                return !self.equals(input);
            }
            catch (Throwable e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private static class ParameterMap
    extends ForwardingMap<String, Object> {
        private final Map<String, Object> delegate;

        public ParameterMap(Map<String, Object> delegate) {
            this.delegate = null == delegate ? Collections.emptyMap() : delegate;
        }

        @Override
        protected Map<String, Object> delegate() {
            return this.delegate;
        }

        public final <T> T of(String key, T defaultValue) {
            Preconditions.checkArgument(null != key);
            Object value = this.delegate.get(key);
            try {
                return (T)(null == value ? defaultValue : value);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("invalid parameter: " + key + ",caused by " + e.getMessage());
            }
        }

        public final <T> T of(String key) {
            return this.of(key, null);
        }
    }
}

