/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TimeCostProbe {
    private final AtomicLong timeCostMills = new AtomicLong(0L);
    private final AtomicLong count = new AtomicLong(0L);
    private String location = null;
    private TimeUnit outTimeUnit = TimeUnit.SECONDS;

    private String getMethodName() {
        StackTraceElement stack = Thread.currentThread().getStackTrace()[3];
        return stack.getClassName() + "." + stack.getMethodName();
    }

    public TimeCostProbe begin() {
        this.location = this.getMethodName();
        this.timeCostMills.set(System.currentTimeMillis());
        return this;
    }

    public TimeCostProbe end() {
        if (0L == this.timeCostMills.get()) {
            throw new IllegalArgumentException("begin/end not match");
        }
        if (!this.getMethodName().equals(this.location)) {
            throw new IllegalArgumentException("begin/end must be call in same method");
        }
        this.timeCostMills.set(System.currentTimeMillis() - this.timeCostMills.get());
        if (this.count.get() == 0L) {
            this.count.set(1L);
        }
        return this;
    }

    public TimeCostProbe add(long mills) {
        this.timeCostMills.addAndGet(mills);
        this.count.incrementAndGet();
        return this;
    }

    public TimeCostProbe add(TimeCostProbe probe) {
        if (probe != null) {
            this.timeCostMills.addAndGet(probe.timeCostMills.get());
            this.count.addAndGet(probe.count.get());
        }
        return this;
    }

    public TimeCostProbe addCount() {
        this.count.incrementAndGet();
        return this;
    }

    public long getTimeCostMills() {
        return this.timeCostMills.get();
    }

    public long getTimeCost(TimeUnit unit) {
        return unit.convert(this.timeCostMills.get(), TimeUnit.MILLISECONDS);
    }

    public long getCount() {
        return this.count.get();
    }

    public void print() {
        System.out.println(this.log(this.location));
    }

    public void print(String name) {
        System.out.println(this.log(name));
    }

    public String log(String name) {
        return this.log(name, this.outTimeUnit);
    }

    public String log(String name, TimeUnit unit) {
        if (0L == this.count.get()) {
            throw new IllegalArgumentException("begin/end not match");
        }
        return String.format("%s: average cost:%f %s(sample count %d)\n", name, (double)unit.convert(this.timeCostMills.get(), TimeUnit.MILLISECONDS) / (double)this.count.get(), unit.name().toLowerCase(), this.count.get());
    }

    public String log() {
        return this.log(this.location);
    }

    public TimeUnit getOutTimeUnit() {
        return this.outTimeUnit;
    }

    public TimeCostProbe setOutTimeUnit(TimeUnit outTimeUnit) {
        if (null != outTimeUnit) {
            this.outTimeUnit = outTimeUnit;
        }
        return this;
    }
}

