/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeTransformer {
    private final Function sameTypeFun = new Function(){

        public Object apply(Object input) {
            return input;
        }
    };
    private final Function<byte[], ByteBuffer> byteArray2ByteBufferFun = new Function<byte[], ByteBuffer>(){

        @Override
        public ByteBuffer apply(byte[] input) {
            return null == input ? null : ByteBuffer.wrap(input);
        }
    };
    private final Function<ByteBuffer, byte[]> byteBuffer2ByteArrayFun = new Function<ByteBuffer, byte[]>(){

        @Override
        public byte[] apply(ByteBuffer input) {
            return TypeTransformer.getBytesInBuffer(input);
        }
    };
    private final Function<Float, Double> float2DoubleFun = new Function<Float, Double>(){

        @Override
        public Double apply(Float input) {
            return null == input ? null : Double.valueOf(input.doubleValue());
        }
    };
    private final Function<Double, Float> double2FloatFun = new Function<Double, Float>(){

        @Override
        public Float apply(Double input) {
            return null == input ? null : Float.valueOf(input.floatValue());
        }
    };
    private final Function<java.util.Date, Long> date2LongFunction = new Function<java.util.Date, Long>(){

        @Override
        public Long apply(java.util.Date input) {
            return null == input ? null : Long.valueOf(input.getTime());
        }
    };
    private final Function<Long, java.util.Date> long2DateFun = new Function<Long, java.util.Date>(){

        @Override
        public java.util.Date apply(Long input) {
            return null == input ? null : new java.util.Date(input);
        }
    };
    private final Function<Long, Date> long2SqlDateFun = new Function<Long, Date>(){

        @Override
        public Date apply(Long input) {
            return null == input ? null : new Date(input);
        }
    };
    private final Function<Long, Time> long2SqlTimeFun = new Function<Long, Time>(){

        @Override
        public Time apply(Long input) {
            return null == input ? null : new Time(input);
        }
    };
    private final Function<URL, String> url2StringFun = new Function<URL, String>(){

        @Override
        public String apply(URL input) {
            return null == input ? null : input.toString();
        }
    };
    private final Function<URI, String> uri2StringFun = new Function<URI, String>(){

        @Override
        public String apply(URI input) {
            return null == input ? null : input.toString();
        }
    };
    private final Function<String, URL> string2UrlFun = new Function<String, URL>(){

        @Override
        public URL apply(String input) {
            try {
                return null == input ? null : new URL(input);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final Function<String, URI> string2UriFun = new Function<String, URI>(){

        @Override
        public URI apply(String input) {
            return null == input ? null : URI.create(input);
        }
    };
    private final Function<int[], List<Integer>> intArray2List = new Function<int[], List<Integer>>(){

        @Override
        public List<Integer> apply(int[] input) {
            return null == input ? null : Ints.asList(input);
        }
    };
    private final Function<long[], List<Long>> longArray2List = new Function<long[], List<Long>>(){

        @Override
        public List<Long> apply(long[] input) {
            return null == input ? null : Longs.asList(input);
        }
    };
    private final Function<double[], List<Double>> doubleArray2List = new Function<double[], List<Double>>(){

        @Override
        public List<Double> apply(double[] input) {
            return null == input ? null : Doubles.asList(input);
        }
    };
    private final Function<float[], List<Double>> floatArray2List = new Function<float[], List<Double>>(){

        @Override
        public List<Double> apply(float[] input) {
            return null == input ? null : Lists.transform(Floats.asList(input), TypeTransformer.this.float2DoubleFun);
        }
    };
    private final Function<short[], List<Short>> shortArray2List = new Function<short[], List<Short>>(){

        @Override
        public List<Short> apply(short[] input) {
            return null == input ? null : Shorts.asList(input);
        }
    };
    private final Function<boolean[], List<Boolean>> booleanArray2List = new Function<boolean[], List<Boolean>>(){

        @Override
        public List<Boolean> apply(boolean[] input) {
            return null == input ? null : Booleans.asList(input);
        }
    };
    private final Function<List<Integer>, int[]> list2intArray = new Function<List<Integer>, int[]>(){

        @Override
        public int[] apply(List<Integer> input) {
            return null == input ? null : Ints.toArray(input);
        }
    };
    private final Function<List<Long>, long[]> list2longArray = new Function<List<Long>, long[]>(){

        @Override
        public long[] apply(List<Long> input) {
            return null == input ? null : Longs.toArray(input);
        }
    };
    private final Function<List<Double>, double[]> list2doubleArray = new Function<List<Double>, double[]>(){

        @Override
        public double[] apply(List<Double> input) {
            return null == input ? null : Doubles.toArray(input);
        }
    };
    private final Function<List<Double>, float[]> list2floatArray = new Function<List<Double>, float[]>(){

        @Override
        public float[] apply(List<Double> input) {
            return null == input ? null : Floats.toArray(input);
        }
    };
    private final Function<List<Short>, short[]> list2shortArray = new Function<List<Short>, short[]>(){

        @Override
        public short[] apply(List<Short> input) {
            return null == input ? null : Shorts.toArray(input);
        }
    };
    private final Function<List<Boolean>, boolean[]> list2booleanArray = new Function<List<Boolean>, boolean[]>(){

        @Override
        public boolean[] apply(List<Boolean> input) {
            return null == input ? null : Booleans.toArray(input);
        }
    };
    protected final Table<Class<?>, Class<?>, Function<?, ?>> transTable = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytesInBuffer(ByteBuffer buffer) {
        if (null == buffer) {
            return null;
        }
        int pos = buffer.position();
        try {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            buffer.position(pos);
        }
    }

    public TypeTransformer() {
        this.transTable.put(byte[].class, ByteBuffer.class, this.byteArray2ByteBufferFun);
        this.transTable.put(ByteBuffer.class, byte[].class, this.byteBuffer2ByteArrayFun);
        this.transTable.put(Float.class, Double.class, this.float2DoubleFun);
        this.transTable.put(Double.class, Float.class, this.double2FloatFun);
        this.transTable.put(Float.TYPE, Double.TYPE, this.float2DoubleFun);
        this.transTable.put(Double.TYPE, Float.TYPE, this.double2FloatFun);
        this.transTable.put(java.util.Date.class, Long.class, this.date2LongFunction);
        this.transTable.put(Date.class, Long.class, this.date2LongFunction);
        this.transTable.put(Time.class, Long.class, this.date2LongFunction);
        this.transTable.put(Long.class, java.util.Date.class, this.long2DateFun);
        this.transTable.put(Long.class, Date.class, this.long2SqlDateFun);
        this.transTable.put(Long.class, Time.class, this.long2SqlTimeFun);
        this.transTable.put(URL.class, String.class, this.url2StringFun);
        this.transTable.put(URI.class, String.class, this.uri2StringFun);
        this.transTable.put(String.class, URL.class, this.string2UrlFun);
        this.transTable.put(String.class, URI.class, this.string2UriFun);
        this.transTable.put(int[].class, List.class, this.intArray2List);
        this.transTable.put(long[].class, List.class, this.longArray2List);
        this.transTable.put(double[].class, List.class, this.doubleArray2List);
        this.transTable.put(float[].class, List.class, this.floatArray2List);
        this.transTable.put(short[].class, List.class, this.shortArray2List);
        this.transTable.put(boolean[].class, List.class, this.booleanArray2List);
        this.transTable.put(List.class, int[].class, this.list2intArray);
        this.transTable.put(List.class, long[].class, this.list2longArray);
        this.transTable.put(List.class, double[].class, this.list2doubleArray);
        this.transTable.put(List.class, float[].class, this.list2floatArray);
        this.transTable.put(List.class, short[].class, this.list2shortArray);
        this.transTable.put(List.class, boolean[].class, this.list2booleanArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L, R> TypeTransformer setTransformer(Class<L> left, Class<R> right, Function<L, R> trans) {
        Preconditions.checkArgument(null != left && null != right && null != trans, "left, right, trans must not be null");
        Table<Class<?>, Class<?>, Function<?, ?>> table = this.transTable;
        synchronized (table) {
            this.transTable.put(left, right, trans);
            return this;
        }
    }

    public <L, R> Function<L, R> getTransformer(Class<L> left, Class<R> right) {
        Preconditions.checkArgument(null != left && null != right, "left, right must not be null");
        if (right.isAssignableFrom(left)) {
            return this.sameTypeFun;
        }
        Function<?, ?> result = this.transTable.get(left, right);
        return result;
    }

    public <L, R> Function<L, R> getTransformerChecked(Class<L> left, Class<R> right) {
        return Preconditions.checkNotNull(this.getTransformer(left, right), "not found transformer for %s to %s", left, right);
    }

    public <L, R> R to(L value, Class<L> left, Class<R> right) {
        if (null == value) {
            return null;
        }
        Preconditions.checkArgument(null != right, "right is null");
        if (right.isInstance(value)) {
            return (R)value;
        }
        return this.getTransformerChecked(left, right).apply(value);
    }

    public <L, R> List<R> to(List<L> input, Class<L> left, Class<R> right) {
        return null == input ? null : Lists.transform(input, this.getTransformerChecked(left, right));
    }

    public <L, R> Set<R> to(Set<L> input, Class<L> left, Class<R> right) {
        return null == input ? null : Sets.newHashSet(Iterables.transform(input, this.getTransformerChecked(left, right)));
    }

    public <L, R> List<R> to(L[] input, Class<L> left, Class<R> right) {
        if (null == input) {
            return null;
        }
        return this.to(Arrays.asList(input), left, right);
    }

    public List<Integer> to(int[] input, Class<Integer> left, Class<Integer> right) {
        return this.intArray2List.apply(input);
    }

    public List<Long> to(long[] input, Class<Long> left, Class<Long> right) {
        return this.longArray2List.apply(input);
    }

    public List<Double> to(double[] input, Class<Double> left, Class<Double> right) {
        return this.doubleArray2List.apply(input);
    }

    public List<Double> to(float[] input, Class<Float> left, Class<Double> right) {
        return this.floatArray2List.apply(input);
    }

    public List<Short> to(short[] input, Class<Short> left, Class<Short> right) {
        return this.shortArray2List.apply(input);
    }

    public List<Boolean> to(boolean[] input, Class<Boolean> left, Class<Boolean> right) {
        return this.booleanArray2List.apply(input);
    }

    public <L, R> R[] toArray(List<L> input, Class<L> left, Class<R> right) {
        if (null == input) {
            return null;
        }
        List<R> r = this.to(input, left, right);
        return r.toArray((Object[])Array.newInstance(right, r.size()));
    }

    public int[] tointArray(List<Integer> input, Class<Integer> left, Class<Integer> right) {
        return this.list2intArray.apply(input);
    }

    public long[] tolongArray(List<Long> input, Class<Long> left, Class<Long> right) {
        return this.list2longArray.apply(input);
    }

    public double[] todoubleArray(List<Double> input, Class<Double> left, Class<Double> right) {
        return this.list2doubleArray.apply(input);
    }

    public float[] tofloatArray(List<Double> input, Class<Double> left, Class<Float> right) {
        return this.list2floatArray.apply(input);
    }

    public short[] toshortArray(List<Short> input, Class<Short> left, Class<Short> right) {
        return this.list2shortArray.apply(input);
    }

    public boolean[] tobooleanArray(List<Boolean> input, Class<Boolean> left, Class<Boolean> right) {
        return this.list2booleanArray.apply(input);
    }

    public <K1, V1, K2, V2> Map<K2, V2> to(Map<K1, V1> input, Class<K1> k1, Class<V1> v1, Class<K2> k2, Class<V2> v2) {
        Preconditions.checkArgument(null != k1 && null != v1 && null != k2 && null != v2, "k1,v1,k2,v2 must not be null");
        if (k1 == k2) {
            if (v1 == v2) {
                return input;
            }
            return Maps.transformValues(input, this.getTransformerChecked(v1, v2));
        }
        Map<K2, V1> k2v1 = TypeTransformer.transform(input, this.getTransformerChecked(k1, k2));
        if (v1 == v2) {
            return k2v1;
        }
        return Maps.transformValues(k2v1, this.getTransformerChecked(v1, v2));
    }

    private static final <K1, K2, V> Map<K2, V> transform(Map<K1, V> fromMap, final Function<K1, K2> transformer) {
        Preconditions.checkNotNull(fromMap, "fromMap is null");
        Preconditions.checkNotNull(transformer, "transformer is null");
        ImmutableMap k2Entry = Maps.uniqueIndex(fromMap.entrySet(), new Function<Map.Entry<K1, V>, K2>(){

            @Override
            public K2 apply(Map.Entry<K1, V> input) {
                return transformer.apply(input.getKey());
            }
        });
        Map k2V = Maps.transformEntries(k2Entry, new Maps.EntryTransformer<K2, Map.Entry<K1, V>, V>(){

            @Override
            public V transformEntry(K2 key, Map.Entry<K1, V> value) {
                return value.getValue();
            }
        });
        return k2V;
    }
}

