/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtils {
    static final FullName FULLNAME_INSTANCE_TRUE = new FullName(){

        @Override
        public boolean isFullName(Class<?> type) {
            return true;
        }
    };
    private static final FullName FULLNAME_INSTANCE_FALSE = new FullName(){

        @Override
        public boolean isFullName(Class<?> type) {
            return true;
        }
    };

    public static void traverseTypes(Type type, Action action) {
        Preconditions.checkArgument(null != action, "action is null");
        if (type instanceof Class) {
            action.doClass((Class)type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            TypeUtils.traverseTypes(rawType, action);
            for (Type arg : typeArgs) {
                TypeUtils.traverseTypes(arg, action);
            }
        } else if (type instanceof GenericArrayType) {
            TypeUtils.traverseTypes(((GenericArrayType)type).getGenericComponentType(), action);
        } else if (type instanceof TypeVariable) {
            for (Type t : ((TypeVariable)type).getBounds()) {
                TypeUtils.traverseTypes(t, action);
            }
        } else if (type instanceof WildcardType) {
            for (Type t : ((WildcardType)type).getLowerBounds()) {
                TypeUtils.traverseTypes(t, action);
            }
            for (Type t : ((WildcardType)type).getUpperBounds()) {
                TypeUtils.traverseTypes(t, action);
            }
        } else {
            throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
        }
    }

    public static <K, V> TypeToken<Map<K, V>> mapToken(TypeToken<K> keyToken, TypeToken<V> valueToken) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyToken).where(new TypeParameter<V>(){}, valueToken);
    }

    public static <T> TypeToken<List<T>> listToken(TypeToken<T> keyToken) {
        return new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, keyToken);
    }

    public static <T> TypeToken<Set<T>> setToken(TypeToken<T> keyToken) {
        return new TypeToken<Set<T>>(){}.where(new TypeParameter<T>(){}, keyToken);
    }

    public static final String getTypeName(Type type, boolean fullClassName) {
        FullName fn = TypeUtils.toFullName(fullClassName);
        return TypeUtils.getTypeName(type, fn);
    }

    public static final String getTypeName(Type type, FullName fn) {
        if (type instanceof Class) {
            return TypeUtils.getTypeName((Class)type, fn);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getTypeName((ParameterizedType)type, fn);
        }
        return TypeUtils.getGenericTypeName(type.toString(), fn);
    }

    public static final String getTypeName(Class<?> type, boolean fullClassName) {
        if (type.isArray()) {
            return TypeUtils.getTypeName(type.getComponentType(), fullClassName) + "[]";
        }
        return fullClassName ? type.getName().replaceAll("\\$", "\\.") : type.getSimpleName();
    }

    public static final String getTypeName(Class<?> type, FullName fn) {
        if (type.isArray()) {
            return TypeUtils.getTypeName(type.getComponentType(), fn) + "[]";
        }
        return fn.isFullName(type) ? type.getName().replaceAll("\\$", "\\.") : type.getSimpleName();
    }

    public static final <T> String getTypeDefine(Type type, T fullNameFlag) {
        FullName fn;
        if (fullNameFlag instanceof FullName) {
            fn = (FullName)fullNameFlag;
        } else if (fullNameFlag instanceof Boolean) {
            fn = TypeUtils.toFullName((Boolean)fullNameFlag);
        } else {
            throw new IllegalArgumentException(String.format("the arugment fullNameFlag must be instance of Boolean or %s", FullName.class.getName()));
        }
        if (type instanceof Class) {
            return TypeUtils.getTypeName((Class)type, fn.isFullName((Class)type));
        }
        if (type instanceof TypeVariable) {
            StringBuilder builder = new StringBuilder();
            builder.append(type.toString());
            Type bound = ((TypeVariable)type).getBounds()[0];
            if (!(bound instanceof Class) || !((Class)bound).getName().equals(Object.class.getName())) {
                builder.append(" extends ").append(TypeUtils.getTypeDefine(bound, fn));
            }
            return builder.toString();
        }
        if (type instanceof ParameterizedType) {
            return fullNameFlag instanceof Boolean && (Boolean)fullNameFlag != false ? type.toString() : TypeUtils.getGenericTypeName(type.toString(), fn);
        }
        return type.toString();
    }

    public static final String genericTypeName(String type) {
        return TypeUtils.getGenericTypeName(type, FULLNAME_INSTANCE_FALSE);
    }

    public static final String getGenericTypeName(String type, FullName fn) {
        Matcher match = Pattern.compile("([\\w\\.\\$]+)([<>\\[\\],])").matcher(type);
        StringBuffer buffer = new StringBuffer();
        while (match.find()) {
            try {
                Class<?> clazz = Class.forName(match.group(1).trim());
                match.appendReplacement(buffer, TypeUtils.getTypeName(clazz, fn) + "$2");
            }
            catch (ClassNotFoundException e) {
                match.appendReplacement(buffer, "$1$2");
            }
        }
        match.appendTail(buffer);
        return buffer.toString();
    }

    public static final String getTypeName(ParameterizedType type, FullName fn) {
        StringBuilder sb = new StringBuilder();
        sb.append(TypeUtils.getTypeName(type.getRawType(), fn));
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            sb.append("<");
            boolean first = true;
            for (Type t : actualTypeArguments) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(TypeUtils.getTypeName(t, fn));
                first = false;
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public static final String[] getAllTypeNamesForGenericType(String type) {
        String[] names = type.replaceAll("([<>\\[\\],?]|\\bextends\\b|\\bsuper\\b)", ",").split(",");
        HashSet<String> set = new HashSet<String>();
        for (String name : names) {
            if ((name = name.trim()).isEmpty()) continue;
            set.add(name);
        }
        return set.toArray(new String[0]);
    }

    public static final Class<?>[] getAllClassForGenericType(String type) {
        HashSet set = new HashSet();
        for (String name : TypeUtils.getAllTypeNamesForGenericType(type)) {
            try {
                set.add(Class.forName(name));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return set.toArray(new Class[0]);
    }

    public static final Class<?> getElementClass(Class<?> clazz) {
        return clazz.isArray() ? TypeUtils.getElementClass(clazz.getComponentType()) : clazz;
    }

    public static final boolean isJavaLangClass(Class<?> clazz) {
        return null == clazz.getPackage() ? false : "java.lang".equals(clazz.getPackage().getName());
    }

    static final FullName toFullName(boolean fullClassName) {
        return fullClassName ? FULLNAME_INSTANCE_TRUE : FULLNAME_INSTANCE_FALSE;
    }

    public static final String getDocSignature(Method method, boolean fn) {
        return TypeUtils.getDocSignature(method, TypeUtils.toFullName(fn));
    }

    public static final String getDocSignature(Method method, final Map<String, Class<?>> importedList) {
        FullName fn = null != importedList ? new FullName(){

            @Override
            public boolean isFullName(Class<?> type) {
                return !importedList.containsValue(type);
            }
        } : FULLNAME_INSTANCE_TRUE;
        return TypeUtils.getDocSignature(method, fn);
    }

    private static String getDocSignature(Method method, FullName fn) {
        StringBuilder builder = new StringBuilder().append(TypeUtils.getTypeName(method.getDeclaringClass(), fn.isFullName(method.getDeclaringClass()))).append("#").append(method.getName()).append("(");
        int c = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (c++ > 0) {
                builder.append(",");
            }
            builder.append(TypeUtils.getTypeName(type, fn.isFullName(type)));
        }
        builder.append(")");
        return builder.toString();
    }

    public static final String getSignature(Method method) {
        return TypeUtils.getDocSignature(method, true).replaceFirst("\\S*#", "");
    }

    public static interface FullName {
        public boolean isFullName(Class<?> var1);
    }

    public static interface Action {
        public void doClass(Class<?> var1);
    }
}

