/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.message.JmsMessageIDBuilder;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderFuture;

public class JmsMessageProducer
implements AutoCloseable,
MessageProducer {
    protected final JmsSession session;
    protected final JmsConnection connection;
    protected JmsProducerInfo producerInfo;
    protected final boolean anonymousProducer;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected boolean disableMessageId;
    protected boolean disableTimestamp;
    protected final AtomicLong messageSequence = new AtomicLong();
    protected final AtomicReference<Exception> failureCause = new AtomicReference();

    protected JmsMessageProducer(JmsProducerId producerId, JmsSession session, JmsDestination destination) throws JMSException {
        this.session = session;
        this.connection = session.getConnection();
        this.anonymousProducer = destination == null;
        JmsMessageIDBuilder messageIDBuilder = session.getMessageIDPolicy().getMessageIDBuilder(session, destination);
        this.producerInfo = new JmsProducerInfo(producerId, messageIDBuilder);
        this.producerInfo.setDestination(destination);
        this.producerInfo.setPresettle(session.getPresettlePolicy().isProducerPresttled(session, destination));
        session.add(this);
        try {
            session.getConnection().createResource(this.producerInfo);
        }
        catch (JMSException jmse) {
            session.remove(this);
            throw jmse;
        }
    }

    @Override
    public void close() throws JMSException {
        if (!this.closed.get()) {
            this.doClose();
        }
    }

    protected void doClose() throws JMSException {
        this.shutdown();
        this.connection.destroyResource(this.producerInfo);
    }

    protected void shutdown() throws JMSException {
        this.shutdown(null);
    }

    protected void shutdown(Exception cause) throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.failureCause.set(cause);
            this.session.remove(this);
        }
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    @Override
    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.producerInfo.getDestination();
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageId;
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableTimestamp;
    }

    @Override
    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.priority;
    }

    @Override
    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    @Override
    public void send(Message message) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created without an explicit Destination");
        }
        this.sendMessage(this.producerInfo.getDestination(), message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (!this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created with an explicit Destination.");
        }
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive);
    }

    private void sendMessage(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        this.session.send(this, destination, message, deliveryMode, priority, timeToLive, this.disableMessageId, this.disableTimestamp);
    }

    @Override
    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        this.deliveryMode = deliveryMode;
    }

    @Override
    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageId = value;
    }

    @Override
    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableTimestamp = value;
    }

    @Override
    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        this.priority = defaultPriority;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.timeToLive = timeToLive;
    }

    protected JmsProducerId getProducerId() {
        return this.producerInfo.getId();
    }

    protected long getNextMessageSequence() {
        return this.messageSequence.incrementAndGet();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            IllegalStateException jmsEx = null;
            if (this.getFailureCause() == null) {
                jmsEx = new IllegalStateException("The MessageProducer is closed");
            } else {
                jmsEx = new IllegalStateException("The MessageProducer was closed due to an unrecoverable error.");
                jmsEx.initCause(this.getFailureCause());
            }
            throw jmsEx;
        }
    }

    protected boolean isPresettled() {
        return this.producerInfo.isPresettle();
    }

    protected boolean isAnonymous() {
        return this.anonymousProducer;
    }

    protected JmsMessageIDBuilder getMessageIDBuilder() {
        return this.producerInfo.getMessageIDBuilder();
    }

    void setFailureCause(Exception failureCause) {
        this.failureCause.set(failureCause);
    }

    Exception getFailureCause() {
        if (this.failureCause.get() == null) {
            return this.session.getFailureCause();
        }
        return this.failureCause.get();
    }

    protected void onConnectionInterrupted() {
    }

    protected void onConnectionRecovery(Provider provider) throws Exception {
        ProviderFuture request = new ProviderFuture();
        provider.create(this.producerInfo, request);
        request.sync();
    }

    protected void onConnectionRecovered(Provider provider) throws Exception {
    }

    protected void onConnectionRestored() {
    }
}

