/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.jndi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class JNDIStorable
implements Externalizable {
    protected abstract Map<String, String> buildFromProperties(Map<String, String> var1);

    protected abstract void populateProperties(Map<String, String> var1);

    public synchronized Map<String, String> setProperties(Map<String, String> props) {
        return this.buildFromProperties(props);
    }

    public synchronized Map<String, String> getProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        this.populateProperties(properties);
        return properties;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Map props = (Map)in.readObject();
        if (props != null) {
            this.setProperties(props);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getProperties());
    }

    protected String getProperty(Map<String, String> map, String key, String defaultValue) {
        String value = map.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

