/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.net.URI;
import java.util.Map;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.util.PropertyUtil;

public class AmqpProviderFactory
extends ProviderFactory {
    public static final String DEFAULT_TRANSPORT_TYPE = "tcp";
    private String transportType = "tcp";

    @Override
    public Provider createProvider(URI remoteURI) throws Exception {
        Map<String, String> map = PropertyUtil.parseQuery(remoteURI.getQuery());
        Map<String, String> providerOptions = PropertyUtil.filterProperties(map, "amqp.");
        remoteURI = PropertyUtil.replaceQuery(remoteURI, map);
        AmqpProvider result = new AmqpProvider(remoteURI);
        result.setTransportType(this.getTransportType());
        Map<String, String> unused = PropertyUtil.setProperties((Object)result, providerOptions);
        if (!unused.isEmpty()) {
            String msg = " Not all provider options could be set on the AMQP Provider. Check the options are spelled correctly. Unused parameters=[" + unused + "]. This provider instance cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    @Override
    public String getName() {
        return "AMQP";
    }

    public String getTransportType() {
        return this.transportType;
    }

    public void setTransportType(String transportType) {
        this.transportType = transportType;
    }
}

