/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.util.Map;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.ResourceAllocationException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.JmsResourceNotFoundException;
import org.apache.qpid.jms.provider.ProviderRedirectedException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.TransactionErrors;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Endpoint;

public class AmqpSupport {
    public static final Symbol SOLE_CONNECTION_CAPABILITY = Symbol.valueOf("sole-connection-for-container");
    public static final Symbol ANONYMOUS_RELAY = Symbol.valueOf("ANONYMOUS-RELAY");
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf("amqp:connection-establishment-failed");
    public static final Symbol INVALID_FIELD = Symbol.valueOf("invalid-field");
    public static final Symbol CONTAINER_ID = Symbol.valueOf("container-id");
    public static final Symbol PATH = Symbol.valueOf("path");
    public static final Symbol SCHEME = Symbol.valueOf("scheme");
    public static final Symbol PORT = Symbol.valueOf("port");
    public static final Symbol NETWORK_HOST = Symbol.valueOf("network-host");
    public static final Symbol OPEN_HOSTNAME = Symbol.valueOf("hostname");
    public static final Symbol QUEUE_PREFIX = Symbol.valueOf("queue-prefix");
    public static final Symbol TOPIC_PREFIX = Symbol.valueOf("topic-prefix");
    public static final Symbol PRODUCT = Symbol.valueOf("product");
    public static final Symbol VERSION = Symbol.valueOf("version");
    public static final Symbol PLATFORM = Symbol.valueOf("platform");
    public static final Symbol COPY = Symbol.getSymbol("copy");
    public static final Symbol JMS_NO_LOCAL_SYMBOL = Symbol.valueOf("no-local");
    public static final Symbol JMS_SELECTOR_SYMBOL = Symbol.valueOf("jms-selector");
    public static final Rejected REJECTED = new Rejected();
    public static final Modified MODIFIED_FAILED = new Modified();
    public static final Modified MODIFIED_FAILED_UNDELIVERABLE = new Modified();
    public static final Symbol DYNAMIC_NODE_LIFETIME_POLICY = Symbol.valueOf("lifetime-policy");
    public static final String TEMP_QUEUE_CREATOR = "temp-queue-creator:";
    public static final String TEMP_TOPIC_CREATOR = "temp-topic-creator:";

    public static Exception convertToException(Endpoint endpoint, ErrorCondition errorCondition) {
        return AmqpSupport.convertToException(endpoint, errorCondition, null);
    }

    public static Exception convertToException(Endpoint endpoint, ErrorCondition errorCondition, Exception defaultException) {
        Exception remoteError = defaultException;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            Map info;
            Symbol error = errorCondition.getCondition();
            String message = AmqpSupport.extractErrorMessage(errorCondition);
            remoteError = error.equals(AmqpError.UNAUTHORIZED_ACCESS) ? new JMSSecurityException(message) : (error.equals(AmqpError.RESOURCE_LIMIT_EXCEEDED) ? new ResourceAllocationException(message) : (error.equals(AmqpError.NOT_FOUND) ? (endpoint instanceof Connection ? new JmsResourceNotFoundException(message) : new InvalidDestinationException(message)) : (error.equals(TransactionErrors.TRANSACTION_ROLLBACK) ? new TransactionRolledBackException(message) : (error.equals(ConnectionError.REDIRECT) ? AmqpSupport.createRedirectException(error, message, errorCondition) : (error.equals(AmqpError.INVALID_FIELD) ? ((info = errorCondition.getInfo()) != null && CONTAINER_ID.equals(info.get(INVALID_FIELD)) ? new InvalidClientIDException(message) : new JMSException(message)) : new JMSException(message))))));
        } else if (remoteError == null) {
            remoteError = new JMSException("Unknown error from remote peer");
        }
        return remoteError;
    }

    public static String extractErrorMessage(ErrorCondition errorCondition) {
        String message = "Received error from remote peer without description";
        if (errorCondition != null) {
            Symbol condition;
            if (errorCondition.getDescription() != null && !errorCondition.getDescription().isEmpty()) {
                message = errorCondition.getDescription();
            }
            if ((condition = errorCondition.getCondition()) != null) {
                message = message + " [condition = " + condition + "]";
            }
        }
        return message;
    }

    public static Exception createRedirectException(Symbol error, String message, ErrorCondition condition) {
        IOException result = null;
        Map info = condition.getInfo();
        if (info == null) {
            result = new IOException(message + " : Redirection information not set.");
        } else {
            String hostname = (String)info.get(OPEN_HOSTNAME);
            String path = (String)info.get(PATH);
            String scheme = (String)info.get(SCHEME);
            String networkHost = (String)info.get(NETWORK_HOST);
            if (networkHost == null || networkHost.isEmpty()) {
                result = new IOException(message + " : Redirection information not set.");
            }
            int port = 0;
            try {
                port = Integer.parseInt(info.get(PORT).toString());
            }
            catch (Exception ex) {
                result = new IOException(message + " : Redirection information not set.");
            }
            result = new ProviderRedirectedException(message, scheme, hostname, networkHost, port, path);
        }
        return result;
    }

    static {
        MODIFIED_FAILED.setDeliveryFailed(true);
        MODIFIED_FAILED_UNDELIVERABLE.setDeliveryFailed(true);
        MODIFIED_FAILED_UNDELIVERABLE.setUndeliverableHere(true);
    }
}

