/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.qpid.jms.message.facade.JmsBytesMessageFacade;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpJmsBytesMessageFacade
extends AmqpJmsMessageFacade
implements JmsBytesMessageFacade {
    private static final Binary EMPTY_BINARY = new Binary(new byte[0]);
    private static final Data EMPTY_BODY = new Data(EMPTY_BINARY);
    private transient ByteBufInputStream bytesIn;
    private transient ByteBufOutputStream bytesOut;

    public AmqpJmsBytesMessageFacade(AmqpConnection connection) {
        super(connection);
        this.setContentType("application/octet-stream");
        this.setMessageAnnotation("x-opt-jms-msg-type", (byte)3);
        this.getAmqpMessage().setBody(EMPTY_BODY);
    }

    public AmqpJmsBytesMessageFacade(AmqpConsumer consumer, Message message) {
        super(consumer, message);
    }

    @Override
    public AmqpJmsBytesMessageFacade copy() {
        this.reset();
        AmqpJmsBytesMessageFacade copy = new AmqpJmsBytesMessageFacade(this.connection);
        this.copyInto(copy);
        Binary payload = this.getBinaryFromBody();
        if (payload.getLength() > 0) {
            byte[] result = new byte[payload.getLength()];
            System.arraycopy(payload.getArray(), payload.getArrayOffset(), result, 0, payload.getLength());
            copy.message.setBody(new Data(new Binary(result)));
        } else {
            copy.message.setBody(EMPTY_BODY);
        }
        return copy;
    }

    @Override
    public byte getJmsMsgType() {
        return 3;
    }

    @Override
    public void clearBody() {
        if (this.bytesIn != null) {
            try {
                this.bytesIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bytesIn = null;
        }
        if (this.bytesOut != null) {
            try {
                this.bytesOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bytesOut = null;
        }
        this.message.setBody(EMPTY_BODY);
    }

    @Override
    public InputStream getInputStream() throws JMSException {
        if (this.bytesOut != null) {
            throw new IllegalStateException("Body is being written to, cannot perform a read.");
        }
        if (this.bytesIn == null) {
            Binary body = this.getBinaryFromBody();
            this.bytesIn = new ByteBufInputStream(Unpooled.wrappedBuffer(body.getArray(), body.getArrayOffset(), body.getLength()));
        }
        return this.bytesIn;
    }

    @Override
    public OutputStream getOutputStream() throws JMSException {
        if (this.bytesIn != null) {
            throw new IllegalStateException("Body is being read from, cannot perform a write.");
        }
        if (this.bytesOut == null) {
            this.bytesOut = new ByteBufOutputStream(Unpooled.buffer());
            this.message.setBody(EMPTY_BODY);
        }
        return this.bytesOut;
    }

    @Override
    public void reset() {
        if (this.bytesOut != null) {
            ByteBuf writeBuf = this.bytesOut.buffer();
            Binary body = new Binary(writeBuf.array(), writeBuf.arrayOffset(), writeBuf.readableBytes());
            this.message.setBody(new Data(body));
            try {
                this.bytesOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bytesOut = null;
        } else if (this.bytesIn != null) {
            try {
                this.bytesIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bytesIn = null;
        }
    }

    @Override
    public int getBodyLength() {
        return this.getBinaryFromBody().getLength();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Binary getBinaryFromBody() {
        Section body = this.getAmqpMessage().getBody();
        Binary result = EMPTY_BINARY;
        if (body == null) {
            return result;
        }
        if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            if (payload == null) return result;
            if (payload.getLength() == 0) return result;
            return payload;
        }
        if (!(body instanceof AmqpValue)) throw new java.lang.IllegalStateException("Unexpected body content type: " + body.getClass().getSimpleName());
        Object value = ((AmqpValue)body).getValue();
        if (value == null) {
            return result;
        }
        if (!(value instanceof Binary)) throw new java.lang.IllegalStateException("Unexpected amqp-value body content type: " + value.getClass().getSimpleName());
        Binary payload = (Binary)value;
        if (payload.getLength() == 0) return result;
        return payload;
    }

    @Override
    public void onSend(long producerTtl) throws JMSException {
        super.onSend(producerTtl);
        this.reset();
    }
}

