/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jms.MessageEOFException;
import org.apache.qpid.jms.message.facade.JmsStreamMessageFacade;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpJmsStreamMessageFacade
extends AmqpJmsMessageFacade
implements JmsStreamMessageFacade {
    private List<Object> list;
    private int position = 0;

    public AmqpJmsStreamMessageFacade(AmqpConnection connection) {
        super(connection);
        this.list = this.initializeEmptyBodyList(true);
        this.setMessageAnnotation("x-opt-jms-msg-type", (byte)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AmqpJmsStreamMessageFacade(AmqpConsumer consumer, Message message) {
        super(consumer, message);
        Section body = this.getAmqpMessage().getBody();
        if (body == null) {
            this.list = this.initializeEmptyBodyList(true);
            return;
        } else if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null) {
                this.list = this.initializeEmptyBodyList(false);
                return;
            } else {
                if (!(value instanceof List)) throw new IllegalStateException("Unexpected amqp-value body content type: " + value.getClass().getSimpleName());
                this.list = (List)value;
            }
            return;
        } else {
            if (!(body instanceof AmqpSequence)) throw new IllegalStateException("Unexpected message body type: " + body.getClass().getSimpleName());
            List value = ((AmqpSequence)body).getValue();
            this.list = value == null ? this.initializeEmptyBodyList(true) : value;
        }
    }

    @Override
    public AmqpJmsStreamMessageFacade copy() {
        AmqpJmsStreamMessageFacade copy = new AmqpJmsStreamMessageFacade(this.connection);
        this.copyInto(copy);
        copy.list.addAll(this.list);
        return copy;
    }

    @Override
    public byte getJmsMsgType() {
        return 4;
    }

    @Override
    public boolean hasNext() {
        return !this.list.isEmpty() && this.position < this.list.size();
    }

    @Override
    public Object peek() throws MessageEOFException {
        if (this.list.isEmpty() || this.position >= this.list.size()) {
            throw new MessageEOFException("Attempt to read past end of stream");
        }
        Object object = this.list.get(this.position);
        if (object instanceof Binary) {
            Binary bin = (Binary)object;
            object = Arrays.copyOfRange(bin.getArray(), bin.getArrayOffset(), bin.getLength());
        }
        return object;
    }

    @Override
    public void pop() throws MessageEOFException {
        if (this.list.isEmpty() || this.position >= this.list.size()) {
            throw new MessageEOFException("Attempt to read past end of stream");
        }
        ++this.position;
    }

    @Override
    public void put(Object value) {
        Object entry = value;
        if (entry instanceof byte[]) {
            entry = new Binary((byte[])value);
        }
        this.list.add(entry);
    }

    @Override
    public void reset() {
        this.position = 0;
    }

    @Override
    public void clearBody() {
        this.list.clear();
        this.position = 0;
    }

    private List<Object> initializeEmptyBodyList(boolean useSequenceBody) {
        ArrayList<Object> emptyList = new ArrayList<Object>();
        if (useSequenceBody) {
            this.message.setBody(new AmqpSequence(emptyList));
        } else {
            this.message.setBody(new AmqpValue(emptyList));
        }
        return emptyList;
    }
}

