/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageSupport;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpTypedObjectDelegate
implements AmqpObjectTypeDelegate {
    static final AmqpValue NULL_OBJECT_BODY = new AmqpValue(null);
    private final Message message;
    private final AtomicReference<Section> cachedReceivedBody = new AtomicReference();
    private ByteBuf messageBytes;

    public AmqpTypedObjectDelegate(AmqpJmsMessageFacade parent, ByteBuf messageBytes) {
        this.message = parent.getAmqpMessage();
        this.message.setContentType(null);
        this.messageBytes = messageBytes;
        if (messageBytes != null) {
            this.cachedReceivedBody.set(this.message.getBody());
        }
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        Section body = this.cachedReceivedBody.getAndSet(null);
        if (body == null) {
            body = this.messageBytes != null ? AmqpMessageSupport.decodeMessage(this.messageBytes).getBody() : this.message.getBody();
        }
        if (body == null) {
            return null;
        }
        if (body instanceof AmqpValue) {
            return (Serializable)((AmqpValue)body).getValue();
        }
        if (body instanceof Data) {
            throw new UnsupportedOperationException("Data support still to be added");
        }
        if (body instanceof AmqpSequence) {
            return (Serializable)((Object)((AmqpSequence)body).getValue());
        }
        throw new IllegalStateException("Unexpected body type: " + body.getClass().getSimpleName());
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        this.cachedReceivedBody.set(null);
        if (value == null) {
            this.message.setBody(NULL_OBJECT_BODY);
            this.messageBytes = null;
        } else if (this.isSupportedAmqpValueObjectType(value)) {
            Message transfer = Message.Factory.create();
            transfer.setBody(new AmqpValue(value));
            this.messageBytes = AmqpMessageSupport.encodeMessage(transfer);
            transfer = AmqpMessageSupport.decodeMessage(this.messageBytes);
            this.message.setBody(transfer.getBody());
        } else {
            throw new IllegalArgumentException("Encoding this object type with the AMQP type system is not supported: " + value.getClass().getName());
        }
    }

    @Override
    public void onSend() {
        this.message.setContentType(null);
        if (this.message.getBody() == null) {
            this.message.setBody(NULL_OBJECT_BODY);
        }
    }

    @Override
    public void copyInto(AmqpObjectTypeDelegate copy) throws Exception {
        if (!(copy instanceof AmqpTypedObjectDelegate)) {
            copy.setObject(this.getObject());
        } else {
            AmqpTypedObjectDelegate target = (AmqpTypedObjectDelegate)copy;
            target.cachedReceivedBody.set(this.cachedReceivedBody.getAndSet(null));
            if (this.messageBytes != null) {
                target.messageBytes = this.messageBytes.copy();
                target.message.setBody(this.message.getBody());
            } else {
                copy.setObject(this.getObject());
            }
        }
    }

    @Override
    public boolean isAmqpTypeEncoded() {
        return true;
    }

    private boolean isSupportedAmqpValueObjectType(Serializable serializable) {
        return serializable instanceof String || serializable instanceof Map || serializable instanceof List || serializable.getClass().isArray();
    }
}

