/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.qpid.jms.transports.Transport;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.util.FactoryFinder;
import org.apache.qpid.jms.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TransportFactory.class);
    private static final FactoryFinder<TransportFactory> TRANSPORT_FACTORY_FINDER = new FactoryFinder<TransportFactory>(TransportFactory.class, "META-INF/services/" + TransportFactory.class.getPackage().getName().replace(".", "/") + "/");

    public Transport createTransport(URI remoteURI) throws Exception {
        Map<String, String> map = PropertyUtil.parseQuery(remoteURI.getQuery());
        Map<String, String> transportURIOptions = PropertyUtil.filterProperties(map, "transport.");
        remoteURI = PropertyUtil.replaceQuery(remoteURI, map);
        TransportOptions transportOptions = this.doCreateTransportOptions();
        Map<String, String> unused = PropertyUtil.setProperties((Object)transportOptions, transportURIOptions);
        if (!unused.isEmpty()) {
            String msg = " Not all transport options could be set on the " + this.getName() + " Transport. Check the options are spelled correctly. Unused parameters=[" + unused + "]. This provider instance cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        Transport result = this.doCreateTransport(remoteURI, transportOptions);
        return result;
    }

    protected TransportOptions doCreateTransportOptions() {
        return new TransportOptions();
    }

    protected abstract Transport doCreateTransport(URI var1, TransportOptions var2) throws Exception;

    public abstract String getName();

    public static Transport create(String transportKey, URI remoteURI) throws Exception {
        Transport result = null;
        try {
            TransportFactory factory = TransportFactory.findTransportFactory(transportKey);
            result = factory.createTransport(remoteURI);
        }
        catch (Exception ex) {
            LOG.error("Failed to create Transport instance for {}, due to: {}", (Object)remoteURI.getScheme(), (Object)ex);
            LOG.trace("Error: ", ex);
            throw ex;
        }
        return result;
    }

    public static TransportFactory findTransportFactory(String transportKey) throws IOException {
        if (transportKey == null) {
            throw new IOException("No Transport key specified");
        }
        TransportFactory factory = null;
        try {
            factory = TRANSPORT_FACTORY_FINDER.newInstance(transportKey);
        }
        catch (Throwable e) {
            throw new IOException("Transport type NOT recognized: [" + transportKey + "]", e);
        }
        return factory;
    }
}

