/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.qpid.jms.util.StringArrayConverter;
import org.apache.qpid.jms.util.TypeConversionSupport;

public class PropertyUtil {
    public static URI replaceQuery(URI originalURI, Map<String, String> params) throws URISyntaxException {
        String s = PropertyUtil.createQueryString(params);
        if (s.length() == 0) {
            s = null;
        }
        return PropertyUtil.replaceQuery(originalURI, s);
    }

    public static URI replaceQuery(URI uri, String query) throws URISyntaxException {
        String schemeSpecificPart = uri.getRawSchemeSpecificPart();
        int questionMark = schemeSpecificPart.lastIndexOf("?");
        if (questionMark < schemeSpecificPart.lastIndexOf(")")) {
            questionMark = -1;
        }
        if (questionMark > 0) {
            schemeSpecificPart = schemeSpecificPart.substring(0, questionMark);
        }
        if (query != null && query.length() > 0) {
            schemeSpecificPart = schemeSpecificPart + "?" + query;
        }
        return new URI(uri.getScheme(), schemeSpecificPart, uri.getFragment());
    }

    public static URI eraseQuery(URI uri) throws URISyntaxException {
        return PropertyUtil.replaceQuery(uri, (String)null);
    }

    public static String createQueryString(Map<String, ? extends Object> options) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuffer rc = new StringBuffer();
                boolean first = true;
                for (Map.Entry<String, ? extends Object> entry : options.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append("&");
                    }
                    rc.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                    rc.append("=");
                    rc.append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            throw (URISyntaxException)new URISyntaxException(e.toString(), "Invalid encoding").initCause(e);
        }
    }

    public static Map<String, String> parseParameters(URI uri) throws Exception {
        if (uri == null || uri.getQuery() == null) {
            return Collections.emptyMap();
        }
        return PropertyUtil.parseQuery(PropertyUtil.stripPrefix(uri.getQuery(), "?"));
    }

    public static Map<String, String> parseParameters(String uri) throws Exception {
        if (uri == null) {
            return Collections.emptyMap();
        }
        return PropertyUtil.parseQuery(PropertyUtil.stripUpto(uri, '?'));
    }

    public static Map<String, String> parseQuery(String queryString) throws Exception {
        if (queryString != null && !queryString.isEmpty()) {
            HashMap<String, String> rc = new HashMap<String, String>();
            String[] parameters = queryString.split("&");
            for (int i = 0; i < parameters.length; ++i) {
                int p = parameters[i].indexOf("=");
                if (p >= 0) {
                    String name = URLDecoder.decode(parameters[i].substring(0, p), "UTF-8");
                    String value = URLDecoder.decode(parameters[i].substring(p + 1), "UTF-8");
                    rc.put(name, value);
                    continue;
                }
                rc.put(parameters[i], null);
            }
            return rc;
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> filterProperties(Map<String, String> properties, String optionPrefix) {
        if (properties == null) {
            throw new IllegalArgumentException("The given properties object was null.");
        }
        HashMap<String, String> rc = new HashMap<String, String>(properties.size());
        Iterator<Map.Entry<String, String>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().startsWith(optionPrefix)) continue;
            String name = entry.getKey().substring(optionPrefix.length());
            rc.put(name, entry.getValue());
            iter.remove();
        }
        return rc;
    }

    public static String addPropertiesToURIFromBean(String uri, Object bean) throws Exception {
        Map<String, String> properties = PropertyUtil.getProperties(bean);
        return PropertyUtil.addPropertiesToURI(uri, properties);
    }

    public static String addPropertiesToURI(URI uri, Map<String, String> properties) throws Exception {
        return PropertyUtil.addPropertiesToURI(uri.toString(), properties);
    }

    public static String addPropertiesToURI(String uri, Map<String, String> properties) throws Exception {
        String result = uri;
        if (uri != null && properties != null) {
            StringBuilder base = new StringBuilder(PropertyUtil.stripBefore(uri, '?'));
            Map<String, String> map = PropertyUtil.parseParameters(uri);
            if (!map.isEmpty()) {
                map.putAll(properties);
            } else {
                map = properties;
            }
            if (!map.isEmpty()) {
                base.append('?');
                boolean first = true;
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!first) {
                        base.append('&');
                    }
                    first = false;
                    base.append(entry.getKey()).append("=").append(entry.getValue());
                }
                result = base.toString();
            }
        }
        return result;
    }

    public static Map<String, String> setProperties(Object target, Map<String, String> properties) {
        if (target == null) {
            throw new IllegalArgumentException("target object cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Given Properties object cannot be null");
        }
        HashMap<String, String> unmatched = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (PropertyUtil.setProperty(target, entry.getKey(), entry.getValue())) continue;
            unmatched.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(unmatched);
    }

    public static Map<String, Object> setProperties(Object target, Properties properties) {
        if (target == null) {
            throw new IllegalArgumentException("target object cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Given Properties object cannot be null");
        }
        HashMap<String, Object> unmatched = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (PropertyUtil.setProperty(target, (String)entry.getKey(), entry.getValue())) continue;
            unmatched.put((String)entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(unmatched);
    }

    public static Map<String, String> getProperties(Object object) throws Exception {
        Method[] methods;
        if (object == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Method method : methods = object.getClass().getMethods()) {
            Object value;
            String name = method.getName();
            Class<?> type = method.getReturnType();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("is") && !name.startsWith("get") || params.length != 0 || type == null || (name = name.startsWith("get") ? name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4) : name.substring(2, 3).toLowerCase(Locale.ENGLISH) + name.substring(3)).equals("class") || name.equals("properties") || name.equals("reference") || (value = method.invoke(object, new Object[0])) == null) continue;
            if (value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof URI || value instanceof URL) {
                properties.put(name, "" + value);
                continue;
            }
            if (value instanceof SSLContext) continue;
            Map<String, String> inner = PropertyUtil.getProperties(value);
            for (Map.Entry<String, String> entry : inner.entrySet()) {
                properties.put(name + "." + entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    public static Object getProperty(Object object, String name) throws Exception {
        Method[] methods;
        for (Method method : methods = object.getClass().getMethods()) {
            String methodName = method.getName();
            Class<?> type = method.getReturnType();
            Class<?>[] params = method.getParameterTypes();
            if (!methodName.startsWith("is") && !methodName.startsWith("get") || params.length != 0 || type == null || !(methodName = methodName.startsWith("get") ? methodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + methodName.substring(4) : methodName.substring(2, 3).toLowerCase(Locale.ENGLISH) + methodName.substring(3)).equals(name)) continue;
            return method.invoke(object, new Object[0]);
        }
        return null;
    }

    public static boolean setProperty(Object target, String name, Object value) {
        try {
            int dotPos = name.indexOf(".");
            while (dotPos >= 0) {
                String getterName = name.substring(0, dotPos);
                target = PropertyUtil.getProperty(target, getterName);
                name = name.substring(dotPos + 1);
                dotPos = name.indexOf(".");
            }
            Class<?> clazz = target.getClass();
            Method setter = PropertyUtil.findSetterMethod(clazz, name);
            if (setter == null) {
                return false;
            }
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, PropertyUtil.convert(value, setter.getParameterTypes()[0]));
            }
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static String stripPrefix(String value, String prefix) {
        if (value != null && prefix != null && value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static String stripUpto(String value, char c) {
        int index;
        String result = null;
        if (value != null && (index = value.indexOf(c)) > 0) {
            result = value.substring(index + 1);
        }
        return result;
    }

    public static String stripBefore(String value, char c) {
        int index;
        String result = value;
        if (value != null && (index = value.indexOf(c)) > 0) {
            result = value.substring(0, index);
        }
        return result;
    }

    private static Method findSetterMethod(Class<? extends Object> clazz, String name) {
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1) continue;
            return method;
        }
        return null;
    }

    private static Object convert(Object value, Class<?> type) throws Exception {
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        if (type.isAssignableFrom(String[].class)) {
            return StringArrayConverter.convertToStringArray(value);
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return TypeConversionSupport.convert(value, type);
    }
}

