/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.redis;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.net.HostAndPort;
import gu.dtalk.redis.DefaultCloudRedisConfigProvider;
import gu.dtalk.redis.DefaultCustomRedisConfigProvider;
import gu.dtalk.redis.DefaultLocalRedisConfigProvider;
import gu.dtalk.redis.DefaultLocalhostRedisConfigProvider;
import gu.dtalk.redis.RedisConfigProvider;
import gu.simplemq.IMQConnParameterSupplier;
import gu.simplemq.MessageQueueType;
import gu.simplemq.exceptions.SmqNotFoundConnectionException;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.JedisUtils;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public enum RedisConfigType implements IMQConnParameterSupplier
{
    CUSTOM(new DefaultCustomRedisConfigProvider()),
    LAN(new DefaultLocalRedisConfigProvider()),
    CLOUD(new DefaultCloudRedisConfigProvider()),
    LOCALHOST(new DefaultLocalhostRedisConfigProvider());

    private final RedisConfigProvider defImpl;
    private volatile RedisConfigProvider instance;
    private volatile Map<JedisPoolLazy.PropName, Object> parameters;
    private volatile boolean connectable = false;
    private static volatile RedisConfigType activeConfigType;

    private RedisConfigType() {
        this(null);
    }

    private RedisConfigType(RedisConfigProvider defImpl) {
        this.defImpl = defImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RedisConfigProvider findConfigProvider() {
        if (this.instance == null) {
            RedisConfigType redisConfigType = this;
            synchronized (redisConfigType) {
                if (this.instance == null) {
                    ServiceLoader<RedisConfigProvider> providers = ServiceLoader.load(RedisConfigProvider.class);
                    Iterator<RedisConfigProvider> itor = providers.iterator();
                    Optional find = Iterators.tryFind(itor, (Predicate)new Predicate<RedisConfigProvider>(){

                        public boolean apply(RedisConfigProvider input) {
                            return input.type() == RedisConfigType.this;
                        }
                    });
                    RedisConfigProvider redisConfigProvider = this.instance = find.isPresent() ? (RedisConfigProvider)find.get() : this.defImpl;
                    if (null != this.instance && this.instance.getHost() == null && this.instance.getURI() == null) {
                        this.instance = null;
                    }
                }
            }
        }
        return this.instance;
    }

    public HostAndPort getHostAndPort() {
        return JedisUtils.getHostAndPort(this.parameters);
    }

    private static Map<JedisPoolLazy.PropName, Object> asRedisParameters(RedisConfigProvider config) {
        if (config == null) {
            return null;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        URI uri = config.getURI();
        if (uri != null) {
            builder.put((Object)JedisPoolLazy.PropName.uri, (Object)uri);
        } else {
            String host = config.getHost();
            int port = config.getPort();
            String password = config.getPassword();
            int database = config.getDatabase();
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host) ? 1 : 0) != 0, (Object)"INVALID REDIS HOST");
            builder.put((Object)JedisPoolLazy.PropName.host, (Object)host);
            if (port > 0) {
                builder.put((Object)JedisPoolLazy.PropName.port, (Object)port);
            }
            if (!Strings.isNullOrEmpty((String)password)) {
                builder.put((Object)JedisPoolLazy.PropName.password, (Object)password);
            }
            if (database > 0) {
                builder.put((Object)JedisPoolLazy.PropName.database, (Object)database);
            }
        }
        int timeout = config.getTimeout();
        if (timeout > 0) {
            builder.put((Object)JedisPoolLazy.PropName.timeout, (Object)timeout);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<JedisPoolLazy.PropName, Object> readRedisParam() {
        if (this.parameters == null) {
            RedisConfigType redisConfigType = this;
            synchronized (redisConfigType) {
                if (this.parameters == null) {
                    RedisConfigProvider config = this.findConfigProvider();
                    this.parameters = RedisConfigType.asRedisParameters(config);
                }
            }
        }
        return this.parameters;
    }

    public Map<String, Object> getMQConnParameters() {
        return JedisUtils.asMqParameters(this.readRedisParam());
    }

    public final MessageQueueType getImplType() {
        return MessageQueueType.REDIS;
    }

    public synchronized void saveRedisParam(Map<JedisPoolLazy.PropName, Object> param) {
        Object uri;
        Object timeout;
        Object database;
        Object password;
        Object port;
        RedisConfigProvider config = this.findConfigProvider();
        Object host = param.get(JedisPoolLazy.PropName.host);
        if (host instanceof String) {
            config.setHost((String)host);
        }
        if ((port = param.get(JedisPoolLazy.PropName.port)) instanceof Number) {
            config.setPort(((Number)port).intValue());
        }
        if ((password = param.get(JedisPoolLazy.PropName.password)) instanceof String) {
            config.setPassword((String)password);
        }
        if ((database = param.get(JedisPoolLazy.PropName.database)) instanceof Number) {
            config.setDatabase(((Number)database).intValue());
        }
        if ((timeout = param.get(JedisPoolLazy.PropName.timeout)) instanceof Number) {
            config.setTimeout(((Number)timeout).intValue());
        }
        if ((uri = param.get(JedisPoolLazy.PropName.uri)) instanceof URI) {
            config.setURI((URI)uri);
        }
    }

    public static void resetActiveConfigType() {
        activeConfigType = null;
    }

    public synchronized boolean testConnect(Integer timeoutMills) {
        ImmutableMap props = this.readRedisParam();
        this.connectable = false;
        if (props != null && !props.isEmpty()) {
            try {
                if (timeoutMills != null && timeoutMills > 0) {
                    props = ImmutableMap.builder().putAll(props).put((Object)JedisPoolLazy.PropName.timeout, (Object)timeoutMills).build();
                }
                this.connectable = JedisUtils.testConnect(props);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.connectable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisConfigType lookupConnect(final Integer timeoutMills) throws SmqNotFoundConnectionException {
        if (activeConfigType != null) return activeConfigType;
        Class<RedisConfigType> clazz = RedisConfigType.class;
        synchronized (RedisConfigType.class) {
            if (activeConfigType != null) return activeConfigType;
            Thread[] threads = new Thread[RedisConfigType.values().length];
            int index = 0;
            for (final RedisConfigType type : RedisConfigType.values()) {
                threads[index] = new Thread(){

                    @Override
                    public void run() {
                        type.testConnect(timeoutMills);
                    }
                };
                threads[index].start();
                ++index;
            }
            try {
                for (int i = 0; i < threads.length; ++i) {
                    threads[i].join();
                    RedisConfigType type = RedisConfigType.values()[i];
                    if (!type.connectable) continue;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return type;
                }
                throw new SmqNotFoundConnectionException("NOT FOUND VALID REDIS SERVER");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new SmqNotFoundConnectionException("NOT FOUND VALID REDIS SERVER");
        }
    }

    public static RedisConfigType lookupConnectUnchecked(Integer timeoutMills) {
        try {
            return RedisConfigType.lookupConnect(timeoutMills);
        }
        catch (SmqNotFoundConnectionException e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((Object)((Object)this)).getClass().getSimpleName()).append(":");
        buffer.append(this.name());
        Map<JedisPoolLazy.PropName, Object> param = this.readRedisParam();
        if (param == null) {
            buffer.append("(UNDEFINED)");
        } else {
            buffer.append("(").append(JedisUtils.getCanonicalURI(param).toString()).append(")");
        }
        return buffer.toString();
    }

    static {
        activeConfigType = null;
    }
}

