/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.sdk.fse.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.gdface.sdk.fse.CodeBean;
import net.gdface.sdk.fse.FeatureSe;
import net.gdface.sdk.fse.thrift.ServiceRuntimeException;
import net.gdface.sdk.fse.thrift.client.FeatureSeClient;
import net.gdface.thrift.ClientFactory;
import net.gdface.thrift.ThriftUtils;
import net.gdface.thrift.TypeTransformer;
import okio.ByteString;

public class FeatureSeThriftClient
implements FeatureSe {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return this.factory;
    }

    public FeatureSeThriftClient(ClientFactory factory) {
        this.factory = (ClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    public FeatureSeThriftClient(String host, int port) {
        this(ClientFactory.builder().setHostAndPort(host, port));
    }

    public boolean testConnect() {
        return this.factory.testConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, L> R syncCall(final Function<L, R> transformer, ServiceAsyncCall<L> serviceCall) throws Throwable {
        final AtomicReference<Object> res = new AtomicReference<Object>(null);
        final AtomicReference<Object> err = new AtomicReference<Object>(null);
        final Object lock = new Object();
        final ServiceMethodCallback callback = new ServiceMethodCallback<L>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(L result) {
                res.set(transformer.apply(result));
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable error) {
                err.set(error);
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        };
        AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){

            public void onTransportClosed() {
            }

            public void onError(Throwable error) {
                callback.onError(error);
            }
        };
        FeatureSeClient service = (FeatureSeClient)this.factory.applyInstance(FeatureSeClient.class, closeListener);
        Object object = lock;
        synchronized (object) {
            try {
                serviceCall.call(service, callback);
                lock.wait();
            }
            catch (InterruptedException e) {
                err.set(e);
            }
            finally {
                try {
                    service.close();
                }
                catch (IOException e) {}
            }
        }
        Throwable e = err.get();
        if (null != e) {
            ThriftUtils.returnNull((Throwable)e);
        }
        return res.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FeatureSeThriftClient [factory=");
        builder.append(this.factory);
        builder.append(",interface=");
        builder.append(FeatureSe.class.getName());
        builder.append("]");
        return builder.toString();
    }

    public boolean addFeature(final byte[] featureId, final byte[] feature, final String imgMD5) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.addFeatureToFse((ByteString)TypeTransformer.getInstance().to((Object)featureId, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), imgMD5, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean addFeature(final byte[] featureId, final byte[] feature, final long appid) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.addFeatureToFseWithAppId((ByteString)TypeTransformer.getInstance().to((Object)featureId, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), appid, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void clearAll() {
        try {
            this.syncCall(new Function<Void, Void>(){

                public Void apply(Void input) {
                    return input;
                }
            }, new ServiceAsyncCall<Void>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<Void> nativeCallback) {
                    service.clearAllOfFse(nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeBean getFeature(final byte[] featureId) {
        try {
            return this.syncCall(new Function<net.gdface.sdk.fse.thrift.client.CodeBean, CodeBean>(){

                public CodeBean apply(net.gdface.sdk.fse.thrift.client.CodeBean input) {
                    return (CodeBean)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.fse.thrift.client.CodeBean.class, CodeBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.sdk.fse.thrift.client.CodeBean>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<net.gdface.sdk.fse.thrift.client.CodeBean> nativeCallback) {
                    service.getFeatureFromFse((ByteString)TypeTransformer.getInstance().to((Object)featureId, byte[].class, ByteString.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeBean getFeatureByHex(final String featureId) {
        try {
            return this.syncCall(new Function<net.gdface.sdk.fse.thrift.client.CodeBean, CodeBean>(){

                public CodeBean apply(net.gdface.sdk.fse.thrift.client.CodeBean input) {
                    return (CodeBean)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.fse.thrift.client.CodeBean.class, CodeBean.class);
                }
            }, new ServiceAsyncCall<net.gdface.sdk.fse.thrift.client.CodeBean>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<net.gdface.sdk.fse.thrift.client.CodeBean> nativeCallback) {
                    service.getFeatureByHexFromFse(featureId, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean removeFeature(final byte[] featureId) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.removeFeatureFromFse((ByteString)TypeTransformer.getInstance().to((Object)featureId, byte[].class, ByteString.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean removeFeatureByHex(final String featureId) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.removeFeatureByHexFromFse(featureId, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeBean[] searchCode(final byte[] code, final double sim, final int rows) {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.fse.thrift.client.CodeBean>, CodeBean[]>(){

                public CodeBean[] apply(List<net.gdface.sdk.fse.thrift.client.CodeBean> input) {
                    return (CodeBean[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.fse.thrift.client.CodeBean.class, CodeBean.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.fse.thrift.client.CodeBean>>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<List<net.gdface.sdk.fse.thrift.client.CodeBean>> nativeCallback) {
                    service.searchCodeFromFse((ByteString)TypeTransformer.getInstance().to((Object)code, byte[].class, ByteString.class), sim, rows, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int size() {
        try {
            return this.syncCall(new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return input;
                }
            }, new ServiceAsyncCall<Integer>(){

                @Override
                public void call(FeatureSeClient service, ServiceMethodCallback<Integer> nativeCallback) {
                    service.sizeOfFse(nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.fse.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static interface ServiceAsyncCall<T> {
        public void call(FeatureSeClient var1, ServiceMethodCallback<T> var2);
    }
}

