/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.sdk.fse.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import java.io.IOException;
import java.util.List;
import net.gdface.sdk.fse.CodeBean;
import net.gdface.sdk.fse.FeatureSe;
import net.gdface.sdk.fse.thrift.client.FeatureSeClient;
import net.gdface.sdk.fse.thrift.client.ServiceRuntimeException;
import net.gdface.thrift.ClientFactory;
import net.gdface.thrift.TypeTransformer;
import okio.ByteString;

public class FeatureSeThriftClientAsync {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return this.factory;
    }

    public FeatureSeThriftClientAsync(ClientFactory factory) {
        this.factory = (ClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    public FeatureSeThriftClientAsync(String host, int port) {
        this(ClientFactory.builder().setHostAndPort(host, port));
    }

    public boolean testConnect() {
        return this.factory.testConnect();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FeatureSeThriftClientAsync [factory=");
        builder.append(this.factory);
        builder.append(",interface=");
        builder.append(FeatureSe.class.getName());
        builder.append("]");
        return builder.toString();
    }

    public ListenableFuture<Boolean> addFeature(byte[] featureId, byte[] feature, String imgMD5) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.addFeatureToFse((ByteString)TypeTransformer.getInstance().to((Object)featureId, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), imgMD5, nativeCallback);
        return nativeCallback.feature;
    }

    public void addFeature(byte[] featureId, byte[] feature, String imgMD5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.addFeature(featureId, feature, imgMD5), callback);
    }

    public ListenableFuture<Boolean> addFeature(byte[] featureId, byte[] feature, long appid) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.addFeatureToFseWithAppId((ByteString)TypeTransformer.getInstance().to((Object)featureId, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), appid, nativeCallback);
        return nativeCallback.feature;
    }

    public void addFeature(byte[] featureId, byte[] feature, long appid, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.addFeature(featureId, feature, appid), callback);
    }

    public ListenableFuture<Void> clearAll() {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.clearAllOfFse(nativeCallback);
        return nativeCallback.feature;
    }

    public void clearAll(FutureCallback<Void> callback) {
        this.factory.addCallback(this.clearAll(), callback);
    }

    public ListenableFuture<CodeBean> getFeature(byte[] featureId) {
        MethodCallback<CodeBean, net.gdface.sdk.fse.thrift.client.CodeBean> nativeCallback = new MethodCallback<CodeBean, net.gdface.sdk.fse.thrift.client.CodeBean>(new Function<net.gdface.sdk.fse.thrift.client.CodeBean, CodeBean>(){

            public CodeBean apply(net.gdface.sdk.fse.thrift.client.CodeBean input) {
                return (CodeBean)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.fse.thrift.client.CodeBean.class, CodeBean.class);
            }
        });
        nativeCallback.service.getFeatureFromFse((ByteString)TypeTransformer.getInstance().to((Object)featureId, byte[].class, ByteString.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeature(byte[] featureId, FutureCallback<CodeBean> callback) {
        this.factory.addCallback(this.getFeature(featureId), callback);
    }

    public ListenableFuture<CodeBean> getFeatureByHex(String featureId) {
        MethodCallback<CodeBean, net.gdface.sdk.fse.thrift.client.CodeBean> nativeCallback = new MethodCallback<CodeBean, net.gdface.sdk.fse.thrift.client.CodeBean>(new Function<net.gdface.sdk.fse.thrift.client.CodeBean, CodeBean>(){

            public CodeBean apply(net.gdface.sdk.fse.thrift.client.CodeBean input) {
                return (CodeBean)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.fse.thrift.client.CodeBean.class, CodeBean.class);
            }
        });
        nativeCallback.service.getFeatureByHexFromFse(featureId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeatureByHex(String featureId, FutureCallback<CodeBean> callback) {
        this.factory.addCallback(this.getFeatureByHex(featureId), callback);
    }

    public ListenableFuture<Boolean> removeFeature(byte[] featureId) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.removeFeatureFromFse((ByteString)TypeTransformer.getInstance().to((Object)featureId, byte[].class, ByteString.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void removeFeature(byte[] featureId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.removeFeature(featureId), callback);
    }

    public ListenableFuture<Boolean> removeFeatureByHex(String featureId) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.removeFeatureByHexFromFse(featureId, nativeCallback);
        return nativeCallback.feature;
    }

    public void removeFeatureByHex(String featureId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.removeFeatureByHex(featureId), callback);
    }

    public ListenableFuture<CodeBean[]> searchCode(byte[] code, double sim, int rows) {
        MethodCallback<CodeBean[], List<net.gdface.sdk.fse.thrift.client.CodeBean>> nativeCallback = new MethodCallback<CodeBean[], List<net.gdface.sdk.fse.thrift.client.CodeBean>>(new Function<List<net.gdface.sdk.fse.thrift.client.CodeBean>, CodeBean[]>(){

            public CodeBean[] apply(List<net.gdface.sdk.fse.thrift.client.CodeBean> input) {
                return (CodeBean[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.fse.thrift.client.CodeBean.class, CodeBean.class);
            }
        });
        nativeCallback.service.searchCodeFromFse((ByteString)TypeTransformer.getInstance().to((Object)code, byte[].class, ByteString.class), sim, rows, nativeCallback);
        return nativeCallback.feature;
    }

    public void searchCode(byte[] code, double sim, int rows, FutureCallback<CodeBean[]> callback) {
        this.factory.addCallback(this.searchCode(code, sim, rows), callback);
    }

    public ListenableFuture<Integer> size() {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.sizeOfFse(nativeCallback);
        return nativeCallback.feature;
    }

    public void size(FutureCallback<Integer> callback) {
        this.factory.addCallback(this.size(), callback);
    }

    static /* synthetic */ ClientFactory access$000(FeatureSeThriftClientAsync x0) {
        return x0.factory;
    }

    public static class DefaultCallback<V>
    implements FutureCallback<V> {
        public void onSuccess(V result) {
        }

        public void onFailure(Throwable t) {
            try {
                throw t;
            }
            catch (ServiceRuntimeException e) {
                this.onServiceRuntimeException(e);
            }
            catch (Throwable e) {
                this.onThrowable(e);
            }
        }

        protected void onServiceRuntimeException(ServiceRuntimeException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onThrowable(Throwable e) {
            e.printStackTrace();
        }
    }

    private class MethodCallback<L, R>
    implements ServiceMethodCallback<R> {
        private final AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){

            public void onTransportClosed() {
            }

            public void onError(Throwable error) {
                MethodCallback.this.onError(error);
            }
        };
        final FeatureSeClient service = (FeatureSeClient)FeatureSeThriftClientAsync.access$000(FeatureSeThriftClientAsync.this).applyInstance(FeatureSeClient.class, this.closeListener);
        final SettableFuture<L> feature = SettableFuture.create();
        final Function<R, L> transformer;

        MethodCallback(Function<R, L> transformer) {
            this.transformer = transformer;
        }

        public void onSuccess(R result) {
            this.feature.set(this.transformer.apply(result));
            try {
                this.service.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onError(Throwable error) {
            if (error instanceof ThriftException && ((ThriftException)error).kind == ThriftException.Kind.MISSING_RESULT) {
                this.onSuccess(null);
            }
            this.feature.setException(error);
            try {
                this.service.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

