/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.sdk.fse.thrift.client;

import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.ListMetadata;
import com.microsoft.thrifty.protocol.MessageMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.MethodCall;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import com.microsoft.thrifty.util.ProtocolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.gdface.sdk.fse.thrift.client.CodeBean;
import net.gdface.sdk.fse.thrift.client.FeatureSe;
import net.gdface.sdk.fse.thrift.client.ServiceRuntimeException;
import okio.ByteString;

public class FeatureSeClient
extends AsyncClientBase
implements FeatureSe {
    public FeatureSeClient(Protocol protocol, AsyncClientBase.Listener listener) {
        super(protocol, listener);
    }

    @Override
    public void addFeatureToFse(ByteString featureId, ByteString feature, String imgMD5, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new AddFeatureToFseCall(featureId, feature, imgMD5, callback));
    }

    @Override
    public void addFeatureToFseWithAppId(ByteString featureId, ByteString feature, Long appid, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new AddFeatureToFseWithAppIdCall(featureId, feature, appid, callback));
    }

    @Override
    public void clearAllOfFse(ServiceMethodCallback<Void> callback) {
        this.enqueue(new ClearAllOfFseCall(callback));
    }

    @Override
    public void getFeatureByHexFromFse(String featureId, ServiceMethodCallback<CodeBean> callback) {
        this.enqueue(new GetFeatureByHexFromFseCall(featureId, callback));
    }

    @Override
    public void getFeatureFromFse(ByteString featureId, ServiceMethodCallback<CodeBean> callback) {
        this.enqueue(new GetFeatureFromFseCall(featureId, callback));
    }

    @Override
    public void removeFeatureByHexFromFse(String featureId, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new RemoveFeatureByHexFromFseCall(featureId, callback));
    }

    @Override
    public void removeFeatureFromFse(ByteString featureId, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new RemoveFeatureFromFseCall(featureId, callback));
    }

    @Override
    public void searchCodeFromFse(ByteString code, Double sim, Integer rows, ServiceMethodCallback<List<CodeBean>> callback) {
        this.enqueue(new SearchCodeFromFseCall(code, sim, rows, callback));
    }

    @Override
    public void sizeOfFse(ServiceMethodCallback<Integer> callback) {
        this.enqueue(new SizeOfFseCall(callback));
    }

    private static final class SizeOfFseCall
    extends MethodCall<Integer> {
        SizeOfFseCall(ServiceMethodCallback<Integer> callback) {
            super("sizeOfFse", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SearchCodeFromFseCall
    extends MethodCall<List<CodeBean>> {
        private final ByteString code;
        private final Double sim;
        private final Integer rows;

        SearchCodeFromFseCall(ByteString code, Double sim, Integer rows, ServiceMethodCallback<List<CodeBean>> callback) {
            super("searchCodeFromFse", (byte)1, callback);
            this.code = code;
            if (sim == null) {
                throw new NullPointerException("sim");
            }
            this.sim = sim;
            if (rows == null) {
                throw new NullPointerException("rows");
            }
            this.rows = rows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.code != null) {
                protocol.writeFieldBegin("code", 1, (byte)11);
                protocol.writeBinary(this.code);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("sim", 2, (byte)4);
            protocol.writeDouble(this.sim.doubleValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("rows", 3, (byte)8);
            protocol.writeI32(this.rows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<CodeBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<CodeBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<CodeBean> value = new ArrayList<CodeBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                CodeBean item0 = (CodeBean)CodeBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RemoveFeatureFromFseCall
    extends MethodCall<Boolean> {
        private final ByteString featureId;

        RemoveFeatureFromFseCall(ByteString featureId, ServiceMethodCallback<Boolean> callback) {
            super("removeFeatureFromFse", (byte)1, callback);
            this.featureId = featureId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureId != null) {
                protocol.writeFieldBegin("featureId", 1, (byte)11);
                protocol.writeBinary(this.featureId);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RemoveFeatureByHexFromFseCall
    extends MethodCall<Boolean> {
        private final String featureId;

        RemoveFeatureByHexFromFseCall(String featureId, ServiceMethodCallback<Boolean> callback) {
            super("removeFeatureByHexFromFse", (byte)1, callback);
            this.featureId = featureId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureId != null) {
                protocol.writeFieldBegin("featureId", 1, (byte)11);
                protocol.writeString(this.featureId);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureFromFseCall
    extends MethodCall<CodeBean> {
        private final ByteString featureId;

        GetFeatureFromFseCall(ByteString featureId, ServiceMethodCallback<CodeBean> callback) {
            super("getFeatureFromFse", (byte)1, callback);
            this.featureId = featureId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureId != null) {
                protocol.writeFieldBegin("featureId", 1, (byte)11);
                protocol.writeBinary(this.featureId);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected CodeBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (CodeBean)CodeBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureByHexFromFseCall
    extends MethodCall<CodeBean> {
        private final String featureId;

        GetFeatureByHexFromFseCall(String featureId, ServiceMethodCallback<CodeBean> callback) {
            super("getFeatureByHexFromFse", (byte)1, callback);
            this.featureId = featureId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureId != null) {
                protocol.writeFieldBegin("featureId", 1, (byte)11);
                protocol.writeString(this.featureId);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected CodeBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (CodeBean)CodeBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ClearAllOfFseCall
    extends MethodCall<Void> {
        ClearAllOfFseCall(ServiceMethodCallback<Void> callback) {
            super("clearAllOfFse", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class AddFeatureToFseWithAppIdCall
    extends MethodCall<Boolean> {
        private final ByteString featureId;
        private final ByteString feature;
        private final Long appid;

        AddFeatureToFseWithAppIdCall(ByteString featureId, ByteString feature, Long appid, ServiceMethodCallback<Boolean> callback) {
            super("addFeatureToFseWithAppId", (byte)1, callback);
            this.featureId = featureId;
            this.feature = feature;
            if (appid == null) {
                throw new NullPointerException("appid");
            }
            this.appid = appid;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureId != null) {
                protocol.writeFieldBegin("featureId", 1, (byte)11);
                protocol.writeBinary(this.featureId);
                protocol.writeFieldEnd();
            }
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 2, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("appid", 3, (byte)10);
            protocol.writeI64(this.appid.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddFeatureToFseCall
    extends MethodCall<Boolean> {
        private final ByteString featureId;
        private final ByteString feature;
        private final String imgMD5;

        AddFeatureToFseCall(ByteString featureId, ByteString feature, String imgMD5, ServiceMethodCallback<Boolean> callback) {
            super("addFeatureToFse", (byte)1, callback);
            this.featureId = featureId;
            this.feature = feature;
            this.imgMD5 = imgMD5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureId != null) {
                protocol.writeFieldBegin("featureId", 1, (byte)11);
                protocol.writeBinary(this.featureId);
                protocol.writeFieldEnd();
            }
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 2, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.imgMD5 != null) {
                protocol.writeFieldBegin("imgMD5", 3, (byte)11);
                protocol.writeString(this.imgMD5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }
}

