/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.sdk.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.CompareResult;
import net.gdface.sdk.FRect;
import net.gdface.sdk.FaceApi;
import net.gdface.sdk.FseResult;
import net.gdface.sdk.NotFaceDetectedException;
import net.gdface.sdk.thrift.ServiceRuntimeException;
import net.gdface.sdk.thrift.client.FaceApiClient;
import net.gdface.sdk.thrift.client.ImageErrorException;
import net.gdface.sdk.thrift.client.MatType;
import net.gdface.thrift.ClientFactory;
import net.gdface.thrift.ThriftUtils;
import net.gdface.thrift.TypeTransformer;
import okio.ByteString;

public class FaceApiThriftClient
implements FaceApi {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return this.factory;
    }

    public FaceApiThriftClient(ClientFactory factory) {
        this.factory = (ClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    public FaceApiThriftClient(String host, int port) {
        this(ClientFactory.builder().setHostAndPort(host, port));
    }

    public boolean testConnect() {
        return this.factory.testConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, L> R syncCall(final Function<L, R> transformer, ServiceAsyncCall<L> serviceCall) throws Throwable {
        final AtomicReference<Object> res = new AtomicReference<Object>(null);
        final AtomicReference<Object> err = new AtomicReference<Object>(null);
        final Object lock = new Object();
        final ServiceMethodCallback callback = new ServiceMethodCallback<L>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(L result) {
                res.set(transformer.apply(result));
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable error) {
                err.set(error);
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        };
        AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){

            public void onTransportClosed() {
            }

            public void onError(Throwable error) {
                callback.onError(error);
            }
        };
        FaceApiClient service = (FaceApiClient)this.factory.applyInstance(FaceApiClient.class, closeListener);
        Object object = lock;
        synchronized (object) {
            try {
                serviceCall.call(service, callback);
                lock.wait();
            }
            catch (InterruptedException e) {
                err.set(e);
            }
            finally {
                try {
                    service.close();
                }
                catch (IOException e) {}
            }
        }
        Throwable e = err.get();
        if (null != e) {
            ThriftUtils.returnNull((Throwable)e);
        }
        return res.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FaceApiThriftClient [factory=");
        builder.append(this.factory);
        builder.append(",interface=");
        builder.append(FaceApi.class.getName());
        builder.append("]");
        return builder.toString();
    }

    public double compare2Face(final byte[] imgData1, final CodeInfo facePos1, final byte[] imgData2, final CodeInfo facePos2) throws net.gdface.image.ImageErrorException, NotFaceDetectedException {
        try {
            return this.syncCall(new Function<Double, Double>(){

                public Double apply(Double input) {
                    return input;
                }
            }, new ServiceAsyncCall<Double>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<Double> nativeCallback) {
                    service.compare2Face((ByteString)TypeTransformer.getInstance().to((Object)imgData1, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos1, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), (ByteString)TypeTransformer.getInstance().to((Object)imgData2, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos2, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public double compareCode(final byte[] code1, final byte[] code2) {
        try {
            return this.syncCall(new Function<Double, Double>(){

                public Double apply(Double input) {
                    return input;
                }
            }, new ServiceAsyncCall<Double>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<Double> nativeCallback) {
                    service.compareCode((ByteString)TypeTransformer.getInstance().to((Object)code1, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)code2, byte[].class, ByteString.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public double[] compareCodes(final byte[] code1, final CodeInfo[] codes) {
        try {
            return this.syncCall(new Function<List<Double>, double[]>(){

                public double[] apply(List<Double> input) {
                    return TypeTransformer.getInstance().todoubleArray(input, Double.TYPE, Double.TYPE);
                }
            }, new ServiceAsyncCall<List<Double>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<Double>> nativeCallback) {
                    service.compareCodes((ByteString)TypeTransformer.getInstance().to((Object)code1, byte[].class, ByteString.class), TypeTransformer.getInstance().to((Object[])codes, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CompareResult compareFaces(final byte[] code, final byte[] imgData, final int faceNum) throws net.gdface.image.ImageErrorException, NotFaceDetectedException {
        try {
            return this.syncCall(new Function<net.gdface.sdk.thrift.client.CompareResult, CompareResult>(){

                public CompareResult apply(net.gdface.sdk.thrift.client.CompareResult input) {
                    return (CompareResult)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CompareResult.class, CompareResult.class);
                }
            }, new ServiceAsyncCall<net.gdface.sdk.thrift.client.CompareResult>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<net.gdface.sdk.thrift.client.CompareResult> nativeCallback) {
                    service.compareFaces((ByteString)TypeTransformer.getInstance().to((Object)code, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), faceNum, nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Double> compareFeatures(final byte[] code1, final List<byte[]> codes) {
        try {
            return this.syncCall(new Function<List<Double>, List<Double>>(){

                public List<Double> apply(List<Double> input) {
                    return TypeTransformer.getInstance().to(input, Double.class, Double.class);
                }
            }, new ServiceAsyncCall<List<Double>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<Double>> nativeCallback) {
                    service.compareFeatures((ByteString)TypeTransformer.getInstance().to((Object)code1, byte[].class, ByteString.class), TypeTransformer.getInstance().to(codes, byte[].class, ByteString.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public double detectAndCompare2Face(final byte[] imgData1, final FRect detectRect1, final byte[] imgData2, final FRect detectRect2) throws net.gdface.image.ImageErrorException, NotFaceDetectedException {
        try {
            return this.syncCall(new Function<Double, Double>(){

                public Double apply(Double input) {
                    return input;
                }
            }, new ServiceAsyncCall<Double>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<Double> nativeCallback) {
                    service.detectAndCompare2Face((ByteString)TypeTransformer.getInstance().to((Object)imgData1, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.FRect)TypeTransformer.getInstance().to((Object)detectRect1, FRect.class, net.gdface.sdk.thrift.client.FRect.class), (ByteString)TypeTransformer.getInstance().to((Object)imgData2, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.FRect)TypeTransformer.getInstance().to((Object)detectRect2, FRect.class, net.gdface.sdk.thrift.client.FRect.class), nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeInfo[] detectAndGetCodeInfo(final byte[] imgData, final int faceNum) throws net.gdface.image.ImageErrorException, NotFaceDetectedException {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

                public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                    return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.CodeInfo>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback) {
                    service.detectAndGetCodeInfo((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), faceNum, nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeInfo detectCenterFace(final byte[] imgData) throws net.gdface.image.ImageErrorException, NotFaceDetectedException {
        try {
            return this.syncCall(new Function<net.gdface.sdk.thrift.client.CodeInfo, CodeInfo>(){

                public CodeInfo apply(net.gdface.sdk.thrift.client.CodeInfo input) {
                    return (CodeInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<net.gdface.sdk.thrift.client.CodeInfo>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<net.gdface.sdk.thrift.client.CodeInfo> nativeCallback) {
                    service.detectCenterFace((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeInfo[] detectFace(final byte[] imgData) throws net.gdface.image.ImageErrorException {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

                public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                    return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.CodeInfo>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback) {
                    service.detectFace((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeInfo detectMaxFace(final byte[] imgData) throws net.gdface.image.ImageErrorException, NotFaceDetectedException {
        try {
            return this.syncCall(new Function<net.gdface.sdk.thrift.client.CodeInfo, CodeInfo>(){

                public CodeInfo apply(net.gdface.sdk.thrift.client.CodeInfo input) {
                    return (CodeInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<net.gdface.sdk.thrift.client.CodeInfo>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<net.gdface.sdk.thrift.client.CodeInfo> nativeCallback) {
                    service.detectMaxFace((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeInfo[] getCodeInfo(final byte[] imgData, final int faceNum, final CodeInfo[] facePos) throws NotFaceDetectedException {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

                public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                    return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.CodeInfo>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback) {
                    service.getCodeInfo((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), faceNum, TypeTransformer.getInstance().to((Object[])facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeInfo getCodeInfo(final byte[] imgData, final CodeInfo facePos) {
        try {
            return this.syncCall(new Function<net.gdface.sdk.thrift.client.CodeInfo, CodeInfo>(){

                public CodeInfo apply(net.gdface.sdk.thrift.client.CodeInfo input) {
                    return (CodeInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<net.gdface.sdk.thrift.client.CodeInfo>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<net.gdface.sdk.thrift.client.CodeInfo> nativeCallback) {
                    service.getCodeInfoSingle((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getFeature(final Map<ByteBuffer, CodeInfo> faces) throws NotFaceDetectedException {
        try {
            return this.syncCall(new Function<ByteString, byte[]>(){

                public byte[] apply(ByteString input) {
                    return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
                }
            }, new ServiceAsyncCall<ByteString>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<ByteString> nativeCallback) {
                    service.getFeature(TypeTransformer.getInstance().to(faces, ByteBuffer.class, CodeInfo.class, ByteString.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean hasFace(final byte[] imgData) throws net.gdface.image.ImageErrorException {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.hasFace((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isLocal() {
        return false;
    }

    public CodeInfo[] matDetectAndGetCodeInfo(final net.gdface.sdk.MatType matType, final byte[] matData, final int width, final int height, final int faceNum) throws NotFaceDetectedException {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

                public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                    return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.CodeInfo>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback) {
                    service.matDetectAndGetCodeInfo((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, faceNum, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<CodeInfo> matDetectFace(final net.gdface.sdk.MatType matType, final byte[] matData, final int width, final int height) {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, List<CodeInfo>>(){

                public List<CodeInfo> apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                    return TypeTransformer.getInstance().to(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.CodeInfo>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback) {
                    service.matDetectFace((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeInfo matDetectMaxFace(final net.gdface.sdk.MatType matType, final byte[] matData, final int width, final int height) throws NotFaceDetectedException {
        try {
            return this.syncCall(new Function<net.gdface.sdk.thrift.client.CodeInfo, CodeInfo>(){

                public CodeInfo apply(net.gdface.sdk.thrift.client.CodeInfo input) {
                    return (CodeInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<net.gdface.sdk.thrift.client.CodeInfo>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<net.gdface.sdk.thrift.client.CodeInfo> nativeCallback) {
                    service.matDetectMaxFace((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CodeInfo[] matGetCodeInfo(final net.gdface.sdk.MatType matType, final byte[] matData, final int width, final int height, final CodeInfo[] facePos) {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

                public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                    return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.CodeInfo>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback) {
                    service.matGetCodeInfo((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, TypeTransformer.getInstance().to((Object[])facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean matHasFace(final net.gdface.sdk.MatType matType, final byte[] matData, final int width, final int height) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.matHasFace((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FseResult[] matSearchFaces(final net.gdface.sdk.MatType matType, final byte[] matData, final int width, final int height, final CodeInfo facePos, final double similarty, final int rows) throws net.gdface.image.ImageErrorException, NotFaceDetectedException {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.FseResult>, FseResult[]>(){

                public FseResult[] apply(List<net.gdface.sdk.thrift.client.FseResult> input) {
                    return (FseResult[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.FseResult.class, FseResult.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.FseResult>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.FseResult>> nativeCallback) {
                    service.matSearchFaces((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), similarty, rows, nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Boolean matWearMask(final net.gdface.sdk.MatType matType, final byte[] matData, final int width, final int height, final CodeInfo faceInfo) {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.matWearMask((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)faceInfo, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> sdkCapacity() {
        try {
            return this.syncCall(new Function<Map<String, String>, Map<String, String>>(){

                public Map<String, String> apply(Map<String, String> input) {
                    return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
                }
            }, new ServiceAsyncCall<Map<String, String>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<Map<String, String>> nativeCallback) {
                    service.sdkCapacity(nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FseResult[] searchFaces(final byte[] imgData, final CodeInfo facePos, final double similarty, final int rows) throws net.gdface.image.ImageErrorException, NotFaceDetectedException {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.FseResult>, FseResult[]>(){

                public FseResult[] apply(List<net.gdface.sdk.thrift.client.FseResult> input) {
                    return (FseResult[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.FseResult.class, FseResult.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.FseResult>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.FseResult>> nativeCallback) {
                    service.searchFaces((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), similarty, rows, nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.NotFaceDetectedException e) {
            throw (NotFaceDetectedException)TypeTransformer.getInstance().to((Object)e, net.gdface.sdk.thrift.client.NotFaceDetectedException.class, NotFaceDetectedException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FseResult[] searchFeatures(final byte[] feature, final double similarty, final int rows) {
        try {
            return this.syncCall(new Function<List<net.gdface.sdk.thrift.client.FseResult>, FseResult[]>(){

                public FseResult[] apply(List<net.gdface.sdk.thrift.client.FseResult> input) {
                    return (FseResult[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.FseResult.class, FseResult.class);
                }
            }, new ServiceAsyncCall<List<net.gdface.sdk.thrift.client.FseResult>>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<List<net.gdface.sdk.thrift.client.FseResult>> nativeCallback) {
                    service.searchFeatures((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), similarty, rows, nativeCallback);
                }
            });
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Boolean wearMask(final byte[] imgData, final CodeInfo faceInfo) throws net.gdface.image.ImageErrorException {
        try {
            return this.syncCall(new Function<Boolean, Boolean>(){

                public Boolean apply(Boolean input) {
                    return input;
                }
            }, new ServiceAsyncCall<Boolean>(){

                @Override
                public void call(FaceApiClient service, ServiceMethodCallback<Boolean> nativeCallback) {
                    service.wearMask((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)faceInfo, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
                }
            });
        }
        catch (ImageErrorException e) {
            throw (net.gdface.image.ImageErrorException)TypeTransformer.getInstance().to((Object)e, ImageErrorException.class, net.gdface.image.ImageErrorException.class);
        }
        catch (net.gdface.sdk.thrift.client.ServiceRuntimeException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static interface ServiceAsyncCall<T> {
        public void call(FaceApiClient var1, ServiceMethodCallback<T> var2);
    }
}

