/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.sdk.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.CompareResult;
import net.gdface.sdk.FRect;
import net.gdface.sdk.FaceApi;
import net.gdface.sdk.FseResult;
import net.gdface.sdk.thrift.client.FaceApiClient;
import net.gdface.sdk.thrift.client.ImageErrorException;
import net.gdface.sdk.thrift.client.MatType;
import net.gdface.sdk.thrift.client.NotFaceDetectedException;
import net.gdface.sdk.thrift.client.ServiceRuntimeException;
import net.gdface.thrift.ClientFactory;
import net.gdface.thrift.TypeTransformer;
import okio.ByteString;

public class FaceApiThriftClientAsync {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return this.factory;
    }

    public FaceApiThriftClientAsync(ClientFactory factory) {
        this.factory = (ClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    public FaceApiThriftClientAsync(String host, int port) {
        this(ClientFactory.builder().setHostAndPort(host, port));
    }

    public boolean testConnect() {
        return this.factory.testConnect();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FaceApiThriftClientAsync [factory=");
        builder.append(this.factory);
        builder.append(",interface=");
        builder.append(FaceApi.class.getName());
        builder.append("]");
        return builder.toString();
    }

    public ListenableFuture<Double> compare2Face(byte[] imgData1, CodeInfo facePos1, byte[] imgData2, CodeInfo facePos2) {
        MethodCallback<Double, Double> nativeCallback = new MethodCallback<Double, Double>(new Function<Double, Double>(){

            public Double apply(Double input) {
                return input;
            }
        });
        nativeCallback.service.compare2Face((ByteString)TypeTransformer.getInstance().to((Object)imgData1, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos1, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), (ByteString)TypeTransformer.getInstance().to((Object)imgData2, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos2, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void compare2Face(byte[] imgData1, CodeInfo facePos1, byte[] imgData2, CodeInfo facePos2, FutureCallback<Double> callback) {
        this.factory.addCallback(this.compare2Face(imgData1, facePos1, imgData2, facePos2), callback);
    }

    public ListenableFuture<Double> compareCode(byte[] code1, byte[] code2) {
        MethodCallback<Double, Double> nativeCallback = new MethodCallback<Double, Double>(new Function<Double, Double>(){

            public Double apply(Double input) {
                return input;
            }
        });
        nativeCallback.service.compareCode((ByteString)TypeTransformer.getInstance().to((Object)code1, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)code2, byte[].class, ByteString.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void compareCode(byte[] code1, byte[] code2, FutureCallback<Double> callback) {
        this.factory.addCallback(this.compareCode(code1, code2), callback);
    }

    public ListenableFuture<double[]> compareCodes(byte[] code1, CodeInfo[] codes) {
        MethodCallback<double[], List<Double>> nativeCallback = new MethodCallback<double[], List<Double>>(new Function<List<Double>, double[]>(){

            public double[] apply(List<Double> input) {
                return TypeTransformer.getInstance().todoubleArray(input, Double.TYPE, Double.TYPE);
            }
        });
        nativeCallback.service.compareCodes((ByteString)TypeTransformer.getInstance().to((Object)code1, byte[].class, ByteString.class), TypeTransformer.getInstance().to((Object[])codes, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void compareCodes(byte[] code1, CodeInfo[] codes, FutureCallback<double[]> callback) {
        this.factory.addCallback(this.compareCodes(code1, codes), callback);
    }

    public ListenableFuture<CompareResult> compareFaces(byte[] code, byte[] imgData, int faceNum) {
        MethodCallback<CompareResult, net.gdface.sdk.thrift.client.CompareResult> nativeCallback = new MethodCallback<CompareResult, net.gdface.sdk.thrift.client.CompareResult>(new Function<net.gdface.sdk.thrift.client.CompareResult, CompareResult>(){

            public CompareResult apply(net.gdface.sdk.thrift.client.CompareResult input) {
                return (CompareResult)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CompareResult.class, CompareResult.class);
            }
        });
        nativeCallback.service.compareFaces((ByteString)TypeTransformer.getInstance().to((Object)code, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), faceNum, nativeCallback);
        return nativeCallback.feature;
    }

    public void compareFaces(byte[] code, byte[] imgData, int faceNum, FutureCallback<CompareResult> callback) {
        this.factory.addCallback(this.compareFaces(code, imgData, faceNum), callback);
    }

    public ListenableFuture<List<Double>> compareFeatures(byte[] code1, List<byte[]> codes) {
        MethodCallback<List<Double>, List<Double>> nativeCallback = new MethodCallback<List<Double>, List<Double>>(new Function<List<Double>, List<Double>>(){

            public List<Double> apply(List<Double> input) {
                return TypeTransformer.getInstance().to(input, Double.class, Double.class);
            }
        });
        nativeCallback.service.compareFeatures((ByteString)TypeTransformer.getInstance().to((Object)code1, byte[].class, ByteString.class), TypeTransformer.getInstance().to(codes, byte[].class, ByteString.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void compareFeatures(byte[] code1, List<byte[]> codes, FutureCallback<List<Double>> callback) {
        this.factory.addCallback(this.compareFeatures(code1, codes), callback);
    }

    public ListenableFuture<Double> detectAndCompare2Face(byte[] imgData1, FRect detectRect1, byte[] imgData2, FRect detectRect2) {
        MethodCallback<Double, Double> nativeCallback = new MethodCallback<Double, Double>(new Function<Double, Double>(){

            public Double apply(Double input) {
                return input;
            }
        });
        nativeCallback.service.detectAndCompare2Face((ByteString)TypeTransformer.getInstance().to((Object)imgData1, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.FRect)TypeTransformer.getInstance().to((Object)detectRect1, FRect.class, net.gdface.sdk.thrift.client.FRect.class), (ByteString)TypeTransformer.getInstance().to((Object)imgData2, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.FRect)TypeTransformer.getInstance().to((Object)detectRect2, FRect.class, net.gdface.sdk.thrift.client.FRect.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void detectAndCompare2Face(byte[] imgData1, FRect detectRect1, byte[] imgData2, FRect detectRect2, FutureCallback<Double> callback) {
        this.factory.addCallback(this.detectAndCompare2Face(imgData1, detectRect1, imgData2, detectRect2), callback);
    }

    public ListenableFuture<CodeInfo[]> detectAndGetCodeInfo(byte[] imgData, int faceNum) {
        MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback = new MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>>(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

            public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.detectAndGetCodeInfo((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), faceNum, nativeCallback);
        return nativeCallback.feature;
    }

    public void detectAndGetCodeInfo(byte[] imgData, int faceNum, FutureCallback<CodeInfo[]> callback) {
        this.factory.addCallback(this.detectAndGetCodeInfo(imgData, faceNum), callback);
    }

    public ListenableFuture<CodeInfo> detectCenterFace(byte[] imgData) {
        MethodCallback<CodeInfo, net.gdface.sdk.thrift.client.CodeInfo> nativeCallback = new MethodCallback<CodeInfo, net.gdface.sdk.thrift.client.CodeInfo>(new Function<net.gdface.sdk.thrift.client.CodeInfo, CodeInfo>(){

            public CodeInfo apply(net.gdface.sdk.thrift.client.CodeInfo input) {
                return (CodeInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.detectCenterFace((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void detectCenterFace(byte[] imgData, FutureCallback<CodeInfo> callback) {
        this.factory.addCallback(this.detectCenterFace(imgData), callback);
    }

    public ListenableFuture<CodeInfo[]> detectFace(byte[] imgData) {
        MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback = new MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>>(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

            public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.detectFace((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void detectFace(byte[] imgData, FutureCallback<CodeInfo[]> callback) {
        this.factory.addCallback(this.detectFace(imgData), callback);
    }

    public ListenableFuture<CodeInfo> detectMaxFace(byte[] imgData) {
        MethodCallback<CodeInfo, net.gdface.sdk.thrift.client.CodeInfo> nativeCallback = new MethodCallback<CodeInfo, net.gdface.sdk.thrift.client.CodeInfo>(new Function<net.gdface.sdk.thrift.client.CodeInfo, CodeInfo>(){

            public CodeInfo apply(net.gdface.sdk.thrift.client.CodeInfo input) {
                return (CodeInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.detectMaxFace((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void detectMaxFace(byte[] imgData, FutureCallback<CodeInfo> callback) {
        this.factory.addCallback(this.detectMaxFace(imgData), callback);
    }

    public ListenableFuture<CodeInfo[]> getCodeInfo(byte[] imgData, int faceNum, CodeInfo[] facePos) {
        MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback = new MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>>(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

            public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.getCodeInfo((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), faceNum, TypeTransformer.getInstance().to((Object[])facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getCodeInfo(byte[] imgData, int faceNum, CodeInfo[] facePos, FutureCallback<CodeInfo[]> callback) {
        this.factory.addCallback(this.getCodeInfo(imgData, faceNum, facePos), callback);
    }

    public ListenableFuture<CodeInfo> getCodeInfo(byte[] imgData, CodeInfo facePos) {
        MethodCallback<CodeInfo, net.gdface.sdk.thrift.client.CodeInfo> nativeCallback = new MethodCallback<CodeInfo, net.gdface.sdk.thrift.client.CodeInfo>(new Function<net.gdface.sdk.thrift.client.CodeInfo, CodeInfo>(){

            public CodeInfo apply(net.gdface.sdk.thrift.client.CodeInfo input) {
                return (CodeInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.getCodeInfoSingle((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getCodeInfo(byte[] imgData, CodeInfo facePos, FutureCallback<CodeInfo> callback) {
        this.factory.addCallback(this.getCodeInfo(imgData, facePos), callback);
    }

    public ListenableFuture<byte[]> getFeature(Map<ByteBuffer, CodeInfo> faces) {
        MethodCallback<byte[], ByteString> nativeCallback = new MethodCallback<byte[], ByteString>(new Function<ByteString, byte[]>(){

            public byte[] apply(ByteString input) {
                return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
            }
        });
        nativeCallback.service.getFeature(TypeTransformer.getInstance().to(faces, ByteBuffer.class, CodeInfo.class, ByteString.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeature(Map<ByteBuffer, CodeInfo> faces, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getFeature(faces), callback);
    }

    public ListenableFuture<Boolean> hasFace(byte[] imgData) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.hasFace((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void hasFace(byte[] imgData, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.hasFace(imgData), callback);
    }

    public boolean isLocal() {
        return false;
    }

    public ListenableFuture<CodeInfo[]> matDetectAndGetCodeInfo(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, int faceNum) {
        MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback = new MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>>(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

            public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.matDetectAndGetCodeInfo((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, faceNum, nativeCallback);
        return nativeCallback.feature;
    }

    public void matDetectAndGetCodeInfo(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, int faceNum, FutureCallback<CodeInfo[]> callback) {
        this.factory.addCallback(this.matDetectAndGetCodeInfo(matType, matData, width, height, faceNum), callback);
    }

    public ListenableFuture<List<CodeInfo>> matDetectFace(net.gdface.sdk.MatType matType, byte[] matData, int width, int height) {
        MethodCallback<List<CodeInfo>, List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback = new MethodCallback<List<CodeInfo>, List<net.gdface.sdk.thrift.client.CodeInfo>>(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, List<CodeInfo>>(){

            public List<CodeInfo> apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.matDetectFace((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, nativeCallback);
        return nativeCallback.feature;
    }

    public void matDetectFace(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, FutureCallback<List<CodeInfo>> callback) {
        this.factory.addCallback(this.matDetectFace(matType, matData, width, height), callback);
    }

    public ListenableFuture<CodeInfo> matDetectMaxFace(net.gdface.sdk.MatType matType, byte[] matData, int width, int height) {
        MethodCallback<CodeInfo, net.gdface.sdk.thrift.client.CodeInfo> nativeCallback = new MethodCallback<CodeInfo, net.gdface.sdk.thrift.client.CodeInfo>(new Function<net.gdface.sdk.thrift.client.CodeInfo, CodeInfo>(){

            public CodeInfo apply(net.gdface.sdk.thrift.client.CodeInfo input) {
                return (CodeInfo)TypeTransformer.getInstance().to((Object)input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.matDetectMaxFace((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, nativeCallback);
        return nativeCallback.feature;
    }

    public void matDetectMaxFace(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, FutureCallback<CodeInfo> callback) {
        this.factory.addCallback(this.matDetectMaxFace(matType, matData, width, height), callback);
    }

    public ListenableFuture<CodeInfo[]> matGetCodeInfo(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, CodeInfo[] facePos) {
        MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>> nativeCallback = new MethodCallback<CodeInfo[], List<net.gdface.sdk.thrift.client.CodeInfo>>(new Function<List<net.gdface.sdk.thrift.client.CodeInfo>, CodeInfo[]>(){

            public CodeInfo[] apply(List<net.gdface.sdk.thrift.client.CodeInfo> input) {
                return (CodeInfo[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.CodeInfo.class, CodeInfo.class);
            }
        });
        nativeCallback.service.matGetCodeInfo((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, TypeTransformer.getInstance().to((Object[])facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void matGetCodeInfo(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, CodeInfo[] facePos, FutureCallback<CodeInfo[]> callback) {
        this.factory.addCallback(this.matGetCodeInfo(matType, matData, width, height, facePos), callback);
    }

    public ListenableFuture<Boolean> matHasFace(net.gdface.sdk.MatType matType, byte[] matData, int width, int height) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.matHasFace((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, nativeCallback);
        return nativeCallback.feature;
    }

    public void matHasFace(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.matHasFace(matType, matData, width, height), callback);
    }

    public ListenableFuture<FseResult[]> matSearchFaces(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, CodeInfo facePos, double similarty, int rows) {
        MethodCallback<FseResult[], List<net.gdface.sdk.thrift.client.FseResult>> nativeCallback = new MethodCallback<FseResult[], List<net.gdface.sdk.thrift.client.FseResult>>(new Function<List<net.gdface.sdk.thrift.client.FseResult>, FseResult[]>(){

            public FseResult[] apply(List<net.gdface.sdk.thrift.client.FseResult> input) {
                return (FseResult[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.FseResult.class, FseResult.class);
            }
        });
        nativeCallback.service.matSearchFaces((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), similarty, rows, nativeCallback);
        return nativeCallback.feature;
    }

    public void matSearchFaces(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, CodeInfo facePos, double similarty, int rows, FutureCallback<FseResult[]> callback) {
        this.factory.addCallback(this.matSearchFaces(matType, matData, width, height, facePos, similarty, rows), callback);
    }

    public ListenableFuture<Boolean> matWearMask(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, CodeInfo faceInfo) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.matWearMask((MatType)((Object)TypeTransformer.getInstance().to((Object)matType, net.gdface.sdk.MatType.class, MatType.class)), (ByteString)TypeTransformer.getInstance().to((Object)matData, byte[].class, ByteString.class), width, height, (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)faceInfo, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void matWearMask(net.gdface.sdk.MatType matType, byte[] matData, int width, int height, CodeInfo faceInfo, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.matWearMask(matType, matData, width, height, faceInfo), callback);
    }

    public ListenableFuture<Map<String, String>> sdkCapacity() {
        MethodCallback<Map<String, String>, Map<String, String>> nativeCallback = new MethodCallback<Map<String, String>, Map<String, String>>(new Function<Map<String, String>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
            }
        });
        nativeCallback.service.sdkCapacity(nativeCallback);
        return nativeCallback.feature;
    }

    public void sdkCapacity(FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.sdkCapacity(), callback);
    }

    public ListenableFuture<FseResult[]> searchFaces(byte[] imgData, CodeInfo facePos, double similarty, int rows) {
        MethodCallback<FseResult[], List<net.gdface.sdk.thrift.client.FseResult>> nativeCallback = new MethodCallback<FseResult[], List<net.gdface.sdk.thrift.client.FseResult>>(new Function<List<net.gdface.sdk.thrift.client.FseResult>, FseResult[]>(){

            public FseResult[] apply(List<net.gdface.sdk.thrift.client.FseResult> input) {
                return (FseResult[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.FseResult.class, FseResult.class);
            }
        });
        nativeCallback.service.searchFaces((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)facePos, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), similarty, rows, nativeCallback);
        return nativeCallback.feature;
    }

    public void searchFaces(byte[] imgData, CodeInfo facePos, double similarty, int rows, FutureCallback<FseResult[]> callback) {
        this.factory.addCallback(this.searchFaces(imgData, facePos, similarty, rows), callback);
    }

    public ListenableFuture<FseResult[]> searchFeatures(byte[] feature, double similarty, int rows) {
        MethodCallback<FseResult[], List<net.gdface.sdk.thrift.client.FseResult>> nativeCallback = new MethodCallback<FseResult[], List<net.gdface.sdk.thrift.client.FseResult>>(new Function<List<net.gdface.sdk.thrift.client.FseResult>, FseResult[]>(){

            public FseResult[] apply(List<net.gdface.sdk.thrift.client.FseResult> input) {
                return (FseResult[])TypeTransformer.getInstance().toArray(input, net.gdface.sdk.thrift.client.FseResult.class, FseResult.class);
            }
        });
        nativeCallback.service.searchFeatures((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), similarty, rows, nativeCallback);
        return nativeCallback.feature;
    }

    public void searchFeatures(byte[] feature, double similarty, int rows, FutureCallback<FseResult[]> callback) {
        this.factory.addCallback(this.searchFeatures(feature, similarty, rows), callback);
    }

    public ListenableFuture<Boolean> wearMask(byte[] imgData, CodeInfo faceInfo) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.wearMask((ByteString)TypeTransformer.getInstance().to((Object)imgData, byte[].class, ByteString.class), (net.gdface.sdk.thrift.client.CodeInfo)TypeTransformer.getInstance().to((Object)faceInfo, CodeInfo.class, net.gdface.sdk.thrift.client.CodeInfo.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void wearMask(byte[] imgData, CodeInfo faceInfo, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.wearMask(imgData, faceInfo), callback);
    }

    static /* synthetic */ ClientFactory access$000(FaceApiThriftClientAsync x0) {
        return x0.factory;
    }

    public static class DefaultCallback<V>
    implements FutureCallback<V> {
        public void onSuccess(V result) {
        }

        public void onFailure(Throwable t) {
            try {
                throw t;
            }
            catch (ImageErrorException e) {
                this.onImageErrorException(e);
            }
            catch (NotFaceDetectedException e) {
                this.onNotFaceDetectedException(e);
            }
            catch (ServiceRuntimeException e) {
                this.onServiceRuntimeException(e);
            }
            catch (Throwable e) {
                this.onThrowable(e);
            }
        }

        protected void onImageErrorException(ImageErrorException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onNotFaceDetectedException(NotFaceDetectedException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onServiceRuntimeException(ServiceRuntimeException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onThrowable(Throwable e) {
            e.printStackTrace();
        }
    }

    private class MethodCallback<L, R>
    implements ServiceMethodCallback<R> {
        private final AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){

            public void onTransportClosed() {
            }

            public void onError(Throwable error) {
                MethodCallback.this.onError(error);
            }
        };
        final FaceApiClient service = (FaceApiClient)FaceApiThriftClientAsync.access$000(FaceApiThriftClientAsync.this).applyInstance(FaceApiClient.class, this.closeListener);
        final SettableFuture<L> feature = SettableFuture.create();
        final Function<R, L> transformer;

        MethodCallback(Function<R, L> transformer) {
            this.transformer = transformer;
        }

        public void onSuccess(R result) {
            this.feature.set(this.transformer.apply(result));
            try {
                this.service.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onError(Throwable error) {
            if (error instanceof ThriftException && ((ThriftException)error).kind == ThriftException.Kind.MISSING_RESULT) {
                this.onSuccess(null);
            }
            this.feature.setException(error);
            try {
                this.service.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

