/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.sdk.thrift.client;

import com.microsoft.thrifty.Adapter;
import com.microsoft.thrifty.Struct;
import com.microsoft.thrifty.StructBuilder;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.ListMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.util.ProtocolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.gdface.sdk.thrift.client.CodeInfo;

public final class CompareResult
implements Struct {
    public static final Adapter<CompareResult, Builder> ADAPTER = new CompareResultAdapter();
    public final List<CodeInfo> codes;
    public final List<Double> similartys;

    private CompareResult(Builder builder) {
        this.codes = builder.codes == null ? null : Collections.unmodifiableList(builder.codes);
        this.similartys = builder.similartys == null ? null : Collections.unmodifiableList(builder.similartys);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof CompareResult)) {
            return false;
        }
        CompareResult that = (CompareResult)other;
        return (this.codes == that.codes || this.codes != null && this.codes.equals(that.codes)) && (this.similartys == that.similartys || this.similartys != null && this.similartys.equals(that.similartys));
    }

    public int hashCode() {
        int code = 16777619;
        code ^= this.codes == null ? 0 : this.codes.hashCode();
        code *= -2128831035;
        code ^= this.similartys == null ? 0 : this.similartys.hashCode();
        return code *= -2128831035;
    }

    public String toString() {
        return "CompareResult{codes=" + this.codes + ", similartys=" + this.similartys + "}";
    }

    public void write(Protocol protocol) throws IOException {
        ADAPTER.write(protocol, (Object)this);
    }

    private static final class CompareResultAdapter
    implements Adapter<CompareResult, Builder> {
        private CompareResultAdapter() {
        }

        public void write(Protocol protocol, CompareResult struct) throws IOException {
            protocol.writeStructBegin("CompareResult");
            if (struct.codes != null) {
                protocol.writeFieldBegin("codes", 1, (byte)15);
                protocol.writeListBegin((byte)12, struct.codes.size());
                for (CodeInfo codeInfo : struct.codes) {
                    CodeInfo.ADAPTER.write(protocol, (Object)codeInfo);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (struct.similartys != null) {
                protocol.writeFieldBegin("similartys", 2, (byte)15);
                protocol.writeListBegin((byte)4, struct.similartys.size());
                for (Double d : struct.similartys) {
                    protocol.writeDouble(d.doubleValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        public CompareResult read(Protocol protocol, Builder builder) throws IOException {
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        int i0;
                        ArrayList<CodeInfo> value;
                        ListMetadata listMetadata0;
                        if (field.typeId == 15) {
                            listMetadata0 = protocol.readListBegin();
                            value = new ArrayList<CodeInfo>(listMetadata0.size);
                            for (i0 = 0; i0 < listMetadata0.size; ++i0) {
                                CodeInfo item0 = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            builder.codes(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        int i0;
                        ArrayList<CodeInfo> value;
                        ListMetadata listMetadata0;
                        if (field.typeId == 15) {
                            listMetadata0 = protocol.readListBegin();
                            value = new ArrayList(listMetadata0.size);
                            for (i0 = 0; i0 < listMetadata0.size; ++i0) {
                                double item0 = protocol.readDouble();
                                value.add((CodeInfo)((Object)Double.valueOf(item0)));
                            }
                            protocol.readListEnd();
                            builder.similartys(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            return builder.build();
        }

        public CompareResult read(Protocol protocol) throws IOException {
            return this.read(protocol, new Builder());
        }
    }

    public static final class Builder
    implements StructBuilder<CompareResult> {
        private List<CodeInfo> codes;
        private List<Double> similartys;

        public Builder() {
        }

        public Builder(CompareResult struct) {
            this.codes = struct.codes;
            this.similartys = struct.similartys;
        }

        public Builder codes(List<CodeInfo> codes) {
            this.codes = codes;
            return this;
        }

        public Builder similartys(List<Double> similartys) {
            this.similartys = similartys;
            return this;
        }

        public CompareResult build() {
            return new CompareResult(this);
        }

        public void reset() {
            this.codes = null;
            this.similartys = null;
        }
    }
}

