/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.sdk.thrift.client;

import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.ListMetadata;
import com.microsoft.thrifty.protocol.MapMetadata;
import com.microsoft.thrifty.protocol.MessageMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.MethodCall;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import com.microsoft.thrifty.util.ProtocolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gdface.sdk.thrift.client.CodeInfo;
import net.gdface.sdk.thrift.client.CompareResult;
import net.gdface.sdk.thrift.client.FRect;
import net.gdface.sdk.thrift.client.FaceApi;
import net.gdface.sdk.thrift.client.FseResult;
import net.gdface.sdk.thrift.client.ImageErrorException;
import net.gdface.sdk.thrift.client.MatType;
import net.gdface.sdk.thrift.client.NotFaceDetectedException;
import net.gdface.sdk.thrift.client.ServiceRuntimeException;
import okio.ByteString;

public class FaceApiClient
extends AsyncClientBase
implements FaceApi {
    public FaceApiClient(Protocol protocol, AsyncClientBase.Listener listener) {
        super(protocol, listener);
    }

    @Override
    public void compare2Face(ByteString imgData1, CodeInfo facePos1, ByteString imgData2, CodeInfo facePos2, ServiceMethodCallback<Double> callback) {
        this.enqueue(new Compare2FaceCall(imgData1, facePos1, imgData2, facePos2, callback));
    }

    @Override
    public void compareCode(ByteString code1, ByteString code2, ServiceMethodCallback<Double> callback) {
        this.enqueue(new CompareCodeCall(code1, code2, callback));
    }

    @Override
    public void compareCodes(ByteString code1, List<CodeInfo> codes, ServiceMethodCallback<List<Double>> callback) {
        this.enqueue(new CompareCodesCall(code1, codes, callback));
    }

    @Override
    public void compareFaces(ByteString code, ByteString imgData, Integer faceNum, ServiceMethodCallback<CompareResult> callback) {
        this.enqueue(new CompareFacesCall(code, imgData, faceNum, callback));
    }

    @Override
    public void compareFeatures(ByteString code1, List<ByteString> codes, ServiceMethodCallback<List<Double>> callback) {
        this.enqueue(new CompareFeaturesCall(code1, codes, callback));
    }

    @Override
    public void detectAndCompare2Face(ByteString imgData1, FRect detectRect1, ByteString imgData2, FRect detectRect2, ServiceMethodCallback<Double> callback) {
        this.enqueue(new DetectAndCompare2FaceCall(imgData1, detectRect1, imgData2, detectRect2, callback));
    }

    @Override
    public void detectAndGetCodeInfo(ByteString imgData, Integer faceNum, ServiceMethodCallback<List<CodeInfo>> callback) {
        this.enqueue(new DetectAndGetCodeInfoCall(imgData, faceNum, callback));
    }

    @Override
    public void detectCenterFace(ByteString imgData, ServiceMethodCallback<CodeInfo> callback) {
        this.enqueue(new DetectCenterFaceCall(imgData, callback));
    }

    @Override
    public void detectFace(ByteString imgData, ServiceMethodCallback<List<CodeInfo>> callback) {
        this.enqueue(new DetectFaceCall(imgData, callback));
    }

    @Override
    public void detectMaxFace(ByteString imgData, ServiceMethodCallback<CodeInfo> callback) {
        this.enqueue(new DetectMaxFaceCall(imgData, callback));
    }

    @Override
    public void getCodeInfo(ByteString imgData, Integer faceNum, List<CodeInfo> facePos, ServiceMethodCallback<List<CodeInfo>> callback) {
        this.enqueue(new GetCodeInfoCall(imgData, faceNum, facePos, callback));
    }

    @Override
    public void getCodeInfoSingle(ByteString imgData, CodeInfo facePos, ServiceMethodCallback<CodeInfo> callback) {
        this.enqueue(new GetCodeInfoSingleCall(imgData, facePos, callback));
    }

    @Override
    public void getFeature(Map<ByteString, CodeInfo> faces, ServiceMethodCallback<ByteString> callback) {
        this.enqueue(new GetFeatureCall(faces, callback));
    }

    @Override
    public void hasFace(ByteString imgData, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new HasFaceCall(imgData, callback));
    }

    @Override
    public void isLocal(ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsLocalCall(callback));
    }

    @Override
    public void matDetectAndGetCodeInfo(MatType matType, ByteString matData, Integer width, Integer height, Integer faceNum, ServiceMethodCallback<List<CodeInfo>> callback) {
        this.enqueue(new MatDetectAndGetCodeInfoCall(matType, matData, width, height, faceNum, callback));
    }

    @Override
    public void matDetectFace(MatType matType, ByteString matData, Integer width, Integer height, ServiceMethodCallback<List<CodeInfo>> callback) {
        this.enqueue(new MatDetectFaceCall(matType, matData, width, height, callback));
    }

    @Override
    public void matDetectMaxFace(MatType matType, ByteString matData, Integer width, Integer height, ServiceMethodCallback<CodeInfo> callback) {
        this.enqueue(new MatDetectMaxFaceCall(matType, matData, width, height, callback));
    }

    @Override
    public void matGetCodeInfo(MatType matType, ByteString matData, Integer width, Integer height, List<CodeInfo> facePos, ServiceMethodCallback<List<CodeInfo>> callback) {
        this.enqueue(new MatGetCodeInfoCall(matType, matData, width, height, facePos, callback));
    }

    @Override
    public void matHasFace(MatType matType, ByteString matData, Integer width, Integer height, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new MatHasFaceCall(matType, matData, width, height, callback));
    }

    @Override
    public void matSearchFaces(MatType matType, ByteString matData, Integer width, Integer height, CodeInfo facePos, Double similarty, Integer rows, ServiceMethodCallback<List<FseResult>> callback) {
        this.enqueue(new MatSearchFacesCall(matType, matData, width, height, facePos, similarty, rows, callback));
    }

    @Override
    public void matWearMask(MatType matType, ByteString matData, Integer width, Integer height, CodeInfo faceInfo, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new MatWearMaskCall(matType, matData, width, height, faceInfo, callback));
    }

    @Override
    public void sdkCapacity(ServiceMethodCallback<Map<String, String>> callback) {
        this.enqueue(new SdkCapacityCall(callback));
    }

    @Override
    public void searchFaces(ByteString imgData, CodeInfo facePos, Double similarty, Integer rows, ServiceMethodCallback<List<FseResult>> callback) {
        this.enqueue(new SearchFacesCall(imgData, facePos, similarty, rows, callback));
    }

    @Override
    public void searchFeatures(ByteString feature, Double similarty, Integer rows, ServiceMethodCallback<List<FseResult>> callback) {
        this.enqueue(new SearchFeaturesCall(feature, similarty, rows, callback));
    }

    @Override
    public void wearMask(ByteString imgData, CodeInfo faceInfo, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new WearMaskCall(imgData, faceInfo, callback));
    }

    private static final class WearMaskCall
    extends MethodCall<Boolean> {
        private final ByteString imgData;
        private final CodeInfo faceInfo;

        WearMaskCall(ByteString imgData, CodeInfo faceInfo, ServiceMethodCallback<Boolean> callback) {
            super("wearMask", (byte)1, callback);
            this.imgData = imgData;
            this.faceInfo = faceInfo;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            if (this.faceInfo != null) {
                protocol.writeFieldBegin("faceInfo", 2, (byte)12);
                CodeInfo.ADAPTER.write(protocol, (Object)this.faceInfo);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ImageErrorException ex1 = null;
            ServiceRuntimeException ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ImageErrorException value;
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SearchFeaturesCall
    extends MethodCall<List<FseResult>> {
        private final ByteString feature;
        private final Double similarty;
        private final Integer rows;

        SearchFeaturesCall(ByteString feature, Double similarty, Integer rows, ServiceMethodCallback<List<FseResult>> callback) {
            super("searchFeatures", (byte)1, callback);
            this.feature = feature;
            if (similarty == null) {
                throw new NullPointerException("similarty");
            }
            this.similarty = similarty;
            if (rows == null) {
                throw new NullPointerException("rows");
            }
            this.rows = rows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 1, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("similarty", 2, (byte)4);
            protocol.writeDouble(this.similarty.doubleValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("rows", 3, (byte)8);
            protocol.writeI32(this.rows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<FseResult> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<FseResult> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<FseResult> value = new ArrayList<FseResult>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                FseResult item0 = (FseResult)FseResult.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SearchFacesCall
    extends MethodCall<List<FseResult>> {
        private final ByteString imgData;
        private final CodeInfo facePos;
        private final Double similarty;
        private final Integer rows;

        SearchFacesCall(ByteString imgData, CodeInfo facePos, Double similarty, Integer rows, ServiceMethodCallback<List<FseResult>> callback) {
            super("searchFaces", (byte)1, callback);
            this.imgData = imgData;
            this.facePos = facePos;
            if (similarty == null) {
                throw new NullPointerException("similarty");
            }
            this.similarty = similarty;
            if (rows == null) {
                throw new NullPointerException("rows");
            }
            this.rows = rows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            if (this.facePos != null) {
                protocol.writeFieldBegin("facePos", 2, (byte)12);
                CodeInfo.ADAPTER.write(protocol, (Object)this.facePos);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("similarty", 3, (byte)4);
            protocol.writeDouble(this.similarty.doubleValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("rows", 4, (byte)8);
            protocol.writeI32(this.rows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<FseResult> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<FseResult> result = null;
            Exception ex1 = null;
            Exception ex2 = null;
            Exception ex3 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<FseResult> value = new ArrayList<FseResult>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                FseResult item0 = (FseResult)FseResult.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex3 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            if (ex3 != null) {
                throw ex3;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SdkCapacityCall
    extends MethodCall<Map<String, String>> {
        SdkCapacityCall(ServiceMethodCallback<Map<String, String>> callback) {
            super("sdkCapacity", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, String> value = new HashMap<String, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class MatWearMaskCall
    extends MethodCall<Boolean> {
        private final MatType matType;
        private final ByteString matData;
        private final Integer width;
        private final Integer height;
        private final CodeInfo faceInfo;

        MatWearMaskCall(MatType matType, ByteString matData, Integer width, Integer height, CodeInfo faceInfo, ServiceMethodCallback<Boolean> callback) {
            super("matWearMask", (byte)1, callback);
            this.matType = matType;
            this.matData = matData;
            if (width == null) {
                throw new NullPointerException("width");
            }
            this.width = width;
            if (height == null) {
                throw new NullPointerException("height");
            }
            this.height = height;
            this.faceInfo = faceInfo;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.matType != null) {
                protocol.writeFieldBegin("matType", 1, (byte)8);
                protocol.writeI32(this.matType.value);
                protocol.writeFieldEnd();
            }
            if (this.matData != null) {
                protocol.writeFieldBegin("matData", 2, (byte)11);
                protocol.writeBinary(this.matData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("width", 3, (byte)8);
            protocol.writeI32(this.width.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("height", 4, (byte)8);
            protocol.writeI32(this.height.intValue());
            protocol.writeFieldEnd();
            if (this.faceInfo != null) {
                protocol.writeFieldBegin("faceInfo", 5, (byte)12);
                CodeInfo.ADAPTER.write(protocol, (Object)this.faceInfo);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class MatSearchFacesCall
    extends MethodCall<List<FseResult>> {
        private final MatType matType;
        private final ByteString matData;
        private final Integer width;
        private final Integer height;
        private final CodeInfo facePos;
        private final Double similarty;
        private final Integer rows;

        MatSearchFacesCall(MatType matType, ByteString matData, Integer width, Integer height, CodeInfo facePos, Double similarty, Integer rows, ServiceMethodCallback<List<FseResult>> callback) {
            super("matSearchFaces", (byte)1, callback);
            this.matType = matType;
            this.matData = matData;
            if (width == null) {
                throw new NullPointerException("width");
            }
            this.width = width;
            if (height == null) {
                throw new NullPointerException("height");
            }
            this.height = height;
            this.facePos = facePos;
            if (similarty == null) {
                throw new NullPointerException("similarty");
            }
            this.similarty = similarty;
            if (rows == null) {
                throw new NullPointerException("rows");
            }
            this.rows = rows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.matType != null) {
                protocol.writeFieldBegin("matType", 1, (byte)8);
                protocol.writeI32(this.matType.value);
                protocol.writeFieldEnd();
            }
            if (this.matData != null) {
                protocol.writeFieldBegin("matData", 2, (byte)11);
                protocol.writeBinary(this.matData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("width", 3, (byte)8);
            protocol.writeI32(this.width.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("height", 4, (byte)8);
            protocol.writeI32(this.height.intValue());
            protocol.writeFieldEnd();
            if (this.facePos != null) {
                protocol.writeFieldBegin("facePos", 5, (byte)12);
                CodeInfo.ADAPTER.write(protocol, (Object)this.facePos);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("similarty", 6, (byte)4);
            protocol.writeDouble(this.similarty.doubleValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("rows", 7, (byte)8);
            protocol.writeI32(this.rows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<FseResult> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<FseResult> result = null;
            Exception ex1 = null;
            Exception ex2 = null;
            Exception ex3 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<FseResult> value = new ArrayList<FseResult>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                FseResult item0 = (FseResult)FseResult.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex3 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            if (ex3 != null) {
                throw ex3;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class MatHasFaceCall
    extends MethodCall<Boolean> {
        private final MatType matType;
        private final ByteString matData;
        private final Integer width;
        private final Integer height;

        MatHasFaceCall(MatType matType, ByteString matData, Integer width, Integer height, ServiceMethodCallback<Boolean> callback) {
            super("matHasFace", (byte)1, callback);
            this.matType = matType;
            this.matData = matData;
            if (width == null) {
                throw new NullPointerException("width");
            }
            this.width = width;
            if (height == null) {
                throw new NullPointerException("height");
            }
            this.height = height;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.matType != null) {
                protocol.writeFieldBegin("matType", 1, (byte)8);
                protocol.writeI32(this.matType.value);
                protocol.writeFieldEnd();
            }
            if (this.matData != null) {
                protocol.writeFieldBegin("matData", 2, (byte)11);
                protocol.writeBinary(this.matData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("width", 3, (byte)8);
            protocol.writeI32(this.width.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("height", 4, (byte)8);
            protocol.writeI32(this.height.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class MatGetCodeInfoCall
    extends MethodCall<List<CodeInfo>> {
        private final MatType matType;
        private final ByteString matData;
        private final Integer width;
        private final Integer height;
        private final List<CodeInfo> facePos;

        MatGetCodeInfoCall(MatType matType, ByteString matData, Integer width, Integer height, List<CodeInfo> facePos, ServiceMethodCallback<List<CodeInfo>> callback) {
            super("matGetCodeInfo", (byte)1, callback);
            this.matType = matType;
            this.matData = matData;
            if (width == null) {
                throw new NullPointerException("width");
            }
            this.width = width;
            if (height == null) {
                throw new NullPointerException("height");
            }
            this.height = height;
            this.facePos = facePos;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.matType != null) {
                protocol.writeFieldBegin("matType", 1, (byte)8);
                protocol.writeI32(this.matType.value);
                protocol.writeFieldEnd();
            }
            if (this.matData != null) {
                protocol.writeFieldBegin("matData", 2, (byte)11);
                protocol.writeBinary(this.matData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("width", 3, (byte)8);
            protocol.writeI32(this.width.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("height", 4, (byte)8);
            protocol.writeI32(this.height.intValue());
            protocol.writeFieldEnd();
            if (this.facePos != null) {
                protocol.writeFieldBegin("facePos", 5, (byte)15);
                protocol.writeListBegin((byte)12, this.facePos.size());
                for (CodeInfo item0 : this.facePos) {
                    CodeInfo.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<CodeInfo> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<CodeInfo> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<CodeInfo> value = new ArrayList<CodeInfo>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                CodeInfo item0 = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class MatDetectMaxFaceCall
    extends MethodCall<CodeInfo> {
        private final MatType matType;
        private final ByteString matData;
        private final Integer width;
        private final Integer height;

        MatDetectMaxFaceCall(MatType matType, ByteString matData, Integer width, Integer height, ServiceMethodCallback<CodeInfo> callback) {
            super("matDetectMaxFace", (byte)1, callback);
            this.matType = matType;
            this.matData = matData;
            if (width == null) {
                throw new NullPointerException("width");
            }
            this.width = width;
            if (height == null) {
                throw new NullPointerException("height");
            }
            this.height = height;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.matType != null) {
                protocol.writeFieldBegin("matType", 1, (byte)8);
                protocol.writeI32(this.matType.value);
                protocol.writeFieldEnd();
            }
            if (this.matData != null) {
                protocol.writeFieldBegin("matData", 2, (byte)11);
                protocol.writeBinary(this.matData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("width", 3, (byte)8);
            protocol.writeI32(this.width.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("height", 4, (byte)8);
            protocol.writeI32(this.height.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected CodeInfo receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class MatDetectFaceCall
    extends MethodCall<List<CodeInfo>> {
        private final MatType matType;
        private final ByteString matData;
        private final Integer width;
        private final Integer height;

        MatDetectFaceCall(MatType matType, ByteString matData, Integer width, Integer height, ServiceMethodCallback<List<CodeInfo>> callback) {
            super("matDetectFace", (byte)1, callback);
            this.matType = matType;
            this.matData = matData;
            if (width == null) {
                throw new NullPointerException("width");
            }
            this.width = width;
            if (height == null) {
                throw new NullPointerException("height");
            }
            this.height = height;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.matType != null) {
                protocol.writeFieldBegin("matType", 1, (byte)8);
                protocol.writeI32(this.matType.value);
                protocol.writeFieldEnd();
            }
            if (this.matData != null) {
                protocol.writeFieldBegin("matData", 2, (byte)11);
                protocol.writeBinary(this.matData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("width", 3, (byte)8);
            protocol.writeI32(this.width.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("height", 4, (byte)8);
            protocol.writeI32(this.height.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<CodeInfo> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<CodeInfo> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<CodeInfo> value = new ArrayList<CodeInfo>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                CodeInfo item0 = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class MatDetectAndGetCodeInfoCall
    extends MethodCall<List<CodeInfo>> {
        private final MatType matType;
        private final ByteString matData;
        private final Integer width;
        private final Integer height;
        private final Integer faceNum;

        MatDetectAndGetCodeInfoCall(MatType matType, ByteString matData, Integer width, Integer height, Integer faceNum, ServiceMethodCallback<List<CodeInfo>> callback) {
            super("matDetectAndGetCodeInfo", (byte)1, callback);
            this.matType = matType;
            this.matData = matData;
            if (width == null) {
                throw new NullPointerException("width");
            }
            this.width = width;
            if (height == null) {
                throw new NullPointerException("height");
            }
            this.height = height;
            if (faceNum == null) {
                throw new NullPointerException("faceNum");
            }
            this.faceNum = faceNum;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.matType != null) {
                protocol.writeFieldBegin("matType", 1, (byte)8);
                protocol.writeI32(this.matType.value);
                protocol.writeFieldEnd();
            }
            if (this.matData != null) {
                protocol.writeFieldBegin("matData", 2, (byte)11);
                protocol.writeBinary(this.matData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("width", 3, (byte)8);
            protocol.writeI32(this.width.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("height", 4, (byte)8);
            protocol.writeI32(this.height.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("faceNum", 5, (byte)8);
            protocol.writeI32(this.faceNum.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<CodeInfo> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<CodeInfo> result = null;
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<CodeInfo> value = new ArrayList<CodeInfo>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                CodeInfo item0 = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsLocalCall
    extends MethodCall<Boolean> {
        IsLocalCall(ServiceMethodCallback<Boolean> callback) {
            super("isLocal", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class HasFaceCall
    extends MethodCall<Boolean> {
        private final ByteString imgData;

        HasFaceCall(ByteString imgData, ServiceMethodCallback<Boolean> callback) {
            super("hasFace", (byte)1, callback);
            this.imgData = imgData;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ImageErrorException ex1 = null;
            ServiceRuntimeException ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ImageErrorException value;
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureCall
    extends MethodCall<ByteString> {
        private final Map<ByteString, CodeInfo> faces;

        GetFeatureCall(Map<ByteString, CodeInfo> faces, ServiceMethodCallback<ByteString> callback) {
            super("getFeature", (byte)1, callback);
            this.faces = faces;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.faces != null) {
                protocol.writeFieldBegin("faces", 1, (byte)13);
                protocol.writeMapBegin((byte)11, (byte)12, this.faces.size());
                for (Map.Entry<ByteString, CodeInfo> entry0 : this.faces.entrySet()) {
                    ByteString key0 = entry0.getKey();
                    CodeInfo value0 = entry0.getValue();
                    protocol.writeBinary(key0);
                    CodeInfo.ADAPTER.write(protocol, (Object)value0);
                }
                protocol.writeMapEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ByteString receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ByteString result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            result = value = protocol.readBinary();
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetCodeInfoSingleCall
    extends MethodCall<CodeInfo> {
        private final ByteString imgData;
        private final CodeInfo facePos;

        GetCodeInfoSingleCall(ByteString imgData, CodeInfo facePos, ServiceMethodCallback<CodeInfo> callback) {
            super("getCodeInfoSingle", (byte)1, callback);
            this.imgData = imgData;
            this.facePos = facePos;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            if (this.facePos != null) {
                protocol.writeFieldBegin("facePos", 2, (byte)12);
                CodeInfo.ADAPTER.write(protocol, (Object)this.facePos);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected CodeInfo receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetCodeInfoCall
    extends MethodCall<List<CodeInfo>> {
        private final ByteString imgData;
        private final Integer faceNum;
        private final List<CodeInfo> facePos;

        GetCodeInfoCall(ByteString imgData, Integer faceNum, List<CodeInfo> facePos, ServiceMethodCallback<List<CodeInfo>> callback) {
            super("getCodeInfo", (byte)1, callback);
            this.imgData = imgData;
            if (faceNum == null) {
                throw new NullPointerException("faceNum");
            }
            this.faceNum = faceNum;
            this.facePos = facePos;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("faceNum", 2, (byte)8);
            protocol.writeI32(this.faceNum.intValue());
            protocol.writeFieldEnd();
            if (this.facePos != null) {
                protocol.writeFieldBegin("facePos", 3, (byte)15);
                protocol.writeListBegin((byte)12, this.facePos.size());
                for (CodeInfo item0 : this.facePos) {
                    CodeInfo.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<CodeInfo> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<CodeInfo> result = null;
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<CodeInfo> value = new ArrayList<CodeInfo>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                CodeInfo item0 = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DetectMaxFaceCall
    extends MethodCall<CodeInfo> {
        private final ByteString imgData;

        DetectMaxFaceCall(ByteString imgData, ServiceMethodCallback<CodeInfo> callback) {
            super("detectMaxFace", (byte)1, callback);
            this.imgData = imgData;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected CodeInfo receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            Object ex3 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        Object value;
                        if (field.typeId == 12) {
                            ex3 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            if (ex3 != null) {
                throw ex3;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DetectFaceCall
    extends MethodCall<List<CodeInfo>> {
        private final ByteString imgData;

        DetectFaceCall(ByteString imgData, ServiceMethodCallback<List<CodeInfo>> callback) {
            super("detectFace", (byte)1, callback);
            this.imgData = imgData;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<CodeInfo> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<CodeInfo> result = null;
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<CodeInfo> value = new ArrayList<CodeInfo>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                CodeInfo item0 = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DetectCenterFaceCall
    extends MethodCall<CodeInfo> {
        private final ByteString imgData;

        DetectCenterFaceCall(ByteString imgData, ServiceMethodCallback<CodeInfo> callback) {
            super("detectCenterFace", (byte)1, callback);
            this.imgData = imgData;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected CodeInfo receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            Object ex3 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        Object value;
                        if (field.typeId == 12) {
                            ex3 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            if (ex3 != null) {
                throw ex3;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DetectAndGetCodeInfoCall
    extends MethodCall<List<CodeInfo>> {
        private final ByteString imgData;
        private final Integer faceNum;

        DetectAndGetCodeInfoCall(ByteString imgData, Integer faceNum, ServiceMethodCallback<List<CodeInfo>> callback) {
            super("detectAndGetCodeInfo", (byte)1, callback);
            this.imgData = imgData;
            if (faceNum == null) {
                throw new NullPointerException("faceNum");
            }
            this.faceNum = faceNum;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 1, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("faceNum", 2, (byte)8);
            protocol.writeI32(this.faceNum.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<CodeInfo> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<CodeInfo> result = null;
            Exception ex1 = null;
            Exception ex2 = null;
            Exception ex3 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<CodeInfo> value = new ArrayList<CodeInfo>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                CodeInfo item0 = (CodeInfo)CodeInfo.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex3 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            if (ex3 != null) {
                throw ex3;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DetectAndCompare2FaceCall
    extends MethodCall<Double> {
        private final ByteString imgData1;
        private final FRect detectRect1;
        private final ByteString imgData2;
        private final FRect detectRect2;

        DetectAndCompare2FaceCall(ByteString imgData1, FRect detectRect1, ByteString imgData2, FRect detectRect2, ServiceMethodCallback<Double> callback) {
            super("detectAndCompare2Face", (byte)1, callback);
            this.imgData1 = imgData1;
            this.detectRect1 = detectRect1;
            this.imgData2 = imgData2;
            this.detectRect2 = detectRect2;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData1 != null) {
                protocol.writeFieldBegin("imgData1", 1, (byte)11);
                protocol.writeBinary(this.imgData1);
                protocol.writeFieldEnd();
            }
            if (this.detectRect1 != null) {
                protocol.writeFieldBegin("detectRect1", 2, (byte)12);
                FRect.ADAPTER.write(protocol, (Object)this.detectRect1);
                protocol.writeFieldEnd();
            }
            if (this.imgData2 != null) {
                protocol.writeFieldBegin("imgData2", 3, (byte)11);
                protocol.writeBinary(this.imgData2);
                protocol.writeFieldEnd();
            }
            if (this.detectRect2 != null) {
                protocol.writeFieldBegin("detectRect2", 4, (byte)12);
                FRect.ADAPTER.write(protocol, (Object)this.detectRect2);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Double receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Double result = null;
            ImageErrorException ex1 = null;
            NotFaceDetectedException ex2 = null;
            ServiceRuntimeException ex3 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 4) {
                            double value = protocol.readDouble();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ImageErrorException value;
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        if (field.typeId == 12) {
                            NotFaceDetectedException value;
                            ex2 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex3 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            if (ex3 != null) {
                throw ex3;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CompareFeaturesCall
    extends MethodCall<List<Double>> {
        private final ByteString code1;
        private final List<ByteString> codes;

        CompareFeaturesCall(ByteString code1, List<ByteString> codes, ServiceMethodCallback<List<Double>> callback) {
            super("compareFeatures", (byte)1, callback);
            this.code1 = code1;
            this.codes = codes;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.code1 != null) {
                protocol.writeFieldBegin("code1", 1, (byte)11);
                protocol.writeBinary(this.code1);
                protocol.writeFieldEnd();
            }
            if (this.codes != null) {
                protocol.writeFieldBegin("codes", 2, (byte)15);
                protocol.writeListBegin((byte)11, this.codes.size());
                for (ByteString item0 : this.codes) {
                    protocol.writeBinary(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Double> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Double> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Double> value = new ArrayList<Double>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                double item0 = protocol.readDouble();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CompareFacesCall
    extends MethodCall<CompareResult> {
        private final ByteString code;
        private final ByteString imgData;
        private final Integer faceNum;

        CompareFacesCall(ByteString code, ByteString imgData, Integer faceNum, ServiceMethodCallback<CompareResult> callback) {
            super("compareFaces", (byte)1, callback);
            this.code = code;
            this.imgData = imgData;
            if (faceNum == null) {
                throw new NullPointerException("faceNum");
            }
            this.faceNum = faceNum;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.code != null) {
                protocol.writeFieldBegin("code", 1, (byte)11);
                protocol.writeBinary(this.code);
                protocol.writeFieldEnd();
            }
            if (this.imgData != null) {
                protocol.writeFieldBegin("imgData", 2, (byte)11);
                protocol.writeBinary(this.imgData);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("faceNum", 3, (byte)8);
            protocol.writeI32(this.faceNum.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected CompareResult receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            Object ex3 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (CompareResult)CompareResult.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        Object value;
                        if (field.typeId == 12) {
                            ex3 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            if (ex3 != null) {
                throw ex3;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CompareCodesCall
    extends MethodCall<List<Double>> {
        private final ByteString code1;
        private final List<CodeInfo> codes;

        CompareCodesCall(ByteString code1, List<CodeInfo> codes, ServiceMethodCallback<List<Double>> callback) {
            super("compareCodes", (byte)1, callback);
            this.code1 = code1;
            this.codes = codes;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.code1 != null) {
                protocol.writeFieldBegin("code1", 1, (byte)11);
                protocol.writeBinary(this.code1);
                protocol.writeFieldEnd();
            }
            if (this.codes != null) {
                protocol.writeFieldBegin("codes", 2, (byte)15);
                protocol.writeListBegin((byte)12, this.codes.size());
                for (CodeInfo item0 : this.codes) {
                    CodeInfo.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Double> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Double> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Double> value = new ArrayList<Double>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                double item0 = protocol.readDouble();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CompareCodeCall
    extends MethodCall<Double> {
        private final ByteString code1;
        private final ByteString code2;

        CompareCodeCall(ByteString code1, ByteString code2, ServiceMethodCallback<Double> callback) {
            super("compareCode", (byte)1, callback);
            this.code1 = code1;
            this.code2 = code2;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.code1 != null) {
                protocol.writeFieldBegin("code1", 1, (byte)11);
                protocol.writeBinary(this.code1);
                protocol.writeFieldEnd();
            }
            if (this.code2 != null) {
                protocol.writeFieldBegin("code2", 2, (byte)11);
                protocol.writeBinary(this.code2);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Double receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Double result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 4) {
                            double value = protocol.readDouble();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class Compare2FaceCall
    extends MethodCall<Double> {
        private final ByteString imgData1;
        private final CodeInfo facePos1;
        private final ByteString imgData2;
        private final CodeInfo facePos2;

        Compare2FaceCall(ByteString imgData1, CodeInfo facePos1, ByteString imgData2, CodeInfo facePos2, ServiceMethodCallback<Double> callback) {
            super("compare2Face", (byte)1, callback);
            this.imgData1 = imgData1;
            this.facePos1 = facePos1;
            this.imgData2 = imgData2;
            this.facePos2 = facePos2;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imgData1 != null) {
                protocol.writeFieldBegin("imgData1", 1, (byte)11);
                protocol.writeBinary(this.imgData1);
                protocol.writeFieldEnd();
            }
            if (this.facePos1 != null) {
                protocol.writeFieldBegin("facePos1", 2, (byte)12);
                CodeInfo.ADAPTER.write(protocol, (Object)this.facePos1);
                protocol.writeFieldEnd();
            }
            if (this.imgData2 != null) {
                protocol.writeFieldBegin("imgData2", 3, (byte)11);
                protocol.writeBinary(this.imgData2);
                protocol.writeFieldEnd();
            }
            if (this.facePos2 != null) {
                protocol.writeFieldBegin("facePos2", 4, (byte)12);
                CodeInfo.ADAPTER.write(protocol, (Object)this.facePos2);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Double receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Double result = null;
            ImageErrorException ex1 = null;
            NotFaceDetectedException ex2 = null;
            ServiceRuntimeException ex3 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 4) {
                            double value = protocol.readDouble();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ImageErrorException value;
                            ex1 = value = (ImageErrorException)ImageErrorException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        if (field.typeId == 12) {
                            NotFaceDetectedException value;
                            ex2 = value = (NotFaceDetectedException)NotFaceDetectedException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex3 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            if (ex3 != null) {
                throw ex3;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }
}

