/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.ITableCache;
import net.gdface.facedb.db.TableListener;
import net.gdface.facedb.db.exception.ObjectRetrievalException;

public abstract class BaseJunctionTableCache<K1, K2, B extends BaseBean<B>> {
    private final LoadingCache<Key, B> cache;
    private final ConcurrentMap<Key, B> cacheMap;
    protected final TableListener.Adapter<B> tableListener;
    private final ITableCache.UpdateStrategy updateStrategy;
    private final Function<B, K1> funReturnK1 = new Function<B, K1>(){

        public K1 apply(B input) {
            return BaseJunctionTableCache.this.returnK1(input);
        }
    };
    private final Function<B, K2> funReturnK2 = new Function<B, K2>(){

        public K2 apply(B input) {
            return BaseJunctionTableCache.this.returnK2(input);
        }
    };

    private Key asTmpKey(K1 k1, K2 k2) {
        return new Key(k1, k2);
    }

    protected abstract K1 returnK1(B var1);

    protected abstract K2 returnK2(B var1);

    protected abstract Object loadfromDatabase(Key var1) throws Exception;

    public abstract void registerListener();

    public abstract void unregisterListener();

    public BaseJunctionTableCache() {
        this(10000L, 10L, ITableCache.DEFAULT_TIME_UNIT);
    }

    public BaseJunctionTableCache(long maximumSize) {
        this(maximumSize, 10L, ITableCache.DEFAULT_TIME_UNIT);
    }

    public BaseJunctionTableCache(long maximumSize, long durationMinutes) {
        this(maximumSize, durationMinutes, ITableCache.DEFAULT_TIME_UNIT);
    }

    public BaseJunctionTableCache(long maximumSize, long duration, TimeUnit unit) {
        this(ITableCache.DEFAULT_STRATEGY, maximumSize, duration, unit);
    }

    public BaseJunctionTableCache(ITableCache.UpdateStrategy updateStrategy, long maximumSize, long duration, TimeUnit unit) {
        if (null == updateStrategy) {
            updateStrategy = ITableCache.DEFAULT_STRATEGY;
        }
        if (0L >= maximumSize) {
            maximumSize = 10000L;
        }
        if (0L >= duration) {
            maximumSize = 10L;
        }
        if (null == unit) {
            unit = ITableCache.DEFAULT_TIME_UNIT;
        }
        this.updateStrategy = updateStrategy;
        this.cache = CacheBuilder.newBuilder().maximumSize(maximumSize).expireAfterWrite(duration, unit).build(new CacheLoader<Key, B>(){

            public B load(Key key) throws Exception {
                Object obj = BaseJunctionTableCache.this.loadfromDatabase(key);
                try {
                    return (BaseBean)obj;
                }
                catch (ClassCastException e) {
                    if (obj instanceof Collection) {
                        for (BaseBean bean : (Collection)obj) {
                            BaseJunctionTableCache.this.update(bean);
                        }
                        throw new CollectionReturnException();
                    }
                    throw e;
                }
            }
        });
        this.cacheMap = this.cache.asMap();
        this.tableListener = new TableListener.Adapter<B>(){

            @Override
            public void afterUpdate(B bean) {
                BaseJunctionTableCache.this.update(bean);
            }

            @Override
            public void afterInsert(B bean) {
                BaseJunctionTableCache.this.update(bean);
            }

            @Override
            public void afterDelete(B bean) {
                BaseJunctionTableCache.this.remove(bean);
            }
        };
    }

    private <K> Set<B> filter(final K k, final Function<B, K> fun) {
        return (Set)(null == k ? ImmutableSet.of() : Sets.newHashSet((Iterable)Collections2.filter(this.cacheMap.values(), (Predicate)new Predicate<B>(){

            public boolean apply(B input) {
                return Objects.equals(k, fun.apply(input));
            }
        })));
    }

    public Set<B> getBeansByK1(K1 k1) throws ExecutionException {
        try {
            this.cache.get((Object)this.asTmpKey(k1, null));
            return null;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CollectionReturnException) {
                return this.filter(k1, this.funReturnK1);
            }
            throw e;
        }
    }

    public Set<B> getBeansByK1IfPresent(K1 k1) {
        return this.filter(k1, this.funReturnK1);
    }

    public Set<B> getBeansByK1Unchecked(K1 k1) {
        try {
            this.cache.getUnchecked((Object)this.asTmpKey(k1, null));
            return null;
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof CollectionReturnException) {
                return this.filter(k1, this.funReturnK1);
            }
            throw e;
        }
    }

    public Set<B> getBeansByK2(K2 k2) throws ExecutionException {
        try {
            this.cache.get((Object)this.asTmpKey(null, k2));
            return null;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CollectionReturnException) {
                return this.filter(k2, this.funReturnK2);
            }
            throw e;
        }
    }

    public Set<B> getBeansByK2IfPresent(K2 k2) {
        return this.filter(k2, this.funReturnK2);
    }

    public Set<B> getBeansByK2Unchecked(K2 k2) {
        try {
            this.cache.getUnchecked((Object)this.asTmpKey(null, k2));
            return null;
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof CollectionReturnException) {
                return this.filter(k2, this.funReturnK2);
            }
            throw e;
        }
    }

    public B getBean(K1 k1, K2 k2) throws ExecutionException {
        return (B)((BaseBean)this.cache.get((Object)new Key(Preconditions.checkNotNull(k1), Preconditions.checkNotNull(k2))));
    }

    public B getBeanIfPresent(K1 k1, K2 k2) {
        return (B)(null == k1 || null == k2 ? null : (BaseBean)this.cache.getIfPresent((Object)this.asTmpKey(k1, k2)));
    }

    public B getBeanUnchecked(K1 k1, K2 k2) {
        try {
            return (B)(null == k1 || null == k2 ? null : (BaseBean)this.cache.getUnchecked((Object)new Key(k1, k2)));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof ObjectRetrievalException) {
                return null;
            }
            throw e;
        }
    }

    public void remove(B bean) {
        K1 k1 = this.returnK1(bean);
        K2 k2 = this.returnK2(bean);
        if (null != k1 && null != k2) {
            this.cacheMap.remove(new Key(k1, k2));
        }
    }

    public void update(B bean) {
        K1 k1 = this.returnK1(bean);
        K2 k2 = this.returnK2(bean);
        if (null != k1 && null != k2) {
            if (ITableCache.UpdateStrategy.refresh == this.updateStrategy) {
                this.updateStrategy.update(this.cacheMap, new ReloadEntry(new Key(k1, k2)));
            } else {
                this.updateStrategy.update(this.cacheMap, new ITableCache.ImmutableEntry<Key, B>(new Key(k1, k2), bean));
            }
        }
    }

    public ITableCache.UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    private class ReloadEntry
    extends ITableCache.ImmutableEntry<Key, B> {
        public ReloadEntry(Key key) {
            super(key);
        }

        @Override
        public B reload() throws Exception {
            return (BaseBean)BaseJunctionTableCache.this.loadfromDatabase((Key)this.getKey());
        }
    }

    public final class Key {
        public K1 k1;
        public K2 k2;

        Key(K1 k1, K2 k2) {
            this.k1 = k1;
            this.k2 = k2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.k1 == null ? 0 : this.k1.hashCode());
            result = 31 * result + (this.k2 == null ? 0 : this.k2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || Key.class != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.k1, other.k1) && Objects.equals(this.k2, other.k2);
        }
    }

    private static class CollectionReturnException
    extends Exception {
        private CollectionReturnException() {
        }
    }
}

