/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.ITableCache;
import net.gdface.facedb.db.TableListener;
import net.gdface.facedb.db.exception.ObjectRetrievalException;

public abstract class BaseTableLoadCaching<K, B extends BaseBean<B>>
implements ITableCache<K, B> {
    private final LoadingCache<K, B> cache;
    protected final ConcurrentMap<K, B> cacheMap;
    protected final TableListener.Adapter<B> tableListener;
    private final ITableCache.UpdateStrategy updateStrategy;

    protected abstract K returnKey(B var1);

    protected abstract B loadfromDatabase(K var1) throws Exception;

    public BaseTableLoadCaching() {
        this(10000L, 10L, DEFAULT_TIME_UNIT);
    }

    public BaseTableLoadCaching(long maximumSize) {
        this(maximumSize, 10L, DEFAULT_TIME_UNIT);
    }

    public BaseTableLoadCaching(long maximumSize, long durationMinutes) {
        this(maximumSize, durationMinutes, DEFAULT_TIME_UNIT);
    }

    public BaseTableLoadCaching(long maximumSize, long duration, TimeUnit unit) {
        this(DEFAULT_STRATEGY, maximumSize, duration, unit);
    }

    public BaseTableLoadCaching(ITableCache.UpdateStrategy updateStrategy, long maximumSize, long duration, TimeUnit unit) {
        if (null == updateStrategy) {
            updateStrategy = DEFAULT_STRATEGY;
        }
        if (0L >= maximumSize) {
            maximumSize = 10000L;
        }
        if (0L >= duration) {
            maximumSize = 10L;
        }
        if (null == unit) {
            unit = DEFAULT_TIME_UNIT;
        }
        this.updateStrategy = updateStrategy;
        this.cache = CacheBuilder.newBuilder().maximumSize(maximumSize).expireAfterWrite(duration, unit).build(new CacheLoader<K, B>(){

            public B load(K key) throws Exception {
                return BaseTableLoadCaching.this.loadfromDatabase(key);
            }
        });
        this.cacheMap = this.cache.asMap();
        this.tableListener = new TableListener.Adapter<B>(){

            @Override
            public void afterUpdate(B bean) {
                BaseTableLoadCaching.this.update(bean);
            }

            @Override
            public void afterInsert(B bean) {
                BaseTableLoadCaching.this.update(bean);
            }

            @Override
            public void afterDelete(B bean) {
                BaseTableLoadCaching.this.cacheMap.remove(BaseTableLoadCaching.this.returnKey(bean));
            }
        };
    }

    @Override
    public B getBean(K key) throws ExecutionException {
        return (B)((BaseBean)this.cache.get(key));
    }

    @Override
    public B getBeanIfPresent(K key) {
        return (B)(null == key ? null : (BaseBean)this.cache.getIfPresent(key));
    }

    @Override
    public B getBeanUnchecked(K key) {
        try {
            return (B)((BaseBean)this.cache.getUnchecked(key));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof ObjectRetrievalException) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void remove(B bean) {
        this.cacheMap.remove(this.returnKey(bean));
    }

    @Override
    public void update(B bean) {
        if (ITableCache.UpdateStrategy.refresh == this.updateStrategy) {
            this.updateStrategy.update(this.cacheMap, new ReloadEntry(this.returnKey(bean)));
        } else {
            this.updateStrategy.update(this.cacheMap, new ITableCache.ImmutableEntry<K, B>(this.returnKey(bean), bean));
        }
    }

    public ITableCache.UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    private class ReloadEntry
    extends ITableCache.ImmutableEntry<K, B> {
        public ReloadEntry(K key) {
            super(key);
        }

        @Override
        public B reload() throws Exception {
            return BaseTableLoadCaching.this.loadfromDatabase(this.getKey());
        }
    }
}

