/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.gdface.facedb.db.Constant;
import net.gdface.facedb.db.FaceBean;
import net.gdface.facedb.db.FeatureBean;
import net.gdface.facedb.db.IBeanConverter;
import net.gdface.facedb.db.ImageBean;
import net.gdface.facedb.db.StoreBean;

public class BeanConverterUtils
implements Constant {
    public static final String GET_INITIALIZED = "getInitialized";
    public static final String SET_INITIALIZED = "setInitialized";
    public static final String GET_MODIFIED = "getModified";
    public static final String SET_MODIFIED = "setModified";
    public static final String SET_NEW = "setNew";
    public static final String IS_NEW = "isNew";

    private BeanConverterUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] getBytesInBuffer(ByteBuffer buffer) {
        int pos = buffer.position();
        try {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            buffer.position(pos);
        }
    }

    private static final List<Long> toList(long[] array) {
        ArrayList<Long> result = new ArrayList<Long>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.add(new Long(array[i]));
        }
        return result;
    }

    private static final long[] toPrimitive(List<Long> list) {
        long[] dst = new long[list.size()];
        for (int i = 0; i < dst.length; ++i) {
            Long element = list.get(i);
            if (null == element) {
                throw new IllegalArgumentException("can't cast List<Long> to long[] because of null element");
            }
            dst[i] = element;
        }
        return dst;
    }

    private static final <T> T cast(Class<T> type, Object source) {
        try {
            if (null == source && type.isPrimitive()) {
                throw new NullCastPrimitiveException(String.format("can't convert null to primitive type %s", type.getSimpleName()));
            }
            return (T)source;
        }
        catch (ClassCastException cce) {
            if (List.class.isAssignableFrom(type) && null != source && source instanceof long[]) {
                return (T)BeanConverterUtils.toList((long[])source);
            }
            if (long[].class == type && null != source && source instanceof List) {
                return (T)BeanConverterUtils.toPrimitive((List)source);
            }
            if (Date.class.isAssignableFrom(type) && null != source && source instanceof Long) {
                try {
                    return type.getConstructor(Long.TYPE).newInstance(source);
                }
                catch (Exception e) {
                    StringWriter writer = new StringWriter();
                    e.printStackTrace(new PrintWriter(writer));
                    throw new ClassCastException(writer.toString());
                }
            }
            if ((Long.TYPE == type || Long.class == type) && null != source && source instanceof Date) {
                Long time = ((Date)source).getTime();
                return (T)time;
            }
            if (ByteBuffer.class == type && null != source && source instanceof byte[]) {
                return (T)ByteBuffer.wrap((byte[])source);
            }
            if (byte[].class == type && null != source && source instanceof ByteBuffer) {
                return (T)BeanConverterUtils.getBytesInBuffer((ByteBuffer)source);
            }
            throw cce;
        }
    }

    private static final boolean bitCheck(int index, long ... bits) {
        return 0L != (bits[index >> 6] & 1L << (index & 0x3F));
    }

    private static final long[] bitOR(int index, long ... bits) {
        int n = index >> 6;
        bits[n] = bits[n] | 1L << (index & 0x3F);
        return bits;
    }

    public static class StoreBeanConverter<R_STORE>
    extends IBeanConverter.AbstractHandle<StoreBean, R_STORE> {
        private final Map<String, Method> methods = new Hashtable<String, Method>();
        private final Map<String, Integer> rightIndexs = new Hashtable<String, Integer>();
        private final Map<String, Class<?>> setterParams = new Hashtable();

        private boolean bitCheck(String name, long ... bits) {
            Integer id = this.rightIndexs.get(name);
            return null == id ? false : BeanConverterUtils.bitCheck(id, bits);
        }

        private long[] bitOR(String name, long ... bits) {
            return BeanConverterUtils.bitOR(this.rightIndexs.get(name), bits);
        }

        private void getGetter(String name) {
            try {
                this.methods.put(name, this.rightType.getMethod(name, new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        private void getSetter(String name, Class<?> ... types) throws NoSuchMethodException {
            for (Class<?> paramType : types) {
                try {
                    this.methods.put(name, this.rightType.getMethod(name, paramType));
                    this.setterParams.put(name, paramType);
                    return;
                }
                catch (NoSuchMethodException e) {
                }
            }
            throw new NoSuchMethodException();
        }

        private void getSetterNoThrow(String name, Class<?> ... types) {
            try {
                this.getSetter(name, types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public StoreBeanConverter(String javaFields) {
            this.init(javaFields);
        }

        public StoreBeanConverter() {
            this(null);
        }

        public StoreBeanConverter(Class<StoreBean> leftClass, Class<R_STORE> rightClass, String javaFields) {
            super(leftClass, rightClass);
            this.init(javaFields);
        }

        public StoreBeanConverter(Class<StoreBean> leftClass, Class<R_STORE> rightClass) {
            this(leftClass, rightClass, null);
        }

        private void init(String javaFields) {
            if (null == javaFields || javaFields.isEmpty()) {
                javaFields = "md5,encoding,data";
            }
            String[] rightFields = javaFields.split(",");
            for (int i = 0; i < rightFields.length; ++i) {
                String field = rightFields[i].trim();
                if (!field.matches("\\w+")) {
                    throw new IllegalArgumentException("invalid 'javaFields':" + javaFields);
                }
                this.rightIndexs.put(field, i);
            }
            try {
                this.methods.put(BeanConverterUtils.IS_NEW, this.rightType.getMethod(BeanConverterUtils.IS_NEW, new Class[0]));
                this.methods.put(BeanConverterUtils.GET_INITIALIZED, this.rightType.getMethod(BeanConverterUtils.GET_INITIALIZED, new Class[0]));
                this.getSetter(BeanConverterUtils.SET_NEW, Boolean.TYPE);
                if (this.rightIndexs.size() > 64) {
                    this.getSetter(BeanConverterUtils.SET_INITIALIZED, long[].class, List.class);
                } else {
                    this.getSetter(BeanConverterUtils.SET_INITIALIZED, Long.TYPE);
                }
                this.getGetter(BeanConverterUtils.GET_MODIFIED);
                if (this.rightIndexs.size() > 64) {
                    this.getSetter(BeanConverterUtils.SET_MODIFIED, long[].class, List.class);
                } else {
                    this.getSetter(BeanConverterUtils.SET_MODIFIED, Long.TYPE);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.getGetter(Column.md5.getter);
            this.getSetterNoThrow(Column.md5.setter, String.class);
            this.getGetter(Column.encoding.getter);
            this.getSetterNoThrow(Column.encoding.setter, String.class);
            this.getGetter(Column.data.getter);
            this.getSetterNoThrow(Column.data.setter, ByteBuffer.class, byte[].class);
        }

        @Override
        protected void doFromRight(StoreBean left, R_STORE right) {
            try {
                Method getterMethod;
                long[] modified;
                long[] initialized;
                left.resetIsModified();
                long selfModified = 0L;
                if (this.rightIndexs.size() > 64) {
                    initialized = (long[])this.methods.get(BeanConverterUtils.GET_INITIALIZED).invoke(right, new Object[0]);
                    modified = (long[])this.methods.get(BeanConverterUtils.GET_MODIFIED).invoke(right, new Object[0]);
                } else {
                    initialized = new long[]{(Long)this.methods.get(BeanConverterUtils.GET_INITIALIZED).invoke(right, new Object[0])};
                    modified = new long[]{(Long)this.methods.get(BeanConverterUtils.GET_MODIFIED).invoke(right, new Object[0])};
                }
                if (this.bitCheck(Column.md5.name(), initialized) && null != (getterMethod = this.methods.get(Column.md5.getter))) {
                    left.setMd5((String)BeanConverterUtils.cast(String.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.md5.name(), modified)) {
                        selfModified |= 1L;
                    }
                }
                if (this.bitCheck(Column.encoding.name(), initialized) && null != (getterMethod = this.methods.get(Column.encoding.getter))) {
                    left.setEncoding((String)BeanConverterUtils.cast(String.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.encoding.name(), modified)) {
                        selfModified |= 2L;
                    }
                }
                if (this.bitCheck(Column.data.name(), initialized) && null != (getterMethod = this.methods.get(Column.data.getter))) {
                    left.setData((ByteBuffer)BeanConverterUtils.cast(ByteBuffer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.data.name(), modified)) {
                        selfModified |= 4L;
                    }
                }
                left.isNew((Boolean)this.methods.get(BeanConverterUtils.IS_NEW).invoke(right, new Object[0]));
                left.setModified(selfModified);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void doToRight(StoreBean left, R_STORE right) {
            try {
                long[] initialized = new long[this.rightIndexs.size() + 64 - 1 >> 6];
                long[] modified = new long[this.rightIndexs.size() + 64 - 1 >> 6];
                Arrays.fill(initialized, 0L);
                Arrays.fill(modified, 0L);
                Method setterMethod = this.methods.get(Column.md5.setter);
                if (null != setterMethod && left.checkMd5Initialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.md5.setter), left.getMd5()));
                        this.bitOR(Column.md5.name(), initialized);
                        if (left.checkMd5Modified()) {
                            this.bitOR(Column.md5.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.encoding.setter)) && left.checkEncodingInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.encoding.setter), left.getEncoding()));
                        this.bitOR(Column.encoding.name(), initialized);
                        if (left.checkEncodingModified()) {
                            this.bitOR(Column.encoding.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.data.setter)) && left.checkDataInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.data.setter), left.getData()));
                        this.bitOR(Column.data.name(), initialized);
                        if (left.checkDataModified()) {
                            this.bitOR(Column.data.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(BeanConverterUtils.SET_MODIFIED))) {
                    if (initialized.length > 1) {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_MODIFIED), initialized));
                    } else {
                        setterMethod.invoke(right, initialized[0]);
                    }
                }
                this.methods.get(BeanConverterUtils.SET_NEW).invoke(right, left.isNew());
                if (initialized.length > 1) {
                    this.methods.get(BeanConverterUtils.SET_INITIALIZED).invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_INITIALIZED), initialized));
                    this.methods.get(BeanConverterUtils.SET_MODIFIED).invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_MODIFIED), modified));
                } else {
                    this.methods.get(BeanConverterUtils.SET_INITIALIZED).invoke(right, initialized[0]);
                    this.methods.get(BeanConverterUtils.SET_MODIFIED).invoke(right, modified[0]);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static enum Column {
            md5("getMd5", "setMd5"),
            encoding("getEncoding", "setEncoding"),
            data("getData", "setData");

            final String getter;
            final String setter;

            private Column(String getter, String setter) {
                this.getter = setter;
                this.setter = setter;
            }
        }
    }

    public static class ImageBeanConverter<R_IMAGE>
    extends IBeanConverter.AbstractHandle<ImageBean, R_IMAGE> {
        private final Map<String, Method> methods = new Hashtable<String, Method>();
        private final Map<String, Integer> rightIndexs = new Hashtable<String, Integer>();
        private final Map<String, Class<?>> setterParams = new Hashtable();

        private boolean bitCheck(String name, long ... bits) {
            Integer id = this.rightIndexs.get(name);
            return null == id ? false : BeanConverterUtils.bitCheck(id, bits);
        }

        private long[] bitOR(String name, long ... bits) {
            return BeanConverterUtils.bitOR(this.rightIndexs.get(name), bits);
        }

        private void getGetter(String name) {
            try {
                this.methods.put(name, this.rightType.getMethod(name, new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        private void getSetter(String name, Class<?> ... types) throws NoSuchMethodException {
            for (Class<?> paramType : types) {
                try {
                    this.methods.put(name, this.rightType.getMethod(name, paramType));
                    this.setterParams.put(name, paramType);
                    return;
                }
                catch (NoSuchMethodException e) {
                }
            }
            throw new NoSuchMethodException();
        }

        private void getSetterNoThrow(String name, Class<?> ... types) {
            try {
                this.getSetter(name, types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public ImageBeanConverter(String javaFields) {
            this.init(javaFields);
        }

        public ImageBeanConverter() {
            this(null);
        }

        public ImageBeanConverter(Class<ImageBean> leftClass, Class<R_IMAGE> rightClass, String javaFields) {
            super(leftClass, rightClass);
            this.init(javaFields);
        }

        public ImageBeanConverter(Class<ImageBean> leftClass, Class<R_IMAGE> rightClass) {
            this(leftClass, rightClass, null);
        }

        private void init(String javaFields) {
            if (null == javaFields || javaFields.isEmpty()) {
                javaFields = "md5,format,width,height,depth,faceNum,updateTime,createTime";
            }
            String[] rightFields = javaFields.split(",");
            for (int i = 0; i < rightFields.length; ++i) {
                String field = rightFields[i].trim();
                if (!field.matches("\\w+")) {
                    throw new IllegalArgumentException("invalid 'javaFields':" + javaFields);
                }
                this.rightIndexs.put(field, i);
            }
            try {
                this.methods.put(BeanConverterUtils.IS_NEW, this.rightType.getMethod(BeanConverterUtils.IS_NEW, new Class[0]));
                this.methods.put(BeanConverterUtils.GET_INITIALIZED, this.rightType.getMethod(BeanConverterUtils.GET_INITIALIZED, new Class[0]));
                this.getSetter(BeanConverterUtils.SET_NEW, Boolean.TYPE);
                if (this.rightIndexs.size() > 64) {
                    this.getSetter(BeanConverterUtils.SET_INITIALIZED, long[].class, List.class);
                } else {
                    this.getSetter(BeanConverterUtils.SET_INITIALIZED, Long.TYPE);
                }
                this.getGetter(BeanConverterUtils.GET_MODIFIED);
                if (this.rightIndexs.size() > 64) {
                    this.getSetter(BeanConverterUtils.SET_MODIFIED, long[].class, List.class);
                } else {
                    this.getSetter(BeanConverterUtils.SET_MODIFIED, Long.TYPE);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.getGetter(Column.md5.getter);
            this.getSetterNoThrow(Column.md5.setter, String.class);
            this.getGetter(Column.format.getter);
            this.getSetterNoThrow(Column.format.setter, String.class);
            this.getGetter(Column.width.getter);
            this.getSetterNoThrow(Column.width.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.height.getter);
            this.getSetterNoThrow(Column.height.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.depth.getter);
            this.getSetterNoThrow(Column.depth.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.faceNum.getter);
            this.getSetterNoThrow(Column.faceNum.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.updateTime.getter);
            this.getSetterNoThrow(Column.updateTime.setter, Date.class, Long.class, Long.TYPE);
            this.getGetter(Column.createTime.getter);
            this.getSetterNoThrow(Column.createTime.setter, Date.class, Long.class, Long.TYPE);
        }

        @Override
        protected void doFromRight(ImageBean left, R_IMAGE right) {
            try {
                Method getterMethod;
                long[] modified;
                long[] initialized;
                left.resetIsModified();
                long selfModified = 0L;
                if (this.rightIndexs.size() > 64) {
                    initialized = (long[])this.methods.get(BeanConverterUtils.GET_INITIALIZED).invoke(right, new Object[0]);
                    modified = (long[])this.methods.get(BeanConverterUtils.GET_MODIFIED).invoke(right, new Object[0]);
                } else {
                    initialized = new long[]{(Long)this.methods.get(BeanConverterUtils.GET_INITIALIZED).invoke(right, new Object[0])};
                    modified = new long[]{(Long)this.methods.get(BeanConverterUtils.GET_MODIFIED).invoke(right, new Object[0])};
                }
                if (this.bitCheck(Column.md5.name(), initialized) && null != (getterMethod = this.methods.get(Column.md5.getter))) {
                    left.setMd5((String)BeanConverterUtils.cast(String.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.md5.name(), modified)) {
                        selfModified |= 1L;
                    }
                }
                if (this.bitCheck(Column.format.name(), initialized) && null != (getterMethod = this.methods.get(Column.format.getter))) {
                    left.setFormat((String)BeanConverterUtils.cast(String.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.format.name(), modified)) {
                        selfModified |= 2L;
                    }
                }
                if (this.bitCheck(Column.width.name(), initialized) && null != (getterMethod = this.methods.get(Column.width.getter))) {
                    left.setWidth((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.width.name(), modified)) {
                        selfModified |= 4L;
                    }
                }
                if (this.bitCheck(Column.height.name(), initialized) && null != (getterMethod = this.methods.get(Column.height.getter))) {
                    left.setHeight((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.height.name(), modified)) {
                        selfModified |= 8L;
                    }
                }
                if (this.bitCheck(Column.depth.name(), initialized) && null != (getterMethod = this.methods.get(Column.depth.getter))) {
                    left.setDepth((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.depth.name(), modified)) {
                        selfModified |= 0x10L;
                    }
                }
                if (this.bitCheck(Column.faceNum.name(), initialized) && null != (getterMethod = this.methods.get(Column.faceNum.getter))) {
                    left.setFaceNum((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.faceNum.name(), modified)) {
                        selfModified |= 0x20L;
                    }
                }
                if (this.bitCheck(Column.updateTime.name(), initialized) && null != (getterMethod = this.methods.get(Column.updateTime.getter))) {
                    left.setUpdateTime((Date)BeanConverterUtils.cast(Date.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.updateTime.name(), modified)) {
                        selfModified |= 0x40L;
                    }
                }
                if (this.bitCheck(Column.createTime.name(), initialized) && null != (getterMethod = this.methods.get(Column.createTime.getter))) {
                    left.setCreateTime((Date)BeanConverterUtils.cast(Date.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.createTime.name(), modified)) {
                        selfModified |= 0x80L;
                    }
                }
                left.isNew((Boolean)this.methods.get(BeanConverterUtils.IS_NEW).invoke(right, new Object[0]));
                left.setModified(selfModified);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void doToRight(ImageBean left, R_IMAGE right) {
            try {
                long[] initialized = new long[this.rightIndexs.size() + 64 - 1 >> 6];
                long[] modified = new long[this.rightIndexs.size() + 64 - 1 >> 6];
                Arrays.fill(initialized, 0L);
                Arrays.fill(modified, 0L);
                Method setterMethod = this.methods.get(Column.md5.setter);
                if (null != setterMethod && left.checkMd5Initialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.md5.setter), left.getMd5()));
                        this.bitOR(Column.md5.name(), initialized);
                        if (left.checkMd5Modified()) {
                            this.bitOR(Column.md5.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.format.setter)) && left.checkFormatInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.format.setter), left.getFormat()));
                        this.bitOR(Column.format.name(), initialized);
                        if (left.checkFormatModified()) {
                            this.bitOR(Column.format.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.width.setter)) && left.checkWidthInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.width.setter), left.getWidth()));
                        this.bitOR(Column.width.name(), initialized);
                        if (left.checkWidthModified()) {
                            this.bitOR(Column.width.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.height.setter)) && left.checkHeightInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.height.setter), left.getHeight()));
                        this.bitOR(Column.height.name(), initialized);
                        if (left.checkHeightModified()) {
                            this.bitOR(Column.height.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.depth.setter)) && left.checkDepthInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.depth.setter), left.getDepth()));
                        this.bitOR(Column.depth.name(), initialized);
                        if (left.checkDepthModified()) {
                            this.bitOR(Column.depth.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.faceNum.setter)) && left.checkFaceNumInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.faceNum.setter), left.getFaceNum()));
                        this.bitOR(Column.faceNum.name(), initialized);
                        if (left.checkFaceNumModified()) {
                            this.bitOR(Column.faceNum.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(BeanConverterUtils.SET_MODIFIED))) {
                    if (initialized.length > 1) {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_MODIFIED), initialized));
                    } else {
                        setterMethod.invoke(right, initialized[0]);
                    }
                }
                this.methods.get(BeanConverterUtils.SET_NEW).invoke(right, left.isNew());
                if (initialized.length > 1) {
                    this.methods.get(BeanConverterUtils.SET_INITIALIZED).invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_INITIALIZED), initialized));
                    this.methods.get(BeanConverterUtils.SET_MODIFIED).invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_MODIFIED), modified));
                } else {
                    this.methods.get(BeanConverterUtils.SET_INITIALIZED).invoke(right, initialized[0]);
                    this.methods.get(BeanConverterUtils.SET_MODIFIED).invoke(right, modified[0]);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static enum Column {
            md5("getMd5", "setMd5"),
            format("getFormat", "setFormat"),
            width("getWidth", "setWidth"),
            height("getHeight", "setHeight"),
            depth("getDepth", "setDepth"),
            faceNum("getFaceNum", "setFaceNum"),
            updateTime("getUpdateTime", "setUpdateTime"),
            createTime("getCreateTime", "setCreateTime");

            final String getter;
            final String setter;

            private Column(String getter, String setter) {
                this.getter = setter;
                this.setter = setter;
            }
        }
    }

    public static class FeatureBeanConverter<R_FEATURE>
    extends IBeanConverter.AbstractHandle<FeatureBean, R_FEATURE> {
        private final Map<String, Method> methods = new Hashtable<String, Method>();
        private final Map<String, Integer> rightIndexs = new Hashtable<String, Integer>();
        private final Map<String, Class<?>> setterParams = new Hashtable();

        private boolean bitCheck(String name, long ... bits) {
            Integer id = this.rightIndexs.get(name);
            return null == id ? false : BeanConverterUtils.bitCheck(id, bits);
        }

        private long[] bitOR(String name, long ... bits) {
            return BeanConverterUtils.bitOR(this.rightIndexs.get(name), bits);
        }

        private void getGetter(String name) {
            try {
                this.methods.put(name, this.rightType.getMethod(name, new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        private void getSetter(String name, Class<?> ... types) throws NoSuchMethodException {
            for (Class<?> paramType : types) {
                try {
                    this.methods.put(name, this.rightType.getMethod(name, paramType));
                    this.setterParams.put(name, paramType);
                    return;
                }
                catch (NoSuchMethodException e) {
                }
            }
            throw new NoSuchMethodException();
        }

        private void getSetterNoThrow(String name, Class<?> ... types) {
            try {
                this.getSetter(name, types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public FeatureBeanConverter(String javaFields) {
            this.init(javaFields);
        }

        public FeatureBeanConverter() {
            this(null);
        }

        public FeatureBeanConverter(Class<FeatureBean> leftClass, Class<R_FEATURE> rightClass, String javaFields) {
            super(leftClass, rightClass);
            this.init(javaFields);
        }

        public FeatureBeanConverter(Class<FeatureBean> leftClass, Class<R_FEATURE> rightClass) {
            this(leftClass, rightClass, null);
        }

        private void init(String javaFields) {
            if (null == javaFields || javaFields.isEmpty()) {
                javaFields = "md5,feature,createTime";
            }
            String[] rightFields = javaFields.split(",");
            for (int i = 0; i < rightFields.length; ++i) {
                String field = rightFields[i].trim();
                if (!field.matches("\\w+")) {
                    throw new IllegalArgumentException("invalid 'javaFields':" + javaFields);
                }
                this.rightIndexs.put(field, i);
            }
            try {
                this.methods.put(BeanConverterUtils.IS_NEW, this.rightType.getMethod(BeanConverterUtils.IS_NEW, new Class[0]));
                this.methods.put(BeanConverterUtils.GET_INITIALIZED, this.rightType.getMethod(BeanConverterUtils.GET_INITIALIZED, new Class[0]));
                this.getSetter(BeanConverterUtils.SET_NEW, Boolean.TYPE);
                if (this.rightIndexs.size() > 64) {
                    this.getSetter(BeanConverterUtils.SET_INITIALIZED, long[].class, List.class);
                } else {
                    this.getSetter(BeanConverterUtils.SET_INITIALIZED, Long.TYPE);
                }
                this.getGetter(BeanConverterUtils.GET_MODIFIED);
                if (this.rightIndexs.size() > 64) {
                    this.getSetter(BeanConverterUtils.SET_MODIFIED, long[].class, List.class);
                } else {
                    this.getSetter(BeanConverterUtils.SET_MODIFIED, Long.TYPE);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.getGetter(Column.md5.getter);
            this.getSetterNoThrow(Column.md5.setter, String.class);
            this.getGetter(Column.feature.getter);
            this.getSetterNoThrow(Column.feature.setter, ByteBuffer.class, byte[].class);
            this.getGetter(Column.createTime.getter);
            this.getSetterNoThrow(Column.createTime.setter, Date.class, Long.class, Long.TYPE);
        }

        @Override
        protected void doFromRight(FeatureBean left, R_FEATURE right) {
            try {
                Method getterMethod;
                long[] modified;
                long[] initialized;
                left.resetIsModified();
                long selfModified = 0L;
                if (this.rightIndexs.size() > 64) {
                    initialized = (long[])this.methods.get(BeanConverterUtils.GET_INITIALIZED).invoke(right, new Object[0]);
                    modified = (long[])this.methods.get(BeanConverterUtils.GET_MODIFIED).invoke(right, new Object[0]);
                } else {
                    initialized = new long[]{(Long)this.methods.get(BeanConverterUtils.GET_INITIALIZED).invoke(right, new Object[0])};
                    modified = new long[]{(Long)this.methods.get(BeanConverterUtils.GET_MODIFIED).invoke(right, new Object[0])};
                }
                if (this.bitCheck(Column.md5.name(), initialized) && null != (getterMethod = this.methods.get(Column.md5.getter))) {
                    left.setMd5((String)BeanConverterUtils.cast(String.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.md5.name(), modified)) {
                        selfModified |= 1L;
                    }
                }
                if (this.bitCheck(Column.feature.name(), initialized) && null != (getterMethod = this.methods.get(Column.feature.getter))) {
                    left.setFeature((ByteBuffer)BeanConverterUtils.cast(ByteBuffer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.feature.name(), modified)) {
                        selfModified |= 2L;
                    }
                }
                if (this.bitCheck(Column.createTime.name(), initialized) && null != (getterMethod = this.methods.get(Column.createTime.getter))) {
                    left.setCreateTime((Date)BeanConverterUtils.cast(Date.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.createTime.name(), modified)) {
                        selfModified |= 4L;
                    }
                }
                left.isNew((Boolean)this.methods.get(BeanConverterUtils.IS_NEW).invoke(right, new Object[0]));
                left.setModified(selfModified);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void doToRight(FeatureBean left, R_FEATURE right) {
            try {
                long[] initialized = new long[this.rightIndexs.size() + 64 - 1 >> 6];
                long[] modified = new long[this.rightIndexs.size() + 64 - 1 >> 6];
                Arrays.fill(initialized, 0L);
                Arrays.fill(modified, 0L);
                Method setterMethod = this.methods.get(Column.md5.setter);
                if (null != setterMethod && left.checkMd5Initialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.md5.setter), left.getMd5()));
                        this.bitOR(Column.md5.name(), initialized);
                        if (left.checkMd5Modified()) {
                            this.bitOR(Column.md5.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.feature.setter)) && left.checkFeatureInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.feature.setter), left.getFeature()));
                        this.bitOR(Column.feature.name(), initialized);
                        if (left.checkFeatureModified()) {
                            this.bitOR(Column.feature.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(BeanConverterUtils.SET_MODIFIED))) {
                    if (initialized.length > 1) {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_MODIFIED), initialized));
                    } else {
                        setterMethod.invoke(right, initialized[0]);
                    }
                }
                this.methods.get(BeanConverterUtils.SET_NEW).invoke(right, left.isNew());
                if (initialized.length > 1) {
                    this.methods.get(BeanConverterUtils.SET_INITIALIZED).invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_INITIALIZED), initialized));
                    this.methods.get(BeanConverterUtils.SET_MODIFIED).invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_MODIFIED), modified));
                } else {
                    this.methods.get(BeanConverterUtils.SET_INITIALIZED).invoke(right, initialized[0]);
                    this.methods.get(BeanConverterUtils.SET_MODIFIED).invoke(right, modified[0]);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static enum Column {
            md5("getMd5", "setMd5"),
            feature("getFeature", "setFeature"),
            createTime("getCreateTime", "setCreateTime");

            final String getter;
            final String setter;

            private Column(String getter, String setter) {
                this.getter = setter;
                this.setter = setter;
            }
        }
    }

    public static class FaceBeanConverter<R_FACE>
    extends IBeanConverter.AbstractHandle<FaceBean, R_FACE> {
        private final Map<String, Method> methods = new Hashtable<String, Method>();
        private final Map<String, Integer> rightIndexs = new Hashtable<String, Integer>();
        private final Map<String, Class<?>> setterParams = new Hashtable();

        private boolean bitCheck(String name, long ... bits) {
            Integer id = this.rightIndexs.get(name);
            return null == id ? false : BeanConverterUtils.bitCheck(id, bits);
        }

        private long[] bitOR(String name, long ... bits) {
            return BeanConverterUtils.bitOR(this.rightIndexs.get(name), bits);
        }

        private void getGetter(String name) {
            try {
                this.methods.put(name, this.rightType.getMethod(name, new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        private void getSetter(String name, Class<?> ... types) throws NoSuchMethodException {
            for (Class<?> paramType : types) {
                try {
                    this.methods.put(name, this.rightType.getMethod(name, paramType));
                    this.setterParams.put(name, paramType);
                    return;
                }
                catch (NoSuchMethodException e) {
                }
            }
            throw new NoSuchMethodException();
        }

        private void getSetterNoThrow(String name, Class<?> ... types) {
            try {
                this.getSetter(name, types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public FaceBeanConverter(String javaFields) {
            this.init(javaFields);
        }

        public FaceBeanConverter() {
            this(null);
        }

        public FaceBeanConverter(Class<FaceBean> leftClass, Class<R_FACE> rightClass, String javaFields) {
            super(leftClass, rightClass);
            this.init(javaFields);
        }

        public FaceBeanConverter(Class<FaceBean> leftClass, Class<R_FACE> rightClass) {
            this(leftClass, rightClass, null);
        }

        private void init(String javaFields) {
            if (null == javaFields || javaFields.isEmpty()) {
                javaFields = "id,imageMd5,featureMd5,faceLeft,faceTop,faceWidth,faceHeight,eyeLeftx,eyeLefty,eyeRightx,eyeRighty,mouthX,mouthY,noseX,noseY,angleYaw,anglePitch,angleRoll,angleConfidence,extInfo,createTime";
            }
            String[] rightFields = javaFields.split(",");
            for (int i = 0; i < rightFields.length; ++i) {
                String field = rightFields[i].trim();
                if (!field.matches("\\w+")) {
                    throw new IllegalArgumentException("invalid 'javaFields':" + javaFields);
                }
                this.rightIndexs.put(field, i);
            }
            try {
                this.methods.put(BeanConverterUtils.IS_NEW, this.rightType.getMethod(BeanConverterUtils.IS_NEW, new Class[0]));
                this.methods.put(BeanConverterUtils.GET_INITIALIZED, this.rightType.getMethod(BeanConverterUtils.GET_INITIALIZED, new Class[0]));
                this.getSetter(BeanConverterUtils.SET_NEW, Boolean.TYPE);
                if (this.rightIndexs.size() > 64) {
                    this.getSetter(BeanConverterUtils.SET_INITIALIZED, long[].class, List.class);
                } else {
                    this.getSetter(BeanConverterUtils.SET_INITIALIZED, Long.TYPE);
                }
                this.getGetter(BeanConverterUtils.GET_MODIFIED);
                if (this.rightIndexs.size() > 64) {
                    this.getSetter(BeanConverterUtils.SET_MODIFIED, long[].class, List.class);
                } else {
                    this.getSetter(BeanConverterUtils.SET_MODIFIED, Long.TYPE);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.getGetter(Column.id.getter);
            this.getSetterNoThrow(Column.id.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.imageMd5.getter);
            this.getSetterNoThrow(Column.imageMd5.setter, String.class);
            this.getGetter(Column.featureMd5.getter);
            this.getSetterNoThrow(Column.featureMd5.setter, String.class);
            this.getGetter(Column.faceLeft.getter);
            this.getSetterNoThrow(Column.faceLeft.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.faceTop.getter);
            this.getSetterNoThrow(Column.faceTop.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.faceWidth.getter);
            this.getSetterNoThrow(Column.faceWidth.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.faceHeight.getter);
            this.getSetterNoThrow(Column.faceHeight.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.eyeLeftx.getter);
            this.getSetterNoThrow(Column.eyeLeftx.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.eyeLefty.getter);
            this.getSetterNoThrow(Column.eyeLefty.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.eyeRightx.getter);
            this.getSetterNoThrow(Column.eyeRightx.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.eyeRighty.getter);
            this.getSetterNoThrow(Column.eyeRighty.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.mouthX.getter);
            this.getSetterNoThrow(Column.mouthX.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.mouthY.getter);
            this.getSetterNoThrow(Column.mouthY.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.noseX.getter);
            this.getSetterNoThrow(Column.noseX.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.noseY.getter);
            this.getSetterNoThrow(Column.noseY.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.angleYaw.getter);
            this.getSetterNoThrow(Column.angleYaw.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.anglePitch.getter);
            this.getSetterNoThrow(Column.anglePitch.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.angleRoll.getter);
            this.getSetterNoThrow(Column.angleRoll.setter, Integer.class, Integer.TYPE);
            this.getGetter(Column.angleConfidence.getter);
            this.getSetterNoThrow(Column.angleConfidence.setter, Float.class, Float.TYPE);
            this.getGetter(Column.extInfo.getter);
            this.getSetterNoThrow(Column.extInfo.setter, ByteBuffer.class, byte[].class);
            this.getGetter(Column.createTime.getter);
            this.getSetterNoThrow(Column.createTime.setter, Date.class, Long.class, Long.TYPE);
        }

        @Override
        protected void doFromRight(FaceBean left, R_FACE right) {
            try {
                Method getterMethod;
                long[] modified;
                long[] initialized;
                left.resetIsModified();
                long selfModified = 0L;
                if (this.rightIndexs.size() > 64) {
                    initialized = (long[])this.methods.get(BeanConverterUtils.GET_INITIALIZED).invoke(right, new Object[0]);
                    modified = (long[])this.methods.get(BeanConverterUtils.GET_MODIFIED).invoke(right, new Object[0]);
                } else {
                    initialized = new long[]{(Long)this.methods.get(BeanConverterUtils.GET_INITIALIZED).invoke(right, new Object[0])};
                    modified = new long[]{(Long)this.methods.get(BeanConverterUtils.GET_MODIFIED).invoke(right, new Object[0])};
                }
                if (this.bitCheck(Column.id.name(), initialized) && null != (getterMethod = this.methods.get(Column.id.getter))) {
                    left.setId((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.id.name(), modified)) {
                        selfModified |= 1L;
                    }
                }
                if (this.bitCheck(Column.imageMd5.name(), initialized) && null != (getterMethod = this.methods.get(Column.imageMd5.getter))) {
                    left.setImageMd5((String)BeanConverterUtils.cast(String.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.imageMd5.name(), modified)) {
                        selfModified |= 2L;
                    }
                }
                if (this.bitCheck(Column.featureMd5.name(), initialized) && null != (getterMethod = this.methods.get(Column.featureMd5.getter))) {
                    left.setFeatureMd5((String)BeanConverterUtils.cast(String.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.featureMd5.name(), modified)) {
                        selfModified |= 4L;
                    }
                }
                if (this.bitCheck(Column.faceLeft.name(), initialized) && null != (getterMethod = this.methods.get(Column.faceLeft.getter))) {
                    left.setFaceLeft((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.faceLeft.name(), modified)) {
                        selfModified |= 8L;
                    }
                }
                if (this.bitCheck(Column.faceTop.name(), initialized) && null != (getterMethod = this.methods.get(Column.faceTop.getter))) {
                    left.setFaceTop((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.faceTop.name(), modified)) {
                        selfModified |= 0x10L;
                    }
                }
                if (this.bitCheck(Column.faceWidth.name(), initialized) && null != (getterMethod = this.methods.get(Column.faceWidth.getter))) {
                    left.setFaceWidth((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.faceWidth.name(), modified)) {
                        selfModified |= 0x20L;
                    }
                }
                if (this.bitCheck(Column.faceHeight.name(), initialized) && null != (getterMethod = this.methods.get(Column.faceHeight.getter))) {
                    left.setFaceHeight((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.faceHeight.name(), modified)) {
                        selfModified |= 0x40L;
                    }
                }
                if (this.bitCheck(Column.eyeLeftx.name(), initialized) && null != (getterMethod = this.methods.get(Column.eyeLeftx.getter))) {
                    left.setEyeLeftx((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.eyeLeftx.name(), modified)) {
                        selfModified |= 0x80L;
                    }
                }
                if (this.bitCheck(Column.eyeLefty.name(), initialized) && null != (getterMethod = this.methods.get(Column.eyeLefty.getter))) {
                    left.setEyeLefty((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.eyeLefty.name(), modified)) {
                        selfModified |= 0x100L;
                    }
                }
                if (this.bitCheck(Column.eyeRightx.name(), initialized) && null != (getterMethod = this.methods.get(Column.eyeRightx.getter))) {
                    left.setEyeRightx((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.eyeRightx.name(), modified)) {
                        selfModified |= 0x200L;
                    }
                }
                if (this.bitCheck(Column.eyeRighty.name(), initialized) && null != (getterMethod = this.methods.get(Column.eyeRighty.getter))) {
                    left.setEyeRighty((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.eyeRighty.name(), modified)) {
                        selfModified |= 0x400L;
                    }
                }
                if (this.bitCheck(Column.mouthX.name(), initialized) && null != (getterMethod = this.methods.get(Column.mouthX.getter))) {
                    left.setMouthX((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.mouthX.name(), modified)) {
                        selfModified |= 0x800L;
                    }
                }
                if (this.bitCheck(Column.mouthY.name(), initialized) && null != (getterMethod = this.methods.get(Column.mouthY.getter))) {
                    left.setMouthY((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.mouthY.name(), modified)) {
                        selfModified |= 0x1000L;
                    }
                }
                if (this.bitCheck(Column.noseX.name(), initialized) && null != (getterMethod = this.methods.get(Column.noseX.getter))) {
                    left.setNoseX((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.noseX.name(), modified)) {
                        selfModified |= 0x2000L;
                    }
                }
                if (this.bitCheck(Column.noseY.name(), initialized) && null != (getterMethod = this.methods.get(Column.noseY.getter))) {
                    left.setNoseY((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.noseY.name(), modified)) {
                        selfModified |= 0x4000L;
                    }
                }
                if (this.bitCheck(Column.angleYaw.name(), initialized) && null != (getterMethod = this.methods.get(Column.angleYaw.getter))) {
                    left.setAngleYaw((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.angleYaw.name(), modified)) {
                        selfModified |= 0x8000L;
                    }
                }
                if (this.bitCheck(Column.anglePitch.name(), initialized) && null != (getterMethod = this.methods.get(Column.anglePitch.getter))) {
                    left.setAnglePitch((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.anglePitch.name(), modified)) {
                        selfModified |= 0x10000L;
                    }
                }
                if (this.bitCheck(Column.angleRoll.name(), initialized) && null != (getterMethod = this.methods.get(Column.angleRoll.getter))) {
                    left.setAngleRoll((Integer)BeanConverterUtils.cast(Integer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.angleRoll.name(), modified)) {
                        selfModified |= 0x20000L;
                    }
                }
                if (this.bitCheck(Column.angleConfidence.name(), initialized) && null != (getterMethod = this.methods.get(Column.angleConfidence.getter))) {
                    left.setAngleConfidence((Float)BeanConverterUtils.cast(Float.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.angleConfidence.name(), modified)) {
                        selfModified |= 0x40000L;
                    }
                }
                if (this.bitCheck(Column.extInfo.name(), initialized) && null != (getterMethod = this.methods.get(Column.extInfo.getter))) {
                    left.setExtInfo((ByteBuffer)BeanConverterUtils.cast(ByteBuffer.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.extInfo.name(), modified)) {
                        selfModified |= 0x80000L;
                    }
                }
                if (this.bitCheck(Column.createTime.name(), initialized) && null != (getterMethod = this.methods.get(Column.createTime.getter))) {
                    left.setCreateTime((Date)BeanConverterUtils.cast(Date.class, getterMethod.invoke(right, new Object[0])));
                    if (this.bitCheck(Column.createTime.name(), modified)) {
                        selfModified |= 0x100000L;
                    }
                }
                left.isNew((Boolean)this.methods.get(BeanConverterUtils.IS_NEW).invoke(right, new Object[0]));
                left.setModified(selfModified);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void doToRight(FaceBean left, R_FACE right) {
            try {
                long[] initialized = new long[this.rightIndexs.size() + 64 - 1 >> 6];
                long[] modified = new long[this.rightIndexs.size() + 64 - 1 >> 6];
                Arrays.fill(initialized, 0L);
                Arrays.fill(modified, 0L);
                Method setterMethod = this.methods.get(Column.id.setter);
                if (null != setterMethod && left.checkIdInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.id.setter), left.getId()));
                        this.bitOR(Column.id.name(), initialized);
                        if (left.checkIdModified()) {
                            this.bitOR(Column.id.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.imageMd5.setter)) && left.checkImageMd5Initialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.imageMd5.setter), left.getImageMd5()));
                        this.bitOR(Column.imageMd5.name(), initialized);
                        if (left.checkImageMd5Modified()) {
                            this.bitOR(Column.imageMd5.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.featureMd5.setter)) && left.checkFeatureMd5Initialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.featureMd5.setter), left.getFeatureMd5()));
                        this.bitOR(Column.featureMd5.name(), initialized);
                        if (left.checkFeatureMd5Modified()) {
                            this.bitOR(Column.featureMd5.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.faceLeft.setter)) && left.checkFaceLeftInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.faceLeft.setter), left.getFaceLeft()));
                        this.bitOR(Column.faceLeft.name(), initialized);
                        if (left.checkFaceLeftModified()) {
                            this.bitOR(Column.faceLeft.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.faceTop.setter)) && left.checkFaceTopInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.faceTop.setter), left.getFaceTop()));
                        this.bitOR(Column.faceTop.name(), initialized);
                        if (left.checkFaceTopModified()) {
                            this.bitOR(Column.faceTop.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.faceWidth.setter)) && left.checkFaceWidthInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.faceWidth.setter), left.getFaceWidth()));
                        this.bitOR(Column.faceWidth.name(), initialized);
                        if (left.checkFaceWidthModified()) {
                            this.bitOR(Column.faceWidth.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.faceHeight.setter)) && left.checkFaceHeightInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.faceHeight.setter), left.getFaceHeight()));
                        this.bitOR(Column.faceHeight.name(), initialized);
                        if (left.checkFaceHeightModified()) {
                            this.bitOR(Column.faceHeight.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.eyeLeftx.setter)) && left.checkEyeLeftxInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.eyeLeftx.setter), left.getEyeLeftx()));
                        this.bitOR(Column.eyeLeftx.name(), initialized);
                        if (left.checkEyeLeftxModified()) {
                            this.bitOR(Column.eyeLeftx.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.eyeLefty.setter)) && left.checkEyeLeftyInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.eyeLefty.setter), left.getEyeLefty()));
                        this.bitOR(Column.eyeLefty.name(), initialized);
                        if (left.checkEyeLeftyModified()) {
                            this.bitOR(Column.eyeLefty.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.eyeRightx.setter)) && left.checkEyeRightxInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.eyeRightx.setter), left.getEyeRightx()));
                        this.bitOR(Column.eyeRightx.name(), initialized);
                        if (left.checkEyeRightxModified()) {
                            this.bitOR(Column.eyeRightx.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.eyeRighty.setter)) && left.checkEyeRightyInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.eyeRighty.setter), left.getEyeRighty()));
                        this.bitOR(Column.eyeRighty.name(), initialized);
                        if (left.checkEyeRightyModified()) {
                            this.bitOR(Column.eyeRighty.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.mouthX.setter)) && left.checkMouthXInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.mouthX.setter), left.getMouthX()));
                        this.bitOR(Column.mouthX.name(), initialized);
                        if (left.checkMouthXModified()) {
                            this.bitOR(Column.mouthX.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.mouthY.setter)) && left.checkMouthYInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.mouthY.setter), left.getMouthY()));
                        this.bitOR(Column.mouthY.name(), initialized);
                        if (left.checkMouthYModified()) {
                            this.bitOR(Column.mouthY.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.noseX.setter)) && left.checkNoseXInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.noseX.setter), left.getNoseX()));
                        this.bitOR(Column.noseX.name(), initialized);
                        if (left.checkNoseXModified()) {
                            this.bitOR(Column.noseX.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.noseY.setter)) && left.checkNoseYInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.noseY.setter), left.getNoseY()));
                        this.bitOR(Column.noseY.name(), initialized);
                        if (left.checkNoseYModified()) {
                            this.bitOR(Column.noseY.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.angleYaw.setter)) && left.checkAngleYawInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.angleYaw.setter), left.getAngleYaw()));
                        this.bitOR(Column.angleYaw.name(), initialized);
                        if (left.checkAngleYawModified()) {
                            this.bitOR(Column.angleYaw.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.anglePitch.setter)) && left.checkAnglePitchInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.anglePitch.setter), left.getAnglePitch()));
                        this.bitOR(Column.anglePitch.name(), initialized);
                        if (left.checkAnglePitchModified()) {
                            this.bitOR(Column.anglePitch.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.angleRoll.setter)) && left.checkAngleRollInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.angleRoll.setter), left.getAngleRoll()));
                        this.bitOR(Column.angleRoll.name(), initialized);
                        if (left.checkAngleRollModified()) {
                            this.bitOR(Column.angleRoll.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.angleConfidence.setter)) && left.checkAngleConfidenceInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.angleConfidence.setter), left.getAngleConfidence()));
                        this.bitOR(Column.angleConfidence.name(), initialized);
                        if (left.checkAngleConfidenceModified()) {
                            this.bitOR(Column.angleConfidence.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(Column.extInfo.setter)) && left.checkExtInfoInitialized()) {
                    try {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(Column.extInfo.setter), left.getExtInfo()));
                        this.bitOR(Column.extInfo.name(), initialized);
                        if (left.checkExtInfoModified()) {
                            this.bitOR(Column.extInfo.name(), modified);
                        }
                    }
                    catch (NullCastPrimitiveException e) {
                        // empty catch block
                    }
                }
                if (null != (setterMethod = this.methods.get(BeanConverterUtils.SET_MODIFIED))) {
                    if (initialized.length > 1) {
                        setterMethod.invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_MODIFIED), initialized));
                    } else {
                        setterMethod.invoke(right, initialized[0]);
                    }
                }
                this.methods.get(BeanConverterUtils.SET_NEW).invoke(right, left.isNew());
                if (initialized.length > 1) {
                    this.methods.get(BeanConverterUtils.SET_INITIALIZED).invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_INITIALIZED), initialized));
                    this.methods.get(BeanConverterUtils.SET_MODIFIED).invoke(right, BeanConverterUtils.cast(this.setterParams.get(BeanConverterUtils.SET_MODIFIED), modified));
                } else {
                    this.methods.get(BeanConverterUtils.SET_INITIALIZED).invoke(right, initialized[0]);
                    this.methods.get(BeanConverterUtils.SET_MODIFIED).invoke(right, modified[0]);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static enum Column {
            id("getId", "setId"),
            imageMd5("getImageMd5", "setImageMd5"),
            featureMd5("getFeatureMd5", "setFeatureMd5"),
            faceLeft("getFaceLeft", "setFaceLeft"),
            faceTop("getFaceTop", "setFaceTop"),
            faceWidth("getFaceWidth", "setFaceWidth"),
            faceHeight("getFaceHeight", "setFaceHeight"),
            eyeLeftx("getEyeLeftx", "setEyeLeftx"),
            eyeLefty("getEyeLefty", "setEyeLefty"),
            eyeRightx("getEyeRightx", "setEyeRightx"),
            eyeRighty("getEyeRighty", "setEyeRighty"),
            mouthX("getMouthX", "setMouthX"),
            mouthY("getMouthY", "setMouthY"),
            noseX("getNoseX", "setNoseX"),
            noseY("getNoseY", "setNoseY"),
            angleYaw("getAngleYaw", "setAngleYaw"),
            anglePitch("getAnglePitch", "setAnglePitch"),
            angleRoll("getAngleRoll", "setAngleRoll"),
            angleConfidence("getAngleConfidence", "setAngleConfidence"),
            extInfo("getExtInfo", "setExtInfo"),
            createTime("getCreateTime", "setCreateTime");

            final String getter;
            final String setter;

            private Column(String getter, String setter) {
                this.getter = setter;
                this.setter = setter;
            }
        }
    }

    private static class NullCastPrimitiveException
    extends ClassCastException {
        private static final long serialVersionUID = 1L;

        NullCastPrimitiveException(String message) {
            super(message);
        }
    }
}

