/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.CompareToBuilder;
import net.gdface.facedb.db.Constant;
import net.gdface.facedb.db.EqualsBuilder;
import net.gdface.facedb.db.FeatureBean;
import net.gdface.facedb.db.HashCodeBuilder;
import net.gdface.facedb.db.ImageBean;

@ThriftStruct
public final class FaceBean
implements Serializable,
BaseBean<FaceBean>,
Comparable<FaceBean>,
Constant,
Cloneable {
    private static final long serialVersionUID = 5300396122553394837L;
    public static final FaceBean NULL = new FaceBean().asNULL().asImmutable();
    private Integer id;
    private String imageMd5;
    private String featureMd5;
    private Integer faceLeft;
    private Integer faceTop;
    private Integer faceWidth;
    private Integer faceHeight;
    private Integer eyeLeftx;
    private Integer eyeLefty;
    private Integer eyeRightx;
    private Integer eyeRighty;
    private Integer mouthX;
    private Integer mouthY;
    private Integer noseX;
    private Integer noseY;
    private Integer angleYaw;
    private Integer anglePitch;
    private Integer angleRoll;
    private Float angleConfidence;
    private ByteBuffer extInfo;
    private Date createTime;
    private Boolean immutable;
    private long modified;
    private long initialized;
    private boolean isNew;
    private FeatureBean referencedByFeatureMd5;
    private ImageBean referencedByImageMd5;
    private static int stringLimit = 64;
    private static final int MINIMUM_LIMIT = 16;

    private FaceBean immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    public FaceBean asImmutable() {
        return this.immutable(Boolean.TRUE);
    }

    public boolean mutable() {
        return !Boolean.TRUE.equals(this.immutable);
    }

    private FaceBean checkMutable() {
        if (!this.mutable()) {
            throw new IllegalStateException("this is a immutable object");
        }
        return this;
    }

    public FaceBean cloneMutable() {
        return this.clone().immutable(null);
    }

    @Override
    @ThriftField(value=1, name="_new", requiredness=ThriftField.Requiredness.REQUIRED)
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void isNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField(value=2, requiredness=ThriftField.Requiredness.REQUIRED)
    public long getModified() {
        return this.modified;
    }

    @ThriftField
    public void setModified(long modified) {
        this.modified = modified;
    }

    @ThriftField(value=3, requiredness=ThriftField.Requiredness.REQUIRED)
    public long getInitialized() {
        return this.initialized;
    }

    @ThriftField
    public void setInitialized(long initialized) {
        this.initialized = initialized;
    }

    protected static final <T extends Comparable<T>> boolean equals(T a, T b) {
        return a == b || a != null && 0 == a.compareTo(b);
    }

    public FaceBean() {
        this.reset();
    }

    public FaceBean(Integer id) {
        this();
        this.setId(id);
    }

    @ThriftField(value=4)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.id)) {
            return;
        }
        this.id = newVal;
        this.modified |= 1L;
        this.initialized |= 1L;
    }

    @ThriftField(name="id")
    public void writeId(Integer newVal) {
        this.checkMutable();
        this.id = newVal;
    }

    public void setId(int newVal) {
        this.setId(new Integer(newVal));
    }

    public boolean checkIdModified() {
        return 0L != (this.modified & 1L);
    }

    public boolean checkIdInitialized() {
        return 0L != (this.initialized & 1L);
    }

    @ThriftField(value=5)
    public String getImageMd5() {
        return this.imageMd5;
    }

    public void setImageMd5(String newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.imageMd5)) {
            return;
        }
        this.imageMd5 = newVal;
        this.modified |= 2L;
        this.initialized |= 2L;
    }

    @ThriftField(name="imageMd5")
    public void writeImageMd5(String newVal) {
        this.checkMutable();
        this.imageMd5 = newVal;
    }

    public boolean checkImageMd5Modified() {
        return 0L != (this.modified & 2L);
    }

    public boolean checkImageMd5Initialized() {
        return 0L != (this.initialized & 2L);
    }

    @ThriftField(value=6)
    public String getFeatureMd5() {
        return this.featureMd5;
    }

    public void setFeatureMd5(String newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.featureMd5)) {
            return;
        }
        this.featureMd5 = newVal;
        this.modified |= 4L;
        this.initialized |= 4L;
    }

    @ThriftField(name="featureMd5")
    public void writeFeatureMd5(String newVal) {
        this.checkMutable();
        this.featureMd5 = newVal;
    }

    public boolean checkFeatureMd5Modified() {
        return 0L != (this.modified & 4L);
    }

    public boolean checkFeatureMd5Initialized() {
        return 0L != (this.initialized & 4L);
    }

    @ThriftField(value=7)
    public Integer getFaceLeft() {
        return this.faceLeft;
    }

    public void setFaceLeft(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.faceLeft)) {
            return;
        }
        this.faceLeft = newVal;
        this.modified |= 8L;
        this.initialized |= 8L;
    }

    @ThriftField(name="faceLeft")
    public void writeFaceLeft(Integer newVal) {
        this.checkMutable();
        this.faceLeft = newVal;
    }

    public void setFaceLeft(int newVal) {
        this.setFaceLeft(new Integer(newVal));
    }

    public boolean checkFaceLeftModified() {
        return 0L != (this.modified & 8L);
    }

    public boolean checkFaceLeftInitialized() {
        return 0L != (this.initialized & 8L);
    }

    @ThriftField(value=8)
    public Integer getFaceTop() {
        return this.faceTop;
    }

    public void setFaceTop(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.faceTop)) {
            return;
        }
        this.faceTop = newVal;
        this.modified |= 0x10L;
        this.initialized |= 0x10L;
    }

    @ThriftField(name="faceTop")
    public void writeFaceTop(Integer newVal) {
        this.checkMutable();
        this.faceTop = newVal;
    }

    public void setFaceTop(int newVal) {
        this.setFaceTop(new Integer(newVal));
    }

    public boolean checkFaceTopModified() {
        return 0L != (this.modified & 0x10L);
    }

    public boolean checkFaceTopInitialized() {
        return 0L != (this.initialized & 0x10L);
    }

    @ThriftField(value=9)
    public Integer getFaceWidth() {
        return this.faceWidth;
    }

    public void setFaceWidth(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.faceWidth)) {
            return;
        }
        this.faceWidth = newVal;
        this.modified |= 0x20L;
        this.initialized |= 0x20L;
    }

    @ThriftField(name="faceWidth")
    public void writeFaceWidth(Integer newVal) {
        this.checkMutable();
        this.faceWidth = newVal;
    }

    public void setFaceWidth(int newVal) {
        this.setFaceWidth(new Integer(newVal));
    }

    public boolean checkFaceWidthModified() {
        return 0L != (this.modified & 0x20L);
    }

    public boolean checkFaceWidthInitialized() {
        return 0L != (this.initialized & 0x20L);
    }

    @ThriftField(value=10)
    public Integer getFaceHeight() {
        return this.faceHeight;
    }

    public void setFaceHeight(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.faceHeight)) {
            return;
        }
        this.faceHeight = newVal;
        this.modified |= 0x40L;
        this.initialized |= 0x40L;
    }

    @ThriftField(name="faceHeight")
    public void writeFaceHeight(Integer newVal) {
        this.checkMutable();
        this.faceHeight = newVal;
    }

    public void setFaceHeight(int newVal) {
        this.setFaceHeight(new Integer(newVal));
    }

    public boolean checkFaceHeightModified() {
        return 0L != (this.modified & 0x40L);
    }

    public boolean checkFaceHeightInitialized() {
        return 0L != (this.initialized & 0x40L);
    }

    @ThriftField(value=11)
    public Integer getEyeLeftx() {
        return this.eyeLeftx;
    }

    public void setEyeLeftx(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.eyeLeftx)) {
            return;
        }
        this.eyeLeftx = newVal;
        this.modified |= 0x80L;
        this.initialized |= 0x80L;
    }

    @ThriftField(name="eyeLeftx")
    public void writeEyeLeftx(Integer newVal) {
        this.checkMutable();
        this.eyeLeftx = newVal;
    }

    public void setEyeLeftx(int newVal) {
        this.setEyeLeftx(new Integer(newVal));
    }

    public boolean checkEyeLeftxModified() {
        return 0L != (this.modified & 0x80L);
    }

    public boolean checkEyeLeftxInitialized() {
        return 0L != (this.initialized & 0x80L);
    }

    @ThriftField(value=12)
    public Integer getEyeLefty() {
        return this.eyeLefty;
    }

    public void setEyeLefty(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.eyeLefty)) {
            return;
        }
        this.eyeLefty = newVal;
        this.modified |= 0x100L;
        this.initialized |= 0x100L;
    }

    @ThriftField(name="eyeLefty")
    public void writeEyeLefty(Integer newVal) {
        this.checkMutable();
        this.eyeLefty = newVal;
    }

    public void setEyeLefty(int newVal) {
        this.setEyeLefty(new Integer(newVal));
    }

    public boolean checkEyeLeftyModified() {
        return 0L != (this.modified & 0x100L);
    }

    public boolean checkEyeLeftyInitialized() {
        return 0L != (this.initialized & 0x100L);
    }

    @ThriftField(value=13)
    public Integer getEyeRightx() {
        return this.eyeRightx;
    }

    public void setEyeRightx(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.eyeRightx)) {
            return;
        }
        this.eyeRightx = newVal;
        this.modified |= 0x200L;
        this.initialized |= 0x200L;
    }

    @ThriftField(name="eyeRightx")
    public void writeEyeRightx(Integer newVal) {
        this.checkMutable();
        this.eyeRightx = newVal;
    }

    public void setEyeRightx(int newVal) {
        this.setEyeRightx(new Integer(newVal));
    }

    public boolean checkEyeRightxModified() {
        return 0L != (this.modified & 0x200L);
    }

    public boolean checkEyeRightxInitialized() {
        return 0L != (this.initialized & 0x200L);
    }

    @ThriftField(value=14)
    public Integer getEyeRighty() {
        return this.eyeRighty;
    }

    public void setEyeRighty(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.eyeRighty)) {
            return;
        }
        this.eyeRighty = newVal;
        this.modified |= 0x400L;
        this.initialized |= 0x400L;
    }

    @ThriftField(name="eyeRighty")
    public void writeEyeRighty(Integer newVal) {
        this.checkMutable();
        this.eyeRighty = newVal;
    }

    public void setEyeRighty(int newVal) {
        this.setEyeRighty(new Integer(newVal));
    }

    public boolean checkEyeRightyModified() {
        return 0L != (this.modified & 0x400L);
    }

    public boolean checkEyeRightyInitialized() {
        return 0L != (this.initialized & 0x400L);
    }

    @ThriftField(value=15)
    public Integer getMouthX() {
        return this.mouthX;
    }

    public void setMouthX(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.mouthX)) {
            return;
        }
        this.mouthX = newVal;
        this.modified |= 0x800L;
        this.initialized |= 0x800L;
    }

    @ThriftField(name="mouthX")
    public void writeMouthX(Integer newVal) {
        this.checkMutable();
        this.mouthX = newVal;
    }

    public void setMouthX(int newVal) {
        this.setMouthX(new Integer(newVal));
    }

    public boolean checkMouthXModified() {
        return 0L != (this.modified & 0x800L);
    }

    public boolean checkMouthXInitialized() {
        return 0L != (this.initialized & 0x800L);
    }

    @ThriftField(value=16)
    public Integer getMouthY() {
        return this.mouthY;
    }

    public void setMouthY(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.mouthY)) {
            return;
        }
        this.mouthY = newVal;
        this.modified |= 0x1000L;
        this.initialized |= 0x1000L;
    }

    @ThriftField(name="mouthY")
    public void writeMouthY(Integer newVal) {
        this.checkMutable();
        this.mouthY = newVal;
    }

    public void setMouthY(int newVal) {
        this.setMouthY(new Integer(newVal));
    }

    public boolean checkMouthYModified() {
        return 0L != (this.modified & 0x1000L);
    }

    public boolean checkMouthYInitialized() {
        return 0L != (this.initialized & 0x1000L);
    }

    @ThriftField(value=17)
    public Integer getNoseX() {
        return this.noseX;
    }

    public void setNoseX(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.noseX)) {
            return;
        }
        this.noseX = newVal;
        this.modified |= 0x2000L;
        this.initialized |= 0x2000L;
    }

    @ThriftField(name="noseX")
    public void writeNoseX(Integer newVal) {
        this.checkMutable();
        this.noseX = newVal;
    }

    public void setNoseX(int newVal) {
        this.setNoseX(new Integer(newVal));
    }

    public boolean checkNoseXModified() {
        return 0L != (this.modified & 0x2000L);
    }

    public boolean checkNoseXInitialized() {
        return 0L != (this.initialized & 0x2000L);
    }

    @ThriftField(value=18)
    public Integer getNoseY() {
        return this.noseY;
    }

    public void setNoseY(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.noseY)) {
            return;
        }
        this.noseY = newVal;
        this.modified |= 0x4000L;
        this.initialized |= 0x4000L;
    }

    @ThriftField(name="noseY")
    public void writeNoseY(Integer newVal) {
        this.checkMutable();
        this.noseY = newVal;
    }

    public void setNoseY(int newVal) {
        this.setNoseY(new Integer(newVal));
    }

    public boolean checkNoseYModified() {
        return 0L != (this.modified & 0x4000L);
    }

    public boolean checkNoseYInitialized() {
        return 0L != (this.initialized & 0x4000L);
    }

    @ThriftField(value=19)
    public Integer getAngleYaw() {
        return this.angleYaw;
    }

    public void setAngleYaw(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.angleYaw)) {
            return;
        }
        this.angleYaw = newVal;
        this.modified |= 0x8000L;
        this.initialized |= 0x8000L;
    }

    @ThriftField(name="angleYaw")
    public void writeAngleYaw(Integer newVal) {
        this.checkMutable();
        this.angleYaw = newVal;
    }

    public void setAngleYaw(int newVal) {
        this.setAngleYaw(new Integer(newVal));
    }

    public boolean checkAngleYawModified() {
        return 0L != (this.modified & 0x8000L);
    }

    public boolean checkAngleYawInitialized() {
        return 0L != (this.initialized & 0x8000L);
    }

    @ThriftField(value=20)
    public Integer getAnglePitch() {
        return this.anglePitch;
    }

    public void setAnglePitch(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.anglePitch)) {
            return;
        }
        this.anglePitch = newVal;
        this.modified |= 0x10000L;
        this.initialized |= 0x10000L;
    }

    @ThriftField(name="anglePitch")
    public void writeAnglePitch(Integer newVal) {
        this.checkMutable();
        this.anglePitch = newVal;
    }

    public void setAnglePitch(int newVal) {
        this.setAnglePitch(new Integer(newVal));
    }

    public boolean checkAnglePitchModified() {
        return 0L != (this.modified & 0x10000L);
    }

    public boolean checkAnglePitchInitialized() {
        return 0L != (this.initialized & 0x10000L);
    }

    @ThriftField(value=21)
    public Integer getAngleRoll() {
        return this.angleRoll;
    }

    public void setAngleRoll(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.angleRoll)) {
            return;
        }
        this.angleRoll = newVal;
        this.modified |= 0x20000L;
        this.initialized |= 0x20000L;
    }

    @ThriftField(name="angleRoll")
    public void writeAngleRoll(Integer newVal) {
        this.checkMutable();
        this.angleRoll = newVal;
    }

    public void setAngleRoll(int newVal) {
        this.setAngleRoll(new Integer(newVal));
    }

    public boolean checkAngleRollModified() {
        return 0L != (this.modified & 0x20000L);
    }

    public boolean checkAngleRollInitialized() {
        return 0L != (this.initialized & 0x20000L);
    }

    public Float getAngleConfidence() {
        return this.angleConfidence;
    }

    @ThriftField(name="angleConfidence", value=22)
    public Double readAngleConfidence() {
        return null == this.angleConfidence ? null : Double.valueOf(this.angleConfidence.doubleValue());
    }

    public void setAngleConfidence(Float newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.angleConfidence)) {
            return;
        }
        this.angleConfidence = newVal;
        this.modified |= 0x40000L;
        this.initialized |= 0x40000L;
    }

    @ThriftField(name="angleConfidence")
    public void writeAngleConfidence(Double newVal) {
        this.checkMutable();
        this.angleConfidence = null == newVal ? null : Float.valueOf(newVal.floatValue());
    }

    public void setAngleConfidence(float newVal) {
        this.setAngleConfidence(new Float(newVal));
    }

    public boolean checkAngleConfidenceModified() {
        return 0L != (this.modified & 0x40000L);
    }

    public boolean checkAngleConfidenceInitialized() {
        return 0L != (this.initialized & 0x40000L);
    }

    @ThriftField(value=23)
    public ByteBuffer getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(ByteBuffer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.extInfo)) {
            return;
        }
        this.extInfo = newVal;
        this.modified |= 0x80000L;
        this.initialized |= 0x80000L;
    }

    @ThriftField(name="extInfo")
    public void writeExtInfo(ByteBuffer newVal) {
        this.checkMutable();
        this.extInfo = newVal;
    }

    public boolean checkExtInfoModified() {
        return 0L != (this.modified & 0x80000L);
    }

    public boolean checkExtInfoInitialized() {
        return 0L != (this.initialized & 0x80000L);
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    @ThriftField(name="createTime", value=24)
    public Long readCreateTime() {
        return null == this.createTime ? null : Long.valueOf(this.createTime.getTime());
    }

    public void setCreateTime(Date newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.createTime)) {
            return;
        }
        this.createTime = newVal;
        this.modified |= 0x100000L;
        this.initialized |= 0x100000L;
    }

    @ThriftField(name="createTime")
    public void writeCreateTime(Long newVal) {
        this.checkMutable();
        this.createTime = null == newVal ? null : new Date(newVal);
    }

    public void setCreateTime(long newVal) {
        this.setCreateTime(new Date(newVal));
    }

    public void setCreateTime(Long newVal) {
        this.setCreateTime(null == newVal ? null : new Date(newVal));
    }

    public boolean checkCreateTimeModified() {
        return 0L != (this.modified & 0x100000L);
    }

    public boolean checkCreateTimeInitialized() {
        return 0L != (this.initialized & 0x100000L);
    }

    public FeatureBean getReferencedByFeatureMd5() {
        return this.referencedByFeatureMd5;
    }

    public void setReferencedByFeatureMd5(FeatureBean reference) {
        this.referencedByFeatureMd5 = reference;
    }

    public ImageBean getReferencedByImageMd5() {
        return this.referencedByImageMd5;
    }

    public void setReferencedByImageMd5(ImageBean reference) {
        this.referencedByImageMd5 = reference;
    }

    @Override
    public boolean isModified() {
        return 0L != this.modified;
    }

    @Override
    public boolean isModified(int columnID) {
        switch (columnID) {
            case 0: {
                return this.checkIdModified();
            }
            case 1: {
                return this.checkImageMd5Modified();
            }
            case 2: {
                return this.checkFeatureMd5Modified();
            }
            case 3: {
                return this.checkFaceLeftModified();
            }
            case 4: {
                return this.checkFaceTopModified();
            }
            case 5: {
                return this.checkFaceWidthModified();
            }
            case 6: {
                return this.checkFaceHeightModified();
            }
            case 7: {
                return this.checkEyeLeftxModified();
            }
            case 8: {
                return this.checkEyeLeftyModified();
            }
            case 9: {
                return this.checkEyeRightxModified();
            }
            case 10: {
                return this.checkEyeRightyModified();
            }
            case 11: {
                return this.checkMouthXModified();
            }
            case 12: {
                return this.checkMouthYModified();
            }
            case 13: {
                return this.checkNoseXModified();
            }
            case 14: {
                return this.checkNoseYModified();
            }
            case 15: {
                return this.checkAngleYawModified();
            }
            case 16: {
                return this.checkAnglePitchModified();
            }
            case 17: {
                return this.checkAngleRollModified();
            }
            case 18: {
                return this.checkAngleConfidenceModified();
            }
            case 19: {
                return this.checkExtInfoModified();
            }
            case 20: {
                return this.checkCreateTimeModified();
            }
        }
        return false;
    }

    @Override
    public boolean isInitialized(int columnID) {
        switch (columnID) {
            case 0: {
                return this.checkIdInitialized();
            }
            case 1: {
                return this.checkImageMd5Initialized();
            }
            case 2: {
                return this.checkFeatureMd5Initialized();
            }
            case 3: {
                return this.checkFaceLeftInitialized();
            }
            case 4: {
                return this.checkFaceTopInitialized();
            }
            case 5: {
                return this.checkFaceWidthInitialized();
            }
            case 6: {
                return this.checkFaceHeightInitialized();
            }
            case 7: {
                return this.checkEyeLeftxInitialized();
            }
            case 8: {
                return this.checkEyeLeftyInitialized();
            }
            case 9: {
                return this.checkEyeRightxInitialized();
            }
            case 10: {
                return this.checkEyeRightyInitialized();
            }
            case 11: {
                return this.checkMouthXInitialized();
            }
            case 12: {
                return this.checkMouthYInitialized();
            }
            case 13: {
                return this.checkNoseXInitialized();
            }
            case 14: {
                return this.checkNoseYInitialized();
            }
            case 15: {
                return this.checkAngleYawInitialized();
            }
            case 16: {
                return this.checkAnglePitchInitialized();
            }
            case 17: {
                return this.checkAngleRollInitialized();
            }
            case 18: {
                return this.checkAngleConfidenceInitialized();
            }
            case 19: {
                return this.checkExtInfoInitialized();
            }
            case 20: {
                return this.checkCreateTimeInitialized();
            }
        }
        return false;
    }

    @Override
    public boolean isModified(String column) {
        return this.isModified(FaceBean.columnIDOf(column));
    }

    @Override
    public boolean isInitialized(String column) {
        return this.isInitialized(FaceBean.columnIDOf(column));
    }

    @Override
    public void resetIsModified() {
        this.checkMutable();
        this.modified = 0L;
    }

    @Override
    public void resetPrimaryKeysModified() {
        this.modified &= 0xFFFFFFFFFFFFFFFEL;
    }

    public void resetModifiedExceptPrimaryKeys() {
        this.modified &= 0xFFFFFFFFFFE00001L;
    }

    private void resetInitialized() {
        this.initialized = 0L;
    }

    public void reset() {
        this.checkMutable();
        this.id = null;
        this.imageMd5 = null;
        this.featureMd5 = null;
        this.faceLeft = null;
        this.faceTop = null;
        this.faceWidth = null;
        this.faceHeight = null;
        this.eyeLeftx = null;
        this.eyeLefty = null;
        this.eyeRightx = null;
        this.eyeRighty = null;
        this.mouthX = null;
        this.mouthY = null;
        this.noseX = null;
        this.noseY = null;
        this.angleYaw = null;
        this.anglePitch = null;
        this.angleRoll = null;
        this.angleConfidence = null;
        this.extInfo = null;
        this.createTime = null;
        this.isNew = true;
        this.modified = 0L;
        this.initialized = 0L;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FaceBean)) {
            return false;
        }
        FaceBean obj = (FaceBean)object;
        return new EqualsBuilder().append(this.getId(), obj.getId()).append(this.getImageMd5(), obj.getImageMd5()).append(this.getFeatureMd5(), obj.getFeatureMd5()).append(this.getFaceLeft(), obj.getFaceLeft()).append(this.getFaceTop(), obj.getFaceTop()).append(this.getFaceWidth(), obj.getFaceWidth()).append(this.getFaceHeight(), obj.getFaceHeight()).append(this.getEyeLeftx(), obj.getEyeLeftx()).append(this.getEyeLefty(), obj.getEyeLefty()).append(this.getEyeRightx(), obj.getEyeRightx()).append(this.getEyeRighty(), obj.getEyeRighty()).append(this.getMouthX(), obj.getMouthX()).append(this.getMouthY(), obj.getMouthY()).append(this.getNoseX(), obj.getNoseX()).append(this.getNoseY(), obj.getNoseY()).append(this.getAngleYaw(), obj.getAngleYaw()).append(this.getAnglePitch(), obj.getAnglePitch()).append(this.getAngleRoll(), obj.getAngleRoll()).append(this.getAngleConfidence(), obj.getAngleConfidence()).append(this.getExtInfo(), obj.getExtInfo()).append(this.getCreateTime(), obj.getCreateTime()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-82280557, -700257973).append(this.getId()).toHashCode();
    }

    public String toString() {
        return this.toString(true, false);
    }

    private static final String toHex(byte[] input) {
        if (null == input) {
            return null;
        }
        StringBuffer sb = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            sb.append(Character.forDigit((input[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(input[i] & 0xF, 16));
        }
        return sb.toString();
    }

    protected static final StringBuilder append(StringBuilder buffer, boolean full, byte[] value) {
        if (full || null == value) {
            buffer.append(FaceBean.toHex(value));
        } else {
            buffer.append(value.length).append(" bytes");
        }
        return buffer;
    }

    protected static final StringBuilder append(StringBuilder buffer, boolean full, String value) {
        if (full || null == value || value.length() <= stringLimit) {
            buffer.append(value);
        } else {
            buffer.append(value.substring(0, stringLimit - 8)).append(" ...").append(value.substring(stringLimit - 4, stringLimit));
        }
        return buffer;
    }

    protected static final <T> StringBuilder append(StringBuilder buffer, boolean full, T value) {
        return buffer.append(value);
    }

    public static final void setStringLimit(int limit) {
        if (limit < 16) {
            throw new IllegalArgumentException(String.format("INVALID limit %d,minimum value %d", limit, 16));
        }
        stringLimit = limit;
    }

    @Override
    public String toString(boolean notNull, boolean fullIfStringOrBytes) {
        StringBuilder builder = new StringBuilder(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append("[");
        int count = 0;
        if (this.checkIdInitialized() && (!notNull || null != this.getId())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("id=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getId());
        }
        if (this.checkImageMd5Initialized() && (!notNull || null != this.getImageMd5())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("image_md5=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getImageMd5());
        }
        if (this.checkFeatureMd5Initialized() && (!notNull || null != this.getFeatureMd5())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("feature_md5=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getFeatureMd5());
        }
        if (this.checkFaceLeftInitialized() && (!notNull || null != this.getFaceLeft())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("face_left=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getFaceLeft());
        }
        if (this.checkFaceTopInitialized() && (!notNull || null != this.getFaceTop())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("face_top=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getFaceTop());
        }
        if (this.checkFaceWidthInitialized() && (!notNull || null != this.getFaceWidth())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("face_width=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getFaceWidth());
        }
        if (this.checkFaceHeightInitialized() && (!notNull || null != this.getFaceHeight())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("face_height=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getFaceHeight());
        }
        if (this.checkEyeLeftxInitialized() && (!notNull || null != this.getEyeLeftx())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("eye_leftx=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getEyeLeftx());
        }
        if (this.checkEyeLeftyInitialized() && (!notNull || null != this.getEyeLefty())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("eye_lefty=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getEyeLefty());
        }
        if (this.checkEyeRightxInitialized() && (!notNull || null != this.getEyeRightx())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("eye_rightx=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getEyeRightx());
        }
        if (this.checkEyeRightyInitialized() && (!notNull || null != this.getEyeRighty())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("eye_righty=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getEyeRighty());
        }
        if (this.checkMouthXInitialized() && (!notNull || null != this.getMouthX())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("mouth_x=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getMouthX());
        }
        if (this.checkMouthYInitialized() && (!notNull || null != this.getMouthY())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("mouth_y=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getMouthY());
        }
        if (this.checkNoseXInitialized() && (!notNull || null != this.getNoseX())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("nose_x=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getNoseX());
        }
        if (this.checkNoseYInitialized() && (!notNull || null != this.getNoseY())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("nose_y=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getNoseY());
        }
        if (this.checkAngleYawInitialized() && (!notNull || null != this.getAngleYaw())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("angle_yaw=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getAngleYaw());
        }
        if (this.checkAnglePitchInitialized() && (!notNull || null != this.getAnglePitch())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("angle_pitch=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getAnglePitch());
        }
        if (this.checkAngleRollInitialized() && (!notNull || null != this.getAngleRoll())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("angle_roll=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getAngleRoll());
        }
        if (this.checkAngleConfidenceInitialized() && (!notNull || null != this.getAngleConfidence())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("angle_confidence=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getAngleConfidence());
        }
        if (this.checkExtInfoInitialized() && (!notNull || null != this.getExtInfo())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("ext_info=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getExtInfo());
        }
        if (this.checkCreateTimeInitialized() && (!notNull || null != this.getCreateTime())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("create_time=");
            FaceBean.append(builder, fullIfStringOrBytes, this.getCreateTime());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(FaceBean object) {
        return new CompareToBuilder().append(this.getId(), object.getId()).append(this.getImageMd5(), object.getImageMd5()).append(this.getFeatureMd5(), object.getFeatureMd5()).append(this.getFaceLeft(), object.getFaceLeft()).append(this.getFaceTop(), object.getFaceTop()).append(this.getFaceWidth(), object.getFaceWidth()).append(this.getFaceHeight(), object.getFaceHeight()).append(this.getEyeLeftx(), object.getEyeLeftx()).append(this.getEyeLefty(), object.getEyeLefty()).append(this.getEyeRightx(), object.getEyeRightx()).append(this.getEyeRighty(), object.getEyeRighty()).append(this.getMouthX(), object.getMouthX()).append(this.getMouthY(), object.getMouthY()).append(this.getNoseX(), object.getNoseX()).append(this.getNoseY(), object.getNoseY()).append(this.getAngleYaw(), object.getAngleYaw()).append(this.getAnglePitch(), object.getAnglePitch()).append(this.getAngleRoll(), object.getAngleRoll()).append(this.getAngleConfidence(), object.getAngleConfidence()).append(this.getExtInfo(), object.getExtInfo()).append(this.getCreateTime(), object.getCreateTime()).toComparison();
    }

    public FaceBean clone() {
        try {
            return (FaceBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public FaceBean asNULL() {
        this.checkMutable();
        this.setId(null);
        this.setImageMd5(null);
        this.setFeatureMd5(null);
        this.setFaceLeft(null);
        this.setFaceTop(null);
        this.setFaceWidth(null);
        this.setFaceHeight(null);
        this.setEyeLeftx(null);
        this.setEyeLefty(null);
        this.setEyeRightx(null);
        this.setEyeRighty(null);
        this.setMouthX(null);
        this.setMouthY(null);
        this.setNoseX(null);
        this.setNoseY(null);
        this.setAngleYaw(null);
        this.setAnglePitch(null);
        this.setAngleRoll(null);
        this.setAngleConfidence(null);
        this.setExtInfo(null);
        this.setCreateTime((Date)null);
        this.isNew(true);
        this.resetInitialized();
        this.resetIsModified();
        return this;
    }

    public boolean checkNULL() {
        return 0L == this.getInitialized();
    }

    public static final List<FaceBean> replaceNull(List<FaceBean> source) {
        if (null != source) {
            int endIndex = source.size();
            for (int i = 0; i < endIndex; ++i) {
                if (null != source.get(i)) continue;
                source.set(i, NULL);
            }
        }
        return source;
    }

    public static final List<FaceBean> replaceNullInstance(List<FaceBean> source) {
        if (null != source) {
            int endIndex = source.size();
            for (int i = 0; i < endIndex; ++i) {
                if (!source.get(i).checkNULL()) continue;
                source.set(i, null);
            }
        }
        return source;
    }

    @Override
    public FaceBean copy(FaceBean bean) {
        return this.copy(bean, new int[0]);
    }

    @Override
    public FaceBean copy(FaceBean bean, int ... fieldList) {
        if (null == fieldList || 0 == fieldList.length) {
            for (int i = 0; i < 21; ++i) {
                if (!bean.isInitialized(i)) continue;
                this.setValue(i, bean.getValue(i));
            }
        } else {
            for (int i = 0; i < fieldList.length; ++i) {
                if (!bean.isInitialized(fieldList[i])) continue;
                this.setValue(fieldList[i], bean.getValue(fieldList[i]));
            }
        }
        return this;
    }

    @Override
    public FaceBean copy(FaceBean bean, String ... fieldList) {
        if (null == fieldList || 0 == fieldList.length) {
            this.copy(bean, (int[])null);
        } else {
            for (int i = 0; i < fieldList.length; ++i) {
                int field = FaceBean.columnIDOf(fieldList[i].trim());
                if (!bean.isInitialized(field)) continue;
                this.setValue(field, bean.getValue(field));
            }
        }
        return this;
    }

    @Override
    public <T> T getValue(int columnID) {
        switch (columnID) {
            case 0: {
                return (T)this.getId();
            }
            case 1: {
                return (T)this.getImageMd5();
            }
            case 2: {
                return (T)this.getFeatureMd5();
            }
            case 3: {
                return (T)this.getFaceLeft();
            }
            case 4: {
                return (T)this.getFaceTop();
            }
            case 5: {
                return (T)this.getFaceWidth();
            }
            case 6: {
                return (T)this.getFaceHeight();
            }
            case 7: {
                return (T)this.getEyeLeftx();
            }
            case 8: {
                return (T)this.getEyeLefty();
            }
            case 9: {
                return (T)this.getEyeRightx();
            }
            case 10: {
                return (T)this.getEyeRighty();
            }
            case 11: {
                return (T)this.getMouthX();
            }
            case 12: {
                return (T)this.getMouthY();
            }
            case 13: {
                return (T)this.getNoseX();
            }
            case 14: {
                return (T)this.getNoseY();
            }
            case 15: {
                return (T)this.getAngleYaw();
            }
            case 16: {
                return (T)this.getAnglePitch();
            }
            case 17: {
                return (T)this.getAngleRoll();
            }
            case 18: {
                return (T)this.getAngleConfidence();
            }
            case 19: {
                return (T)this.getExtInfo();
            }
            case 20: {
                return (T)this.getCreateTime();
            }
        }
        return null;
    }

    @Override
    public <T> void setValue(int columnID, T value) {
        switch (columnID) {
            case 0: {
                this.setId((Integer)value);
                break;
            }
            case 1: {
                this.setImageMd5((String)value);
                break;
            }
            case 2: {
                this.setFeatureMd5((String)value);
                break;
            }
            case 3: {
                this.setFaceLeft((Integer)value);
                break;
            }
            case 4: {
                this.setFaceTop((Integer)value);
                break;
            }
            case 5: {
                this.setFaceWidth((Integer)value);
                break;
            }
            case 6: {
                this.setFaceHeight((Integer)value);
                break;
            }
            case 7: {
                this.setEyeLeftx((Integer)value);
                break;
            }
            case 8: {
                this.setEyeLefty((Integer)value);
                break;
            }
            case 9: {
                this.setEyeRightx((Integer)value);
                break;
            }
            case 10: {
                this.setEyeRighty((Integer)value);
                break;
            }
            case 11: {
                this.setMouthX((Integer)value);
                break;
            }
            case 12: {
                this.setMouthY((Integer)value);
                break;
            }
            case 13: {
                this.setNoseX((Integer)value);
                break;
            }
            case 14: {
                this.setNoseY((Integer)value);
                break;
            }
            case 15: {
                this.setAngleYaw((Integer)value);
                break;
            }
            case 16: {
                this.setAnglePitch((Integer)value);
                break;
            }
            case 17: {
                this.setAngleRoll((Integer)value);
                break;
            }
            case 18: {
                this.setAngleConfidence((Float)value);
                break;
            }
            case 19: {
                this.setExtInfo((ByteBuffer)value);
                break;
            }
            case 20: {
                this.setCreateTime((Date)value);
                break;
            }
        }
    }

    @Override
    public <T> T getValue(String column) {
        return this.getValue(FaceBean.columnIDOf(column));
    }

    @Override
    public <T> void setValue(String column, T value) {
        this.setValue(FaceBean.columnIDOf(column), value);
    }

    public static int columnIDOf(String column) {
        int index = FD_FACE_FIELDS_LIST.indexOf(column);
        return index < 0 ? FD_FACE_JAVA_FIELDS_LIST.indexOf(column) : index;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        static final ThreadLocal<FaceBean> TEMPLATE = new ThreadLocal<FaceBean>(){

            @Override
            protected FaceBean initialValue() {
                return new FaceBean();
            }
        };

        private Builder() {
        }

        public Builder reset() {
            TEMPLATE.get().reset();
            return this;
        }

        public Builder template(FaceBean bean) {
            if (null == bean) {
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }

        public FaceBean build() {
            return TEMPLATE.get().clone();
        }

        public Builder id(Integer id) {
            TEMPLATE.get().setId(id);
            return this;
        }

        public Builder imageMd5(String imageMd5) {
            TEMPLATE.get().setImageMd5(imageMd5);
            return this;
        }

        public Builder featureMd5(String featureMd5) {
            TEMPLATE.get().setFeatureMd5(featureMd5);
            return this;
        }

        public Builder faceLeft(Integer faceLeft) {
            TEMPLATE.get().setFaceLeft(faceLeft);
            return this;
        }

        public Builder faceTop(Integer faceTop) {
            TEMPLATE.get().setFaceTop(faceTop);
            return this;
        }

        public Builder faceWidth(Integer faceWidth) {
            TEMPLATE.get().setFaceWidth(faceWidth);
            return this;
        }

        public Builder faceHeight(Integer faceHeight) {
            TEMPLATE.get().setFaceHeight(faceHeight);
            return this;
        }

        public Builder eyeLeftx(Integer eyeLeftx) {
            TEMPLATE.get().setEyeLeftx(eyeLeftx);
            return this;
        }

        public Builder eyeLefty(Integer eyeLefty) {
            TEMPLATE.get().setEyeLefty(eyeLefty);
            return this;
        }

        public Builder eyeRightx(Integer eyeRightx) {
            TEMPLATE.get().setEyeRightx(eyeRightx);
            return this;
        }

        public Builder eyeRighty(Integer eyeRighty) {
            TEMPLATE.get().setEyeRighty(eyeRighty);
            return this;
        }

        public Builder mouthX(Integer mouthX) {
            TEMPLATE.get().setMouthX(mouthX);
            return this;
        }

        public Builder mouthY(Integer mouthY) {
            TEMPLATE.get().setMouthY(mouthY);
            return this;
        }

        public Builder noseX(Integer noseX) {
            TEMPLATE.get().setNoseX(noseX);
            return this;
        }

        public Builder noseY(Integer noseY) {
            TEMPLATE.get().setNoseY(noseY);
            return this;
        }

        public Builder angleYaw(Integer angleYaw) {
            TEMPLATE.get().setAngleYaw(angleYaw);
            return this;
        }

        public Builder anglePitch(Integer anglePitch) {
            TEMPLATE.get().setAnglePitch(anglePitch);
            return this;
        }

        public Builder angleRoll(Integer angleRoll) {
            TEMPLATE.get().setAngleRoll(angleRoll);
            return this;
        }

        public Builder angleConfidence(Float angleConfidence) {
            TEMPLATE.get().setAngleConfidence(angleConfidence);
            return this;
        }

        public Builder extInfo(ByteBuffer extInfo) {
            TEMPLATE.get().setExtInfo(extInfo);
            return this;
        }

        public Builder createTime(Date createTime) {
            TEMPLATE.get().setCreateTime(createTime);
            return this;
        }
    }
}

