/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.CompareToBuilder;
import net.gdface.facedb.db.Constant;
import net.gdface.facedb.db.EqualsBuilder;
import net.gdface.facedb.db.HashCodeBuilder;

@ThriftStruct
public final class FeatureBean
implements Serializable,
BaseBean<FeatureBean>,
Comparable<FeatureBean>,
Constant,
Cloneable {
    private static final long serialVersionUID = 932068192335281810L;
    public static final FeatureBean NULL = new FeatureBean().asNULL().asImmutable();
    private String md5;
    private ByteBuffer feature;
    private Date createTime;
    private Boolean immutable;
    private long modified;
    private long initialized;
    private boolean isNew;
    private static int stringLimit = 64;
    private static final int MINIMUM_LIMIT = 16;

    private FeatureBean immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    public FeatureBean asImmutable() {
        return this.immutable(Boolean.TRUE);
    }

    public boolean mutable() {
        return !Boolean.TRUE.equals(this.immutable);
    }

    private FeatureBean checkMutable() {
        if (!this.mutable()) {
            throw new IllegalStateException("this is a immutable object");
        }
        return this;
    }

    public FeatureBean cloneMutable() {
        return this.clone().immutable(null);
    }

    @Override
    @ThriftField(value=1, name="_new", requiredness=ThriftField.Requiredness.REQUIRED)
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void isNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField(value=2, requiredness=ThriftField.Requiredness.REQUIRED)
    public long getModified() {
        return this.modified;
    }

    @ThriftField
    public void setModified(long modified) {
        this.modified = modified;
    }

    @ThriftField(value=3, requiredness=ThriftField.Requiredness.REQUIRED)
    public long getInitialized() {
        return this.initialized;
    }

    @ThriftField
    public void setInitialized(long initialized) {
        this.initialized = initialized;
    }

    protected static final <T extends Comparable<T>> boolean equals(T a, T b) {
        return a == b || a != null && 0 == a.compareTo(b);
    }

    public FeatureBean() {
        this.reset();
    }

    public FeatureBean(String md5) {
        this();
        this.setMd5(md5);
    }

    @ThriftField(value=4)
    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.md5)) {
            return;
        }
        this.md5 = newVal;
        this.modified |= 1L;
        this.initialized |= 1L;
    }

    @ThriftField(name="md5")
    public void writeMd5(String newVal) {
        this.checkMutable();
        this.md5 = newVal;
    }

    public boolean checkMd5Modified() {
        return 0L != (this.modified & 1L);
    }

    public boolean checkMd5Initialized() {
        return 0L != (this.initialized & 1L);
    }

    @ThriftField(value=5)
    public ByteBuffer getFeature() {
        return this.feature;
    }

    public void setFeature(ByteBuffer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.feature)) {
            return;
        }
        this.feature = newVal;
        this.modified |= 2L;
        this.initialized |= 2L;
    }

    @ThriftField(name="feature")
    public void writeFeature(ByteBuffer newVal) {
        this.checkMutable();
        this.feature = newVal;
    }

    public boolean checkFeatureModified() {
        return 0L != (this.modified & 2L);
    }

    public boolean checkFeatureInitialized() {
        return 0L != (this.initialized & 2L);
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    @ThriftField(name="createTime", value=6)
    public Long readCreateTime() {
        return null == this.createTime ? null : Long.valueOf(this.createTime.getTime());
    }

    public void setCreateTime(Date newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.createTime)) {
            return;
        }
        this.createTime = newVal;
        this.modified |= 4L;
        this.initialized |= 4L;
    }

    @ThriftField(name="createTime")
    public void writeCreateTime(Long newVal) {
        this.checkMutable();
        this.createTime = null == newVal ? null : new Date(newVal);
    }

    public void setCreateTime(long newVal) {
        this.setCreateTime(new Date(newVal));
    }

    public void setCreateTime(Long newVal) {
        this.setCreateTime(null == newVal ? null : new Date(newVal));
    }

    public boolean checkCreateTimeModified() {
        return 0L != (this.modified & 4L);
    }

    public boolean checkCreateTimeInitialized() {
        return 0L != (this.initialized & 4L);
    }

    @Override
    public boolean isModified() {
        return 0L != this.modified;
    }

    @Override
    public boolean isModified(int columnID) {
        switch (columnID) {
            case 0: {
                return this.checkMd5Modified();
            }
            case 1: {
                return this.checkFeatureModified();
            }
            case 2: {
                return this.checkCreateTimeModified();
            }
        }
        return false;
    }

    @Override
    public boolean isInitialized(int columnID) {
        switch (columnID) {
            case 0: {
                return this.checkMd5Initialized();
            }
            case 1: {
                return this.checkFeatureInitialized();
            }
            case 2: {
                return this.checkCreateTimeInitialized();
            }
        }
        return false;
    }

    @Override
    public boolean isModified(String column) {
        return this.isModified(FeatureBean.columnIDOf(column));
    }

    @Override
    public boolean isInitialized(String column) {
        return this.isInitialized(FeatureBean.columnIDOf(column));
    }

    @Override
    public void resetIsModified() {
        this.checkMutable();
        this.modified = 0L;
    }

    @Override
    public void resetPrimaryKeysModified() {
        this.modified &= 0xFFFFFFFFFFFFFFFEL;
    }

    public void resetModifiedExceptPrimaryKeys() {
        this.modified &= 0xFFFFFFFFFFFFFFF9L;
    }

    private void resetInitialized() {
        this.initialized = 0L;
    }

    public void reset() {
        this.checkMutable();
        this.md5 = null;
        this.feature = null;
        this.createTime = null;
        this.isNew = true;
        this.modified = 0L;
        this.initialized = 0L;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FeatureBean)) {
            return false;
        }
        FeatureBean obj = (FeatureBean)object;
        return new EqualsBuilder().append(this.getMd5(), obj.getMd5()).append(this.getFeature(), obj.getFeature()).append(this.getCreateTime(), obj.getCreateTime()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-82280557, -700257973).append(this.getMd5()).toHashCode();
    }

    public String toString() {
        return this.toString(true, false);
    }

    private static final String toHex(byte[] input) {
        if (null == input) {
            return null;
        }
        StringBuffer sb = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            sb.append(Character.forDigit((input[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(input[i] & 0xF, 16));
        }
        return sb.toString();
    }

    protected static final StringBuilder append(StringBuilder buffer, boolean full, byte[] value) {
        if (full || null == value) {
            buffer.append(FeatureBean.toHex(value));
        } else {
            buffer.append(value.length).append(" bytes");
        }
        return buffer;
    }

    protected static final StringBuilder append(StringBuilder buffer, boolean full, String value) {
        if (full || null == value || value.length() <= stringLimit) {
            buffer.append(value);
        } else {
            buffer.append(value.substring(0, stringLimit - 8)).append(" ...").append(value.substring(stringLimit - 4, stringLimit));
        }
        return buffer;
    }

    protected static final <T> StringBuilder append(StringBuilder buffer, boolean full, T value) {
        return buffer.append(value);
    }

    public static final void setStringLimit(int limit) {
        if (limit < 16) {
            throw new IllegalArgumentException(String.format("INVALID limit %d,minimum value %d", limit, 16));
        }
        stringLimit = limit;
    }

    @Override
    public String toString(boolean notNull, boolean fullIfStringOrBytes) {
        StringBuilder builder = new StringBuilder(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append("[");
        int count = 0;
        if (this.checkMd5Initialized() && (!notNull || null != this.getMd5())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("md5=");
            FeatureBean.append(builder, fullIfStringOrBytes, this.getMd5());
        }
        if (this.checkFeatureInitialized() && (!notNull || null != this.getFeature())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("feature=");
            FeatureBean.append(builder, fullIfStringOrBytes, this.getFeature());
        }
        if (this.checkCreateTimeInitialized() && (!notNull || null != this.getCreateTime())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("create_time=");
            FeatureBean.append(builder, fullIfStringOrBytes, this.getCreateTime());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(FeatureBean object) {
        return new CompareToBuilder().append(this.getMd5(), object.getMd5()).append(this.getFeature(), object.getFeature()).append(this.getCreateTime(), object.getCreateTime()).toComparison();
    }

    public FeatureBean clone() {
        try {
            return (FeatureBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public FeatureBean asNULL() {
        this.checkMutable();
        this.setMd5(null);
        this.setFeature(null);
        this.setCreateTime((Date)null);
        this.isNew(true);
        this.resetInitialized();
        this.resetIsModified();
        return this;
    }

    public boolean checkNULL() {
        return 0L == this.getInitialized();
    }

    public static final List<FeatureBean> replaceNull(List<FeatureBean> source) {
        if (null != source) {
            int endIndex = source.size();
            for (int i = 0; i < endIndex; ++i) {
                if (null != source.get(i)) continue;
                source.set(i, NULL);
            }
        }
        return source;
    }

    public static final List<FeatureBean> replaceNullInstance(List<FeatureBean> source) {
        if (null != source) {
            int endIndex = source.size();
            for (int i = 0; i < endIndex; ++i) {
                if (!source.get(i).checkNULL()) continue;
                source.set(i, null);
            }
        }
        return source;
    }

    @Override
    public FeatureBean copy(FeatureBean bean) {
        return this.copy(bean, new int[0]);
    }

    @Override
    public FeatureBean copy(FeatureBean bean, int ... fieldList) {
        if (null == fieldList || 0 == fieldList.length) {
            for (int i = 0; i < 3; ++i) {
                if (!bean.isInitialized(i)) continue;
                this.setValue(i, bean.getValue(i));
            }
        } else {
            for (int i = 0; i < fieldList.length; ++i) {
                if (!bean.isInitialized(fieldList[i])) continue;
                this.setValue(fieldList[i], bean.getValue(fieldList[i]));
            }
        }
        return this;
    }

    @Override
    public FeatureBean copy(FeatureBean bean, String ... fieldList) {
        if (null == fieldList || 0 == fieldList.length) {
            this.copy(bean, (int[])null);
        } else {
            for (int i = 0; i < fieldList.length; ++i) {
                int field = FeatureBean.columnIDOf(fieldList[i].trim());
                if (!bean.isInitialized(field)) continue;
                this.setValue(field, bean.getValue(field));
            }
        }
        return this;
    }

    @Override
    public <T> T getValue(int columnID) {
        switch (columnID) {
            case 0: {
                return (T)this.getMd5();
            }
            case 1: {
                return (T)this.getFeature();
            }
            case 2: {
                return (T)this.getCreateTime();
            }
        }
        return null;
    }

    @Override
    public <T> void setValue(int columnID, T value) {
        switch (columnID) {
            case 0: {
                this.setMd5((String)value);
                break;
            }
            case 1: {
                this.setFeature((ByteBuffer)value);
                break;
            }
            case 2: {
                this.setCreateTime((Date)value);
                break;
            }
        }
    }

    @Override
    public <T> T getValue(String column) {
        return this.getValue(FeatureBean.columnIDOf(column));
    }

    @Override
    public <T> void setValue(String column, T value) {
        this.setValue(FeatureBean.columnIDOf(column), value);
    }

    public static int columnIDOf(String column) {
        int index = FD_FEATURE_FIELDS_LIST.indexOf(column);
        return index < 0 ? FD_FEATURE_JAVA_FIELDS_LIST.indexOf(column) : index;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        static final ThreadLocal<FeatureBean> TEMPLATE = new ThreadLocal<FeatureBean>(){

            @Override
            protected FeatureBean initialValue() {
                return new FeatureBean();
            }
        };

        private Builder() {
        }

        public Builder reset() {
            TEMPLATE.get().reset();
            return this;
        }

        public Builder template(FeatureBean bean) {
            if (null == bean) {
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }

        public FeatureBean build() {
            return TEMPLATE.get().clone();
        }

        public Builder md5(String md5) {
            TEMPLATE.get().setMd5(md5);
            return this;
        }

        public Builder feature(ByteBuffer feature) {
            TEMPLATE.get().setFeature(feature);
            return this;
        }

        public Builder createTime(Date createTime) {
            TEMPLATE.get().setCreateTime(createTime);
            return this;
        }
    }
}

