/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IBeanConverter<L, R> {
    public L fromRight(L var1, R var2);

    public R toRight(L var1, R var2);

    public L fromRight(R var1);

    public R toRight(L var1);

    public L[] fromRight(L[] var1, R[] var2);

    public R[] toRight(L[] var1, R[] var2);

    public L[] fromRight(R[] var1);

    public R[] toRight(L[] var1);

    public List<L> fromRight(List<L> var1, List<R> var2);

    public List<R> toRight(List<L> var1, List<R> var2);

    public List<L> fromRight(List<R> var1);

    public List<R> toRight(List<L> var1);

    public List<L> fromRight(Collection<R> var1);

    public List<R> toRight(Collection<L> var1);

    public <V> Map<R, V> toRightKey(Map<L, V> var1);

    public <K> Map<K, R> toRightValue(Map<K, L> var1);

    public <V> Map<L, V> fromRightKey(Map<R, V> var1);

    public <K> Map<K, L> fromRightValue(Map<K, R> var1);

    public Map<R, R> toRight(Map<L, L> var1);

    public Map<L, L> fromRight(Map<R, R> var1);

    public static abstract class AbstractHandle<L, R>
    implements IBeanConverter<L, R> {
        protected final Class<?> leftType;
        protected final Class<?> rightType;

        private static Class<?> getRawClass(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return AbstractHandle.getRawClass(((ParameterizedType)type).getRawType());
            }
            throw new IllegalArgumentException("invalid type");
        }

        public AbstractHandle() {
            Type superClass = this.getClass().getGenericSuperclass();
            this.leftType = AbstractHandle.getRawClass(((ParameterizedType)superClass).getActualTypeArguments()[0]);
            this.rightType = AbstractHandle.getRawClass(((ParameterizedType)superClass).getActualTypeArguments()[1]);
        }

        public AbstractHandle(Class<L> leftClass, Class<R> rightClass) {
            this.leftType = leftClass;
            this.rightType = rightClass;
        }

        protected abstract void doFromRight(L var1, R var2);

        protected abstract void doToRight(L var1, R var2);

        protected L newInstanceL() {
            return (L)AbstractHandle.newInstance(this.leftType);
        }

        protected R newInstanceR() {
            return (R)AbstractHandle.newInstance(this.rightType);
        }

        protected static <T> T newInstance(Class<T> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private R[] makeRights(L[] lefts) {
            if (null == lefts) {
                return null;
            }
            Object[] rights = (Object[])Array.newInstance(this.rightType, lefts.length);
            for (int i = 0; i < lefts.length; ++i) {
                rights[i] = null == lefts[i] ? null : this.newInstanceR();
            }
            return rights;
        }

        private L[] makeLefts(R[] rights) {
            if (null == rights) {
                return null;
            }
            Object[] lefts = (Object[])Array.newInstance(this.leftType, rights.length);
            for (int i = 0; i < rights.length; ++i) {
                lefts[i] = null == rights[i] ? null : this.newInstanceL();
            }
            return lefts;
        }

        private List<R> makeRights(List<L> lefts) {
            if (null == lefts) {
                return null;
            }
            ArrayList<Object> rights = new ArrayList<Object>(lefts.size());
            for (int i = 0; i < lefts.size(); ++i) {
                rights.add(null == lefts.get(i) ? null : (Object)this.newInstanceR());
            }
            return rights;
        }

        private List<L> makeLefts(List<R> rights) {
            if (null == rights) {
                return null;
            }
            ArrayList<Object> lefts = new ArrayList<Object>(rights.size());
            for (int i = 0; i < rights.size(); ++i) {
                lefts.add(null == rights.get(i) ? null : (Object)this.newInstanceL());
            }
            return lefts;
        }

        @Override
        public L fromRight(L left, R right) {
            if (null != right && null != left) {
                this.doFromRight(left, right);
            }
            return left;
        }

        @Override
        public R toRight(L left, R right) {
            if (null != left && null != right) {
                this.doToRight(left, right);
            }
            return right;
        }

        @Override
        public L fromRight(R bean) {
            return null == bean ? null : (L)this.fromRight(this.newInstanceL(), bean);
        }

        @Override
        public R toRight(L bean) {
            return null == bean ? null : (R)this.toRight(bean, this.newInstanceR());
        }

        @Override
        public R[] toRight(L[] lefts, R[] rights) {
            if (null != lefts && null != rights) {
                if (lefts.length != rights.length) {
                    throw new IllegalArgumentException("mismatched length between left and right array");
                }
                for (int i = 0; i < lefts.length; ++i) {
                    this.toRight(lefts[i], rights[i]);
                }
            }
            return rights;
        }

        @Override
        public L[] fromRight(L[] lefts, R[] rights) {
            if (null != rights && null != lefts) {
                if (lefts.length != rights.length) {
                    throw new IllegalArgumentException("mismatched length between left and right array");
                }
                for (int i = 0; i < lefts.length; ++i) {
                    this.fromRight(lefts[i], rights[i]);
                }
            }
            return lefts;
        }

        @Override
        public R[] toRight(L[] beans) {
            return this.toRight(beans, this.makeRights(beans));
        }

        @Override
        public L[] fromRight(R[] beans) {
            return this.fromRight(this.makeLefts(beans), beans);
        }

        @Override
        public List<R> toRight(Collection<L> beans) {
            if (null == beans) {
                return null;
            }
            ArrayList<R> rights = new ArrayList<R>(beans.size());
            for (L g : beans) {
                rights.add(this.toRight(g));
            }
            return rights;
        }

        @Override
        public List<L> fromRight(Collection<R> beans) {
            if (null == beans) {
                return null;
            }
            ArrayList<L> lefts = new ArrayList<L>(beans.size());
            for (R n : beans) {
                lefts.add(this.fromRight(n));
            }
            return lefts;
        }

        @Override
        public List<R> toRight(List<L> lefts, List<R> rights) {
            if (null != lefts && null != rights) {
                if (lefts.size() != rights.size()) {
                    throw new IllegalArgumentException("mismatched length between left and right list");
                }
                for (int i = 0; i < lefts.size(); ++i) {
                    this.toRight(lefts.get(i), rights.get(i));
                }
            }
            return rights;
        }

        @Override
        public List<L> fromRight(List<L> lefts, List<R> rights) {
            if (null != rights && null != lefts) {
                if (lefts.size() != rights.size()) {
                    throw new IllegalArgumentException("mismatched length between left and right list");
                }
                for (int i = 0; i < lefts.size(); ++i) {
                    this.fromRight(lefts.get(i), rights.get(i));
                }
            }
            return lefts;
        }

        @Override
        public List<R> toRight(List<L> beans) {
            return this.toRight(beans, this.makeRights(beans));
        }

        @Override
        public List<L> fromRight(List<R> beans) {
            return this.fromRight(this.makeLefts(beans), beans);
        }

        @Override
        public <V> Map<R, V> toRightKey(Map<L, V> lmap) {
            if (null == lmap) {
                return null;
            }
            HashMap<R, V> rmap = new HashMap<R, V>(16);
            for (Map.Entry<L, V> entry : lmap.entrySet()) {
                rmap.put(this.toRight(entry.getKey()), entry.getValue());
            }
            return rmap;
        }

        @Override
        public <K> Map<K, R> toRightValue(Map<K, L> lmap) {
            if (null == lmap) {
                return null;
            }
            HashMap<K, R> rmap = new HashMap<K, R>(16);
            for (Map.Entry<K, L> entry : lmap.entrySet()) {
                rmap.put(entry.getKey(), this.toRight(entry.getValue()));
            }
            return rmap;
        }

        @Override
        public <V> Map<L, V> fromRightKey(Map<R, V> rmap) {
            if (null == rmap) {
                return null;
            }
            HashMap<L, V> lmap = new HashMap<L, V>(16);
            for (Map.Entry<R, V> entry : rmap.entrySet()) {
                lmap.put(this.fromRight(entry.getKey()), entry.getValue());
            }
            return lmap;
        }

        @Override
        public <K> Map<K, L> fromRightValue(Map<K, R> rmap) {
            if (null == rmap) {
                return null;
            }
            HashMap<K, L> lmap = new HashMap<K, L>(16);
            for (Map.Entry<K, R> entry : rmap.entrySet()) {
                lmap.put(entry.getKey(), this.fromRight(entry.getValue()));
            }
            return lmap;
        }

        @Override
        public Map<R, R> toRight(Map<L, L> lmap) {
            if (null == lmap) {
                return null;
            }
            HashMap<R, R> rmap = new HashMap<R, R>(16);
            for (Map.Entry<L, L> entry : lmap.entrySet()) {
                rmap.put(this.toRight(entry.getKey()), this.toRight(entry.getValue()));
            }
            return rmap;
        }

        @Override
        public Map<L, L> fromRight(Map<R, R> rmap) {
            if (null == rmap) {
                return null;
            }
            HashMap<L, L> lmap = new HashMap<L, L>(16);
            for (Map.Entry<R, R> entry : rmap.entrySet()) {
                lmap.put(this.fromRight(entry.getKey()), this.fromRight(entry.getValue()));
            }
            return lmap;
        }
    }
}

