/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.exception.ObjectRetrievalException;

public interface ITableCache<K, B extends BaseBean<B>> {
    public static final UpdateStrategy DEFAULT_STRATEGY = UpdateStrategy.always;
    public static final long DEFAULT_CACHE_MAXIMUMSIZE = 10000L;
    public static final long DEFAULT_DURATION = 10L;
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MINUTES;

    public B getBean(K var1) throws Exception;

    public B getBeanUnchecked(K var1);

    public B getBeanIfPresent(K var1);

    public void remove(B var1);

    public void update(B var1);

    public void registerListener();

    public void unregisterListener();

    public static enum UpdateStrategy {
        always,
        replace,
        remove,
        refresh;


        public <K, V> void update(ConcurrentMap<K, V> map, ImmutableEntry<K, V> entry) {
            if (null == map || null == entry) {
                return;
            }
            K key = entry.getKey();
            if (null == key) {
                return;
            }
            V value = entry.getValue();
            if (null == value) {
                map.remove(key);
                return;
            }
            switch (this) {
                case always: {
                    map.put(key, value);
                    break;
                }
                case replace: {
                    map.replace(key, value);
                    break;
                }
                case remove: {
                    map.remove(key);
                    break;
                }
                case refresh: {
                    map.replace(key, value);
                }
            }
        }
    }

    public static class ImmutableEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public ImmutableEntry(K key) {
            this.key = key;
        }

        public ImmutableEntry(K key, V value) {
            this(key);
            this.value = value;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            try {
                return this.reload();
            }
            catch (ObjectRetrievalException e) {
                return null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        protected V reload() throws Exception {
            return this.value;
        }
    }
}

