/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.CompareToBuilder;
import net.gdface.facedb.db.Constant;
import net.gdface.facedb.db.EqualsBuilder;
import net.gdface.facedb.db.HashCodeBuilder;

@ThriftStruct
public final class ImageBean
implements Serializable,
BaseBean<ImageBean>,
Comparable<ImageBean>,
Constant,
Cloneable {
    private static final long serialVersionUID = -5562592083876692784L;
    public static final ImageBean NULL = new ImageBean().asNULL().asImmutable();
    private String md5;
    private String format;
    private Integer width;
    private Integer height;
    private Integer depth;
    private Integer faceNum;
    private Date updateTime;
    private Date createTime;
    private Boolean immutable;
    private long modified;
    private long initialized;
    private boolean isNew;
    private static int stringLimit = 64;
    private static final int MINIMUM_LIMIT = 16;

    private ImageBean immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    public ImageBean asImmutable() {
        return this.immutable(Boolean.TRUE);
    }

    public boolean mutable() {
        return !Boolean.TRUE.equals(this.immutable);
    }

    private ImageBean checkMutable() {
        if (!this.mutable()) {
            throw new IllegalStateException("this is a immutable object");
        }
        return this;
    }

    public ImageBean cloneMutable() {
        return this.clone().immutable(null);
    }

    @Override
    @ThriftField(value=1, name="_new", requiredness=ThriftField.Requiredness.REQUIRED)
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void isNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField(value=2, requiredness=ThriftField.Requiredness.REQUIRED)
    public long getModified() {
        return this.modified;
    }

    @ThriftField
    public void setModified(long modified) {
        this.modified = modified;
    }

    @ThriftField(value=3, requiredness=ThriftField.Requiredness.REQUIRED)
    public long getInitialized() {
        return this.initialized;
    }

    @ThriftField
    public void setInitialized(long initialized) {
        this.initialized = initialized;
    }

    protected static final <T extends Comparable<T>> boolean equals(T a, T b) {
        return a == b || a != null && 0 == a.compareTo(b);
    }

    public ImageBean() {
        this.reset();
    }

    public ImageBean(String md5) {
        this();
        this.setMd5(md5);
    }

    @ThriftField(value=4)
    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.md5)) {
            return;
        }
        this.md5 = newVal;
        this.modified |= 1L;
        this.initialized |= 1L;
    }

    @ThriftField(name="md5")
    public void writeMd5(String newVal) {
        this.checkMutable();
        this.md5 = newVal;
    }

    public boolean checkMd5Modified() {
        return 0L != (this.modified & 1L);
    }

    public boolean checkMd5Initialized() {
        return 0L != (this.initialized & 1L);
    }

    @ThriftField(value=5)
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.format)) {
            return;
        }
        this.format = newVal;
        this.modified |= 2L;
        this.initialized |= 2L;
    }

    @ThriftField(name="format")
    public void writeFormat(String newVal) {
        this.checkMutable();
        this.format = newVal;
    }

    public boolean checkFormatModified() {
        return 0L != (this.modified & 2L);
    }

    public boolean checkFormatInitialized() {
        return 0L != (this.initialized & 2L);
    }

    @ThriftField(value=6)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.width)) {
            return;
        }
        this.width = newVal;
        this.modified |= 4L;
        this.initialized |= 4L;
    }

    @ThriftField(name="width")
    public void writeWidth(Integer newVal) {
        this.checkMutable();
        this.width = newVal;
    }

    public void setWidth(int newVal) {
        this.setWidth(new Integer(newVal));
    }

    public boolean checkWidthModified() {
        return 0L != (this.modified & 4L);
    }

    public boolean checkWidthInitialized() {
        return 0L != (this.initialized & 4L);
    }

    @ThriftField(value=7)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.height)) {
            return;
        }
        this.height = newVal;
        this.modified |= 8L;
        this.initialized |= 8L;
    }

    @ThriftField(name="height")
    public void writeHeight(Integer newVal) {
        this.checkMutable();
        this.height = newVal;
    }

    public void setHeight(int newVal) {
        this.setHeight(new Integer(newVal));
    }

    public boolean checkHeightModified() {
        return 0L != (this.modified & 8L);
    }

    public boolean checkHeightInitialized() {
        return 0L != (this.initialized & 8L);
    }

    @ThriftField(value=8)
    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.depth)) {
            return;
        }
        this.depth = newVal;
        this.modified |= 0x10L;
        this.initialized |= 0x10L;
    }

    @ThriftField(name="depth")
    public void writeDepth(Integer newVal) {
        this.checkMutable();
        this.depth = newVal;
    }

    public void setDepth(int newVal) {
        this.setDepth(new Integer(newVal));
    }

    public boolean checkDepthModified() {
        return 0L != (this.modified & 0x10L);
    }

    public boolean checkDepthInitialized() {
        return 0L != (this.initialized & 0x10L);
    }

    @ThriftField(value=9)
    public Integer getFaceNum() {
        return this.faceNum;
    }

    public void setFaceNum(Integer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.faceNum)) {
            return;
        }
        this.faceNum = newVal;
        this.modified |= 0x20L;
        this.initialized |= 0x20L;
    }

    @ThriftField(name="faceNum")
    public void writeFaceNum(Integer newVal) {
        this.checkMutable();
        this.faceNum = newVal;
    }

    public void setFaceNum(int newVal) {
        this.setFaceNum(new Integer(newVal));
    }

    public boolean checkFaceNumModified() {
        return 0L != (this.modified & 0x20L);
    }

    public boolean checkFaceNumInitialized() {
        return 0L != (this.initialized & 0x20L);
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    @ThriftField(name="updateTime", value=10)
    public Long readUpdateTime() {
        return null == this.updateTime ? null : Long.valueOf(this.updateTime.getTime());
    }

    public void setUpdateTime(Date newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.updateTime)) {
            return;
        }
        this.updateTime = newVal;
        this.modified |= 0x40L;
        this.initialized |= 0x40L;
    }

    @ThriftField(name="updateTime")
    public void writeUpdateTime(Long newVal) {
        this.checkMutable();
        this.updateTime = null == newVal ? null : new Date(newVal);
    }

    public void setUpdateTime(long newVal) {
        this.setUpdateTime(new Date(newVal));
    }

    public void setUpdateTime(Long newVal) {
        this.setUpdateTime(null == newVal ? null : new Date(newVal));
    }

    public boolean checkUpdateTimeModified() {
        return 0L != (this.modified & 0x40L);
    }

    public boolean checkUpdateTimeInitialized() {
        return 0L != (this.initialized & 0x40L);
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    @ThriftField(name="createTime", value=11)
    public Long readCreateTime() {
        return null == this.createTime ? null : Long.valueOf(this.createTime.getTime());
    }

    public void setCreateTime(Date newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.createTime)) {
            return;
        }
        this.createTime = newVal;
        this.modified |= 0x80L;
        this.initialized |= 0x80L;
    }

    @ThriftField(name="createTime")
    public void writeCreateTime(Long newVal) {
        this.checkMutable();
        this.createTime = null == newVal ? null : new Date(newVal);
    }

    public void setCreateTime(long newVal) {
        this.setCreateTime(new Date(newVal));
    }

    public void setCreateTime(Long newVal) {
        this.setCreateTime(null == newVal ? null : new Date(newVal));
    }

    public boolean checkCreateTimeModified() {
        return 0L != (this.modified & 0x80L);
    }

    public boolean checkCreateTimeInitialized() {
        return 0L != (this.initialized & 0x80L);
    }

    @Override
    public boolean isModified() {
        return 0L != this.modified;
    }

    @Override
    public boolean isModified(int columnID) {
        switch (columnID) {
            case 0: {
                return this.checkMd5Modified();
            }
            case 1: {
                return this.checkFormatModified();
            }
            case 2: {
                return this.checkWidthModified();
            }
            case 3: {
                return this.checkHeightModified();
            }
            case 4: {
                return this.checkDepthModified();
            }
            case 5: {
                return this.checkFaceNumModified();
            }
            case 6: {
                return this.checkUpdateTimeModified();
            }
            case 7: {
                return this.checkCreateTimeModified();
            }
        }
        return false;
    }

    @Override
    public boolean isInitialized(int columnID) {
        switch (columnID) {
            case 0: {
                return this.checkMd5Initialized();
            }
            case 1: {
                return this.checkFormatInitialized();
            }
            case 2: {
                return this.checkWidthInitialized();
            }
            case 3: {
                return this.checkHeightInitialized();
            }
            case 4: {
                return this.checkDepthInitialized();
            }
            case 5: {
                return this.checkFaceNumInitialized();
            }
            case 6: {
                return this.checkUpdateTimeInitialized();
            }
            case 7: {
                return this.checkCreateTimeInitialized();
            }
        }
        return false;
    }

    @Override
    public boolean isModified(String column) {
        return this.isModified(ImageBean.columnIDOf(column));
    }

    @Override
    public boolean isInitialized(String column) {
        return this.isInitialized(ImageBean.columnIDOf(column));
    }

    @Override
    public void resetIsModified() {
        this.checkMutable();
        this.modified = 0L;
    }

    @Override
    public void resetPrimaryKeysModified() {
        this.modified &= 0xFFFFFFFFFFFFFFFEL;
    }

    public void resetModifiedExceptPrimaryKeys() {
        this.modified &= 0xFFFFFFFFFFFFFF01L;
    }

    private void resetInitialized() {
        this.initialized = 0L;
    }

    public void reset() {
        this.checkMutable();
        this.md5 = null;
        this.format = null;
        this.width = null;
        this.height = null;
        this.depth = new Integer(0);
        this.faceNum = new Integer(0);
        this.updateTime = null;
        this.createTime = null;
        this.isNew = true;
        this.modified = 0L;
        this.initialized = 48L;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageBean)) {
            return false;
        }
        ImageBean obj = (ImageBean)object;
        return new EqualsBuilder().append(this.getMd5(), obj.getMd5()).append(this.getFormat(), obj.getFormat()).append(this.getWidth(), obj.getWidth()).append(this.getHeight(), obj.getHeight()).append(this.getDepth(), obj.getDepth()).append(this.getFaceNum(), obj.getFaceNum()).append(this.getUpdateTime(), obj.getUpdateTime()).append(this.getCreateTime(), obj.getCreateTime()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-82280557, -700257973).append(this.getMd5()).toHashCode();
    }

    public String toString() {
        return this.toString(true, false);
    }

    private static final String toHex(byte[] input) {
        if (null == input) {
            return null;
        }
        StringBuffer sb = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            sb.append(Character.forDigit((input[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(input[i] & 0xF, 16));
        }
        return sb.toString();
    }

    protected static final StringBuilder append(StringBuilder buffer, boolean full, byte[] value) {
        if (full || null == value) {
            buffer.append(ImageBean.toHex(value));
        } else {
            buffer.append(value.length).append(" bytes");
        }
        return buffer;
    }

    protected static final StringBuilder append(StringBuilder buffer, boolean full, String value) {
        if (full || null == value || value.length() <= stringLimit) {
            buffer.append(value);
        } else {
            buffer.append(value.substring(0, stringLimit - 8)).append(" ...").append(value.substring(stringLimit - 4, stringLimit));
        }
        return buffer;
    }

    protected static final <T> StringBuilder append(StringBuilder buffer, boolean full, T value) {
        return buffer.append(value);
    }

    public static final void setStringLimit(int limit) {
        if (limit < 16) {
            throw new IllegalArgumentException(String.format("INVALID limit %d,minimum value %d", limit, 16));
        }
        stringLimit = limit;
    }

    @Override
    public String toString(boolean notNull, boolean fullIfStringOrBytes) {
        StringBuilder builder = new StringBuilder(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append("[");
        int count = 0;
        if (this.checkMd5Initialized() && (!notNull || null != this.getMd5())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("md5=");
            ImageBean.append(builder, fullIfStringOrBytes, this.getMd5());
        }
        if (this.checkFormatInitialized() && (!notNull || null != this.getFormat())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("format=");
            ImageBean.append(builder, fullIfStringOrBytes, this.getFormat());
        }
        if (this.checkWidthInitialized() && (!notNull || null != this.getWidth())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("width=");
            ImageBean.append(builder, fullIfStringOrBytes, this.getWidth());
        }
        if (this.checkHeightInitialized() && (!notNull || null != this.getHeight())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("height=");
            ImageBean.append(builder, fullIfStringOrBytes, this.getHeight());
        }
        if (this.checkDepthInitialized() && (!notNull || null != this.getDepth())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("depth=");
            ImageBean.append(builder, fullIfStringOrBytes, this.getDepth());
        }
        if (this.checkFaceNumInitialized() && (!notNull || null != this.getFaceNum())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("face_num=");
            ImageBean.append(builder, fullIfStringOrBytes, this.getFaceNum());
        }
        if (this.checkUpdateTimeInitialized() && (!notNull || null != this.getUpdateTime())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("update_time=");
            ImageBean.append(builder, fullIfStringOrBytes, this.getUpdateTime());
        }
        if (this.checkCreateTimeInitialized() && (!notNull || null != this.getCreateTime())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("create_time=");
            ImageBean.append(builder, fullIfStringOrBytes, this.getCreateTime());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(ImageBean object) {
        return new CompareToBuilder().append(this.getMd5(), object.getMd5()).append(this.getFormat(), object.getFormat()).append(this.getWidth(), object.getWidth()).append(this.getHeight(), object.getHeight()).append(this.getDepth(), object.getDepth()).append(this.getFaceNum(), object.getFaceNum()).append(this.getUpdateTime(), object.getUpdateTime()).append(this.getCreateTime(), object.getCreateTime()).toComparison();
    }

    public ImageBean clone() {
        try {
            return (ImageBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public ImageBean asNULL() {
        this.checkMutable();
        this.setMd5(null);
        this.setFormat(null);
        this.setWidth(null);
        this.setHeight(null);
        this.setDepth(null);
        this.setFaceNum(null);
        this.setUpdateTime((Date)null);
        this.setCreateTime((Date)null);
        this.isNew(true);
        this.resetInitialized();
        this.resetIsModified();
        return this;
    }

    public boolean checkNULL() {
        return 0L == this.getInitialized();
    }

    public static final List<ImageBean> replaceNull(List<ImageBean> source) {
        if (null != source) {
            int endIndex = source.size();
            for (int i = 0; i < endIndex; ++i) {
                if (null != source.get(i)) continue;
                source.set(i, NULL);
            }
        }
        return source;
    }

    public static final List<ImageBean> replaceNullInstance(List<ImageBean> source) {
        if (null != source) {
            int endIndex = source.size();
            for (int i = 0; i < endIndex; ++i) {
                if (!source.get(i).checkNULL()) continue;
                source.set(i, null);
            }
        }
        return source;
    }

    @Override
    public ImageBean copy(ImageBean bean) {
        return this.copy(bean, new int[0]);
    }

    @Override
    public ImageBean copy(ImageBean bean, int ... fieldList) {
        if (null == fieldList || 0 == fieldList.length) {
            for (int i = 0; i < 8; ++i) {
                if (!bean.isInitialized(i)) continue;
                this.setValue(i, bean.getValue(i));
            }
        } else {
            for (int i = 0; i < fieldList.length; ++i) {
                if (!bean.isInitialized(fieldList[i])) continue;
                this.setValue(fieldList[i], bean.getValue(fieldList[i]));
            }
        }
        return this;
    }

    @Override
    public ImageBean copy(ImageBean bean, String ... fieldList) {
        if (null == fieldList || 0 == fieldList.length) {
            this.copy(bean, (int[])null);
        } else {
            for (int i = 0; i < fieldList.length; ++i) {
                int field = ImageBean.columnIDOf(fieldList[i].trim());
                if (!bean.isInitialized(field)) continue;
                this.setValue(field, bean.getValue(field));
            }
        }
        return this;
    }

    @Override
    public <T> T getValue(int columnID) {
        switch (columnID) {
            case 0: {
                return (T)this.getMd5();
            }
            case 1: {
                return (T)this.getFormat();
            }
            case 2: {
                return (T)this.getWidth();
            }
            case 3: {
                return (T)this.getHeight();
            }
            case 4: {
                return (T)this.getDepth();
            }
            case 5: {
                return (T)this.getFaceNum();
            }
            case 6: {
                return (T)this.getUpdateTime();
            }
            case 7: {
                return (T)this.getCreateTime();
            }
        }
        return null;
    }

    @Override
    public <T> void setValue(int columnID, T value) {
        switch (columnID) {
            case 0: {
                this.setMd5((String)value);
                break;
            }
            case 1: {
                this.setFormat((String)value);
                break;
            }
            case 2: {
                this.setWidth((Integer)value);
                break;
            }
            case 3: {
                this.setHeight((Integer)value);
                break;
            }
            case 4: {
                this.setDepth((Integer)value);
                break;
            }
            case 5: {
                this.setFaceNum((Integer)value);
                break;
            }
            case 6: {
                this.setUpdateTime((Date)value);
                break;
            }
            case 7: {
                this.setCreateTime((Date)value);
                break;
            }
        }
    }

    @Override
    public <T> T getValue(String column) {
        return this.getValue(ImageBean.columnIDOf(column));
    }

    @Override
    public <T> void setValue(String column, T value) {
        this.setValue(ImageBean.columnIDOf(column), value);
    }

    public static int columnIDOf(String column) {
        int index = FD_IMAGE_FIELDS_LIST.indexOf(column);
        return index < 0 ? FD_IMAGE_JAVA_FIELDS_LIST.indexOf(column) : index;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        static final ThreadLocal<ImageBean> TEMPLATE = new ThreadLocal<ImageBean>(){

            @Override
            protected ImageBean initialValue() {
                return new ImageBean();
            }
        };

        private Builder() {
        }

        public Builder reset() {
            TEMPLATE.get().reset();
            return this;
        }

        public Builder template(ImageBean bean) {
            if (null == bean) {
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }

        public ImageBean build() {
            return TEMPLATE.get().clone();
        }

        public Builder md5(String md5) {
            TEMPLATE.get().setMd5(md5);
            return this;
        }

        public Builder format(String format) {
            TEMPLATE.get().setFormat(format);
            return this;
        }

        public Builder width(Integer width) {
            TEMPLATE.get().setWidth(width);
            return this;
        }

        public Builder height(Integer height) {
            TEMPLATE.get().setHeight(height);
            return this;
        }

        public Builder depth(Integer depth) {
            TEMPLATE.get().setDepth(depth);
            return this;
        }

        public Builder faceNum(Integer faceNum) {
            TEMPLATE.get().setFaceNum(faceNum);
            return this;
        }

        public Builder updateTime(Date updateTime) {
            TEMPLATE.get().setUpdateTime(updateTime);
            return this;
        }

        public Builder createTime(Date createTime) {
            TEMPLATE.get().setCreateTime(createTime);
            return this;
        }
    }
}

