/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.CompareToBuilder;
import net.gdface.facedb.db.Constant;
import net.gdface.facedb.db.EqualsBuilder;
import net.gdface.facedb.db.HashCodeBuilder;

@ThriftStruct
public final class StoreBean
implements Serializable,
BaseBean<StoreBean>,
Comparable<StoreBean>,
Constant,
Cloneable {
    private static final long serialVersionUID = -4461098722616355232L;
    public static final StoreBean NULL = new StoreBean().asNULL().asImmutable();
    private String md5;
    private String encoding;
    private ByteBuffer data;
    private Boolean immutable;
    private long modified;
    private long initialized;
    private boolean isNew;
    private static int stringLimit = 64;
    private static final int MINIMUM_LIMIT = 16;

    private StoreBean immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    public StoreBean asImmutable() {
        return this.immutable(Boolean.TRUE);
    }

    public boolean mutable() {
        return !Boolean.TRUE.equals(this.immutable);
    }

    private StoreBean checkMutable() {
        if (!this.mutable()) {
            throw new IllegalStateException("this is a immutable object");
        }
        return this;
    }

    public StoreBean cloneMutable() {
        return this.clone().immutable(null);
    }

    @Override
    @ThriftField(value=1, name="_new", requiredness=ThriftField.Requiredness.REQUIRED)
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void isNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField(value=2, requiredness=ThriftField.Requiredness.REQUIRED)
    public long getModified() {
        return this.modified;
    }

    @ThriftField
    public void setModified(long modified) {
        this.modified = modified;
    }

    @ThriftField(value=3, requiredness=ThriftField.Requiredness.REQUIRED)
    public long getInitialized() {
        return this.initialized;
    }

    @ThriftField
    public void setInitialized(long initialized) {
        this.initialized = initialized;
    }

    protected static final <T extends Comparable<T>> boolean equals(T a, T b) {
        return a == b || a != null && 0 == a.compareTo(b);
    }

    public StoreBean() {
        this.reset();
    }

    public StoreBean(String md5) {
        this();
        this.setMd5(md5);
    }

    @ThriftField(value=4)
    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.md5)) {
            return;
        }
        this.md5 = newVal;
        this.modified |= 1L;
        this.initialized |= 1L;
    }

    @ThriftField(name="md5")
    public void writeMd5(String newVal) {
        this.checkMutable();
        this.md5 = newVal;
    }

    public boolean checkMd5Modified() {
        return 0L != (this.modified & 1L);
    }

    public boolean checkMd5Initialized() {
        return 0L != (this.initialized & 1L);
    }

    @ThriftField(value=5)
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.encoding)) {
            return;
        }
        this.encoding = newVal;
        this.modified |= 2L;
        this.initialized |= 2L;
    }

    @ThriftField(name="encoding")
    public void writeEncoding(String newVal) {
        this.checkMutable();
        this.encoding = newVal;
    }

    public boolean checkEncodingModified() {
        return 0L != (this.modified & 2L);
    }

    public boolean checkEncodingInitialized() {
        return 0L != (this.initialized & 2L);
    }

    @ThriftField(value=6)
    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer newVal) {
        this.checkMutable();
        if (Objects.equals(newVal, this.data)) {
            return;
        }
        this.data = newVal;
        this.modified |= 4L;
        this.initialized |= 4L;
    }

    @ThriftField(name="data")
    public void writeData(ByteBuffer newVal) {
        this.checkMutable();
        this.data = newVal;
    }

    public boolean checkDataModified() {
        return 0L != (this.modified & 4L);
    }

    public boolean checkDataInitialized() {
        return 0L != (this.initialized & 4L);
    }

    @Override
    public boolean isModified() {
        return 0L != this.modified;
    }

    @Override
    public boolean isModified(int columnID) {
        switch (columnID) {
            case 0: {
                return this.checkMd5Modified();
            }
            case 1: {
                return this.checkEncodingModified();
            }
            case 2: {
                return this.checkDataModified();
            }
        }
        return false;
    }

    @Override
    public boolean isInitialized(int columnID) {
        switch (columnID) {
            case 0: {
                return this.checkMd5Initialized();
            }
            case 1: {
                return this.checkEncodingInitialized();
            }
            case 2: {
                return this.checkDataInitialized();
            }
        }
        return false;
    }

    @Override
    public boolean isModified(String column) {
        return this.isModified(StoreBean.columnIDOf(column));
    }

    @Override
    public boolean isInitialized(String column) {
        return this.isInitialized(StoreBean.columnIDOf(column));
    }

    @Override
    public void resetIsModified() {
        this.checkMutable();
        this.modified = 0L;
    }

    @Override
    public void resetPrimaryKeysModified() {
        this.modified &= 0xFFFFFFFFFFFFFFFEL;
    }

    public void resetModifiedExceptPrimaryKeys() {
        this.modified &= 0xFFFFFFFFFFFFFFF9L;
    }

    private void resetInitialized() {
        this.initialized = 0L;
    }

    public void reset() {
        this.checkMutable();
        this.md5 = null;
        this.encoding = null;
        this.data = null;
        this.isNew = true;
        this.modified = 0L;
        this.initialized = 0L;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StoreBean)) {
            return false;
        }
        StoreBean obj = (StoreBean)object;
        return new EqualsBuilder().append(this.getMd5(), obj.getMd5()).append(this.getEncoding(), obj.getEncoding()).append(this.getData(), obj.getData()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-82280557, -700257973).append(this.getMd5()).toHashCode();
    }

    public String toString() {
        return this.toString(true, false);
    }

    private static final String toHex(byte[] input) {
        if (null == input) {
            return null;
        }
        StringBuffer sb = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            sb.append(Character.forDigit((input[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(input[i] & 0xF, 16));
        }
        return sb.toString();
    }

    protected static final StringBuilder append(StringBuilder buffer, boolean full, byte[] value) {
        if (full || null == value) {
            buffer.append(StoreBean.toHex(value));
        } else {
            buffer.append(value.length).append(" bytes");
        }
        return buffer;
    }

    protected static final StringBuilder append(StringBuilder buffer, boolean full, String value) {
        if (full || null == value || value.length() <= stringLimit) {
            buffer.append(value);
        } else {
            buffer.append(value.substring(0, stringLimit - 8)).append(" ...").append(value.substring(stringLimit - 4, stringLimit));
        }
        return buffer;
    }

    protected static final <T> StringBuilder append(StringBuilder buffer, boolean full, T value) {
        return buffer.append(value);
    }

    public static final void setStringLimit(int limit) {
        if (limit < 16) {
            throw new IllegalArgumentException(String.format("INVALID limit %d,minimum value %d", limit, 16));
        }
        stringLimit = limit;
    }

    @Override
    public String toString(boolean notNull, boolean fullIfStringOrBytes) {
        StringBuilder builder = new StringBuilder(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append("[");
        int count = 0;
        if (this.checkMd5Initialized() && (!notNull || null != this.getMd5())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("md5=");
            StoreBean.append(builder, fullIfStringOrBytes, this.getMd5());
        }
        if (this.checkEncodingInitialized() && (!notNull || null != this.getEncoding())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("encoding=");
            StoreBean.append(builder, fullIfStringOrBytes, this.getEncoding());
        }
        if (this.checkDataInitialized() && (!notNull || null != this.getData())) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append("data=");
            StoreBean.append(builder, fullIfStringOrBytes, this.getData());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(StoreBean object) {
        return new CompareToBuilder().append(this.getMd5(), object.getMd5()).append(this.getEncoding(), object.getEncoding()).append(this.getData(), object.getData()).toComparison();
    }

    public StoreBean clone() {
        try {
            return (StoreBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public StoreBean asNULL() {
        this.checkMutable();
        this.setMd5(null);
        this.setEncoding(null);
        this.setData(null);
        this.isNew(true);
        this.resetInitialized();
        this.resetIsModified();
        return this;
    }

    public boolean checkNULL() {
        return 0L == this.getInitialized();
    }

    public static final List<StoreBean> replaceNull(List<StoreBean> source) {
        if (null != source) {
            int endIndex = source.size();
            for (int i = 0; i < endIndex; ++i) {
                if (null != source.get(i)) continue;
                source.set(i, NULL);
            }
        }
        return source;
    }

    public static final List<StoreBean> replaceNullInstance(List<StoreBean> source) {
        if (null != source) {
            int endIndex = source.size();
            for (int i = 0; i < endIndex; ++i) {
                if (!source.get(i).checkNULL()) continue;
                source.set(i, null);
            }
        }
        return source;
    }

    @Override
    public StoreBean copy(StoreBean bean) {
        return this.copy(bean, new int[0]);
    }

    @Override
    public StoreBean copy(StoreBean bean, int ... fieldList) {
        if (null == fieldList || 0 == fieldList.length) {
            for (int i = 0; i < 3; ++i) {
                if (!bean.isInitialized(i)) continue;
                this.setValue(i, bean.getValue(i));
            }
        } else {
            for (int i = 0; i < fieldList.length; ++i) {
                if (!bean.isInitialized(fieldList[i])) continue;
                this.setValue(fieldList[i], bean.getValue(fieldList[i]));
            }
        }
        return this;
    }

    @Override
    public StoreBean copy(StoreBean bean, String ... fieldList) {
        if (null == fieldList || 0 == fieldList.length) {
            this.copy(bean, (int[])null);
        } else {
            for (int i = 0; i < fieldList.length; ++i) {
                int field = StoreBean.columnIDOf(fieldList[i].trim());
                if (!bean.isInitialized(field)) continue;
                this.setValue(field, bean.getValue(field));
            }
        }
        return this;
    }

    @Override
    public <T> T getValue(int columnID) {
        switch (columnID) {
            case 0: {
                return (T)this.getMd5();
            }
            case 1: {
                return (T)this.getEncoding();
            }
            case 2: {
                return (T)this.getData();
            }
        }
        return null;
    }

    @Override
    public <T> void setValue(int columnID, T value) {
        switch (columnID) {
            case 0: {
                this.setMd5((String)value);
                break;
            }
            case 1: {
                this.setEncoding((String)value);
                break;
            }
            case 2: {
                this.setData((ByteBuffer)value);
                break;
            }
        }
    }

    @Override
    public <T> T getValue(String column) {
        return this.getValue(StoreBean.columnIDOf(column));
    }

    @Override
    public <T> void setValue(String column, T value) {
        this.setValue(StoreBean.columnIDOf(column), value);
    }

    public static int columnIDOf(String column) {
        int index = FD_STORE_FIELDS_LIST.indexOf(column);
        return index < 0 ? FD_STORE_JAVA_FIELDS_LIST.indexOf(column) : index;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        static final ThreadLocal<StoreBean> TEMPLATE = new ThreadLocal<StoreBean>(){

            @Override
            protected StoreBean initialValue() {
                return new StoreBean();
            }
        };

        private Builder() {
        }

        public Builder reset() {
            TEMPLATE.get().reset();
            return this;
        }

        public Builder template(StoreBean bean) {
            if (null == bean) {
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }

        public StoreBean build() {
            return TEMPLATE.get().clone();
        }

        public Builder md5(String md5) {
            TEMPLATE.get().setMd5(md5);
            return this;
        }

        public Builder encoding(String encoding) {
            TEMPLATE.get().setEncoding(encoding);
            return this;
        }

        public Builder data(ByteBuffer data) {
            TEMPLATE.get().setData(data);
            return this;
        }
    }
}

