/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.TableManager;
import net.gdface.facedb.db.exception.RuntimeDaoException;

public interface TableListener<B> {
    public void beforeInsert(B var1) throws RuntimeDaoException;

    public void afterInsert(B var1) throws RuntimeDaoException;

    public void beforeUpdate(B var1) throws RuntimeDaoException;

    public void afterUpdate(B var1) throws RuntimeDaoException;

    public void beforeDelete(B var1) throws RuntimeDaoException;

    public void afterDelete(B var1) throws RuntimeDaoException;

    public void done() throws RuntimeDaoException;

    public static class DecoratorExecutorListener<B>
    implements TableListener<B> {
        private final TableListener<B> delegate;
        private static final Executor DIRECT_EXECUTOR = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };

        public DecoratorExecutorListener(TableListener<B> delegate) {
            if (null == delegate) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        protected Executor getExecutor() {
            return DIRECT_EXECUTOR;
        }

        public TableListener<B> delegate() {
            return this.delegate;
        }

        protected void onException(Exception e) {
            e.printStackTrace();
        }

        @Override
        public void beforeInsert(final B bean) throws RuntimeDaoException {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DecoratorExecutorListener.this.delegate.beforeDelete(bean);
                    }
                    catch (Exception e) {
                        DecoratorExecutorListener.this.onException(e);
                    }
                }
            });
        }

        @Override
        public void afterInsert(final B bean) throws RuntimeDaoException {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DecoratorExecutorListener.this.delegate.afterInsert(bean);
                    }
                    catch (Exception e) {
                        DecoratorExecutorListener.this.onException(e);
                    }
                }
            });
        }

        @Override
        public void beforeUpdate(final B bean) throws RuntimeDaoException {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DecoratorExecutorListener.this.delegate.beforeUpdate(bean);
                    }
                    catch (Exception e) {
                        DecoratorExecutorListener.this.onException(e);
                    }
                }
            });
        }

        @Override
        public void afterUpdate(final B bean) throws RuntimeDaoException {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DecoratorExecutorListener.this.delegate.afterUpdate(bean);
                    }
                    catch (Exception e) {
                        DecoratorExecutorListener.this.onException(e);
                    }
                }
            });
        }

        @Override
        public void beforeDelete(final B bean) throws RuntimeDaoException {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DecoratorExecutorListener.this.delegate.beforeDelete(bean);
                    }
                    catch (Exception e) {
                        DecoratorExecutorListener.this.onException(e);
                    }
                }
            });
        }

        @Override
        public void afterDelete(final B bean) throws RuntimeDaoException {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DecoratorExecutorListener.this.delegate.afterDelete(bean);
                    }
                    catch (Exception e) {
                        DecoratorExecutorListener.this.onException(e);
                    }
                }
            });
        }

        @Override
        public void done() throws RuntimeDaoException {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DecoratorExecutorListener.this.delegate.done();
                    }
                    catch (Exception e) {
                        DecoratorExecutorListener.this.onException(e);
                    }
                }
            });
        }
    }

    public static class ListenerContainer<B>
    implements TableListener<B> {
        private final Set<TableListener<B>> listeners = Collections.synchronizedSet(new LinkedHashSet(16));

        @Override
        public void beforeInsert(B bean) throws RuntimeDaoException {
            for (TableListener<B> listener : this.listeners) {
                listener.beforeInsert(bean);
            }
        }

        @Override
        public void afterInsert(B bean) throws RuntimeDaoException {
            for (TableListener<B> listener : this.listeners) {
                listener.afterInsert(bean);
            }
        }

        @Override
        public void beforeUpdate(B bean) throws RuntimeDaoException {
            for (TableListener<B> listener : this.listeners) {
                listener.beforeUpdate(bean);
            }
        }

        @Override
        public void afterUpdate(B bean) throws RuntimeDaoException {
            for (TableListener<B> listener : this.listeners) {
                listener.afterUpdate(bean);
            }
        }

        @Override
        public void beforeDelete(B bean) throws RuntimeDaoException {
            for (TableListener<B> listener : this.listeners) {
                listener.beforeDelete(bean);
            }
        }

        @Override
        public void afterDelete(B bean) throws RuntimeDaoException {
            for (TableListener<B> listener : this.listeners) {
                listener.afterDelete(bean);
            }
        }

        @Override
        public void done() throws RuntimeDaoException {
            for (TableListener<B> listener : this.listeners) {
                listener.done();
            }
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public boolean contains(TableListener<B> listener) {
            return this.listeners.contains(listener);
        }

        public boolean add(TableListener<B> listener) {
            return null == listener ? false : this.listeners.add(listener);
        }

        public boolean remove(TableListener<B> listener) {
            return null == listener ? false : this.listeners.remove(listener);
        }

        public void clear() {
            this.listeners.clear();
        }
    }

    public static enum Event {
        INSERT,
        UPDATE,
        DELETE;


        public <B> void fire(ListenerContainer<B> container, B bean) throws RuntimeDaoException {
            if (null == container || null == bean) {
                return;
            }
            switch (this) {
                case INSERT: {
                    container.afterInsert(bean);
                    break;
                }
                case UPDATE: {
                    container.afterUpdate(bean);
                    break;
                }
                case DELETE: {
                    container.afterDelete(bean);
                    break;
                }
            }
        }

        public <B extends BaseBean<B>> void fire(TableManager<B> manager, B bean) throws RuntimeDaoException {
            if (null == manager || null == bean) {
                return;
            }
            manager.fire(this, bean);
        }
    }

    public static class Adapter<B>
    implements TableListener<B> {
        @Override
        public void beforeInsert(B bean) throws RuntimeDaoException {
        }

        @Override
        public void afterInsert(B bean) throws RuntimeDaoException {
        }

        @Override
        public void beforeUpdate(B bean) throws RuntimeDaoException {
        }

        @Override
        public void afterUpdate(B bean) throws RuntimeDaoException {
        }

        @Override
        public void beforeDelete(B bean) throws RuntimeDaoException {
        }

        @Override
        public void afterDelete(B bean) throws RuntimeDaoException {
        }

        @Override
        public void done() throws RuntimeDaoException {
        }
    }
}

