/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import net.gdface.facedb.db.BaseBean;
import net.gdface.facedb.db.Constant;
import net.gdface.facedb.db.TableListener;
import net.gdface.facedb.db.exception.ObjectRetrievalException;
import net.gdface.facedb.db.exception.RuntimeDaoException;

public interface TableManager<B extends BaseBean<?>>
extends Constant {
    public String getFields();

    public String[] getPrimarykeyNames();

    public String getTableName();

    public String getFullFields();

    public boolean isPrimaryKey(String var1);

    public int countAll() throws RuntimeDaoException;

    public int countUsingTemplate(B var1) throws RuntimeDaoException;

    public int countUsingTemplate(B var1, int var2) throws RuntimeDaoException;

    public int countWhere(String var1) throws RuntimeDaoException;

    public int deleteAll() throws RuntimeDaoException;

    public int deleteByWhere(String var1) throws RuntimeDaoException;

    public int deleteUsingTemplate(B var1) throws RuntimeDaoException;

    public int deleteByPrimaryKey(Object ... var1) throws RuntimeDaoException;

    public int delete(B var1) throws RuntimeDaoException;

    public B[] loadAll() throws RuntimeDaoException;

    public int loadAll(Action<B> var1) throws RuntimeDaoException;

    public B[] loadAll(int var1, int var2) throws RuntimeDaoException;

    public int loadAll(int var1, int var2, Action<B> var3) throws RuntimeDaoException;

    public List<B> loadAllAsList() throws RuntimeDaoException;

    public List<B> loadAllAsList(int var1, int var2) throws RuntimeDaoException;

    public B loadByPrimaryKey(B var1) throws RuntimeDaoException;

    public B loadByPrimaryKeyChecked(B var1) throws RuntimeDaoException, ObjectRetrievalException;

    public B loadByPrimaryKey(Object ... var1) throws RuntimeDaoException;

    public B loadByPrimaryKeyChecked(Object ... var1) throws RuntimeDaoException, ObjectRetrievalException;

    public boolean existsPrimaryKey(Object ... var1) throws RuntimeDaoException;

    public boolean existsByPrimaryKey(B var1) throws RuntimeDaoException;

    public B checkDuplicate(B var1) throws RuntimeDaoException, ObjectRetrievalException;

    public B[] loadByWhere(String var1) throws RuntimeDaoException;

    public int loadByWhere(String var1, Action<B> var2) throws RuntimeDaoException;

    public B[] loadByWhere(String var1, int[] var2) throws RuntimeDaoException;

    public int loadByWhere(String var1, int[] var2, Action<B> var3) throws RuntimeDaoException;

    public B[] loadByWhere(String var1, int[] var2, int var3, int var4) throws RuntimeDaoException;

    public int loadByWhere(String var1, int[] var2, int var3, int var4, Action<B> var5) throws RuntimeDaoException;

    public List<B> loadByWhereAsList(String var1) throws RuntimeDaoException;

    public List<B> loadByWhereAsList(String var1, int[] var2) throws RuntimeDaoException;

    public List<B> loadByWhereAsList(String var1, int[] var2, int var3, int var4) throws RuntimeDaoException;

    public int loadByWhereForAction(String var1, int[] var2, int var3, int var4, Action<B> var5) throws RuntimeDaoException;

    public B loadUniqueUsingTemplate(B var1) throws RuntimeDaoException;

    public B loadUniqueUsingTemplateChecked(B var1) throws RuntimeDaoException, ObjectRetrievalException;

    public B[] loadUsingTemplate(B var1) throws RuntimeDaoException;

    public int loadUsingTemplate(B var1, Action<B> var2) throws RuntimeDaoException;

    public B[] loadUsingTemplate(B var1, int var2, int var3) throws RuntimeDaoException;

    public int loadUsingTemplate(B var1, int var2, int var3, Action<B> var4) throws RuntimeDaoException;

    public int loadUsingTemplate(B var1, int[] var2, int var3, int var4, int var5, Action<B> var6) throws RuntimeDaoException;

    public B[] loadUsingTemplate(B var1, int var2, int var3, int var4) throws RuntimeDaoException;

    public List<B> loadUsingTemplateAsList(B var1) throws RuntimeDaoException;

    public List<B> loadUsingTemplateAsList(B var1, int var2, int var3) throws RuntimeDaoException;

    public List<B> loadUsingTemplateAsList(B var1, int var2, int var3, int var4) throws RuntimeDaoException;

    public B[] loadByIndex(int var1, Object ... var2) throws RuntimeDaoException;

    public List<B> loadByIndexAsList(int var1, Object ... var2) throws RuntimeDaoException;

    public int deleteByIndex(int var1, Object ... var2) throws RuntimeDaoException;

    public TableListener<B> registerListener(TableListener<B> var1);

    public void unregisterListener(TableListener<B> var1);

    public void fire(TableListener.Event var1, B var2) throws RuntimeDaoException;

    public void fire(int var1, B var2) throws RuntimeDaoException;

    public B save(B var1) throws RuntimeDaoException;

    public B[] save(B[] var1) throws RuntimeDaoException;

    public <C extends Collection<B>> C saveAsTransaction(C var1) throws RuntimeDaoException;

    public B[] saveAsTransaction(B[] var1) throws RuntimeDaoException;

    public <C extends Collection<B>> C save(C var1) throws RuntimeDaoException;

    public B save(B var1, Object ... var2) throws RuntimeDaoException;

    public B saveCollection(B var1, Object ... var2) throws RuntimeDaoException;

    public B saveAsTransaction(B var1, Object ... var2) throws RuntimeDaoException;

    public B saveCollectionAsTransaction(B var1, Object ... var2) throws RuntimeDaoException;

    public B[] loadBySql(String var1, Object[] var2, int[] var3) throws RuntimeDaoException;

    public List<B> loadBySqlAsList(String var1, Object[] var2, int[] var3) throws RuntimeDaoException;

    public int loadBySqlForAction(String var1, Object[] var2, int[] var3, int var4, int var5, Action<B> var6) throws RuntimeDaoException;

    public <T> T runAsTransaction(Callable<T> var1) throws RuntimeDaoException;

    public void runAsTransaction(Runnable var1) throws RuntimeDaoException;

    public <T extends BaseBean<T>> T getReferencedBean(B var1, int var2) throws RuntimeDaoException;

    public <T extends BaseBean<T>> T setReferencedBean(B var1, T var2, int var3) throws RuntimeDaoException;

    public <T extends BaseBean<T>> T[] getImportedBeans(B var1, int var2) throws RuntimeDaoException;

    public <T extends BaseBean<T>> List<T> getImportedBeansAsList(B var1, int var2) throws RuntimeDaoException;

    public <T extends BaseBean<T>> T[] setImportedBeans(B var1, T[] var2, int var3) throws RuntimeDaoException;

    public <T extends BaseBean<T>, C extends Collection<T>> C setImportedBeans(B var1, C var2, int var3) throws RuntimeDaoException;

    public static abstract class BaseAdapter<B extends BaseBean<B>>
    implements TableManager<B> {
        protected abstract Class<B> beanType();

        protected abstract B insert(B var1) throws RuntimeDaoException;

        protected abstract B update(B var1) throws RuntimeDaoException;

        @Override
        public int countAll() throws RuntimeDaoException {
            return this.countWhere("");
        }

        @Override
        public int countUsingTemplate(B bean) throws RuntimeDaoException {
            return this.countUsingTemplate(bean, 0);
        }

        @Override
        public int deleteAll() throws RuntimeDaoException {
            return this.deleteByWhere("");
        }

        @Override
        public B[] loadAll() throws RuntimeDaoException {
            return this.loadUsingTemplate(null, 1, -1, 0);
        }

        @Override
        public int loadAll(Action<B> action) throws RuntimeDaoException {
            return this.loadUsingTemplate(null, null, 1, -1, 0, action);
        }

        @Override
        public B[] loadAll(int startRow, int numRows) throws RuntimeDaoException {
            return this.loadUsingTemplate(null, startRow, numRows, 0);
        }

        @Override
        public int loadAll(int startRow, int numRows, Action<B> action) throws RuntimeDaoException {
            return this.loadUsingTemplate(null, null, startRow, numRows, 0, action);
        }

        @Override
        public List<B> loadAllAsList() throws RuntimeDaoException {
            return this.loadUsingTemplateAsList(null, 1, -1, 0);
        }

        @Override
        public List<B> loadAllAsList(int startRow, int numRows) throws RuntimeDaoException {
            return this.loadUsingTemplateAsList(null, startRow, numRows, 0);
        }

        @Override
        public boolean existsByPrimaryKey(B bean) throws RuntimeDaoException {
            return null != this.loadByPrimaryKey(bean);
        }

        @Override
        public B checkDuplicate(B bean) throws RuntimeDaoException, ObjectRetrievalException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean existsPrimaryKey(Object ... keys) throws RuntimeDaoException {
            return null != this.loadByPrimaryKey(keys);
        }

        @Override
        public B[] loadByWhere(String where) throws RuntimeDaoException {
            return this.loadByWhere(where, null);
        }

        @Override
        public int loadByWhere(String where, Action<B> action) throws RuntimeDaoException {
            return this.loadByWhere(where, null, action);
        }

        @Override
        public B[] loadByWhere(String where, int[] fieldList) throws RuntimeDaoException {
            return this.loadByWhere(where, fieldList, 1, -1);
        }

        @Override
        public int loadByWhere(String where, int[] fieldList, Action<B> action) throws RuntimeDaoException {
            return this.loadByWhere(where, fieldList, 1, -1, action);
        }

        @Override
        public B[] loadByWhere(String where, int[] fieldList, int startRow, int numRows) throws RuntimeDaoException {
            return this.loadByWhereAsList(where, fieldList, startRow, numRows).toArray((BaseBean[])Array.newInstance(this.beanType(), 0));
        }

        @Override
        public int loadByWhere(String where, int[] fieldList, int startRow, int numRows, Action<B> action) throws RuntimeDaoException {
            return this.loadByWhereForAction(where, fieldList, startRow, numRows, action);
        }

        @Override
        public List<B> loadByWhereAsList(String where) throws RuntimeDaoException {
            return this.loadByWhereAsList(where, null, 1, -1);
        }

        @Override
        public List<B> loadByWhereAsList(String where, int[] fieldList) throws RuntimeDaoException {
            return this.loadByWhereAsList(where, fieldList, 1, -1);
        }

        @Override
        public List<B> loadByWhereAsList(String where, int[] fieldList, int startRow, int numRows) throws RuntimeDaoException {
            ListAction action = new ListAction();
            this.loadByWhereForAction(where, fieldList, startRow, numRows, action);
            return action.getList();
        }

        @Override
        public int loadByWhereForAction(String where, int[] fieldList, int startRow, int numRows, Action<B> action) throws RuntimeDaoException {
            String sql = this.createSelectSql(fieldList, where);
            return this.loadBySqlForAction(sql, null, fieldList, startRow, numRows, action);
        }

        @Override
        public B[] loadUsingTemplate(B bean) throws RuntimeDaoException {
            return this.loadUsingTemplate((BaseBean)bean, 1, -1, 0);
        }

        @Override
        public int loadUsingTemplate(B bean, Action<B> action) throws RuntimeDaoException {
            return this.loadUsingTemplate(bean, null, 1, -1, 0, action);
        }

        @Override
        public B[] loadUsingTemplate(B bean, int startRow, int numRows) throws RuntimeDaoException {
            return this.loadUsingTemplate((BaseBean)bean, startRow, numRows, 0);
        }

        @Override
        public int loadUsingTemplate(B bean, int startRow, int numRows, Action<B> action) throws RuntimeDaoException {
            return this.loadUsingTemplate(bean, null, startRow, numRows, 0, action);
        }

        @Override
        public B[] loadUsingTemplate(B bean, int startRow, int numRows, int searchType) throws RuntimeDaoException {
            return this.loadUsingTemplateAsList(bean, startRow, numRows, searchType).toArray((BaseBean[])Array.newInstance(this.beanType(), 0));
        }

        @Override
        public List<B> loadUsingTemplateAsList(B bean) throws RuntimeDaoException {
            return this.loadUsingTemplateAsList(bean, 1, -1, 0);
        }

        @Override
        public List<B> loadUsingTemplateAsList(B bean, int startRow, int numRows) throws RuntimeDaoException {
            return this.loadUsingTemplateAsList(bean, startRow, numRows, 0);
        }

        @Override
        public List<B> loadUsingTemplateAsList(B bean, int startRow, int numRows, int searchType) throws RuntimeDaoException {
            ListAction action = new ListAction();
            this.loadUsingTemplate(bean, null, startRow, numRows, searchType, action);
            return action.getList();
        }

        @Override
        public B save(B bean) throws RuntimeDaoException {
            if (null != bean) {
                if (bean.isNew()) {
                    this.insert(bean);
                } else {
                    this.update(bean);
                }
            }
            return bean;
        }

        @Override
        public B[] save(B[] beans) throws RuntimeDaoException {
            if (null != beans) {
                for (B bean : beans) {
                    this.save((Collection)bean);
                }
            }
            return beans;
        }

        @Override
        public <C extends Collection<B>> C save(C beans) throws RuntimeDaoException {
            if (null != beans) {
                for (BaseBean bean : beans) {
                    this.save((C)((Object)bean));
                }
            }
            return beans;
        }

        @Override
        public <C extends Collection<B>> C saveAsTransaction(final C beans) throws RuntimeDaoException {
            return (C)((Collection)this.runAsTransaction(new Callable<C>(){

                @Override
                public C call() throws Exception {
                    return BaseAdapter.this.save(beans);
                }
            }));
        }

        @Override
        public B[] saveAsTransaction(final B[] beans) throws RuntimeDaoException {
            return (BaseBean[])this.runAsTransaction(new Callable<B[]>(){

                @Override
                public B[] call() throws Exception {
                    return BaseAdapter.this.save(beans);
                }
            });
        }

        @Override
        public B[] loadBySql(String sql, Object[] argList, int[] fieldList) throws RuntimeDaoException {
            return this.loadBySqlAsList(sql, argList, fieldList).toArray((BaseBean[])Array.newInstance(this.beanType(), 0));
        }

        @Override
        public List<B> loadBySqlAsList(String sql, Object[] argList, int[] fieldList) throws RuntimeDaoException {
            ListAction action = new ListAction();
            this.loadBySqlForAction(sql, argList, fieldList, 1, -1, action);
            return action.getList();
        }

        protected String createSelectSql(int[] fieldList, String where) {
            StringBuffer sql = new StringBuffer(128);
            String fullFields = this.getFullFields();
            if (null == fieldList || 0 == fieldList.length) {
                sql.append("SELECT ").append(fullFields);
            } else {
                sql.append("SELECT ");
                String[] names = fullFields.split(",");
                for (int i = 0; i < fieldList.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(names[fieldList[i]]);
                }
            }
            sql.append(" FROM " + this.getTableName() + " ");
            if (null != where) {
                sql.append(where);
            }
            return sql.toString();
        }

        @Override
        public int delete(B bean) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> T getReferencedBean(B bean, int fkIndex) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> T setReferencedBean(B bean, T beanToSet, int fkIndex) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> T[] getImportedBeans(B bean, int ikIndex) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> List<T> getImportedBeansAsList(B bean, int ikIndex) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>> T[] setImportedBeans(B bean, T[] importedBeans, int ikIndex) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends BaseBean<T>, C extends Collection<T>> C setImportedBeans(B bean, C importedBeans, int ikIndex) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public B loadByPrimaryKey(B bean) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public B loadByPrimaryKeyChecked(B bean) throws RuntimeDaoException, ObjectRetrievalException {
            throw new UnsupportedOperationException();
        }

        @Override
        public B loadByPrimaryKey(Object ... keys) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public B loadByPrimaryKeyChecked(Object ... keys) throws RuntimeDaoException, ObjectRetrievalException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int deleteByPrimaryKey(Object ... keys) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public B[] loadByIndex(int keyIndex, Object ... keys) throws RuntimeDaoException {
            return this.loadByIndexAsList(keyIndex, keys).toArray((BaseBean[])Array.newInstance(this.beanType(), 0));
        }

        @Override
        public List<B> loadByIndexAsList(int keyIndex, Object ... keys) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int deleteByIndex(int keyIndex, Object ... keys) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public B save(B bean, Object ... args) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public B saveCollection(B bean, Object ... args) throws RuntimeDaoException {
            throw new UnsupportedOperationException();
        }

        @Override
        public B saveAsTransaction(B bean, Object ... args) throws RuntimeDaoException {
            return (B)((BaseBean)this.runAsTransaction(new Callable<B>((BaseBean)bean, args){
                final /* synthetic */ BaseBean val$bean;
                final /* synthetic */ Object[] val$args;
                {
                    this.val$bean = baseBean;
                    this.val$args = objectArray;
                }

                @Override
                public B call() throws Exception {
                    return BaseAdapter.this.save(this.val$bean, this.val$args);
                }
            }));
        }

        @Override
        public B saveCollectionAsTransaction(B bean, Object ... args) throws RuntimeDaoException {
            return (B)((BaseBean)this.runAsTransaction(new Callable<B>((BaseBean)bean, args){
                final /* synthetic */ BaseBean val$bean;
                final /* synthetic */ Object[] val$args;
                {
                    this.val$bean = baseBean;
                    this.val$args = objectArray;
                }

                @Override
                public B call() throws Exception {
                    return BaseAdapter.this.saveCollection(this.val$bean, this.val$args);
                }
            }));
        }

        @Override
        public void runAsTransaction(final Runnable fun) throws RuntimeDaoException {
            this.runAsTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    fun.run();
                    return null;
                }
            });
        }

        public class ListAction
        implements Action<B> {
            final List<B> list = new LinkedList();

            public List<B> getList() {
                return this.list;
            }

            @Override
            public void call(B bean) {
                this.list.add(bean);
            }

            @Override
            public B getBean() {
                return null;
            }
        }
    }

    public static interface Action<B> {
        public void call(B var1) throws RuntimeDaoException;

        public B getBean();

        public static abstract class BaseAdapter<B>
        implements Action<B> {
            @Override
            public B getBean() {
                return null;
            }
        }
    }
}

