/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import gu.sql2java.BaseRow;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Objects;
import net.gdface.facedb.db.Constant;

@ThriftStruct
@ApiModel(description="\u7528\u4e8e\u9a8c\u8bc1\u8eab\u4efd\u7684\u4eba\u8138\u7279\u5f81\u6570\u636e\u8868")
public final class FeatureBean
extends BaseRow
implements Serializable,
Constant {
    private static final long serialVersionUID = 932068192335281810L;
    @ApiModelProperty(value="\u4e3b\u952e,\u7279\u5f81\u7801md5\u6821\u9a8c\u7801", required=true, dataType="String")
    private String md5;
    @ApiModelProperty(value="\u4e8c\u8fdb\u5236\u7279\u5f81\u6570\u636e", required=true, dataType="ByteBuffer")
    private ByteBuffer feature;
    @ApiModelProperty(value="create_time", dataType="Date")
    private Date createTime;
    @ApiModelProperty(value="columns modified flag", dataType="int", required=true)
    private int modified;
    @ApiModelProperty(value="columns initialized flag", dataType="int", required=true)
    private int initialized;
    @ApiModelProperty(value="new record flag", dataType="boolean", required=true)
    private boolean isNew;

    @ThriftField(value=1, name="_new", requiredness=ThriftField.Requiredness.REQUIRED)
    public boolean isNew() {
        return this.isNew;
    }

    @ThriftField
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField(value=2, requiredness=ThriftField.Requiredness.REQUIRED)
    public int getModified() {
        return this.modified;
    }

    @ThriftField
    public void setModified(int modified) {
        this.modified = modified;
    }

    @ThriftField(value=3, requiredness=ThriftField.Requiredness.REQUIRED)
    public int getInitialized() {
        return this.initialized;
    }

    @ThriftField
    public void setInitialized(int initialized) {
        this.initialized = initialized;
    }

    public FeatureBean() {
        this.reset();
    }

    public FeatureBean(String md5) {
        this.setMd5(md5);
    }

    @ThriftField(value=4)
    @JsonProperty(value="md5")
    public String getMd5() {
        return this.md5;
    }

    @ThriftField(name="md5")
    @JsonProperty(value="md5")
    public void setMd5(String newVal) {
        this.modified |= 1;
        this.initialized |= 1;
        if (Objects.equals(newVal, this.md5)) {
            return;
        }
        this.md5 = newVal;
    }

    public boolean checkMd5Modified() {
        return 0 != (this.modified & 1);
    }

    public boolean checkMd5Initialized() {
        return 0 != (this.initialized & 1);
    }

    @ThriftField(value=5)
    @JsonProperty(value="feature")
    public ByteBuffer getFeature() {
        return this.feature;
    }

    @ThriftField(name="feature")
    @JsonProperty(value="feature")
    public void setFeature(ByteBuffer newVal) {
        this.modified |= 2;
        this.initialized |= 2;
        if (Objects.equals(newVal, this.feature)) {
            return;
        }
        this.feature = newVal;
    }

    public boolean checkFeatureModified() {
        return 0 != (this.modified & 2);
    }

    public boolean checkFeatureInitialized() {
        return 0 != (this.initialized & 2);
    }

    @JsonIgnore
    public Date getCreateTime() {
        return this.createTime;
    }

    @ThriftField(value=6, name="createTime")
    @JsonProperty(value="createTime")
    public Long readCreateTime() {
        return null == this.createTime ? null : Long.valueOf(this.createTime.getTime());
    }

    @JsonIgnore
    public void setCreateTime(Date newVal) {
        this.modified |= 4;
        this.initialized |= 4;
        if (Objects.equals(newVal, this.createTime)) {
            return;
        }
        this.createTime = newVal;
    }

    @ThriftField(name="createTime")
    @JsonProperty(value="createTime")
    public void writeCreateTime(Long newVal) {
        this.createTime = null == newVal ? null : new Date(newVal);
    }

    @JsonIgnore
    public void setCreateTime(long newVal) {
        this.setCreateTime(new Date(newVal));
    }

    @JsonIgnore
    public void setCreateTime(Long newVal) {
        this.setCreateTime(null == newVal ? null : new Date(newVal));
    }

    public boolean checkCreateTimeModified() {
        return 0 != (this.modified & 4);
    }

    public boolean checkCreateTimeInitialized() {
        return 0 != (this.initialized & 4);
    }

    public boolean beModified() {
        return 0 != this.modified;
    }

    public boolean isModified(int columnID) {
        return columnID >= 0 && columnID < this.metaData.columnCount && 0 != (this.modified & 1 << columnID);
    }

    public boolean isInitialized(int columnID) {
        return columnID >= 0 && columnID < this.metaData.columnCount && 0 != (this.initialized & 1 << columnID);
    }

    public void resetIsModified() {
        this.modified = 0;
    }

    public void resetPrimaryKeysModified() {
        this.modified &= 0xFFFFFFFE;
    }

    public void resetModifiedExceptPrimaryKeys() {
        this.modified &= 0xFFFFFFF9;
    }

    public void reset() {
        this.md5 = null;
        this.feature = null;
        this.createTime = null;
        this.isNew = true;
        this.modified = 0;
        this.initialized = 0;
    }

    public FeatureBean clone() {
        return (FeatureBean)super.clone();
    }

    public static final Builder builder() {
        return new Builder().reset();
    }

    public static final class Builder {
        static final ThreadLocal<FeatureBean> TEMPLATE = new ThreadLocal<FeatureBean>(){

            @Override
            protected FeatureBean initialValue() {
                return new FeatureBean();
            }
        };

        private Builder() {
        }

        public Builder reset() {
            TEMPLATE.get().reset();
            return this;
        }

        public Builder template(FeatureBean bean) {
            if (null == bean) {
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }

        public FeatureBean build() {
            return TEMPLATE.get().clone();
        }

        public Builder md5(String md5) {
            TEMPLATE.get().setMd5(md5);
            return this;
        }

        public Builder feature(ByteBuffer feature) {
            TEMPLATE.get().setFeature(feature);
            return this;
        }

        public Builder createTime(Date createTime) {
            TEMPLATE.get().setCreateTime(createTime);
            return this;
        }
    }
}

