/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facedb.db;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonProperty;
import gu.sql2java.BaseRow;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.gdface.facedb.db.Constant;

@ThriftStruct
@ApiModel(description="\u4e8c\u8fdb\u5236\u6570\u636e\u5b58\u50a8\u8868")
public final class StoreBean
extends BaseRow
implements Serializable,
Constant {
    private static final long serialVersionUID = -4461098722616355232L;
    @ApiModelProperty(value="\u4e3b\u952e,md5\u68c0\u9a8c\u7801", required=true, dataType="String")
    private String md5;
    @ApiModelProperty(value="\u7f16\u7801\u7c7b\u578b,GBK,UTF8...", dataType="String")
    private String encoding;
    @ApiModelProperty(value="\u4e8c\u8fdb\u5236\u6570\u636e", dataType="ByteBuffer")
    private ByteBuffer data;
    @ApiModelProperty(value="columns modified flag", dataType="int", required=true)
    private int modified;
    @ApiModelProperty(value="columns initialized flag", dataType="int", required=true)
    private int initialized;
    @ApiModelProperty(value="new record flag", dataType="boolean", required=true)
    private boolean isNew;

    @ThriftField(value=1, name="_new", requiredness=ThriftField.Requiredness.REQUIRED)
    public boolean isNew() {
        return this.isNew;
    }

    @ThriftField
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @ThriftField(value=2, requiredness=ThriftField.Requiredness.REQUIRED)
    public int getModified() {
        return this.modified;
    }

    @ThriftField
    public void setModified(int modified) {
        this.modified = modified;
    }

    @ThriftField(value=3, requiredness=ThriftField.Requiredness.REQUIRED)
    public int getInitialized() {
        return this.initialized;
    }

    @ThriftField
    public void setInitialized(int initialized) {
        this.initialized = initialized;
    }

    public StoreBean() {
        this.reset();
    }

    public StoreBean(String md5) {
        this.setMd5(md5);
    }

    @ThriftField(value=4)
    @JsonProperty(value="md5")
    public String getMd5() {
        return this.md5;
    }

    @ThriftField(name="md5")
    @JsonProperty(value="md5")
    public void setMd5(String newVal) {
        this.modified |= 1;
        this.initialized |= 1;
        if (Objects.equals(newVal, this.md5)) {
            return;
        }
        this.md5 = newVal;
    }

    public boolean checkMd5Modified() {
        return 0 != (this.modified & 1);
    }

    public boolean checkMd5Initialized() {
        return 0 != (this.initialized & 1);
    }

    @ThriftField(value=5)
    @JsonProperty(value="encoding")
    public String getEncoding() {
        return this.encoding;
    }

    @ThriftField(name="encoding")
    @JsonProperty(value="encoding")
    public void setEncoding(String newVal) {
        this.modified |= 2;
        this.initialized |= 2;
        if (Objects.equals(newVal, this.encoding)) {
            return;
        }
        this.encoding = newVal;
    }

    public boolean checkEncodingModified() {
        return 0 != (this.modified & 2);
    }

    public boolean checkEncodingInitialized() {
        return 0 != (this.initialized & 2);
    }

    @ThriftField(value=6)
    @JsonProperty(value="data")
    public ByteBuffer getData() {
        return this.data;
    }

    @ThriftField(name="data")
    @JsonProperty(value="data")
    public void setData(ByteBuffer newVal) {
        this.modified |= 4;
        this.initialized |= 4;
        if (Objects.equals(newVal, this.data)) {
            return;
        }
        this.data = newVal;
    }

    public boolean checkDataModified() {
        return 0 != (this.modified & 4);
    }

    public boolean checkDataInitialized() {
        return 0 != (this.initialized & 4);
    }

    public boolean beModified() {
        return 0 != this.modified;
    }

    public boolean isModified(int columnID) {
        return columnID >= 0 && columnID < this.metaData.columnCount && 0 != (this.modified & 1 << columnID);
    }

    public boolean isInitialized(int columnID) {
        return columnID >= 0 && columnID < this.metaData.columnCount && 0 != (this.initialized & 1 << columnID);
    }

    public void resetIsModified() {
        this.modified = 0;
    }

    public void resetPrimaryKeysModified() {
        this.modified &= 0xFFFFFFFE;
    }

    public void resetModifiedExceptPrimaryKeys() {
        this.modified &= 0xFFFFFFF9;
    }

    public void reset() {
        this.md5 = null;
        this.encoding = null;
        this.data = null;
        this.isNew = true;
        this.modified = 0;
        this.initialized = 0;
    }

    public StoreBean clone() {
        return (StoreBean)super.clone();
    }

    public static final Builder builder() {
        return new Builder().reset();
    }

    public static final class Builder {
        static final ThreadLocal<StoreBean> TEMPLATE = new ThreadLocal<StoreBean>(){

            @Override
            protected StoreBean initialValue() {
                return new StoreBean();
            }
        };

        private Builder() {
        }

        public Builder reset() {
            TEMPLATE.get().reset();
            return this;
        }

        public Builder template(StoreBean bean) {
            if (null == bean) {
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }

        public StoreBean build() {
            return TEMPLATE.get().clone();
        }

        public Builder md5(String md5) {
            TEMPLATE.get().setMd5(md5);
            return this;
        }

        public Builder encoding(String encoding) {
            TEMPLATE.get().setEncoding(encoding);
            return this;
        }

        public Builder data(ByteBuffer data) {
            TEMPLATE.get().setData(data);
            return this;
        }
    }
}

