// ______________________________________________________
// Generated by sql2java - https://github.com/10km/sql2java 
// JDBC driver used at code generation time: com.mysql.jdbc.Driver
// template: bean.java.vm
// ______________________________________________________
package net.gdface.facedb.db;
import java.io.Serializable;
import java.util.Objects;

import gu.sql2java.BaseRow;

import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftField.Requiredness;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
/**
 * FeatureBean is a mapping of fd_feature Table.
 * <br>Meta Data Information (in progress):
 * <ul>
 *    <li>comments: 用于验证身份的人脸特征数据表 </li>
 * </ul>
 * @author guyadong
*/
@ThriftStruct
@ApiModel(description="用于验证身份的人脸特征数据表")
public final class FeatureBean extends BaseRow
    implements Serializable,Constant
{
    private static final long serialVersionUID = 932068192335281810L;

    /** comments:主键,特征码md5校验码 */
    @ApiModelProperty(value = "主键,特征码md5校验码" ,required=true ,dataType="String")
    private String md5;

    /** comments:二进制特征数据 */
    @ApiModelProperty(value = "二进制特征数据" ,required=true ,dataType="ByteBuffer")
    private java.nio.ByteBuffer feature;

    @ApiModelProperty(value = "create_time"  ,dataType="Date")
    private java.util.Date createTime;

    /** columns modified flag */
    @ApiModelProperty(value="columns modified flag",dataType="int",required=true)
    private int modified;
    /** columns initialized flag */
    @ApiModelProperty(value="columns initialized flag",dataType="int",required=true)
    private int initialized;
    /** new record flag  */
    @ApiModelProperty(value="new record flag",dataType="boolean",required=true)
    private boolean isNew;        
    @ThriftField(value=1,name="_new",requiredness=Requiredness.REQUIRED)
    @Override
    public boolean isNew()
    {
        return this.isNew;
    }

    /**
     * Specifies to the object if it has been set as new.
     *
     * @param isNew the boolean value to be assigned to the isNew field
     */
    @ThriftField()
    @Override
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }
    /**
     * @return the modified status of columns
     */
    @ThriftField(value=2,requiredness=Requiredness.REQUIRED)
    @Override
    public int getModified(){
        return modified;
    }

    /**
     * @param modified the modified status bit to be assigned to {@link #modified}
     */
    @ThriftField()
    @Override
    public void setModified(int modified){
        this.modified = modified;
    }
    /**
     * @return the initialized status of columns
     */
    @ThriftField(value=3,requiredness=Requiredness.REQUIRED)
    @Override
    public int getInitialized(){
        return initialized;
    }

    /**
     * @param initialized the initialized status bit to be assigned to {@link #initialized}
     */
    @ThriftField()
    @Override
    public void setInitialized(int initialized){
        this.initialized = initialized;
    }

    public FeatureBean(){
        reset();
    }
    /**
     * construct a new instance filled with primary keys
     * @param md5 PK# 1 
     */
    public FeatureBean(String md5){
        setMd5(md5);
    }
    /**
     * Getter method for {@link #md5}.<br>
     * PRIMARY KEY.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fd_feature.md5</li>
     * <li> imported key: fd_face.feature_md5</li>
     * <li>comments: 主键,特征码md5校验码</li>
     * <li>NOT NULL</li>
     * <li>column size: 32</li>
     * <li>JDBC type returned by the driver: Types.CHAR</li>
     * </ul>
     *
     * @return the value of md5
     */
    @ThriftField(value=4)
    @JsonProperty("md5")
    public String getMd5(){
        return md5;
    }
    /**
     * Setter method for {@link #md5}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to md5
     */
    @ThriftField(name="md5")
    @JsonProperty("md5")
    public void setMd5(String newVal)
    {
        modified |= FD_FEATURE_ID_MD5_MASK;
        initialized |= FD_FEATURE_ID_MD5_MASK;

        if (Objects.equals(newVal, md5)) {
            return;
        }
        md5 = newVal;
    }
    /**
     * Determines if the md5 has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkMd5Modified()
    {
        return 0 !=  (modified & FD_FEATURE_ID_MD5_MASK);
    }

    /**
     * Determines if the md5 has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkMd5Initialized()
    {
        return 0 !=  (initialized & FD_FEATURE_ID_MD5_MASK);
    }
    /**
     * Getter method for {@link #feature}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fd_feature.feature</li>
     * <li>comments: 二进制特征数据</li>
     * <li>NOT NULL</li>
     * <li>column size: 65535</li>
     * <li>JDBC type returned by the driver: Types.LONGVARBINARY</li>
     * </ul>
     *
     * @return the value of feature
     */
    @ThriftField(value=5)
    @JsonProperty("feature")
    public java.nio.ByteBuffer getFeature(){
        return feature;
    }
    /**
     * Setter method for {@link #feature}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to feature
     */
    @ThriftField(name="feature")
    @JsonProperty("feature")
    public void setFeature(java.nio.ByteBuffer newVal)
    {
        modified |= FD_FEATURE_ID_FEATURE_MASK;
        initialized |= FD_FEATURE_ID_FEATURE_MASK;

        if (Objects.equals(newVal, feature)) {
            return;
        }
        feature = newVal;
    }
    /**
     * Determines if the feature has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkFeatureModified()
    {
        return 0 !=  (modified & FD_FEATURE_ID_FEATURE_MASK);
    }

    /**
     * Determines if the feature has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkFeatureInitialized()
    {
        return 0 !=  (initialized & FD_FEATURE_ID_FEATURE_MASK);
    }
    /**
     * Getter method for {@link #createTime}.<br>
     * Meta Data Information (in progress):
     * <ul>
     * <li>full name: fd_feature.create_time</li>
     * <li>default value: 'CURRENT_TIMESTAMP'</li>
     * <li>NOT NULL</li>
     * <li>column size: 19</li>
     * <li>JDBC type returned by the driver: Types.TIMESTAMP</li>
     * </ul>
     *
     * @return the value of createTime
     */
    @JsonIgnore
    public java.util.Date getCreateTime(){
        return createTime;
    }
    /** 
     * use Long to represent date type for thrift:swift support 
     * @see #getCreateTime()
     */
    @ThriftField(value=6,name="createTime")
    @JsonProperty("createTime")
    public Long readCreateTime(){
        return null == createTime ? null:createTime.getTime();
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * The new value is set only if equals() says it is different,
     * or if one of either the new value or the current value is null.
     * In case the new value is different, it is set and the field is marked as 'modified'.
     *
     * @param newVal the new value( NOT NULL) to be assigned to createTime
     */
    @JsonIgnore
    public void setCreateTime(java.util.Date newVal)
    {
        modified |= FD_FEATURE_ID_CREATE_TIME_MASK;
        initialized |= FD_FEATURE_ID_CREATE_TIME_MASK;

        if (Objects.equals(newVal, createTime)) {
            return;
        }
        createTime = newVal;
    }
    /** 
     * setter for thrift:swift OR jackson support<br>
     * without modification for {@link #modified} and {@link #initialized}<br>
     * <b>NOTE:</b>DO NOT use the method in your code
     */
    @ThriftField(name="createTime")
    @JsonProperty("createTime")
    public void writeCreateTime(Long newVal){
        setCreateTime(null == newVal?null:new java.util.Date(newVal));
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * Convenient for those who do not want to deal with Objects for primary types.
     *
     * @param newVal the new value to be assigned to createTime
     */
    @JsonIgnore
    public void setCreateTime(long newVal)
    {
        setCreateTime(new java.util.Date(newVal));
    }
    /**
     * Setter method for {@link #createTime}.<br>
     * @param newVal the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this Date object.
     */
    @JsonIgnore
    public void setCreateTime(Long newVal)
    {
        setCreateTime(null == newVal ? null : new java.util.Date(newVal));
    }
    /**
     * Determines if the createTime has been modified.
     *
     * @return true if the field has been modified, false if the field has not been modified
     */
    public boolean checkCreateTimeModified()
    {
        return 0 !=  (modified & FD_FEATURE_ID_CREATE_TIME_MASK);
    }

    /**
     * Determines if the createTime has been initialized.<br>
     *
     * It is useful to determine if a field is null on purpose or just because it has not been initialized.
     *
     * @return true if the field has been initialized, false otherwise
     */
    public boolean checkCreateTimeInitialized()
    {
        return 0 !=  (initialized & FD_FEATURE_ID_CREATE_TIME_MASK);
    }

    @Override
    public boolean beModified()
    {
        return 0 != modified;
    }
  
    @Override
    public boolean isModified(int columnID){
        return columnID>=0 && columnID < metaData.columnCount && 0 !=  (modified & (1 << columnID));
    }

    @Override
    public boolean isInitialized(int columnID){
        return columnID>=0 && columnID < metaData.columnCount && 0 !=  (initialized & (1 << columnID));
    }
    
    @Override
    public void resetIsModified()
    {
        modified = 0;
    }

    @Override
    public void resetPrimaryKeysModified()
    {
        modified &= (~(FD_FEATURE_ID_MD5_MASK));
    }
    /**
     * Resets columns modification status except primary keys to 'not modified'.
     */
    public void resetModifiedExceptPrimaryKeys()
    {
        modified &= (~(FD_FEATURE_ID_FEATURE_MASK |
            FD_FEATURE_ID_CREATE_TIME_MASK));
    }

    /** reset all fields to initial value, equal to a new bean */
    public void reset(){
        this.md5 = null;
        this.feature = null;
        /* DEFAULT:'CURRENT_TIMESTAMP'*/
        this.createTime = null;
        this.isNew = true;
        this.modified = 0;
        this.initialized = 0;
    }

    @Override
    public FeatureBean clone(){
        return (FeatureBean) super.clone();
    }


    public static final Builder builder(){
        return new Builder().reset();
    }
    /** 
     * a builder for FeatureBean,the template instance is thread local variable
     * a instance of Builder can be reused.
     */
    public static final class Builder{
        /** FeatureBean instance used for template to create new FeatureBean instance. */
        static final ThreadLocal<FeatureBean> TEMPLATE = new ThreadLocal<FeatureBean>(){
            @Override
            protected FeatureBean initialValue() {
                return new FeatureBean();
            }};
        private Builder() {}
        /** 
         * reset the bean as template 
         * @see FeatureBean#reset()
         */
        public Builder reset(){
            TEMPLATE.get().reset();
            return this;
        }
        /** set a bean as template,must not be {@code null} */
        public Builder template(FeatureBean bean){
            if(null == bean){
                throw new NullPointerException();
            }
            TEMPLATE.set(bean);
            return this;
        }
        /** return a clone instance of {@link #TEMPLATE}*/
        public FeatureBean build(){
            return TEMPLATE.get().clone();
        }
        /** 
         * fill the field : fd_feature.md5
         * @param md5 主键,特征码md5校验码
         * @see FeatureBean#getMd5()
         * @see FeatureBean#setMd5(String)
         */
        public Builder md5(String md5){
            TEMPLATE.get().setMd5(md5);
            return this;
        }
        /** 
         * fill the field : fd_feature.feature
         * @param feature 二进制特征数据
         * @see FeatureBean#getFeature()
         * @see FeatureBean#setFeature(java.nio.ByteBuffer)
         */
        public Builder feature(java.nio.ByteBuffer feature){
            TEMPLATE.get().setFeature(feature);
            return this;
        }
        /** 
         * fill the field : fd_feature.create_time
         * @param createTime 
         * @see FeatureBean#getCreateTime()
         * @see FeatureBean#setCreateTime(java.util.Date)
         */
        public Builder createTime(java.util.Date createTime){
            TEMPLATE.get().setCreateTime(createTime);
            return this;
        }
    }
}
