package net.gdface.facelog.thrift;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.Token;
import net.gdface.facelog.db.DeviceBean;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.LogBean;
import net.gdface.facelog.db.LogLightBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.thrift.TypeTransformer;

import java.io.IOException;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;

import net.gdface.thrift.ClientFactory;
import static com.google.common.base.Preconditions.*;

/**
 * 基于thrift/swift框架生成的client端代码提供{@link IFaceLog}接口的异步RPC实现(线程安全)<br>
 * 转发所有{@link IFaceLog}接口方法到{@link net.gdface.facelog.client.thrift.IFaceLogClient}实例<br>
 * 所有服务端抛出的{@link RuntimeException}异常被封装到{@link ServiceRuntimeException}中抛出<br>
 * Example:<br>
 * <pre>
 *        IFaceLogThriftClientAsync thriftInstance = ClientFactory
 *            .builder()
 *            .setHostAndPort("127.0.0.1",26413)
 *            .build(IFaceLogThriftClientAsync.class);
 * </pre>
 * 计算机生成代码(generated by automated tools ThriftServiceDecoratorGenerator @author guyadong)<br>
 * @author guyadong
 *
 */
public class IFaceLogThriftClientAsync {
    private final ClientFactory factory;

    public IFaceLogThriftClientAsync(ClientFactory factory) {
        super();
        this.factory = checkNotNull(factory,"factory is null");
    }
    private class MethodCallback<L,R> implements ServiceMethodCallback<R>{
	    private final AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){
	        @Override
	        public void onTransportClosed() {
	        }
	
	        @Override
	        public void onError(Throwable error) {
	            MethodCallback.this.onError(error);
	        }
	    };
        final net.gdface.facelog.client.thrift.IFaceLogClient service = factory.applyInstance(net.gdface.facelog.client.thrift.IFaceLogClient.class,closeListener);
        final SettableFuture<L> feature = SettableFuture.create();
        final Function<R,L> transformer;

        MethodCallback(Function<R, L> transformer) {
            this.transformer = transformer;
        }

        @Override
        public void onSuccess(R result) {
            feature.set(transformer.apply(result));            
            try {
                service.close();
            } catch (IOException e) {
            }
        }

        @Override 
        public void onError(Throwable error) {            
            if(error instanceof ThriftException ){
                if(((ThriftException)error).kind == ThriftException.Kind.MISSING_RESULT  ){
                    this.onSuccess(null);
                }
            }
            feature.setException(error);
            try {
                service.close();
            } catch (IOException e) {
            }
        }
    }
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClientAsync [factory=");
        builder.append(factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }
    /**
     * 默认的{@link FutureCallback}实现
     * @author guyadong
     *
     * @param <V>
     */
    public static class DefaultCallback<V> implements FutureCallback<V>{
        @Override
        public void onSuccess(V result) {
            // DO NOTHING
        }
        @Override
        public void onFailure(Throwable t) {
            try{
                throw t;
            }
            catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
                onDuplicateRecordException(e);
            }
            catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
                onServiceSecurityException(e);
            }
            catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
                onServiceRuntimeException(e);
            }
            catch(Throwable e){
                onThrowable(e);
            }
        }
        protected void onDuplicateRecordException(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            System.out.println(e.serviceStackTraceMessage);
        }
        protected void onServiceSecurityException(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            System.out.println(e.serviceStackTraceMessage);
        }
        protected void onServiceRuntimeException(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            System.out.println(e.serviceStackTraceMessage);
        }
        protected void onThrowable(Throwable e){
            e.printStackTrace();
        }
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addFeature(byte[],java.lang.Integer,java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<FeatureBean> addFeature(byte[] feature,
        Integer personId,
        List<FaceBean> faecBeans,
        Token token){
        MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = 
            new MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean>(
                new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                        @Override
                        public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.addFeature(
                TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            personId,
            TypeTransformer.getInstance().to(
                    faecBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addFeature(byte[] feature,
        Integer personId,
        List<FaceBean> faecBeans,
        Token token,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(addFeature(feature,personId,faecBeans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addFeature(byte[],java.lang.Integer,java.util.Map,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<FeatureBean> addFeature(byte[] feature,
        Integer personId,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token){
        MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = 
            new MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean>(
                new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                        @Override
                        public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.addFeatureMulti(
                TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            personId,
            TypeTransformer.getInstance().to(
                    faceInfo,
                    ByteBuffer.class,
                    FaceBean.class,
                    okio.ByteString.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addFeature(byte[] feature,
        Integer personId,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(addFeature(feature,personId,faceInfo,deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addImage(byte[],java.lang.Integer,net.gdface.facelog.db.FaceBean,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<ImageBean> addImage(byte[] imageData,
        Integer deviceId,
        FaceBean faceBean,
        Integer personId,
        Token token){
        MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean> nativeCallback = 
            new MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean>(
                new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>() {
                        @Override
                        public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }});
        nativeCallback.service.addImage(
                TypeTransformer.getInstance().to(
                    imageData,
                    byte[].class,
                    okio.ByteString.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addImage(byte[] imageData,
        Integer deviceId,
        FaceBean faceBean,
        Integer personId,
        Token token,
        FutureCallback<ImageBean>callback){
        factory.addCallback(addImage(imageData,deviceId,faceBean,personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLog(net.gdface.facelog.db.LogBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLog(LogBean bean,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addLog(
                TypeTransformer.getInstance().to(
                    bean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addLog(LogBean bean,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLog(bean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLogs(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLogs(List<LogBean> beans,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addLogs(
                TypeTransformer.getInstance().to(
                    beans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addLogs(List<LogBean> beans,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLogs(beans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addPermit(int,int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addPermit(int deviceGroupId,
        int personGroupId,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addPermitById(
                deviceGroupId,
            personGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addPermit(int deviceGroupId,
        int personGroupId,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addPermit(deviceGroupId,personGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addPermit(net.gdface.facelog.db.DeviceGroupBean,net.gdface.facelog.db.PersonGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addPermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addPermit(
                TypeTransformer.getInstance().to(
                    deviceGroup,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
            TypeTransformer.getInstance().to(
                    personGroup,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addPermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addPermit(deviceGroup,personGroup,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyAckChannel(net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> applyAckChannel(Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.applyAckChannel(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void applyAckChannel(Token token,
        FutureCallback<String>callback){
        factory.addCallback(applyAckChannel(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyAckChannel(net.gdface.facelog.Token,long)}
     */
    public ListenableFuture<String> applyAckChannel(Token token,
        long duration){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.applyAckChannelWithDuration(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),
            duration,nativeCallback);
        return nativeCallback.feature;
    }
    public void applyAckChannel(Token token,
        long duration,
        FutureCallback<String>callback){
        factory.addCallback(applyAckChannel(token,duration), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyCmdSn(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Long> applyCmdSn(Token token){
        MethodCallback<Long,Long> nativeCallback = 
            new MethodCallback<Long,Long>(
                new Function<Long,Long>() {
                        @Override
                        public Long apply(Long input) {
                            return input;
                }});
        nativeCallback.service.applyCmdSn(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void applyCmdSn(Token token,
        FutureCallback<Long>callback){
        factory.addCallback(applyCmdSn(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyPersonToken(int,java.lang.String,boolean)}
     */
    public ListenableFuture<Token> applyPersonToken(int personId,
        String password,
        boolean isMd5){
        MethodCallback<Token,net.gdface.facelog.client.thrift.Token> nativeCallback = 
            new MethodCallback<Token,net.gdface.facelog.client.thrift.Token>(
                new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                        @Override
                        public Token apply(net.gdface.facelog.client.thrift.Token input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }});
        nativeCallback.service.applyPersonToken(
                personId,
            password,
            isMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void applyPersonToken(int personId,
        String password,
        boolean isMd5,
        FutureCallback<Token>callback){
        factory.addCallback(applyPersonToken(personId,password,isMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyRootToken(java.lang.String,boolean)}
     */
    public ListenableFuture<Token> applyRootToken(String password,
        boolean isMd5){
        MethodCallback<Token,net.gdface.facelog.client.thrift.Token> nativeCallback = 
            new MethodCallback<Token,net.gdface.facelog.client.thrift.Token>(
                new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                        @Override
                        public Token apply(net.gdface.facelog.client.thrift.Token input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }});
        nativeCallback.service.applyRootToken(
                password,
            isMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void applyRootToken(String password,
        boolean isMd5,
        FutureCallback<Token>callback){
        factory.addCallback(applyRootToken(password,isMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countDeviceByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countDeviceByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countDeviceByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countDeviceByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countDeviceByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countDeviceGroupByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countDeviceGroupByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countDeviceGroupByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countDeviceGroupByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countDeviceGroupByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countLogByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countLogByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countLogByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogLightByVerifyTime(long)}
     */
    public ListenableFuture<Integer> countLogLightByVerifyTime(long timestamp){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countLogLightByVerifyTime(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void countLogLightByVerifyTime(long timestamp,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogLightByVerifyTime(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogLightByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countLogLightByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countLogLightByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countLogLightByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogLightByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countPersonByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countPersonByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countPersonByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countPersonByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countPersonByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countPersonGroupByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countPersonGroupByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countPersonGroupByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countPersonGroupByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countPersonGroupByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteAllFeaturesByPersonId(int,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteAllFeaturesByPersonId(int personId,
        boolean deleteImage,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteAllFeaturesByPersonId(
                personId,
            deleteImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteAllFeaturesByPersonId(int personId,
        boolean deleteImage,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteAllFeaturesByPersonId(personId,deleteImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteDeviceGroup(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteDeviceGroup(int deviceGroupId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteDeviceGroup(
                deviceGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteDeviceGroup(int deviceGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteDeviceGroup(deviceGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteFeature(java.lang.String,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<List<String>> deleteFeature(String featureMd5,
        boolean deleteImage,
        Token token){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.deleteFeature(
                featureMd5,
            deleteImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteFeature(String featureMd5,
        boolean deleteImage,
        Token token,
        FutureCallback<List<String>>callback){
        factory.addCallback(deleteFeature(featureMd5,deleteImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteImage(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteImage(String imageMd5,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteImage(
                imageMd5,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteImage(String imageMd5,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteImage(imageMd5,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePermit(net.gdface.facelog.db.DeviceGroupBean,net.gdface.facelog.db.PersonGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePermit(
                TypeTransformer.getInstance().to(
                    deviceGroup,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
            TypeTransformer.getInstance().to(
                    personGroup,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePermit(DeviceGroupBean deviceGroup,
        PersonGroupBean personGroup,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePermit(deviceGroup,personGroup,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePerson(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePerson(int personId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePerson(
                personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePerson(int personId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePerson(personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonByPapersNum(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonByPapersNum(String papersNum,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersonByPapersNum(
                papersNum,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersonByPapersNum(String papersNum,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonByPapersNum(papersNum,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonGroup(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonGroup(int personGroupId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersonGroup(
                personGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersonGroup(int personGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonGroup(personGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersons(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersons(List<Integer> personIdList,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersons(
                TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersons(List<Integer> personIdList,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersons(personIdList,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonsByPapersNum(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonsByPapersNum(List<String> papersNumlist,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersonsByPapersNum(
                TypeTransformer.getInstance().to(
                    papersNumlist,
                    String.class,
                    String.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersonsByPapersNum(List<String> papersNumlist,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonsByPapersNum(papersNumlist,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#disablePerson(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> disablePerson(int personId,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.disablePerson(
                personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void disablePerson(int personId,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(disablePerson(personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#disablePerson(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> disablePerson(List<Integer> personIdList,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.disablePersonList(
                TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void disablePerson(List<Integer> personIdList,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(disablePerson(personIdList,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsDevice(int)}
     */
    public ListenableFuture<Boolean> existsDevice(int id){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.existsDevice(
                id,nativeCallback);
        return nativeCallback.feature;
    }
    public void existsDevice(int id,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsDevice(id), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsFeature(java.lang.String)}
     */
    public ListenableFuture<Boolean> existsFeature(String md5){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.existsFeature(
                md5,nativeCallback);
        return nativeCallback.feature;
    }
    public void existsFeature(String md5,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsFeature(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsImage(java.lang.String)}
     */
    public ListenableFuture<Boolean> existsImage(String md5){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.existsImage(
                md5,nativeCallback);
        return nativeCallback.feature;
    }
    public void existsImage(String md5,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsImage(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsPerson(int)}
     */
    public ListenableFuture<Boolean> existsPerson(int persionId){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.existsPerson(
                persionId,nativeCallback);
        return nativeCallback.feature;
    }
    public void existsPerson(int persionId,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsPerson(persionId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevice(int)}
     */
    public ListenableFuture<DeviceBean> getDevice(int deviceId){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.getDevice(
                deviceId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDevice(int deviceId,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(getDevice(deviceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroup(int)}
     */
    public ListenableFuture<DeviceGroupBean> getDeviceGroup(int deviceGroupId){
        MethodCallback<DeviceGroupBean,net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback = 
            new MethodCallback<DeviceGroupBean,net.gdface.facelog.client.thrift.DeviceGroupBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceGroupBean,DeviceGroupBean>() {
                        @Override
                        public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }});
        nativeCallback.service.getDeviceGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceGroup(int deviceGroupId,
        FutureCallback<DeviceGroupBean>callback){
        factory.addCallback(getDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroups(java.util.List)}
     */
    public ListenableFuture<List<DeviceGroupBean>> getDeviceGroups(List<Integer> groupIdList){
        MethodCallback<List<DeviceGroupBean>,List<net.gdface.facelog.client.thrift.DeviceGroupBean>> nativeCallback = 
            new MethodCallback<List<DeviceGroupBean>,List<net.gdface.facelog.client.thrift.DeviceGroupBean>>(
                new Function<List<net.gdface.facelog.client.thrift.DeviceGroupBean>,List<DeviceGroupBean>>() {
                        @Override
                        public List<DeviceGroupBean> apply(List<net.gdface.facelog.client.thrift.DeviceGroupBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }});
        nativeCallback.service.getDeviceGroups(
                TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceGroups(List<Integer> groupIdList,
        FutureCallback<List<DeviceGroupBean>>callback){
        factory.addCallback(getDeviceGroups(groupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroupsBelongs(int)}
     */
    public ListenableFuture<List<Integer>> getDeviceGroupsBelongs(int deviceId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getDeviceGroupsBelongs(
                deviceId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceGroupsBelongs(int deviceId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getDeviceGroupsBelongs(deviceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceIdOfFeature(java.lang.String)}
     */
    public ListenableFuture<Integer> getDeviceIdOfFeature(String featureMd5){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.getDeviceIdOfFeature(
                featureMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceIdOfFeature(String featureMd5,
        FutureCallback<Integer>callback){
        factory.addCallback(getDeviceIdOfFeature(featureMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevices(java.util.List)}
     */
    public ListenableFuture<List<DeviceBean>> getDevices(List<Integer> idList){
        MethodCallback<List<DeviceBean>,List<net.gdface.facelog.client.thrift.DeviceBean>> nativeCallback = 
            new MethodCallback<List<DeviceBean>,List<net.gdface.facelog.client.thrift.DeviceBean>>(
                new Function<List<net.gdface.facelog.client.thrift.DeviceBean>,List<DeviceBean>>() {
                        @Override
                        public List<DeviceBean> apply(List<net.gdface.facelog.client.thrift.DeviceBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.getDevices(
                TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getDevices(List<Integer> idList,
        FutureCallback<List<DeviceBean>>callback){
        factory.addCallback(getDevices(idList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevicesOfGroup(int)}
     */
    public ListenableFuture<List<Integer>> getDevicesOfGroup(int deviceGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getDevicesOfGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDevicesOfGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getDevicesOfGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeature(java.lang.String)}
     */
    public ListenableFuture<FeatureBean> getFeature(String md5){
        MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = 
            new MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean>(
                new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                        @Override
                        public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.getFeature(
                md5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeature(String md5,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(getFeature(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatureBeansByPersonId(int)}
     */
    public ListenableFuture<List<String>> getFeatureBeansByPersonId(int personId){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getFeatureBeansByPersonId(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeatureBeansByPersonId(int personId,
        FutureCallback<List<String>>callback){
        factory.addCallback(getFeatureBeansByPersonId(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatureBytes(java.lang.String)}
     */
    public ListenableFuture<byte[]> getFeatureBytes(String md5){
        MethodCallback<byte[],okio.ByteString> nativeCallback = 
            new MethodCallback<byte[],okio.ByteString>(
                new Function<okio.ByteString,byte[]>() {
                        @Override
                        public byte[] apply(okio.ByteString input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }});
        nativeCallback.service.getFeatureBytes(
                md5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeatureBytes(String md5,
        FutureCallback<byte[]>callback){
        factory.addCallback(getFeatureBytes(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatures(java.util.List)}
     */
    public ListenableFuture<List<FeatureBean>> getFeatures(List<String> md5){
        MethodCallback<List<FeatureBean>,List<net.gdface.facelog.client.thrift.FeatureBean>> nativeCallback = 
            new MethodCallback<List<FeatureBean>,List<net.gdface.facelog.client.thrift.FeatureBean>>(
                new Function<List<net.gdface.facelog.client.thrift.FeatureBean>,List<FeatureBean>>() {
                        @Override
                        public List<FeatureBean> apply(List<net.gdface.facelog.client.thrift.FeatureBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.getFeatures(
                TypeTransformer.getInstance().to(
                    md5,
                    String.class,
                    String.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeatures(List<String> md5,
        FutureCallback<List<FeatureBean>>callback){
        factory.addCallback(getFeatures(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeaturesOfPerson(int)}
     */
    public ListenableFuture<List<String>> getFeaturesOfPerson(int personId){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getFeaturesOfPerson(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeaturesOfPerson(int personId,
        FutureCallback<List<String>>callback){
        factory.addCallback(getFeaturesOfPerson(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getGroupPermit(int,int)}
     */
    public ListenableFuture<Boolean> getGroupPermit(int deviceId,
        int personGroupId){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.getGroupPermit(
                deviceId,
            personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getGroupPermit(int deviceId,
        int personGroupId,
        FutureCallback<Boolean>callback){
        factory.addCallback(getGroupPermit(deviceId,personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getGroupPermits(int,java.util.List)}
     */
    public ListenableFuture<List<Boolean>> getGroupPermits(int deviceId,
        List<Integer> personGroupIdList){
        MethodCallback<List<Boolean>,List<Boolean>> nativeCallback = 
            new MethodCallback<List<Boolean>,List<Boolean>>(
                new Function<List<Boolean>,List<Boolean>>() {
                        @Override
                        public List<Boolean> apply(List<Boolean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Boolean.class,
                    Boolean.class);
                }});
        nativeCallback.service.getGroupPermits(
                deviceId,
            TypeTransformer.getInstance().to(
                    personGroupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getGroupPermits(int deviceId,
        List<Integer> personGroupIdList,
        FutureCallback<List<Boolean>>callback){
        factory.addCallback(getGroupPermits(deviceId,personGroupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImage(java.lang.String)}
     */
    public ListenableFuture<ImageBean> getImage(String imageMD5){
        MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean> nativeCallback = 
            new MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean>(
                new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>() {
                        @Override
                        public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }});
        nativeCallback.service.getImage(
                imageMD5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getImage(String imageMD5,
        FutureCallback<ImageBean>callback){
        factory.addCallback(getImage(imageMD5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImageBytes(java.lang.String)}
     */
    public ListenableFuture<byte[]> getImageBytes(String imageMD5){
        MethodCallback<byte[],okio.ByteString> nativeCallback = 
            new MethodCallback<byte[],okio.ByteString>(
                new Function<okio.ByteString,byte[]>() {
                        @Override
                        public byte[] apply(okio.ByteString input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }});
        nativeCallback.service.getImageBytes(
                imageMD5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getImageBytes(String imageMD5,
        FutureCallback<byte[]>callback){
        factory.addCallback(getImageBytes(imageMD5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImagesAssociatedByFeature(java.lang.String)}
     */
    public ListenableFuture<List<String>> getImagesAssociatedByFeature(String featureMd5){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getImagesAssociatedByFeature(
                featureMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getImagesAssociatedByFeature(String featureMd5,
        FutureCallback<List<String>>callback){
        factory.addCallback(getImagesAssociatedByFeature(featureMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getLogBeansByPersonId(int)}
     */
    public ListenableFuture<List<LogBean>> getLogBeansByPersonId(int personId){
        MethodCallback<List<LogBean>,List<net.gdface.facelog.client.thrift.LogBean>> nativeCallback = 
            new MethodCallback<List<LogBean>,List<net.gdface.facelog.client.thrift.LogBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogBean>,List<LogBean>>() {
                        @Override
                        public List<LogBean> apply(List<net.gdface.facelog.client.thrift.LogBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
                }});
        nativeCallback.service.getLogBeansByPersonId(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getLogBeansByPersonId(int personId,
        FutureCallback<List<LogBean>>callback){
        factory.addCallback(getLogBeansByPersonId(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPerson(int)}
     */
    public ListenableFuture<PersonBean> getPerson(int personId){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPerson(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPerson(int personId,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPerson(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonByPapersNum(java.lang.String)}
     */
    public ListenableFuture<PersonBean> getPersonByPapersNum(String papersNum){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersonByPapersNum(
                papersNum,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonByPapersNum(String papersNum,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPersonByPapersNum(papersNum), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroup(int)}
     */
    public ListenableFuture<PersonGroupBean> getPersonGroup(int personGroupId){
        MethodCallback<PersonGroupBean,net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback = 
            new MethodCallback<PersonGroupBean,net.gdface.facelog.client.thrift.PersonGroupBean>(
                new Function<net.gdface.facelog.client.thrift.PersonGroupBean,PersonGroupBean>() {
                        @Override
                        public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }});
        nativeCallback.service.getPersonGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonGroup(int personGroupId,
        FutureCallback<PersonGroupBean>callback){
        factory.addCallback(getPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroups(java.util.List)}
     */
    public ListenableFuture<List<PersonGroupBean>> getPersonGroups(List<Integer> groupIdList){
        MethodCallback<List<PersonGroupBean>,List<net.gdface.facelog.client.thrift.PersonGroupBean>> nativeCallback = 
            new MethodCallback<List<PersonGroupBean>,List<net.gdface.facelog.client.thrift.PersonGroupBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PersonGroupBean>,List<PersonGroupBean>>() {
                        @Override
                        public List<PersonGroupBean> apply(List<net.gdface.facelog.client.thrift.PersonGroupBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }});
        nativeCallback.service.getPersonGroups(
                TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonGroups(List<Integer> groupIdList,
        FutureCallback<List<PersonGroupBean>>callback){
        factory.addCallback(getPersonGroups(groupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroupsBelongs(int)}
     */
    public ListenableFuture<List<Integer>> getPersonGroupsBelongs(int personId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getPersonGroupsBelongs(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonGroupsBelongs(int personId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getPersonGroupsBelongs(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonPermit(int,int)}
     */
    public ListenableFuture<Boolean> getPersonPermit(int deviceId,
        int personId){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.getPersonPermit(
                deviceId,
            personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonPermit(int deviceId,
        int personId,
        FutureCallback<Boolean>callback){
        factory.addCallback(getPersonPermit(deviceId,personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonPermits(int,java.util.List)}
     */
    public ListenableFuture<List<Boolean>> getPersonPermits(int deviceId,
        List<Integer> personIdList){
        MethodCallback<List<Boolean>,List<Boolean>> nativeCallback = 
            new MethodCallback<List<Boolean>,List<Boolean>>(
                new Function<List<Boolean>,List<Boolean>>() {
                        @Override
                        public List<Boolean> apply(List<Boolean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Boolean.class,
                    Boolean.class);
                }});
        nativeCallback.service.getPersonPermits(
                deviceId,
            TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonPermits(int deviceId,
        List<Integer> personIdList,
        FutureCallback<List<Boolean>>callback){
        factory.addCallback(getPersonPermits(deviceId,personIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersons(java.util.List)}
     */
    public ListenableFuture<List<PersonBean>> getPersons(List<Integer> idList){
        MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = 
            new MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                        @Override
                        public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersons(
                TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersons(List<Integer> idList,
        FutureCallback<List<PersonBean>>callback){
        factory.addCallback(getPersons(idList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonsOfGroup(int)}
     */
    public ListenableFuture<List<Integer>> getPersonsOfGroup(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getPersonsOfGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonsOfGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getPersonsOfGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getProperty(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> getProperty(String key,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.getProperty(
                key,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getProperty(String key,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(getProperty(key,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getRedisParameters(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<MQParam, String>> getRedisParameters(Token token){
        MethodCallback<Map<MQParam, String>,Map<net.gdface.facelog.client.thrift.MQParam,String>> nativeCallback = 
            new MethodCallback<Map<MQParam, String>,Map<net.gdface.facelog.client.thrift.MQParam,String>>(
                new Function<Map<net.gdface.facelog.client.thrift.MQParam,String>,Map<MQParam, String>>() {
                        @Override
                        public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.MQParam.class,
                    String.class,
                    MQParam.class,
                    String.class);
                }});
        nativeCallback.service.getRedisParameters(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getRedisParameters(Token token,
        FutureCallback<Map<MQParam, String>>callback){
        factory.addCallback(getRedisParameters(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getServiceConfig(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<String, String>> getServiceConfig(Token token){
        MethodCallback<Map<String, String>,Map<String,String>> nativeCallback = 
            new MethodCallback<Map<String, String>,Map<String,String>>(
                new Function<Map<String,String>,Map<String, String>>() {
                        @Override
                        public Map<String, String> apply(Map<String,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getServiceConfig(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getServiceConfig(Token token,
        FutureCallback<Map<String, String>>callback){
        factory.addCallback(getServiceConfig(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getSubDeviceGroup(int)}
     */
    public ListenableFuture<List<Integer>> getSubDeviceGroup(int deviceGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getSubDeviceGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getSubDeviceGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getSubDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getSubPersonGroup(int)}
     */
    public ListenableFuture<List<Integer>> getSubPersonGroup(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getSubPersonGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getSubPersonGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getSubPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isDisable(int)}
     */
    public ListenableFuture<Boolean> isDisable(int personId){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isDisable(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void isDisable(int personId,
        FutureCallback<Boolean>callback){
        factory.addCallback(isDisable(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isLocal()}
     */
    public boolean isLocal(){
        return false;
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidAckChannel(java.lang.String)}
     */
    public ListenableFuture<Boolean> isValidAckChannel(String ackChannel){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidAckChannel(
                ackChannel,nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidAckChannel(String ackChannel,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidAckChannel(ackChannel), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidCmdSn(long)}
     */
    public ListenableFuture<Boolean> isValidCmdSn(long cmdSn){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidCmdSn(
                cmdSn,nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidCmdSn(long cmdSn,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidCmdSn(cmdSn), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidPassword(java.lang.String,java.lang.String,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> isValidPassword(String userId,
        String password,
        boolean isMd5,
        Token token){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidPassword(
                userId,
            password,
            isMd5,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidPassword(String userId,
        String password,
        boolean isMd5,
        Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidPassword(userId,password,isMd5,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#listOfParentForDeviceGroup(int)}
     */
    public ListenableFuture<List<Integer>> listOfParentForDeviceGroup(int deviceGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.listOfParentForDeviceGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void listOfParentForDeviceGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(listOfParentForDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#listOfParentForPersonGroup(int)}
     */
    public ListenableFuture<List<Integer>> listOfParentForPersonGroup(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.listOfParentForPersonGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void listOfParentForPersonGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(listOfParentForPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadAllPerson()}
     */
    public ListenableFuture<List<Integer>> loadAllPerson(){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadAllPerson(
                nativeCallback);
        return nativeCallback.feature;
    }
    public void loadAllPerson(FutureCallback<List<Integer>>callback){
        factory.addCallback(loadAllPerson(), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<DeviceBean>> loadDeviceByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<DeviceBean>,List<net.gdface.facelog.client.thrift.DeviceBean>> nativeCallback = 
            new MethodCallback<List<DeviceBean>,List<net.gdface.facelog.client.thrift.DeviceBean>>(
                new Function<List<net.gdface.facelog.client.thrift.DeviceBean>,List<DeviceBean>>() {
                        @Override
                        public List<DeviceBean> apply(List<net.gdface.facelog.client.thrift.DeviceBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.loadDeviceByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDeviceByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<DeviceBean>>callback){
        factory.addCallback(loadDeviceByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceGroupByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<Integer>> loadDeviceGroupByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadDeviceGroupByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDeviceGroupByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceGroupByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceGroupIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadDeviceGroupIdByWhere(String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadDeviceGroupIdByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDeviceGroupIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceGroupIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadDeviceIdByWhere(String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadDeviceIdByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDeviceIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadFeatureMd5ByUpdate(long)}
     */
    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(long timestamp){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.loadFeatureMd5ByUpdate(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadFeatureMd5ByUpdate(long timestamp,
        FutureCallback<List<String>>callback){
        factory.addCallback(loadFeatureMd5ByUpdate(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<LogBean>> loadLogByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<LogBean>,List<net.gdface.facelog.client.thrift.LogBean>> nativeCallback = 
            new MethodCallback<List<LogBean>,List<net.gdface.facelog.client.thrift.LogBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogBean>,List<LogBean>>() {
                        @Override
                        public List<LogBean> apply(List<net.gdface.facelog.client.thrift.LogBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
                }});
        nativeCallback.service.loadLogByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadLogByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<LogBean>>callback){
        factory.addCallback(loadLogByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogLightByVerifyTime(long,int,int)}
     */
    public ListenableFuture<List<LogLightBean>> loadLogLightByVerifyTime(long timestamp,
        int startRow,
        int numRows){
        MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>> nativeCallback = 
            new MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>() {
                        @Override
                        public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }});
        nativeCallback.service.loadLogLightByVerifyTime(
                timestamp,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadLogLightByVerifyTime(long timestamp,
        int startRow,
        int numRows,
        FutureCallback<List<LogLightBean>>callback){
        factory.addCallback(loadLogLightByVerifyTime(timestamp,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogLightByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<LogLightBean>> loadLogLightByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>> nativeCallback = 
            new MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>() {
                        @Override
                        public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }});
        nativeCallback.service.loadLogLightByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadLogLightByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<LogLightBean>>callback){
        factory.addCallback(loadLogLightByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPermitByUpdate(long)}
     */
    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(long timestamp){
        MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = 
            new MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                        @Override
                        public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.loadPermitByUpdate(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPermitByUpdate(long timestamp,
        FutureCallback<List<PermitBean>>callback){
        factory.addCallback(loadPermitByUpdate(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<PersonBean>> loadPersonByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = 
            new MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                        @Override
                        public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.loadPersonByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<PersonBean>>callback){
        factory.addCallback(loadPersonByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonGroupByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<Integer>> loadPersonGroupByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonGroupByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonGroupByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonGroupByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonGroupIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadPersonGroupIdByWhere(String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonGroupIdByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonGroupIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonGroupIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonIdByUpdateTime(long)}
     */
    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(long timestamp){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonIdByUpdateTime(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonIdByUpdateTime(long timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonIdByUpdateTime(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadPersonIdByWhere(String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonIdByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadUpdatedPersons(long)}
     */
    public ListenableFuture<List<Integer>> loadUpdatedPersons(long timestamp){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadUpdatedPersons(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadUpdatedPersons(long timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadUpdatedPersons(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#offline(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> offline(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.offline(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void offline(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(offline(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#online(net.gdface.facelog.db.DeviceBean)}
     */
    public ListenableFuture<Token> online(DeviceBean device){
        MethodCallback<Token,net.gdface.facelog.client.thrift.Token> nativeCallback = 
            new MethodCallback<Token,net.gdface.facelog.client.thrift.Token>(
                new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                        @Override
                        public Token apply(net.gdface.facelog.client.thrift.Token input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }});
        nativeCallback.service.online(
                TypeTransformer.getInstance().to(
                    device,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void online(DeviceBean device,
        FutureCallback<Token>callback){
        factory.addCallback(online(device), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#registerDevice(net.gdface.facelog.db.DeviceBean)}
     */
    public ListenableFuture<DeviceBean> registerDevice(DeviceBean newDevice){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.registerDevice(
                TypeTransformer.getInstance().to(
                    newDevice,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void registerDevice(DeviceBean newDevice,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(registerDevice(newDevice), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#releasePersonToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> releasePersonToken(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.releasePersonToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void releasePersonToken(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(releasePersonToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#releaseRootToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> releaseRootToken(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.releaseRootToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void releaseRootToken(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(releaseRootToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#replaceFeature(java.lang.Integer,java.lang.String,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> replaceFeature(Integer personId,
        String featureMd5,
        boolean deleteOldFeatureImage,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.replaceFeature(
                personId,
            featureMd5,
            deleteOldFeatureImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void replaceFeature(Integer personId,
        String featureMd5,
        boolean deleteOldFeatureImage,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(replaceFeature(personId,featureMd5,deleteOldFeatureImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveDevice(net.gdface.facelog.db.DeviceBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceBean> saveDevice(DeviceBean deviceBean,
        Token token){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.saveDevice(
                TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void saveDevice(DeviceBean deviceBean,
        Token token,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(saveDevice(deviceBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveDeviceGroup(net.gdface.facelog.db.DeviceGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceGroupBean> saveDeviceGroup(DeviceGroupBean deviceGroupBean,
        Token token){
        MethodCallback<DeviceGroupBean,net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback = 
            new MethodCallback<DeviceGroupBean,net.gdface.facelog.client.thrift.DeviceGroupBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceGroupBean,DeviceGroupBean>() {
                        @Override
                        public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }});
        nativeCallback.service.saveDeviceGroup(
                TypeTransformer.getInstance().to(
                    deviceGroupBean,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void saveDeviceGroup(DeviceGroupBean deviceGroupBean,
        Token token,
        FutureCallback<DeviceGroupBean>callback){
        factory.addCallback(saveDeviceGroup(deviceGroupBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],byte[],net.gdface.facelog.db.FaceBean,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        byte[] featureImage,
        FaceBean featureFaceBean,
        Integer deviceId,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonFull(
                TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    featureImage,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    featureFaceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        byte[] featureImage,
        FaceBean featureFaceBean,
        Integer deviceId,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,feature,featureImage,featureFaceBean,deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        List<FaceBean> faceBeans,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhotoAndFeatureMultiFaces(
                TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    faceBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        List<FaceBean> faceBeans,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,feature,faceBeans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],java.util.Map,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhotoAndFeatureMultiImage(
                TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    faceInfo,
                    ByteBuffer.class,
                    FaceBean.class,
                    okio.ByteString.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        byte[] feature,
        Map<ByteBuffer, FaceBean> faceInfo,
        Integer deviceId,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,feature,faceInfo,deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhoto(
                TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],net.gdface.facelog.db.FeatureBean,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        byte[] idPhoto,
        FeatureBean featureBean,
        Integer deviceId,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhotoAndFeature(
                TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    featureBean,
                    FeatureBean.class,
                    net.gdface.facelog.client.thrift.FeatureBean.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean bean,
        byte[] idPhoto,
        FeatureBean featureBean,
        Integer deviceId,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhoto,featureBean,deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        String idPhotoMd5,
        String featureMd5,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhotoAndFeatureSaved(
                TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            idPhotoMd5,
            featureMd5,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean bean,
        String idPhotoMd5,
        String featureMd5,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,idPhotoMd5,featureMd5,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean bean,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePerson(
                TypeTransformer.getInstance().to(
                    bean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean bean,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(bean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersonGroup(net.gdface.facelog.db.PersonGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonGroupBean> savePersonGroup(PersonGroupBean personGroupBean,
        Token token){
        MethodCallback<PersonGroupBean,net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback = 
            new MethodCallback<PersonGroupBean,net.gdface.facelog.client.thrift.PersonGroupBean>(
                new Function<net.gdface.facelog.client.thrift.PersonGroupBean,PersonGroupBean>() {
                        @Override
                        public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }});
        nativeCallback.service.savePersonGroup(
                TypeTransformer.getInstance().to(
                    personGroupBean,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePersonGroup(PersonGroupBean personGroupBean,
        Token token,
        FutureCallback<PersonGroupBean>callback){
        factory.addCallback(savePersonGroup(personGroupBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersons(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> savePersons(List<PersonBean> beans,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.savePersons(
                TypeTransformer.getInstance().to(
                    beans,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePersons(List<PersonBean> beans,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(savePersons(beans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersons(java.util.Map,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> savePersons(Map<ByteBuffer, PersonBean> persons,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.savePersonsWithPhoto(
                TypeTransformer.getInstance().to(
                    persons,
                    ByteBuffer.class,
                    PersonBean.class,
                    okio.ByteString.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePersons(Map<ByteBuffer, PersonBean> persons,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(savePersons(persons,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveServiceConfig(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> saveServiceConfig(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.saveServiceConfig(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void saveServiceConfig(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(saveServiceConfig(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setPersonExpiryDate(int,long,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setPersonExpiryDate(int personId,
        long expiryDate,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setPersonExpiryDate(
                personId,
            expiryDate,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setPersonExpiryDate(int personId,
        long expiryDate,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setPersonExpiryDate(personId,expiryDate,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setPersonExpiryDate(java.util.List,long,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setPersonExpiryDate(List<Integer> personIdList,
        long expiryDate,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setPersonExpiryDateList(
                TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            expiryDate,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setPersonExpiryDate(List<Integer> personIdList,
        long expiryDate,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setPersonExpiryDate(personIdList,expiryDate,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setProperties(java.util.Map,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setProperties(Map<String, String> config,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setProperties(
                TypeTransformer.getInstance().to(
                    config,
                    String.class,
                    String.class,
                    String.class,
                    String.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setProperties(Map<String, String> config,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setProperties(config,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setProperty(java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setProperty(String key,
        String value,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setProperty(
                key,
            value,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setProperty(String key,
        String value,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setProperty(key,value,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#unregisterDevice(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> unregisterDevice(int deviceId,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.unregisterDevice(
                deviceId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void unregisterDevice(int deviceId,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(unregisterDevice(deviceId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#updateDevice(net.gdface.facelog.db.DeviceBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceBean> updateDevice(DeviceBean deviceBean,
        Token token){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.updateDevice(
                TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void updateDevice(DeviceBean deviceBean,
        Token token,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(updateDevice(deviceBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#version()}
     */
    public ListenableFuture<String> version(){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.version(
                nativeCallback);
        return nativeCallback.feature;
    }
    public void version(FutureCallback<String>callback){
        factory.addCallback(version(), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#versionInfo()}
     */
    public ListenableFuture<Map<String, String>> versionInfo(){
        MethodCallback<Map<String, String>,Map<String,String>> nativeCallback = 
            new MethodCallback<Map<String, String>,Map<String,String>>(
                new Function<Map<String,String>,Map<String, String>>() {
                        @Override
                        public Map<String, String> apply(Map<String,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.versionInfo(
                nativeCallback);
        return nativeCallback.feature;
    }
    public void versionInfo(FutureCallback<Map<String, String>>callback){
        factory.addCallback(versionInfo(), callback);
    }
}