/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import gu.dtalk.MenuItem;
import gu.simplemq.Channel;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisFactory;
import gu.simplemq.redis.RedisSubscriber;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.ServiceHeartbeatPackage;
import net.gdface.facelog.ServiceSecurityException;
import net.gdface.facelog.Token;
import net.gdface.facelog.client.CmdDispatcher;
import net.gdface.facelog.client.CmdManager;
import net.gdface.facelog.client.TokenHelper;
import net.gdface.facelog.client.dtalk.DtalkEngineForFacelog;
import net.gdface.facelog.client.dtalk.FacelogRedisConfigProvider;
import net.gdface.facelog.db.DeviceBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.hb.BaseServiceHeartbeatListener;
import net.gdface.facelog.hb.DeviceHeartbeat;
import net.gdface.facelog.hb.DeviceHeartbeatListener;
import net.gdface.facelog.hb.HeartbeatMonitor;
import net.gdface.facelog.hb.ServiceHeartbeatAdapter;
import net.gdface.facelog.hb.ServiceHeartbeatListener;
import net.gdface.facelog.thrift.IFaceLogThriftClient;
import net.gdface.facelog.thrift.IFaceLogThriftClientAsync;
import net.gdface.thrift.ClientFactory;
import net.gdface.utils.NetworkUtil;

public class ClientExtendTools {
    private final IFaceLog syncInstance;
    private final IFaceLogThriftClientAsync asyncInstance;
    private final ClientFactory factory;
    private TokenHelper tokenHelper;
    private final ServiceHeartbeatListener tokenRefreshListener = new BaseServiceHeartbeatListener(){

        public boolean doServiceOnline(ServiceHeartbeatPackage heartbeatPackage) {
            return ClientExtendTools.this.tokenRefresh != null && ClientExtendTools.this.tokenRefresh.refresh();
        }
    };
    private TokenRefresh tokenRefresh;
    public final Function<Integer, Integer> deviceGroupIdGetter = new Function<Integer, Integer>(){

        public Integer apply(Integer input) {
            try {
                DeviceBean device = ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.getDevice(input.intValue()) : (DeviceBean)ClientExtendTools.this.asyncInstance.getDevice(input).get();
                return null == device ? null : device.getGroupId();
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Function<Integer, List<Integer>> personGroupBelonsGetter = new Function<Integer, List<Integer>>(){

        public List<Integer> apply(Integer personId) {
            try {
                return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.getPersonGroupsBelongs(personId.intValue()) : (List)ClientExtendTools.this.asyncInstance.getPersonGroupsBelongs(personId).get();
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Long> cmdSnValidator = new Predicate<Long>(){

        public boolean apply(Long input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidCmdSn(input.longValue()) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidCmdSn(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<String> ackChannelValidator = new Predicate<String>(){

        public boolean apply(String input) {
            try {
                return null == input || input.isEmpty() ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidAckChannel(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidAckChannel(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Token> deviceTokenValidator = new Predicate<Token>(){

        public boolean apply(Token input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidDeviceToken(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidDeviceToken(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Token> personTokenValidator = new Predicate<Token>(){

        public boolean apply(Token input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidPersonToken(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidPersonToken(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Token> rootTokenValidator = new Predicate<Token>(){

        public boolean apply(Token input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidRootToken(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidRootToken(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Function<Token, Integer> tokenRank = new Function<Token, Integer>(){

        public Integer apply(Token input) {
            try {
                if (null != input) {
                    switch (input.getType()) {
                        case ROOT: {
                            if (!ClientExtendTools.this.rootTokenValidator.apply((Object)input)) break;
                            return 4;
                        }
                        case PERSON: {
                            if (!ClientExtendTools.this.personTokenValidator.apply((Object)input)) break;
                            PersonBean bean = ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.getPerson(input.getId()) : (PersonBean)ClientExtendTools.this.asyncInstance.getPerson(input.getId()).get();
                            Integer rank = bean.getRank();
                            return rank != null ? rank : 0;
                        }
                    }
                }
                return -1;
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };

    ClientExtendTools(IFaceLogThriftClient syncInstance) {
        this.syncInstance = (IFaceLog)Preconditions.checkNotNull((Object)syncInstance, (Object)"syncInstance is null");
        this.asyncInstance = null;
        this.factory = syncInstance.getFactory();
    }

    ClientExtendTools(IFaceLogThriftClientAsync asyncInstance) {
        this.syncInstance = null;
        this.asyncInstance = (IFaceLogThriftClientAsync)Preconditions.checkNotNull((Object)asyncInstance, (Object)"asyncInstance is null");
        this.factory = asyncInstance.getFactory();
    }

    public String insteadHostIfLocalhost(String host) {
        if (NetworkUtil.isLoopbackAddress((String)host)) {
            return this.factory.getHostAndPort().getHost();
        }
        return host;
    }

    public URI insteadHostIfLocalhost(URI uri) {
        if (null != uri && NetworkUtil.isLoopbackAddress((String)uri.getHost())) {
            try {
                return new URI(uri.getScheme(), uri.getUserInfo(), this.factory.getHostAndPort().getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri;
    }

    public URL insteadHostIfLocalhost(URL url) {
        if (null != url && NetworkUtil.isLoopbackAddress((String)url.getHost())) {
            try {
                return new URL(url.getProtocol(), this.factory.getHostAndPort().getHost(), url.getPort(), url.getFile());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public String insteadHostOfURIIfLocalhost(String uri) {
        try {
            return Strings.isNullOrEmpty((String)uri) ? uri : this.insteadHostIfLocalhost(new URI(uri)).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return uri;
        }
    }

    public String insteadHostOfURLIfLocalhost(String url) {
        try {
            return Strings.isNullOrEmpty((String)url) ? url : this.insteadHostIfLocalhost(new URL(url)).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return url;
        }
    }

    public Map<MQParam, String> insteadHostOfMQParamIfLocalhost(Map<MQParam, String> parameters) {
        if (parameters != null) {
            HashMap out = Maps.newHashMap();
            for (Map.Entry<MQParam, String> entry : parameters.entrySet()) {
                String insteaded;
                MQParam key = entry.getKey();
                String value = entry.getValue();
                if (MQParam.REDIS_URI.equals((Object)key)) {
                    insteaded = this.insteadHostOfURIIfLocalhost(value);
                    out.put(key, insteaded);
                    continue;
                }
                if (MQParam.WEBREDIS_URL.equals((Object)key)) {
                    insteaded = this.insteadHostOfURLIfLocalhost(value);
                    out.put(key, insteaded);
                    continue;
                }
                out.put(key, value);
            }
            return out;
        }
        return parameters;
    }

    public Supplier<Integer> getDeviceGroupIdSupplier(final int deviceId) {
        return new Supplier<Integer>(){

            public Integer get() {
                return (Integer)ClientExtendTools.this.deviceGroupIdGetter.apply((Object)deviceId);
            }
        };
    }

    public Supplier<List<Integer>> getPersonGroupBelonsSupplier(final int personId) {
        return new Supplier<List<Integer>>(){

            public List<Integer> get() {
                return (List)ClientExtendTools.this.personGroupBelonsGetter.apply((Object)personId);
            }
        };
    }

    public CmdManager makeCmdManager(Token token) {
        try {
            Preconditions.checkArgument((((Token)Preconditions.checkNotNull((Object)token, (Object)"token is null")).getType() == Token.TokenType.PERSON || token.getType() == Token.TokenType.ROOT ? 1 : 0) != 0, (Object)"person or root token required");
            Preconditions.checkArgument(((Integer)this.tokenRank.apply((Object)token) >= 2 ? 1 : 0) != 0, (Object)"person or root token required");
            return new CmdManager(JedisPoolLazy.getDefaultInstance(), this.syncInstance != null ? this.syncInstance.getRedisParameters(token) : (Map)this.asyncInstance.getRedisParameters(token).get());
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CmdDispatcher makeCmdDispatcher(Token token) {
        try {
            Preconditions.checkArgument((((Token)Preconditions.checkNotNull((Object)token, (Object)"token is null")).getType() == Token.TokenType.DEVICE ? 1 : 0) != 0, (Object)"device token required");
            int deviceId = token.getId();
            Map pameters = this.syncInstance != null ? this.syncInstance.getRedisParameters(token) : (Map)this.asyncInstance.getRedisParameters(token).get();
            return new CmdDispatcher(deviceId, this.getDeviceGroupIdSupplier(deviceId)).setCmdSnValidator(this.cmdSnValidator).setAckChannelValidator(this.ackChannelValidator).registerChannel((String)pameters.get(MQParam.CMD_CHANNEL));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Supplier<String> getAckChannelSupplier(final Token token, final long duration) {
        return new Supplier<String>(){

            public String get() {
                try {
                    return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.applyAckChannel(token, duration) : (String)ClientExtendTools.this.asyncInstance.applyAckChannel(token, duration).get();
                }
                catch (ExecutionException e) {
                    Throwables.throwIfUnchecked((Throwable)e.getCause());
                    throw new RuntimeException(e.getCause());
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Supplier<String> getAckChannelSupplier(Token token) {
        return this.getAckChannelSupplier(token, 0L);
    }

    public Supplier<Long> getCmdSnSupplier(final Token token) {
        return new Supplier<Long>(){

            public Long get() {
                try {
                    return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.applyCmdSn(token) : ((Long)ClientExtendTools.this.asyncInstance.applyCmdSn(token).get()).longValue();
                }
                catch (ExecutionException e) {
                    Throwables.throwIfUnchecked((Throwable)e.getCause());
                    throw new RuntimeException(e.getCause());
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Token applyUserToken(int userid, String password, boolean isMd5) throws ServiceSecurityException {
        try {
            Token token = this.syncInstance != null ? this.syncInstance.applyUserToken(userid, password, isMd5) : (Token)this.asyncInstance.applyUserToken(userid, password, isMd5).get();
            return token;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), ServiceSecurityException.class);
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, ServiceSecurityException.class);
            throw new RuntimeException(e);
        }
    }

    private Map<MQParam, String> getRedisParameters(Token token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        try {
            Map param = this.syncInstance != null ? this.syncInstance.getRedisParameters(token) : (Map)this.asyncInstance.getRedisParameters(token).get();
            return this.insteadHostOfMQParamIfLocalhost(param);
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Supplier<Map<MQParam, String>> getRedisParametersSupplier(final Token token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        return new Supplier<Map<MQParam, String>>(){

            public Map<MQParam, String> get() {
                return ClientExtendTools.this.getRedisParameters(token);
            }
        };
    }

    public Supplier<String> getMonitorChannelSupplier(Token token) {
        return Suppliers.compose((Function)new Function<Map<MQParam, String>, String>(){

            public String apply(Map<MQParam, String> input) {
                return input.get(MQParam.HB_MONITOR_CHANNEL);
            }
        }, this.getRedisParametersSupplier(token));
    }

    public DtalkEngineForFacelog initDtalkEngine(Token deviceToken, MenuItem rootMenu) {
        Preconditions.checkArgument((boolean)this.deviceTokenValidator.apply((Object)deviceToken), (Object)"device token REQUIRED");
        this.initDtalkRedisLocation(deviceToken);
        return new DtalkEngineForFacelog((MenuItem)Preconditions.checkNotNull((Object)rootMenu, (Object)"rootMenu is null"), this.tokenRank);
    }

    public void initDtalkRedisLocation(Token token) {
        Map<MQParam, String> redisParam = this.getRedisParameters(token);
        URI uri = URI.create(redisParam.get(MQParam.REDIS_URI));
        FacelogRedisConfigProvider.setRedisLocation((URI)uri);
    }

    public void initRedisDefaultInstance(Token token) {
        Map<MQParam, String> redisParam = this.getRedisParameters(token);
        URI uri = URI.create(redisParam.get(MQParam.REDIS_URI));
        JedisPoolLazy.getInstance((URI)uri).asDefaultInstance();
    }

    private Token online(DeviceBean deviceBean) throws ServiceSecurityException {
        try {
            return this.syncInstance != null ? this.syncInstance.online(deviceBean) : (Token)this.asyncInstance.online(deviceBean).get();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), ServiceSecurityException.class);
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, ServiceSecurityException.class);
            throw new RuntimeException(e);
        }
    }

    public Token refreshToken(TokenHelper helper, Token token) {
        Token freshToken = null;
        try {
            switch (token.getType()) {
                case DEVICE: {
                    if (helper.deviceBean() == null) break;
                    freshToken = this.online(helper.deviceBean());
                    break;
                }
                case ROOT: 
                case PERSON: {
                    String pwd = helper.passwordOf(token.getId());
                    if (pwd == null) break;
                    freshToken = this.applyUserToken(token.getId(), pwd, helper.isHashedPwd());
                    break;
                }
            }
            if (freshToken != null) {
                helper.saveFreshedToken(freshToken);
            }
        }
        catch (Exception er) {
            // empty catch block
        }
        return freshToken;
    }

    public Supplier<Token> getTokenSupplier() {
        return (Supplier)Preconditions.checkNotNull((Object)this.tokenRefresh, (Object)"tokenRefresh field must be initialized by startServiceHeartbeatListener firstly");
    }

    public ClientExtendTools addServiceEventListener(ServiceHeartbeatListener listener) {
        ServiceHeartbeatAdapter.INSTANCE.addServiceEventListener(listener);
        return this;
    }

    public ClientExtendTools removeServiceEventListener(ServiceHeartbeatListener listener) {
        ServiceHeartbeatAdapter.INSTANCE.removeServiceEventListener(listener);
        return this;
    }

    public HeartbeatMonitor makeHeartbeatMonitor(DeviceHeartbeatListener listener, Token token, JedisPoolLazy jedisPoolLazy) {
        HeartbeatMonitor monitor = new HeartbeatMonitor((IMessageAdapter)listener, this.getMonitorChannelSupplier(token), (JedisPoolLazy)MoreObjects.firstNonNull((Object)jedisPoolLazy, (Object)JedisPoolLazy.getDefaultInstance()));
        this.addServiceEventListener((ServiceHeartbeatListener)monitor);
        return monitor;
    }

    public DeviceHeartbeat makeHeartbeat(int deviceID, Token token, JedisPoolLazy jedisPoolLazy) {
        DeviceHeartbeat heartbeat = DeviceHeartbeat.makeHeartbeat((int)deviceID, (JedisPoolLazy)((JedisPoolLazy)MoreObjects.firstNonNull((Object)jedisPoolLazy, (Object)JedisPoolLazy.getDefaultInstance()))).setMonitorChannelSupplier(this.getMonitorChannelSupplier(token));
        this.addServiceEventListener((ServiceHeartbeatListener)heartbeat);
        return heartbeat;
    }

    public ClientExtendTools setTokenHelper(TokenHelper tokenHelper) {
        this.tokenHelper = tokenHelper;
        return this;
    }

    public ClientExtendTools startServiceHeartbeatListener(Token token, boolean initJedisPoolLazyDefaultInstance) {
        RedisSubscriber subscriber;
        Preconditions.checkState((this.tokenHelper != null ? 1 : 0) != 0, (Object)"tokenHelper field must be initialized by setTokenHelper firstly");
        this.tokenRefresh = new TokenRefresh(this.tokenHelper, token);
        if (initJedisPoolLazyDefaultInstance) {
            this.initRedisDefaultInstance(token);
            subscriber = RedisFactory.getSubscriber();
        } else {
            Map<MQParam, String> redisParam = this.getRedisParameters(token);
            URI uri = URI.create(redisParam.get(MQParam.REDIS_URI));
            subscriber = RedisFactory.getSubscriber((JedisPoolLazy)JedisPoolLazy.getInstance((URI)uri));
        }
        subscriber.register(new Channel[]{ServiceHeartbeatAdapter.SERVICE_HB_CHANNEL});
        this.addServiceEventListener(this.tokenRefreshListener);
        return this;
    }

    private class TokenRefresh
    implements Supplier<Token> {
        private Token token;
        private final Object lock = new Object();
        private volatile boolean relead = true;
        private final TokenHelper helper;

        private TokenRefresh(TokenHelper helper, Token token) {
            this.helper = (TokenHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper is null");
            this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token is null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Token get() {
            if (this.relead) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.relead) {
                        Token t = ClientExtendTools.this.refreshToken(this.helper, this.token);
                        if (null != t) {
                            this.relead = false;
                            this.token.assignFrom(t);
                        }
                        return t;
                    }
                }
            }
            return this.token;
        }

        boolean refresh() {
            this.relead = true;
            Token token = this.get();
            if (null != token) {
                try {
                    ClientExtendTools.this.getRedisParameters(token);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

