/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import gu.dtalk.MenuItem;
import gu.simplemq.redis.JedisPoolLazy;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.Token;
import net.gdface.facelog.client.ClientExtendTools;
import net.gdface.facelog.client.CmdDispatcher;
import net.gdface.facelog.client.CmdManager;
import net.gdface.facelog.client.TokenHelper;
import net.gdface.facelog.client.dtalk.DtalkEngineForFacelog;
import net.gdface.facelog.hb.DeviceHeartbeat;
import net.gdface.facelog.hb.DeviceHeartbeatListener;
import net.gdface.facelog.hb.HeartbeatMonitor;
import net.gdface.facelog.thrift.IFaceLogThriftClientAsync;
import net.gdface.thrift.ClientFactory;

public class IFaceLogClientAsync
extends IFaceLogThriftClientAsync {
    private final ClientExtendTools clientTools = new ClientExtendTools(this);

    public IFaceLogClientAsync(ClientFactory factory) {
        super(factory);
    }

    public String insteadHostIfLocalhost(String host) {
        return this.clientTools.insteadHostIfLocalhost(host);
    }

    public URI insteadHostIfLocalhost(URI uri) {
        return this.clientTools.insteadHostIfLocalhost(uri);
    }

    public URL insteadHostIfLocalhost(URL url) {
        return this.clientTools.insteadHostIfLocalhost(url);
    }

    public Supplier<Integer> getDeviceGroupIdSupplier(int deviceId) {
        return this.clientTools.getDeviceGroupIdSupplier(deviceId);
    }

    public Supplier<List<Integer>> getPersonGroupBelonsSupplier(int personId) {
        return this.clientTools.getPersonGroupBelonsSupplier(personId);
    }

    public CmdManager makeCmdManager(Token token) {
        return this.clientTools.makeCmdManager(token);
    }

    public CmdDispatcher makeCmdDispatcher(Token token) {
        return this.clientTools.makeCmdDispatcher(token);
    }

    public Supplier<String> getAckChannelSupplier(Token token, long duration) {
        return this.clientTools.getAckChannelSupplier(token, duration);
    }

    public Supplier<String> getAckChannelSupplier(Token token) {
        return this.clientTools.getAckChannelSupplier(token);
    }

    public Supplier<Long> getCmdSnSupplier(Token token) {
        return this.clientTools.getCmdSnSupplier(token);
    }

    public DtalkEngineForFacelog initDtalkEngine(Token deviceToken, MenuItem rootMenu) {
        return this.clientTools.initDtalkEngine(deviceToken, rootMenu);
    }

    public void initDtalkRedisLocation(Token token) {
        this.clientTools.initDtalkRedisLocation(token);
    }

    public void initRedisDefaultInstance(Token token) {
        this.clientTools.initRedisDefaultInstance(token);
    }

    @Override
    public ListenableFuture<Map<MQParam, String>> getRedisParameters(Token token) {
        ListenableFuture<Map<MQParam, String>> feature = super.getRedisParameters(token);
        return Futures.transform(feature, (Function)new Function<Map<MQParam, String>, Map<MQParam, String>>(){

            public Map<MQParam, String> apply(Map<MQParam, String> input) {
                return IFaceLogClientAsync.this.clientTools.insteadHostOfMQParamIfLocalhost(input);
            }
        });
    }

    public Supplier<Map<MQParam, String>> getRedisParametersSupplier(Token token) {
        return this.clientTools.getRedisParametersSupplier(token);
    }

    public Supplier<String> getMonitorChannelSupplier(Token token) {
        return this.clientTools.getMonitorChannelSupplier(token);
    }

    public Supplier<Token> getTokenSupplier() {
        return this.clientTools.getTokenSupplier();
    }

    public HeartbeatMonitor makeHeartbeatMonitor(DeviceHeartbeatListener listener, Token token) {
        return this.clientTools.makeHeartbeatMonitor(listener, token, null);
    }

    public DeviceHeartbeat makeHeartbeat(int deviceID, Token token, JedisPoolLazy jedisPoolLazy) {
        return this.clientTools.makeHeartbeat(deviceID, token, jedisPoolLazy);
    }

    public IFaceLogClientAsync setTokenHelper(TokenHelper tokenHelper) {
        this.clientTools.setTokenHelper(tokenHelper);
        return this;
    }

    public IFaceLogClientAsync startServiceHeartbeatListener(Token token, boolean initJedisPoolLazyDefaultInstance) {
        this.clientTools.startServiceHeartbeatListener(token, initJedisPoolLazyDefaultInstance);
        return this;
    }
}

