/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client.thrift;

import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.ListMetadata;
import com.microsoft.thrifty.protocol.MapMetadata;
import com.microsoft.thrifty.protocol.MessageMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.MethodCall;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import com.microsoft.thrifty.util.ProtocolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.client.thrift.DeviceBean;
import net.gdface.facelog.client.thrift.DeviceGroupBean;
import net.gdface.facelog.client.thrift.DuplicateRecordException;
import net.gdface.facelog.client.thrift.FaceBean;
import net.gdface.facelog.client.thrift.FeatureBean;
import net.gdface.facelog.client.thrift.IFaceLog;
import net.gdface.facelog.client.thrift.ImageBean;
import net.gdface.facelog.client.thrift.LogBean;
import net.gdface.facelog.client.thrift.LogLightBean;
import net.gdface.facelog.client.thrift.MQParam;
import net.gdface.facelog.client.thrift.PermitBean;
import net.gdface.facelog.client.thrift.PersonBean;
import net.gdface.facelog.client.thrift.PersonGroupBean;
import net.gdface.facelog.client.thrift.ServiceRuntimeException;
import net.gdface.facelog.client.thrift.ServiceSecurityException;
import net.gdface.facelog.client.thrift.Token;
import okio.ByteString;

public class IFaceLogClient
extends AsyncClientBase
implements IFaceLog {
    public IFaceLogClient(Protocol protocol, AsyncClientBase.Listener listener) {
        super(protocol, listener);
    }

    @Override
    public void addFeature(ByteString feature, String featureVersion, Integer personId, List<FaceBean> faecBeans, Token token, ServiceMethodCallback<FeatureBean> callback) {
        this.enqueue(new AddFeatureCall(feature, featureVersion, personId, faecBeans, token, callback));
    }

    @Override
    public void addFeatureMulti(ByteString feature, String featureVersion, Integer personId, Map<ByteString, FaceBean> faceInfo, Token token, ServiceMethodCallback<FeatureBean> callback) {
        this.enqueue(new AddFeatureMultiCall(feature, featureVersion, personId, faceInfo, token, callback));
    }

    @Override
    public void addFeatureWithImage(ByteString feature, String featureVersion, Integer personId, Boolean asIdPhotoIfAbsent, ByteString featurePhoto, FaceBean faceBean, Token token, ServiceMethodCallback<FeatureBean> callback) {
        this.enqueue(new AddFeatureWithImageCall(feature, featureVersion, personId, asIdPhotoIfAbsent, featurePhoto, faceBean, token, callback));
    }

    @Override
    public void addImage(ByteString imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token, ServiceMethodCallback<ImageBean> callback) {
        this.enqueue(new AddImageCall(imageData, deviceId, faceBean, personId, token, callback));
    }

    @Override
    public void addLog(LogBean logBean, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogCall(logBean, token, callback));
    }

    @Override
    public void addLogFull(LogBean logBean, FaceBean faceBean, ByteString featureImage, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogFullCall(logBean, faceBean, featureImage, token, callback));
    }

    @Override
    public void addLogs(List<LogBean> beans, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogsCall(beans, token, callback));
    }

    @Override
    public void addLogsFull(List<LogBean> logBeans, List<FaceBean> faceBeans, List<ByteString> featureImages, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogsFullCall(logBeans, faceBeans, featureImages, token, callback));
    }

    @Override
    public void addPermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddPermitCall(deviceGroup, personGroup, token, callback));
    }

    @Override
    public void addPermitById(Integer deviceGroupId, Integer personGroupId, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddPermitByIdCall(deviceGroupId, personGroupId, token, callback));
    }

    @Override
    public void applyAckChannel(Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new ApplyAckChannelCall(token, callback));
    }

    @Override
    public void applyAckChannelWithDuration(Token token, Long duration, ServiceMethodCallback<String> callback) {
        this.enqueue(new ApplyAckChannelWithDurationCall(token, duration, callback));
    }

    @Override
    public void applyCmdSn(Token token, ServiceMethodCallback<Long> callback) {
        this.enqueue(new ApplyCmdSnCall(token, callback));
    }

    @Override
    public void applyPersonToken(Integer personId, String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
        this.enqueue(new ApplyPersonTokenCall(personId, password, isMd5, callback));
    }

    @Override
    public void applyRootToken(String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
        this.enqueue(new ApplyRootTokenCall(password, isMd5, callback));
    }

    @Override
    public void applyUserToken(Integer userid, String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
        this.enqueue(new ApplyUserTokenCall(userid, password, isMd5, callback));
    }

    @Override
    public void bindBorder(Integer personGroupId, Integer deviceGroupId, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new BindBorderCall(personGroupId, deviceGroupId, token, callback));
    }

    @Override
    public void childListForDeviceGroup(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new ChildListForDeviceGroupCall(deviceGroupId, callback));
    }

    @Override
    public void childListForPersonGroup(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new ChildListForPersonGroupCall(personGroupId, callback));
    }

    @Override
    public void countDeviceByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountDeviceByWhereCall(where, callback));
    }

    @Override
    public void countDeviceGroupByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountDeviceGroupByWhereCall(where, callback));
    }

    @Override
    public void countLogByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogByWhereCall(where, callback));
    }

    @Override
    public void countLogLightByVerifyTime(Long timestamp, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByVerifyTimeCall(timestamp, callback));
    }

    @Override
    public void countLogLightByVerifyTimeTimestr(String timestamp, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByVerifyTimeTimestrCall(timestamp, callback));
    }

    @Override
    public void countLogLightByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByWhereCall(where, callback));
    }

    @Override
    public void countPersonByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountPersonByWhereCall(where, callback));
    }

    @Override
    public void countPersonGroupByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountPersonGroupByWhereCall(where, callback));
    }

    @Override
    public void deleteAllFeaturesByPersonId(Integer personId, Boolean deleteImage, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteAllFeaturesByPersonIdCall(personId, deleteImage, token, callback));
    }

    @Override
    public void deleteDeviceGroup(Integer deviceGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteDeviceGroupCall(deviceGroupId, token, callback));
    }

    @Override
    public void deleteFeature(String featureMd5, Boolean deleteImage, Token token, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new DeleteFeatureCall(featureMd5, deleteImage, token, callback));
    }

    @Override
    public void deleteGroupPermitOnDeviceGroup(Integer deviceGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteGroupPermitOnDeviceGroupCall(deviceGroupId, token, callback));
    }

    @Override
    public void deleteImage(String imageMd5, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteImageCall(imageMd5, token, callback));
    }

    @Override
    public void deletePermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePermitCall(deviceGroup, personGroup, token, callback));
    }

    @Override
    public void deletePermitById(Integer deviceGroupId, Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePermitByIdCall(deviceGroupId, personGroupId, token, callback));
    }

    @Override
    public void deletePerson(Integer personId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonCall(personId, token, callback));
    }

    @Override
    public void deletePersonByPapersNum(String papersNum, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonByPapersNumCall(papersNum, token, callback));
    }

    @Override
    public void deletePersonGroup(Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonGroupCall(personGroupId, token, callback));
    }

    @Override
    public void deletePersonGroupPermit(Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonGroupPermitCall(personGroupId, token, callback));
    }

    @Override
    public void deletePersons(List<Integer> personIdList, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonsCall(personIdList, token, callback));
    }

    @Override
    public void deletePersonsByPapersNum(List<String> papersNumlist, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonsByPapersNumCall(papersNumlist, token, callback));
    }

    @Override
    public void disablePerson(Integer personId, Integer moveToGroupId, Boolean deletePhoto, Boolean deleteFeature, Boolean deleteLog, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new DisablePersonCall(personId, moveToGroupId, deletePhoto, deleteFeature, deleteLog, token, callback));
    }

    @Override
    public void disablePersonList(List<Integer> personIdList, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new DisablePersonListCall(personIdList, token, callback));
    }

    @Override
    public void existsDevice(Integer id, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new ExistsDeviceCall(id, callback));
    }

    @Override
    public void existsFeature(String md5, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new ExistsFeatureCall(md5, callback));
    }

    @Override
    public void existsImage(String md5, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new ExistsImageCall(md5, callback));
    }

    @Override
    public void existsPerson(Integer persionId, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new ExistsPersonCall(persionId, callback));
    }

    @Override
    public void getDevice(Integer deviceId, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new GetDeviceCall(deviceId, callback));
    }

    @Override
    public void getDeviceGroup(Integer deviceGroupId, ServiceMethodCallback<DeviceGroupBean> callback) {
        this.enqueue(new GetDeviceGroupCall(deviceGroupId, callback));
    }

    @Override
    public void getDeviceGroups(List<Integer> groupIdList, ServiceMethodCallback<List<DeviceGroupBean>> callback) {
        this.enqueue(new GetDeviceGroupsCall(groupIdList, callback));
    }

    @Override
    public void getDeviceGroupsBelongs(Integer deviceId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetDeviceGroupsBelongsCall(deviceId, callback));
    }

    @Override
    public void getDeviceGroupsPermit(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetDeviceGroupsPermitCall(personGroupId, callback));
    }

    @Override
    public void getDeviceGroupsPermittedBy(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetDeviceGroupsPermittedByCall(personGroupId, callback));
    }

    @Override
    public void getDeviceIdOfFeature(String featureMd5, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new GetDeviceIdOfFeatureCall(featureMd5, callback));
    }

    @Override
    public void getDevices(List<Integer> idList, ServiceMethodCallback<List<DeviceBean>> callback) {
        this.enqueue(new GetDevicesCall(idList, callback));
    }

    @Override
    public void getDevicesOfGroup(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetDevicesOfGroupCall(deviceGroupId, callback));
    }

    @Override
    public void getFace(Integer faceId, ServiceMethodCallback<FaceBean> callback) {
        this.enqueue(new GetFaceCall(faceId, callback));
    }

    @Override
    public void getFeature(String md5, ServiceMethodCallback<FeatureBean> callback) {
        this.enqueue(new GetFeatureCall(md5, callback));
    }

    @Override
    public void getFeatureBytes(String md5, ServiceMethodCallback<ByteString> callback) {
        this.enqueue(new GetFeatureBytesCall(md5, callback));
    }

    @Override
    public void getFeatures(List<String> md5, ServiceMethodCallback<List<FeatureBean>> callback) {
        this.enqueue(new GetFeaturesCall(md5, callback));
    }

    @Override
    public void getFeaturesByPersonId(Integer personId, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetFeaturesByPersonIdCall(personId, callback));
    }

    @Override
    public void getFeaturesByPersonIdAndSdkVersion(Integer personId, String sdkVersion, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetFeaturesByPersonIdAndSdkVersionCall(personId, sdkVersion, callback));
    }

    @Override
    public void getFeaturesOfPerson(Integer personId, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetFeaturesOfPersonCall(personId, callback));
    }

    @Override
    public void getGroupPermit(Integer deviceId, Integer personGroupId, ServiceMethodCallback<PermitBean> callback) {
        this.enqueue(new GetGroupPermitCall(deviceId, personGroupId, callback));
    }

    @Override
    public void getGroupPermitOnDeviceGroup(Integer deviceGroupId, Integer personGroupId, ServiceMethodCallback<PermitBean> callback) {
        this.enqueue(new GetGroupPermitOnDeviceGroupCall(deviceGroupId, personGroupId, callback));
    }

    @Override
    public void getGroupPermits(Integer deviceId, List<Integer> personGroupIdList, ServiceMethodCallback<List<PermitBean>> callback) {
        this.enqueue(new GetGroupPermitsCall(deviceId, personGroupIdList, callback));
    }

    @Override
    public void getImage(String imageMD5, ServiceMethodCallback<ImageBean> callback) {
        this.enqueue(new GetImageCall(imageMD5, callback));
    }

    @Override
    public void getImageBytes(String imageMD5, ServiceMethodCallback<ByteString> callback) {
        this.enqueue(new GetImageBytesCall(imageMD5, callback));
    }

    @Override
    public void getImagesAssociatedByFeature(String featureMd5, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetImagesAssociatedByFeatureCall(featureMd5, callback));
    }

    @Override
    public void getLogBeansByPersonId(Integer personId, ServiceMethodCallback<List<LogBean>> callback) {
        this.enqueue(new GetLogBeansByPersonIdCall(personId, callback));
    }

    @Override
    public void getPerson(Integer personId, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new GetPersonCall(personId, callback));
    }

    @Override
    public void getPersonByPapersNum(String papersNum, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new GetPersonByPapersNumCall(papersNum, callback));
    }

    @Override
    public void getPersonGroup(Integer personGroupId, ServiceMethodCallback<PersonGroupBean> callback) {
        this.enqueue(new GetPersonGroupCall(personGroupId, callback));
    }

    @Override
    public void getPersonGroups(List<Integer> groupIdList, ServiceMethodCallback<List<PersonGroupBean>> callback) {
        this.enqueue(new GetPersonGroupsCall(groupIdList, callback));
    }

    @Override
    public void getPersonGroupsBelongs(Integer personId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetPersonGroupsBelongsCall(personId, callback));
    }

    @Override
    public void getPersonGroupsPermittedBy(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetPersonGroupsPermittedByCall(deviceGroupId, callback));
    }

    @Override
    public void getPersonPermit(Integer deviceId, Integer personId, ServiceMethodCallback<PermitBean> callback) {
        this.enqueue(new GetPersonPermitCall(deviceId, personId, callback));
    }

    @Override
    public void getPersonPermits(Integer deviceId, List<Integer> personIdList, ServiceMethodCallback<List<PermitBean>> callback) {
        this.enqueue(new GetPersonPermitsCall(deviceId, personIdList, callback));
    }

    @Override
    public void getPersons(List<Integer> idList, ServiceMethodCallback<List<PersonBean>> callback) {
        this.enqueue(new GetPersonsCall(idList, callback));
    }

    @Override
    public void getPersonsOfGroup(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetPersonsOfGroupCall(personGroupId, callback));
    }

    @Override
    public void getProperty(String key, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new GetPropertyCall(key, token, callback));
    }

    @Override
    public void getRedisParameters(Token token, ServiceMethodCallback<Map<MQParam, String>> callback) {
        this.enqueue(new GetRedisParametersCall(token, callback));
    }

    @Override
    public void getServiceConfig(Token token, ServiceMethodCallback<Map<String, String>> callback) {
        this.enqueue(new GetServiceConfigCall(token, callback));
    }

    @Override
    public void getSubDeviceGroup(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetSubDeviceGroupCall(deviceGroupId, callback));
    }

    @Override
    public void getSubPersonGroup(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetSubPersonGroupCall(personGroupId, callback));
    }

    @Override
    public void isDisable(Integer personId, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsDisableCall(personId, callback));
    }

    @Override
    public void isLocal(ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsLocalCall(callback));
    }

    @Override
    public void isValidAckChannel(String ackChannel, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidAckChannelCall(ackChannel, callback));
    }

    @Override
    public void isValidCmdSn(Long cmdSn, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidCmdSnCall(cmdSn, callback));
    }

    @Override
    public void isValidDeviceToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidDeviceTokenCall(token, callback));
    }

    @Override
    public void isValidPassword(String userId, String password, Boolean isMd5, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidPasswordCall(userId, password, isMd5, callback));
    }

    @Override
    public void isValidPersonToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidPersonTokenCall(token, callback));
    }

    @Override
    public void isValidRootToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidRootTokenCall(token, callback));
    }

    @Override
    public void isValidToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidTokenCall(token, callback));
    }

    @Override
    public void isValidUserToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidUserTokenCall(token, callback));
    }

    @Override
    public void listOfParentForDeviceGroup(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new ListOfParentForDeviceGroupCall(deviceGroupId, callback));
    }

    @Override
    public void listOfParentForPersonGroup(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new ListOfParentForPersonGroupCall(personGroupId, callback));
    }

    @Override
    public void loadAllPerson(ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadAllPersonCall(callback));
    }

    @Override
    public void loadDeviceByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<DeviceBean>> callback) {
        this.enqueue(new LoadDeviceByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadDeviceGroupByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDeviceGroupByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadDeviceGroupIdByWhere(String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDeviceGroupIdByWhereCall(where, callback));
    }

    @Override
    public void loadDeviceIdByWhere(String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDeviceIdByWhereCall(where, callback));
    }

    @Override
    public void loadFeatureMd5ByUpdate(Long timestamp, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new LoadFeatureMd5ByUpdateCall(timestamp, callback));
    }

    @Override
    public void loadFeatureMd5ByUpdateTimeStr(String timestamp, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new LoadFeatureMd5ByUpdateTimeStrCall(timestamp, callback));
    }

    @Override
    public void loadLogByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogBean>> callback) {
        this.enqueue(new LoadLogByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadLogLightByVerifyTime(Long timestamp, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByVerifyTimeCall(timestamp, startRow, numRows, callback));
    }

    @Override
    public void loadLogLightByVerifyTimeTimestr(String timestamp, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByVerifyTimeTimestrCall(timestamp, startRow, numRows, callback));
    }

    @Override
    public void loadLogLightByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadPermitByUpdate(Long timestamp, ServiceMethodCallback<List<PermitBean>> callback) {
        this.enqueue(new LoadPermitByUpdateCall(timestamp, callback));
    }

    @Override
    public void loadPermitByUpdateTimestr(String timestamp, ServiceMethodCallback<List<PermitBean>> callback) {
        this.enqueue(new LoadPermitByUpdateTimestrCall(timestamp, callback));
    }

    @Override
    public void loadPersonByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<PersonBean>> callback) {
        this.enqueue(new LoadPersonByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadPersonGroupByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonGroupByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadPersonGroupIdByWhere(String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonGroupIdByWhereCall(where, callback));
    }

    @Override
    public void loadPersonIdByUpdateTime(Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByUpdateTimeCall(timestamp, callback));
    }

    @Override
    public void loadPersonIdByUpdateTimeTimeStr(String timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByUpdateTimeTimeStrCall(timestamp, callback));
    }

    @Override
    public void loadPersonIdByWhere(String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByWhereCall(where, callback));
    }

    @Override
    public void loadUpdatedPersons(Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadUpdatedPersonsCall(timestamp, callback));
    }

    @Override
    public void loadUpdatedPersonsTimestr(String timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadUpdatedPersonsTimestrCall(timestamp, callback));
    }

    @Override
    public void offline(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new OfflineCall(token, callback));
    }

    @Override
    public void online(DeviceBean device, ServiceMethodCallback<Token> callback) {
        this.enqueue(new OnlineCall(device, callback));
    }

    @Override
    public void registerDevice(DeviceBean newDevice, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new RegisterDeviceCall(newDevice, callback));
    }

    @Override
    public void releasePersonToken(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new ReleasePersonTokenCall(token, callback));
    }

    @Override
    public void releaseRootToken(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new ReleaseRootTokenCall(token, callback));
    }

    @Override
    public void releaseUserToken(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new ReleaseUserTokenCall(token, callback));
    }

    @Override
    public void replaceFeature(Integer personId, String featureMd5, Boolean deleteOldFeatureImage, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new ReplaceFeatureCall(personId, featureMd5, deleteOldFeatureImage, token, callback));
    }

    @Override
    public void rootGroupOfDevice(Integer deviceId, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new RootGroupOfDeviceCall(deviceId, callback));
    }

    @Override
    public void rootGroupOfPerson(Integer personId, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new RootGroupOfPersonCall(personId, callback));
    }

    @Override
    public void saveDevice(DeviceBean deviceBean, Token token, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new SaveDeviceCall(deviceBean, token, callback));
    }

    @Override
    public void saveDeviceGroup(DeviceGroupBean deviceGroupBean, Token token, ServiceMethodCallback<DeviceGroupBean> callback) {
        this.enqueue(new SaveDeviceGroupCall(deviceGroupBean, token, callback));
    }

    @Override
    public void savePerson(PersonBean personBean, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonCall(personBean, token, callback));
    }

    @Override
    public void savePersonFull(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, ByteString featureImage, FaceBean featureFaceBean, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonFullCall(personBean, idPhoto, feature, featureVersion, featureImage, featureFaceBean, token, callback));
    }

    @Override
    public void savePersonGroup(PersonGroupBean personGroupBean, Token token, ServiceMethodCallback<PersonGroupBean> callback) {
        this.enqueue(new SavePersonGroupCall(personGroupBean, token, callback));
    }

    @Override
    public void savePersonWithPhoto(PersonBean personBean, ByteString idPhoto, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoCall(personBean, idPhoto, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndFeature(PersonBean personBean, ByteString idPhoto, FeatureBean featureBean, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndFeatureCall(personBean, idPhoto, featureBean, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndFeatureMultiFaces(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, List<FaceBean> faceBeans, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndFeatureMultiFacesCall(personBean, idPhoto, feature, featureVersion, faceBeans, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndFeatureMultiImage(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, Map<ByteString, FaceBean> faceInfo, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndFeatureMultiImageCall(personBean, idPhoto, feature, featureVersion, faceInfo, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndFeatureSaved(PersonBean personBean, String idPhotoMd5, String featureMd5, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndFeatureSavedCall(personBean, idPhotoMd5, featureMd5, token, callback));
    }

    @Override
    public void savePersons(List<PersonBean> persons, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SavePersonsCall(persons, token, callback));
    }

    @Override
    public void savePersonsWithPhoto(Map<ByteString, PersonBean> persons, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new SavePersonsWithPhotoCall(persons, token, callback));
    }

    @Override
    public void saveServiceConfig(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SaveServiceConfigCall(token, callback));
    }

    @Override
    public void setPersonExpiryDate(Integer personId, Long expiryDate, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPersonExpiryDateCall(personId, expiryDate, token, callback));
    }

    @Override
    public void setPersonExpiryDateList(List<Integer> personIdList, Long expiryDate, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPersonExpiryDateListCall(personIdList, expiryDate, token, callback));
    }

    @Override
    public void setPersonExpiryDateTimeStr(Integer personId, String expiryDate, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPersonExpiryDateTimeStrCall(personId, expiryDate, token, callback));
    }

    @Override
    public void setProperties(Map<String, String> config, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPropertiesCall(config, token, callback));
    }

    @Override
    public void setProperty(String key, String value, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPropertyCall(key, value, token, callback));
    }

    @Override
    public void taskQueueOf(String task, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new TaskQueueOfCall(task, token, callback));
    }

    @Override
    public void taskRegister(String task, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new TaskRegisterCall(task, token, callback));
    }

    @Override
    public void unbindBorder(Integer personGroupId, Integer deviceGroupId, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new UnbindBorderCall(personGroupId, deviceGroupId, token, callback));
    }

    @Override
    public void unregisterDevice(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new UnregisterDeviceCall(token, callback));
    }

    @Override
    public void updateDevice(DeviceBean deviceBean, Token token, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new UpdateDeviceCall(deviceBean, token, callback));
    }

    @Override
    public void version(ServiceMethodCallback<String> callback) {
        this.enqueue(new VersionCall(callback));
    }

    @Override
    public void versionInfo(ServiceMethodCallback<Map<String, String>> callback) {
        this.enqueue(new VersionInfoCall(callback));
    }

    private static final class VersionInfoCall
    extends MethodCall<Map<String, String>> {
        VersionInfoCall(ServiceMethodCallback<Map<String, String>> callback) {
            super("versionInfo", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, String> value = new HashMap<String, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class VersionCall
    extends MethodCall<String> {
        VersionCall(ServiceMethodCallback<String> callback) {
            super("version", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class UpdateDeviceCall
    extends MethodCall<DeviceBean> {
        private final DeviceBean deviceBean;
        private final Token token;

        UpdateDeviceCall(DeviceBean deviceBean, Token token, ServiceMethodCallback<DeviceBean> callback) {
            super("updateDevice", (byte)1, callback);
            this.deviceBean = deviceBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceBean != null) {
                protocol.writeFieldBegin("deviceBean", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.deviceBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class UnregisterDeviceCall
    extends MethodCall<Void> {
        private final Token token;

        UnregisterDeviceCall(Token token, ServiceMethodCallback<Void> callback) {
            super("unregisterDevice", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class UnbindBorderCall
    extends MethodCall<Void> {
        private final Integer personGroupId;
        private final Integer deviceGroupId;
        private final Token token;

        UnbindBorderCall(Integer personGroupId, Integer deviceGroupId, Token token, ServiceMethodCallback<Void> callback) {
            super("unbindBorder", (byte)1, callback);
            this.personGroupId = personGroupId;
            this.deviceGroupId = deviceGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personGroupId != null) {
                protocol.writeFieldBegin("personGroupId", 1, (byte)8);
                protocol.writeI32(this.personGroupId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.deviceGroupId != null) {
                protocol.writeFieldBegin("deviceGroupId", 2, (byte)8);
                protocol.writeI32(this.deviceGroupId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class TaskRegisterCall
    extends MethodCall<String> {
        private final String task;
        private final Token token;

        TaskRegisterCall(String task, Token token, ServiceMethodCallback<String> callback) {
            super("taskRegister", (byte)1, callback);
            this.task = task;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.task != null) {
                protocol.writeFieldBegin("task", 1, (byte)11);
                protocol.writeString(this.task);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class TaskQueueOfCall
    extends MethodCall<String> {
        private final String task;
        private final Token token;

        TaskQueueOfCall(String task, Token token, ServiceMethodCallback<String> callback) {
            super("taskQueueOf", (byte)1, callback);
            this.task = task;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.task != null) {
                protocol.writeFieldBegin("task", 1, (byte)11);
                protocol.writeString(this.task);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SetPropertyCall
    extends MethodCall<Void> {
        private final String key;
        private final String value;
        private final Token token;

        SetPropertyCall(String key, String value, Token token, ServiceMethodCallback<Void> callback) {
            super("setProperty", (byte)1, callback);
            this.key = key;
            this.value = value;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.key != null) {
                protocol.writeFieldBegin("key", 1, (byte)11);
                protocol.writeString(this.key);
                protocol.writeFieldEnd();
            }
            if (this.value != null) {
                protocol.writeFieldBegin("value", 2, (byte)11);
                protocol.writeString(this.value);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SetPropertiesCall
    extends MethodCall<Void> {
        private final Map<String, String> config;
        private final Token token;

        SetPropertiesCall(Map<String, String> config, Token token, ServiceMethodCallback<Void> callback) {
            super("setProperties", (byte)1, callback);
            this.config = config;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.config != null) {
                protocol.writeFieldBegin("config", 1, (byte)13);
                protocol.writeMapBegin((byte)11, (byte)11, this.config.size());
                for (Map.Entry<String, String> entry0 : this.config.entrySet()) {
                    String key0 = entry0.getKey();
                    String value0 = entry0.getValue();
                    protocol.writeString(key0);
                    protocol.writeString(value0);
                }
                protocol.writeMapEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SetPersonExpiryDateTimeStrCall
    extends MethodCall<Void> {
        private final Integer personId;
        private final String expiryDate;
        private final Token token;

        SetPersonExpiryDateTimeStrCall(Integer personId, String expiryDate, Token token, ServiceMethodCallback<Void> callback) {
            super("setPersonExpiryDateTimeStr", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.expiryDate = expiryDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.expiryDate != null) {
                protocol.writeFieldBegin("expiryDate", 2, (byte)11);
                protocol.writeString(this.expiryDate);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SetPersonExpiryDateListCall
    extends MethodCall<Void> {
        private final List<Integer> personIdList;
        private final Long expiryDate;
        private final Token token;

        SetPersonExpiryDateListCall(List<Integer> personIdList, Long expiryDate, Token token, ServiceMethodCallback<Void> callback) {
            super("setPersonExpiryDateList", (byte)1, callback);
            this.personIdList = personIdList;
            if (expiryDate == null) {
                throw new NullPointerException("expiryDate");
            }
            this.expiryDate = expiryDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personIdList != null) {
                protocol.writeFieldBegin("personIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.personIdList.size());
                for (Integer item0 : this.personIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("expiryDate", 2, (byte)10);
            protocol.writeI64(this.expiryDate.longValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SetPersonExpiryDateCall
    extends MethodCall<Void> {
        private final Integer personId;
        private final Long expiryDate;
        private final Token token;

        SetPersonExpiryDateCall(Integer personId, Long expiryDate, Token token, ServiceMethodCallback<Void> callback) {
            super("setPersonExpiryDate", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            if (expiryDate == null) {
                throw new NullPointerException("expiryDate");
            }
            this.expiryDate = expiryDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("expiryDate", 2, (byte)10);
            protocol.writeI64(this.expiryDate.longValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SaveServiceConfigCall
    extends MethodCall<Void> {
        private final Token token;

        SaveServiceConfigCall(Token token, ServiceMethodCallback<Void> callback) {
            super("saveServiceConfig", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SavePersonsWithPhotoCall
    extends MethodCall<Integer> {
        private final Map<ByteString, PersonBean> persons;
        private final Token token;

        SavePersonsWithPhotoCall(Map<ByteString, PersonBean> persons, Token token, ServiceMethodCallback<Integer> callback) {
            super("savePersonsWithPhoto", (byte)1, callback);
            this.persons = persons;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.persons != null) {
                protocol.writeFieldBegin("persons", 1, (byte)13);
                protocol.writeMapBegin((byte)11, (byte)12, this.persons.size());
                for (Map.Entry<ByteString, PersonBean> entry0 : this.persons.entrySet()) {
                    ByteString key0 = entry0.getKey();
                    PersonBean value0 = entry0.getValue();
                    protocol.writeBinary(key0);
                    PersonBean.ADAPTER.write(protocol, (Object)value0);
                }
                protocol.writeMapEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonsCall
    extends MethodCall<Void> {
        private final List<PersonBean> persons;
        private final Token token;

        SavePersonsCall(List<PersonBean> persons, Token token, ServiceMethodCallback<Void> callback) {
            super("savePersons", (byte)1, callback);
            this.persons = persons;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.persons != null) {
                protocol.writeFieldBegin("persons", 1, (byte)15);
                protocol.writeListBegin((byte)12, this.persons.size());
                for (PersonBean item0 : this.persons) {
                    PersonBean.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SavePersonWithPhotoAndFeatureSavedCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final String idPhotoMd5;
        private final String featureMd5;
        private final Token token;

        SavePersonWithPhotoAndFeatureSavedCall(PersonBean personBean, String idPhotoMd5, String featureMd5, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndFeatureSaved", (byte)1, callback);
            this.personBean = personBean;
            this.idPhotoMd5 = idPhotoMd5;
            this.featureMd5 = featureMd5;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhotoMd5 != null) {
                protocol.writeFieldBegin("idPhotoMd5", 2, (byte)11);
                protocol.writeString(this.idPhotoMd5);
                protocol.writeFieldEnd();
            }
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 3, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoAndFeatureMultiImageCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final ByteString feature;
        private final String featureVersion;
        private final Map<ByteString, FaceBean> faceInfo;
        private final Token token;

        SavePersonWithPhotoAndFeatureMultiImageCall(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, Map<ByteString, FaceBean> faceInfo, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndFeatureMultiImage", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.faceInfo = faceInfo;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 3, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 4, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.faceInfo != null) {
                protocol.writeFieldBegin("faceInfo", 5, (byte)13);
                protocol.writeMapBegin((byte)11, (byte)12, this.faceInfo.size());
                for (Map.Entry<ByteString, FaceBean> entry0 : this.faceInfo.entrySet()) {
                    ByteString key0 = entry0.getKey();
                    FaceBean value0 = entry0.getValue();
                    protocol.writeBinary(key0);
                    FaceBean.ADAPTER.write(protocol, (Object)value0);
                }
                protocol.writeMapEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 6, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoAndFeatureMultiFacesCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final ByteString feature;
        private final String featureVersion;
        private final List<FaceBean> faceBeans;
        private final Token token;

        SavePersonWithPhotoAndFeatureMultiFacesCall(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, List<FaceBean> faceBeans, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndFeatureMultiFaces", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.faceBeans = faceBeans;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 3, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 4, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.faceBeans != null) {
                protocol.writeFieldBegin("faceBeans", 5, (byte)15);
                protocol.writeListBegin((byte)12, this.faceBeans.size());
                for (FaceBean item0 : this.faceBeans) {
                    FaceBean.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 6, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoAndFeatureCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final FeatureBean featureBean;
        private final Token token;

        SavePersonWithPhotoAndFeatureCall(PersonBean personBean, ByteString idPhoto, FeatureBean featureBean, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndFeature", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.featureBean = featureBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.featureBean != null) {
                protocol.writeFieldBegin("featureBean", 3, (byte)12);
                FeatureBean.ADAPTER.write(protocol, (Object)this.featureBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final Token token;

        SavePersonWithPhotoCall(PersonBean personBean, ByteString idPhoto, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhoto", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonGroupCall
    extends MethodCall<PersonGroupBean> {
        private final PersonGroupBean personGroupBean;
        private final Token token;

        SavePersonGroupCall(PersonGroupBean personGroupBean, Token token, ServiceMethodCallback<PersonGroupBean> callback) {
            super("savePersonGroup", (byte)1, callback);
            this.personGroupBean = personGroupBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personGroupBean != null) {
                protocol.writeFieldBegin("personGroupBean", 1, (byte)12);
                PersonGroupBean.ADAPTER.write(protocol, (Object)this.personGroupBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonGroupBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonGroupBean)PersonGroupBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonFullCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final ByteString feature;
        private final String featureVersion;
        private final ByteString featureImage;
        private final FaceBean featureFaceBean;
        private final Token token;

        SavePersonFullCall(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, ByteString featureImage, FaceBean featureFaceBean, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonFull", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.featureImage = featureImage;
            this.featureFaceBean = featureFaceBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 3, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 4, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.featureImage != null) {
                protocol.writeFieldBegin("featureImage", 5, (byte)11);
                protocol.writeBinary(this.featureImage);
                protocol.writeFieldEnd();
            }
            if (this.featureFaceBean != null) {
                protocol.writeFieldBegin("featureFaceBean", 6, (byte)12);
                FaceBean.ADAPTER.write(protocol, (Object)this.featureFaceBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 7, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final Token token;

        SavePersonCall(PersonBean personBean, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePerson", (byte)1, callback);
            this.personBean = personBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SaveDeviceGroupCall
    extends MethodCall<DeviceGroupBean> {
        private final DeviceGroupBean deviceGroupBean;
        private final Token token;

        SaveDeviceGroupCall(DeviceGroupBean deviceGroupBean, Token token, ServiceMethodCallback<DeviceGroupBean> callback) {
            super("saveDeviceGroup", (byte)1, callback);
            this.deviceGroupBean = deviceGroupBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceGroupBean != null) {
                protocol.writeFieldBegin("deviceGroupBean", 1, (byte)12);
                DeviceGroupBean.ADAPTER.write(protocol, (Object)this.deviceGroupBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceGroupBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceGroupBean)DeviceGroupBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SaveDeviceCall
    extends MethodCall<DeviceBean> {
        private final DeviceBean deviceBean;
        private final Token token;

        SaveDeviceCall(DeviceBean deviceBean, Token token, ServiceMethodCallback<DeviceBean> callback) {
            super("saveDevice", (byte)1, callback);
            this.deviceBean = deviceBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceBean != null) {
                protocol.writeFieldBegin("deviceBean", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.deviceBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RootGroupOfPersonCall
    extends MethodCall<Integer> {
        private final Integer personId;

        RootGroupOfPersonCall(Integer personId, ServiceMethodCallback<Integer> callback) {
            super("rootGroupOfPerson", (byte)1, callback);
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 1, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RootGroupOfDeviceCall
    extends MethodCall<Integer> {
        private final Integer deviceId;

        RootGroupOfDeviceCall(Integer deviceId, ServiceMethodCallback<Integer> callback) {
            super("rootGroupOfDevice", (byte)1, callback);
            this.deviceId = deviceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceId != null) {
                protocol.writeFieldBegin("deviceId", 1, (byte)8);
                protocol.writeI32(this.deviceId.intValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ReplaceFeatureCall
    extends MethodCall<Void> {
        private final Integer personId;
        private final String featureMd5;
        private final Boolean deleteOldFeatureImage;
        private final Token token;

        ReplaceFeatureCall(Integer personId, String featureMd5, Boolean deleteOldFeatureImage, Token token, ServiceMethodCallback<Void> callback) {
            super("replaceFeature", (byte)1, callback);
            this.personId = personId;
            this.featureMd5 = featureMd5;
            if (deleteOldFeatureImage == null) {
                throw new NullPointerException("deleteOldFeatureImage");
            }
            this.deleteOldFeatureImage = deleteOldFeatureImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 1, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 2, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("deleteOldFeatureImage", 3, (byte)2);
            protocol.writeBool(this.deleteOldFeatureImage.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class ReleaseUserTokenCall
    extends MethodCall<Void> {
        private final Token token;

        ReleaseUserTokenCall(Token token, ServiceMethodCallback<Void> callback) {
            super("releaseUserToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class ReleaseRootTokenCall
    extends MethodCall<Void> {
        private final Token token;

        ReleaseRootTokenCall(Token token, ServiceMethodCallback<Void> callback) {
            super("releaseRootToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class ReleasePersonTokenCall
    extends MethodCall<Void> {
        private final Token token;

        ReleasePersonTokenCall(Token token, ServiceMethodCallback<Void> callback) {
            super("releasePersonToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class RegisterDeviceCall
    extends MethodCall<DeviceBean> {
        private final DeviceBean newDevice;

        RegisterDeviceCall(DeviceBean newDevice, ServiceMethodCallback<DeviceBean> callback) {
            super("registerDevice", (byte)1, callback);
            this.newDevice = newDevice;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.newDevice != null) {
                protocol.writeFieldBegin("newDevice", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.newDevice);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class OnlineCall
    extends MethodCall<Token> {
        private final DeviceBean device;

        OnlineCall(DeviceBean device, ServiceMethodCallback<Token> callback) {
            super("online", (byte)1, callback);
            this.device = device;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.device != null) {
                protocol.writeFieldBegin("device", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.device);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Token receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (Token)Token.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class OfflineCall
    extends MethodCall<Void> {
        private final Token token;

        OfflineCall(Token token, ServiceMethodCallback<Void> callback) {
            super("offline", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class LoadUpdatedPersonsTimestrCall
    extends MethodCall<List<Integer>> {
        private final String timestamp;

        LoadUpdatedPersonsTimestrCall(String timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("loadUpdatedPersonsTimestr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadUpdatedPersonsCall
    extends MethodCall<List<Integer>> {
        private final Long timestamp;

        LoadUpdatedPersonsCall(Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("loadUpdatedPersons", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;

        LoadPersonIdByWhereCall(String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByUpdateTimeTimeStrCall
    extends MethodCall<List<Integer>> {
        private final String timestamp;

        LoadPersonIdByUpdateTimeTimeStrCall(String timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByUpdateTimeTimeStr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByUpdateTimeCall
    extends MethodCall<List<Integer>> {
        private final Long timestamp;

        LoadPersonIdByUpdateTimeCall(Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByUpdateTime", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonGroupIdByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;

        LoadPersonGroupIdByWhereCall(String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonGroupIdByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonGroupByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadPersonGroupByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonGroupByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonByWhereCall
    extends MethodCall<List<PersonBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadPersonByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<PersonBean>> callback) {
            super("loadPersonByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonBean> value = new ArrayList<PersonBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonBean item0 = (PersonBean)PersonBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPermitByUpdateTimestrCall
    extends MethodCall<List<PermitBean>> {
        private final String timestamp;

        LoadPermitByUpdateTimestrCall(String timestamp, ServiceMethodCallback<List<PermitBean>> callback) {
            super("loadPermitByUpdateTimestr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PermitBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PermitBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PermitBean> value = new ArrayList<PermitBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PermitBean item0 = (PermitBean)PermitBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPermitByUpdateCall
    extends MethodCall<List<PermitBean>> {
        private final Long timestamp;

        LoadPermitByUpdateCall(Long timestamp, ServiceMethodCallback<List<PermitBean>> callback) {
            super("loadPermitByUpdate", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PermitBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PermitBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PermitBean> value = new ArrayList<PermitBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PermitBean item0 = (PermitBean)PermitBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByWhereCall
    extends MethodCall<List<LogLightBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadLogLightByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByVerifyTimeTimestrCall
    extends MethodCall<List<LogLightBean>> {
        private final String timestamp;
        private final Integer startRow;
        private final Integer numRows;

        LoadLogLightByVerifyTimeTimestrCall(String timestamp, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByVerifyTimeTimestr", (byte)1, callback);
            this.timestamp = timestamp;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByVerifyTimeCall
    extends MethodCall<List<LogLightBean>> {
        private final Long timestamp;
        private final Integer startRow;
        private final Integer numRows;

        LoadLogLightByVerifyTimeCall(Long timestamp, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByVerifyTime", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogByWhereCall
    extends MethodCall<List<LogBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadLogByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogBean>> callback) {
            super("loadLogByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogBean> value = new ArrayList<LogBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogBean item0 = (LogBean)LogBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadFeatureMd5ByUpdateTimeStrCall
    extends MethodCall<List<String>> {
        private final String timestamp;

        LoadFeatureMd5ByUpdateTimeStrCall(String timestamp, ServiceMethodCallback<List<String>> callback) {
            super("loadFeatureMd5ByUpdateTimeStr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadFeatureMd5ByUpdateCall
    extends MethodCall<List<String>> {
        private final Long timestamp;

        LoadFeatureMd5ByUpdateCall(Long timestamp, ServiceMethodCallback<List<String>> callback) {
            super("loadFeatureMd5ByUpdate", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceIdByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;

        LoadDeviceIdByWhereCall(String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDeviceIdByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceGroupIdByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;

        LoadDeviceGroupIdByWhereCall(String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDeviceGroupIdByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceGroupByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadDeviceGroupByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDeviceGroupByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceByWhereCall
    extends MethodCall<List<DeviceBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadDeviceByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<DeviceBean>> callback) {
            super("loadDeviceByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<DeviceBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<DeviceBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<DeviceBean> value = new ArrayList<DeviceBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                DeviceBean item0 = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadAllPersonCall
    extends MethodCall<List<Integer>> {
        LoadAllPersonCall(ServiceMethodCallback<List<Integer>> callback) {
            super("loadAllPerson", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ListOfParentForPersonGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        ListOfParentForPersonGroupCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("listOfParentForPersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ListOfParentForDeviceGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        ListOfParentForDeviceGroupCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("listOfParentForDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidUserTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidUserTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidUserToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidRootTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidRootTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidRootToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidPersonTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidPersonTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidPersonToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidPasswordCall
    extends MethodCall<Boolean> {
        private final String userId;
        private final String password;
        private final Boolean isMd5;

        IsValidPasswordCall(String userId, String password, Boolean isMd5, ServiceMethodCallback<Boolean> callback) {
            super("isValidPassword", (byte)1, callback);
            this.userId = userId;
            this.password = password;
            if (isMd5 == null) {
                throw new NullPointerException("isMd5");
            }
            this.isMd5 = isMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.userId != null) {
                protocol.writeFieldBegin("userId", 1, (byte)11);
                protocol.writeString(this.userId);
                protocol.writeFieldEnd();
            }
            if (this.password != null) {
                protocol.writeFieldBegin("password", 2, (byte)11);
                protocol.writeString(this.password);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("isMd5", 3, (byte)2);
            protocol.writeBool(this.isMd5.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidDeviceTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidDeviceTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidDeviceToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidCmdSnCall
    extends MethodCall<Boolean> {
        private final Long cmdSn;

        IsValidCmdSnCall(Long cmdSn, ServiceMethodCallback<Boolean> callback) {
            super("isValidCmdSn", (byte)1, callback);
            if (cmdSn == null) {
                throw new NullPointerException("cmdSn");
            }
            this.cmdSn = cmdSn;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("cmdSn", 1, (byte)10);
            protocol.writeI64(this.cmdSn.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidAckChannelCall
    extends MethodCall<Boolean> {
        private final String ackChannel;

        IsValidAckChannelCall(String ackChannel, ServiceMethodCallback<Boolean> callback) {
            super("isValidAckChannel", (byte)1, callback);
            this.ackChannel = ackChannel;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.ackChannel != null) {
                protocol.writeFieldBegin("ackChannel", 1, (byte)11);
                protocol.writeString(this.ackChannel);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsLocalCall
    extends MethodCall<Boolean> {
        IsLocalCall(ServiceMethodCallback<Boolean> callback) {
            super("isLocal", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsDisableCall
    extends MethodCall<Boolean> {
        private final Integer personId;

        IsDisableCall(Integer personId, ServiceMethodCallback<Boolean> callback) {
            super("isDisable", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetSubPersonGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        GetSubPersonGroupCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getSubPersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetSubDeviceGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        GetSubDeviceGroupCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getSubDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetServiceConfigCall
    extends MethodCall<Map<String, String>> {
        private final Token token;

        GetServiceConfigCall(Token token, ServiceMethodCallback<Map<String, String>> callback) {
            super("getServiceConfig", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, String> value = new HashMap<String, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetRedisParametersCall
    extends MethodCall<Map<MQParam, String>> {
        private final Token token;

        GetRedisParametersCall(Token token, ServiceMethodCallback<Map<MQParam, String>> callback) {
            super("getRedisParameters", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<MQParam, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<MQParam, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<MQParam, String> value = new HashMap<MQParam, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                int i32_1 = protocol.readI32();
                                MQParam key0 = MQParam.findByValue(i32_1);
                                if (key0 == null) {
                                    throw new ThriftException(ThriftException.Kind.PROTOCOL_ERROR, "Unexpected value for enum-type MQParam: " + i32_1);
                                }
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPropertyCall
    extends MethodCall<String> {
        private final String key;
        private final Token token;

        GetPropertyCall(String key, Token token, ServiceMethodCallback<String> callback) {
            super("getProperty", (byte)1, callback);
            this.key = key;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.key != null) {
                protocol.writeFieldBegin("key", 1, (byte)11);
                protocol.writeString(this.key);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonsOfGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        GetPersonsOfGroupCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getPersonsOfGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonsCall
    extends MethodCall<List<PersonBean>> {
        private final List<Integer> idList;

        GetPersonsCall(List<Integer> idList, ServiceMethodCallback<List<PersonBean>> callback) {
            super("getPersons", (byte)1, callback);
            this.idList = idList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.idList != null) {
                protocol.writeFieldBegin("idList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.idList.size());
                for (Integer item0 : this.idList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonBean> value = new ArrayList<PersonBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonBean item0 = (PersonBean)PersonBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonPermitsCall
    extends MethodCall<List<PermitBean>> {
        private final Integer deviceId;
        private final List<Integer> personIdList;

        GetPersonPermitsCall(Integer deviceId, List<Integer> personIdList, ServiceMethodCallback<List<PermitBean>> callback) {
            super("getPersonPermits", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            this.personIdList = personIdList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            if (this.personIdList != null) {
                protocol.writeFieldBegin("personIdList", 2, (byte)15);
                protocol.writeListBegin((byte)8, this.personIdList.size());
                for (Integer item0 : this.personIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PermitBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PermitBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PermitBean> value = new ArrayList<PermitBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PermitBean item0 = (PermitBean)PermitBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonPermitCall
    extends MethodCall<PermitBean> {
        private final Integer deviceId;
        private final Integer personId;

        GetPersonPermitCall(Integer deviceId, Integer personId, ServiceMethodCallback<PermitBean> callback) {
            super("getPersonPermit", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personId", 2, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PermitBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PermitBean)PermitBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonGroupsPermittedByCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        GetPersonGroupsPermittedByCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getPersonGroupsPermittedBy", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonGroupsBelongsCall
    extends MethodCall<List<Integer>> {
        private final Integer personId;

        GetPersonGroupsBelongsCall(Integer personId, ServiceMethodCallback<List<Integer>> callback) {
            super("getPersonGroupsBelongs", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonGroupsCall
    extends MethodCall<List<PersonGroupBean>> {
        private final List<Integer> groupIdList;

        GetPersonGroupsCall(List<Integer> groupIdList, ServiceMethodCallback<List<PersonGroupBean>> callback) {
            super("getPersonGroups", (byte)1, callback);
            this.groupIdList = groupIdList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.groupIdList != null) {
                protocol.writeFieldBegin("groupIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.groupIdList.size());
                for (Integer item0 : this.groupIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonGroupBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonGroupBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonGroupBean> value = new ArrayList<PersonGroupBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonGroupBean item0 = (PersonGroupBean)PersonGroupBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonGroupCall
    extends MethodCall<PersonGroupBean> {
        private final Integer personGroupId;

        GetPersonGroupCall(Integer personGroupId, ServiceMethodCallback<PersonGroupBean> callback) {
            super("getPersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonGroupBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonGroupBean)PersonGroupBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonByPapersNumCall
    extends MethodCall<PersonBean> {
        private final String papersNum;

        GetPersonByPapersNumCall(String papersNum, ServiceMethodCallback<PersonBean> callback) {
            super("getPersonByPapersNum", (byte)1, callback);
            this.papersNum = papersNum;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.papersNum != null) {
                protocol.writeFieldBegin("papersNum", 1, (byte)11);
                protocol.writeString(this.papersNum);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonCall
    extends MethodCall<PersonBean> {
        private final Integer personId;

        GetPersonCall(Integer personId, ServiceMethodCallback<PersonBean> callback) {
            super("getPerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetLogBeansByPersonIdCall
    extends MethodCall<List<LogBean>> {
        private final Integer personId;

        GetLogBeansByPersonIdCall(Integer personId, ServiceMethodCallback<List<LogBean>> callback) {
            super("getLogBeansByPersonId", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogBean> value = new ArrayList<LogBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogBean item0 = (LogBean)LogBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetImagesAssociatedByFeatureCall
    extends MethodCall<List<String>> {
        private final String featureMd5;

        GetImagesAssociatedByFeatureCall(String featureMd5, ServiceMethodCallback<List<String>> callback) {
            super("getImagesAssociatedByFeature", (byte)1, callback);
            this.featureMd5 = featureMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 1, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetImageBytesCall
    extends MethodCall<ByteString> {
        private final String imageMD5;

        GetImageBytesCall(String imageMD5, ServiceMethodCallback<ByteString> callback) {
            super("getImageBytes", (byte)1, callback);
            this.imageMD5 = imageMD5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageMD5 != null) {
                protocol.writeFieldBegin("imageMD5", 1, (byte)11);
                protocol.writeString(this.imageMD5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ByteString receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ByteString result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            result = value = protocol.readBinary();
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetImageCall
    extends MethodCall<ImageBean> {
        private final String imageMD5;

        GetImageCall(String imageMD5, ServiceMethodCallback<ImageBean> callback) {
            super("getImage", (byte)1, callback);
            this.imageMD5 = imageMD5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageMD5 != null) {
                protocol.writeFieldBegin("imageMD5", 1, (byte)11);
                protocol.writeString(this.imageMD5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ImageBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (ImageBean)ImageBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetGroupPermitsCall
    extends MethodCall<List<PermitBean>> {
        private final Integer deviceId;
        private final List<Integer> personGroupIdList;

        GetGroupPermitsCall(Integer deviceId, List<Integer> personGroupIdList, ServiceMethodCallback<List<PermitBean>> callback) {
            super("getGroupPermits", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            this.personGroupIdList = personGroupIdList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            if (this.personGroupIdList != null) {
                protocol.writeFieldBegin("personGroupIdList", 2, (byte)15);
                protocol.writeListBegin((byte)8, this.personGroupIdList.size());
                for (Integer item0 : this.personGroupIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PermitBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PermitBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PermitBean> value = new ArrayList<PermitBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PermitBean item0 = (PermitBean)PermitBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetGroupPermitOnDeviceGroupCall
    extends MethodCall<PermitBean> {
        private final Integer deviceGroupId;
        private final Integer personGroupId;

        GetGroupPermitOnDeviceGroupCall(Integer deviceGroupId, Integer personGroupId, ServiceMethodCallback<PermitBean> callback) {
            super("getGroupPermitOnDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personGroupId", 2, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PermitBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PermitBean)PermitBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetGroupPermitCall
    extends MethodCall<PermitBean> {
        private final Integer deviceId;
        private final Integer personGroupId;

        GetGroupPermitCall(Integer deviceId, Integer personGroupId, ServiceMethodCallback<PermitBean> callback) {
            super("getGroupPermit", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personGroupId", 2, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PermitBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PermitBean)PermitBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesOfPersonCall
    extends MethodCall<List<String>> {
        private final Integer personId;

        GetFeaturesOfPersonCall(Integer personId, ServiceMethodCallback<List<String>> callback) {
            super("getFeaturesOfPerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesByPersonIdAndSdkVersionCall
    extends MethodCall<List<String>> {
        private final Integer personId;
        private final String sdkVersion;

        GetFeaturesByPersonIdAndSdkVersionCall(Integer personId, String sdkVersion, ServiceMethodCallback<List<String>> callback) {
            super("getFeaturesByPersonIdAndSdkVersion", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.sdkVersion = sdkVersion;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.sdkVersion != null) {
                protocol.writeFieldBegin("sdkVersion", 2, (byte)11);
                protocol.writeString(this.sdkVersion);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesByPersonIdCall
    extends MethodCall<List<String>> {
        private final Integer personId;

        GetFeaturesByPersonIdCall(Integer personId, ServiceMethodCallback<List<String>> callback) {
            super("getFeaturesByPersonId", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesCall
    extends MethodCall<List<FeatureBean>> {
        private final List<String> md5;

        GetFeaturesCall(List<String> md5, ServiceMethodCallback<List<FeatureBean>> callback) {
            super("getFeatures", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)15);
                protocol.writeListBegin((byte)11, this.md5.size());
                for (String item0 : this.md5) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<FeatureBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<FeatureBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<FeatureBean> value = new ArrayList<FeatureBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                FeatureBean item0 = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureBytesCall
    extends MethodCall<ByteString> {
        private final String md5;

        GetFeatureBytesCall(String md5, ServiceMethodCallback<ByteString> callback) {
            super("getFeatureBytes", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ByteString receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ByteString result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            result = value = protocol.readBinary();
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureCall
    extends MethodCall<FeatureBean> {
        private final String md5;

        GetFeatureCall(String md5, ServiceMethodCallback<FeatureBean> callback) {
            super("getFeature", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FeatureBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFaceCall
    extends MethodCall<FaceBean> {
        private final Integer faceId;

        GetFaceCall(Integer faceId, ServiceMethodCallback<FaceBean> callback) {
            super("getFace", (byte)1, callback);
            if (faceId == null) {
                throw new NullPointerException("faceId");
            }
            this.faceId = faceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("faceId", 1, (byte)8);
            protocol.writeI32(this.faceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FaceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FaceBean)FaceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDevicesOfGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        GetDevicesOfGroupCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getDevicesOfGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDevicesCall
    extends MethodCall<List<DeviceBean>> {
        private final List<Integer> idList;

        GetDevicesCall(List<Integer> idList, ServiceMethodCallback<List<DeviceBean>> callback) {
            super("getDevices", (byte)1, callback);
            this.idList = idList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.idList != null) {
                protocol.writeFieldBegin("idList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.idList.size());
                for (Integer item0 : this.idList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<DeviceBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<DeviceBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<DeviceBean> value = new ArrayList<DeviceBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                DeviceBean item0 = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceIdOfFeatureCall
    extends MethodCall<Integer> {
        private final String featureMd5;

        GetDeviceIdOfFeatureCall(String featureMd5, ServiceMethodCallback<Integer> callback) {
            super("getDeviceIdOfFeature", (byte)1, callback);
            this.featureMd5 = featureMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 1, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupsPermittedByCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        GetDeviceGroupsPermittedByCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getDeviceGroupsPermittedBy", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupsPermitCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        GetDeviceGroupsPermitCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getDeviceGroupsPermit", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupsBelongsCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceId;

        GetDeviceGroupsBelongsCall(Integer deviceId, ServiceMethodCallback<List<Integer>> callback) {
            super("getDeviceGroupsBelongs", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupsCall
    extends MethodCall<List<DeviceGroupBean>> {
        private final List<Integer> groupIdList;

        GetDeviceGroupsCall(List<Integer> groupIdList, ServiceMethodCallback<List<DeviceGroupBean>> callback) {
            super("getDeviceGroups", (byte)1, callback);
            this.groupIdList = groupIdList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.groupIdList != null) {
                protocol.writeFieldBegin("groupIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.groupIdList.size());
                for (Integer item0 : this.groupIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<DeviceGroupBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<DeviceGroupBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<DeviceGroupBean> value = new ArrayList<DeviceGroupBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                DeviceGroupBean item0 = (DeviceGroupBean)DeviceGroupBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupCall
    extends MethodCall<DeviceGroupBean> {
        private final Integer deviceGroupId;

        GetDeviceGroupCall(Integer deviceGroupId, ServiceMethodCallback<DeviceGroupBean> callback) {
            super("getDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceGroupBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceGroupBean)DeviceGroupBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceCall
    extends MethodCall<DeviceBean> {
        private final Integer deviceId;

        GetDeviceCall(Integer deviceId, ServiceMethodCallback<DeviceBean> callback) {
            super("getDevice", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ExistsPersonCall
    extends MethodCall<Boolean> {
        private final Integer persionId;

        ExistsPersonCall(Integer persionId, ServiceMethodCallback<Boolean> callback) {
            super("existsPerson", (byte)1, callback);
            if (persionId == null) {
                throw new NullPointerException("persionId");
            }
            this.persionId = persionId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("persionId", 1, (byte)8);
            protocol.writeI32(this.persionId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ExistsImageCall
    extends MethodCall<Boolean> {
        private final String md5;

        ExistsImageCall(String md5, ServiceMethodCallback<Boolean> callback) {
            super("existsImage", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ExistsFeatureCall
    extends MethodCall<Boolean> {
        private final String md5;

        ExistsFeatureCall(String md5, ServiceMethodCallback<Boolean> callback) {
            super("existsFeature", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ExistsDeviceCall
    extends MethodCall<Boolean> {
        private final Integer id;

        ExistsDeviceCall(Integer id, ServiceMethodCallback<Boolean> callback) {
            super("existsDevice", (byte)1, callback);
            if (id == null) {
                throw new NullPointerException("id");
            }
            this.id = id;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("id", 1, (byte)8);
            protocol.writeI32(this.id.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DisablePersonListCall
    extends MethodCall<Void> {
        private final List<Integer> personIdList;
        private final Token token;

        DisablePersonListCall(List<Integer> personIdList, Token token, ServiceMethodCallback<Void> callback) {
            super("disablePersonList", (byte)1, callback);
            this.personIdList = personIdList;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personIdList != null) {
                protocol.writeFieldBegin("personIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.personIdList.size());
                for (Integer item0 : this.personIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class DisablePersonCall
    extends MethodCall<Void> {
        private final Integer personId;
        private final Integer moveToGroupId;
        private final Boolean deletePhoto;
        private final Boolean deleteFeature;
        private final Boolean deleteLog;
        private final Token token;

        DisablePersonCall(Integer personId, Integer moveToGroupId, Boolean deletePhoto, Boolean deleteFeature, Boolean deleteLog, Token token, ServiceMethodCallback<Void> callback) {
            super("disablePerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.moveToGroupId = moveToGroupId;
            if (deletePhoto == null) {
                throw new NullPointerException("deletePhoto");
            }
            this.deletePhoto = deletePhoto;
            if (deleteFeature == null) {
                throw new NullPointerException("deleteFeature");
            }
            this.deleteFeature = deleteFeature;
            if (deleteLog == null) {
                throw new NullPointerException("deleteLog");
            }
            this.deleteLog = deleteLog;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.moveToGroupId != null) {
                protocol.writeFieldBegin("moveToGroupId", 2, (byte)8);
                protocol.writeI32(this.moveToGroupId.intValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("deletePhoto", 3, (byte)2);
            protocol.writeBool(this.deletePhoto.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deleteFeature", 4, (byte)2);
            protocol.writeBool(this.deleteFeature.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deleteLog", 5, (byte)2);
            protocol.writeBool(this.deleteLog.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 6, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class DeletePersonsByPapersNumCall
    extends MethodCall<Integer> {
        private final List<String> papersNumlist;
        private final Token token;

        DeletePersonsByPapersNumCall(List<String> papersNumlist, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonsByPapersNum", (byte)1, callback);
            this.papersNumlist = papersNumlist;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.papersNumlist != null) {
                protocol.writeFieldBegin("papersNumlist", 1, (byte)15);
                protocol.writeListBegin((byte)11, this.papersNumlist.size());
                for (String item0 : this.papersNumlist) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonsCall
    extends MethodCall<Integer> {
        private final List<Integer> personIdList;
        private final Token token;

        DeletePersonsCall(List<Integer> personIdList, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersons", (byte)1, callback);
            this.personIdList = personIdList;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personIdList != null) {
                protocol.writeFieldBegin("personIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.personIdList.size());
                for (Integer item0 : this.personIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonGroupPermitCall
    extends MethodCall<Integer> {
        private final Integer personGroupId;
        private final Token token;

        DeletePersonGroupPermitCall(Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonGroupPermit", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonGroupCall
    extends MethodCall<Integer> {
        private final Integer personGroupId;
        private final Token token;

        DeletePersonGroupCall(Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonByPapersNumCall
    extends MethodCall<Integer> {
        private final String papersNum;
        private final Token token;

        DeletePersonByPapersNumCall(String papersNum, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonByPapersNum", (byte)1, callback);
            this.papersNum = papersNum;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.papersNum != null) {
                protocol.writeFieldBegin("papersNum", 1, (byte)11);
                protocol.writeString(this.papersNum);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonCall
    extends MethodCall<Integer> {
        private final Integer personId;
        private final Token token;

        DeletePersonCall(Integer personId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePermitByIdCall
    extends MethodCall<Integer> {
        private final Integer deviceGroupId;
        private final Integer personGroupId;
        private final Token token;

        DeletePermitByIdCall(Integer deviceGroupId, Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePermitById", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personGroupId", 2, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePermitCall
    extends MethodCall<Integer> {
        private final DeviceGroupBean deviceGroup;
        private final PersonGroupBean personGroup;
        private final Token token;

        DeletePermitCall(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePermit", (byte)1, callback);
            this.deviceGroup = deviceGroup;
            this.personGroup = personGroup;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceGroup != null) {
                protocol.writeFieldBegin("deviceGroup", 1, (byte)12);
                DeviceGroupBean.ADAPTER.write(protocol, (Object)this.deviceGroup);
                protocol.writeFieldEnd();
            }
            if (this.personGroup != null) {
                protocol.writeFieldBegin("personGroup", 2, (byte)12);
                PersonGroupBean.ADAPTER.write(protocol, (Object)this.personGroup);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteImageCall
    extends MethodCall<Integer> {
        private final String imageMd5;
        private final Token token;

        DeleteImageCall(String imageMd5, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteImage", (byte)1, callback);
            this.imageMd5 = imageMd5;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageMd5 != null) {
                protocol.writeFieldBegin("imageMd5", 1, (byte)11);
                protocol.writeString(this.imageMd5);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteGroupPermitOnDeviceGroupCall
    extends MethodCall<Integer> {
        private final Integer deviceGroupId;
        private final Token token;

        DeleteGroupPermitOnDeviceGroupCall(Integer deviceGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteGroupPermitOnDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteFeatureCall
    extends MethodCall<List<String>> {
        private final String featureMd5;
        private final Boolean deleteImage;
        private final Token token;

        DeleteFeatureCall(String featureMd5, Boolean deleteImage, Token token, ServiceMethodCallback<List<String>> callback) {
            super("deleteFeature", (byte)1, callback);
            this.featureMd5 = featureMd5;
            if (deleteImage == null) {
                throw new NullPointerException("deleteImage");
            }
            this.deleteImage = deleteImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 1, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("deleteImage", 2, (byte)2);
            protocol.writeBool(this.deleteImage.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteDeviceGroupCall
    extends MethodCall<Integer> {
        private final Integer deviceGroupId;
        private final Token token;

        DeleteDeviceGroupCall(Integer deviceGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteAllFeaturesByPersonIdCall
    extends MethodCall<Integer> {
        private final Integer personId;
        private final Boolean deleteImage;
        private final Token token;

        DeleteAllFeaturesByPersonIdCall(Integer personId, Boolean deleteImage, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteAllFeaturesByPersonId", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            if (deleteImage == null) {
                throw new NullPointerException("deleteImage");
            }
            this.deleteImage = deleteImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deleteImage", 2, (byte)2);
            protocol.writeBool(this.deleteImage.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonGroupByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountPersonGroupByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countPersonGroupByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountPersonByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countPersonByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountLogLightByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByVerifyTimeTimestrCall
    extends MethodCall<Integer> {
        private final String timestamp;

        CountLogLightByVerifyTimeTimestrCall(String timestamp, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByVerifyTimeTimestr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByVerifyTimeCall
    extends MethodCall<Integer> {
        private final Long timestamp;

        CountLogLightByVerifyTimeCall(Long timestamp, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByVerifyTime", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountLogByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countLogByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountDeviceGroupByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountDeviceGroupByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countDeviceGroupByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountDeviceByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountDeviceByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countDeviceByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ChildListForPersonGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        ChildListForPersonGroupCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("childListForPersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ChildListForDeviceGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        ChildListForDeviceGroupCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("childListForDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class BindBorderCall
    extends MethodCall<Void> {
        private final Integer personGroupId;
        private final Integer deviceGroupId;
        private final Token token;

        BindBorderCall(Integer personGroupId, Integer deviceGroupId, Token token, ServiceMethodCallback<Void> callback) {
            super("bindBorder", (byte)1, callback);
            this.personGroupId = personGroupId;
            this.deviceGroupId = deviceGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personGroupId != null) {
                protocol.writeFieldBegin("personGroupId", 1, (byte)8);
                protocol.writeI32(this.personGroupId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.deviceGroupId != null) {
                protocol.writeFieldBegin("deviceGroupId", 2, (byte)8);
                protocol.writeI32(this.deviceGroupId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class ApplyUserTokenCall
    extends MethodCall<Token> {
        private final Integer userid;
        private final String password;
        private final Boolean isMd5;

        ApplyUserTokenCall(Integer userid, String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
            super("applyUserToken", (byte)1, callback);
            if (userid == null) {
                throw new NullPointerException("userid");
            }
            this.userid = userid;
            this.password = password;
            if (isMd5 == null) {
                throw new NullPointerException("isMd5");
            }
            this.isMd5 = isMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("userid", 1, (byte)8);
            protocol.writeI32(this.userid.intValue());
            protocol.writeFieldEnd();
            if (this.password != null) {
                protocol.writeFieldBegin("password", 2, (byte)11);
                protocol.writeString(this.password);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("isMd5", 3, (byte)2);
            protocol.writeBool(this.isMd5.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Token receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (Token)Token.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyRootTokenCall
    extends MethodCall<Token> {
        private final String password;
        private final Boolean isMd5;

        ApplyRootTokenCall(String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
            super("applyRootToken", (byte)1, callback);
            this.password = password;
            if (isMd5 == null) {
                throw new NullPointerException("isMd5");
            }
            this.isMd5 = isMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.password != null) {
                protocol.writeFieldBegin("password", 1, (byte)11);
                protocol.writeString(this.password);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("isMd5", 2, (byte)2);
            protocol.writeBool(this.isMd5.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Token receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (Token)Token.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyPersonTokenCall
    extends MethodCall<Token> {
        private final Integer personId;
        private final String password;
        private final Boolean isMd5;

        ApplyPersonTokenCall(Integer personId, String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
            super("applyPersonToken", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.password = password;
            if (isMd5 == null) {
                throw new NullPointerException("isMd5");
            }
            this.isMd5 = isMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.password != null) {
                protocol.writeFieldBegin("password", 2, (byte)11);
                protocol.writeString(this.password);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("isMd5", 3, (byte)2);
            protocol.writeBool(this.isMd5.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Token receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (Token)Token.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyCmdSnCall
    extends MethodCall<Long> {
        private final Token token;

        ApplyCmdSnCall(Token token, ServiceMethodCallback<Long> callback) {
            super("applyCmdSn", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Long receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Long result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 10) {
                            long value = protocol.readI64();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyAckChannelWithDurationCall
    extends MethodCall<String> {
        private final Token token;
        private final Long duration;

        ApplyAckChannelWithDurationCall(Token token, Long duration, ServiceMethodCallback<String> callback) {
            super("applyAckChannelWithDuration", (byte)1, callback);
            this.token = token;
            if (duration == null) {
                throw new NullPointerException("duration");
            }
            this.duration = duration;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("duration", 2, (byte)10);
            protocol.writeI64(this.duration.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyAckChannelCall
    extends MethodCall<String> {
        private final Token token;

        ApplyAckChannelCall(Token token, ServiceMethodCallback<String> callback) {
            super("applyAckChannel", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddPermitByIdCall
    extends MethodCall<Void> {
        private final Integer deviceGroupId;
        private final Integer personGroupId;
        private final Token token;

        AddPermitByIdCall(Integer deviceGroupId, Integer personGroupId, Token token, ServiceMethodCallback<Void> callback) {
            super("addPermitById", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personGroupId", 2, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class AddPermitCall
    extends MethodCall<Void> {
        private final DeviceGroupBean deviceGroup;
        private final PersonGroupBean personGroup;
        private final Token token;

        AddPermitCall(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token, ServiceMethodCallback<Void> callback) {
            super("addPermit", (byte)1, callback);
            this.deviceGroup = deviceGroup;
            this.personGroup = personGroup;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceGroup != null) {
                protocol.writeFieldBegin("deviceGroup", 1, (byte)12);
                DeviceGroupBean.ADAPTER.write(protocol, (Object)this.deviceGroup);
                protocol.writeFieldEnd();
            }
            if (this.personGroup != null) {
                protocol.writeFieldBegin("personGroup", 2, (byte)12);
                PersonGroupBean.ADAPTER.write(protocol, (Object)this.personGroup);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class AddLogsFullCall
    extends MethodCall<Void> {
        private final List<LogBean> logBeans;
        private final List<FaceBean> faceBeans;
        private final List<ByteString> featureImages;
        private final Token token;

        AddLogsFullCall(List<LogBean> logBeans, List<FaceBean> faceBeans, List<ByteString> featureImages, Token token, ServiceMethodCallback<Void> callback) {
            super("addLogsFull", (byte)1, callback);
            this.logBeans = logBeans;
            this.faceBeans = faceBeans;
            this.featureImages = featureImages;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBeans != null) {
                protocol.writeFieldBegin("logBeans", 1, (byte)15);
                protocol.writeListBegin((byte)12, this.logBeans.size());
                for (LogBean logBean : this.logBeans) {
                    LogBean.ADAPTER.write(protocol, (Object)logBean);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.faceBeans != null) {
                protocol.writeFieldBegin("faceBeans", 2, (byte)15);
                protocol.writeListBegin((byte)12, this.faceBeans.size());
                for (FaceBean faceBean : this.faceBeans) {
                    FaceBean.ADAPTER.write(protocol, (Object)faceBean);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.featureImages != null) {
                protocol.writeFieldBegin("featureImages", 3, (byte)15);
                protocol.writeListBegin((byte)11, this.featureImages.size());
                for (ByteString byteString : this.featureImages) {
                    protocol.writeBinary(byteString);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddLogsCall
    extends MethodCall<Void> {
        private final List<LogBean> beans;
        private final Token token;

        AddLogsCall(List<LogBean> beans, Token token, ServiceMethodCallback<Void> callback) {
            super("addLogs", (byte)1, callback);
            this.beans = beans;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.beans != null) {
                protocol.writeFieldBegin("beans", 1, (byte)15);
                protocol.writeListBegin((byte)12, this.beans.size());
                for (LogBean item0 : this.beans) {
                    LogBean.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddLogFullCall
    extends MethodCall<Void> {
        private final LogBean logBean;
        private final FaceBean faceBean;
        private final ByteString featureImage;
        private final Token token;

        AddLogFullCall(LogBean logBean, FaceBean faceBean, ByteString featureImage, Token token, ServiceMethodCallback<Void> callback) {
            super("addLogFull", (byte)1, callback);
            this.logBean = logBean;
            this.faceBean = faceBean;
            this.featureImage = featureImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBean != null) {
                protocol.writeFieldBegin("logBean", 1, (byte)12);
                LogBean.ADAPTER.write(protocol, (Object)this.logBean);
                protocol.writeFieldEnd();
            }
            if (this.faceBean != null) {
                protocol.writeFieldBegin("faceBean", 2, (byte)12);
                FaceBean.ADAPTER.write(protocol, (Object)this.faceBean);
                protocol.writeFieldEnd();
            }
            if (this.featureImage != null) {
                protocol.writeFieldBegin("featureImage", 3, (byte)11);
                protocol.writeBinary(this.featureImage);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddLogCall
    extends MethodCall<Void> {
        private final LogBean logBean;
        private final Token token;

        AddLogCall(LogBean logBean, Token token, ServiceMethodCallback<Void> callback) {
            super("addLog", (byte)1, callback);
            this.logBean = logBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBean != null) {
                protocol.writeFieldBegin("logBean", 1, (byte)12);
                LogBean.ADAPTER.write(protocol, (Object)this.logBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddImageCall
    extends MethodCall<ImageBean> {
        private final ByteString imageData;
        private final Integer deviceId;
        private final FaceBean faceBean;
        private final Integer personId;
        private final Token token;

        AddImageCall(ByteString imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token, ServiceMethodCallback<ImageBean> callback) {
            super("addImage", (byte)1, callback);
            this.imageData = imageData;
            this.deviceId = deviceId;
            this.faceBean = faceBean;
            this.personId = personId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageData != null) {
                protocol.writeFieldBegin("imageData", 1, (byte)11);
                protocol.writeBinary(this.imageData);
                protocol.writeFieldEnd();
            }
            if (this.deviceId != null) {
                protocol.writeFieldBegin("deviceId", 2, (byte)8);
                protocol.writeI32(this.deviceId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.faceBean != null) {
                protocol.writeFieldBegin("faceBean", 3, (byte)12);
                FaceBean.ADAPTER.write(protocol, (Object)this.faceBean);
                protocol.writeFieldEnd();
            }
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 4, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 5, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ImageBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (ImageBean)ImageBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddFeatureWithImageCall
    extends MethodCall<FeatureBean> {
        private final ByteString feature;
        private final String featureVersion;
        private final Integer personId;
        private final Boolean asIdPhotoIfAbsent;
        private final ByteString featurePhoto;
        private final FaceBean faceBean;
        private final Token token;

        AddFeatureWithImageCall(ByteString feature, String featureVersion, Integer personId, Boolean asIdPhotoIfAbsent, ByteString featurePhoto, FaceBean faceBean, Token token, ServiceMethodCallback<FeatureBean> callback) {
            super("addFeatureWithImage", (byte)1, callback);
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.personId = personId;
            if (asIdPhotoIfAbsent == null) {
                throw new NullPointerException("asIdPhotoIfAbsent");
            }
            this.asIdPhotoIfAbsent = asIdPhotoIfAbsent;
            this.featurePhoto = featurePhoto;
            this.faceBean = faceBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 1, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 2, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 3, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("asIdPhotoIfAbsent", 4, (byte)2);
            protocol.writeBool(this.asIdPhotoIfAbsent.booleanValue());
            protocol.writeFieldEnd();
            if (this.featurePhoto != null) {
                protocol.writeFieldBegin("featurePhoto", 5, (byte)11);
                protocol.writeBinary(this.featurePhoto);
                protocol.writeFieldEnd();
            }
            if (this.faceBean != null) {
                protocol.writeFieldBegin("faceBean", 6, (byte)12);
                FaceBean.ADAPTER.write(protocol, (Object)this.faceBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 7, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FeatureBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddFeatureMultiCall
    extends MethodCall<FeatureBean> {
        private final ByteString feature;
        private final String featureVersion;
        private final Integer personId;
        private final Map<ByteString, FaceBean> faceInfo;
        private final Token token;

        AddFeatureMultiCall(ByteString feature, String featureVersion, Integer personId, Map<ByteString, FaceBean> faceInfo, Token token, ServiceMethodCallback<FeatureBean> callback) {
            super("addFeatureMulti", (byte)1, callback);
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.personId = personId;
            this.faceInfo = faceInfo;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 1, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 2, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 3, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.faceInfo != null) {
                protocol.writeFieldBegin("faceInfo", 4, (byte)13);
                protocol.writeMapBegin((byte)11, (byte)12, this.faceInfo.size());
                for (Map.Entry<ByteString, FaceBean> entry0 : this.faceInfo.entrySet()) {
                    ByteString key0 = entry0.getKey();
                    FaceBean value0 = entry0.getValue();
                    protocol.writeBinary(key0);
                    FaceBean.ADAPTER.write(protocol, (Object)value0);
                }
                protocol.writeMapEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 5, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FeatureBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddFeatureCall
    extends MethodCall<FeatureBean> {
        private final ByteString feature;
        private final String featureVersion;
        private final Integer personId;
        private final List<FaceBean> faecBeans;
        private final Token token;

        AddFeatureCall(ByteString feature, String featureVersion, Integer personId, List<FaceBean> faecBeans, Token token, ServiceMethodCallback<FeatureBean> callback) {
            super("addFeature", (byte)1, callback);
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.personId = personId;
            this.faecBeans = faecBeans;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 1, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 2, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 3, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.faecBeans != null) {
                protocol.writeFieldBegin("faecBeans", 4, (byte)15);
                protocol.writeListBegin((byte)12, this.faecBeans.size());
                for (FaceBean item0 : this.faecBeans) {
                    FaceBean.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 5, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FeatureBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }
}

