/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.Token;
import net.gdface.facelog.client.thrift.DeviceBean;
import net.gdface.facelog.client.thrift.DuplicateRecordException;
import net.gdface.facelog.client.thrift.IFaceLogClient;
import net.gdface.facelog.client.thrift.LogBean;
import net.gdface.facelog.client.thrift.LogLightBean;
import net.gdface.facelog.client.thrift.ServiceRuntimeException;
import net.gdface.facelog.client.thrift.ServiceSecurityException;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.thrift.ClientFactory;
import net.gdface.thrift.TypeTransformer;
import okio.ByteString;

public class IFaceLogThriftClientAsync {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return this.factory;
    }

    public IFaceLogThriftClientAsync(ClientFactory factory) {
        this.factory = (ClientFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClientAsync [factory=");
        builder.append(this.factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }

    public ListenableFuture<FeatureBean> addFeature(byte[] feature, String featureVersion, Integer personId, boolean asIdPhotoIfAbsent, byte[] featurePhoto, FaceBean faceBean, Token token) {
        MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = new MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean>(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.addFeatureWithImage((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, asIdPhotoIfAbsent, (ByteString)TypeTransformer.getInstance().to((Object)featurePhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addFeature(byte[] feature, String featureVersion, Integer personId, boolean asIdPhotoIfAbsent, byte[] featurePhoto, FaceBean faceBean, Token token, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.addFeature(feature, featureVersion, personId, asIdPhotoIfAbsent, featurePhoto, faceBean, token), callback);
    }

    public ListenableFuture<FeatureBean> addFeature(byte[] feature, String featureVersion, Integer personId, List<FaceBean> faecBeans, Token token) {
        MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = new MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean>(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.addFeature((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, TypeTransformer.getInstance().to(faecBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addFeature(byte[] feature, String featureVersion, Integer personId, List<FaceBean> faecBeans, Token token, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.addFeature(feature, featureVersion, personId, faecBeans, token), callback);
    }

    public ListenableFuture<FeatureBean> addFeature(byte[] feature, String featureVersion, Integer personId, Map<ByteBuffer, FaceBean> faceInfo, Token token) {
        MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = new MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean>(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.addFeatureMulti((ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, personId, TypeTransformer.getInstance().to(faceInfo, ByteBuffer.class, FaceBean.class, ByteString.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addFeature(byte[] feature, String featureVersion, Integer personId, Map<ByteBuffer, FaceBean> faceInfo, Token token, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.addFeature(feature, featureVersion, personId, faceInfo, token), callback);
    }

    public ListenableFuture<ImageBean> addImage(byte[] imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token) {
        MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean> nativeCallback = new MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean>(new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

            public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
            }
        });
        nativeCallback.service.addImage((ByteString)TypeTransformer.getInstance().to((Object)imageData, byte[].class, ByteString.class), deviceId, (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addImage(byte[] imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token, FutureCallback<ImageBean> callback) {
        this.factory.addCallback(this.addImage(imageData, deviceId, faceBean, personId, token), callback);
    }

    public ListenableFuture<Void> addLog(net.gdface.facelog.db.LogBean logBean, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.addLog((LogBean)TypeTransformer.getInstance().to((Object)logBean, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLog(net.gdface.facelog.db.LogBean logBean, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLog(logBean, token), callback);
    }

    public ListenableFuture<Void> addLog(net.gdface.facelog.db.LogBean logBean, FaceBean faceBean, byte[] featureImage, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.addLogFull((LogBean)TypeTransformer.getInstance().to((Object)logBean, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)faceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (ByteString)TypeTransformer.getInstance().to((Object)featureImage, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLog(net.gdface.facelog.db.LogBean logBean, FaceBean faceBean, byte[] featureImage, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLog(logBean, faceBean, featureImage, token), callback);
    }

    public ListenableFuture<Void> addLogs(List<net.gdface.facelog.db.LogBean> logBeans, List<FaceBean> faceBeans, List<byte[]> featureImages, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.addLogsFull(TypeTransformer.getInstance().to(logBeans, net.gdface.facelog.db.LogBean.class, LogBean.class), TypeTransformer.getInstance().to(faceBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), TypeTransformer.getInstance().to(featureImages, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLogs(List<net.gdface.facelog.db.LogBean> logBeans, List<FaceBean> faceBeans, List<byte[]> featureImages, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLogs(logBeans, faceBeans, featureImages, token), callback);
    }

    public ListenableFuture<Void> addLogs(List<net.gdface.facelog.db.LogBean> beans, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.addLogs(TypeTransformer.getInstance().to(beans, net.gdface.facelog.db.LogBean.class, LogBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addLogs(List<net.gdface.facelog.db.LogBean> beans, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addLogs(beans, token), callback);
    }

    public ListenableFuture<Void> addPermit(int deviceGroupId, int personGroupId, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.addPermitById(deviceGroupId, personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addPermit(int deviceGroupId, int personGroupId, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addPermit(deviceGroupId, personGroupId, token), callback);
    }

    public ListenableFuture<Void> addPermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.addPermit((net.gdface.facelog.client.thrift.DeviceGroupBean)TypeTransformer.getInstance().to((Object)deviceGroup, DeviceGroupBean.class, net.gdface.facelog.client.thrift.DeviceGroupBean.class), (net.gdface.facelog.client.thrift.PersonGroupBean)TypeTransformer.getInstance().to((Object)personGroup, PersonGroupBean.class, net.gdface.facelog.client.thrift.PersonGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void addPermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.addPermit(deviceGroup, personGroup, token), callback);
    }

    public ListenableFuture<String> applyAckChannel(Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.applyAckChannel((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void applyAckChannel(Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.applyAckChannel(token), callback);
    }

    public ListenableFuture<String> applyAckChannel(Token token, long duration) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.applyAckChannelWithDuration((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), duration, nativeCallback);
        return nativeCallback.feature;
    }

    public void applyAckChannel(Token token, long duration, FutureCallback<String> callback) {
        this.factory.addCallback(this.applyAckChannel(token, duration), callback);
    }

    public ListenableFuture<Long> applyCmdSn(Token token) {
        MethodCallback<Long, Long> nativeCallback = new MethodCallback<Long, Long>(new Function<Long, Long>(){

            public Long apply(Long input) {
                return input;
            }
        });
        nativeCallback.service.applyCmdSn((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void applyCmdSn(Token token, FutureCallback<Long> callback) {
        this.factory.addCallback(this.applyCmdSn(token), callback);
    }

    public ListenableFuture<Token> applyPersonToken(int personId, String password, boolean isMd5) {
        MethodCallback<Token, net.gdface.facelog.client.thrift.Token> nativeCallback = new MethodCallback<Token, net.gdface.facelog.client.thrift.Token>(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        nativeCallback.service.applyPersonToken(personId, password, isMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void applyPersonToken(int personId, String password, boolean isMd5, FutureCallback<Token> callback) {
        this.factory.addCallback(this.applyPersonToken(personId, password, isMd5), callback);
    }

    public ListenableFuture<Token> applyRootToken(String password, boolean isMd5) {
        MethodCallback<Token, net.gdface.facelog.client.thrift.Token> nativeCallback = new MethodCallback<Token, net.gdface.facelog.client.thrift.Token>(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        nativeCallback.service.applyRootToken(password, isMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void applyRootToken(String password, boolean isMd5, FutureCallback<Token> callback) {
        this.factory.addCallback(this.applyRootToken(password, isMd5), callback);
    }

    public ListenableFuture<Token> applyUserToken(int userid, String password, boolean isMd5) {
        MethodCallback<Token, net.gdface.facelog.client.thrift.Token> nativeCallback = new MethodCallback<Token, net.gdface.facelog.client.thrift.Token>(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        nativeCallback.service.applyUserToken(userid, password, isMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void applyUserToken(int userid, String password, boolean isMd5, FutureCallback<Token> callback) {
        this.factory.addCallback(this.applyUserToken(userid, password, isMd5), callback);
    }

    public ListenableFuture<Void> bindBorder(Integer personGroupId, Integer deviceGroupId, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.bindBorder(personGroupId, deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void bindBorder(Integer personGroupId, Integer deviceGroupId, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.bindBorder(personGroupId, deviceGroupId, token), callback);
    }

    public ListenableFuture<List<Integer>> childListForDeviceGroup(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.childListForDeviceGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void childListForDeviceGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.childListForDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<Integer>> childListForPersonGroup(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.childListForPersonGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void childListForPersonGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.childListForPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<Integer> countDeviceByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countDeviceByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countDeviceByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countDeviceByWhere(where), callback);
    }

    public ListenableFuture<Integer> countDeviceGroupByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countDeviceGroupByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countDeviceGroupByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countDeviceGroupByWhere(where), callback);
    }

    public ListenableFuture<Integer> countLogByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogByWhere(where), callback);
    }

    public ListenableFuture<Integer> countLogLightByVerifyTime(String timestamp) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByVerifyTimeTimestr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByVerifyTime(String timestamp, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByVerifyTime(timestamp), callback);
    }

    public ListenableFuture<Integer> countLogLightByVerifyTime(long timestamp) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByVerifyTime(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByVerifyTime(long timestamp, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByVerifyTime(timestamp), callback);
    }

    public ListenableFuture<Integer> countLogLightByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countLogLightByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countLogLightByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countLogLightByWhere(where), callback);
    }

    public ListenableFuture<Integer> countPersonByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countPersonByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countPersonByWhere(where), callback);
    }

    public ListenableFuture<Integer> countPersonGroupByWhere(String where) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.countPersonGroupByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void countPersonGroupByWhere(String where, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.countPersonGroupByWhere(where), callback);
    }

    public ListenableFuture<Integer> deleteAllFeaturesByPersonId(int personId, boolean deleteImage, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteAllFeaturesByPersonId(personId, deleteImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteAllFeaturesByPersonId(int personId, boolean deleteImage, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteAllFeaturesByPersonId(personId, deleteImage, token), callback);
    }

    public ListenableFuture<Integer> deleteDeviceGroup(int deviceGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteDeviceGroup(deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteDeviceGroup(int deviceGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteDeviceGroup(deviceGroupId, token), callback);
    }

    public ListenableFuture<List<String>> deleteFeature(String featureMd5, boolean deleteImage, Token token) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class);
            }
        });
        nativeCallback.service.deleteFeature(featureMd5, deleteImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteFeature(String featureMd5, boolean deleteImage, Token token, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.deleteFeature(featureMd5, deleteImage, token), callback);
    }

    public ListenableFuture<Integer> deleteGroupPermitOnDeviceGroup(int deviceGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteGroupPermitOnDeviceGroup(deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteGroupPermitOnDeviceGroup(int deviceGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteGroupPermitOnDeviceGroup(deviceGroupId, token), callback);
    }

    public ListenableFuture<Integer> deleteImage(String imageMd5, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deleteImage(imageMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deleteImage(String imageMd5, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deleteImage(imageMd5, token), callback);
    }

    public ListenableFuture<Integer> deletePermit(int deviceGroupId, int personGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePermitById(deviceGroupId, personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePermit(int deviceGroupId, int personGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePermit(deviceGroupId, personGroupId, token), callback);
    }

    public ListenableFuture<Integer> deletePermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePermit((net.gdface.facelog.client.thrift.DeviceGroupBean)TypeTransformer.getInstance().to((Object)deviceGroup, DeviceGroupBean.class, net.gdface.facelog.client.thrift.DeviceGroupBean.class), (net.gdface.facelog.client.thrift.PersonGroupBean)TypeTransformer.getInstance().to((Object)personGroup, PersonGroupBean.class, net.gdface.facelog.client.thrift.PersonGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePermit(DeviceGroupBean deviceGroup, PersonGroupBean personGroup, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePermit(deviceGroup, personGroup, token), callback);
    }

    public ListenableFuture<Integer> deletePerson(int personId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePerson(personId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePerson(int personId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePerson(personId, token), callback);
    }

    public ListenableFuture<Integer> deletePersonByPapersNum(String papersNum, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonByPapersNum(papersNum, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonByPapersNum(String papersNum, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonByPapersNum(papersNum, token), callback);
    }

    public ListenableFuture<Integer> deletePersonGroup(int personGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonGroup(personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonGroup(int personGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonGroup(personGroupId, token), callback);
    }

    public ListenableFuture<Integer> deletePersonGroupPermit(int personGroupId, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonGroupPermit(personGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonGroupPermit(int personGroupId, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonGroupPermit(personGroupId, token), callback);
    }

    public ListenableFuture<Integer> deletePersons(List<Integer> personIdList, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersons(TypeTransformer.getInstance().to(personIdList, Integer.class, Integer.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersons(List<Integer> personIdList, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersons(personIdList, token), callback);
    }

    public ListenableFuture<Integer> deletePersonsByPapersNum(List<String> papersNumlist, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.deletePersonsByPapersNum(TypeTransformer.getInstance().to(papersNumlist, String.class, String.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void deletePersonsByPapersNum(List<String> papersNumlist, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.deletePersonsByPapersNum(papersNumlist, token), callback);
    }

    public ListenableFuture<Void> disablePerson(int personId, Integer moveToGroupId, boolean deletePhoto, boolean deleteFeature, boolean deleteLog, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.disablePerson(personId, moveToGroupId, deletePhoto, deleteFeature, deleteLog, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void disablePerson(int personId, Integer moveToGroupId, boolean deletePhoto, boolean deleteFeature, boolean deleteLog, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.disablePerson(personId, moveToGroupId, deletePhoto, deleteFeature, deleteLog, token), callback);
    }

    public ListenableFuture<Void> disablePerson(List<Integer> personIdList, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.disablePersonList(TypeTransformer.getInstance().to(personIdList, Integer.class, Integer.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void disablePerson(List<Integer> personIdList, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.disablePerson(personIdList, token), callback);
    }

    public ListenableFuture<Boolean> existsDevice(int id) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.existsDevice(id, nativeCallback);
        return nativeCallback.feature;
    }

    public void existsDevice(int id, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsDevice(id), callback);
    }

    public ListenableFuture<Boolean> existsFeature(String md5) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.existsFeature(md5, nativeCallback);
        return nativeCallback.feature;
    }

    public void existsFeature(String md5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsFeature(md5), callback);
    }

    public ListenableFuture<Boolean> existsImage(String md5) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.existsImage(md5, nativeCallback);
        return nativeCallback.feature;
    }

    public void existsImage(String md5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsImage(md5), callback);
    }

    public ListenableFuture<Boolean> existsPerson(int persionId) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.existsPerson(persionId, nativeCallback);
        return nativeCallback.feature;
    }

    public void existsPerson(int persionId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.existsPerson(persionId), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> getDevice(int deviceId) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.getDevice(deviceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDevice(int deviceId, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.getDevice(deviceId), callback);
    }

    public ListenableFuture<DeviceGroupBean> getDeviceGroup(int deviceGroupId) {
        MethodCallback<DeviceGroupBean, net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback = new MethodCallback<DeviceGroupBean, net.gdface.facelog.client.thrift.DeviceGroupBean>(new Function<net.gdface.facelog.client.thrift.DeviceGroupBean, DeviceGroupBean>(){

            public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                return (DeviceGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        nativeCallback.service.getDeviceGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroup(int deviceGroupId, FutureCallback<DeviceGroupBean> callback) {
        this.factory.addCallback(this.getDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<DeviceGroupBean>> getDeviceGroups(List<Integer> groupIdList) {
        MethodCallback<List<DeviceGroupBean>, List<net.gdface.facelog.client.thrift.DeviceGroupBean>> nativeCallback = new MethodCallback<List<DeviceGroupBean>, List<net.gdface.facelog.client.thrift.DeviceGroupBean>>(new Function<List<net.gdface.facelog.client.thrift.DeviceGroupBean>, List<DeviceGroupBean>>(){

            public List<DeviceGroupBean> apply(List<net.gdface.facelog.client.thrift.DeviceGroupBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        nativeCallback.service.getDeviceGroups(TypeTransformer.getInstance().to(groupIdList, Integer.class, Integer.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroups(List<Integer> groupIdList, FutureCallback<List<DeviceGroupBean>> callback) {
        this.factory.addCallback(this.getDeviceGroups(groupIdList), callback);
    }

    public ListenableFuture<List<Integer>> getDeviceGroupsBelongs(int deviceId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getDeviceGroupsBelongs(deviceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroupsBelongs(int deviceId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDeviceGroupsBelongs(deviceId), callback);
    }

    public ListenableFuture<List<Integer>> getDeviceGroupsPermit(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getDeviceGroupsPermit(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroupsPermit(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDeviceGroupsPermit(personGroupId), callback);
    }

    public ListenableFuture<List<Integer>> getDeviceGroupsPermittedBy(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getDeviceGroupsPermittedBy(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceGroupsPermittedBy(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDeviceGroupsPermittedBy(personGroupId), callback);
    }

    public ListenableFuture<Integer> getDeviceIdOfFeature(String featureMd5) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.getDeviceIdOfFeature(featureMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDeviceIdOfFeature(String featureMd5, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.getDeviceIdOfFeature(featureMd5), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.DeviceBean>> getDevices(List<Integer> idList) {
        MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>>(new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

            public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.getDevices(TypeTransformer.getInstance().to(idList, Integer.class, Integer.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getDevices(List<Integer> idList, FutureCallback<List<net.gdface.facelog.db.DeviceBean>> callback) {
        this.factory.addCallback(this.getDevices(idList), callback);
    }

    public ListenableFuture<List<Integer>> getDevicesOfGroup(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getDevicesOfGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getDevicesOfGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getDevicesOfGroup(deviceGroupId), callback);
    }

    public ListenableFuture<FaceBean> getFace(int faceId) {
        MethodCallback<FaceBean, net.gdface.facelog.client.thrift.FaceBean> nativeCallback = new MethodCallback<FaceBean, net.gdface.facelog.client.thrift.FaceBean>(new Function<net.gdface.facelog.client.thrift.FaceBean, FaceBean>(){

            public FaceBean apply(net.gdface.facelog.client.thrift.FaceBean input) {
                return (FaceBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FaceBean.class, FaceBean.class);
            }
        });
        nativeCallback.service.getFace(faceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFace(int faceId, FutureCallback<FaceBean> callback) {
        this.factory.addCallback(this.getFace(faceId), callback);
    }

    public ListenableFuture<FeatureBean> getFeature(String md5) {
        MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = new MethodCallback<FeatureBean, net.gdface.facelog.client.thrift.FeatureBean>(new Function<net.gdface.facelog.client.thrift.FeatureBean, FeatureBean>(){

            public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                return (FeatureBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.getFeature(md5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeature(String md5, FutureCallback<FeatureBean> callback) {
        this.factory.addCallback(this.getFeature(md5), callback);
    }

    public ListenableFuture<byte[]> getFeatureBytes(String md5) {
        MethodCallback<byte[], ByteString> nativeCallback = new MethodCallback<byte[], ByteString>(new Function<ByteString, byte[]>(){

            public byte[] apply(ByteString input) {
                return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
            }
        });
        nativeCallback.service.getFeatureBytes(md5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeatureBytes(String md5, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getFeatureBytes(md5), callback);
    }

    public ListenableFuture<List<FeatureBean>> getFeatures(List<String> md5) {
        MethodCallback<List<FeatureBean>, List<net.gdface.facelog.client.thrift.FeatureBean>> nativeCallback = new MethodCallback<List<FeatureBean>, List<net.gdface.facelog.client.thrift.FeatureBean>>(new Function<List<net.gdface.facelog.client.thrift.FeatureBean>, List<FeatureBean>>(){

            public List<FeatureBean> apply(List<net.gdface.facelog.client.thrift.FeatureBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.FeatureBean.class, FeatureBean.class);
            }
        });
        nativeCallback.service.getFeatures(TypeTransformer.getInstance().to(md5, String.class, String.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeatures(List<String> md5, FutureCallback<List<FeatureBean>> callback) {
        this.factory.addCallback(this.getFeatures(md5), callback);
    }

    public ListenableFuture<List<String>> getFeaturesByPersonId(int personId) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class);
            }
        });
        nativeCallback.service.getFeaturesByPersonId(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeaturesByPersonId(int personId, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeaturesByPersonId(personId), callback);
    }

    public ListenableFuture<List<String>> getFeaturesByPersonIdAndSdkVersion(int personId, String sdkVersion) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class);
            }
        });
        nativeCallback.service.getFeaturesByPersonIdAndSdkVersion(personId, sdkVersion, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeaturesByPersonIdAndSdkVersion(int personId, String sdkVersion, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeaturesByPersonIdAndSdkVersion(personId, sdkVersion), callback);
    }

    public ListenableFuture<List<String>> getFeaturesOfPerson(int personId) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class);
            }
        });
        nativeCallback.service.getFeaturesOfPerson(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getFeaturesOfPerson(int personId, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getFeaturesOfPerson(personId), callback);
    }

    public ListenableFuture<PermitBean> getGroupPermit(int deviceId, int personGroupId) {
        MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean> nativeCallback = new MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean>(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

            public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getGroupPermit(deviceId, personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getGroupPermit(int deviceId, int personGroupId, FutureCallback<PermitBean> callback) {
        this.factory.addCallback(this.getGroupPermit(deviceId, personGroupId), callback);
    }

    public ListenableFuture<PermitBean> getGroupPermitOnDeviceGroup(int deviceGroupId, int personGroupId) {
        MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean> nativeCallback = new MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean>(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

            public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getGroupPermitOnDeviceGroup(deviceGroupId, personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getGroupPermitOnDeviceGroup(int deviceGroupId, int personGroupId, FutureCallback<PermitBean> callback) {
        this.factory.addCallback(this.getGroupPermitOnDeviceGroup(deviceGroupId, personGroupId), callback);
    }

    public ListenableFuture<List<PermitBean>> getGroupPermits(int deviceId, List<Integer> personGroupIdList) {
        MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = new MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>>(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getGroupPermits(deviceId, TypeTransformer.getInstance().to(personGroupIdList, Integer.class, Integer.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getGroupPermits(int deviceId, List<Integer> personGroupIdList, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.getGroupPermits(deviceId, personGroupIdList), callback);
    }

    public ListenableFuture<ImageBean> getImage(String imageMD5) {
        MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean> nativeCallback = new MethodCallback<ImageBean, net.gdface.facelog.client.thrift.ImageBean>(new Function<net.gdface.facelog.client.thrift.ImageBean, ImageBean>(){

            public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                return (ImageBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.ImageBean.class, ImageBean.class);
            }
        });
        nativeCallback.service.getImage(imageMD5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getImage(String imageMD5, FutureCallback<ImageBean> callback) {
        this.factory.addCallback(this.getImage(imageMD5), callback);
    }

    public ListenableFuture<byte[]> getImageBytes(String imageMD5) {
        MethodCallback<byte[], ByteString> nativeCallback = new MethodCallback<byte[], ByteString>(new Function<ByteString, byte[]>(){

            public byte[] apply(ByteString input) {
                return (byte[])TypeTransformer.getInstance().to((Object)input, ByteString.class, byte[].class);
            }
        });
        nativeCallback.service.getImageBytes(imageMD5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getImageBytes(String imageMD5, FutureCallback<byte[]> callback) {
        this.factory.addCallback(this.getImageBytes(imageMD5), callback);
    }

    public ListenableFuture<List<String>> getImagesAssociatedByFeature(String featureMd5) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class);
            }
        });
        nativeCallback.service.getImagesAssociatedByFeature(featureMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void getImagesAssociatedByFeature(String featureMd5, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.getImagesAssociatedByFeature(featureMd5), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogBean>> getLogBeansByPersonId(int personId) {
        MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>>(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

            public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
            }
        });
        nativeCallback.service.getLogBeansByPersonId(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getLogBeansByPersonId(int personId, FutureCallback<List<net.gdface.facelog.db.LogBean>> callback) {
        this.factory.addCallback(this.getLogBeansByPersonId(personId), callback);
    }

    public ListenableFuture<PersonBean> getPerson(int personId) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPerson(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPerson(int personId, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPerson(personId), callback);
    }

    public ListenableFuture<PersonBean> getPersonByPapersNum(String papersNum) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersonByPapersNum(papersNum, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonByPapersNum(String papersNum, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.getPersonByPapersNum(papersNum), callback);
    }

    public ListenableFuture<PersonGroupBean> getPersonGroup(int personGroupId) {
        MethodCallback<PersonGroupBean, net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback = new MethodCallback<PersonGroupBean, net.gdface.facelog.client.thrift.PersonGroupBean>(new Function<net.gdface.facelog.client.thrift.PersonGroupBean, PersonGroupBean>(){

            public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                return (PersonGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        nativeCallback.service.getPersonGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonGroup(int personGroupId, FutureCallback<PersonGroupBean> callback) {
        this.factory.addCallback(this.getPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<List<PersonGroupBean>> getPersonGroups(List<Integer> groupIdList) {
        MethodCallback<List<PersonGroupBean>, List<net.gdface.facelog.client.thrift.PersonGroupBean>> nativeCallback = new MethodCallback<List<PersonGroupBean>, List<net.gdface.facelog.client.thrift.PersonGroupBean>>(new Function<List<net.gdface.facelog.client.thrift.PersonGroupBean>, List<PersonGroupBean>>(){

            public List<PersonGroupBean> apply(List<net.gdface.facelog.client.thrift.PersonGroupBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        nativeCallback.service.getPersonGroups(TypeTransformer.getInstance().to(groupIdList, Integer.class, Integer.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonGroups(List<Integer> groupIdList, FutureCallback<List<PersonGroupBean>> callback) {
        this.factory.addCallback(this.getPersonGroups(groupIdList), callback);
    }

    public ListenableFuture<List<Integer>> getPersonGroupsBelongs(int personId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getPersonGroupsBelongs(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonGroupsBelongs(int personId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonGroupsBelongs(personId), callback);
    }

    public ListenableFuture<List<Integer>> getPersonGroupsPermittedBy(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getPersonGroupsPermittedBy(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonGroupsPermittedBy(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonGroupsPermittedBy(deviceGroupId), callback);
    }

    public ListenableFuture<PermitBean> getPersonPermit(int deviceId, int personId) {
        MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean> nativeCallback = new MethodCallback<PermitBean, net.gdface.facelog.client.thrift.PermitBean>(new Function<net.gdface.facelog.client.thrift.PermitBean, PermitBean>(){

            public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                return (PermitBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getPersonPermit(deviceId, personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonPermit(int deviceId, int personId, FutureCallback<PermitBean> callback) {
        this.factory.addCallback(this.getPersonPermit(deviceId, personId), callback);
    }

    public ListenableFuture<List<PermitBean>> getPersonPermits(int deviceId, List<Integer> personIdList) {
        MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = new MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>>(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.getPersonPermits(deviceId, TypeTransformer.getInstance().to(personIdList, Integer.class, Integer.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonPermits(int deviceId, List<Integer> personIdList, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.getPersonPermits(deviceId, personIdList), callback);
    }

    public ListenableFuture<List<PersonBean>> getPersons(List<Integer> idList) {
        MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = new MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>>(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

            public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.getPersons(TypeTransformer.getInstance().to(idList, Integer.class, Integer.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersons(List<Integer> idList, FutureCallback<List<PersonBean>> callback) {
        this.factory.addCallback(this.getPersons(idList), callback);
    }

    public ListenableFuture<List<Integer>> getPersonsOfGroup(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getPersonsOfGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getPersonsOfGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getPersonsOfGroup(personGroupId), callback);
    }

    public ListenableFuture<String> getProperty(String key, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.getProperty(key, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getProperty(String key, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.getProperty(key, token), callback);
    }

    public ListenableFuture<Map<MQParam, String>> getRedisParameters(Token token) {
        MethodCallback<Map<MQParam, String>, Map<net.gdface.facelog.client.thrift.MQParam, String>> nativeCallback = new MethodCallback<Map<MQParam, String>, Map<net.gdface.facelog.client.thrift.MQParam, String>>(new Function<Map<net.gdface.facelog.client.thrift.MQParam, String>, Map<MQParam, String>>(){

            public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam, String> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.MQParam.class, String.class, MQParam.class, String.class);
            }
        });
        nativeCallback.service.getRedisParameters((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getRedisParameters(Token token, FutureCallback<Map<MQParam, String>> callback) {
        this.factory.addCallback(this.getRedisParameters(token), callback);
    }

    public ListenableFuture<Map<String, String>> getServiceConfig(Token token) {
        MethodCallback<Map<String, String>, Map<String, String>> nativeCallback = new MethodCallback<Map<String, String>, Map<String, String>>(new Function<Map<String, String>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
            }
        });
        nativeCallback.service.getServiceConfig((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void getServiceConfig(Token token, FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.getServiceConfig(token), callback);
    }

    public ListenableFuture<List<Integer>> getSubDeviceGroup(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getSubDeviceGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getSubDeviceGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getSubDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<Integer>> getSubPersonGroup(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.getSubPersonGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void getSubPersonGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.getSubPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<Boolean> isDisable(int personId) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isDisable(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void isDisable(int personId, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isDisable(personId), callback);
    }

    public boolean isLocal() {
        return false;
    }

    public ListenableFuture<Boolean> isValidAckChannel(String ackChannel) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidAckChannel(ackChannel, nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidAckChannel(String ackChannel, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidAckChannel(ackChannel), callback);
    }

    public ListenableFuture<Boolean> isValidCmdSn(long cmdSn) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidCmdSn(cmdSn, nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidCmdSn(long cmdSn, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidCmdSn(cmdSn), callback);
    }

    public ListenableFuture<Boolean> isValidDeviceToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidDeviceToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidDeviceToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidDeviceToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidPassword(String userId, String password, boolean isMd5) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidPassword(userId, password, isMd5, nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidPassword(String userId, String password, boolean isMd5, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidPassword(userId, password, isMd5), callback);
    }

    public ListenableFuture<Boolean> isValidPersonToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidPersonToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidPersonToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidPersonToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidRootToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidRootToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidRootToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidRootToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidToken(token), callback);
    }

    public ListenableFuture<Boolean> isValidUserToken(Token token) {
        MethodCallback<Boolean, Boolean> nativeCallback = new MethodCallback<Boolean, Boolean>(new Function<Boolean, Boolean>(){

            public Boolean apply(Boolean input) {
                return input;
            }
        });
        nativeCallback.service.isValidUserToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void isValidUserToken(Token token, FutureCallback<Boolean> callback) {
        this.factory.addCallback(this.isValidUserToken(token), callback);
    }

    public ListenableFuture<List<Integer>> listOfParentForDeviceGroup(int deviceGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.listOfParentForDeviceGroup(deviceGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void listOfParentForDeviceGroup(int deviceGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.listOfParentForDeviceGroup(deviceGroupId), callback);
    }

    public ListenableFuture<List<Integer>> listOfParentForPersonGroup(int personGroupId) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.listOfParentForPersonGroup(personGroupId, nativeCallback);
        return nativeCallback.feature;
    }

    public void listOfParentForPersonGroup(int personGroupId, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.listOfParentForPersonGroup(personGroupId), callback);
    }

    public ListenableFuture<List<Integer>> loadAllPerson() {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadAllPerson(nativeCallback);
        return nativeCallback.feature;
    }

    public void loadAllPerson(FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadAllPerson(), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.DeviceBean>> loadDeviceByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.DeviceBean>, List<DeviceBean>>(new Function<List<DeviceBean>, List<net.gdface.facelog.db.DeviceBean>>(){

            public List<net.gdface.facelog.db.DeviceBean> apply(List<DeviceBean> input) {
                return TypeTransformer.getInstance().to(input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.loadDeviceByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.DeviceBean>> callback) {
        this.factory.addCallback(this.loadDeviceByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceGroupByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadDeviceGroupByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceGroupByWhere(String where, int startRow, int numRows, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceGroupByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceGroupIdByWhere(String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadDeviceGroupIdByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceGroupIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceGroupIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadDeviceIdByWhere(String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadDeviceIdByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadDeviceIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadDeviceIdByWhere(where), callback);
    }

    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(String timestamp) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class);
            }
        });
        nativeCallback.service.loadFeatureMd5ByUpdateTimeStr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadFeatureMd5ByUpdate(String timestamp, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.loadFeatureMd5ByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(long timestamp) {
        MethodCallback<List<String>, List<String>> nativeCallback = new MethodCallback<List<String>, List<String>>(new Function<List<String>, List<String>>(){

            public List<String> apply(List<String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class);
            }
        });
        nativeCallback.service.loadFeatureMd5ByUpdate(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadFeatureMd5ByUpdate(long timestamp, FutureCallback<List<String>> callback) {
        this.factory.addCallback(this.loadFeatureMd5ByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogBean>> loadLogByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogBean>, List<LogBean>>(new Function<List<LogBean>, List<net.gdface.facelog.db.LogBean>>(){

            public List<net.gdface.facelog.db.LogBean> apply(List<LogBean> input) {
                return TypeTransformer.getInstance().to(input, LogBean.class, net.gdface.facelog.db.LogBean.class);
            }
        });
        nativeCallback.service.loadLogByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogBean>> callback) {
        this.factory.addCallback(this.loadLogByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByVerifyTime(String timestamp, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByVerifyTimeTimestr(timestamp, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByVerifyTime(String timestamp, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByVerifyTime(timestamp, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByVerifyTime(long timestamp, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByVerifyTime(timestamp, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByVerifyTime(long timestamp, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByVerifyTime(timestamp, startRow, numRows), callback);
    }

    public ListenableFuture<List<net.gdface.facelog.db.LogLightBean>> loadLogLightByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>> nativeCallback = new MethodCallback<List<net.gdface.facelog.db.LogLightBean>, List<LogLightBean>>(new Function<List<LogLightBean>, List<net.gdface.facelog.db.LogLightBean>>(){

            public List<net.gdface.facelog.db.LogLightBean> apply(List<LogLightBean> input) {
                return TypeTransformer.getInstance().to(input, LogLightBean.class, net.gdface.facelog.db.LogLightBean.class);
            }
        });
        nativeCallback.service.loadLogLightByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadLogLightByWhere(String where, int startRow, int numRows, FutureCallback<List<net.gdface.facelog.db.LogLightBean>> callback) {
        this.factory.addCallback(this.loadLogLightByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(String timestamp) {
        MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = new MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>>(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.loadPermitByUpdateTimestr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPermitByUpdate(String timestamp, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.loadPermitByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(long timestamp) {
        MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = new MethodCallback<List<PermitBean>, List<net.gdface.facelog.client.thrift.PermitBean>>(new Function<List<net.gdface.facelog.client.thrift.PermitBean>, List<PermitBean>>(){

            public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PermitBean.class, PermitBean.class);
            }
        });
        nativeCallback.service.loadPermitByUpdate(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPermitByUpdate(long timestamp, FutureCallback<List<PermitBean>> callback) {
        this.factory.addCallback(this.loadPermitByUpdate(timestamp), callback);
    }

    public ListenableFuture<List<PersonBean>> loadPersonByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = new MethodCallback<List<PersonBean>, List<net.gdface.facelog.client.thrift.PersonBean>>(new Function<List<net.gdface.facelog.client.thrift.PersonBean>, List<PersonBean>>(){

            public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                return TypeTransformer.getInstance().to(input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.loadPersonByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonByWhere(String where, int startRow, int numRows, FutureCallback<List<PersonBean>> callback) {
        this.factory.addCallback(this.loadPersonByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonGroupByWhere(String where, int startRow, int numRows) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadPersonGroupByWhere(where, startRow, numRows, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonGroupByWhere(String where, int startRow, int numRows, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonGroupByWhere(where, startRow, numRows), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonGroupIdByWhere(String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadPersonGroupIdByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonGroupIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonGroupIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(String timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadPersonIdByUpdateTimeTimeStr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByUpdateTime(String timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByUpdateTime(timestamp), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(long timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadPersonIdByUpdateTime(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByUpdateTime(long timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByUpdateTime(timestamp), callback);
    }

    public ListenableFuture<List<Integer>> loadPersonIdByWhere(String where) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadPersonIdByWhere(where, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadPersonIdByWhere(String where, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadPersonIdByWhere(where), callback);
    }

    public ListenableFuture<List<Integer>> loadUpdatedPersons(String timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadUpdatedPersonsTimestr(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadUpdatedPersons(String timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadUpdatedPersons(timestamp), callback);
    }

    public ListenableFuture<List<Integer>> loadUpdatedPersons(long timestamp) {
        MethodCallback<List<Integer>, List<Integer>> nativeCallback = new MethodCallback<List<Integer>, List<Integer>>(new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> input) {
                return TypeTransformer.getInstance().to(input, Integer.class, Integer.class);
            }
        });
        nativeCallback.service.loadUpdatedPersons(timestamp, nativeCallback);
        return nativeCallback.feature;
    }

    public void loadUpdatedPersons(long timestamp, FutureCallback<List<Integer>> callback) {
        this.factory.addCallback(this.loadUpdatedPersons(timestamp), callback);
    }

    public ListenableFuture<Void> offline(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.offline((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void offline(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.offline(token), callback);
    }

    public ListenableFuture<Token> online(net.gdface.facelog.db.DeviceBean device) {
        MethodCallback<Token, net.gdface.facelog.client.thrift.Token> nativeCallback = new MethodCallback<Token, net.gdface.facelog.client.thrift.Token>(new Function<net.gdface.facelog.client.thrift.Token, Token>(){

            public Token apply(net.gdface.facelog.client.thrift.Token input) {
                return (Token)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.Token.class, Token.class);
            }
        });
        nativeCallback.service.online((DeviceBean)TypeTransformer.getInstance().to((Object)device, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void online(net.gdface.facelog.db.DeviceBean device, FutureCallback<Token> callback) {
        this.factory.addCallback(this.online(device), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> registerDevice(net.gdface.facelog.db.DeviceBean newDevice) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.registerDevice((DeviceBean)TypeTransformer.getInstance().to((Object)newDevice, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void registerDevice(net.gdface.facelog.db.DeviceBean newDevice, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.registerDevice(newDevice), callback);
    }

    public ListenableFuture<Void> releasePersonToken(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.releasePersonToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void releasePersonToken(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.releasePersonToken(token), callback);
    }

    public ListenableFuture<Void> releaseRootToken(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.releaseRootToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void releaseRootToken(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.releaseRootToken(token), callback);
    }

    public ListenableFuture<Void> releaseUserToken(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.releaseUserToken((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void releaseUserToken(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.releaseUserToken(token), callback);
    }

    public ListenableFuture<Void> replaceFeature(Integer personId, String featureMd5, boolean deleteOldFeatureImage, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.replaceFeature(personId, featureMd5, deleteOldFeatureImage, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void replaceFeature(Integer personId, String featureMd5, boolean deleteOldFeatureImage, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.replaceFeature(personId, featureMd5, deleteOldFeatureImage, token), callback);
    }

    public ListenableFuture<Integer> rootGroupOfDevice(Integer deviceId) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.rootGroupOfDevice(deviceId, nativeCallback);
        return nativeCallback.feature;
    }

    public void rootGroupOfDevice(Integer deviceId, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.rootGroupOfDevice(deviceId), callback);
    }

    public ListenableFuture<Integer> rootGroupOfPerson(Integer personId) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.rootGroupOfPerson(personId, nativeCallback);
        return nativeCallback.feature;
    }

    public void rootGroupOfPerson(Integer personId, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.rootGroupOfPerson(personId), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> saveDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.saveDevice((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void saveDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.saveDevice(deviceBean, token), callback);
    }

    public ListenableFuture<DeviceGroupBean> saveDeviceGroup(DeviceGroupBean deviceGroupBean, Token token) {
        MethodCallback<DeviceGroupBean, net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback = new MethodCallback<DeviceGroupBean, net.gdface.facelog.client.thrift.DeviceGroupBean>(new Function<net.gdface.facelog.client.thrift.DeviceGroupBean, DeviceGroupBean>(){

            public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                return (DeviceGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.DeviceGroupBean.class, DeviceGroupBean.class);
            }
        });
        nativeCallback.service.saveDeviceGroup((net.gdface.facelog.client.thrift.DeviceGroupBean)TypeTransformer.getInstance().to((Object)deviceGroupBean, DeviceGroupBean.class, net.gdface.facelog.client.thrift.DeviceGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void saveDeviceGroup(DeviceGroupBean deviceGroupBean, Token token, FutureCallback<DeviceGroupBean> callback) {
        this.factory.addCallback(this.saveDeviceGroup(deviceGroupBean, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, byte[] featureImage, FaceBean featureFaceBean, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonFull((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, (ByteString)TypeTransformer.getInstance().to((Object)featureImage, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FaceBean)TypeTransformer.getInstance().to((Object)featureFaceBean, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, byte[] featureImage, FaceBean featureFaceBean, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, feature, featureVersion, featureImage, featureFaceBean, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, List<FaceBean> faceBeans, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndFeatureMultiFaces((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, TypeTransformer.getInstance().to(faceBeans, FaceBean.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, List<FaceBean> faceBeans, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, feature, featureVersion, faceBeans, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, Map<ByteBuffer, FaceBean> faceInfo, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndFeatureMultiImage((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (ByteString)TypeTransformer.getInstance().to((Object)feature, byte[].class, ByteString.class), featureVersion, TypeTransformer.getInstance().to(faceInfo, ByteBuffer.class, FaceBean.class, ByteString.class, net.gdface.facelog.client.thrift.FaceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, byte[] feature, String featureVersion, Map<ByteBuffer, FaceBean> faceInfo, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, feature, featureVersion, faceInfo, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhoto((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, byte[] idPhoto, FeatureBean featureBean, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndFeature((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (ByteString)TypeTransformer.getInstance().to((Object)idPhoto, byte[].class, ByteString.class), (net.gdface.facelog.client.thrift.FeatureBean)TypeTransformer.getInstance().to((Object)featureBean, FeatureBean.class, net.gdface.facelog.client.thrift.FeatureBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, byte[] idPhoto, FeatureBean featureBean, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhoto, featureBean, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, String idPhotoMd5, String featureMd5, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePersonWithPhotoAndFeatureSaved((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), idPhotoMd5, featureMd5, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, String idPhotoMd5, String featureMd5, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, idPhotoMd5, featureMd5, token), callback);
    }

    public ListenableFuture<PersonBean> savePerson(PersonBean personBean, Token token) {
        MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean> nativeCallback = new MethodCallback<PersonBean, net.gdface.facelog.client.thrift.PersonBean>(new Function<net.gdface.facelog.client.thrift.PersonBean, PersonBean>(){

            public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                return (PersonBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonBean.class, PersonBean.class);
            }
        });
        nativeCallback.service.savePerson((net.gdface.facelog.client.thrift.PersonBean)TypeTransformer.getInstance().to((Object)personBean, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePerson(PersonBean personBean, Token token, FutureCallback<PersonBean> callback) {
        this.factory.addCallback(this.savePerson(personBean, token), callback);
    }

    public ListenableFuture<PersonGroupBean> savePersonGroup(PersonGroupBean personGroupBean, Token token) {
        MethodCallback<PersonGroupBean, net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback = new MethodCallback<PersonGroupBean, net.gdface.facelog.client.thrift.PersonGroupBean>(new Function<net.gdface.facelog.client.thrift.PersonGroupBean, PersonGroupBean>(){

            public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                return (PersonGroupBean)TypeTransformer.getInstance().to((Object)input, net.gdface.facelog.client.thrift.PersonGroupBean.class, PersonGroupBean.class);
            }
        });
        nativeCallback.service.savePersonGroup((net.gdface.facelog.client.thrift.PersonGroupBean)TypeTransformer.getInstance().to((Object)personGroupBean, PersonGroupBean.class, net.gdface.facelog.client.thrift.PersonGroupBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePersonGroup(PersonGroupBean personGroupBean, Token token, FutureCallback<PersonGroupBean> callback) {
        this.factory.addCallback(this.savePersonGroup(personGroupBean, token), callback);
    }

    public ListenableFuture<Void> savePersons(List<PersonBean> persons, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.savePersons(TypeTransformer.getInstance().to(persons, PersonBean.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePersons(List<PersonBean> persons, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.savePersons(persons, token), callback);
    }

    public ListenableFuture<Integer> savePersons(Map<ByteBuffer, PersonBean> persons, Token token) {
        MethodCallback<Integer, Integer> nativeCallback = new MethodCallback<Integer, Integer>(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input;
            }
        });
        nativeCallback.service.savePersonsWithPhoto(TypeTransformer.getInstance().to(persons, ByteBuffer.class, PersonBean.class, ByteString.class, net.gdface.facelog.client.thrift.PersonBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void savePersons(Map<ByteBuffer, PersonBean> persons, Token token, FutureCallback<Integer> callback) {
        this.factory.addCallback(this.savePersons(persons, token), callback);
    }

    public ListenableFuture<Void> saveServiceConfig(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.saveServiceConfig((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void saveServiceConfig(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.saveServiceConfig(token), callback);
    }

    public ListenableFuture<Void> setPersonExpiryDate(int personId, String expiryDate, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.setPersonExpiryDateTimeStr(personId, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setPersonExpiryDate(int personId, String expiryDate, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setPersonExpiryDate(personId, expiryDate, token), callback);
    }

    public ListenableFuture<Void> setPersonExpiryDate(int personId, long expiryDate, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.setPersonExpiryDate(personId, expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setPersonExpiryDate(int personId, long expiryDate, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setPersonExpiryDate(personId, expiryDate, token), callback);
    }

    public ListenableFuture<Void> setPersonExpiryDate(List<Integer> personIdList, long expiryDate, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.setPersonExpiryDateList(TypeTransformer.getInstance().to(personIdList, Integer.class, Integer.class), expiryDate, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setPersonExpiryDate(List<Integer> personIdList, long expiryDate, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setPersonExpiryDate(personIdList, expiryDate, token), callback);
    }

    public ListenableFuture<Void> setProperties(Map<String, String> config, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.setProperties(TypeTransformer.getInstance().to(config, String.class, String.class, String.class, String.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setProperties(Map<String, String> config, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setProperties(config, token), callback);
    }

    public ListenableFuture<Void> setProperty(String key, String value, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.setProperty(key, value, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void setProperty(String key, String value, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.setProperty(key, value, token), callback);
    }

    public ListenableFuture<String> taskQueueOf(String task, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.taskQueueOf(task, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void taskQueueOf(String task, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.taskQueueOf(task, token), callback);
    }

    public ListenableFuture<String> taskRegister(String task, Token token) {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.taskRegister(task, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void taskRegister(String task, Token token, FutureCallback<String> callback) {
        this.factory.addCallback(this.taskRegister(task, token), callback);
    }

    public ListenableFuture<Void> unbindBorder(Integer personGroupId, Integer deviceGroupId, Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.unbindBorder(personGroupId, deviceGroupId, (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void unbindBorder(Integer personGroupId, Integer deviceGroupId, Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.unbindBorder(personGroupId, deviceGroupId, token), callback);
    }

    public ListenableFuture<Void> unregisterDevice(Token token) {
        MethodCallback<Void, Void> nativeCallback = new MethodCallback<Void, Void>(new Function<Void, Void>(){

            public Void apply(Void input) {
                return (Void)TypeTransformer.getInstance().to((Object)input, Void.class, Void.class);
            }
        });
        nativeCallback.service.unregisterDevice((net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void unregisterDevice(Token token, FutureCallback<Void> callback) {
        this.factory.addCallback(this.unregisterDevice(token), callback);
    }

    public ListenableFuture<net.gdface.facelog.db.DeviceBean> updateDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token) {
        MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean> nativeCallback = new MethodCallback<net.gdface.facelog.db.DeviceBean, DeviceBean>(new Function<DeviceBean, net.gdface.facelog.db.DeviceBean>(){

            public net.gdface.facelog.db.DeviceBean apply(DeviceBean input) {
                return (net.gdface.facelog.db.DeviceBean)TypeTransformer.getInstance().to((Object)input, DeviceBean.class, net.gdface.facelog.db.DeviceBean.class);
            }
        });
        nativeCallback.service.updateDevice((DeviceBean)TypeTransformer.getInstance().to((Object)deviceBean, net.gdface.facelog.db.DeviceBean.class, DeviceBean.class), (net.gdface.facelog.client.thrift.Token)TypeTransformer.getInstance().to((Object)token, Token.class, net.gdface.facelog.client.thrift.Token.class), nativeCallback);
        return nativeCallback.feature;
    }

    public void updateDevice(net.gdface.facelog.db.DeviceBean deviceBean, Token token, FutureCallback<net.gdface.facelog.db.DeviceBean> callback) {
        this.factory.addCallback(this.updateDevice(deviceBean, token), callback);
    }

    public ListenableFuture<String> version() {
        MethodCallback<String, String> nativeCallback = new MethodCallback<String, String>(new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        nativeCallback.service.version(nativeCallback);
        return nativeCallback.feature;
    }

    public void version(FutureCallback<String> callback) {
        this.factory.addCallback(this.version(), callback);
    }

    public ListenableFuture<Map<String, String>> versionInfo() {
        MethodCallback<Map<String, String>, Map<String, String>> nativeCallback = new MethodCallback<Map<String, String>, Map<String, String>>(new Function<Map<String, String>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, String> input) {
                return TypeTransformer.getInstance().to(input, String.class, String.class, String.class, String.class);
            }
        });
        nativeCallback.service.versionInfo(nativeCallback);
        return nativeCallback.feature;
    }

    public void versionInfo(FutureCallback<Map<String, String>> callback) {
        this.factory.addCallback(this.versionInfo(), callback);
    }

    static /* synthetic */ ClientFactory access$000(IFaceLogThriftClientAsync x0) {
        return x0.factory;
    }

    public static class DefaultCallback<V>
    implements FutureCallback<V> {
        public void onSuccess(V result) {
        }

        public void onFailure(Throwable t) {
            try {
                throw t;
            }
            catch (DuplicateRecordException e) {
                this.onDuplicateRecordException(e);
            }
            catch (ServiceSecurityException e) {
                this.onServiceSecurityException(e);
            }
            catch (ServiceRuntimeException e) {
                this.onServiceRuntimeException(e);
            }
            catch (Throwable e) {
                this.onThrowable(e);
            }
        }

        protected void onDuplicateRecordException(DuplicateRecordException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onServiceSecurityException(ServiceSecurityException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onServiceRuntimeException(ServiceRuntimeException e) {
            System.out.println(e.serviceStackTraceMessage);
        }

        protected void onThrowable(Throwable e) {
            e.printStackTrace();
        }
    }

    private class MethodCallback<L, R>
    implements ServiceMethodCallback<R> {
        private final AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){

            public void onTransportClosed() {
            }

            public void onError(Throwable error) {
                MethodCallback.this.onError(error);
            }
        };
        final IFaceLogClient service = (IFaceLogClient)IFaceLogThriftClientAsync.access$000(IFaceLogThriftClientAsync.this).applyInstance(IFaceLogClient.class, this.closeListener);
        final SettableFuture<L> feature = SettableFuture.create();
        final Function<R, L> transformer;

        MethodCallback(Function<R, L> transformer) {
            this.transformer = transformer;
        }

        public void onSuccess(R result) {
            this.feature.set(this.transformer.apply(result));
            try {
                this.service.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onError(Throwable error) {
            if (error instanceof ThriftException && ((ThriftException)error).kind == ThriftException.Kind.MISSING_RESULT) {
                this.onSuccess(null);
            }
            this.feature.setException(error);
            try {
                this.service.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

