// ______________________________________________________
// Generated by codegen - https://gitee.com/l0km/codegen 
// template: thrift/client_thrifty/perservice/client.service.decorator.class.vm
// ______________________________________________________
package net.gdface.facelog.thrift;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.DuplicateRecordException;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.ServiceSecurityException;
import net.gdface.facelog.TmpPwdTargetType;
import net.gdface.facelog.TmpwdTargetInfo;
import net.gdface.facelog.Token;
import net.gdface.facelog.db.DeviceBean;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.ErrorLogBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.LogBean;
import net.gdface.facelog.db.LogLightBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.thrift.TypeTransformer;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import net.gdface.thrift.ClientFactory;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;

import static com.google.common.base.Preconditions.*;
import static net.gdface.thrift.ThriftUtils.returnNull;
/**
 * 基于thrift/swift框架生成的client端代码提供{@link IFaceLog}接口的RPC实现(线程安全)<br>
 * 转发所有{@link IFaceLog}接口方法到{@link net.gdface.facelog.client.thrift.IFaceLogClient}实例<br>
 * 所有服务端抛出的{@link RuntimeException}异常被封装到{@link ServiceRuntimeException}中抛出<br>
 * Example:<br>
 * <pre>
 *        IFaceLogThriftClient thriftInstance = ClientFactory
 *            .builder()
 *            .setHostAndPort("127.0.0.1",26413)
 *            .build(IFaceLogThriftClient.class);
 * </pre>
 * 计算机生成代码(generated by automated tools ThriftServiceDecoratorGenerator @author guyadong)<br>
 * @author guyadong
 *
 */
public class IFaceLogThriftClient implements IFaceLog {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return factory;
    }
    public IFaceLogThriftClient(ClientFactory factory) {
        super();
        this.factory = checkNotNull(factory,"factory is null");
    }
    /**
     * @param host RPC service host
     * @param port RPC service port 
     */
    public IFaceLogThriftClient(String host,int port) {
        this(ClientFactory.builder().setHostAndPort(host,port));
    }
    /**
     * @param hostAndPort RPC service host and port 
     */
    public IFaceLogThriftClient(HostAndPort hostAndPort) {
        this(ClientFactory.builder().setHostAndPort(hostAndPort));
    }
    /**
     * test if connectable for RPC service
     * @return return {@code true} if connectable ,otherwise {@code false}
     */
    public boolean testConnect(){
        return factory.testConnect();
    }
    /**
     * 服务异步调用接口
     *
     * @param <T>
     */
    private interface ServiceAsyncCall<T> {
        public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<T> callback);
    }
    /**
     * 异常调用转同步调用实现
     * @param transformer
     * @param serviceCall
     * @return
     * @throws Throwable
     */
    private <R,L>R syncCall(final Function<L, R> transformer,final ServiceAsyncCall<L> serviceCall) throws Throwable{
        final AtomicReference<R> res = new AtomicReference<R>(null);
        final AtomicReference<Throwable> err = new AtomicReference<Throwable>(null);
        /* 异步调用结束标志信号量 */
        final Object lock = new Object();
        final ServiceMethodCallback<L> callback = new ServiceMethodCallback<L>() {

            @Override
            public void onSuccess(L result) {
                res.set(transformer.apply(result));
                /* 异步调用结束,唤醒等待线程 */
                synchronized(lock){
                    lock.notifyAll();
                }
            }

            @Override
            public void onError(Throwable error) {
                err.set(error);
                /* 异步调用结束,唤醒等待线程 */
                synchronized(lock){
                    lock.notifyAll();
                }
            }
        };
        /* 连接关闭侦听器当检测到异常时调用callback来处理 */
        AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){
                @Override
                public void onTransportClosed() {
                }
        
                @Override
                public void onError(Throwable error) {
                    callback.onError(error);
                }};
        net.gdface.facelog.client.thrift.IFaceLogClient service = factory.applyInstance(net.gdface.facelog.client.thrift.IFaceLogClient.class,closeListener);

        synchronized(lock){
            try {
                serviceCall.call(service,callback);
                /* 等待异步调用结束 */
                lock.wait();
            } catch (InterruptedException e) {
                err.set(e);
            } finally{
                try {
                    /* 调用结束关闭连接 */
                    service.close();
                } catch (IOException e) {}
            }
        }
        Throwable e = err.get(); 
        if(null != e){
            /** 判断异常类型返回null */
            returnNull(e);
        }
        return res.get();
    }    
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClient [factory=");
        builder.append(factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }
    @Override
    public void addErrorLog(final ErrorLogBean errorLogBean,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.addErrorLog(TypeTransformer.getInstance().to(
                    errorLogBean,
                    ErrorLogBean.class,
                    net.gdface.facelog.client.thrift.ErrorLogBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public FeatureBean addFeature(final byte[] feature,
        final String featureVersion,
        final Integer personId,
        final boolean asIdPhotoIfAbsent,
        final byte[] featurePhoto,
        final FaceBean faceBean,
        final String removed,
        final Token token) 
        throws DuplicateRecordException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                @Override
                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.FeatureBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.FeatureBean> nativeCallback){
                    service.addFeatureWithImage(TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),featureVersion,personId,asIdPhotoIfAbsent,TypeTransformer.getInstance().to(
                    featurePhoto,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),removed,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public FeatureBean addFeature(final byte[] feature,
        final String featureVersion,
        final Integer personId,
        final List<FaceBean> faecBeans,
        final String removed,
        final Token token) 
        throws DuplicateRecordException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                @Override
                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.FeatureBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.FeatureBean> nativeCallback){
                    service.addFeature(TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),featureVersion,personId,TypeTransformer.getInstance().to(
                    faecBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),removed,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public FeatureBean addFeature(final byte[] feature,
        final String featureVersion,
        final Integer personId,
        final List<byte[]> photos,
        final List<FaceBean> faces,
        final String removed,
        final Token token) 
        throws DuplicateRecordException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                @Override
                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.FeatureBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.FeatureBean> nativeCallback){
                    service.addFeatureMulti(TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),featureVersion,personId,TypeTransformer.getInstance().to(
                    photos,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    faces,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),removed,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public ImageBean addImage(final byte[] imageData,
        final Integer deviceId,
        final FaceBean faceBean,
        final Integer personId,
        final Token token) 
        throws DuplicateRecordException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>() {
                @Override
                public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.ImageBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.ImageBean> nativeCallback){
                    service.addImage(TypeTransformer.getInstance().to(
                    imageData,
                    byte[].class,
                    okio.ByteString.class),deviceId,TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),personId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void addLog(final LogBean logBean,
        final byte[] faceImage,
        final Token token) 
        throws DuplicateRecordException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.addLogWithFaceImage(TypeTransformer.getInstance().to(
                    logBean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),TypeTransformer.getInstance().to(
                    faceImage,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void addLog(final LogBean logBean,
        final Token token) 
        throws DuplicateRecordException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.addLog(TypeTransformer.getInstance().to(
                    logBean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void addLog(final LogBean logBean,
        final FaceBean faceBean,
        final byte[] featureImage,
        final Token token) 
        throws DuplicateRecordException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.addLogFull(TypeTransformer.getInstance().to(
                    logBean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),TypeTransformer.getInstance().to(
                    featureImage,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void addLogs(final List<LogBean> logBeans,
        final List<FaceBean> faceBeans,
        final List<byte[]> featureImages,
        final Token token) 
        throws DuplicateRecordException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.addLogsFull(TypeTransformer.getInstance().to(
                    logBeans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),TypeTransformer.getInstance().to(
                    faceBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),TypeTransformer.getInstance().to(
                    featureImages,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void addLogs(final List<LogBean> logBeans,
        final List<byte[]> faceImages,
        final Token token) 
        throws DuplicateRecordException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.addLogsWithFaceImage(TypeTransformer.getInstance().to(
                    logBeans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),TypeTransformer.getInstance().to(
                    faceImages,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void addLogs(final List<LogBean> beans,
        final Token token) 
        throws DuplicateRecordException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.addLogs(TypeTransformer.getInstance().to(
                    beans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.DuplicateRecordException.class,
                    DuplicateRecordException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String applyAckChannel(final int duration,
        final Token token) 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.applyAckChannelWithDuration(duration,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String applyAckChannel(final Token token) 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.applyAckChannel(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int applyCmdSn(final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.applyCmdSn(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Token applyPersonToken(final int personId,
        final String password,
        final boolean isMd5) 
        throws ServiceSecurityException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                @Override
                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.Token>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.Token> nativeCallback){
                    service.applyPersonToken(personId,password,isMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Token applyRootToken(final String password,
        final boolean isMd5) 
        throws ServiceSecurityException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                @Override
                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.Token>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.Token> nativeCallback){
                    service.applyRootToken(password,isMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Token applyUserToken(final int userid,
        final String password,
        final boolean isMd5) 
        throws ServiceSecurityException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                @Override
                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.Token>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.Token> nativeCallback){
                    service.applyUserToken(userid,password,isMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void bindBorder(final Integer personGroupId,
        final Integer deviceGroupId,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.bindBorder(personGroupId,deviceGroupId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> childListForDeviceGroup(final int deviceGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.childListForDeviceGroup(deviceGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> childListForPersonGroup(final int personGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.childListForPersonGroup(personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countDeviceByWhere(final String where) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countDeviceByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countDeviceGroupByWhere(final String where) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countDeviceGroupByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countErrorLogByWhere(final String where) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countErrorLogByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countLogByWhere(final String where) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countLogByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countLogLightByVerifyTime(final String timestamp) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countLogLightByVerifyTimeTimestr(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countLogLightByVerifyTime(final long timestamp) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countLogLightByVerifyTime(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countLogLightByWhere(final String where) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countLogLightByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countPersonByWhere(final String where) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countPersonByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int countPersonGroupByWhere(final String where) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.countPersonGroupByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Map<String, Integer> countPersonLog(final int personId,
        final Long startDate,
        final Long endDate) 
        {
        try{
            return syncCall(new Function<Map<String,Integer>,Map<String, Integer>>() {
                @Override
                public Map<String, Integer> apply(Map<String,Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    Integer.class,
                    String.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<Map<String,Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Map<String,Integer>> nativeCallback){
                    service.countPersonLog(personId,startDate,endDate,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Map<String, Integer> countPersonLog(final int personId,
        final String startDate,
        final String endDate) 
        {
        try{
            return syncCall(new Function<Map<String,Integer>,Map<String, Integer>>() {
                @Override
                public Map<String, Integer> apply(Map<String,Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    Integer.class,
                    String.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<Map<String,Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Map<String,Integer>> nativeCallback){
                    service.countPersonLogTimeStr(personId,startDate,endDate,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String createTempPwd(final int targetId,
        final TmpPwdTargetType targetType,
        final int duration,
        final Token token) 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.createTempPwdWithDuration(targetId,TypeTransformer.getInstance().to(
                    targetType,
                    TmpPwdTargetType.class,
                    net.gdface.facelog.client.thrift.TmpPwdTargetType.class),duration,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String createTempPwd(final int targetId,
        final TmpPwdTargetType targetType,
        final String expiryDate,
        final Token token) 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.createTempPwd(targetId,TypeTransformer.getInstance().to(
                    targetType,
                    TmpPwdTargetType.class,
                    net.gdface.facelog.client.thrift.TmpPwdTargetType.class),expiryDate,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deleteAllFeaturesByPersonId(final int personId,
        final boolean deleteImage,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deleteAllFeaturesByPersonId(personId,deleteImage,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean deleteDevice(final int id,
        final Token token) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.deleteDevice(id,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean deleteDeviceByMac(final String mac,
        final Token token) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.deleteDeviceByMac(mac,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deleteDeviceGroup(final int deviceGroupId,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deleteDeviceGroup(deviceGroupId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deleteErrorLogByWhere(final String where,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deleteErrorLogByWhere(where,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> deleteFeature(final String featureMd5,
        final boolean deleteImage,
        final Token token) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.deleteFeature(featureMd5,deleteImage,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deleteGroupPermitOnDeviceGroup(final int deviceGroupId,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deleteGroupPermitOnDeviceGroup(deviceGroupId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deleteImage(final String imageMd5,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deleteImage(imageMd5,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deleteLogByWhere(final String where,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deleteLogByWhere(where,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deletePermit(final int deviceGroupId,
        final int personGroupId,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deletePermitById(deviceGroupId,personGroupId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deletePerson(final int personId,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deletePerson(personId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deletePersonByPapersNum(final String papersNum,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deletePersonByPapersNum(papersNum,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deletePersonGroup(final int personGroupId,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deletePersonGroup(personGroupId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deletePersonGroupPermit(final int personGroupId,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deletePersonGroupPermit(personGroupId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deletePersons(final List<Integer> personIdList,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deletePersons(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int deletePersonsByPapersNum(final List<String> papersNumlist,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.deletePersonsByPapersNum(TypeTransformer.getInstance().to(
                    papersNumlist,
                    String.class,
                    String.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void disablePerson(final int personId,
        final Integer moveToGroupId,
        final boolean deletePhoto,
        final boolean deleteFeature,
        final boolean deleteLog,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.disablePerson(personId,moveToGroupId,deletePhoto,deleteFeature,deleteLog,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void disablePerson(final List<Integer> personIdList,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.disablePersonList(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean existsDevice(final int id) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.existsDevice(id,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean existsFeature(final String md5) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.existsFeature(md5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean existsImage(final String md5) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.existsImage(md5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean existsPerson(final int persionId) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.existsPerson(persionId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public DeviceBean getDevice(final int deviceId) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceBean> nativeCallback){
                    service.getDevice(deviceId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public DeviceBean getDeviceByMac(final String mac) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceBean> nativeCallback){
                    service.getDeviceByMac(mac,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public DeviceGroupBean getDeviceGroup(final int deviceGroupId) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.DeviceGroupBean,DeviceGroupBean>() {
                @Override
                public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceGroupBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback){
                    service.getDeviceGroup(deviceGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<DeviceGroupBean> getDeviceGroups(final List<Integer> groupIdList) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.DeviceGroupBean>,List<DeviceGroupBean>>() {
                @Override
                public List<DeviceGroupBean> apply(List<net.gdface.facelog.client.thrift.DeviceGroupBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.DeviceGroupBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.DeviceGroupBean>> nativeCallback){
                    service.getDeviceGroups(TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getDeviceGroupsBelongs(final int deviceId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getDeviceGroupsBelongs(deviceId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getDeviceGroupsPermit(final int personGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getDeviceGroupsPermit(personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getDeviceGroupsPermittedBy(final int personGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getDeviceGroupsPermittedBy(personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Integer getDeviceIdOfFeature(final String featureMd5) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.getDeviceIdOfFeature(featureMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<DeviceBean> getDevices(final List<Integer> idList) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.DeviceBean>,List<DeviceBean>>() {
                @Override
                public List<DeviceBean> apply(List<net.gdface.facelog.client.thrift.DeviceBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.DeviceBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.DeviceBean>> nativeCallback){
                    service.getDevices(TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getDevicesOfGroup(final int deviceGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getDevicesOfGroup(deviceGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public FaceBean getFace(final int faceId) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.FaceBean,FaceBean>() {
                @Override
                public FaceBean apply(net.gdface.facelog.client.thrift.FaceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FaceBean.class,
                    FaceBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.FaceBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.FaceBean> nativeCallback){
                    service.getFace(faceId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Map<String, String> getFaceApiParameters(final Token token) 
        {
        try{
            return syncCall(new Function<Map<String,String>,Map<String, String>>() {
                @Override
                public Map<String, String> apply(Map<String,String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<Map<String,String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Map<String,String>> nativeCallback){
                    service.getFaceApiParameters(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<FaceBean> getFacesOfFeature(final String featureMd5) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.FaceBean>,List<FaceBean>>() {
                @Override
                public List<FaceBean> apply(List<net.gdface.facelog.client.thrift.FaceBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FaceBean.class,
                    FaceBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.FaceBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.FaceBean>> nativeCallback){
                    service.getFacesOfFeature(featureMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<FaceBean> getFacesOfImage(final String imageMd5) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.FaceBean>,List<FaceBean>>() {
                @Override
                public List<FaceBean> apply(List<net.gdface.facelog.client.thrift.FaceBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FaceBean.class,
                    FaceBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.FaceBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.FaceBean>> nativeCallback){
                    service.getFacesOfImage(imageMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public FeatureBean getFeature(final String md5) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                @Override
                public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.FeatureBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.FeatureBean> nativeCallback){
                    service.getFeature(md5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public byte[] getFeatureBytes(final String md5) 
        {
        try{
            return syncCall(new Function<okio.ByteString,byte[]>() {
                @Override
                public byte[] apply(okio.ByteString input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }},
                new ServiceAsyncCall<okio.ByteString>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<okio.ByteString> nativeCallback){
                    service.getFeatureBytes(md5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public byte[] getFeatureBytes(final String md5,
        final boolean truncation) 
        {
        try{
            return syncCall(new Function<okio.ByteString,byte[]>() {
                @Override
                public byte[] apply(okio.ByteString input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }},
                new ServiceAsyncCall<okio.ByteString>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<okio.ByteString> nativeCallback){
                    service.getFeatureBytesTruncation(md5,truncation,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<FeatureBean> getFeatures(final List<String> md5List) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.FeatureBean>,List<FeatureBean>>() {
                @Override
                public List<FeatureBean> apply(List<net.gdface.facelog.client.thrift.FeatureBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.FeatureBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.FeatureBean>> nativeCallback){
                    service.getFeatures(TypeTransformer.getInstance().to(
                    md5List,
                    String.class,
                    String.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> getFeaturesByPersonIdAndSdkVersion(final int personId,
        final String sdkVersion) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.getFeaturesByPersonIdAndSdkVersion(personId,sdkVersion,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> getFeaturesOfImage(final String imageMd5) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.getFeaturesOfImage(imageMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> getFeaturesOfPerson(final int personId) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.getFeaturesOfPerson(personId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> getFeaturesPermittedOnDevice(final int deviceId,
        final boolean ignoreSchedule,
        final String sdkVersion,
        final List<String> excludeFeatureIds,
        final Long timestamp) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.getFeaturesPermittedOnDevice(deviceId,ignoreSchedule,sdkVersion,TypeTransformer.getInstance().to(
                    excludeFeatureIds,
                    String.class,
                    String.class),timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PermitBean getGroupPermit(final int deviceId,
        final int personGroupId) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                @Override
                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback){
                    service.getGroupPermit(deviceId,personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PermitBean getGroupPermitOnDeviceGroup(final int deviceGroupId,
        final int personGroupId) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                @Override
                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback){
                    service.getGroupPermitOnDeviceGroup(deviceGroupId,personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PermitBean> getGroupPermits(final int deviceId,
        final List<Integer> personGroupIdList) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                @Override
                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PermitBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback){
                    service.getGroupPermits(deviceId,TypeTransformer.getInstance().to(
                    personGroupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public ImageBean getImage(final String imageMD5) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>() {
                @Override
                public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.ImageBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.ImageBean> nativeCallback){
                    service.getImage(imageMD5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public ImageBean getImage(final String primaryKey,
        final String refType) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>() {
                @Override
                public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.ImageBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.ImageBean> nativeCallback){
                    service.getImageRef(primaryKey,refType,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public byte[] getImageBytes(final String imageMD5) 
        {
        try{
            return syncCall(new Function<okio.ByteString,byte[]>() {
                @Override
                public byte[] apply(okio.ByteString input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }},
                new ServiceAsyncCall<okio.ByteString>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<okio.ByteString> nativeCallback){
                    service.getImageBytes(imageMD5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public byte[] getImageBytes(final String primaryKey,
        final String refType) 
        {
        try{
            return syncCall(new Function<okio.ByteString,byte[]>() {
                @Override
                public byte[] apply(okio.ByteString input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }},
                new ServiceAsyncCall<okio.ByteString>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<okio.ByteString> nativeCallback){
                    service.getImageBytesRef(primaryKey,refType,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> getImagesAssociatedByFeature(final String featureMd5) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.getImagesAssociatedByFeature(featureMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<LogBean> getLogBeansByPersonId(final int personId) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.LogBean>,List<LogBean>>() {
                @Override
                public List<LogBean> apply(List<net.gdface.facelog.client.thrift.LogBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.LogBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.LogBean>> nativeCallback){
                    service.getLogBeansByPersonId(personId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean getPerson(final int personId) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.getPerson(personId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean getPerson(final int personId,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.getPersonReal(personId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean getPersonByMobilePhone(final String mobilePhone) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.getPersonByMobilePhone(mobilePhone,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean getPersonByMobilePhone(final String mobilePhone,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.getPersonByMobilePhoneReal(mobilePhone,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean getPersonByPapersNum(final String papersNum) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.getPersonByPapersNum(papersNum,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean getPersonByPapersNum(final String papersNum,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.getPersonByPapersNumReal(papersNum,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonGroupBean getPersonGroup(final int personGroupId) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonGroupBean,PersonGroupBean>() {
                @Override
                public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonGroupBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback){
                    service.getPersonGroup(personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PersonGroupBean> getPersonGroups(final List<Integer> groupIdList) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonGroupBean>,List<PersonGroupBean>>() {
                @Override
                public List<PersonGroupBean> apply(List<net.gdface.facelog.client.thrift.PersonGroupBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonGroupBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonGroupBean>> nativeCallback){
                    service.getPersonGroups(TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getPersonGroupsBelongs(final int personId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getPersonGroupsBelongs(personId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getPersonGroupsPermittedBy(final int deviceGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getPersonGroupsPermittedBy(deviceGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PermitBean getPersonPermit(final int deviceId,
        final int personId) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                @Override
                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback){
                    service.getPersonPermit(deviceId,personId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PermitBean> getPersonPermits(final int deviceId,
        final List<Integer> personIdList) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                @Override
                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PermitBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback){
                    service.getPersonPermits(deviceId,TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PersonBean> getPersons(final List<Integer> idList) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                @Override
                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback){
                    service.getPersons(TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PersonBean> getPersons(final List<Integer> idList,
        final Token token) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                @Override
                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback){
                    service.getPersonsReal(TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getPersonsOfGroup(final int personGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getPersonsOfGroup(personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getPersonsPermittedOnDevice(final int deviceId,
        final boolean ignoreSchedule,
        final List<Integer> excludePersonIds,
        final Long timestamp) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getPersonsPermittedOnDevice(deviceId,ignoreSchedule,TypeTransformer.getInstance().to(
                    excludePersonIds,
                    Integer.class,
                    Integer.class),timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Map<String, String> getProperties(final String prefix,
        final Token token) 
        {
        try{
            return syncCall(new Function<Map<String,String>,Map<String, String>>() {
                @Override
                public Map<String, String> apply(Map<String,String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<Map<String,String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Map<String,String>> nativeCallback){
                    service.getProperties(prefix,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String getProperty(final String key,
        final Token token) 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.getProperty(key,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Map<MQParam, String> getRedisParameters(final Token token) 
        {
        try{
            return syncCall(new Function<Map<net.gdface.facelog.client.thrift.MQParam,String>,Map<MQParam, String>>() {
                @Override
                public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam,String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.MQParam.class,
                    String.class,
                    MQParam.class,
                    String.class);
                }},
                new ServiceAsyncCall<Map<net.gdface.facelog.client.thrift.MQParam,String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Map<net.gdface.facelog.client.thrift.MQParam,String>> nativeCallback){
                    service.getRedisParameters(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Map<String, String> getServiceConfig(final Token token) 
        {
        try{
            return syncCall(new Function<Map<String,String>,Map<String, String>>() {
                @Override
                public Map<String, String> apply(Map<String,String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<Map<String,String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Map<String,String>> nativeCallback){
                    service.getServiceConfig(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getSubDeviceGroup(final int deviceGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getSubDeviceGroup(deviceGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> getSubPersonGroup(final int personGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.getSubPersonGroup(personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public TmpwdTargetInfo getTargetInfo4PwdOnDevice(final String pwd,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.TmpwdTargetInfo,TmpwdTargetInfo>() {
                @Override
                public TmpwdTargetInfo apply(net.gdface.facelog.client.thrift.TmpwdTargetInfo input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.TmpwdTargetInfo.class,
                    TmpwdTargetInfo.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.TmpwdTargetInfo>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.TmpwdTargetInfo> nativeCallback){
                    service.getTargetInfo4PwdOnDevice(pwd,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isDisable(final int personId) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isDisable(personId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isLocal(){
        return false;
    }
    @Override
    public boolean isValidAckChannel(final String ackChannel) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isValidAckChannel(ackChannel,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isValidCmdSn(final int cmdSn) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isValidCmdSn(cmdSn,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isValidDeviceToken(final Token token) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isValidDeviceToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isValidPassword(final String userId,
        final String password,
        final boolean isMd5) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isValidPassword(userId,password,isMd5,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isValidPersonToken(final Token token) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isValidPersonToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isValidRootToken(final Token token) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isValidRootToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isValidToken(final Token token) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isValidToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public boolean isValidUserToken(final Token token) 
        {
        try{
            return syncCall(new Function<Boolean,Boolean>() {
                @Override
                public Boolean apply(Boolean input) {
                    return input;
                }},
                new ServiceAsyncCall<Boolean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Boolean> nativeCallback){
                    service.isValidUserToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String iso8601Time() 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.iso8601Time(nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> listOfParentForDeviceGroup(final int deviceGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.listOfParentForDeviceGroup(deviceGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> listOfParentForPersonGroup(final int personGroupId) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.listOfParentForPersonGroup(personGroupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadAllPerson() 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadAllPerson(nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<DeviceBean> loadDeviceByWhere(final String where,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.DeviceBean>,List<DeviceBean>>() {
                @Override
                public List<DeviceBean> apply(List<net.gdface.facelog.client.thrift.DeviceBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.DeviceBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.DeviceBean>> nativeCallback){
                    service.loadDeviceByWhere(where,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadDeviceGroupByWhere(final String where,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadDeviceGroupByWhere(where,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadDeviceGroupIdByWhere(final String where) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadDeviceGroupIdByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadDeviceIdByWhere(final String where) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadDeviceIdByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadDistinctIntegerColumn(final String table,
        final String column,
        final String where) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadDistinctIntegerColumn(table,column,where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> loadDistinctStringColumn(final String table,
        final String column,
        final String where) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.loadDistinctStringColumn(table,column,where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<ErrorLogBean> loadErrorLogByWhere(final String where,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.ErrorLogBean>,List<ErrorLogBean>>() {
                @Override
                public List<ErrorLogBean> apply(List<net.gdface.facelog.client.thrift.ErrorLogBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ErrorLogBean.class,
                    ErrorLogBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.ErrorLogBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.ErrorLogBean>> nativeCallback){
                    service.loadErrorLogByWhere(where,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> loadFeatureMd5ByUpdate(final String timestamp) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.loadFeatureMd5ByUpdateTimeStr(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<String> loadFeatureMd5ByUpdate(final long timestamp) 
        {
        try{
            return syncCall(new Function<List<String>,List<String>>() {
                @Override
                public List<String> apply(List<String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<List<String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<String>> nativeCallback){
                    service.loadFeatureMd5ByUpdate(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<LogBean> loadLogByWhere(final String where,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.LogBean>,List<LogBean>>() {
                @Override
                public List<LogBean> apply(List<net.gdface.facelog.client.thrift.LogBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.LogBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.LogBean>> nativeCallback){
                    service.loadLogByWhere(where,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<LogLightBean> loadLogLightByVerifyTime(final String timestamp,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>() {
                @Override
                public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.LogLightBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.LogLightBean>> nativeCallback){
                    service.loadLogLightByVerifyTimeTimestr(timestamp,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<LogLightBean> loadLogLightByVerifyTime(final long timestamp,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>() {
                @Override
                public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.LogLightBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.LogLightBean>> nativeCallback){
                    service.loadLogLightByVerifyTime(timestamp,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<LogLightBean> loadLogLightByWhere(final String where,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>() {
                @Override
                public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.LogLightBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.LogLightBean>> nativeCallback){
                    service.loadLogLightByWhere(where,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PermitBean> loadPermitByUpdate(final String timestamp) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                @Override
                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PermitBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback){
                    service.loadPermitByUpdateTimestr(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PermitBean> loadPermitByUpdate(final long timestamp) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                @Override
                public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PermitBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback){
                    service.loadPermitByUpdate(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PersonBean> loadPersonByWhere(final String where,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                @Override
                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback){
                    service.loadPersonByWhere(where,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<PersonBean> loadPersonByWhere(final String where,
        final int startRow,
        final int numRows,
        final Token token) 
        {
        try{
            return syncCall(new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                @Override
                public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<List<net.gdface.facelog.client.thrift.PersonBean>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback){
                    service.loadPersonByWhereReal(where,startRow,numRows,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadPersonGroupByWhere(final String where,
        final int startRow,
        final int numRows) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadPersonGroupByWhere(where,startRow,numRows,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadPersonGroupIdByWhere(final String where) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadPersonGroupIdByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadPersonIdByUpdateTime(final String timestamp) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadPersonIdByUpdateTimeTimeStr(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadPersonIdByUpdateTime(final long timestamp) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadPersonIdByUpdateTime(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadPersonIdByWhere(final String where) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadPersonIdByWhere(where,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadUpdatedPersons(final String timestamp) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadUpdatedPersonsTimestr(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public List<Integer> loadUpdatedPersons(final long timestamp) 
        {
        try{
            return syncCall(new Function<List<Integer>,List<Integer>>() {
                @Override
                public List<Integer> apply(List<Integer> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }},
                new ServiceAsyncCall<List<Integer>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<List<Integer>> nativeCallback){
                    service.loadUpdatedPersons(timestamp,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void offline(final Token token) 
        throws ServiceSecurityException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.offline(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Token online(final DeviceBean device) 
        throws ServiceSecurityException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                @Override
                public Token apply(net.gdface.facelog.client.thrift.Token input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.Token>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.Token> nativeCallback){
                    service.online(TypeTransformer.getInstance().to(
                    device,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public DeviceBean registerDevice(final DeviceBean newDevice) 
        throws ServiceSecurityException{
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceBean> nativeCallback){
                    service.registerDevice(TypeTransformer.getInstance().to(
                    newDevice,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void releasePersonToken(final Token token) 
        throws ServiceSecurityException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.releasePersonToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void releaseRootToken(final Token token) 
        throws ServiceSecurityException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.releaseRootToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void releaseUserToken(final Token token) 
        throws ServiceSecurityException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.releaseUserToken(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void replaceFeature(final Integer personId,
        final String featureMd5,
        final boolean deleteOldFeatureImage,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.replaceFeature(personId,featureMd5,deleteOldFeatureImage,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Integer rootGroupOfDevice(final Integer deviceId) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.rootGroupOfDevice(deviceId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Integer rootGroupOfDeviceGroup(final Integer groupId) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.rootGroupOfDeviceGroup(groupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Integer rootGroupOfPerson(final Integer personId) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.rootGroupOfPerson(personId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Integer rootGroupOfPersonGroup(final Integer groupId) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.rootGroupOfPersonGroup(groupId,nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String runCmd(final List<Integer> target,
        final boolean group,
        final String cmdpath,
        final String jsonArgs,
        final String ackChannel,
        final Token token) 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.runCmd(TypeTransformer.getInstance().to(
                    target,
                    Integer.class,
                    Integer.class),group,cmdpath,jsonArgs,ackChannel,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Integer runTask(final String taskQueue,
        final String cmdpath,
        final String jsonArgs,
        final String ackChannel,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.runTask(taskQueue,cmdpath,jsonArgs,ackChannel,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public DeviceBean saveDevice(final DeviceBean deviceBean,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceBean> nativeCallback){
                    service.saveDevice(TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public DeviceGroupBean saveDeviceGroup(final DeviceGroupBean deviceGroupBean,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.DeviceGroupBean,DeviceGroupBean>() {
                @Override
                public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceGroupBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback){
                    service.saveDeviceGroup(TypeTransformer.getInstance().to(
                    deviceGroupBean,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PermitBean savePermit(final int deviceGroupId,
        final int personGroupId,
        final String column,
        final String value,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                @Override
                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback){
                    service.savePermitWithColumn(deviceGroupId,personGroupId,column,value,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PermitBean savePermit(final PermitBean permitBean,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                @Override
                public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PermitBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PermitBean> nativeCallback){
                    service.savePermit(TypeTransformer.getInstance().to(
                    permitBean,
                    PermitBean.class,
                    net.gdface.facelog.client.thrift.PermitBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean savePerson(final PersonBean personBean,
        final byte[] idPhoto,
        final byte[] feature,
        final String featureVersion,
        final byte[] featureImage,
        final FaceBean faceBean,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.savePersonFull(TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),featureVersion,TypeTransformer.getInstance().to(
                    featureImage,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean savePerson(final PersonBean personBean,
        final byte[] idPhoto,
        final byte[] feature,
        final String featureVersion,
        final List<byte[]> photos,
        final List<FaceBean> faces,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.savePersonWithPhotoAndFeatureMultiImage(TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),featureVersion,TypeTransformer.getInstance().to(
                    photos,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    faces,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean savePerson(final PersonBean personBean,
        final byte[] idPhoto,
        final byte[] feature,
        final String featureVersion,
        final List<FaceBean> faceBeans,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.savePersonWithPhotoAndFeatureMultiFaces(TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),featureVersion,TypeTransformer.getInstance().to(
                    faceBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean savePerson(final PersonBean personBean,
        final byte[] idPhoto,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.savePersonWithPhoto(TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean savePerson(final PersonBean personBean,
        final byte[] idPhoto,
        final FeatureBean featureBean,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.savePersonWithPhotoAndFeature(TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    featureBean,
                    FeatureBean.class,
                    net.gdface.facelog.client.thrift.FeatureBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean savePerson(final PersonBean personBean,
        final String idPhotoMd5,
        final String featureMd5,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.savePersonWithPhotoAndFeatureSaved(TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),idPhotoMd5,featureMd5,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonBean savePerson(final PersonBean personBean,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                @Override
                public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonBean> nativeCallback){
                    service.savePerson(TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public PersonGroupBean savePersonGroup(final PersonGroupBean personGroupBean,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.PersonGroupBean,PersonGroupBean>() {
                @Override
                public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.PersonGroupBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback){
                    service.savePersonGroup(TypeTransformer.getInstance().to(
                    personGroupBean,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public int savePersons(final List<byte[]> photos,
        final List<PersonBean> persons,
        final Token token) 
        {
        try{
            return syncCall(new Function<Integer,Integer>() {
                @Override
                public Integer apply(Integer input) {
                    return input;
                }},
                new ServiceAsyncCall<Integer>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Integer> nativeCallback){
                    service.savePersonsWithPhoto(TypeTransformer.getInstance().to(
                    photos,
                    byte[].class,
                    okio.ByteString.class),TypeTransformer.getInstance().to(
                    persons,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void savePersons(final List<PersonBean> persons,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.savePersons(TypeTransformer.getInstance().to(
                    persons,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void saveServiceConfig(final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.saveServiceConfig(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String sdkTaskQueueOf(final String task,
        final String sdkVersion,
        final Token token) 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.sdkTaskQueueOf(task,sdkVersion,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void setPersonExpiryDate(final int personId,
        final String expiryDate,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.setPersonExpiryDateTimeStr(personId,expiryDate,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void setPersonExpiryDate(final int personId,
        final long expiryDate,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.setPersonExpiryDate(personId,expiryDate,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void setPersonExpiryDate(final List<Integer> personIdList,
        final long expiryDate,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.setPersonExpiryDateList(TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),expiryDate,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void setProperties(final Map<String, String> config,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.setProperties(TypeTransformer.getInstance().to(
                    config,
                    String.class,
                    String.class,
                    String.class,
                    String.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void setProperty(final String key,
        final String value,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.setProperty(key,value,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String taskQueueOf(final String task,
        final Token token) 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.taskQueueOf(task,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void unbindBorder(final Integer personGroupId,
        final Integer deviceGroupId,
        final Token token) 
        {
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.unbindBorder(personGroupId,deviceGroupId,TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public void unregisterDevice(final Token token) 
        throws ServiceSecurityException{
        try{
             syncCall(new Function<Void,Void>() {
                @Override
                public Void apply(Void input) {
                    return input;
                }},
                new ServiceAsyncCall<Void>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Void> nativeCallback){
                    service.unregisterDevice(TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            throw TypeTransformer.getInstance().to(
                    e,
                    net.gdface.facelog.client.thrift.ServiceSecurityException.class,
                    ServiceSecurityException.class);
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public DeviceBean updateDevice(final DeviceBean deviceBean,
        final Token token) 
        {
        try{
            return syncCall(new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                @Override
                public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }},
                new ServiceAsyncCall<net.gdface.facelog.client.thrift.DeviceBean>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<net.gdface.facelog.client.thrift.DeviceBean> nativeCallback){
                    service.updateDevice(TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public String version() 
        {
        try{
            return syncCall(new Function<String,String>() {
                @Override
                public String apply(String input) {
                    return input;
                }},
                new ServiceAsyncCall<String>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<String> nativeCallback){
                    service.version(nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
    @Override
    public Map<String, String> versionInfo() 
        {
        try{
            return syncCall(new Function<Map<String,String>,Map<String, String>>() {
                @Override
                public Map<String, String> apply(Map<String,String> input) {
                    return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }},
                new ServiceAsyncCall<Map<String,String>>(){
                @Override
                public void call(net.gdface.facelog.client.thrift.IFaceLogClient service,ServiceMethodCallback<Map<String,String>> nativeCallback){
                    service.versionInfo(nativeCallback);
                }});
        }
        catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            throw new ServiceRuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}