// ______________________________________________________
// Generated by codegen - https://gitee.com/l0km/codegen 
// template: thrift/client_thrifty/perservice/client.async.decorator.class.vm
// ______________________________________________________
package net.gdface.facelog.thrift;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.TmpPwdTargetType;
import net.gdface.facelog.TmpwdTargetInfo;
import net.gdface.facelog.Token;
import net.gdface.facelog.db.DeviceBean;
import net.gdface.facelog.db.DeviceGroupBean;
import net.gdface.facelog.db.ErrorLogBean;
import net.gdface.facelog.db.FaceBean;
import net.gdface.facelog.db.FeatureBean;
import net.gdface.facelog.db.ImageBean;
import net.gdface.facelog.db.LogBean;
import net.gdface.facelog.db.LogLightBean;
import net.gdface.facelog.db.PermitBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.db.PersonGroupBean;
import net.gdface.thrift.TypeTransformer;

import java.io.IOException;
import com.google.common.base.Function;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.ServiceMethodCallback;

import net.gdface.thrift.ClientFactory;
import static com.google.common.base.Preconditions.*;

/**
 * 基于thrift/swift框架生成的client端代码提供{@link IFaceLog}接口的异步RPC实现(线程安全)<br>
 * 转发所有{@link IFaceLog}接口方法到{@link net.gdface.facelog.client.thrift.IFaceLogClient}实例<br>
 * 所有服务端抛出的{@link RuntimeException}异常被封装到{@link ServiceRuntimeException}中抛出<br>
 * Example:<br>
 * <pre>
 *        IFaceLogThriftClientAsync thriftInstance = ClientFactory
 *            .builder()
 *            .setHostAndPort("127.0.0.1",26413)
 *            .build(IFaceLogThriftClientAsync.class);
 * </pre>
 * 计算机生成代码(generated by automated tools ThriftServiceDecoratorGenerator @author guyadong)<br>
 * @author guyadong
 *
 */
public class IFaceLogThriftClientAsync {
    private final ClientFactory factory;

    public ClientFactory getFactory() {
        return factory;
    }
    public IFaceLogThriftClientAsync(ClientFactory factory) {
        super();
        this.factory = checkNotNull(factory,"factory is null");
    }
    /**
     * @param host RPC service host
     * @param port RPC service port 
     */
    public IFaceLogThriftClientAsync(String host,int port) {
        this(ClientFactory.builder().setHostAndPort(host,port));
    }
    /**
     * @param hostAndPort RPC service host and port 
     */
    public IFaceLogThriftClientAsync(HostAndPort hostAndPort) {
        this(ClientFactory.builder().setHostAndPort(hostAndPort));
    }
    /**
     * test if connectable for RPC service
     * @return return {@code true} if connectable ,otherwise {@code false}
     */
    public boolean testConnect(){
        return factory.testConnect();
    }
    private class MethodCallback<L,R> implements ServiceMethodCallback<R>{
	    private final AsyncClientBase.Listener closeListener = new AsyncClientBase.Listener(){
	        @Override
	        public void onTransportClosed() {
	        }
	
	        @Override
	        public void onError(Throwable error) {
	            MethodCallback.this.onError(error);
	        }
	    };
        final net.gdface.facelog.client.thrift.IFaceLogClient service = factory.applyInstance(net.gdface.facelog.client.thrift.IFaceLogClient.class,closeListener);
        final SettableFuture<L> feature = SettableFuture.create();
        final Function<R,L> transformer;

        MethodCallback(Function<R, L> transformer) {
            this.transformer = transformer;
        }

        @Override
        public void onSuccess(R result) {
            feature.set(transformer.apply(result));            
            try {
                service.close();
            } catch (IOException e) {
            }
        }

        @Override 
        public void onError(Throwable error) {            
            if(error instanceof ThriftException ){
                if(((ThriftException)error).kind == ThriftException.Kind.MISSING_RESULT  ){
                    this.onSuccess(null);
                }
            }
            feature.setException(error);
            try {
                service.close();
            } catch (IOException e) {
            }
        }
    }
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IFaceLogThriftClientAsync [factory=");
        builder.append(factory);
        builder.append(",interface=");
        builder.append(IFaceLog.class.getName());
        builder.append("]");
        return builder.toString();
    }
    /**
     * 默认的{@link FutureCallback}实现
     * @author guyadong
     *
     * @param <V>
     */
    public static class DefaultCallback<V> implements FutureCallback<V>{
        @Override
        public void onSuccess(V result) {
            // DO NOTHING
        }
        @Override
        public void onFailure(Throwable t) {
            try{
                throw t;
            }
            catch(net.gdface.facelog.client.thrift.DuplicateRecordException e){
                onDuplicateRecordException(e);
            }
            catch(net.gdface.facelog.client.thrift.ServiceSecurityException e){
                onServiceSecurityException(e);
            }
            catch(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
                onServiceRuntimeException(e);
            }
            catch(Throwable e){
                onThrowable(e);
            }
        }
        protected void onDuplicateRecordException(net.gdface.facelog.client.thrift.DuplicateRecordException e){
            System.out.println(e.serviceStackTraceMessage);
        }
        protected void onServiceSecurityException(net.gdface.facelog.client.thrift.ServiceSecurityException e){
            System.out.println(e.serviceStackTraceMessage);
        }
        protected void onServiceRuntimeException(net.gdface.facelog.client.thrift.ServiceRuntimeException e){
            System.out.println(e.serviceStackTraceMessage);
        }
        protected void onThrowable(Throwable e){
            e.printStackTrace();
        }
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addErrorLog(net.gdface.facelog.db.ErrorLogBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addErrorLog(ErrorLogBean errorLogBean,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addErrorLog(
                TypeTransformer.getInstance().to(
                    errorLogBean,
                    ErrorLogBean.class,
                    net.gdface.facelog.client.thrift.ErrorLogBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addErrorLog(ErrorLogBean errorLogBean,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addErrorLog(errorLogBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addFeature(byte[],java.lang.String,java.lang.Integer,boolean,byte[],net.gdface.facelog.db.FaceBean,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<FeatureBean> addFeature(byte[] feature,
        String featureVersion,
        Integer personId,
        boolean asIdPhotoIfAbsent,
        byte[] featurePhoto,
        FaceBean faceBean,
        String removed,
        Token token){
        MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = 
            new MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean>(
                new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                        @Override
                        public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.addFeatureWithImage(
                TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            featureVersion,
            personId,
            asIdPhotoIfAbsent,
            TypeTransformer.getInstance().to(
                    featurePhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            removed,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addFeature(byte[] feature,
        String featureVersion,
        Integer personId,
        boolean asIdPhotoIfAbsent,
        byte[] featurePhoto,
        FaceBean faceBean,
        String removed,
        Token token,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(addFeature(feature,featureVersion,personId,asIdPhotoIfAbsent,featurePhoto,faceBean,removed,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addFeature(byte[],java.lang.String,java.lang.Integer,java.util.List,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<FeatureBean> addFeature(byte[] feature,
        String featureVersion,
        Integer personId,
        List<FaceBean> faecBeans,
        String removed,
        Token token){
        MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = 
            new MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean>(
                new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                        @Override
                        public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.addFeature(
                TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            featureVersion,
            personId,
            TypeTransformer.getInstance().to(
                    faecBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            removed,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addFeature(byte[] feature,
        String featureVersion,
        Integer personId,
        List<FaceBean> faecBeans,
        String removed,
        Token token,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(addFeature(feature,featureVersion,personId,faecBeans,removed,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addFeature(byte[],java.lang.String,java.lang.Integer,java.util.List,java.util.List,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<FeatureBean> addFeature(byte[] feature,
        String featureVersion,
        Integer personId,
        List<byte[]> photos,
        List<FaceBean> faces,
        String removed,
        Token token){
        MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = 
            new MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean>(
                new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                        @Override
                        public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.addFeatureMulti(
                TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            featureVersion,
            personId,
            TypeTransformer.getInstance().to(
                    photos,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    faces,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            removed,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addFeature(byte[] feature,
        String featureVersion,
        Integer personId,
        List<byte[]> photos,
        List<FaceBean> faces,
        String removed,
        Token token,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(addFeature(feature,featureVersion,personId,photos,faces,removed,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addImage(byte[],java.lang.Integer,net.gdface.facelog.db.FaceBean,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<ImageBean> addImage(byte[] imageData,
        Integer deviceId,
        FaceBean faceBean,
        Integer personId,
        Token token){
        MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean> nativeCallback = 
            new MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean>(
                new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>() {
                        @Override
                        public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }});
        nativeCallback.service.addImage(
                TypeTransformer.getInstance().to(
                    imageData,
                    byte[].class,
                    okio.ByteString.class),
            deviceId,
            TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addImage(byte[] imageData,
        Integer deviceId,
        FaceBean faceBean,
        Integer personId,
        Token token,
        FutureCallback<ImageBean>callback){
        factory.addCallback(addImage(imageData,deviceId,faceBean,personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLog(net.gdface.facelog.db.LogBean,byte[],net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLog(LogBean logBean,
        byte[] faceImage,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addLogWithFaceImage(
                TypeTransformer.getInstance().to(
                    logBean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    faceImage,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addLog(LogBean logBean,
        byte[] faceImage,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLog(logBean,faceImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLog(net.gdface.facelog.db.LogBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLog(LogBean logBean,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addLog(
                TypeTransformer.getInstance().to(
                    logBean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addLog(LogBean logBean,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLog(logBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLog(net.gdface.facelog.db.LogBean,net.gdface.facelog.db.FaceBean,byte[],net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLog(LogBean logBean,
        FaceBean faceBean,
        byte[] featureImage,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addLogFull(
                TypeTransformer.getInstance().to(
                    logBean,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    featureImage,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addLog(LogBean logBean,
        FaceBean faceBean,
        byte[] featureImage,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLog(logBean,faceBean,featureImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLogs(java.util.List,java.util.List,java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLogs(List<LogBean> logBeans,
        List<FaceBean> faceBeans,
        List<byte[]> featureImages,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addLogsFull(
                TypeTransformer.getInstance().to(
                    logBeans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    faceBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    featureImages,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addLogs(List<LogBean> logBeans,
        List<FaceBean> faceBeans,
        List<byte[]> featureImages,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLogs(logBeans,faceBeans,featureImages,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLogs(java.util.List,java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLogs(List<LogBean> logBeans,
        List<byte[]> faceImages,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addLogsWithFaceImage(
                TypeTransformer.getInstance().to(
                    logBeans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    faceImages,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addLogs(List<LogBean> logBeans,
        List<byte[]> faceImages,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLogs(logBeans,faceImages,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#addLogs(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> addLogs(List<LogBean> beans,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.addLogs(
                TypeTransformer.getInstance().to(
                    beans,
                    LogBean.class,
                    net.gdface.facelog.client.thrift.LogBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void addLogs(List<LogBean> beans,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(addLogs(beans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyAckChannel(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> applyAckChannel(int duration,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.applyAckChannelWithDuration(
                duration,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void applyAckChannel(int duration,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(applyAckChannel(duration,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyAckChannel(net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> applyAckChannel(Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.applyAckChannel(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void applyAckChannel(Token token,
        FutureCallback<String>callback){
        factory.addCallback(applyAckChannel(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyCmdSn(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> applyCmdSn(Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.applyCmdSn(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void applyCmdSn(Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(applyCmdSn(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyPersonToken(int,java.lang.String,boolean)}
     */
    public ListenableFuture<Token> applyPersonToken(int personId,
        String password,
        boolean isMd5){
        MethodCallback<Token,net.gdface.facelog.client.thrift.Token> nativeCallback = 
            new MethodCallback<Token,net.gdface.facelog.client.thrift.Token>(
                new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                        @Override
                        public Token apply(net.gdface.facelog.client.thrift.Token input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }});
        nativeCallback.service.applyPersonToken(
                personId,
            password,
            isMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void applyPersonToken(int personId,
        String password,
        boolean isMd5,
        FutureCallback<Token>callback){
        factory.addCallback(applyPersonToken(personId,password,isMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyRootToken(java.lang.String,boolean)}
     */
    public ListenableFuture<Token> applyRootToken(String password,
        boolean isMd5){
        MethodCallback<Token,net.gdface.facelog.client.thrift.Token> nativeCallback = 
            new MethodCallback<Token,net.gdface.facelog.client.thrift.Token>(
                new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                        @Override
                        public Token apply(net.gdface.facelog.client.thrift.Token input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }});
        nativeCallback.service.applyRootToken(
                password,
            isMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void applyRootToken(String password,
        boolean isMd5,
        FutureCallback<Token>callback){
        factory.addCallback(applyRootToken(password,isMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#applyUserToken(int,java.lang.String,boolean)}
     */
    public ListenableFuture<Token> applyUserToken(int userid,
        String password,
        boolean isMd5){
        MethodCallback<Token,net.gdface.facelog.client.thrift.Token> nativeCallback = 
            new MethodCallback<Token,net.gdface.facelog.client.thrift.Token>(
                new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                        @Override
                        public Token apply(net.gdface.facelog.client.thrift.Token input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }});
        nativeCallback.service.applyUserToken(
                userid,
            password,
            isMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void applyUserToken(int userid,
        String password,
        boolean isMd5,
        FutureCallback<Token>callback){
        factory.addCallback(applyUserToken(userid,password,isMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#bindBorder(java.lang.Integer,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> bindBorder(Integer personGroupId,
        Integer deviceGroupId,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.bindBorder(
                personGroupId,
            deviceGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void bindBorder(Integer personGroupId,
        Integer deviceGroupId,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(bindBorder(personGroupId,deviceGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#childListForDeviceGroup(int)}
     */
    public ListenableFuture<List<Integer>> childListForDeviceGroup(int deviceGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.childListForDeviceGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void childListForDeviceGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(childListForDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#childListForPersonGroup(int)}
     */
    public ListenableFuture<List<Integer>> childListForPersonGroup(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.childListForPersonGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void childListForPersonGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(childListForPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countDeviceByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countDeviceByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countDeviceByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countDeviceByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countDeviceByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countDeviceGroupByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countDeviceGroupByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countDeviceGroupByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countDeviceGroupByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countDeviceGroupByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countErrorLogByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countErrorLogByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countErrorLogByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countErrorLogByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countErrorLogByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countLogByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countLogByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countLogByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogLightByVerifyTime(java.lang.String)}
     */
    public ListenableFuture<Integer> countLogLightByVerifyTime(String timestamp){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countLogLightByVerifyTimeTimestr(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void countLogLightByVerifyTime(String timestamp,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogLightByVerifyTime(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogLightByVerifyTime(long)}
     */
    public ListenableFuture<Integer> countLogLightByVerifyTime(long timestamp){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countLogLightByVerifyTime(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void countLogLightByVerifyTime(long timestamp,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogLightByVerifyTime(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countLogLightByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countLogLightByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countLogLightByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countLogLightByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countLogLightByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countPersonByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countPersonByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countPersonByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countPersonByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countPersonByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countPersonGroupByWhere(java.lang.String)}
     */
    public ListenableFuture<Integer> countPersonGroupByWhere(String where){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.countPersonGroupByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void countPersonGroupByWhere(String where,
        FutureCallback<Integer>callback){
        factory.addCallback(countPersonGroupByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countPersonLog(int,java.lang.Long,java.lang.Long)}
     */
    public ListenableFuture<Map<String, Integer>> countPersonLog(int personId,
        Long startDate,
        Long endDate){
        MethodCallback<Map<String, Integer>,Map<String,Integer>> nativeCallback = 
            new MethodCallback<Map<String, Integer>,Map<String,Integer>>(
                new Function<Map<String,Integer>,Map<String, Integer>>() {
                        @Override
                        public Map<String, Integer> apply(Map<String,Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    Integer.class,
                    String.class,
                    Integer.class);
                }});
        nativeCallback.service.countPersonLog(
                personId,
            startDate,
            endDate,nativeCallback);
        return nativeCallback.feature;
    }
    public void countPersonLog(int personId,
        Long startDate,
        Long endDate,
        FutureCallback<Map<String, Integer>>callback){
        factory.addCallback(countPersonLog(personId,startDate,endDate), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#countPersonLog(int,java.lang.String,java.lang.String)}
     */
    public ListenableFuture<Map<String, Integer>> countPersonLog(int personId,
        String startDate,
        String endDate){
        MethodCallback<Map<String, Integer>,Map<String,Integer>> nativeCallback = 
            new MethodCallback<Map<String, Integer>,Map<String,Integer>>(
                new Function<Map<String,Integer>,Map<String, Integer>>() {
                        @Override
                        public Map<String, Integer> apply(Map<String,Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    Integer.class,
                    String.class,
                    Integer.class);
                }});
        nativeCallback.service.countPersonLogTimeStr(
                personId,
            startDate,
            endDate,nativeCallback);
        return nativeCallback.feature;
    }
    public void countPersonLog(int personId,
        String startDate,
        String endDate,
        FutureCallback<Map<String, Integer>>callback){
        factory.addCallback(countPersonLog(personId,startDate,endDate), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#createTempPwd(int,net.gdface.facelog.TmpPwdTargetType,int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> createTempPwd(int targetId,
        TmpPwdTargetType targetType,
        int duration,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.createTempPwdWithDuration(
                targetId,
            TypeTransformer.getInstance().to(
                    targetType,
                    TmpPwdTargetType.class,
                    net.gdface.facelog.client.thrift.TmpPwdTargetType.class),
            duration,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void createTempPwd(int targetId,
        TmpPwdTargetType targetType,
        int duration,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(createTempPwd(targetId,targetType,duration,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#createTempPwd(int,net.gdface.facelog.TmpPwdTargetType,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> createTempPwd(int targetId,
        TmpPwdTargetType targetType,
        String expiryDate,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.createTempPwd(
                targetId,
            TypeTransformer.getInstance().to(
                    targetType,
                    TmpPwdTargetType.class,
                    net.gdface.facelog.client.thrift.TmpPwdTargetType.class),
            expiryDate,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void createTempPwd(int targetId,
        TmpPwdTargetType targetType,
        String expiryDate,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(createTempPwd(targetId,targetType,expiryDate,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteAllFeaturesByPersonId(int,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteAllFeaturesByPersonId(int personId,
        boolean deleteImage,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteAllFeaturesByPersonId(
                personId,
            deleteImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteAllFeaturesByPersonId(int personId,
        boolean deleteImage,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteAllFeaturesByPersonId(personId,deleteImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteDevice(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> deleteDevice(int id,
        Token token){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.deleteDevice(
                id,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteDevice(int id,
        Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(deleteDevice(id,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteDeviceByMac(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> deleteDeviceByMac(String mac,
        Token token){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.deleteDeviceByMac(
                mac,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteDeviceByMac(String mac,
        Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(deleteDeviceByMac(mac,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteDeviceGroup(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteDeviceGroup(int deviceGroupId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteDeviceGroup(
                deviceGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteDeviceGroup(int deviceGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteDeviceGroup(deviceGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteErrorLogByWhere(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteErrorLogByWhere(String where,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteErrorLogByWhere(
                where,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteErrorLogByWhere(String where,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteErrorLogByWhere(where,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteFeature(java.lang.String,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<List<String>> deleteFeature(String featureMd5,
        boolean deleteImage,
        Token token){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.deleteFeature(
                featureMd5,
            deleteImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteFeature(String featureMd5,
        boolean deleteImage,
        Token token,
        FutureCallback<List<String>>callback){
        factory.addCallback(deleteFeature(featureMd5,deleteImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteGroupPermitOnDeviceGroup(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteGroupPermitOnDeviceGroup(int deviceGroupId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteGroupPermitOnDeviceGroup(
                deviceGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteGroupPermitOnDeviceGroup(int deviceGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteGroupPermitOnDeviceGroup(deviceGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteImage(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteImage(String imageMd5,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteImage(
                imageMd5,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteImage(String imageMd5,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteImage(imageMd5,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deleteLogByWhere(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deleteLogByWhere(String where,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deleteLogByWhere(
                where,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deleteLogByWhere(String where,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deleteLogByWhere(where,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePermit(int,int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePermit(int deviceGroupId,
        int personGroupId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePermitById(
                deviceGroupId,
            personGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePermit(int deviceGroupId,
        int personGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePermit(deviceGroupId,personGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePerson(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePerson(int personId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePerson(
                personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePerson(int personId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePerson(personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonByPapersNum(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonByPapersNum(String papersNum,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersonByPapersNum(
                papersNum,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersonByPapersNum(String papersNum,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonByPapersNum(papersNum,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonGroup(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonGroup(int personGroupId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersonGroup(
                personGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersonGroup(int personGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonGroup(personGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonGroupPermit(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonGroupPermit(int personGroupId,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersonGroupPermit(
                personGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersonGroupPermit(int personGroupId,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonGroupPermit(personGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersons(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersons(List<Integer> personIdList,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersons(
                TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersons(List<Integer> personIdList,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersons(personIdList,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#deletePersonsByPapersNum(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> deletePersonsByPapersNum(List<String> papersNumlist,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.deletePersonsByPapersNum(
                TypeTransformer.getInstance().to(
                    papersNumlist,
                    String.class,
                    String.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void deletePersonsByPapersNum(List<String> papersNumlist,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(deletePersonsByPapersNum(papersNumlist,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#disablePerson(int,java.lang.Integer,boolean,boolean,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> disablePerson(int personId,
        Integer moveToGroupId,
        boolean deletePhoto,
        boolean deleteFeature,
        boolean deleteLog,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.disablePerson(
                personId,
            moveToGroupId,
            deletePhoto,
            deleteFeature,
            deleteLog,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void disablePerson(int personId,
        Integer moveToGroupId,
        boolean deletePhoto,
        boolean deleteFeature,
        boolean deleteLog,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(disablePerson(personId,moveToGroupId,deletePhoto,deleteFeature,deleteLog,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#disablePerson(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> disablePerson(List<Integer> personIdList,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.disablePersonList(
                TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void disablePerson(List<Integer> personIdList,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(disablePerson(personIdList,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsDevice(int)}
     */
    public ListenableFuture<Boolean> existsDevice(int id){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.existsDevice(
                id,nativeCallback);
        return nativeCallback.feature;
    }
    public void existsDevice(int id,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsDevice(id), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsFeature(java.lang.String)}
     */
    public ListenableFuture<Boolean> existsFeature(String md5){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.existsFeature(
                md5,nativeCallback);
        return nativeCallback.feature;
    }
    public void existsFeature(String md5,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsFeature(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsImage(java.lang.String)}
     */
    public ListenableFuture<Boolean> existsImage(String md5){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.existsImage(
                md5,nativeCallback);
        return nativeCallback.feature;
    }
    public void existsImage(String md5,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsImage(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#existsPerson(int)}
     */
    public ListenableFuture<Boolean> existsPerson(int persionId){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.existsPerson(
                persionId,nativeCallback);
        return nativeCallback.feature;
    }
    public void existsPerson(int persionId,
        FutureCallback<Boolean>callback){
        factory.addCallback(existsPerson(persionId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#faceRecognizePersonPermitted(byte[],java.lang.Float,int)}
     */
    public ListenableFuture<Integer> faceRecognizePersonPermitted(byte[] imageData,
        Float threshold,
        int deviceId){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.faceRecognizePersonPermitted(
                TypeTransformer.getInstance().to(
                    imageData,
                    byte[].class,
                    okio.ByteString.class),
            (threshold==null)?null:threshold.doubleValue(),
            deviceId,nativeCallback);
        return nativeCallback.feature;
    }
    public void faceRecognizePersonPermitted(byte[] imageData,
        Float threshold,
        int deviceId,
        FutureCallback<Integer>callback){
        factory.addCallback(faceRecognizePersonPermitted(imageData,threshold,deviceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevice(int)}
     */
    public ListenableFuture<DeviceBean> getDevice(int deviceId){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.getDevice(
                deviceId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDevice(int deviceId,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(getDevice(deviceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceByMac(java.lang.String)}
     */
    public ListenableFuture<DeviceBean> getDeviceByMac(String mac){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.getDeviceByMac(
                mac,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceByMac(String mac,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(getDeviceByMac(mac), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroup(int)}
     */
    public ListenableFuture<DeviceGroupBean> getDeviceGroup(int deviceGroupId){
        MethodCallback<DeviceGroupBean,net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback = 
            new MethodCallback<DeviceGroupBean,net.gdface.facelog.client.thrift.DeviceGroupBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceGroupBean,DeviceGroupBean>() {
                        @Override
                        public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }});
        nativeCallback.service.getDeviceGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceGroup(int deviceGroupId,
        FutureCallback<DeviceGroupBean>callback){
        factory.addCallback(getDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroups(java.util.List)}
     */
    public ListenableFuture<List<DeviceGroupBean>> getDeviceGroups(List<Integer> groupIdList){
        MethodCallback<List<DeviceGroupBean>,List<net.gdface.facelog.client.thrift.DeviceGroupBean>> nativeCallback = 
            new MethodCallback<List<DeviceGroupBean>,List<net.gdface.facelog.client.thrift.DeviceGroupBean>>(
                new Function<List<net.gdface.facelog.client.thrift.DeviceGroupBean>,List<DeviceGroupBean>>() {
                        @Override
                        public List<DeviceGroupBean> apply(List<net.gdface.facelog.client.thrift.DeviceGroupBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }});
        nativeCallback.service.getDeviceGroups(
                TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceGroups(List<Integer> groupIdList,
        FutureCallback<List<DeviceGroupBean>>callback){
        factory.addCallback(getDeviceGroups(groupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroupsBelongs(int)}
     */
    public ListenableFuture<List<Integer>> getDeviceGroupsBelongs(int deviceId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getDeviceGroupsBelongs(
                deviceId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceGroupsBelongs(int deviceId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getDeviceGroupsBelongs(deviceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroupsPermit(int)}
     */
    public ListenableFuture<List<Integer>> getDeviceGroupsPermit(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getDeviceGroupsPermit(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceGroupsPermit(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getDeviceGroupsPermit(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceGroupsPermittedBy(int)}
     */
    public ListenableFuture<List<Integer>> getDeviceGroupsPermittedBy(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getDeviceGroupsPermittedBy(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceGroupsPermittedBy(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getDeviceGroupsPermittedBy(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDeviceIdOfFeature(java.lang.String)}
     */
    public ListenableFuture<Integer> getDeviceIdOfFeature(String featureMd5){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.getDeviceIdOfFeature(
                featureMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDeviceIdOfFeature(String featureMd5,
        FutureCallback<Integer>callback){
        factory.addCallback(getDeviceIdOfFeature(featureMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevices(java.util.List)}
     */
    public ListenableFuture<List<DeviceBean>> getDevices(List<Integer> idList){
        MethodCallback<List<DeviceBean>,List<net.gdface.facelog.client.thrift.DeviceBean>> nativeCallback = 
            new MethodCallback<List<DeviceBean>,List<net.gdface.facelog.client.thrift.DeviceBean>>(
                new Function<List<net.gdface.facelog.client.thrift.DeviceBean>,List<DeviceBean>>() {
                        @Override
                        public List<DeviceBean> apply(List<net.gdface.facelog.client.thrift.DeviceBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.getDevices(
                TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getDevices(List<Integer> idList,
        FutureCallback<List<DeviceBean>>callback){
        factory.addCallback(getDevices(idList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getDevicesOfGroup(int)}
     */
    public ListenableFuture<List<Integer>> getDevicesOfGroup(int deviceGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getDevicesOfGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getDevicesOfGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getDevicesOfGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFace(int)}
     */
    public ListenableFuture<FaceBean> getFace(int faceId){
        MethodCallback<FaceBean,net.gdface.facelog.client.thrift.FaceBean> nativeCallback = 
            new MethodCallback<FaceBean,net.gdface.facelog.client.thrift.FaceBean>(
                new Function<net.gdface.facelog.client.thrift.FaceBean,FaceBean>() {
                        @Override
                        public FaceBean apply(net.gdface.facelog.client.thrift.FaceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FaceBean.class,
                    FaceBean.class);
                }});
        nativeCallback.service.getFace(
                faceId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFace(int faceId,
        FutureCallback<FaceBean>callback){
        factory.addCallback(getFace(faceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFaceApiParameters(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<String, String>> getFaceApiParameters(Token token){
        MethodCallback<Map<String, String>,Map<String,String>> nativeCallback = 
            new MethodCallback<Map<String, String>,Map<String,String>>(
                new Function<Map<String,String>,Map<String, String>>() {
                        @Override
                        public Map<String, String> apply(Map<String,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getFaceApiParameters(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getFaceApiParameters(Token token,
        FutureCallback<Map<String, String>>callback){
        factory.addCallback(getFaceApiParameters(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFacesOfFeature(java.lang.String)}
     */
    public ListenableFuture<List<FaceBean>> getFacesOfFeature(String featureMd5){
        MethodCallback<List<FaceBean>,List<net.gdface.facelog.client.thrift.FaceBean>> nativeCallback = 
            new MethodCallback<List<FaceBean>,List<net.gdface.facelog.client.thrift.FaceBean>>(
                new Function<List<net.gdface.facelog.client.thrift.FaceBean>,List<FaceBean>>() {
                        @Override
                        public List<FaceBean> apply(List<net.gdface.facelog.client.thrift.FaceBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FaceBean.class,
                    FaceBean.class);
                }});
        nativeCallback.service.getFacesOfFeature(
                featureMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFacesOfFeature(String featureMd5,
        FutureCallback<List<FaceBean>>callback){
        factory.addCallback(getFacesOfFeature(featureMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFacesOfImage(java.lang.String)}
     */
    public ListenableFuture<List<FaceBean>> getFacesOfImage(String imageMd5){
        MethodCallback<List<FaceBean>,List<net.gdface.facelog.client.thrift.FaceBean>> nativeCallback = 
            new MethodCallback<List<FaceBean>,List<net.gdface.facelog.client.thrift.FaceBean>>(
                new Function<List<net.gdface.facelog.client.thrift.FaceBean>,List<FaceBean>>() {
                        @Override
                        public List<FaceBean> apply(List<net.gdface.facelog.client.thrift.FaceBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FaceBean.class,
                    FaceBean.class);
                }});
        nativeCallback.service.getFacesOfImage(
                imageMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFacesOfImage(String imageMd5,
        FutureCallback<List<FaceBean>>callback){
        factory.addCallback(getFacesOfImage(imageMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeature(java.lang.String)}
     */
    public ListenableFuture<FeatureBean> getFeature(String md5){
        MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean> nativeCallback = 
            new MethodCallback<FeatureBean,net.gdface.facelog.client.thrift.FeatureBean>(
                new Function<net.gdface.facelog.client.thrift.FeatureBean,FeatureBean>() {
                        @Override
                        public FeatureBean apply(net.gdface.facelog.client.thrift.FeatureBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.getFeature(
                md5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeature(String md5,
        FutureCallback<FeatureBean>callback){
        factory.addCallback(getFeature(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatureBytes(java.lang.String)}
     */
    public ListenableFuture<byte[]> getFeatureBytes(String md5){
        MethodCallback<byte[],okio.ByteString> nativeCallback = 
            new MethodCallback<byte[],okio.ByteString>(
                new Function<okio.ByteString,byte[]>() {
                        @Override
                        public byte[] apply(okio.ByteString input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }});
        nativeCallback.service.getFeatureBytes(
                md5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeatureBytes(String md5,
        FutureCallback<byte[]>callback){
        factory.addCallback(getFeatureBytes(md5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatureBytes(java.lang.String,boolean)}
     */
    public ListenableFuture<byte[]> getFeatureBytes(String md5,
        boolean truncation){
        MethodCallback<byte[],okio.ByteString> nativeCallback = 
            new MethodCallback<byte[],okio.ByteString>(
                new Function<okio.ByteString,byte[]>() {
                        @Override
                        public byte[] apply(okio.ByteString input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }});
        nativeCallback.service.getFeatureBytesTruncation(
                md5,
            truncation,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeatureBytes(String md5,
        boolean truncation,
        FutureCallback<byte[]>callback){
        factory.addCallback(getFeatureBytes(md5,truncation), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeatures(java.util.List)}
     */
    public ListenableFuture<List<FeatureBean>> getFeatures(List<String> md5List){
        MethodCallback<List<FeatureBean>,List<net.gdface.facelog.client.thrift.FeatureBean>> nativeCallback = 
            new MethodCallback<List<FeatureBean>,List<net.gdface.facelog.client.thrift.FeatureBean>>(
                new Function<List<net.gdface.facelog.client.thrift.FeatureBean>,List<FeatureBean>>() {
                        @Override
                        public List<FeatureBean> apply(List<net.gdface.facelog.client.thrift.FeatureBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.FeatureBean.class,
                    FeatureBean.class);
                }});
        nativeCallback.service.getFeatures(
                TypeTransformer.getInstance().to(
                    md5List,
                    String.class,
                    String.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeatures(List<String> md5List,
        FutureCallback<List<FeatureBean>>callback){
        factory.addCallback(getFeatures(md5List), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeaturesByPersonIdAndSdkVersion(int,java.lang.String)}
     */
    public ListenableFuture<List<String>> getFeaturesByPersonIdAndSdkVersion(int personId,
        String sdkVersion){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getFeaturesByPersonIdAndSdkVersion(
                personId,
            sdkVersion,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeaturesByPersonIdAndSdkVersion(int personId,
        String sdkVersion,
        FutureCallback<List<String>>callback){
        factory.addCallback(getFeaturesByPersonIdAndSdkVersion(personId,sdkVersion), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeaturesOfImage(java.lang.String)}
     */
    public ListenableFuture<List<String>> getFeaturesOfImage(String imageMd5){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getFeaturesOfImage(
                imageMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeaturesOfImage(String imageMd5,
        FutureCallback<List<String>>callback){
        factory.addCallback(getFeaturesOfImage(imageMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeaturesOfPerson(int)}
     */
    public ListenableFuture<List<String>> getFeaturesOfPerson(int personId){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getFeaturesOfPerson(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeaturesOfPerson(int personId,
        FutureCallback<List<String>>callback){
        factory.addCallback(getFeaturesOfPerson(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getFeaturesPermittedOnDevice(int,boolean,java.lang.String,java.util.List,java.lang.Long)}
     */
    public ListenableFuture<List<String>> getFeaturesPermittedOnDevice(int deviceId,
        boolean ignoreSchedule,
        String sdkVersion,
        List<String> excludeFeatureIds,
        Long timestamp){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getFeaturesPermittedOnDevice(
                deviceId,
            ignoreSchedule,
            sdkVersion,
            TypeTransformer.getInstance().to(
                    excludeFeatureIds,
                    String.class,
                    String.class),
            timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void getFeaturesPermittedOnDevice(int deviceId,
        boolean ignoreSchedule,
        String sdkVersion,
        List<String> excludeFeatureIds,
        Long timestamp,
        FutureCallback<List<String>>callback){
        factory.addCallback(getFeaturesPermittedOnDevice(deviceId,ignoreSchedule,sdkVersion,excludeFeatureIds,timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getGroupPermit(int,int)}
     */
    public ListenableFuture<PermitBean> getGroupPermit(int deviceId,
        int personGroupId){
        MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean> nativeCallback = 
            new MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean>(
                new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                        @Override
                        public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.getGroupPermit(
                deviceId,
            personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getGroupPermit(int deviceId,
        int personGroupId,
        FutureCallback<PermitBean>callback){
        factory.addCallback(getGroupPermit(deviceId,personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getGroupPermitOnDeviceGroup(int,int)}
     */
    public ListenableFuture<PermitBean> getGroupPermitOnDeviceGroup(int deviceGroupId,
        int personGroupId){
        MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean> nativeCallback = 
            new MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean>(
                new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                        @Override
                        public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.getGroupPermitOnDeviceGroup(
                deviceGroupId,
            personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getGroupPermitOnDeviceGroup(int deviceGroupId,
        int personGroupId,
        FutureCallback<PermitBean>callback){
        factory.addCallback(getGroupPermitOnDeviceGroup(deviceGroupId,personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getGroupPermits(int,java.util.List)}
     */
    public ListenableFuture<List<PermitBean>> getGroupPermits(int deviceId,
        List<Integer> personGroupIdList){
        MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = 
            new MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                        @Override
                        public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.getGroupPermits(
                deviceId,
            TypeTransformer.getInstance().to(
                    personGroupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getGroupPermits(int deviceId,
        List<Integer> personGroupIdList,
        FutureCallback<List<PermitBean>>callback){
        factory.addCallback(getGroupPermits(deviceId,personGroupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImage(java.lang.String)}
     */
    public ListenableFuture<ImageBean> getImage(String imageMD5){
        MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean> nativeCallback = 
            new MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean>(
                new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>() {
                        @Override
                        public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }});
        nativeCallback.service.getImage(
                imageMD5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getImage(String imageMD5,
        FutureCallback<ImageBean>callback){
        factory.addCallback(getImage(imageMD5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImage(java.lang.String,java.lang.String)}
     */
    public ListenableFuture<ImageBean> getImage(String primaryKey,
        String refType){
        MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean> nativeCallback = 
            new MethodCallback<ImageBean,net.gdface.facelog.client.thrift.ImageBean>(
                new Function<net.gdface.facelog.client.thrift.ImageBean,ImageBean>() {
                        @Override
                        public ImageBean apply(net.gdface.facelog.client.thrift.ImageBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ImageBean.class,
                    ImageBean.class);
                }});
        nativeCallback.service.getImageRef(
                primaryKey,
            refType,nativeCallback);
        return nativeCallback.feature;
    }
    public void getImage(String primaryKey,
        String refType,
        FutureCallback<ImageBean>callback){
        factory.addCallback(getImage(primaryKey,refType), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImageBytes(java.lang.String)}
     */
    public ListenableFuture<byte[]> getImageBytes(String imageMD5){
        MethodCallback<byte[],okio.ByteString> nativeCallback = 
            new MethodCallback<byte[],okio.ByteString>(
                new Function<okio.ByteString,byte[]>() {
                        @Override
                        public byte[] apply(okio.ByteString input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }});
        nativeCallback.service.getImageBytes(
                imageMD5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getImageBytes(String imageMD5,
        FutureCallback<byte[]>callback){
        factory.addCallback(getImageBytes(imageMD5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImageBytes(java.lang.String,java.lang.String)}
     */
    public ListenableFuture<byte[]> getImageBytes(String primaryKey,
        String refType){
        MethodCallback<byte[],okio.ByteString> nativeCallback = 
            new MethodCallback<byte[],okio.ByteString>(
                new Function<okio.ByteString,byte[]>() {
                        @Override
                        public byte[] apply(okio.ByteString input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    okio.ByteString.class,
                    byte[].class);
                }});
        nativeCallback.service.getImageBytesRef(
                primaryKey,
            refType,nativeCallback);
        return nativeCallback.feature;
    }
    public void getImageBytes(String primaryKey,
        String refType,
        FutureCallback<byte[]>callback){
        factory.addCallback(getImageBytes(primaryKey,refType), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getImagesAssociatedByFeature(java.lang.String)}
     */
    public ListenableFuture<List<String>> getImagesAssociatedByFeature(String featureMd5){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getImagesAssociatedByFeature(
                featureMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void getImagesAssociatedByFeature(String featureMd5,
        FutureCallback<List<String>>callback){
        factory.addCallback(getImagesAssociatedByFeature(featureMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getLogBeansByPersonId(int)}
     */
    public ListenableFuture<List<LogBean>> getLogBeansByPersonId(int personId){
        MethodCallback<List<LogBean>,List<net.gdface.facelog.client.thrift.LogBean>> nativeCallback = 
            new MethodCallback<List<LogBean>,List<net.gdface.facelog.client.thrift.LogBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogBean>,List<LogBean>>() {
                        @Override
                        public List<LogBean> apply(List<net.gdface.facelog.client.thrift.LogBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
                }});
        nativeCallback.service.getLogBeansByPersonId(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getLogBeansByPersonId(int personId,
        FutureCallback<List<LogBean>>callback){
        factory.addCallback(getLogBeansByPersonId(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getMessageQueueParameters(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<MQParam, String>> getMessageQueueParameters(Token token){
        MethodCallback<Map<MQParam, String>,Map<net.gdface.facelog.client.thrift.MQParam,String>> nativeCallback = 
            new MethodCallback<Map<MQParam, String>,Map<net.gdface.facelog.client.thrift.MQParam,String>>(
                new Function<Map<net.gdface.facelog.client.thrift.MQParam,String>,Map<MQParam, String>>() {
                        @Override
                        public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.MQParam.class,
                    String.class,
                    MQParam.class,
                    String.class);
                }});
        nativeCallback.service.getMessageQueueParameters(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getMessageQueueParameters(Token token,
        FutureCallback<Map<MQParam, String>>callback){
        factory.addCallback(getMessageQueueParameters(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPerson(int)}
     */
    public ListenableFuture<PersonBean> getPerson(int personId){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPerson(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPerson(int personId,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPerson(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPerson(int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> getPerson(int personId,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersonReal(
                personId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPerson(int personId,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPerson(personId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonByMobilePhone(java.lang.String)}
     */
    public ListenableFuture<PersonBean> getPersonByMobilePhone(String mobilePhone){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersonByMobilePhone(
                mobilePhone,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonByMobilePhone(String mobilePhone,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPersonByMobilePhone(mobilePhone), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonByMobilePhone(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> getPersonByMobilePhone(String mobilePhone,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersonByMobilePhoneReal(
                mobilePhone,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonByMobilePhone(String mobilePhone,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPersonByMobilePhone(mobilePhone,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonByPapersNum(java.lang.String)}
     */
    public ListenableFuture<PersonBean> getPersonByPapersNum(String papersNum){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersonByPapersNum(
                papersNum,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonByPapersNum(String papersNum,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPersonByPapersNum(papersNum), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonByPapersNum(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> getPersonByPapersNum(String papersNum,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersonByPapersNumReal(
                papersNum,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonByPapersNum(String papersNum,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(getPersonByPapersNum(papersNum,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroup(int)}
     */
    public ListenableFuture<PersonGroupBean> getPersonGroup(int personGroupId){
        MethodCallback<PersonGroupBean,net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback = 
            new MethodCallback<PersonGroupBean,net.gdface.facelog.client.thrift.PersonGroupBean>(
                new Function<net.gdface.facelog.client.thrift.PersonGroupBean,PersonGroupBean>() {
                        @Override
                        public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }});
        nativeCallback.service.getPersonGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonGroup(int personGroupId,
        FutureCallback<PersonGroupBean>callback){
        factory.addCallback(getPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroups(java.util.List)}
     */
    public ListenableFuture<List<PersonGroupBean>> getPersonGroups(List<Integer> groupIdList){
        MethodCallback<List<PersonGroupBean>,List<net.gdface.facelog.client.thrift.PersonGroupBean>> nativeCallback = 
            new MethodCallback<List<PersonGroupBean>,List<net.gdface.facelog.client.thrift.PersonGroupBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PersonGroupBean>,List<PersonGroupBean>>() {
                        @Override
                        public List<PersonGroupBean> apply(List<net.gdface.facelog.client.thrift.PersonGroupBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }});
        nativeCallback.service.getPersonGroups(
                TypeTransformer.getInstance().to(
                    groupIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonGroups(List<Integer> groupIdList,
        FutureCallback<List<PersonGroupBean>>callback){
        factory.addCallback(getPersonGroups(groupIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroupsBelongs(int)}
     */
    public ListenableFuture<List<Integer>> getPersonGroupsBelongs(int personId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getPersonGroupsBelongs(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonGroupsBelongs(int personId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getPersonGroupsBelongs(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonGroupsPermittedBy(int)}
     */
    public ListenableFuture<List<Integer>> getPersonGroupsPermittedBy(int deviceGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getPersonGroupsPermittedBy(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonGroupsPermittedBy(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getPersonGroupsPermittedBy(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonPermit(int,int)}
     */
    public ListenableFuture<PermitBean> getPersonPermit(int deviceId,
        int personId){
        MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean> nativeCallback = 
            new MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean>(
                new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                        @Override
                        public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.getPersonPermit(
                deviceId,
            personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonPermit(int deviceId,
        int personId,
        FutureCallback<PermitBean>callback){
        factory.addCallback(getPersonPermit(deviceId,personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonPermits(int,java.util.List)}
     */
    public ListenableFuture<List<PermitBean>> getPersonPermits(int deviceId,
        List<Integer> personIdList){
        MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = 
            new MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                        @Override
                        public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.getPersonPermits(
                deviceId,
            TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonPermits(int deviceId,
        List<Integer> personIdList,
        FutureCallback<List<PermitBean>>callback){
        factory.addCallback(getPersonPermits(deviceId,personIdList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersons(java.util.List)}
     */
    public ListenableFuture<List<PersonBean>> getPersons(List<Integer> idList){
        MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = 
            new MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                        @Override
                        public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersons(
                TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersons(List<Integer> idList,
        FutureCallback<List<PersonBean>>callback){
        factory.addCallback(getPersons(idList), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersons(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<List<PersonBean>> getPersons(List<Integer> idList,
        Token token){
        MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = 
            new MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                        @Override
                        public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.getPersonsReal(
                TypeTransformer.getInstance().to(
                    idList,
                    Integer.class,
                    Integer.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersons(List<Integer> idList,
        Token token,
        FutureCallback<List<PersonBean>>callback){
        factory.addCallback(getPersons(idList,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonsOfGroup(int)}
     */
    public ListenableFuture<List<Integer>> getPersonsOfGroup(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getPersonsOfGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonsOfGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getPersonsOfGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getPersonsPermittedOnDevice(int,boolean,java.util.List,java.lang.Long)}
     */
    public ListenableFuture<List<Integer>> getPersonsPermittedOnDevice(int deviceId,
        boolean ignoreSchedule,
        List<Integer> excludePersonIds,
        Long timestamp){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getPersonsPermittedOnDevice(
                deviceId,
            ignoreSchedule,
            TypeTransformer.getInstance().to(
                    excludePersonIds,
                    Integer.class,
                    Integer.class),
            timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void getPersonsPermittedOnDevice(int deviceId,
        boolean ignoreSchedule,
        List<Integer> excludePersonIds,
        Long timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getPersonsPermittedOnDevice(deviceId,ignoreSchedule,excludePersonIds,timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getProperties(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<String, String>> getProperties(String prefix,
        Token token){
        MethodCallback<Map<String, String>,Map<String,String>> nativeCallback = 
            new MethodCallback<Map<String, String>,Map<String,String>>(
                new Function<Map<String,String>,Map<String, String>>() {
                        @Override
                        public Map<String, String> apply(Map<String,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getProperties(
                prefix,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getProperties(String prefix,
        Token token,
        FutureCallback<Map<String, String>>callback){
        factory.addCallback(getProperties(prefix,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getProperty(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> getProperty(String key,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.getProperty(
                key,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getProperty(String key,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(getProperty(key,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getRedisParameters(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<MQParam, String>> getRedisParameters(Token token){
        MethodCallback<Map<MQParam, String>,Map<net.gdface.facelog.client.thrift.MQParam,String>> nativeCallback = 
            new MethodCallback<Map<MQParam, String>,Map<net.gdface.facelog.client.thrift.MQParam,String>>(
                new Function<Map<net.gdface.facelog.client.thrift.MQParam,String>,Map<MQParam, String>>() {
                        @Override
                        public Map<MQParam, String> apply(Map<net.gdface.facelog.client.thrift.MQParam,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.MQParam.class,
                    String.class,
                    MQParam.class,
                    String.class);
                }});
        nativeCallback.service.getRedisParameters(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getRedisParameters(Token token,
        FutureCallback<Map<MQParam, String>>callback){
        factory.addCallback(getRedisParameters(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getServiceConfig(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Map<String, String>> getServiceConfig(Token token){
        MethodCallback<Map<String, String>,Map<String,String>> nativeCallback = 
            new MethodCallback<Map<String, String>,Map<String,String>>(
                new Function<Map<String,String>,Map<String, String>>() {
                        @Override
                        public Map<String, String> apply(Map<String,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.getServiceConfig(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getServiceConfig(Token token,
        FutureCallback<Map<String, String>>callback){
        factory.addCallback(getServiceConfig(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getSubDeviceGroup(int)}
     */
    public ListenableFuture<List<Integer>> getSubDeviceGroup(int deviceGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getSubDeviceGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getSubDeviceGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getSubDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getSubPersonGroup(int)}
     */
    public ListenableFuture<List<Integer>> getSubPersonGroup(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.getSubPersonGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void getSubPersonGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(getSubPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#getTargetInfo4PwdOnDevice(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<TmpwdTargetInfo> getTargetInfo4PwdOnDevice(String pwd,
        Token token){
        MethodCallback<TmpwdTargetInfo,net.gdface.facelog.client.thrift.TmpwdTargetInfo> nativeCallback = 
            new MethodCallback<TmpwdTargetInfo,net.gdface.facelog.client.thrift.TmpwdTargetInfo>(
                new Function<net.gdface.facelog.client.thrift.TmpwdTargetInfo,TmpwdTargetInfo>() {
                        @Override
                        public TmpwdTargetInfo apply(net.gdface.facelog.client.thrift.TmpwdTargetInfo input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.TmpwdTargetInfo.class,
                    TmpwdTargetInfo.class);
                }});
        nativeCallback.service.getTargetInfo4PwdOnDevice(
                pwd,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void getTargetInfo4PwdOnDevice(String pwd,
        Token token,
        FutureCallback<TmpwdTargetInfo>callback){
        factory.addCallback(getTargetInfo4PwdOnDevice(pwd,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isDisable(int)}
     */
    public ListenableFuture<Boolean> isDisable(int personId){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isDisable(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void isDisable(int personId,
        FutureCallback<Boolean>callback){
        factory.addCallback(isDisable(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isLocal()}
     */
    public boolean isLocal(){
        return false;
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidAckChannel(java.lang.String)}
     */
    public ListenableFuture<Boolean> isValidAckChannel(String ackChannel){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidAckChannel(
                ackChannel,nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidAckChannel(String ackChannel,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidAckChannel(ackChannel), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidCmdSn(int)}
     */
    public ListenableFuture<Boolean> isValidCmdSn(int cmdSn){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidCmdSn(
                cmdSn,nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidCmdSn(int cmdSn,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidCmdSn(cmdSn), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidDeviceToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> isValidDeviceToken(Token token){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidDeviceToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidDeviceToken(Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidDeviceToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidPassword(java.lang.String,java.lang.String,boolean)}
     */
    public ListenableFuture<Boolean> isValidPassword(String userId,
        String password,
        boolean isMd5){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidPassword(
                userId,
            password,
            isMd5,nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidPassword(String userId,
        String password,
        boolean isMd5,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidPassword(userId,password,isMd5), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidPersonToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> isValidPersonToken(Token token){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidPersonToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidPersonToken(Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidPersonToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidRootToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> isValidRootToken(Token token){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidRootToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidRootToken(Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidRootToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> isValidToken(Token token){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidToken(Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#isValidUserToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Boolean> isValidUserToken(Token token){
        MethodCallback<Boolean,Boolean> nativeCallback = 
            new MethodCallback<Boolean,Boolean>(
                new Function<Boolean,Boolean>() {
                        @Override
                        public Boolean apply(Boolean input) {
                            return input;
                }});
        nativeCallback.service.isValidUserToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void isValidUserToken(Token token,
        FutureCallback<Boolean>callback){
        factory.addCallback(isValidUserToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#iso8601Time()}
     */
    public ListenableFuture<String> iso8601Time(){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.iso8601Time(
                nativeCallback);
        return nativeCallback.feature;
    }
    public void iso8601Time(FutureCallback<String>callback){
        factory.addCallback(iso8601Time(), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#listOfParentForDeviceGroup(int)}
     */
    public ListenableFuture<List<Integer>> listOfParentForDeviceGroup(int deviceGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.listOfParentForDeviceGroup(
                deviceGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void listOfParentForDeviceGroup(int deviceGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(listOfParentForDeviceGroup(deviceGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#listOfParentForPersonGroup(int)}
     */
    public ListenableFuture<List<Integer>> listOfParentForPersonGroup(int personGroupId){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.listOfParentForPersonGroup(
                personGroupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void listOfParentForPersonGroup(int personGroupId,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(listOfParentForPersonGroup(personGroupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadAllPerson()}
     */
    public ListenableFuture<List<Integer>> loadAllPerson(){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadAllPerson(
                nativeCallback);
        return nativeCallback.feature;
    }
    public void loadAllPerson(FutureCallback<List<Integer>>callback){
        factory.addCallback(loadAllPerson(), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<DeviceBean>> loadDeviceByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<DeviceBean>,List<net.gdface.facelog.client.thrift.DeviceBean>> nativeCallback = 
            new MethodCallback<List<DeviceBean>,List<net.gdface.facelog.client.thrift.DeviceBean>>(
                new Function<List<net.gdface.facelog.client.thrift.DeviceBean>,List<DeviceBean>>() {
                        @Override
                        public List<DeviceBean> apply(List<net.gdface.facelog.client.thrift.DeviceBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.loadDeviceByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDeviceByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<DeviceBean>>callback){
        factory.addCallback(loadDeviceByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceGroupByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<Integer>> loadDeviceGroupByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadDeviceGroupByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDeviceGroupByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceGroupByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceGroupIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadDeviceGroupIdByWhere(String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadDeviceGroupIdByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDeviceGroupIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceGroupIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDeviceIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadDeviceIdByWhere(String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadDeviceIdByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDeviceIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDeviceIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDistinctIntegerColumn(java.lang.String,java.lang.String,java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadDistinctIntegerColumn(String table,
        String column,
        String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadDistinctIntegerColumn(
                table,
            column,
            where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDistinctIntegerColumn(String table,
        String column,
        String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadDistinctIntegerColumn(table,column,where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadDistinctStringColumn(java.lang.String,java.lang.String,java.lang.String)}
     */
    public ListenableFuture<List<String>> loadDistinctStringColumn(String table,
        String column,
        String where){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.loadDistinctStringColumn(
                table,
            column,
            where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadDistinctStringColumn(String table,
        String column,
        String where,
        FutureCallback<List<String>>callback){
        factory.addCallback(loadDistinctStringColumn(table,column,where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadErrorLogByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<ErrorLogBean>> loadErrorLogByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<ErrorLogBean>,List<net.gdface.facelog.client.thrift.ErrorLogBean>> nativeCallback = 
            new MethodCallback<List<ErrorLogBean>,List<net.gdface.facelog.client.thrift.ErrorLogBean>>(
                new Function<List<net.gdface.facelog.client.thrift.ErrorLogBean>,List<ErrorLogBean>>() {
                        @Override
                        public List<ErrorLogBean> apply(List<net.gdface.facelog.client.thrift.ErrorLogBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.ErrorLogBean.class,
                    ErrorLogBean.class);
                }});
        nativeCallback.service.loadErrorLogByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadErrorLogByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<ErrorLogBean>>callback){
        factory.addCallback(loadErrorLogByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadFeatureMd5ByUpdate(java.lang.String)}
     */
    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(String timestamp){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.loadFeatureMd5ByUpdateTimeStr(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadFeatureMd5ByUpdate(String timestamp,
        FutureCallback<List<String>>callback){
        factory.addCallback(loadFeatureMd5ByUpdate(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadFeatureMd5ByUpdate(long)}
     */
    public ListenableFuture<List<String>> loadFeatureMd5ByUpdate(long timestamp){
        MethodCallback<List<String>,List<String>> nativeCallback = 
            new MethodCallback<List<String>,List<String>>(
                new Function<List<String>,List<String>>() {
                        @Override
                        public List<String> apply(List<String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.loadFeatureMd5ByUpdate(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadFeatureMd5ByUpdate(long timestamp,
        FutureCallback<List<String>>callback){
        factory.addCallback(loadFeatureMd5ByUpdate(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<LogBean>> loadLogByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<LogBean>,List<net.gdface.facelog.client.thrift.LogBean>> nativeCallback = 
            new MethodCallback<List<LogBean>,List<net.gdface.facelog.client.thrift.LogBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogBean>,List<LogBean>>() {
                        @Override
                        public List<LogBean> apply(List<net.gdface.facelog.client.thrift.LogBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogBean.class,
                    LogBean.class);
                }});
        nativeCallback.service.loadLogByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadLogByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<LogBean>>callback){
        factory.addCallback(loadLogByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogLightByVerifyTime(java.lang.String,int,int)}
     */
    public ListenableFuture<List<LogLightBean>> loadLogLightByVerifyTime(String timestamp,
        int startRow,
        int numRows){
        MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>> nativeCallback = 
            new MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>() {
                        @Override
                        public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }});
        nativeCallback.service.loadLogLightByVerifyTimeTimestr(
                timestamp,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadLogLightByVerifyTime(String timestamp,
        int startRow,
        int numRows,
        FutureCallback<List<LogLightBean>>callback){
        factory.addCallback(loadLogLightByVerifyTime(timestamp,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogLightByVerifyTime(long,int,int)}
     */
    public ListenableFuture<List<LogLightBean>> loadLogLightByVerifyTime(long timestamp,
        int startRow,
        int numRows){
        MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>> nativeCallback = 
            new MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>() {
                        @Override
                        public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }});
        nativeCallback.service.loadLogLightByVerifyTime(
                timestamp,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadLogLightByVerifyTime(long timestamp,
        int startRow,
        int numRows,
        FutureCallback<List<LogLightBean>>callback){
        factory.addCallback(loadLogLightByVerifyTime(timestamp,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadLogLightByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<LogLightBean>> loadLogLightByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>> nativeCallback = 
            new MethodCallback<List<LogLightBean>,List<net.gdface.facelog.client.thrift.LogLightBean>>(
                new Function<List<net.gdface.facelog.client.thrift.LogLightBean>,List<LogLightBean>>() {
                        @Override
                        public List<LogLightBean> apply(List<net.gdface.facelog.client.thrift.LogLightBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.LogLightBean.class,
                    LogLightBean.class);
                }});
        nativeCallback.service.loadLogLightByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadLogLightByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<LogLightBean>>callback){
        factory.addCallback(loadLogLightByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPermitByUpdate(java.lang.String)}
     */
    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(String timestamp){
        MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = 
            new MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                        @Override
                        public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.loadPermitByUpdateTimestr(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPermitByUpdate(String timestamp,
        FutureCallback<List<PermitBean>>callback){
        factory.addCallback(loadPermitByUpdate(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPermitByUpdate(long)}
     */
    public ListenableFuture<List<PermitBean>> loadPermitByUpdate(long timestamp){
        MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>> nativeCallback = 
            new MethodCallback<List<PermitBean>,List<net.gdface.facelog.client.thrift.PermitBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PermitBean>,List<PermitBean>>() {
                        @Override
                        public List<PermitBean> apply(List<net.gdface.facelog.client.thrift.PermitBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.loadPermitByUpdate(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPermitByUpdate(long timestamp,
        FutureCallback<List<PermitBean>>callback){
        factory.addCallback(loadPermitByUpdate(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<PersonBean>> loadPersonByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = 
            new MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                        @Override
                        public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.loadPersonByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<PersonBean>>callback){
        factory.addCallback(loadPersonByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonByWhere(java.lang.String,int,int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<List<PersonBean>> loadPersonByWhere(String where,
        int startRow,
        int numRows,
        Token token){
        MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>> nativeCallback = 
            new MethodCallback<List<PersonBean>,List<net.gdface.facelog.client.thrift.PersonBean>>(
                new Function<List<net.gdface.facelog.client.thrift.PersonBean>,List<PersonBean>>() {
                        @Override
                        public List<PersonBean> apply(List<net.gdface.facelog.client.thrift.PersonBean> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.loadPersonByWhereReal(
                where,
            startRow,
            numRows,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonByWhere(String where,
        int startRow,
        int numRows,
        Token token,
        FutureCallback<List<PersonBean>>callback){
        factory.addCallback(loadPersonByWhere(where,startRow,numRows,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonGroupByWhere(java.lang.String,int,int)}
     */
    public ListenableFuture<List<Integer>> loadPersonGroupByWhere(String where,
        int startRow,
        int numRows){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonGroupByWhere(
                where,
            startRow,
            numRows,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonGroupByWhere(String where,
        int startRow,
        int numRows,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonGroupByWhere(where,startRow,numRows), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonGroupIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadPersonGroupIdByWhere(String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonGroupIdByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonGroupIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonGroupIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonIdByUpdateTime(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(String timestamp){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonIdByUpdateTimeTimeStr(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonIdByUpdateTime(String timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonIdByUpdateTime(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonIdByUpdateTime(long)}
     */
    public ListenableFuture<List<Integer>> loadPersonIdByUpdateTime(long timestamp){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonIdByUpdateTime(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonIdByUpdateTime(long timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonIdByUpdateTime(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadPersonIdByWhere(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadPersonIdByWhere(String where){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadPersonIdByWhere(
                where,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadPersonIdByWhere(String where,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadPersonIdByWhere(where), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadUpdatedPersons(java.lang.String)}
     */
    public ListenableFuture<List<Integer>> loadUpdatedPersons(String timestamp){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadUpdatedPersonsTimestr(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadUpdatedPersons(String timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadUpdatedPersons(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#loadUpdatedPersons(long)}
     */
    public ListenableFuture<List<Integer>> loadUpdatedPersons(long timestamp){
        MethodCallback<List<Integer>,List<Integer>> nativeCallback = 
            new MethodCallback<List<Integer>,List<Integer>>(
                new Function<List<Integer>,List<Integer>>() {
                        @Override
                        public List<Integer> apply(List<Integer> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Integer.class,
                    Integer.class);
                }});
        nativeCallback.service.loadUpdatedPersons(
                timestamp,nativeCallback);
        return nativeCallback.feature;
    }
    public void loadUpdatedPersons(long timestamp,
        FutureCallback<List<Integer>>callback){
        factory.addCallback(loadUpdatedPersons(timestamp), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#offline(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> offline(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.offline(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void offline(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(offline(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#online(net.gdface.facelog.db.DeviceBean)}
     */
    public ListenableFuture<Token> online(DeviceBean device){
        MethodCallback<Token,net.gdface.facelog.client.thrift.Token> nativeCallback = 
            new MethodCallback<Token,net.gdface.facelog.client.thrift.Token>(
                new Function<net.gdface.facelog.client.thrift.Token,Token>() {
                        @Override
                        public Token apply(net.gdface.facelog.client.thrift.Token input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.Token.class,
                    Token.class);
                }});
        nativeCallback.service.online(
                TypeTransformer.getInstance().to(
                    device,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void online(DeviceBean device,
        FutureCallback<Token>callback){
        factory.addCallback(online(device), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#registerDevice(net.gdface.facelog.db.DeviceBean)}
     */
    public ListenableFuture<DeviceBean> registerDevice(DeviceBean newDevice){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.registerDevice(
                TypeTransformer.getInstance().to(
                    newDevice,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void registerDevice(DeviceBean newDevice,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(registerDevice(newDevice), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#releasePersonToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> releasePersonToken(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.releasePersonToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void releasePersonToken(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(releasePersonToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#releaseRootToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> releaseRootToken(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.releaseRootToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void releaseRootToken(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(releaseRootToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#releaseUserToken(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> releaseUserToken(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.releaseUserToken(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void releaseUserToken(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(releaseUserToken(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#replaceFeature(java.lang.Integer,java.lang.String,boolean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> replaceFeature(Integer personId,
        String featureMd5,
        boolean deleteOldFeatureImage,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.replaceFeature(
                personId,
            featureMd5,
            deleteOldFeatureImage,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void replaceFeature(Integer personId,
        String featureMd5,
        boolean deleteOldFeatureImage,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(replaceFeature(personId,featureMd5,deleteOldFeatureImage,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#rootGroupOfDevice(java.lang.Integer)}
     */
    public ListenableFuture<Integer> rootGroupOfDevice(Integer deviceId){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.rootGroupOfDevice(
                deviceId,nativeCallback);
        return nativeCallback.feature;
    }
    public void rootGroupOfDevice(Integer deviceId,
        FutureCallback<Integer>callback){
        factory.addCallback(rootGroupOfDevice(deviceId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#rootGroupOfDeviceGroup(java.lang.Integer)}
     */
    public ListenableFuture<Integer> rootGroupOfDeviceGroup(Integer groupId){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.rootGroupOfDeviceGroup(
                groupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void rootGroupOfDeviceGroup(Integer groupId,
        FutureCallback<Integer>callback){
        factory.addCallback(rootGroupOfDeviceGroup(groupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#rootGroupOfPerson(java.lang.Integer)}
     */
    public ListenableFuture<Integer> rootGroupOfPerson(Integer personId){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.rootGroupOfPerson(
                personId,nativeCallback);
        return nativeCallback.feature;
    }
    public void rootGroupOfPerson(Integer personId,
        FutureCallback<Integer>callback){
        factory.addCallback(rootGroupOfPerson(personId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#rootGroupOfPersonGroup(java.lang.Integer)}
     */
    public ListenableFuture<Integer> rootGroupOfPersonGroup(Integer groupId){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.rootGroupOfPersonGroup(
                groupId,nativeCallback);
        return nativeCallback.feature;
    }
    public void rootGroupOfPersonGroup(Integer groupId,
        FutureCallback<Integer>callback){
        factory.addCallback(rootGroupOfPersonGroup(groupId), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#runCmd(java.util.List,boolean,java.lang.String,java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> runCmd(List<Integer> target,
        boolean group,
        String cmdpath,
        String jsonArgs,
        String ackChannel,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.runCmd(
                TypeTransformer.getInstance().to(
                    target,
                    Integer.class,
                    Integer.class),
            group,
            cmdpath,
            jsonArgs,
            ackChannel,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void runCmd(List<Integer> target,
        boolean group,
        String cmdpath,
        String jsonArgs,
        String ackChannel,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(runCmd(target,group,cmdpath,jsonArgs,ackChannel,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#runTask(java.lang.String,java.lang.String,java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> runTask(String taskQueue,
        String cmdpath,
        String jsonArgs,
        String ackChannel,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.runTask(
                taskQueue,
            cmdpath,
            jsonArgs,
            ackChannel,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void runTask(String taskQueue,
        String cmdpath,
        String jsonArgs,
        String ackChannel,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(runTask(taskQueue,cmdpath,jsonArgs,ackChannel,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#runTaskSync(java.lang.String,java.lang.String,java.lang.String,int,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> runTaskSync(String taskQueue,
        String cmdpath,
        String jsonArgs,
        int timeoutSecs,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.runTaskSync(
                taskQueue,
            cmdpath,
            jsonArgs,
            timeoutSecs,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void runTaskSync(String taskQueue,
        String cmdpath,
        String jsonArgs,
        int timeoutSecs,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(runTaskSync(taskQueue,cmdpath,jsonArgs,timeoutSecs,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveDevice(net.gdface.facelog.db.DeviceBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceBean> saveDevice(DeviceBean deviceBean,
        Token token){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.saveDevice(
                TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void saveDevice(DeviceBean deviceBean,
        Token token,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(saveDevice(deviceBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveDeviceGroup(net.gdface.facelog.db.DeviceGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceGroupBean> saveDeviceGroup(DeviceGroupBean deviceGroupBean,
        Token token){
        MethodCallback<DeviceGroupBean,net.gdface.facelog.client.thrift.DeviceGroupBean> nativeCallback = 
            new MethodCallback<DeviceGroupBean,net.gdface.facelog.client.thrift.DeviceGroupBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceGroupBean,DeviceGroupBean>() {
                        @Override
                        public DeviceGroupBean apply(net.gdface.facelog.client.thrift.DeviceGroupBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class,
                    DeviceGroupBean.class);
                }});
        nativeCallback.service.saveDeviceGroup(
                TypeTransformer.getInstance().to(
                    deviceGroupBean,
                    DeviceGroupBean.class,
                    net.gdface.facelog.client.thrift.DeviceGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void saveDeviceGroup(DeviceGroupBean deviceGroupBean,
        Token token,
        FutureCallback<DeviceGroupBean>callback){
        factory.addCallback(saveDeviceGroup(deviceGroupBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePermit(int,int,java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PermitBean> savePermit(int deviceGroupId,
        int personGroupId,
        String column,
        String value,
        Token token){
        MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean> nativeCallback = 
            new MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean>(
                new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                        @Override
                        public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.savePermitWithColumn(
                deviceGroupId,
            personGroupId,
            column,
            value,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePermit(int deviceGroupId,
        int personGroupId,
        String column,
        String value,
        Token token,
        FutureCallback<PermitBean>callback){
        factory.addCallback(savePermit(deviceGroupId,personGroupId,column,value,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePermit(net.gdface.facelog.db.PermitBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PermitBean> savePermit(PermitBean permitBean,
        Token token){
        MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean> nativeCallback = 
            new MethodCallback<PermitBean,net.gdface.facelog.client.thrift.PermitBean>(
                new Function<net.gdface.facelog.client.thrift.PermitBean,PermitBean>() {
                        @Override
                        public PermitBean apply(net.gdface.facelog.client.thrift.PermitBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PermitBean.class,
                    PermitBean.class);
                }});
        nativeCallback.service.savePermit(
                TypeTransformer.getInstance().to(
                    permitBean,
                    PermitBean.class,
                    net.gdface.facelog.client.thrift.PermitBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePermit(PermitBean permitBean,
        Token token,
        FutureCallback<PermitBean>callback){
        factory.addCallback(savePermit(permitBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],java.lang.String,byte[],net.gdface.facelog.db.FaceBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean personBean,
        byte[] idPhoto,
        byte[] feature,
        String featureVersion,
        byte[] featureImage,
        FaceBean faceBean,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonFull(
                TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            featureVersion,
            TypeTransformer.getInstance().to(
                    featureImage,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    faceBean,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean personBean,
        byte[] idPhoto,
        byte[] feature,
        String featureVersion,
        byte[] featureImage,
        FaceBean faceBean,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(personBean,idPhoto,feature,featureVersion,featureImage,faceBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],java.lang.String,java.util.List,java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean personBean,
        byte[] idPhoto,
        byte[] feature,
        String featureVersion,
        List<byte[]> photos,
        List<FaceBean> faces,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhotoAndFeatureMultiImage(
                TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            featureVersion,
            TypeTransformer.getInstance().to(
                    photos,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    faces,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean personBean,
        byte[] idPhoto,
        byte[] feature,
        String featureVersion,
        List<byte[]> photos,
        List<FaceBean> faces,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(personBean,idPhoto,feature,featureVersion,photos,faces,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],byte[],java.lang.String,java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean personBean,
        byte[] idPhoto,
        byte[] feature,
        String featureVersion,
        List<FaceBean> faceBeans,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhotoAndFeatureMultiFaces(
                TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    feature,
                    byte[].class,
                    okio.ByteString.class),
            featureVersion,
            TypeTransformer.getInstance().to(
                    faceBeans,
                    FaceBean.class,
                    net.gdface.facelog.client.thrift.FaceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean personBean,
        byte[] idPhoto,
        byte[] feature,
        String featureVersion,
        List<FaceBean> faceBeans,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(personBean,idPhoto,feature,featureVersion,faceBeans,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean personBean,
        byte[] idPhoto,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhoto(
                TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean personBean,
        byte[] idPhoto,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(personBean,idPhoto,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,byte[],net.gdface.facelog.db.FeatureBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean personBean,
        byte[] idPhoto,
        FeatureBean featureBean,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhotoAndFeature(
                TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    idPhoto,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    featureBean,
                    FeatureBean.class,
                    net.gdface.facelog.client.thrift.FeatureBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean personBean,
        byte[] idPhoto,
        FeatureBean featureBean,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(personBean,idPhoto,featureBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean personBean,
        String idPhotoMd5,
        String featureMd5,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePersonWithPhotoAndFeatureSaved(
                TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            idPhotoMd5,
            featureMd5,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean personBean,
        String idPhotoMd5,
        String featureMd5,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(personBean,idPhotoMd5,featureMd5,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePerson(net.gdface.facelog.db.PersonBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonBean> savePerson(PersonBean personBean,
        Token token){
        MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean> nativeCallback = 
            new MethodCallback<PersonBean,net.gdface.facelog.client.thrift.PersonBean>(
                new Function<net.gdface.facelog.client.thrift.PersonBean,PersonBean>() {
                        @Override
                        public PersonBean apply(net.gdface.facelog.client.thrift.PersonBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonBean.class,
                    PersonBean.class);
                }});
        nativeCallback.service.savePerson(
                TypeTransformer.getInstance().to(
                    personBean,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePerson(PersonBean personBean,
        Token token,
        FutureCallback<PersonBean>callback){
        factory.addCallback(savePerson(personBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersonGroup(net.gdface.facelog.db.PersonGroupBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<PersonGroupBean> savePersonGroup(PersonGroupBean personGroupBean,
        Token token){
        MethodCallback<PersonGroupBean,net.gdface.facelog.client.thrift.PersonGroupBean> nativeCallback = 
            new MethodCallback<PersonGroupBean,net.gdface.facelog.client.thrift.PersonGroupBean>(
                new Function<net.gdface.facelog.client.thrift.PersonGroupBean,PersonGroupBean>() {
                        @Override
                        public PersonGroupBean apply(net.gdface.facelog.client.thrift.PersonGroupBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class,
                    PersonGroupBean.class);
                }});
        nativeCallback.service.savePersonGroup(
                TypeTransformer.getInstance().to(
                    personGroupBean,
                    PersonGroupBean.class,
                    net.gdface.facelog.client.thrift.PersonGroupBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePersonGroup(PersonGroupBean personGroupBean,
        Token token,
        FutureCallback<PersonGroupBean>callback){
        factory.addCallback(savePersonGroup(personGroupBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersons(java.util.List,java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Integer> savePersons(List<byte[]> photos,
        List<PersonBean> persons,
        Token token){
        MethodCallback<Integer,Integer> nativeCallback = 
            new MethodCallback<Integer,Integer>(
                new Function<Integer,Integer>() {
                        @Override
                        public Integer apply(Integer input) {
                            return input;
                }});
        nativeCallback.service.savePersonsWithPhoto(
                TypeTransformer.getInstance().to(
                    photos,
                    byte[].class,
                    okio.ByteString.class),
            TypeTransformer.getInstance().to(
                    persons,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePersons(List<byte[]> photos,
        List<PersonBean> persons,
        Token token,
        FutureCallback<Integer>callback){
        factory.addCallback(savePersons(photos,persons,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#savePersons(java.util.List,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> savePersons(List<PersonBean> persons,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.savePersons(
                TypeTransformer.getInstance().to(
                    persons,
                    PersonBean.class,
                    net.gdface.facelog.client.thrift.PersonBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void savePersons(List<PersonBean> persons,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(savePersons(persons,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#saveServiceConfig(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> saveServiceConfig(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.saveServiceConfig(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void saveServiceConfig(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(saveServiceConfig(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#sdkTaskQueueOf(java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> sdkTaskQueueOf(String task,
        String sdkVersion,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.sdkTaskQueueOf(
                task,
            sdkVersion,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void sdkTaskQueueOf(String task,
        String sdkVersion,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(sdkTaskQueueOf(task,sdkVersion,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setPersonExpiryDate(int,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setPersonExpiryDate(int personId,
        String expiryDate,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setPersonExpiryDateTimeStr(
                personId,
            expiryDate,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setPersonExpiryDate(int personId,
        String expiryDate,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setPersonExpiryDate(personId,expiryDate,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setPersonExpiryDate(int,long,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setPersonExpiryDate(int personId,
        long expiryDate,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setPersonExpiryDate(
                personId,
            expiryDate,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setPersonExpiryDate(int personId,
        long expiryDate,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setPersonExpiryDate(personId,expiryDate,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setPersonExpiryDate(java.util.List,long,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setPersonExpiryDate(List<Integer> personIdList,
        long expiryDate,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setPersonExpiryDateList(
                TypeTransformer.getInstance().to(
                    personIdList,
                    Integer.class,
                    Integer.class),
            expiryDate,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setPersonExpiryDate(List<Integer> personIdList,
        long expiryDate,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setPersonExpiryDate(personIdList,expiryDate,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setProperties(java.util.Map,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setProperties(Map<String, String> config,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setProperties(
                TypeTransformer.getInstance().to(
                    config,
                    String.class,
                    String.class,
                    String.class,
                    String.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setProperties(Map<String, String> config,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setProperties(config,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#setProperty(java.lang.String,java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> setProperty(String key,
        String value,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.setProperty(
                key,
            value,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void setProperty(String key,
        String value,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(setProperty(key,value,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#taskQueueOf(java.lang.String,net.gdface.facelog.Token)}
     */
    public ListenableFuture<String> taskQueueOf(String task,
        Token token){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.taskQueueOf(
                task,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void taskQueueOf(String task,
        Token token,
        FutureCallback<String>callback){
        factory.addCallback(taskQueueOf(task,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#unbindBorder(java.lang.Integer,java.lang.Integer,net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> unbindBorder(Integer personGroupId,
        Integer deviceGroupId,
        Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.unbindBorder(
                personGroupId,
            deviceGroupId,
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void unbindBorder(Integer personGroupId,
        Integer deviceGroupId,
        Token token,
        FutureCallback<Void>callback){
        factory.addCallback(unbindBorder(personGroupId,deviceGroupId,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#unregisterDevice(net.gdface.facelog.Token)}
     */
    public ListenableFuture<Void> unregisterDevice(Token token){
        MethodCallback<Void,Void> nativeCallback = 
            new MethodCallback<Void,Void>(
                new Function<Void,Void>() {
                        @Override
                        public Void apply(Void input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    Void.class,
                    Void.class);
                }});
        nativeCallback.service.unregisterDevice(
                TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void unregisterDevice(Token token,
        FutureCallback<Void>callback){
        factory.addCallback(unregisterDevice(token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#updateDevice(net.gdface.facelog.db.DeviceBean,net.gdface.facelog.Token)}
     */
    public ListenableFuture<DeviceBean> updateDevice(DeviceBean deviceBean,
        Token token){
        MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean> nativeCallback = 
            new MethodCallback<DeviceBean,net.gdface.facelog.client.thrift.DeviceBean>(
                new Function<net.gdface.facelog.client.thrift.DeviceBean,DeviceBean>() {
                        @Override
                        public DeviceBean apply(net.gdface.facelog.client.thrift.DeviceBean input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    net.gdface.facelog.client.thrift.DeviceBean.class,
                    DeviceBean.class);
                }});
        nativeCallback.service.updateDevice(
                TypeTransformer.getInstance().to(
                    deviceBean,
                    DeviceBean.class,
                    net.gdface.facelog.client.thrift.DeviceBean.class),
            TypeTransformer.getInstance().to(
                    token,
                    Token.class,
                    net.gdface.facelog.client.thrift.Token.class),nativeCallback);
        return nativeCallback.feature;
    }
    public void updateDevice(DeviceBean deviceBean,
        Token token,
        FutureCallback<DeviceBean>callback){
        factory.addCallback(updateDevice(deviceBean,token), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#version()}
     */
    public ListenableFuture<String> version(){
        MethodCallback<String,String> nativeCallback = 
            new MethodCallback<String,String>(
                new Function<String,String>() {
                        @Override
                        public String apply(String input) {
                            return input;
                }});
        nativeCallback.service.version(
                nativeCallback);
        return nativeCallback.feature;
    }
    public void version(FutureCallback<String>callback){
        factory.addCallback(version(), callback);
    }
    /**
     * see also {@link net.gdface.facelog.IFaceLog#versionInfo()}
     */
    public ListenableFuture<Map<String, String>> versionInfo(){
        MethodCallback<Map<String, String>,Map<String,String>> nativeCallback = 
            new MethodCallback<Map<String, String>,Map<String,String>>(
                new Function<Map<String,String>,Map<String, String>>() {
                        @Override
                        public Map<String, String> apply(Map<String,String> input) {
                            return TypeTransformer.getInstance().to(
                    input,
                    String.class,
                    String.class,
                    String.class,
                    String.class);
                }});
        nativeCallback.service.versionInfo(
                nativeCallback);
        return nativeCallback.feature;
    }
    public void versionInfo(FutureCallback<Map<String, String>>callback){
        factory.addCallback(versionInfo(), callback);
    }
}