/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import gu.dtalk.MenuItem;
import gu.dtalk.cmd.CmdManager;
import gu.dtalk.cmd.TaskManager;
import gu.dtalk.engine.BaseDispatcher;
import gu.dtalk.engine.CmdDispatcher;
import gu.dtalk.engine.TaskDispatcher;
import gu.simplemq.Channel;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.ISubscriber;
import gu.simplemq.MessageQueueFactorys;
import gu.simplemq.json.BaseJsonEncoder;
import gu.sql2java.SimpleLog;
import java.io.Closeable;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.gdface.facelog.CommonConstant;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.ServiceSecurityException;
import net.gdface.facelog.Token;
import net.gdface.facelog.client.TokenHelper;
import net.gdface.facelog.client.dtalk.DtalkEngineForFacelog;
import net.gdface.facelog.db.DeviceBean;
import net.gdface.facelog.db.PersonBean;
import net.gdface.facelog.hb.DeviceHeartbeat;
import net.gdface.facelog.hb.DynamicChannelListener;
import net.gdface.facelog.mq.BaseServiceHeartbeatListener;
import net.gdface.facelog.mq.ServiceHeartbeatAdapter;
import net.gdface.facelog.mq.ServiceHeartbeatListener;
import net.gdface.facelog.mq.ServiceHeartbeatPackage;
import net.gdface.facelog.thrift.IFaceLogThriftClient;
import net.gdface.facelog.thrift.IFaceLogThriftClientAsync;
import net.gdface.thrift.ClientFactory;
import net.gdface.utils.Delegator;
import net.gdface.utils.NetworkUtil;

public class ClientExtendTools
implements CommonConstant {
    private final IFaceLog syncInstance;
    private final IFaceLogThriftClientAsync asyncInstance;
    private final ClientFactory factory;
    private TokenHelper tokenHelper;
    private volatile Map<MQParam, String> redisParameters = null;
    private volatile Map<MQParam, String> mqParameters = null;
    private Map<String, String> faceapiParameters = null;
    private final ServiceHeartbeatListener tokenRefreshListener = new BaseServiceHeartbeatListener(){

        public boolean doServiceOnline(ServiceHeartbeatPackage heartbeatPackage) {
            return ClientExtendTools.this.tokenRefresh != null && ClientExtendTools.this.tokenRefresh.refresh();
        }
    };
    private final DispatcherListener dispatcherListener = new DispatcherListener();
    private TokenRefresh tokenRefresh;
    public final Function<Integer, Integer> deviceGroupIdGetter = new Function<Integer, Integer>(){

        public Integer apply(Integer input) {
            try {
                DeviceBean device = ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.getDevice(input.intValue()) : (DeviceBean)ClientExtendTools.this.asyncInstance.getDevice(input).get();
                return null == device ? null : device.getGroupId();
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Function<Integer, List<Integer>> personGroupBelonsGetter = new Function<Integer, List<Integer>>(){

        public List<Integer> apply(Integer personId) {
            try {
                return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.getPersonGroupsBelongs(personId.intValue()) : (List)ClientExtendTools.this.asyncInstance.getPersonGroupsBelongs(personId).get();
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Integer> cmdSnValidator = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidCmdSn(input.intValue()) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidCmdSn(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<String> ackChannelValidator = new Predicate<String>(){

        public boolean apply(String input) {
            try {
                return null == input || input.isEmpty() ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidAckChannel(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidAckChannel(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Token> deviceTokenValidator = new Predicate<Token>(){

        public boolean apply(Token input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidDeviceToken(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidDeviceToken(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Token> personTokenValidator = new Predicate<Token>(){

        public boolean apply(Token input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidPersonToken(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidPersonToken(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Predicate<Token> rootTokenValidator = new Predicate<Token>(){

        public boolean apply(Token input) {
            try {
                return null == input ? false : (ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.isValidRootToken(input) : ((Boolean)ClientExtendTools.this.asyncInstance.isValidRootToken(input).get()).booleanValue());
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };
    public final Function<Token, Integer> tokenRank = new Function<Token, Integer>(){

        public Integer apply(Token input) {
            try {
                if (null != input) {
                    switch (input.getType()) {
                        case ROOT: {
                            if (!ClientExtendTools.this.rootTokenValidator.apply((Object)input)) break;
                            return 4;
                        }
                        case PERSON: {
                            if (!ClientExtendTools.this.personTokenValidator.apply((Object)input)) break;
                            PersonBean bean = ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.getPerson(input.getId()) : (PersonBean)ClientExtendTools.this.asyncInstance.getPerson(input.getId()).get();
                            Integer rank = bean.getRank();
                            return rank != null ? rank : 0;
                        }
                    }
                }
                return -1;
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    };

    private static <T> T unwrap(Object value, Class<T> clazz) {
        if (Proxy.isProxyClass(value.getClass())) {
            return ClientExtendTools.unwrap(Proxy.getInvocationHandler(value), clazz);
        }
        if (value instanceof Delegator) {
            return ClientExtendTools.unwrap(((Delegator)value).delegate(), clazz);
        }
        return clazz.cast(value);
    }

    ClientExtendTools(IFaceLog syncInstance) {
        this.syncInstance = (IFaceLog)Preconditions.checkNotNull((Object)syncInstance, (Object)"syncInstance is null");
        this.asyncInstance = null;
        this.factory = ClientExtendTools.unwrap(syncInstance, IFaceLogThriftClient.class).getFactory();
    }

    ClientExtendTools(IFaceLogThriftClientAsync asyncInstance) {
        this.syncInstance = null;
        this.asyncInstance = (IFaceLogThriftClientAsync)Preconditions.checkNotNull((Object)asyncInstance, (Object)"asyncInstance is null");
        this.factory = asyncInstance.getFactory();
    }

    public String insteadHostIfLocalhost(String host) {
        if (NetworkUtil.isLoopbackAddress((String)host) || "landfaceloghost".equals(host)) {
            return this.factory.getHostAndPort().getHost();
        }
        return host;
    }

    public HostAndPort insteadHostIfLocalhost(HostAndPort host) {
        return HostAndPort.fromParts((String)this.insteadHostIfLocalhost(host.getHost()), (int)host.getPort());
    }

    public URI insteadHostIfLocalhost(URI uri) {
        if (null != uri && (NetworkUtil.isLoopbackAddress((String)uri.getHost()) || "landfaceloghost".equals(uri.getHost()))) {
            try {
                return new URI(uri.getScheme(), uri.getUserInfo(), this.factory.getHostAndPort().getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri;
    }

    public URL insteadHostIfLocalhost(URL url) {
        if (null != url && (NetworkUtil.isLoopbackAddress((String)url.getHost()) || "landfaceloghost".equals(url.getHost()))) {
            try {
                return new URL(url.getProtocol(), this.factory.getHostAndPort().getHost(), url.getPort(), url.getFile());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public String insteadHostJsonIfLocalhost(String json) {
        if (!Strings.isNullOrEmpty((String)json)) {
            Map map = MessageQueueFactorys.asMQConnParam2((String)json);
            for (Map.Entry entry : map.entrySet()) {
                try {
                    URI uri = new URI((String)entry.getValue());
                    URI insteaded = this.insteadHostIfLocalhost(uri);
                    entry.setValue(insteaded.toString());
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return BaseJsonEncoder.getEncoder().toJsonString((Object)map);
        }
        return json;
    }

    public String insteadHostOfURIIfLocalhost(String uri) {
        try {
            return Strings.isNullOrEmpty((String)uri) ? uri : this.insteadHostIfLocalhost(new URI(uri)).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return uri;
        }
    }

    public String insteadHostOfURLIfLocalhost(String url) {
        try {
            return Strings.isNullOrEmpty((String)url) ? url : this.insteadHostIfLocalhost(new URL(url)).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return url;
        }
    }

    public Map<MQParam, String> insteadHostOfMQParamIfLocalhost(Map<MQParam, String> parameters) {
        if (parameters != null) {
            HashMap out = Maps.newHashMap();
            for (Map.Entry<MQParam, String> entry : parameters.entrySet()) {
                String insteaded;
                MQParam key = entry.getKey();
                String value = entry.getValue();
                if (MQParam.REDIS_URI.equals((Object)key)) {
                    insteaded = this.insteadHostOfURIIfLocalhost(value);
                    out.put(key, insteaded);
                    continue;
                }
                if (MQParam.WEBREDIS_URL.equals((Object)key)) {
                    insteaded = this.insteadHostOfURLIfLocalhost(value);
                    out.put(key, insteaded);
                    continue;
                }
                if (MQParam.MQ_CONNECT.equals((Object)key)) {
                    insteaded = this.insteadHostJsonIfLocalhost(value);
                    out.put(key, insteaded);
                    continue;
                }
                out.put(key, value);
            }
            return out;
        }
        return parameters;
    }

    public Map<String, String> insteadHostOfValueIfLocalhost(Map<String, String> parameters) {
        if (parameters != null) {
            HashMap out = Maps.newHashMap();
            Iterator<Map.Entry<String, String>> iterator = parameters.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String value = entry.getValue();
                HostAndPort insteaded = this.insteadHostIfLocalhost(HostAndPort.fromString((String)value));
                out.put(entry.getKey(), insteaded.toString());
                return out;
            }
        }
        return parameters;
    }

    public Supplier<Integer> getDeviceGroupIdSupplier(final int deviceId) {
        return new Supplier<Integer>(){

            public Integer get() {
                return (Integer)ClientExtendTools.this.deviceGroupIdGetter.apply((Object)deviceId);
            }
        };
    }

    public Supplier<List<Integer>> getPersonGroupBelonsSupplier(final int personId) {
        return new Supplier<List<Integer>>(){

            public List<Integer> get() {
                return (List)ClientExtendTools.this.personGroupBelonsGetter.apply((Object)personId);
            }
        };
    }

    public CmdManager makeCmdManager(Token token) {
        try {
            Preconditions.checkArgument((((Token)Preconditions.checkNotNull((Object)token, (Object)"token is null")).getType() == Token.TokenType.PERSON || token.getType() == Token.TokenType.ROOT ? 1 : 0) != 0, (Object)"person or root token required");
            Preconditions.checkArgument(((Integer)this.tokenRank.apply((Object)token) >= 2 ? 1 : 0) != 0, (Object)"person or root token required");
            IMessageQueueFactory mqFactory = MessageQueueFactorys.getDefaultFactory();
            return (CmdManager)new CmdManager(mqFactory.getPublisher(), mqFactory.getSubscriber(), this.getCmdChannelSupplier(token)).setCmdSn(this.getCmdSnSupplier(token)).setAckChannel(this.getAckChannelSupplier(token)).self();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public TaskManager makeTaskManager(Token token, String cmdpath, Supplier<String> taskQueueSupplier) {
        try {
            Preconditions.checkArgument((((Token)Preconditions.checkNotNull((Object)token, (Object)"token is null")).getType() == Token.TokenType.PERSON || token.getType() == Token.TokenType.ROOT ? 1 : 0) != 0, (Object)"person or root token required");
            Preconditions.checkArgument(((Integer)this.tokenRank.apply((Object)token) >= 2 ? 1 : 0) != 0, (Object)"person or root token required");
            IMessageQueueFactory mqFactory = MessageQueueFactorys.getDefaultFactory();
            return (TaskManager)new TaskManager(mqFactory.getPublisher(), mqFactory.getSubscriber(), mqFactory.getProducer(), cmdpath, taskQueueSupplier).setCmdSn(this.getCmdSnSupplier(token)).setAckChannel(this.getAckChannelSupplier(token)).self();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CmdDispatcher makeCmdDispatcher(Token token) {
        try {
            Preconditions.checkArgument((((Token)Preconditions.checkNotNull((Object)token, (Object)"token is null")).getType() == Token.TokenType.DEVICE ? 1 : 0) != 0, (Object)"device token required");
            int deviceId = token.getId();
            IMessageQueueFactory mqFactory = MessageQueueFactorys.getDefaultFactory();
            CmdDispatcher dispatcher = (CmdDispatcher)new CmdDispatcher(deviceId, mqFactory.getPublisher(), mqFactory.getSubscriber()).setGroupIdSupplier(this.getDeviceGroupIdSupplier(deviceId)).setCmdSnValidator(this.cmdSnValidator).setChannelSupplier((Supplier)new MessageQueueParameterSupplier(MQParam.CMD_CHANNEL, token)).register().self();
            this.dispatcherListener.addDispatcher((BaseDispatcher)dispatcher);
            return dispatcher;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public TaskDispatcher makeTaskDispatcher(Token token, Supplier<String> taskQueueSupplier) {
        try {
            Preconditions.checkArgument((((Token)Preconditions.checkNotNull((Object)token, (Object)"token is null")).getType() == Token.TokenType.DEVICE ? 1 : 0) != 0, (Object)"device token required");
            int deviceId = token.getId();
            IMessageQueueFactory mqFactory = MessageQueueFactorys.getDefaultFactory();
            TaskDispatcher dispatcher = (TaskDispatcher)new TaskDispatcher(deviceId, mqFactory.getPublisher(), mqFactory.getConsumer()).setCmdSnValidator(this.cmdSnValidator).setChannelSupplier(taskQueueSupplier).register().self();
            this.dispatcherListener.addDispatcher((BaseDispatcher)dispatcher);
            return dispatcher;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Supplier<String> getAckChannelSupplier(final int duration, final Token token) {
        return new Supplier<String>(){

            public String get() {
                try {
                    return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.applyAckChannel(duration, token) : (String)ClientExtendTools.this.asyncInstance.applyAckChannel(duration, token).get();
                }
                catch (ExecutionException e) {
                    Throwables.throwIfUnchecked((Throwable)e.getCause());
                    throw new RuntimeException(e.getCause());
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Supplier<String> getAckChannelSupplier(Token token) {
        return this.getAckChannelSupplier(0, token);
    }

    public Supplier<Integer> getCmdSnSupplier(final Token token) {
        return new Supplier<Integer>(){

            public Integer get() {
                try {
                    return ClientExtendTools.this.syncInstance != null ? ClientExtendTools.this.syncInstance.applyCmdSn(token) : ((Integer)ClientExtendTools.this.asyncInstance.applyCmdSn(token).get()).intValue();
                }
                catch (ExecutionException e) {
                    Throwables.throwIfUnchecked((Throwable)e.getCause());
                    throw new RuntimeException(e.getCause());
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Supplier<String> getCmdChannelSupplier(final Token token) {
        return new Supplier<String>(){

            public String get() {
                try {
                    return (String)ClientExtendTools.this.getRedisParametersLazy(token).get(MQParam.CMD_CHANNEL);
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Token applyUserToken(int userid, String password, boolean isMd5) throws ServiceSecurityException {
        try {
            Token token = this.syncInstance != null ? this.syncInstance.applyUserToken(userid, password, isMd5) : (Token)this.asyncInstance.applyUserToken(userid, password, isMd5).get();
            return token;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), ServiceSecurityException.class);
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, ServiceSecurityException.class);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MQParam, String> getRedisParametersLazy(Token token) {
        if (this.redisParameters == null) {
            ClientExtendTools clientExtendTools = this;
            synchronized (clientExtendTools) {
                if (this.redisParameters == null) {
                    Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
                    try {
                        Map param = this.syncInstance != null ? this.syncInstance.getRedisParameters(token) : (Map)this.asyncInstance.getRedisParameters(token).get();
                        this.redisParameters = this.insteadHostOfMQParamIfLocalhost(param);
                    }
                    catch (ExecutionException e) {
                        Throwables.throwIfUnchecked((Throwable)e.getCause());
                        throw new RuntimeException(e.getCause());
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.redisParameters;
    }

    public Supplier<Map<MQParam, String>> getRedisParametersSupplier(final Token token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        return new Supplier<Map<MQParam, String>>(){

            public Map<MQParam, String> get() {
                return ClientExtendTools.this.getRedisParametersLazy(token);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MQParam, String> getMessageQueueParametersLazy(Token token) {
        if (this.mqParameters == null) {
            ClientExtendTools clientExtendTools = this;
            synchronized (clientExtendTools) {
                if (this.mqParameters == null) {
                    Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
                    try {
                        Map param = this.syncInstance != null ? this.syncInstance.getMessageQueueParameters(token) : (Map)this.asyncInstance.getMessageQueueParameters(token).get();
                        this.mqParameters = this.insteadHostOfMQParamIfLocalhost(param);
                    }
                    catch (ExecutionException e) {
                        Throwables.throwIfUnchecked((Throwable)e.getCause());
                        throw new RuntimeException(e.getCause());
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.mqParameters;
    }

    public Supplier<Map<MQParam, String>> getMessageQueueParametersSupplier(final Token token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        return new Supplier<Map<MQParam, String>>(){

            public Map<MQParam, String> get() {
                return ClientExtendTools.this.getMessageQueueParametersLazy(token);
            }
        };
    }

    private Map<String, String> getFaceApiParametersLazy(Token token) {
        if (this.faceapiParameters == null) {
            Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
            try {
                Map param = this.syncInstance != null ? this.syncInstance.getFaceApiParameters(token) : (Map)this.asyncInstance.getFaceApiParameters(token).get();
                this.faceapiParameters = this.insteadHostOfValueIfLocalhost(param);
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.faceapiParameters;
    }

    public Supplier<Map<String, String>> getFaceApiParametersSupplier(final Token token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        return new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                return ClientExtendTools.this.getFaceApiParametersLazy(token);
            }
        };
    }

    public Supplier<String> getDynamicParamSupplier(final MQParam mqParam, Token token) {
        Preconditions.checkNotNull((Object)mqParam, (Object)"mqParam is null");
        return Suppliers.compose((Function)new Function<Map<MQParam, String>, String>(){

            public String apply(Map<MQParam, String> input) {
                return input.get(mqParam);
            }
        }, this.getRedisParametersSupplier(token));
    }

    public DtalkEngineForFacelog initDtalkEngine(Token deviceToken, MenuItem rootMenu) {
        Preconditions.checkArgument((boolean)this.deviceTokenValidator.apply((Object)deviceToken), (Object)"device token REQUIRED");
        this.initMQDefaultFactory(deviceToken);
        IMessageQueueFactory mqFactory = MessageQueueFactorys.getDefaultFactory();
        return new DtalkEngineForFacelog((MenuItem)Preconditions.checkNotNull((Object)rootMenu, (Object)"rootMenu is null"), this.tokenRank, mqFactory);
    }

    public void initMQDefaultFactory(Token token) {
        Map<MQParam, String> mqParam = this.getMessageQueueParametersLazy(token);
        MessageQueueFactorys.getFactory((String)mqParam.get(MQParam.MQ_TYPE)).init(mqParam.get(MQParam.MQ_CONNECT)).asDefaultFactory();
    }

    private Token online(DeviceBean deviceBean) throws ServiceSecurityException {
        try {
            return this.syncInstance != null ? this.syncInstance.online(deviceBean) : (Token)this.asyncInstance.online(deviceBean).get();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), ServiceSecurityException.class);
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, ServiceSecurityException.class);
            throw new RuntimeException(e);
        }
    }

    public Token refreshToken(TokenHelper helper, Token token) {
        Token freshToken = null;
        try {
            switch (token.getType()) {
                case DEVICE: {
                    if (helper.deviceBean() == null) break;
                    freshToken = this.online(helper.deviceBean());
                    break;
                }
                case ROOT: 
                case PERSON: {
                    String pwd = helper.passwordOf(token.getId());
                    if (pwd == null) break;
                    freshToken = this.applyUserToken(token.getId(), pwd, helper.isHashedPwd());
                    break;
                }
            }
            if (freshToken != null) {
                helper.saveFreshedToken(freshToken);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return freshToken;
    }

    public Supplier<Token> getTokenSupplier() {
        return (Supplier)Preconditions.checkNotNull((Object)this.tokenRefresh, (Object)"tokenRefresh field must be initialized by startServiceHeartbeatListener firstly");
    }

    public ClientExtendTools addServiceEventListener(ServiceHeartbeatListener listener) {
        ServiceHeartbeatAdapter.INSTANCE.addServiceEventListener(listener);
        return this;
    }

    public ClientExtendTools removeServiceEventListener(ServiceHeartbeatListener listener) {
        ServiceHeartbeatAdapter.INSTANCE.removeServiceEventListener(listener);
        return this;
    }

    public <T> DynamicChannelListener<T> makeDynamicChannelListener(IMessageAdapter<T> listener, Class<T> channelType, MQParam mqParam, Token token, IMessageQueueFactory factory) {
        DynamicChannelListener monitor = new DynamicChannelListener(listener, channelType, this.getDynamicParamSupplier(mqParam, token), factory);
        this.addServiceEventListener((ServiceHeartbeatListener)monitor);
        return monitor;
    }

    public DeviceHeartbeat makeHeartbeat(int deviceID, Token token) {
        DeviceHeartbeat heartbeat = DeviceHeartbeat.makeHeartbeat((int)deviceID).setMonitorChannelSupplier(this.getDynamicParamSupplier(MQParam.HB_MONITOR_CHANNEL, token));
        this.addServiceEventListener((ServiceHeartbeatListener)heartbeat);
        return heartbeat;
    }

    public ClientExtendTools setTokenHelper(TokenHelper tokenHelper) {
        this.tokenHelper = tokenHelper;
        return this;
    }

    public ClientExtendTools startServiceHeartbeatListener(Token token, boolean initMQDefaultFactoryInstance) {
        ISubscriber subscriber;
        Preconditions.checkState((this.tokenHelper != null ? 1 : 0) != 0, (Object)"tokenHelper field must be initialized by setTokenHelper firstly");
        this.tokenRefresh = new TokenRefresh(this.tokenHelper, token);
        if (initMQDefaultFactoryInstance) {
            this.initMQDefaultFactory(token);
            subscriber = MessageQueueFactorys.getDefaultFactory().getSubscriber();
        } else {
            Map<MQParam, String> mqParam = this.getMessageQueueParametersLazy(token);
            IMessageQueueFactory mqFactory = MessageQueueFactorys.getFactory((String)mqParam.get(MQParam.MQ_TYPE)).init(mqParam.get(MQParam.MQ_CONNECT));
            subscriber = mqFactory.getSubscriber();
        }
        subscriber.register(new Channel[]{ServiceHeartbeatAdapter.SERVICE_HB_CHANNEL});
        this.addServiceEventListener(this.tokenRefreshListener);
        this.addServiceEventListener((ServiceHeartbeatListener)this.dispatcherListener);
        return this;
    }

    private String taskQueueOf(String task, Token token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        try {
            return this.syncInstance != null ? this.syncInstance.taskQueueOf(task, token) : (String)this.asyncInstance.taskQueueOf(task, token).get();
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ParameterSupplier<String> getTaskQueueSupplier(String task, Token token) {
        return new TaskQueueSupplier(task, token);
    }

    public ParameterSupplier<String> getSdkTaskQueueSupplier(String task, String sdkVersion, Token token) {
        return new TaskQueueSupplier((String)Preconditions.checkNotNull((Object)task, (Object)"task is null") + (String)Preconditions.checkNotNull((Object)sdkVersion, (Object)"sdkVersion is null"), token);
    }

    public ClientFactory getFactory() {
        return this.factory;
    }

    private class TaskQueueSupplier
    extends BaseServiceHeartbeatListener
    implements ParameterSupplier<String> {
        private final String task;
        private final Token token;
        protected String taskQueue = null;

        private TaskQueueSupplier(String task, Token token) {
            this.task = (String)Preconditions.checkNotNull((Object)task, (Object)"task is null");
            this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token is null");
            ClientExtendTools.this.addServiceEventListener((ServiceHeartbeatListener)this);
        }

        public String get() {
            if (this.taskQueue == null) {
                this.doServiceOnline(null);
            }
            return this.taskQueue;
        }

        @Override
        public Object key() {
            return this.task;
        }

        protected boolean doServiceOnline(ServiceHeartbeatPackage heartbeatPackage) {
            this.taskQueue = ClientExtendTools.this.taskQueueOf(this.task, this.token);
            return true;
        }

        @Override
        public void close() {
            ClientExtendTools.this.removeServiceEventListener((ServiceHeartbeatListener)this);
        }
    }

    private class MessageQueueParameterSupplier
    implements ParameterSupplier<String> {
        private final MQParam mqParam;
        private final Token token;

        private MessageQueueParameterSupplier(MQParam mqParam, Token token) {
            this.mqParam = (MQParam)Preconditions.checkNotNull((Object)mqParam, (Object)"mqParam is null");
            this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token is null");
        }

        public String get() {
            return (String)ClientExtendTools.this.getMessageQueueParametersLazy(this.token).get(this.mqParam);
        }

        @Override
        public Object key() {
            return this.mqParam;
        }

        @Override
        public void close() {
        }
    }

    public static interface ParameterSupplier<T>
    extends Supplier<T>,
    Closeable {
        public Object key();
    }

    private static class DispatcherListener
    extends BaseServiceHeartbeatListener {
        private final Set<BaseDispatcher> dispatchers = Sets.newLinkedHashSet();

        private DispatcherListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doServiceOnline(ServiceHeartbeatPackage heartbeatPackage) {
            Set<BaseDispatcher> set = this.dispatchers;
            synchronized (set) {
                for (BaseDispatcher dispatcher : this.dispatchers) {
                    if (!dispatcher.isEnable()) continue;
                    dispatcher.unregister();
                    dispatcher.register();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addDispatcher(BaseDispatcher dispatcher) {
            Set<BaseDispatcher> set = this.dispatchers;
            synchronized (set) {
                return this.dispatchers.add(dispatcher);
            }
        }
    }

    private class TokenRefresh
    implements Supplier<Token> {
        private Token token;
        private final Object lock = new Object();
        private volatile boolean relead = true;
        private final TokenHelper helper;

        private TokenRefresh(TokenHelper helper, Token token) {
            this.helper = (TokenHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper is null");
            this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token is null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Token get() {
            if (this.relead) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.relead) {
                        Token t = ClientExtendTools.this.refreshToken(this.helper, this.token);
                        if (null != t) {
                            this.relead = false;
                            this.token.assignFrom(t);
                        }
                        return t;
                    }
                }
            }
            return this.token;
        }

        private boolean refresh() {
            this.relead = true;
            Token token = this.get();
            if (null != token) {
                try {
                    ClientExtendTools.this.redisParameters = null;
                    ClientExtendTools.this.getRedisParametersLazy(token);
                    ClientExtendTools.this.mqParameters = null;
                    ClientExtendTools.this.getMessageQueueParametersLazy(token);
                    ClientExtendTools.this.faceapiParameters = null;
                    ClientExtendTools.this.getFaceApiParametersLazy(token);
                    return true;
                }
                catch (Exception e) {
                    SimpleLog.log((String)((String)MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e.getClass().getName())), (Object[])new Object[0]);
                }
            }
            return false;
        }
    }
}

