/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client;

import com.google.common.base.Supplier;
import gu.dtalk.MenuItem;
import gu.dtalk.cmd.CmdManager;
import gu.dtalk.cmd.TaskManager;
import gu.dtalk.engine.BaseDispatcher;
import gu.dtalk.engine.TaskDispatcher;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.IMessageQueueFactory;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.IFaceLog;
import net.gdface.facelog.IFaceLogDecorator;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.Token;
import net.gdface.facelog.client.ClientExtendTools;
import net.gdface.facelog.client.TokenHelper;
import net.gdface.facelog.client.dtalk.DtalkEngineForFacelog;
import net.gdface.facelog.hb.DeviceHeartbeat;
import net.gdface.facelog.hb.DynamicChannelListener;
import net.gdface.facelog.mq.ServiceHeartbeatListener;
import net.gdface.facelog.thrift.IFaceLogThriftClient;

public class IFaceLogClient
extends IFaceLogDecorator {
    public final ClientExtendTools clientTools;

    public IFaceLogClient(IFaceLog delegate) {
        super(delegate);
        this.clientTools = new ClientExtendTools(delegate);
    }

    public IFaceLogClient(String host, int port) {
        this(new IFaceLogThriftClient(host, port));
    }

    public boolean testConnect() {
        return this.clientTools.getFactory().testConnect();
    }

    public String insteadHostIfLocalhost(String host) {
        return this.clientTools.insteadHostIfLocalhost(host);
    }

    public URI insteadHostIfLocalhost(URI uri) {
        return this.clientTools.insteadHostIfLocalhost(uri);
    }

    public URL insteadHostIfLocalhost(URL url) {
        return this.clientTools.insteadHostIfLocalhost(url);
    }

    public Supplier<Integer> getDeviceGroupIdSupplier(int deviceId) {
        return this.clientTools.getDeviceGroupIdSupplier(deviceId);
    }

    public Supplier<List<Integer>> getPersonGroupBelonsSupplier(int personId) {
        return this.clientTools.getPersonGroupBelonsSupplier(personId);
    }

    public CmdManager makeCmdManager(Token token) {
        return this.clientTools.makeCmdManager(token);
    }

    public TaskManager makeTaskManager(Token token, String cmdpath, Supplier<String> taskQueueSupplier) {
        return this.clientTools.makeTaskManager(token, cmdpath, taskQueueSupplier);
    }

    public BaseDispatcher makeCmdDispatcher(Token token) {
        return this.clientTools.makeCmdDispatcher(token);
    }

    public TaskDispatcher makeTaskDispatcher(Token token, Supplier<String> taskQueueSupplier) {
        return this.clientTools.makeTaskDispatcher(token, taskQueueSupplier);
    }

    public Supplier<String> getAckChannelSupplier(int duration, Token token) {
        return this.clientTools.getAckChannelSupplier(duration, token);
    }

    public Supplier<String> getAckChannelSupplier(Token token) {
        return this.clientTools.getAckChannelSupplier(token);
    }

    public Supplier<Integer> getCmdSnSupplier(Token token) {
        return this.clientTools.getCmdSnSupplier(token);
    }

    public DtalkEngineForFacelog initDtalkEngine(Token deviceToken, MenuItem rootMenu) {
        return this.clientTools.initDtalkEngine(deviceToken, rootMenu);
    }

    public void initMQDefaultFactory(Token token) {
        this.clientTools.initMQDefaultFactory(token);
    }

    public Map<MQParam, String> getRedisParameters(Token token) {
        Map parameters = super.getRedisParameters(token);
        return this.clientTools.insteadHostOfMQParamIfLocalhost(parameters);
    }

    public Supplier<Map<MQParam, String>> getRedisParametersSupplier(Token token) {
        return this.clientTools.getRedisParametersSupplier(token);
    }

    public Supplier<Map<MQParam, String>> getMessageQueueParametersSupplier(Token token) {
        return this.clientTools.getMessageQueueParametersSupplier(token);
    }

    public Map<String, String> getFaceApiParameters(Token token) {
        Map parameters = super.getFaceApiParameters(token);
        return this.clientTools.insteadHostOfValueIfLocalhost(parameters);
    }

    public Supplier<Map<String, String>> getFaceApiParametersSupplier(Token token) {
        return this.clientTools.getFaceApiParametersSupplier(token);
    }

    public Supplier<String> getMonitorChannelSupplier(Token token) {
        return this.clientTools.getDynamicParamSupplier(MQParam.HB_MONITOR_CHANNEL, token);
    }

    public Supplier<String> getDynamicParamSupplier(MQParam mqParam, Token token) {
        return this.clientTools.getDynamicParamSupplier(mqParam, token);
    }

    public Supplier<Token> getTokenSupplier() {
        return this.clientTools.getTokenSupplier();
    }

    public IFaceLogClient addServiceEventListener(ServiceHeartbeatListener listener) {
        this.clientTools.addServiceEventListener(listener);
        return this;
    }

    public IFaceLogClient removeServiceEventListener(ServiceHeartbeatListener listener) {
        this.clientTools.removeServiceEventListener(listener);
        return this;
    }

    public <T> DynamicChannelListener<T> makeDynamicChannelListener(IMessageAdapter<T> listener, Class<T> channelType, MQParam mqParam, Token token, IMessageQueueFactory factory) {
        return this.clientTools.makeDynamicChannelListener(listener, channelType, mqParam, token, factory);
    }

    public DeviceHeartbeat makeHeartbeat(int deviceID, Token token) {
        return this.clientTools.makeHeartbeat(deviceID, token);
    }

    public IFaceLogClient setTokenHelper(TokenHelper tokenHelper) {
        this.clientTools.setTokenHelper(tokenHelper);
        return this;
    }

    public IFaceLogClient startServiceHeartbeatListener(Token token, boolean initMQDefaultFactoryInstance) {
        this.clientTools.startServiceHeartbeatListener(token, initMQDefaultFactoryInstance);
        return this;
    }

    public ClientExtendTools.ParameterSupplier<String> getTaskQueueSupplier(String task, Token token) {
        return this.clientTools.getTaskQueueSupplier(task, token);
    }

    public ClientExtendTools.ParameterSupplier<String> getSdkTaskQueueSupplier(String task, String sdkVersion, Token token) {
        return this.clientTools.getSdkTaskQueueSupplier(task, sdkVersion, token);
    }
}

