/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import gu.dtalk.MenuItem;
import gu.dtalk.cmd.CmdManager;
import gu.dtalk.cmd.TaskManager;
import gu.dtalk.engine.BaseDispatcher;
import gu.dtalk.engine.TaskDispatcher;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.IMessageQueueFactory;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.MQParam;
import net.gdface.facelog.Token;
import net.gdface.facelog.client.ClientExtendTools;
import net.gdface.facelog.client.TokenHelper;
import net.gdface.facelog.client.dtalk.DtalkEngineForFacelog;
import net.gdface.facelog.hb.DeviceHeartbeat;
import net.gdface.facelog.hb.DynamicChannelListener;
import net.gdface.facelog.thrift.IFaceLogThriftClientAsync;
import net.gdface.thrift.ClientFactory;

public class IFaceLogClientAsync
extends IFaceLogThriftClientAsync {
    private final ClientExtendTools clientTools = new ClientExtendTools(this);

    public IFaceLogClientAsync(ClientFactory factory) {
        super(factory);
    }

    public IFaceLogClientAsync(String host, int port) {
        this(ClientFactory.builder().setHostAndPort(host, port));
    }

    @Override
    public boolean testConnect() {
        return this.getFactory().testConnect();
    }

    public String insteadHostIfLocalhost(String host) {
        return this.clientTools.insteadHostIfLocalhost(host);
    }

    public URI insteadHostIfLocalhost(URI uri) {
        return this.clientTools.insteadHostIfLocalhost(uri);
    }

    public URL insteadHostIfLocalhost(URL url) {
        return this.clientTools.insteadHostIfLocalhost(url);
    }

    public Supplier<Integer> getDeviceGroupIdSupplier(int deviceId) {
        return this.clientTools.getDeviceGroupIdSupplier(deviceId);
    }

    public Supplier<List<Integer>> getPersonGroupBelonsSupplier(int personId) {
        return this.clientTools.getPersonGroupBelonsSupplier(personId);
    }

    public CmdManager makeCmdManager(Token token) {
        return this.clientTools.makeCmdManager(token);
    }

    public TaskManager makeTaskManager(Token token, String cmdpath, Supplier<String> taskQueueSupplier) {
        return this.clientTools.makeTaskManager(token, null, taskQueueSupplier);
    }

    public BaseDispatcher makeCmdDispatcher(Token token) {
        return this.clientTools.makeCmdDispatcher(token);
    }

    protected TaskDispatcher makeTaskDispatcher(Token token, Supplier<String> taskQueueSupplier) {
        return this.clientTools.makeTaskDispatcher(token, taskQueueSupplier);
    }

    public Supplier<String> getAckChannelSupplier(int duration, Token token) {
        return this.clientTools.getAckChannelSupplier(duration, token);
    }

    public Supplier<String> getAckChannelSupplier(Token token) {
        return this.clientTools.getAckChannelSupplier(token);
    }

    public Supplier<Integer> getCmdSnSupplier(Token token) {
        return this.clientTools.getCmdSnSupplier(token);
    }

    public DtalkEngineForFacelog initDtalkEngine(Token deviceToken, MenuItem rootMenu) {
        return this.clientTools.initDtalkEngine(deviceToken, rootMenu);
    }

    public void initMQDefaultFactory(Token token) {
        this.clientTools.initMQDefaultFactory(token);
    }

    @Override
    public ListenableFuture<Map<MQParam, String>> getRedisParameters(Token token) {
        ListenableFuture<Map<MQParam, String>> feature = super.getRedisParameters(token);
        return Futures.transform(feature, (Function)new Function<Map<MQParam, String>, Map<MQParam, String>>(){

            public Map<MQParam, String> apply(Map<MQParam, String> input) {
                return IFaceLogClientAsync.this.clientTools.insteadHostOfMQParamIfLocalhost(input);
            }
        });
    }

    public Supplier<Map<MQParam, String>> getRedisParametersSupplier(Token token) {
        return this.clientTools.getRedisParametersSupplier(token);
    }

    public Supplier<Map<MQParam, String>> getMessageQueueParametersSupplier(Token token) {
        return this.clientTools.getMessageQueueParametersSupplier(token);
    }

    public Supplier<String> getMonitorChannelSupplier(Token token) {
        return this.clientTools.getDynamicParamSupplier(MQParam.HB_MONITOR_CHANNEL, token);
    }

    public Supplier<String> getDynamicParamSupplier(MQParam mqParam, Token token) {
        return this.clientTools.getDynamicParamSupplier(mqParam, token);
    }

    public Supplier<Token> getTokenSupplier() {
        return this.clientTools.getTokenSupplier();
    }

    public <T> DynamicChannelListener<T> makeDynamicChannelListener(IMessageAdapter<T> listener, Class<T> channelType, MQParam mqParam, Token token, IMessageQueueFactory factory) {
        return this.clientTools.makeDynamicChannelListener(listener, channelType, mqParam, token, factory);
    }

    public DeviceHeartbeat makeHeartbeat(int deviceID, Token token) {
        return this.clientTools.makeHeartbeat(deviceID, token);
    }

    public IFaceLogClientAsync setTokenHelper(TokenHelper tokenHelper) {
        this.clientTools.setTokenHelper(tokenHelper);
        return this;
    }

    public IFaceLogClientAsync startServiceHeartbeatListener(Token token, boolean initMQDefaultFactoryInstance) {
        this.clientTools.startServiceHeartbeatListener(token, initMQDefaultFactoryInstance);
        return this;
    }

    public ClientExtendTools.ParameterSupplier<String> getTaskQueueSupplier(String task, Token token) {
        return this.clientTools.getTaskQueueSupplier(task, token);
    }

    public ClientExtendTools.ParameterSupplier<String> getSdkTaskQueueSupplier(String task, String sdkVersion, Token token) {
        return this.clientTools.getSdkTaskQueueSupplier(task, sdkVersion, token);
    }
}

