/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client.thrift;

import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.ListMetadata;
import com.microsoft.thrifty.protocol.MapMetadata;
import com.microsoft.thrifty.protocol.MessageMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.service.AsyncClientBase;
import com.microsoft.thrifty.service.MethodCall;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import com.microsoft.thrifty.util.ProtocolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gdface.facelog.client.thrift.DeviceBean;
import net.gdface.facelog.client.thrift.DeviceGroupBean;
import net.gdface.facelog.client.thrift.DuplicateRecordException;
import net.gdface.facelog.client.thrift.ErrorLogBean;
import net.gdface.facelog.client.thrift.FaceBean;
import net.gdface.facelog.client.thrift.FeatureBean;
import net.gdface.facelog.client.thrift.FuzzyMatchCountExceedLimitException;
import net.gdface.facelog.client.thrift.IFaceLog;
import net.gdface.facelog.client.thrift.ImageBean;
import net.gdface.facelog.client.thrift.LockWakeupResponse;
import net.gdface.facelog.client.thrift.LogBean;
import net.gdface.facelog.client.thrift.LogLightBean;
import net.gdface.facelog.client.thrift.MQParam;
import net.gdface.facelog.client.thrift.MatchEntry;
import net.gdface.facelog.client.thrift.PermitBean;
import net.gdface.facelog.client.thrift.PersonBean;
import net.gdface.facelog.client.thrift.PersonDataPackage;
import net.gdface.facelog.client.thrift.PersonGroupBean;
import net.gdface.facelog.client.thrift.ServiceRuntimeException;
import net.gdface.facelog.client.thrift.ServiceSecurityException;
import net.gdface.facelog.client.thrift.StringMatchType;
import net.gdface.facelog.client.thrift.TmpPwdTargetType;
import net.gdface.facelog.client.thrift.TmpwdTargetInfo;
import net.gdface.facelog.client.thrift.Token;
import net.gdface.facelog.client.thrift.TopGroupInfo;
import okio.ByteString;

public class IFaceLogClient
extends AsyncClientBase
implements IFaceLog {
    public IFaceLogClient(Protocol protocol, AsyncClientBase.Listener listener) {
        super(protocol, listener);
    }

    @Override
    public void addErrorLog(ErrorLogBean errorLogBean, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddErrorLogCall(errorLogBean, token, callback));
    }

    @Override
    public void addFeature(ByteString feature, String featureVersion, Integer personId, List<FaceBean> faecBeans, String removed, Token token, ServiceMethodCallback<FeatureBean> callback) {
        this.enqueue(new AddFeatureCall(feature, featureVersion, personId, faecBeans, removed, token, callback));
    }

    @Override
    public void addFeatureMulti(ByteString feature, String featureVersion, Integer personId, List<ByteString> photos, List<FaceBean> faces, String removed, Token token, ServiceMethodCallback<FeatureBean> callback) {
        this.enqueue(new AddFeatureMultiCall(feature, featureVersion, personId, photos, faces, removed, token, callback));
    }

    @Override
    public void addFeatureWithImage(ByteString feature, String featureVersion, Integer personId, Boolean asIdPhotoIfAbsent, ByteString featurePhoto, FaceBean faceBean, String removed, Token token, ServiceMethodCallback<FeatureBean> callback) {
        this.enqueue(new AddFeatureWithImageCall(feature, featureVersion, personId, asIdPhotoIfAbsent, featurePhoto, faceBean, removed, token, callback));
    }

    @Override
    public void addImage(ByteString imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token, ServiceMethodCallback<ImageBean> callback) {
        this.enqueue(new AddImageCall(imageData, deviceId, faceBean, personId, token, callback));
    }

    @Override
    public void addLog(LogBean logBean, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogCall(logBean, token, callback));
    }

    @Override
    public void addLogFull(LogBean logBean, FaceBean faceBean, ByteString featureImage, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogFullCall(logBean, faceBean, featureImage, token, callback));
    }

    @Override
    public void addLogWithFaceImage(LogBean logBean, ByteString faceImage, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogWithFaceImageCall(logBean, faceImage, token, callback));
    }

    @Override
    public void addLogs(List<LogBean> logBeans, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogsCall(logBeans, token, callback));
    }

    @Override
    public void addLogsFull(List<LogBean> logBeans, List<FaceBean> faceBeans, List<ByteString> featureImages, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogsFullCall(logBeans, faceBeans, featureImages, token, callback));
    }

    @Override
    public void addLogsWithFaceImage(List<LogBean> logBeans, List<ByteString> faceImages, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new AddLogsWithFaceImageCall(logBeans, faceImages, token, callback));
    }

    @Override
    public void applyAckChannel(Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new ApplyAckChannelCall(token, callback));
    }

    @Override
    public void applyAckChannelWithDuration(Integer duration, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new ApplyAckChannelWithDurationCall(duration, token, callback));
    }

    @Override
    public void applyCmdSn(Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new ApplyCmdSnCall(token, callback));
    }

    @Override
    public void applyPersonToken(Integer personId, String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
        this.enqueue(new ApplyPersonTokenCall(personId, password, isMd5, callback));
    }

    @Override
    public void applyRootToken(String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
        this.enqueue(new ApplyRootTokenCall(password, isMd5, callback));
    }

    @Override
    public void applyUserToken(Integer userid, String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
        this.enqueue(new ApplyUserTokenCall(userid, password, isMd5, callback));
    }

    @Override
    public void bindBorder(Integer personGroupId, Integer deviceGroupId, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new BindBorderCall(personGroupId, deviceGroupId, token, callback));
    }

    @Override
    public void childListForDeviceGroup(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new ChildListForDeviceGroupCall(deviceGroupId, callback));
    }

    @Override
    public void childListForPersonGroup(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new ChildListForPersonGroupCall(personGroupId, callback));
    }

    @Override
    public void countDeviceByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountDeviceByWhereCall(where, callback));
    }

    @Override
    public void countDeviceByWhereSafe(String where, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountDeviceByWhereSafeCall(where, token, callback));
    }

    @Override
    public void countDeviceGroupByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountDeviceGroupByWhereCall(where, callback));
    }

    @Override
    public void countDeviceGroupByWhereSafe(String where, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountDeviceGroupByWhereSafeCall(where, token, callback));
    }

    @Override
    public void countErrorLogByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountErrorLogByWhereCall(where, callback));
    }

    @Override
    public void countLogByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogByWhereCall(where, callback));
    }

    @Override
    public void countLogByWhereSafe(String where, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogByWhereSafeCall(where, token, callback));
    }

    @Override
    public void countLogLightByVerifyTime(Long timestamp, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByVerifyTimeCall(timestamp, callback));
    }

    @Override
    public void countLogLightByVerifyTimeSafe(Long timestamp, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByVerifyTimeSafeCall(timestamp, token, callback));
    }

    @Override
    public void countLogLightByVerifyTimeTimestr(String timestamp, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByVerifyTimeTimestrCall(timestamp, callback));
    }

    @Override
    public void countLogLightByVerifyTimeTimestrSafe(String timestamp, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByVerifyTimeTimestrSafeCall(timestamp, token, callback));
    }

    @Override
    public void countLogLightByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByWhereCall(where, callback));
    }

    @Override
    public void countLogLightByWhereSafe(String where, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountLogLightByWhereSafeCall(where, token, callback));
    }

    @Override
    public void countPersonByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountPersonByWhereCall(where, callback));
    }

    @Override
    public void countPersonByWhereSafe(String where, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountPersonByWhereSafeCall(where, token, callback));
    }

    @Override
    public void countPersonGroupByWhere(String where, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountPersonGroupByWhereCall(where, callback));
    }

    @Override
    public void countPersonGroupByWhereSafe(String where, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new CountPersonGroupByWhereSafeCall(where, token, callback));
    }

    @Override
    public void countPersonLog(Integer personId, Long startDate, Long endDate, ServiceMethodCallback<Map<String, Integer>> callback) {
        this.enqueue(new CountPersonLogCall(personId, startDate, endDate, callback));
    }

    @Override
    public void countPersonLogSafe(Integer personId, Long startDate, Long endDate, Token token, ServiceMethodCallback<Map<String, Integer>> callback) {
        this.enqueue(new CountPersonLogSafeCall(personId, startDate, endDate, token, callback));
    }

    @Override
    public void countPersonLogTimeStr(Integer personId, String startDate, String endDate, ServiceMethodCallback<Map<String, Integer>> callback) {
        this.enqueue(new CountPersonLogTimeStrCall(personId, startDate, endDate, callback));
    }

    @Override
    public void countPersonLogTimeStrSafe(Integer personId, String startDate, String endDate, Token token, ServiceMethodCallback<Map<String, Integer>> callback) {
        this.enqueue(new CountPersonLogTimeStrSafeCall(personId, startDate, endDate, token, callback));
    }

    @Override
    public void createTempPwd(Integer targetId, TmpPwdTargetType targetType, String expiryDate, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new CreateTempPwdCall(targetId, targetType, expiryDate, token, callback));
    }

    @Override
    public void createTempPwdWithDuration(Integer targetId, TmpPwdTargetType targetType, Integer duration, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new CreateTempPwdWithDurationCall(targetId, targetType, duration, token, callback));
    }

    @Override
    public void deleteAllFeaturesByPersonId(Integer personId, Boolean deleteImage, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteAllFeaturesByPersonIdCall(personId, deleteImage, token, callback));
    }

    @Override
    public void deleteDevice(Integer id, Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new DeleteDeviceCall(id, token, callback));
    }

    @Override
    public void deleteDeviceByMac(String mac, Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new DeleteDeviceByMacCall(mac, token, callback));
    }

    @Override
    public void deleteDeviceGroup(Integer deviceGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteDeviceGroupCall(deviceGroupId, token, callback));
    }

    @Override
    public void deleteErrorLogByWhere(String where, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteErrorLogByWhereCall(where, token, callback));
    }

    @Override
    public void deleteFeature(String featureMd5, Boolean deleteImage, Token token, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new DeleteFeatureCall(featureMd5, deleteImage, token, callback));
    }

    @Override
    public void deleteGroupPermitOnDeviceGroup(Integer deviceGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteGroupPermitOnDeviceGroupCall(deviceGroupId, token, callback));
    }

    @Override
    public void deleteImage(String imageMd5, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteImageCall(imageMd5, token, callback));
    }

    @Override
    public void deleteLogByWhere(String where, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeleteLogByWhereCall(where, token, callback));
    }

    @Override
    public void deletePermitById(Integer deviceGroupId, Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePermitByIdCall(deviceGroupId, personGroupId, token, callback));
    }

    @Override
    public void deletePerson(Integer personId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonCall(personId, token, callback));
    }

    @Override
    public void deletePersonByMobilePhone(String mobilePhone, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonByMobilePhoneCall(mobilePhone, token, callback));
    }

    @Override
    public void deletePersonByPapersNum(String papersNum, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonByPapersNumCall(papersNum, token, callback));
    }

    @Override
    public void deletePersonGroup(Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonGroupCall(personGroupId, token, callback));
    }

    @Override
    public void deletePersonGroupPermit(Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonGroupPermitCall(personGroupId, token, callback));
    }

    @Override
    public void deletePersons(List<Integer> personIdList, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonsCall(personIdList, token, callback));
    }

    @Override
    public void deletePersonsByMobilePhone(List<String> mobilePhoneList, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonsByMobilePhoneCall(mobilePhoneList, token, callback));
    }

    @Override
    public void deletePersonsByPapersNum(List<String> papersNumList, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new DeletePersonsByPapersNumCall(papersNumList, token, callback));
    }

    @Override
    public void disablePerson(Integer personId, Integer moveToGroupId, Boolean deletePhoto, Boolean deleteFeature, Boolean deleteLog, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new DisablePersonCall(personId, moveToGroupId, deletePhoto, deleteFeature, deleteLog, token, callback));
    }

    @Override
    public void disablePersonList(List<Integer> personIdList, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new DisablePersonListCall(personIdList, token, callback));
    }

    @Override
    public void existsDevice(Integer id, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new ExistsDeviceCall(id, callback));
    }

    @Override
    public void existsFeature(String md5, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new ExistsFeatureCall(md5, callback));
    }

    @Override
    public void existsImage(String md5, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new ExistsImageCall(md5, callback));
    }

    @Override
    public void existsPerson(Integer persionId, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new ExistsPersonCall(persionId, callback));
    }

    @Override
    public void faceRecognizePersonPermitted(ByteString imageData, Double threshold, Integer group, Integer deviceId, Boolean searchInPermited, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new FaceRecognizePersonPermittedCall(imageData, threshold, group, deviceId, searchInPermited, callback));
    }

    @Override
    public void fuzzySearch(String tablename, String column, String pattern, StringMatchType matchType, Integer matchFlags, Integer parentGroupId, Integer maxMatchCount, ServiceMethodCallback<List<MatchEntry>> callback) {
        this.enqueue(new FuzzySearchCall(tablename, column, pattern, matchType, matchFlags, parentGroupId, maxMatchCount, callback));
    }

    @Override
    public void fuzzySearchPerson(String column, String pattern, StringMatchType matchType, Integer matchFlags, Integer parentGroupId, Integer maxMatchCount, Token token, ServiceMethodCallback<List<MatchEntry>> callback) {
        this.enqueue(new FuzzySearchPersonCall(column, pattern, matchType, matchFlags, parentGroupId, maxMatchCount, token, callback));
    }

    @Override
    public void getDevice(Integer deviceId, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new GetDeviceCall(deviceId, callback));
    }

    @Override
    public void getDeviceByMac(String mac, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new GetDeviceByMacCall(mac, callback));
    }

    @Override
    public void getDeviceGroup(Integer deviceGroupId, ServiceMethodCallback<DeviceGroupBean> callback) {
        this.enqueue(new GetDeviceGroupCall(deviceGroupId, callback));
    }

    @Override
    public void getDeviceGroups(List<Integer> groupIdList, ServiceMethodCallback<List<DeviceGroupBean>> callback) {
        this.enqueue(new GetDeviceGroupsCall(groupIdList, callback));
    }

    @Override
    public void getDeviceGroupsBelongs(Integer deviceId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetDeviceGroupsBelongsCall(deviceId, callback));
    }

    @Override
    public void getDeviceGroupsPermit(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetDeviceGroupsPermitCall(personGroupId, callback));
    }

    @Override
    public void getDeviceGroupsPermittedBy(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetDeviceGroupsPermittedByCall(personGroupId, callback));
    }

    @Override
    public void getDeviceIdOfFeature(String featureMd5, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new GetDeviceIdOfFeatureCall(featureMd5, callback));
    }

    @Override
    public void getDevices(List<Integer> idList, ServiceMethodCallback<List<DeviceBean>> callback) {
        this.enqueue(new GetDevicesCall(idList, callback));
    }

    @Override
    public void getDevicesOfGroup(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetDevicesOfGroupCall(deviceGroupId, callback));
    }

    @Override
    public void getFace(Integer faceId, ServiceMethodCallback<FaceBean> callback) {
        this.enqueue(new GetFaceCall(faceId, callback));
    }

    @Override
    public void getFaceApiParameters(Token token, ServiceMethodCallback<Map<String, String>> callback) {
        this.enqueue(new GetFaceApiParametersCall(token, callback));
    }

    @Override
    public void getFacesOfFeature(String featureMd5, ServiceMethodCallback<List<FaceBean>> callback) {
        this.enqueue(new GetFacesOfFeatureCall(featureMd5, callback));
    }

    @Override
    public void getFacesOfImage(String imageMd5, ServiceMethodCallback<List<FaceBean>> callback) {
        this.enqueue(new GetFacesOfImageCall(imageMd5, callback));
    }

    @Override
    public void getFeature(String md5, ServiceMethodCallback<FeatureBean> callback) {
        this.enqueue(new GetFeatureCall(md5, callback));
    }

    @Override
    public void getFeatureBytes(String md5, ServiceMethodCallback<ByteString> callback) {
        this.enqueue(new GetFeatureBytesCall(md5, callback));
    }

    @Override
    public void getFeatureBytesList(List<String> md5List, Boolean truncation, ServiceMethodCallback<List<ByteString>> callback) {
        this.enqueue(new GetFeatureBytesListCall(md5List, truncation, callback));
    }

    @Override
    public void getFeatureBytesTruncation(String md5, Boolean truncation, ServiceMethodCallback<ByteString> callback) {
        this.enqueue(new GetFeatureBytesTruncationCall(md5, truncation, callback));
    }

    @Override
    public void getFeatures(List<String> md5List, ServiceMethodCallback<List<FeatureBean>> callback) {
        this.enqueue(new GetFeaturesCall(md5List, callback));
    }

    @Override
    public void getFeaturesByPersonIdAndSdkVersion(Integer personId, String sdkVersion, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetFeaturesByPersonIdAndSdkVersionCall(personId, sdkVersion, callback));
    }

    @Override
    public void getFeaturesOfImage(String imageMd5, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetFeaturesOfImageCall(imageMd5, callback));
    }

    @Override
    public void getFeaturesOfPerson(Integer personId, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetFeaturesOfPersonCall(personId, callback));
    }

    @Override
    public void getFeaturesPermittedOnDevice(Integer deviceId, Boolean ignoreSchedule, String sdkVersion, List<String> excludeFeatureIds, Long timestamp, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetFeaturesPermittedOnDeviceCall(deviceId, ignoreSchedule, sdkVersion, excludeFeatureIds, timestamp, callback));
    }

    @Override
    public void getGroupIdsByPath(String tablename, String path, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetGroupIdsByPathCall(tablename, path, callback));
    }

    @Override
    public void getGroupPermit(Integer deviceId, Integer personGroupId, ServiceMethodCallback<PermitBean> callback) {
        this.enqueue(new GetGroupPermitCall(deviceId, personGroupId, callback));
    }

    @Override
    public void getGroupPermitOnDeviceGroup(Integer deviceGroupId, Integer personGroupId, ServiceMethodCallback<PermitBean> callback) {
        this.enqueue(new GetGroupPermitOnDeviceGroupCall(deviceGroupId, personGroupId, callback));
    }

    @Override
    public void getGroupPermits(Integer deviceId, List<Integer> personGroupIdList, ServiceMethodCallback<List<PermitBean>> callback) {
        this.enqueue(new GetGroupPermitsCall(deviceId, personGroupIdList, callback));
    }

    @Override
    public void getImage(String imageMD5, ServiceMethodCallback<ImageBean> callback) {
        this.enqueue(new GetImageCall(imageMD5, callback));
    }

    @Override
    public void getImageBytes(String imageMD5, ServiceMethodCallback<ByteString> callback) {
        this.enqueue(new GetImageBytesCall(imageMD5, callback));
    }

    @Override
    public void getImageBytesRef(String primaryKey, String refType, ServiceMethodCallback<ByteString> callback) {
        this.enqueue(new GetImageBytesRefCall(primaryKey, refType, callback));
    }

    @Override
    public void getImageRef(String primaryKey, String refType, ServiceMethodCallback<ImageBean> callback) {
        this.enqueue(new GetImageRefCall(primaryKey, refType, callback));
    }

    @Override
    public void getImagesAssociatedByFeature(String featureMd5, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetImagesAssociatedByFeatureCall(featureMd5, callback));
    }

    @Override
    public void getLogBeansByPersonId(Integer personId, ServiceMethodCallback<List<LogBean>> callback) {
        this.enqueue(new GetLogBeansByPersonIdCall(personId, callback));
    }

    @Override
    public void getLogBeansByPersonIdSafe(Integer personId, Token token, ServiceMethodCallback<List<LogBean>> callback) {
        this.enqueue(new GetLogBeansByPersonIdSafeCall(personId, token, callback));
    }

    @Override
    public void getMessageQueueParameters(Token token, ServiceMethodCallback<Map<MQParam, String>> callback) {
        this.enqueue(new GetMessageQueueParametersCall(token, callback));
    }

    @Override
    public void getPerson(Integer personId, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new GetPersonCall(personId, callback));
    }

    @Override
    public void getPersonByMobilePhone(String mobilePhone, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new GetPersonByMobilePhoneCall(mobilePhone, callback));
    }

    @Override
    public void getPersonByMobilePhoneReal(String mobilePhone, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new GetPersonByMobilePhoneRealCall(mobilePhone, token, callback));
    }

    @Override
    public void getPersonByPapersNum(String papersNum, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new GetPersonByPapersNumCall(papersNum, callback));
    }

    @Override
    public void getPersonByPapersNumSafe(String papersNum, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new GetPersonByPapersNumSafeCall(papersNum, token, callback));
    }

    @Override
    public void getPersonGroup(Integer personGroupId, ServiceMethodCallback<PersonGroupBean> callback) {
        this.enqueue(new GetPersonGroupCall(personGroupId, callback));
    }

    @Override
    public void getPersonGroups(List<Integer> groupIdList, ServiceMethodCallback<List<PersonGroupBean>> callback) {
        this.enqueue(new GetPersonGroupsCall(groupIdList, callback));
    }

    @Override
    public void getPersonGroupsBelongs(Integer personId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetPersonGroupsBelongsCall(personId, callback));
    }

    @Override
    public void getPersonGroupsPermittedBy(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetPersonGroupsPermittedByCall(deviceGroupId, callback));
    }

    @Override
    public void getPersonPermit(Integer deviceId, Integer personId, ServiceMethodCallback<PermitBean> callback) {
        this.enqueue(new GetPersonPermitCall(deviceId, personId, callback));
    }

    @Override
    public void getPersonPermits(Integer deviceId, List<Integer> personIdList, ServiceMethodCallback<List<PermitBean>> callback) {
        this.enqueue(new GetPersonPermitsCall(deviceId, personIdList, callback));
    }

    @Override
    public void getPersonReal(Integer personId, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new GetPersonRealCall(personId, token, callback));
    }

    @Override
    public void getPersons(List<Integer> idList, ServiceMethodCallback<List<PersonBean>> callback) {
        this.enqueue(new GetPersonsCall(idList, callback));
    }

    @Override
    public void getPersonsOfGroup(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetPersonsOfGroupCall(personGroupId, callback));
    }

    @Override
    public void getPersonsPermittedOnDevice(Integer deviceId, Boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetPersonsPermittedOnDeviceCall(deviceId, ignoreSchedule, excludePersonIds, timestamp, callback));
    }

    @Override
    public void getPersonsPermittedOnDeviceByGroup(Integer deviceId, Boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new GetPersonsPermittedOnDeviceByGroupCall(deviceId, ignoreSchedule, excludePersonIds, timestamp, callback));
    }

    @Override
    public void getPersonsReal(List<Integer> idList, Token token, ServiceMethodCallback<List<PersonBean>> callback) {
        this.enqueue(new GetPersonsRealCall(idList, token, callback));
    }

    @Override
    public void getProperties(String prefix, Token token, ServiceMethodCallback<Map<String, String>> callback) {
        this.enqueue(new GetPropertiesCall(prefix, token, callback));
    }

    @Override
    public void getProperty(String key, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new GetPropertyCall(key, token, callback));
    }

    @Override
    public void getRedisParameters(Token token, ServiceMethodCallback<Map<MQParam, String>> callback) {
        this.enqueue(new GetRedisParametersCall(token, callback));
    }

    @Override
    public void getServiceConfig(Token token, ServiceMethodCallback<Map<String, String>> callback) {
        this.enqueue(new GetServiceConfigCall(token, callback));
    }

    @Override
    public void getSubDeviceGroup(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetSubDeviceGroupCall(deviceGroupId, callback));
    }

    @Override
    public void getSubPersonGroup(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new GetSubPersonGroupCall(personGroupId, callback));
    }

    @Override
    public void getTargetInfo4PwdOnDevice(String pwd, Token token, ServiceMethodCallback<TmpwdTargetInfo> callback) {
        this.enqueue(new GetTargetInfo4PwdOnDeviceCall(pwd, token, callback));
    }

    @Override
    public void initTopGroup(TopGroupInfo groupInfo, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new InitTopGroupCall(groupInfo, token, callback));
    }

    @Override
    public void isDisable(Integer personId, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsDisableCall(personId, callback));
    }

    @Override
    public void isLocal(ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsLocalCall(callback));
    }

    @Override
    public void isValidAckChannel(String ackChannel, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidAckChannelCall(ackChannel, callback));
    }

    @Override
    public void isValidCmdSn(Integer cmdSn, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidCmdSnCall(cmdSn, callback));
    }

    @Override
    public void isValidDeviceToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidDeviceTokenCall(token, callback));
    }

    @Override
    public void isValidPassword(String userId, String password, Boolean isMd5, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidPasswordCall(userId, password, isMd5, callback));
    }

    @Override
    public void isValidPersonToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidPersonTokenCall(token, callback));
    }

    @Override
    public void isValidRootToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidRootTokenCall(token, callback));
    }

    @Override
    public void isValidToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidTokenCall(token, callback));
    }

    @Override
    public void isValidUserToken(Token token, ServiceMethodCallback<Boolean> callback) {
        this.enqueue(new IsValidUserTokenCall(token, callback));
    }

    @Override
    public void iso8601Time(ServiceMethodCallback<String> callback) {
        this.enqueue(new Iso8601TimeCall(callback));
    }

    @Override
    public void listOfParentForDeviceGroup(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new ListOfParentForDeviceGroupCall(deviceGroupId, callback));
    }

    @Override
    public void listOfParentForPersonGroup(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new ListOfParentForPersonGroupCall(personGroupId, callback));
    }

    @Override
    public void loadAllPerson(ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadAllPersonCall(callback));
    }

    @Override
    public void loadAllPersonSafe(Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadAllPersonSafeCall(token, callback));
    }

    @Override
    public void loadDeviceByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<DeviceBean>> callback) {
        this.enqueue(new LoadDeviceByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadDeviceByWhereSafe(String where, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<DeviceBean>> callback) {
        this.enqueue(new LoadDeviceByWhereSafeCall(where, startRow, numRows, token, callback));
    }

    @Override
    public void loadDeviceGroupByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDeviceGroupByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadDeviceGroupIdByWhere(String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDeviceGroupIdByWhereCall(where, callback));
    }

    @Override
    public void loadDeviceGroupIdByWhereSafe(String where, Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDeviceGroupIdByWhereSafeCall(where, token, callback));
    }

    @Override
    public void loadDeviceIdByWhere(String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDeviceIdByWhereCall(where, callback));
    }

    @Override
    public void loadDeviceIdByWhereSafe(String where, Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDeviceIdByWhereSafeCall(where, token, callback));
    }

    @Override
    public void loadDistinctIntegerColumn(String table, String column, String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadDistinctIntegerColumnCall(table, column, where, callback));
    }

    @Override
    public void loadDistinctStringColumn(String table, String column, String where, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new LoadDistinctStringColumnCall(table, column, where, callback));
    }

    @Override
    public void loadErrorLogByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<ErrorLogBean>> callback) {
        this.enqueue(new LoadErrorLogByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadFeatureMd5ByUpdate(Long timestamp, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new LoadFeatureMd5ByUpdateCall(timestamp, callback));
    }

    @Override
    public void loadFeatureMd5ByUpdateSafe(Long timestamp, Token token, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new LoadFeatureMd5ByUpdateSafeCall(timestamp, token, callback));
    }

    @Override
    public void loadFeatureMd5ByUpdateTimeStr(String timestamp, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new LoadFeatureMd5ByUpdateTimeStrCall(timestamp, callback));
    }

    @Override
    public void loadFeatureMd5ByUpdateTimeStrSafe(String timestamp, Token token, ServiceMethodCallback<List<String>> callback) {
        this.enqueue(new LoadFeatureMd5ByUpdateTimeStrSafeCall(timestamp, token, callback));
    }

    @Override
    public void loadLogByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogBean>> callback) {
        this.enqueue(new LoadLogByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadLogByWhereSafe(String where, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<LogBean>> callback) {
        this.enqueue(new LoadLogByWhereSafeCall(where, startRow, numRows, token, callback));
    }

    @Override
    public void loadLogLightByVerifyTime(Long timestamp, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByVerifyTimeCall(timestamp, startRow, numRows, callback));
    }

    @Override
    public void loadLogLightByVerifyTimeSafe(Long timestamp, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByVerifyTimeSafeCall(timestamp, startRow, numRows, token, callback));
    }

    @Override
    public void loadLogLightByVerifyTimeTimestr(String timestamp, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByVerifyTimeTimestrCall(timestamp, startRow, numRows, callback));
    }

    @Override
    public void loadLogLightByVerifyTimeTimestrSafe(String timestamp, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByVerifyTimeTimestrSafeCall(timestamp, startRow, numRows, token, callback));
    }

    @Override
    public void loadLogLightByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadLogLightByWhereSafe(String where, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<LogLightBean>> callback) {
        this.enqueue(new LoadLogLightByWhereSafeCall(where, startRow, numRows, token, callback));
    }

    @Override
    public void loadPermitByUpdate(Long timestamp, ServiceMethodCallback<List<PermitBean>> callback) {
        this.enqueue(new LoadPermitByUpdateCall(timestamp, callback));
    }

    @Override
    public void loadPermitByUpdateTimestr(String timestamp, ServiceMethodCallback<List<PermitBean>> callback) {
        this.enqueue(new LoadPermitByUpdateTimestrCall(timestamp, callback));
    }

    @Override
    public void loadPersonByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<PersonBean>> callback) {
        this.enqueue(new LoadPersonByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadPersonByWhereReal(String where, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<PersonBean>> callback) {
        this.enqueue(new LoadPersonByWhereRealCall(where, startRow, numRows, token, callback));
    }

    @Override
    public void loadPersonDataPackages(List<Integer> personIds, String sdkVersion, Integer deviceId, ServiceMethodCallback<List<PersonDataPackage>> callback) {
        this.enqueue(new LoadPersonDataPackagesCall(personIds, sdkVersion, deviceId, callback));
    }

    @Override
    public void loadPersonDataPackagesInSameGroup(List<Integer> personIds, String sdkVersion, Integer deviceId, ServiceMethodCallback<List<PersonDataPackage>> callback) {
        this.enqueue(new LoadPersonDataPackagesInSameGroupCall(personIds, sdkVersion, deviceId, callback));
    }

    @Override
    public void loadPersonDataPackagesPermittedOnDevice(Integer deviceId, Boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, String sdkVersion, ServiceMethodCallback<List<PersonDataPackage>> callback) {
        this.enqueue(new LoadPersonDataPackagesPermittedOnDeviceCall(deviceId, ignoreSchedule, excludePersonIds, timestamp, sdkVersion, callback));
    }

    @Override
    public void loadPersonGroupByWhere(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonGroupByWhereCall(where, startRow, numRows, callback));
    }

    @Override
    public void loadPersonGroupIdByWhere(String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonGroupIdByWhereCall(where, callback));
    }

    @Override
    public void loadPersonGroupIdByWhereSafe(String where, Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonGroupIdByWhereSafeCall(where, token, callback));
    }

    @Override
    public void loadPersonIdByUpdateTime(Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByUpdateTimeCall(timestamp, callback));
    }

    @Override
    public void loadPersonIdByUpdateTimeSafe(Long timestamp, Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByUpdateTimeSafeCall(timestamp, token, callback));
    }

    @Override
    public void loadPersonIdByUpdateTimeTimeStr(String timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByUpdateTimeTimeStrCall(timestamp, callback));
    }

    @Override
    public void loadPersonIdByUpdateTimeTimeStrSafe(String timestamp, Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByUpdateTimeTimeStrSafeCall(timestamp, token, callback));
    }

    @Override
    public void loadPersonIdByWhere(String where, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByWhereCall(where, callback));
    }

    @Override
    public void loadPersonIdByWhereSafe(String where, Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadPersonIdByWhereSafeCall(where, token, callback));
    }

    @Override
    public void loadUpdatedPersons(Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadUpdatedPersonsCall(timestamp, callback));
    }

    @Override
    public void loadUpdatedPersonsSafe(Long timestamp, Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadUpdatedPersonsSafeCall(timestamp, token, callback));
    }

    @Override
    public void loadUpdatedPersonsTimestr(String timestamp, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadUpdatedPersonsTimestrCall(timestamp, callback));
    }

    @Override
    public void loadUpdatedPersonsTimestrSafe(String timestamp, Token token, ServiceMethodCallback<List<Integer>> callback) {
        this.enqueue(new LoadUpdatedPersonsTimestrSafeCall(timestamp, token, callback));
    }

    @Override
    public void lockWakeup(DeviceBean deviceBean, Boolean ignoreSchedule, String sdkVersion, ServiceMethodCallback<LockWakeupResponse> callback) {
        this.enqueue(new LockWakeupCall(deviceBean, ignoreSchedule, sdkVersion, callback));
    }

    @Override
    public void offline(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new OfflineCall(token, callback));
    }

    @Override
    public void online(DeviceBean device, ServiceMethodCallback<Token> callback) {
        this.enqueue(new OnlineCall(device, callback));
    }

    @Override
    public void pathOf(String tablename, Integer groupId, ServiceMethodCallback<String> callback) {
        this.enqueue(new PathOfCall(tablename, groupId, callback));
    }

    @Override
    public void registerDevice(DeviceBean newDevice, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new RegisterDeviceCall(newDevice, callback));
    }

    @Override
    public void releasePersonToken(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new ReleasePersonTokenCall(token, callback));
    }

    @Override
    public void releaseRootToken(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new ReleaseRootTokenCall(token, callback));
    }

    @Override
    public void releaseUserToken(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new ReleaseUserTokenCall(token, callback));
    }

    @Override
    public void replaceFeature(Integer personId, String featureMd5, Boolean deleteOldFeatureImage, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new ReplaceFeatureCall(personId, featureMd5, deleteOldFeatureImage, token, callback));
    }

    @Override
    public void rootGroupOfDevice(Integer deviceId, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new RootGroupOfDeviceCall(deviceId, callback));
    }

    @Override
    public void rootGroupOfDeviceGroup(Integer groupId, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new RootGroupOfDeviceGroupCall(groupId, callback));
    }

    @Override
    public void rootGroupOfPerson(Integer personId, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new RootGroupOfPersonCall(personId, callback));
    }

    @Override
    public void rootGroupOfPersonGroup(Integer groupId, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new RootGroupOfPersonGroupCall(groupId, callback));
    }

    @Override
    public void runCmd(List<Integer> target, Boolean group, String cmdpath, String jsonArgs, String ackChannel, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new RunCmdCall(target, group, cmdpath, jsonArgs, ackChannel, token, callback));
    }

    @Override
    public void runTask(String taskQueue, String cmdpath, String jsonArgs, String ackChannel, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new RunTaskCall(taskQueue, cmdpath, jsonArgs, ackChannel, token, callback));
    }

    @Override
    public void runTaskSync(String taskQueue, String cmdpath, String jsonArgs, Integer timeoutSecs, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new RunTaskSyncCall(taskQueue, cmdpath, jsonArgs, timeoutSecs, token, callback));
    }

    @Override
    public void saveDevice(DeviceBean deviceBean, Token token, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new SaveDeviceCall(deviceBean, token, callback));
    }

    @Override
    public void saveDeviceGroup(DeviceGroupBean deviceGroupBean, Token token, ServiceMethodCallback<DeviceGroupBean> callback) {
        this.enqueue(new SaveDeviceGroupCall(deviceGroupBean, token, callback));
    }

    @Override
    public void savePermit(PermitBean permitBean, Token token, ServiceMethodCallback<PermitBean> callback) {
        this.enqueue(new SavePermitCall(permitBean, token, callback));
    }

    @Override
    public void savePermitWithColumn(Integer deviceGroupId, Integer personGroupId, String column, String value, Token token, ServiceMethodCallback<PermitBean> callback) {
        this.enqueue(new SavePermitWithColumnCall(deviceGroupId, personGroupId, column, value, token, callback));
    }

    @Override
    public void savePerson(PersonBean personBean, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonCall(personBean, token, callback));
    }

    @Override
    public void savePersonFull(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, ByteString featureImage, FaceBean faceBean, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonFullCall(personBean, idPhoto, feature, featureVersion, featureImage, faceBean, token, callback));
    }

    @Override
    public void savePersonGroup(PersonGroupBean personGroupBean, Token token, ServiceMethodCallback<PersonGroupBean> callback) {
        this.enqueue(new SavePersonGroupCall(personGroupBean, token, callback));
    }

    @Override
    public void savePersonWithPhoto(PersonBean personBean, ByteString idPhoto, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoCall(personBean, idPhoto, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndExtractFeature(PersonBean personBean, ByteString idPhoto, Boolean exractFeature, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndExtractFeatureCall(personBean, idPhoto, exractFeature, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndFeature(PersonBean personBean, ByteString idPhoto, FeatureBean featureBean, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndFeatureCall(personBean, idPhoto, featureBean, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndFeatureMultiFaces(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, List<FaceBean> faceBeans, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndFeatureMultiFacesCall(personBean, idPhoto, feature, featureVersion, faceBeans, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndFeatureMultiImage(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, List<ByteString> photos, List<FaceBean> faces, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndFeatureMultiImageCall(personBean, idPhoto, feature, featureVersion, photos, faces, token, callback));
    }

    @Override
    public void savePersonWithPhotoAndFeatureSaved(PersonBean personBean, String idPhotoMd5, String featureMd5, Token token, ServiceMethodCallback<PersonBean> callback) {
        this.enqueue(new SavePersonWithPhotoAndFeatureSavedCall(personBean, idPhotoMd5, featureMd5, token, callback));
    }

    @Override
    public void savePersons(List<PersonBean> persons, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SavePersonsCall(persons, token, callback));
    }

    @Override
    public void savePersonsWithPhoto(List<ByteString> photos, List<PersonBean> persons, Token token, ServiceMethodCallback<Integer> callback) {
        this.enqueue(new SavePersonsWithPhotoCall(photos, persons, token, callback));
    }

    @Override
    public void saveServiceConfig(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SaveServiceConfigCall(token, callback));
    }

    @Override
    public void sdkTaskQueueOf(String task, String sdkVersion, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new SdkTaskQueueOfCall(task, sdkVersion, token, callback));
    }

    @Override
    public void setPersonExpiryDate(Integer personId, Long expiryDate, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPersonExpiryDateCall(personId, expiryDate, token, callback));
    }

    @Override
    public void setPersonExpiryDateList(List<Integer> personIdList, Long expiryDate, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPersonExpiryDateListCall(personIdList, expiryDate, token, callback));
    }

    @Override
    public void setPersonExpiryDateTimeStr(Integer personId, String expiryDate, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPersonExpiryDateTimeStrCall(personId, expiryDate, token, callback));
    }

    @Override
    public void setProperties(Map<String, String> config, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPropertiesCall(config, token, callback));
    }

    @Override
    public void setProperty(String key, String value, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new SetPropertyCall(key, value, token, callback));
    }

    @Override
    public void taskQueueOf(String task, Token token, ServiceMethodCallback<String> callback) {
        this.enqueue(new TaskQueueOfCall(task, token, callback));
    }

    @Override
    public void unbindBorder(Integer personGroupId, Integer deviceGroupId, Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new UnbindBorderCall(personGroupId, deviceGroupId, token, callback));
    }

    @Override
    public void unregisterDevice(Token token, ServiceMethodCallback<Void> callback) {
        this.enqueue(new UnregisterDeviceCall(token, callback));
    }

    @Override
    public void updateDevice(DeviceBean deviceBean, Token token, ServiceMethodCallback<DeviceBean> callback) {
        this.enqueue(new UpdateDeviceCall(deviceBean, token, callback));
    }

    @Override
    public void version(ServiceMethodCallback<String> callback) {
        this.enqueue(new VersionCall(callback));
    }

    @Override
    public void versionInfo(ServiceMethodCallback<Map<String, String>> callback) {
        this.enqueue(new VersionInfoCall(callback));
    }

    private static final class VersionInfoCall
    extends MethodCall<Map<String, String>> {
        VersionInfoCall(ServiceMethodCallback<Map<String, String>> callback) {
            super("versionInfo", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, String> value = new HashMap<String, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class VersionCall
    extends MethodCall<String> {
        VersionCall(ServiceMethodCallback<String> callback) {
            super("version", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class UpdateDeviceCall
    extends MethodCall<DeviceBean> {
        private final DeviceBean deviceBean;
        private final Token token;

        UpdateDeviceCall(DeviceBean deviceBean, Token token, ServiceMethodCallback<DeviceBean> callback) {
            super("updateDevice", (byte)1, callback);
            this.deviceBean = deviceBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceBean != null) {
                protocol.writeFieldBegin("deviceBean", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.deviceBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class UnregisterDeviceCall
    extends MethodCall<Void> {
        private final Token token;

        UnregisterDeviceCall(Token token, ServiceMethodCallback<Void> callback) {
            super("unregisterDevice", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class UnbindBorderCall
    extends MethodCall<Void> {
        private final Integer personGroupId;
        private final Integer deviceGroupId;
        private final Token token;

        UnbindBorderCall(Integer personGroupId, Integer deviceGroupId, Token token, ServiceMethodCallback<Void> callback) {
            super("unbindBorder", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deviceGroupId", 2, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class TaskQueueOfCall
    extends MethodCall<String> {
        private final String task;
        private final Token token;

        TaskQueueOfCall(String task, Token token, ServiceMethodCallback<String> callback) {
            super("taskQueueOf", (byte)1, callback);
            this.task = task;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.task != null) {
                protocol.writeFieldBegin("task", 1, (byte)11);
                protocol.writeString(this.task);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SetPropertyCall
    extends MethodCall<Void> {
        private final String key;
        private final String value;
        private final Token token;

        SetPropertyCall(String key, String value, Token token, ServiceMethodCallback<Void> callback) {
            super("setProperty", (byte)1, callback);
            this.key = key;
            this.value = value;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.key != null) {
                protocol.writeFieldBegin("key", 1, (byte)11);
                protocol.writeString(this.key);
                protocol.writeFieldEnd();
            }
            if (this.value != null) {
                protocol.writeFieldBegin("value", 2, (byte)11);
                protocol.writeString(this.value);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SetPropertiesCall
    extends MethodCall<Void> {
        private final Map<String, String> config;
        private final Token token;

        SetPropertiesCall(Map<String, String> config, Token token, ServiceMethodCallback<Void> callback) {
            super("setProperties", (byte)1, callback);
            this.config = config;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.config != null) {
                protocol.writeFieldBegin("config", 1, (byte)13);
                protocol.writeMapBegin((byte)11, (byte)11, this.config.size());
                for (Map.Entry<String, String> entry0 : this.config.entrySet()) {
                    String key0 = entry0.getKey();
                    String value0 = entry0.getValue();
                    protocol.writeString(key0);
                    protocol.writeString(value0);
                }
                protocol.writeMapEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SetPersonExpiryDateTimeStrCall
    extends MethodCall<Void> {
        private final Integer personId;
        private final String expiryDate;
        private final Token token;

        SetPersonExpiryDateTimeStrCall(Integer personId, String expiryDate, Token token, ServiceMethodCallback<Void> callback) {
            super("setPersonExpiryDateTimeStr", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.expiryDate = expiryDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.expiryDate != null) {
                protocol.writeFieldBegin("expiryDate", 2, (byte)11);
                protocol.writeString(this.expiryDate);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SetPersonExpiryDateListCall
    extends MethodCall<Void> {
        private final List<Integer> personIdList;
        private final Long expiryDate;
        private final Token token;

        SetPersonExpiryDateListCall(List<Integer> personIdList, Long expiryDate, Token token, ServiceMethodCallback<Void> callback) {
            super("setPersonExpiryDateList", (byte)1, callback);
            this.personIdList = personIdList;
            if (expiryDate == null) {
                throw new NullPointerException("expiryDate");
            }
            this.expiryDate = expiryDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personIdList != null) {
                protocol.writeFieldBegin("personIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.personIdList.size());
                for (Integer item0 : this.personIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("expiryDate", 2, (byte)10);
            protocol.writeI64(this.expiryDate.longValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SetPersonExpiryDateCall
    extends MethodCall<Void> {
        private final Integer personId;
        private final Long expiryDate;
        private final Token token;

        SetPersonExpiryDateCall(Integer personId, Long expiryDate, Token token, ServiceMethodCallback<Void> callback) {
            super("setPersonExpiryDate", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            if (expiryDate == null) {
                throw new NullPointerException("expiryDate");
            }
            this.expiryDate = expiryDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("expiryDate", 2, (byte)10);
            protocol.writeI64(this.expiryDate.longValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SdkTaskQueueOfCall
    extends MethodCall<String> {
        private final String task;
        private final String sdkVersion;
        private final Token token;

        SdkTaskQueueOfCall(String task, String sdkVersion, Token token, ServiceMethodCallback<String> callback) {
            super("sdkTaskQueueOf", (byte)1, callback);
            this.task = task;
            this.sdkVersion = sdkVersion;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.task != null) {
                protocol.writeFieldBegin("task", 1, (byte)11);
                protocol.writeString(this.task);
                protocol.writeFieldEnd();
            }
            if (this.sdkVersion != null) {
                protocol.writeFieldBegin("sdkVersion", 2, (byte)11);
                protocol.writeString(this.sdkVersion);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SaveServiceConfigCall
    extends MethodCall<Void> {
        private final Token token;

        SaveServiceConfigCall(Token token, ServiceMethodCallback<Void> callback) {
            super("saveServiceConfig", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SavePersonsWithPhotoCall
    extends MethodCall<Integer> {
        private final List<ByteString> photos;
        private final List<PersonBean> persons;
        private final Token token;

        SavePersonsWithPhotoCall(List<ByteString> photos, List<PersonBean> persons, Token token, ServiceMethodCallback<Integer> callback) {
            super("savePersonsWithPhoto", (byte)1, callback);
            this.photos = photos;
            this.persons = persons;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.photos != null) {
                protocol.writeFieldBegin("photos", 1, (byte)15);
                protocol.writeListBegin((byte)11, this.photos.size());
                for (ByteString byteString : this.photos) {
                    protocol.writeBinary(byteString);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.persons != null) {
                protocol.writeFieldBegin("persons", 2, (byte)15);
                protocol.writeListBegin((byte)12, this.persons.size());
                for (PersonBean personBean : this.persons) {
                    PersonBean.ADAPTER.write(protocol, (Object)personBean);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonsCall
    extends MethodCall<Void> {
        private final List<PersonBean> persons;
        private final Token token;

        SavePersonsCall(List<PersonBean> persons, Token token, ServiceMethodCallback<Void> callback) {
            super("savePersons", (byte)1, callback);
            this.persons = persons;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.persons != null) {
                protocol.writeFieldBegin("persons", 1, (byte)15);
                protocol.writeListBegin((byte)12, this.persons.size());
                for (PersonBean item0 : this.persons) {
                    PersonBean.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class SavePersonWithPhotoAndFeatureSavedCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final String idPhotoMd5;
        private final String featureMd5;
        private final Token token;

        SavePersonWithPhotoAndFeatureSavedCall(PersonBean personBean, String idPhotoMd5, String featureMd5, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndFeatureSaved", (byte)1, callback);
            this.personBean = personBean;
            this.idPhotoMd5 = idPhotoMd5;
            this.featureMd5 = featureMd5;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhotoMd5 != null) {
                protocol.writeFieldBegin("idPhotoMd5", 2, (byte)11);
                protocol.writeString(this.idPhotoMd5);
                protocol.writeFieldEnd();
            }
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 3, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoAndFeatureMultiImageCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final ByteString feature;
        private final String featureVersion;
        private final List<ByteString> photos;
        private final List<FaceBean> faces;
        private final Token token;

        SavePersonWithPhotoAndFeatureMultiImageCall(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, List<ByteString> photos, List<FaceBean> faces, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndFeatureMultiImage", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.photos = photos;
            this.faces = faces;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 3, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 4, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.photos != null) {
                protocol.writeFieldBegin("photos", 5, (byte)15);
                protocol.writeListBegin((byte)11, this.photos.size());
                for (ByteString byteString : this.photos) {
                    protocol.writeBinary(byteString);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.faces != null) {
                protocol.writeFieldBegin("faces", 6, (byte)15);
                protocol.writeListBegin((byte)12, this.faces.size());
                for (FaceBean faceBean : this.faces) {
                    FaceBean.ADAPTER.write(protocol, (Object)faceBean);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 7, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoAndFeatureMultiFacesCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final ByteString feature;
        private final String featureVersion;
        private final List<FaceBean> faceBeans;
        private final Token token;

        SavePersonWithPhotoAndFeatureMultiFacesCall(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, List<FaceBean> faceBeans, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndFeatureMultiFaces", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.faceBeans = faceBeans;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 3, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 4, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.faceBeans != null) {
                protocol.writeFieldBegin("faceBeans", 5, (byte)15);
                protocol.writeListBegin((byte)12, this.faceBeans.size());
                for (FaceBean item0 : this.faceBeans) {
                    FaceBean.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 6, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoAndFeatureCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final FeatureBean featureBean;
        private final Token token;

        SavePersonWithPhotoAndFeatureCall(PersonBean personBean, ByteString idPhoto, FeatureBean featureBean, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndFeature", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.featureBean = featureBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.featureBean != null) {
                protocol.writeFieldBegin("featureBean", 3, (byte)12);
                FeatureBean.ADAPTER.write(protocol, (Object)this.featureBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoAndExtractFeatureCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final Boolean exractFeature;
        private final Token token;

        SavePersonWithPhotoAndExtractFeatureCall(PersonBean personBean, ByteString idPhoto, Boolean exractFeature, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhotoAndExtractFeature", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            if (exractFeature == null) {
                throw new NullPointerException("exractFeature");
            }
            this.exractFeature = exractFeature;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("exractFeature", 3, (byte)2);
            protocol.writeBool(this.exractFeature.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonWithPhotoCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final Token token;

        SavePersonWithPhotoCall(PersonBean personBean, ByteString idPhoto, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonWithPhoto", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonGroupCall
    extends MethodCall<PersonGroupBean> {
        private final PersonGroupBean personGroupBean;
        private final Token token;

        SavePersonGroupCall(PersonGroupBean personGroupBean, Token token, ServiceMethodCallback<PersonGroupBean> callback) {
            super("savePersonGroup", (byte)1, callback);
            this.personGroupBean = personGroupBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personGroupBean != null) {
                protocol.writeFieldBegin("personGroupBean", 1, (byte)12);
                PersonGroupBean.ADAPTER.write(protocol, (Object)this.personGroupBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonGroupBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonGroupBean)PersonGroupBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonFullCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final ByteString idPhoto;
        private final ByteString feature;
        private final String featureVersion;
        private final ByteString featureImage;
        private final FaceBean faceBean;
        private final Token token;

        SavePersonFullCall(PersonBean personBean, ByteString idPhoto, ByteString feature, String featureVersion, ByteString featureImage, FaceBean faceBean, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePersonFull", (byte)1, callback);
            this.personBean = personBean;
            this.idPhoto = idPhoto;
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.featureImage = featureImage;
            this.faceBean = faceBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.idPhoto != null) {
                protocol.writeFieldBegin("idPhoto", 2, (byte)11);
                protocol.writeBinary(this.idPhoto);
                protocol.writeFieldEnd();
            }
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 3, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 4, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.featureImage != null) {
                protocol.writeFieldBegin("featureImage", 5, (byte)11);
                protocol.writeBinary(this.featureImage);
                protocol.writeFieldEnd();
            }
            if (this.faceBean != null) {
                protocol.writeFieldBegin("faceBean", 6, (byte)12);
                FaceBean.ADAPTER.write(protocol, (Object)this.faceBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 7, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePersonCall
    extends MethodCall<PersonBean> {
        private final PersonBean personBean;
        private final Token token;

        SavePersonCall(PersonBean personBean, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("savePerson", (byte)1, callback);
            this.personBean = personBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personBean != null) {
                protocol.writeFieldBegin("personBean", 1, (byte)12);
                PersonBean.ADAPTER.write(protocol, (Object)this.personBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePermitWithColumnCall
    extends MethodCall<PermitBean> {
        private final Integer deviceGroupId;
        private final Integer personGroupId;
        private final String column;
        private final String value;
        private final Token token;

        SavePermitWithColumnCall(Integer deviceGroupId, Integer personGroupId, String column, String value, Token token, ServiceMethodCallback<PermitBean> callback) {
            super("savePermitWithColumn", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            this.column = column;
            this.value = value;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personGroupId", 2, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.column != null) {
                protocol.writeFieldBegin("column", 3, (byte)11);
                protocol.writeString(this.column);
                protocol.writeFieldEnd();
            }
            if (this.value != null) {
                protocol.writeFieldBegin("value", 4, (byte)11);
                protocol.writeString(this.value);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 5, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PermitBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PermitBean)PermitBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SavePermitCall
    extends MethodCall<PermitBean> {
        private final PermitBean permitBean;
        private final Token token;

        SavePermitCall(PermitBean permitBean, Token token, ServiceMethodCallback<PermitBean> callback) {
            super("savePermit", (byte)1, callback);
            this.permitBean = permitBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.permitBean != null) {
                protocol.writeFieldBegin("permitBean", 1, (byte)12);
                PermitBean.ADAPTER.write(protocol, (Object)this.permitBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PermitBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PermitBean)PermitBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SaveDeviceGroupCall
    extends MethodCall<DeviceGroupBean> {
        private final DeviceGroupBean deviceGroupBean;
        private final Token token;

        SaveDeviceGroupCall(DeviceGroupBean deviceGroupBean, Token token, ServiceMethodCallback<DeviceGroupBean> callback) {
            super("saveDeviceGroup", (byte)1, callback);
            this.deviceGroupBean = deviceGroupBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceGroupBean != null) {
                protocol.writeFieldBegin("deviceGroupBean", 1, (byte)12);
                DeviceGroupBean.ADAPTER.write(protocol, (Object)this.deviceGroupBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceGroupBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceGroupBean)DeviceGroupBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class SaveDeviceCall
    extends MethodCall<DeviceBean> {
        private final DeviceBean deviceBean;
        private final Token token;

        SaveDeviceCall(DeviceBean deviceBean, Token token, ServiceMethodCallback<DeviceBean> callback) {
            super("saveDevice", (byte)1, callback);
            this.deviceBean = deviceBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceBean != null) {
                protocol.writeFieldBegin("deviceBean", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.deviceBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RunTaskSyncCall
    extends MethodCall<String> {
        private final String taskQueue;
        private final String cmdpath;
        private final String jsonArgs;
        private final Integer timeoutSecs;
        private final Token token;

        RunTaskSyncCall(String taskQueue, String cmdpath, String jsonArgs, Integer timeoutSecs, Token token, ServiceMethodCallback<String> callback) {
            super("runTaskSync", (byte)1, callback);
            this.taskQueue = taskQueue;
            this.cmdpath = cmdpath;
            this.jsonArgs = jsonArgs;
            if (timeoutSecs == null) {
                throw new NullPointerException("timeoutSecs");
            }
            this.timeoutSecs = timeoutSecs;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.taskQueue != null) {
                protocol.writeFieldBegin("taskQueue", 1, (byte)11);
                protocol.writeString(this.taskQueue);
                protocol.writeFieldEnd();
            }
            if (this.cmdpath != null) {
                protocol.writeFieldBegin("cmdpath", 2, (byte)11);
                protocol.writeString(this.cmdpath);
                protocol.writeFieldEnd();
            }
            if (this.jsonArgs != null) {
                protocol.writeFieldBegin("jsonArgs", 3, (byte)11);
                protocol.writeString(this.jsonArgs);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("timeoutSecs", 4, (byte)8);
            protocol.writeI32(this.timeoutSecs.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 5, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RunTaskCall
    extends MethodCall<Integer> {
        private final String taskQueue;
        private final String cmdpath;
        private final String jsonArgs;
        private final String ackChannel;
        private final Token token;

        RunTaskCall(String taskQueue, String cmdpath, String jsonArgs, String ackChannel, Token token, ServiceMethodCallback<Integer> callback) {
            super("runTask", (byte)1, callback);
            this.taskQueue = taskQueue;
            this.cmdpath = cmdpath;
            this.jsonArgs = jsonArgs;
            this.ackChannel = ackChannel;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.taskQueue != null) {
                protocol.writeFieldBegin("taskQueue", 1, (byte)11);
                protocol.writeString(this.taskQueue);
                protocol.writeFieldEnd();
            }
            if (this.cmdpath != null) {
                protocol.writeFieldBegin("cmdpath", 2, (byte)11);
                protocol.writeString(this.cmdpath);
                protocol.writeFieldEnd();
            }
            if (this.jsonArgs != null) {
                protocol.writeFieldBegin("jsonArgs", 3, (byte)11);
                protocol.writeString(this.jsonArgs);
                protocol.writeFieldEnd();
            }
            if (this.ackChannel != null) {
                protocol.writeFieldBegin("ackChannel", 4, (byte)11);
                protocol.writeString(this.ackChannel);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 5, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RunCmdCall
    extends MethodCall<String> {
        private final List<Integer> target;
        private final Boolean group;
        private final String cmdpath;
        private final String jsonArgs;
        private final String ackChannel;
        private final Token token;

        RunCmdCall(List<Integer> target, Boolean group, String cmdpath, String jsonArgs, String ackChannel, Token token, ServiceMethodCallback<String> callback) {
            super("runCmd", (byte)1, callback);
            this.target = target;
            if (group == null) {
                throw new NullPointerException("group");
            }
            this.group = group;
            this.cmdpath = cmdpath;
            this.jsonArgs = jsonArgs;
            this.ackChannel = ackChannel;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.target != null) {
                protocol.writeFieldBegin("target", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.target.size());
                for (Integer item0 : this.target) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("group", 2, (byte)2);
            protocol.writeBool(this.group.booleanValue());
            protocol.writeFieldEnd();
            if (this.cmdpath != null) {
                protocol.writeFieldBegin("cmdpath", 3, (byte)11);
                protocol.writeString(this.cmdpath);
                protocol.writeFieldEnd();
            }
            if (this.jsonArgs != null) {
                protocol.writeFieldBegin("jsonArgs", 4, (byte)11);
                protocol.writeString(this.jsonArgs);
                protocol.writeFieldEnd();
            }
            if (this.ackChannel != null) {
                protocol.writeFieldBegin("ackChannel", 5, (byte)11);
                protocol.writeString(this.ackChannel);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 6, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RootGroupOfPersonGroupCall
    extends MethodCall<Integer> {
        private final Integer groupId;

        RootGroupOfPersonGroupCall(Integer groupId, ServiceMethodCallback<Integer> callback) {
            super("rootGroupOfPersonGroup", (byte)1, callback);
            if (groupId == null) {
                throw new NullPointerException("groupId");
            }
            this.groupId = groupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("groupId", 1, (byte)8);
            protocol.writeI32(this.groupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RootGroupOfPersonCall
    extends MethodCall<Integer> {
        private final Integer personId;

        RootGroupOfPersonCall(Integer personId, ServiceMethodCallback<Integer> callback) {
            super("rootGroupOfPerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RootGroupOfDeviceGroupCall
    extends MethodCall<Integer> {
        private final Integer groupId;

        RootGroupOfDeviceGroupCall(Integer groupId, ServiceMethodCallback<Integer> callback) {
            super("rootGroupOfDeviceGroup", (byte)1, callback);
            if (groupId == null) {
                throw new NullPointerException("groupId");
            }
            this.groupId = groupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("groupId", 1, (byte)8);
            protocol.writeI32(this.groupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class RootGroupOfDeviceCall
    extends MethodCall<Integer> {
        private final Integer deviceId;

        RootGroupOfDeviceCall(Integer deviceId, ServiceMethodCallback<Integer> callback) {
            super("rootGroupOfDevice", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ReplaceFeatureCall
    extends MethodCall<Void> {
        private final Integer personId;
        private final String featureMd5;
        private final Boolean deleteOldFeatureImage;
        private final Token token;

        ReplaceFeatureCall(Integer personId, String featureMd5, Boolean deleteOldFeatureImage, Token token, ServiceMethodCallback<Void> callback) {
            super("replaceFeature", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.featureMd5 = featureMd5;
            if (deleteOldFeatureImage == null) {
                throw new NullPointerException("deleteOldFeatureImage");
            }
            this.deleteOldFeatureImage = deleteOldFeatureImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 2, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("deleteOldFeatureImage", 3, (byte)2);
            protocol.writeBool(this.deleteOldFeatureImage.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class ReleaseUserTokenCall
    extends MethodCall<Void> {
        private final Token token;

        ReleaseUserTokenCall(Token token, ServiceMethodCallback<Void> callback) {
            super("releaseUserToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class ReleaseRootTokenCall
    extends MethodCall<Void> {
        private final Token token;

        ReleaseRootTokenCall(Token token, ServiceMethodCallback<Void> callback) {
            super("releaseRootToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class ReleasePersonTokenCall
    extends MethodCall<Void> {
        private final Token token;

        ReleasePersonTokenCall(Token token, ServiceMethodCallback<Void> callback) {
            super("releasePersonToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class RegisterDeviceCall
    extends MethodCall<DeviceBean> {
        private final DeviceBean newDevice;

        RegisterDeviceCall(DeviceBean newDevice, ServiceMethodCallback<DeviceBean> callback) {
            super("registerDevice", (byte)1, callback);
            this.newDevice = newDevice;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.newDevice != null) {
                protocol.writeFieldBegin("newDevice", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.newDevice);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class PathOfCall
    extends MethodCall<String> {
        private final String tablename;
        private final Integer groupId;

        PathOfCall(String tablename, Integer groupId, ServiceMethodCallback<String> callback) {
            super("pathOf", (byte)1, callback);
            this.tablename = tablename;
            if (groupId == null) {
                throw new NullPointerException("groupId");
            }
            this.groupId = groupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.tablename != null) {
                protocol.writeFieldBegin("tablename", 1, (byte)11);
                protocol.writeString(this.tablename);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("groupId", 2, (byte)8);
            protocol.writeI32(this.groupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class OnlineCall
    extends MethodCall<Token> {
        private final DeviceBean device;

        OnlineCall(DeviceBean device, ServiceMethodCallback<Token> callback) {
            super("online", (byte)1, callback);
            this.device = device;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.device != null) {
                protocol.writeFieldBegin("device", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.device);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Token receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (Token)Token.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class OfflineCall
    extends MethodCall<Void> {
        private final Token token;

        OfflineCall(Token token, ServiceMethodCallback<Void> callback) {
            super("offline", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class LockWakeupCall
    extends MethodCall<LockWakeupResponse> {
        private final DeviceBean deviceBean;
        private final Boolean ignoreSchedule;
        private final String sdkVersion;

        LockWakeupCall(DeviceBean deviceBean, Boolean ignoreSchedule, String sdkVersion, ServiceMethodCallback<LockWakeupResponse> callback) {
            super("lockWakeup", (byte)1, callback);
            this.deviceBean = deviceBean;
            if (ignoreSchedule == null) {
                throw new NullPointerException("ignoreSchedule");
            }
            this.ignoreSchedule = ignoreSchedule;
            this.sdkVersion = sdkVersion;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.deviceBean != null) {
                protocol.writeFieldBegin("deviceBean", 1, (byte)12);
                DeviceBean.ADAPTER.write(protocol, (Object)this.deviceBean);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("ignoreSchedule", 2, (byte)2);
            protocol.writeBool(this.ignoreSchedule.booleanValue());
            protocol.writeFieldEnd();
            if (this.sdkVersion != null) {
                protocol.writeFieldBegin("sdkVersion", 3, (byte)11);
                protocol.writeString(this.sdkVersion);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected LockWakeupResponse receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (LockWakeupResponse)LockWakeupResponse.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadUpdatedPersonsTimestrSafeCall
    extends MethodCall<List<Integer>> {
        private final String timestamp;
        private final Token token;

        LoadUpdatedPersonsTimestrSafeCall(String timestamp, Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadUpdatedPersonsTimestrSafe", (byte)1, callback);
            this.timestamp = timestamp;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadUpdatedPersonsTimestrCall
    extends MethodCall<List<Integer>> {
        private final String timestamp;

        LoadUpdatedPersonsTimestrCall(String timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("loadUpdatedPersonsTimestr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadUpdatedPersonsSafeCall
    extends MethodCall<List<Integer>> {
        private final Long timestamp;
        private final Token token;

        LoadUpdatedPersonsSafeCall(Long timestamp, Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadUpdatedPersonsSafe", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadUpdatedPersonsCall
    extends MethodCall<List<Integer>> {
        private final Long timestamp;

        LoadUpdatedPersonsCall(Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("loadUpdatedPersons", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByWhereSafeCall
    extends MethodCall<List<Integer>> {
        private final String where;
        private final Token token;

        LoadPersonIdByWhereSafeCall(String where, Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;

        LoadPersonIdByWhereCall(String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByUpdateTimeTimeStrSafeCall
    extends MethodCall<List<Integer>> {
        private final String timestamp;
        private final Token token;

        LoadPersonIdByUpdateTimeTimeStrSafeCall(String timestamp, Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByUpdateTimeTimeStrSafe", (byte)1, callback);
            this.timestamp = timestamp;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByUpdateTimeTimeStrCall
    extends MethodCall<List<Integer>> {
        private final String timestamp;

        LoadPersonIdByUpdateTimeTimeStrCall(String timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByUpdateTimeTimeStr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByUpdateTimeSafeCall
    extends MethodCall<List<Integer>> {
        private final Long timestamp;
        private final Token token;

        LoadPersonIdByUpdateTimeSafeCall(Long timestamp, Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByUpdateTimeSafe", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonIdByUpdateTimeCall
    extends MethodCall<List<Integer>> {
        private final Long timestamp;

        LoadPersonIdByUpdateTimeCall(Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonIdByUpdateTime", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonGroupIdByWhereSafeCall
    extends MethodCall<List<Integer>> {
        private final String where;
        private final Token token;

        LoadPersonGroupIdByWhereSafeCall(String where, Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonGroupIdByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonGroupIdByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;

        LoadPersonGroupIdByWhereCall(String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonGroupIdByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonGroupByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadPersonGroupByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<Integer>> callback) {
            super("loadPersonGroupByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonDataPackagesPermittedOnDeviceCall
    extends MethodCall<List<PersonDataPackage>> {
        private final Integer deviceId;
        private final Boolean ignoreSchedule;
        private final List<Integer> excludePersonIds;
        private final Long timestamp;
        private final String sdkVersion;

        LoadPersonDataPackagesPermittedOnDeviceCall(Integer deviceId, Boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, String sdkVersion, ServiceMethodCallback<List<PersonDataPackage>> callback) {
            super("loadPersonDataPackagesPermittedOnDevice", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (ignoreSchedule == null) {
                throw new NullPointerException("ignoreSchedule");
            }
            this.ignoreSchedule = ignoreSchedule;
            this.excludePersonIds = excludePersonIds;
            this.timestamp = timestamp;
            this.sdkVersion = sdkVersion;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("ignoreSchedule", 2, (byte)2);
            protocol.writeBool(this.ignoreSchedule.booleanValue());
            protocol.writeFieldEnd();
            if (this.excludePersonIds != null) {
                protocol.writeFieldBegin("excludePersonIds", 3, (byte)15);
                protocol.writeListBegin((byte)8, this.excludePersonIds.size());
                for (Integer item0 : this.excludePersonIds) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 4, (byte)10);
                protocol.writeI64(this.timestamp.longValue());
                protocol.writeFieldEnd();
            }
            if (this.sdkVersion != null) {
                protocol.writeFieldBegin("sdkVersion", 5, (byte)11);
                protocol.writeString(this.sdkVersion);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonDataPackage> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonDataPackage> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonDataPackage> value = new ArrayList<PersonDataPackage>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonDataPackage item0 = (PersonDataPackage)PersonDataPackage.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonDataPackagesInSameGroupCall
    extends MethodCall<List<PersonDataPackage>> {
        private final List<Integer> personIds;
        private final String sdkVersion;
        private final Integer deviceId;

        LoadPersonDataPackagesInSameGroupCall(List<Integer> personIds, String sdkVersion, Integer deviceId, ServiceMethodCallback<List<PersonDataPackage>> callback) {
            super("loadPersonDataPackagesInSameGroup", (byte)1, callback);
            this.personIds = personIds;
            this.sdkVersion = sdkVersion;
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personIds != null) {
                protocol.writeFieldBegin("personIds", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.personIds.size());
                for (Integer item0 : this.personIds) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.sdkVersion != null) {
                protocol.writeFieldBegin("sdkVersion", 2, (byte)11);
                protocol.writeString(this.sdkVersion);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("deviceId", 3, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonDataPackage> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonDataPackage> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonDataPackage> value = new ArrayList<PersonDataPackage>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonDataPackage item0 = (PersonDataPackage)PersonDataPackage.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonDataPackagesCall
    extends MethodCall<List<PersonDataPackage>> {
        private final List<Integer> personIds;
        private final String sdkVersion;
        private final Integer deviceId;

        LoadPersonDataPackagesCall(List<Integer> personIds, String sdkVersion, Integer deviceId, ServiceMethodCallback<List<PersonDataPackage>> callback) {
            super("loadPersonDataPackages", (byte)1, callback);
            this.personIds = personIds;
            this.sdkVersion = sdkVersion;
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personIds != null) {
                protocol.writeFieldBegin("personIds", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.personIds.size());
                for (Integer item0 : this.personIds) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.sdkVersion != null) {
                protocol.writeFieldBegin("sdkVersion", 2, (byte)11);
                protocol.writeString(this.sdkVersion);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("deviceId", 3, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonDataPackage> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonDataPackage> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonDataPackage> value = new ArrayList<PersonDataPackage>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonDataPackage item0 = (PersonDataPackage)PersonDataPackage.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonByWhereRealCall
    extends MethodCall<List<PersonBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;
        private final Token token;

        LoadPersonByWhereRealCall(String where, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<PersonBean>> callback) {
            super("loadPersonByWhereReal", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonBean> value = new ArrayList<PersonBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonBean item0 = (PersonBean)PersonBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPersonByWhereCall
    extends MethodCall<List<PersonBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadPersonByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<PersonBean>> callback) {
            super("loadPersonByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonBean> value = new ArrayList<PersonBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonBean item0 = (PersonBean)PersonBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPermitByUpdateTimestrCall
    extends MethodCall<List<PermitBean>> {
        private final String timestamp;

        LoadPermitByUpdateTimestrCall(String timestamp, ServiceMethodCallback<List<PermitBean>> callback) {
            super("loadPermitByUpdateTimestr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PermitBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PermitBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PermitBean> value = new ArrayList<PermitBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PermitBean item0 = (PermitBean)PermitBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadPermitByUpdateCall
    extends MethodCall<List<PermitBean>> {
        private final Long timestamp;

        LoadPermitByUpdateCall(Long timestamp, ServiceMethodCallback<List<PermitBean>> callback) {
            super("loadPermitByUpdate", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PermitBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PermitBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PermitBean> value = new ArrayList<PermitBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PermitBean item0 = (PermitBean)PermitBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByWhereSafeCall
    extends MethodCall<List<LogLightBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;
        private final Token token;

        LoadLogLightByWhereSafeCall(String where, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByWhereSafe", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByWhereCall
    extends MethodCall<List<LogLightBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadLogLightByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByVerifyTimeTimestrSafeCall
    extends MethodCall<List<LogLightBean>> {
        private final String timestamp;
        private final Integer startRow;
        private final Integer numRows;
        private final Token token;

        LoadLogLightByVerifyTimeTimestrSafeCall(String timestamp, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByVerifyTimeTimestrSafe", (byte)1, callback);
            this.timestamp = timestamp;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByVerifyTimeTimestrCall
    extends MethodCall<List<LogLightBean>> {
        private final String timestamp;
        private final Integer startRow;
        private final Integer numRows;

        LoadLogLightByVerifyTimeTimestrCall(String timestamp, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByVerifyTimeTimestr", (byte)1, callback);
            this.timestamp = timestamp;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByVerifyTimeSafeCall
    extends MethodCall<List<LogLightBean>> {
        private final Long timestamp;
        private final Integer startRow;
        private final Integer numRows;
        private final Token token;

        LoadLogLightByVerifyTimeSafeCall(Long timestamp, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByVerifyTimeSafe", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogLightByVerifyTimeCall
    extends MethodCall<List<LogLightBean>> {
        private final Long timestamp;
        private final Integer startRow;
        private final Integer numRows;

        LoadLogLightByVerifyTimeCall(Long timestamp, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogLightBean>> callback) {
            super("loadLogLightByVerifyTime", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogLightBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogLightBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogLightBean> value = new ArrayList<LogLightBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogLightBean item0 = (LogLightBean)LogLightBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogByWhereSafeCall
    extends MethodCall<List<LogBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;
        private final Token token;

        LoadLogByWhereSafeCall(String where, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<LogBean>> callback) {
            super("loadLogByWhereSafe", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogBean> value = new ArrayList<LogBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogBean item0 = (LogBean)LogBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadLogByWhereCall
    extends MethodCall<List<LogBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadLogByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<LogBean>> callback) {
            super("loadLogByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogBean> value = new ArrayList<LogBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogBean item0 = (LogBean)LogBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadFeatureMd5ByUpdateTimeStrSafeCall
    extends MethodCall<List<String>> {
        private final String timestamp;
        private final Token token;

        LoadFeatureMd5ByUpdateTimeStrSafeCall(String timestamp, Token token, ServiceMethodCallback<List<String>> callback) {
            super("loadFeatureMd5ByUpdateTimeStrSafe", (byte)1, callback);
            this.timestamp = timestamp;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadFeatureMd5ByUpdateTimeStrCall
    extends MethodCall<List<String>> {
        private final String timestamp;

        LoadFeatureMd5ByUpdateTimeStrCall(String timestamp, ServiceMethodCallback<List<String>> callback) {
            super("loadFeatureMd5ByUpdateTimeStr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadFeatureMd5ByUpdateSafeCall
    extends MethodCall<List<String>> {
        private final Long timestamp;
        private final Token token;

        LoadFeatureMd5ByUpdateSafeCall(Long timestamp, Token token, ServiceMethodCallback<List<String>> callback) {
            super("loadFeatureMd5ByUpdateSafe", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadFeatureMd5ByUpdateCall
    extends MethodCall<List<String>> {
        private final Long timestamp;

        LoadFeatureMd5ByUpdateCall(Long timestamp, ServiceMethodCallback<List<String>> callback) {
            super("loadFeatureMd5ByUpdate", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadErrorLogByWhereCall
    extends MethodCall<List<ErrorLogBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadErrorLogByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<ErrorLogBean>> callback) {
            super("loadErrorLogByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<ErrorLogBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<ErrorLogBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<ErrorLogBean> value = new ArrayList<ErrorLogBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                ErrorLogBean item0 = (ErrorLogBean)ErrorLogBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDistinctStringColumnCall
    extends MethodCall<List<String>> {
        private final String table;
        private final String column;
        private final String where;

        LoadDistinctStringColumnCall(String table, String column, String where, ServiceMethodCallback<List<String>> callback) {
            super("loadDistinctStringColumn", (byte)1, callback);
            this.table = table;
            this.column = column;
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.table != null) {
                protocol.writeFieldBegin("table", 1, (byte)11);
                protocol.writeString(this.table);
                protocol.writeFieldEnd();
            }
            if (this.column != null) {
                protocol.writeFieldBegin("column", 2, (byte)11);
                protocol.writeString(this.column);
                protocol.writeFieldEnd();
            }
            if (this.where != null) {
                protocol.writeFieldBegin("where", 3, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDistinctIntegerColumnCall
    extends MethodCall<List<Integer>> {
        private final String table;
        private final String column;
        private final String where;

        LoadDistinctIntegerColumnCall(String table, String column, String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDistinctIntegerColumn", (byte)1, callback);
            this.table = table;
            this.column = column;
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.table != null) {
                protocol.writeFieldBegin("table", 1, (byte)11);
                protocol.writeString(this.table);
                protocol.writeFieldEnd();
            }
            if (this.column != null) {
                protocol.writeFieldBegin("column", 2, (byte)11);
                protocol.writeString(this.column);
                protocol.writeFieldEnd();
            }
            if (this.where != null) {
                protocol.writeFieldBegin("where", 3, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceIdByWhereSafeCall
    extends MethodCall<List<Integer>> {
        private final String where;
        private final Token token;

        LoadDeviceIdByWhereSafeCall(String where, Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDeviceIdByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceIdByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;

        LoadDeviceIdByWhereCall(String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDeviceIdByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceGroupIdByWhereSafeCall
    extends MethodCall<List<Integer>> {
        private final String where;
        private final Token token;

        LoadDeviceGroupIdByWhereSafeCall(String where, Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDeviceGroupIdByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceGroupIdByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;

        LoadDeviceGroupIdByWhereCall(String where, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDeviceGroupIdByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceGroupByWhereCall
    extends MethodCall<List<Integer>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadDeviceGroupByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<Integer>> callback) {
            super("loadDeviceGroupByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceByWhereSafeCall
    extends MethodCall<List<DeviceBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;
        private final Token token;

        LoadDeviceByWhereSafeCall(String where, Integer startRow, Integer numRows, Token token, ServiceMethodCallback<List<DeviceBean>> callback) {
            super("loadDeviceByWhereSafe", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<DeviceBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<DeviceBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<DeviceBean> value = new ArrayList<DeviceBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                DeviceBean item0 = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadDeviceByWhereCall
    extends MethodCall<List<DeviceBean>> {
        private final String where;
        private final Integer startRow;
        private final Integer numRows;

        LoadDeviceByWhereCall(String where, Integer startRow, Integer numRows, ServiceMethodCallback<List<DeviceBean>> callback) {
            super("loadDeviceByWhere", (byte)1, callback);
            this.where = where;
            if (startRow == null) {
                throw new NullPointerException("startRow");
            }
            this.startRow = startRow;
            if (numRows == null) {
                throw new NullPointerException("numRows");
            }
            this.numRows = numRows;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("startRow", 2, (byte)8);
            protocol.writeI32(this.startRow.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("numRows", 3, (byte)8);
            protocol.writeI32(this.numRows.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<DeviceBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<DeviceBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<DeviceBean> value = new ArrayList<DeviceBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                DeviceBean item0 = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadAllPersonSafeCall
    extends MethodCall<List<Integer>> {
        private final Token token;

        LoadAllPersonSafeCall(Token token, ServiceMethodCallback<List<Integer>> callback) {
            super("loadAllPersonSafe", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class LoadAllPersonCall
    extends MethodCall<List<Integer>> {
        LoadAllPersonCall(ServiceMethodCallback<List<Integer>> callback) {
            super("loadAllPerson", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ListOfParentForPersonGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        ListOfParentForPersonGroupCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("listOfParentForPersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ListOfParentForDeviceGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        ListOfParentForDeviceGroupCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("listOfParentForDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class Iso8601TimeCall
    extends MethodCall<String> {
        Iso8601TimeCall(ServiceMethodCallback<String> callback) {
            super("iso8601Time", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidUserTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidUserTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidUserToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidRootTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidRootTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidRootToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidPersonTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidPersonTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidPersonToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidPasswordCall
    extends MethodCall<Boolean> {
        private final String userId;
        private final String password;
        private final Boolean isMd5;

        IsValidPasswordCall(String userId, String password, Boolean isMd5, ServiceMethodCallback<Boolean> callback) {
            super("isValidPassword", (byte)1, callback);
            this.userId = userId;
            this.password = password;
            if (isMd5 == null) {
                throw new NullPointerException("isMd5");
            }
            this.isMd5 = isMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.userId != null) {
                protocol.writeFieldBegin("userId", 1, (byte)11);
                protocol.writeString(this.userId);
                protocol.writeFieldEnd();
            }
            if (this.password != null) {
                protocol.writeFieldBegin("password", 2, (byte)11);
                protocol.writeString(this.password);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("isMd5", 3, (byte)2);
            protocol.writeBool(this.isMd5.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidDeviceTokenCall
    extends MethodCall<Boolean> {
        private final Token token;

        IsValidDeviceTokenCall(Token token, ServiceMethodCallback<Boolean> callback) {
            super("isValidDeviceToken", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidCmdSnCall
    extends MethodCall<Boolean> {
        private final Integer cmdSn;

        IsValidCmdSnCall(Integer cmdSn, ServiceMethodCallback<Boolean> callback) {
            super("isValidCmdSn", (byte)1, callback);
            if (cmdSn == null) {
                throw new NullPointerException("cmdSn");
            }
            this.cmdSn = cmdSn;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("cmdSn", 1, (byte)8);
            protocol.writeI32(this.cmdSn.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsValidAckChannelCall
    extends MethodCall<Boolean> {
        private final String ackChannel;

        IsValidAckChannelCall(String ackChannel, ServiceMethodCallback<Boolean> callback) {
            super("isValidAckChannel", (byte)1, callback);
            this.ackChannel = ackChannel;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.ackChannel != null) {
                protocol.writeFieldBegin("ackChannel", 1, (byte)11);
                protocol.writeString(this.ackChannel);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsLocalCall
    extends MethodCall<Boolean> {
        IsLocalCall(ServiceMethodCallback<Boolean> callback) {
            super("isLocal", (byte)1, callback);
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class IsDisableCall
    extends MethodCall<Boolean> {
        private final Integer personId;

        IsDisableCall(Integer personId, ServiceMethodCallback<Boolean> callback) {
            super("isDisable", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class InitTopGroupCall
    extends MethodCall<Integer> {
        private final TopGroupInfo groupInfo;
        private final Token token;

        InitTopGroupCall(TopGroupInfo groupInfo, Token token, ServiceMethodCallback<Integer> callback) {
            super("initTopGroup", (byte)1, callback);
            this.groupInfo = groupInfo;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.groupInfo != null) {
                protocol.writeFieldBegin("groupInfo", 1, (byte)12);
                TopGroupInfo.ADAPTER.write(protocol, (Object)this.groupInfo);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetTargetInfo4PwdOnDeviceCall
    extends MethodCall<TmpwdTargetInfo> {
        private final String pwd;
        private final Token token;

        GetTargetInfo4PwdOnDeviceCall(String pwd, Token token, ServiceMethodCallback<TmpwdTargetInfo> callback) {
            super("getTargetInfo4PwdOnDevice", (byte)1, callback);
            this.pwd = pwd;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.pwd != null) {
                protocol.writeFieldBegin("pwd", 1, (byte)11);
                protocol.writeString(this.pwd);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected TmpwdTargetInfo receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (TmpwdTargetInfo)TmpwdTargetInfo.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetSubPersonGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        GetSubPersonGroupCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getSubPersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetSubDeviceGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        GetSubDeviceGroupCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getSubDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetServiceConfigCall
    extends MethodCall<Map<String, String>> {
        private final Token token;

        GetServiceConfigCall(Token token, ServiceMethodCallback<Map<String, String>> callback) {
            super("getServiceConfig", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, String> value = new HashMap<String, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetRedisParametersCall
    extends MethodCall<Map<MQParam, String>> {
        private final Token token;

        GetRedisParametersCall(Token token, ServiceMethodCallback<Map<MQParam, String>> callback) {
            super("getRedisParameters", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<MQParam, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<MQParam, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<MQParam, String> value = new HashMap<MQParam, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                int i32_1 = protocol.readI32();
                                MQParam key0 = MQParam.findByValue(i32_1);
                                if (key0 == null) {
                                    throw new ThriftException(ThriftException.Kind.PROTOCOL_ERROR, "Unexpected value for enum-type MQParam: " + i32_1);
                                }
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPropertyCall
    extends MethodCall<String> {
        private final String key;
        private final Token token;

        GetPropertyCall(String key, Token token, ServiceMethodCallback<String> callback) {
            super("getProperty", (byte)1, callback);
            this.key = key;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.key != null) {
                protocol.writeFieldBegin("key", 1, (byte)11);
                protocol.writeString(this.key);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPropertiesCall
    extends MethodCall<Map<String, String>> {
        private final String prefix;
        private final Token token;

        GetPropertiesCall(String prefix, Token token, ServiceMethodCallback<Map<String, String>> callback) {
            super("getProperties", (byte)1, callback);
            this.prefix = prefix;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.prefix != null) {
                protocol.writeFieldBegin("prefix", 1, (byte)11);
                protocol.writeString(this.prefix);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, String> value = new HashMap<String, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonsRealCall
    extends MethodCall<List<PersonBean>> {
        private final List<Integer> idList;
        private final Token token;

        GetPersonsRealCall(List<Integer> idList, Token token, ServiceMethodCallback<List<PersonBean>> callback) {
            super("getPersonsReal", (byte)1, callback);
            this.idList = idList;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.idList != null) {
                protocol.writeFieldBegin("idList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.idList.size());
                for (Integer item0 : this.idList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonBean> value = new ArrayList<PersonBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonBean item0 = (PersonBean)PersonBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonsPermittedOnDeviceByGroupCall
    extends MethodCall<List<String>> {
        private final Integer deviceId;
        private final Boolean ignoreSchedule;
        private final List<Integer> excludePersonIds;
        private final Long timestamp;

        GetPersonsPermittedOnDeviceByGroupCall(Integer deviceId, Boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, ServiceMethodCallback<List<String>> callback) {
            super("getPersonsPermittedOnDeviceByGroup", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (ignoreSchedule == null) {
                throw new NullPointerException("ignoreSchedule");
            }
            this.ignoreSchedule = ignoreSchedule;
            this.excludePersonIds = excludePersonIds;
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("ignoreSchedule", 2, (byte)2);
            protocol.writeBool(this.ignoreSchedule.booleanValue());
            protocol.writeFieldEnd();
            if (this.excludePersonIds != null) {
                protocol.writeFieldBegin("excludePersonIds", 3, (byte)15);
                protocol.writeListBegin((byte)8, this.excludePersonIds.size());
                for (Integer item0 : this.excludePersonIds) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 4, (byte)10);
                protocol.writeI64(this.timestamp.longValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonsPermittedOnDeviceCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceId;
        private final Boolean ignoreSchedule;
        private final List<Integer> excludePersonIds;
        private final Long timestamp;

        GetPersonsPermittedOnDeviceCall(Integer deviceId, Boolean ignoreSchedule, List<Integer> excludePersonIds, Long timestamp, ServiceMethodCallback<List<Integer>> callback) {
            super("getPersonsPermittedOnDevice", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (ignoreSchedule == null) {
                throw new NullPointerException("ignoreSchedule");
            }
            this.ignoreSchedule = ignoreSchedule;
            this.excludePersonIds = excludePersonIds;
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("ignoreSchedule", 2, (byte)2);
            protocol.writeBool(this.ignoreSchedule.booleanValue());
            protocol.writeFieldEnd();
            if (this.excludePersonIds != null) {
                protocol.writeFieldBegin("excludePersonIds", 3, (byte)15);
                protocol.writeListBegin((byte)8, this.excludePersonIds.size());
                for (Integer item0 : this.excludePersonIds) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 4, (byte)10);
                protocol.writeI64(this.timestamp.longValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonsOfGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        GetPersonsOfGroupCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getPersonsOfGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonsCall
    extends MethodCall<List<PersonBean>> {
        private final List<Integer> idList;

        GetPersonsCall(List<Integer> idList, ServiceMethodCallback<List<PersonBean>> callback) {
            super("getPersons", (byte)1, callback);
            this.idList = idList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.idList != null) {
                protocol.writeFieldBegin("idList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.idList.size());
                for (Integer item0 : this.idList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonBean> value = new ArrayList<PersonBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonBean item0 = (PersonBean)PersonBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonRealCall
    extends MethodCall<PersonBean> {
        private final Integer personId;
        private final Token token;

        GetPersonRealCall(Integer personId, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("getPersonReal", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonPermitsCall
    extends MethodCall<List<PermitBean>> {
        private final Integer deviceId;
        private final List<Integer> personIdList;

        GetPersonPermitsCall(Integer deviceId, List<Integer> personIdList, ServiceMethodCallback<List<PermitBean>> callback) {
            super("getPersonPermits", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            this.personIdList = personIdList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            if (this.personIdList != null) {
                protocol.writeFieldBegin("personIdList", 2, (byte)15);
                protocol.writeListBegin((byte)8, this.personIdList.size());
                for (Integer item0 : this.personIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PermitBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PermitBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PermitBean> value = new ArrayList<PermitBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PermitBean item0 = (PermitBean)PermitBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonPermitCall
    extends MethodCall<PermitBean> {
        private final Integer deviceId;
        private final Integer personId;

        GetPersonPermitCall(Integer deviceId, Integer personId, ServiceMethodCallback<PermitBean> callback) {
            super("getPersonPermit", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personId", 2, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PermitBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PermitBean)PermitBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonGroupsPermittedByCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        GetPersonGroupsPermittedByCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getPersonGroupsPermittedBy", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonGroupsBelongsCall
    extends MethodCall<List<Integer>> {
        private final Integer personId;

        GetPersonGroupsBelongsCall(Integer personId, ServiceMethodCallback<List<Integer>> callback) {
            super("getPersonGroupsBelongs", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonGroupsCall
    extends MethodCall<List<PersonGroupBean>> {
        private final List<Integer> groupIdList;

        GetPersonGroupsCall(List<Integer> groupIdList, ServiceMethodCallback<List<PersonGroupBean>> callback) {
            super("getPersonGroups", (byte)1, callback);
            this.groupIdList = groupIdList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.groupIdList != null) {
                protocol.writeFieldBegin("groupIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.groupIdList.size());
                for (Integer item0 : this.groupIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PersonGroupBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PersonGroupBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PersonGroupBean> value = new ArrayList<PersonGroupBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PersonGroupBean item0 = (PersonGroupBean)PersonGroupBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonGroupCall
    extends MethodCall<PersonGroupBean> {
        private final Integer personGroupId;

        GetPersonGroupCall(Integer personGroupId, ServiceMethodCallback<PersonGroupBean> callback) {
            super("getPersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonGroupBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonGroupBean)PersonGroupBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonByPapersNumSafeCall
    extends MethodCall<PersonBean> {
        private final String papersNum;
        private final Token token;

        GetPersonByPapersNumSafeCall(String papersNum, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("getPersonByPapersNumSafe", (byte)1, callback);
            this.papersNum = papersNum;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.papersNum != null) {
                protocol.writeFieldBegin("papersNum", 1, (byte)11);
                protocol.writeString(this.papersNum);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonByPapersNumCall
    extends MethodCall<PersonBean> {
        private final String papersNum;

        GetPersonByPapersNumCall(String papersNum, ServiceMethodCallback<PersonBean> callback) {
            super("getPersonByPapersNum", (byte)1, callback);
            this.papersNum = papersNum;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.papersNum != null) {
                protocol.writeFieldBegin("papersNum", 1, (byte)11);
                protocol.writeString(this.papersNum);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonByMobilePhoneRealCall
    extends MethodCall<PersonBean> {
        private final String mobilePhone;
        private final Token token;

        GetPersonByMobilePhoneRealCall(String mobilePhone, Token token, ServiceMethodCallback<PersonBean> callback) {
            super("getPersonByMobilePhoneReal", (byte)1, callback);
            this.mobilePhone = mobilePhone;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.mobilePhone != null) {
                protocol.writeFieldBegin("mobilePhone", 1, (byte)11);
                protocol.writeString(this.mobilePhone);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonByMobilePhoneCall
    extends MethodCall<PersonBean> {
        private final String mobilePhone;

        GetPersonByMobilePhoneCall(String mobilePhone, ServiceMethodCallback<PersonBean> callback) {
            super("getPersonByMobilePhone", (byte)1, callback);
            this.mobilePhone = mobilePhone;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.mobilePhone != null) {
                protocol.writeFieldBegin("mobilePhone", 1, (byte)11);
                protocol.writeString(this.mobilePhone);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetPersonCall
    extends MethodCall<PersonBean> {
        private final Integer personId;

        GetPersonCall(Integer personId, ServiceMethodCallback<PersonBean> callback) {
            super("getPerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PersonBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PersonBean)PersonBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetMessageQueueParametersCall
    extends MethodCall<Map<MQParam, String>> {
        private final Token token;

        GetMessageQueueParametersCall(Token token, ServiceMethodCallback<Map<MQParam, String>> callback) {
            super("getMessageQueueParameters", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<MQParam, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<MQParam, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<MQParam, String> value = new HashMap<MQParam, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                int i32_1 = protocol.readI32();
                                MQParam key0 = MQParam.findByValue(i32_1);
                                if (key0 == null) {
                                    throw new ThriftException(ThriftException.Kind.PROTOCOL_ERROR, "Unexpected value for enum-type MQParam: " + i32_1);
                                }
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetLogBeansByPersonIdSafeCall
    extends MethodCall<List<LogBean>> {
        private final Integer personId;
        private final Token token;

        GetLogBeansByPersonIdSafeCall(Integer personId, Token token, ServiceMethodCallback<List<LogBean>> callback) {
            super("getLogBeansByPersonIdSafe", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogBean> value = new ArrayList<LogBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogBean item0 = (LogBean)LogBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetLogBeansByPersonIdCall
    extends MethodCall<List<LogBean>> {
        private final Integer personId;

        GetLogBeansByPersonIdCall(Integer personId, ServiceMethodCallback<List<LogBean>> callback) {
            super("getLogBeansByPersonId", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<LogBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<LogBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<LogBean> value = new ArrayList<LogBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                LogBean item0 = (LogBean)LogBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetImagesAssociatedByFeatureCall
    extends MethodCall<List<String>> {
        private final String featureMd5;

        GetImagesAssociatedByFeatureCall(String featureMd5, ServiceMethodCallback<List<String>> callback) {
            super("getImagesAssociatedByFeature", (byte)1, callback);
            this.featureMd5 = featureMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 1, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetImageRefCall
    extends MethodCall<ImageBean> {
        private final String primaryKey;
        private final String refType;

        GetImageRefCall(String primaryKey, String refType, ServiceMethodCallback<ImageBean> callback) {
            super("getImageRef", (byte)1, callback);
            this.primaryKey = primaryKey;
            this.refType = refType;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.primaryKey != null) {
                protocol.writeFieldBegin("primaryKey", 1, (byte)11);
                protocol.writeString(this.primaryKey);
                protocol.writeFieldEnd();
            }
            if (this.refType != null) {
                protocol.writeFieldBegin("refType", 2, (byte)11);
                protocol.writeString(this.refType);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ImageBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (ImageBean)ImageBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetImageBytesRefCall
    extends MethodCall<ByteString> {
        private final String primaryKey;
        private final String refType;

        GetImageBytesRefCall(String primaryKey, String refType, ServiceMethodCallback<ByteString> callback) {
            super("getImageBytesRef", (byte)1, callback);
            this.primaryKey = primaryKey;
            this.refType = refType;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.primaryKey != null) {
                protocol.writeFieldBegin("primaryKey", 1, (byte)11);
                protocol.writeString(this.primaryKey);
                protocol.writeFieldEnd();
            }
            if (this.refType != null) {
                protocol.writeFieldBegin("refType", 2, (byte)11);
                protocol.writeString(this.refType);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ByteString receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ByteString result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            result = value = protocol.readBinary();
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetImageBytesCall
    extends MethodCall<ByteString> {
        private final String imageMD5;

        GetImageBytesCall(String imageMD5, ServiceMethodCallback<ByteString> callback) {
            super("getImageBytes", (byte)1, callback);
            this.imageMD5 = imageMD5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageMD5 != null) {
                protocol.writeFieldBegin("imageMD5", 1, (byte)11);
                protocol.writeString(this.imageMD5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ByteString receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ByteString result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            result = value = protocol.readBinary();
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetImageCall
    extends MethodCall<ImageBean> {
        private final String imageMD5;

        GetImageCall(String imageMD5, ServiceMethodCallback<ImageBean> callback) {
            super("getImage", (byte)1, callback);
            this.imageMD5 = imageMD5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageMD5 != null) {
                protocol.writeFieldBegin("imageMD5", 1, (byte)11);
                protocol.writeString(this.imageMD5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ImageBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (ImageBean)ImageBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetGroupPermitsCall
    extends MethodCall<List<PermitBean>> {
        private final Integer deviceId;
        private final List<Integer> personGroupIdList;

        GetGroupPermitsCall(Integer deviceId, List<Integer> personGroupIdList, ServiceMethodCallback<List<PermitBean>> callback) {
            super("getGroupPermits", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            this.personGroupIdList = personGroupIdList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            if (this.personGroupIdList != null) {
                protocol.writeFieldBegin("personGroupIdList", 2, (byte)15);
                protocol.writeListBegin((byte)8, this.personGroupIdList.size());
                for (Integer item0 : this.personGroupIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<PermitBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<PermitBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<PermitBean> value = new ArrayList<PermitBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                PermitBean item0 = (PermitBean)PermitBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetGroupPermitOnDeviceGroupCall
    extends MethodCall<PermitBean> {
        private final Integer deviceGroupId;
        private final Integer personGroupId;

        GetGroupPermitOnDeviceGroupCall(Integer deviceGroupId, Integer personGroupId, ServiceMethodCallback<PermitBean> callback) {
            super("getGroupPermitOnDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personGroupId", 2, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PermitBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PermitBean)PermitBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetGroupPermitCall
    extends MethodCall<PermitBean> {
        private final Integer deviceId;
        private final Integer personGroupId;

        GetGroupPermitCall(Integer deviceId, Integer personGroupId, ServiceMethodCallback<PermitBean> callback) {
            super("getGroupPermit", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personGroupId", 2, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected PermitBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (PermitBean)PermitBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetGroupIdsByPathCall
    extends MethodCall<List<Integer>> {
        private final String tablename;
        private final String path;

        GetGroupIdsByPathCall(String tablename, String path, ServiceMethodCallback<List<Integer>> callback) {
            super("getGroupIdsByPath", (byte)1, callback);
            this.tablename = tablename;
            this.path = path;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.tablename != null) {
                protocol.writeFieldBegin("tablename", 1, (byte)11);
                protocol.writeString(this.tablename);
                protocol.writeFieldEnd();
            }
            if (this.path != null) {
                protocol.writeFieldBegin("path", 2, (byte)11);
                protocol.writeString(this.path);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesPermittedOnDeviceCall
    extends MethodCall<List<String>> {
        private final Integer deviceId;
        private final Boolean ignoreSchedule;
        private final String sdkVersion;
        private final List<String> excludeFeatureIds;
        private final Long timestamp;

        GetFeaturesPermittedOnDeviceCall(Integer deviceId, Boolean ignoreSchedule, String sdkVersion, List<String> excludeFeatureIds, Long timestamp, ServiceMethodCallback<List<String>> callback) {
            super("getFeaturesPermittedOnDevice", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (ignoreSchedule == null) {
                throw new NullPointerException("ignoreSchedule");
            }
            this.ignoreSchedule = ignoreSchedule;
            this.sdkVersion = sdkVersion;
            this.excludeFeatureIds = excludeFeatureIds;
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("ignoreSchedule", 2, (byte)2);
            protocol.writeBool(this.ignoreSchedule.booleanValue());
            protocol.writeFieldEnd();
            if (this.sdkVersion != null) {
                protocol.writeFieldBegin("sdkVersion", 3, (byte)11);
                protocol.writeString(this.sdkVersion);
                protocol.writeFieldEnd();
            }
            if (this.excludeFeatureIds != null) {
                protocol.writeFieldBegin("excludeFeatureIds", 4, (byte)15);
                protocol.writeListBegin((byte)11, this.excludeFeatureIds.size());
                for (String item0 : this.excludeFeatureIds) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 5, (byte)10);
                protocol.writeI64(this.timestamp.longValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesOfPersonCall
    extends MethodCall<List<String>> {
        private final Integer personId;

        GetFeaturesOfPersonCall(Integer personId, ServiceMethodCallback<List<String>> callback) {
            super("getFeaturesOfPerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesOfImageCall
    extends MethodCall<List<String>> {
        private final String imageMd5;

        GetFeaturesOfImageCall(String imageMd5, ServiceMethodCallback<List<String>> callback) {
            super("getFeaturesOfImage", (byte)1, callback);
            this.imageMd5 = imageMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageMd5 != null) {
                protocol.writeFieldBegin("imageMd5", 1, (byte)11);
                protocol.writeString(this.imageMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesByPersonIdAndSdkVersionCall
    extends MethodCall<List<String>> {
        private final Integer personId;
        private final String sdkVersion;

        GetFeaturesByPersonIdAndSdkVersionCall(Integer personId, String sdkVersion, ServiceMethodCallback<List<String>> callback) {
            super("getFeaturesByPersonIdAndSdkVersion", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.sdkVersion = sdkVersion;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.sdkVersion != null) {
                protocol.writeFieldBegin("sdkVersion", 2, (byte)11);
                protocol.writeString(this.sdkVersion);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeaturesCall
    extends MethodCall<List<FeatureBean>> {
        private final List<String> md5List;

        GetFeaturesCall(List<String> md5List, ServiceMethodCallback<List<FeatureBean>> callback) {
            super("getFeatures", (byte)1, callback);
            this.md5List = md5List;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5List != null) {
                protocol.writeFieldBegin("md5List", 1, (byte)15);
                protocol.writeListBegin((byte)11, this.md5List.size());
                for (String item0 : this.md5List) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<FeatureBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<FeatureBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<FeatureBean> value = new ArrayList<FeatureBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                FeatureBean item0 = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureBytesTruncationCall
    extends MethodCall<ByteString> {
        private final String md5;
        private final Boolean truncation;

        GetFeatureBytesTruncationCall(String md5, Boolean truncation, ServiceMethodCallback<ByteString> callback) {
            super("getFeatureBytesTruncation", (byte)1, callback);
            this.md5 = md5;
            if (truncation == null) {
                throw new NullPointerException("truncation");
            }
            this.truncation = truncation;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("truncation", 2, (byte)2);
            protocol.writeBool(this.truncation.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ByteString receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ByteString result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            result = value = protocol.readBinary();
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureBytesListCall
    extends MethodCall<List<ByteString>> {
        private final List<String> md5List;
        private final Boolean truncation;

        GetFeatureBytesListCall(List<String> md5List, Boolean truncation, ServiceMethodCallback<List<ByteString>> callback) {
            super("getFeatureBytesList", (byte)1, callback);
            this.md5List = md5List;
            if (truncation == null) {
                throw new NullPointerException("truncation");
            }
            this.truncation = truncation;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5List != null) {
                protocol.writeFieldBegin("md5List", 1, (byte)15);
                protocol.writeListBegin((byte)11, this.md5List.size());
                for (String item0 : this.md5List) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("truncation", 2, (byte)2);
            protocol.writeBool(this.truncation.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<ByteString> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<ByteString> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<ByteString> value = new ArrayList<ByteString>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                ByteString item0 = protocol.readBinary();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureBytesCall
    extends MethodCall<ByteString> {
        private final String md5;

        GetFeatureBytesCall(String md5, ServiceMethodCallback<ByteString> callback) {
            super("getFeatureBytes", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ByteString receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ByteString result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            result = value = protocol.readBinary();
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFeatureCall
    extends MethodCall<FeatureBean> {
        private final String md5;

        GetFeatureCall(String md5, ServiceMethodCallback<FeatureBean> callback) {
            super("getFeature", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FeatureBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFacesOfImageCall
    extends MethodCall<List<FaceBean>> {
        private final String imageMd5;

        GetFacesOfImageCall(String imageMd5, ServiceMethodCallback<List<FaceBean>> callback) {
            super("getFacesOfImage", (byte)1, callback);
            this.imageMd5 = imageMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageMd5 != null) {
                protocol.writeFieldBegin("imageMd5", 1, (byte)11);
                protocol.writeString(this.imageMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<FaceBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<FaceBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<FaceBean> value = new ArrayList<FaceBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                FaceBean item0 = (FaceBean)FaceBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFacesOfFeatureCall
    extends MethodCall<List<FaceBean>> {
        private final String featureMd5;

        GetFacesOfFeatureCall(String featureMd5, ServiceMethodCallback<List<FaceBean>> callback) {
            super("getFacesOfFeature", (byte)1, callback);
            this.featureMd5 = featureMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 1, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<FaceBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<FaceBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<FaceBean> value = new ArrayList<FaceBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                FaceBean item0 = (FaceBean)FaceBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFaceApiParametersCall
    extends MethodCall<Map<String, String>> {
        private final Token token;

        GetFaceApiParametersCall(Token token, ServiceMethodCallback<Map<String, String>> callback) {
            super("getFaceApiParameters", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, String> value = new HashMap<String, String>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                String value0 = protocol.readString();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetFaceCall
    extends MethodCall<FaceBean> {
        private final Integer faceId;

        GetFaceCall(Integer faceId, ServiceMethodCallback<FaceBean> callback) {
            super("getFace", (byte)1, callback);
            if (faceId == null) {
                throw new NullPointerException("faceId");
            }
            this.faceId = faceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("faceId", 1, (byte)8);
            protocol.writeI32(this.faceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FaceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FaceBean)FaceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDevicesOfGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        GetDevicesOfGroupCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getDevicesOfGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDevicesCall
    extends MethodCall<List<DeviceBean>> {
        private final List<Integer> idList;

        GetDevicesCall(List<Integer> idList, ServiceMethodCallback<List<DeviceBean>> callback) {
            super("getDevices", (byte)1, callback);
            this.idList = idList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.idList != null) {
                protocol.writeFieldBegin("idList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.idList.size());
                for (Integer item0 : this.idList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<DeviceBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<DeviceBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<DeviceBean> value = new ArrayList<DeviceBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                DeviceBean item0 = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceIdOfFeatureCall
    extends MethodCall<Integer> {
        private final String featureMd5;

        GetDeviceIdOfFeatureCall(String featureMd5, ServiceMethodCallback<Integer> callback) {
            super("getDeviceIdOfFeature", (byte)1, callback);
            this.featureMd5 = featureMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 1, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupsPermittedByCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        GetDeviceGroupsPermittedByCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getDeviceGroupsPermittedBy", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupsPermitCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        GetDeviceGroupsPermitCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("getDeviceGroupsPermit", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupsBelongsCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceId;

        GetDeviceGroupsBelongsCall(Integer deviceId, ServiceMethodCallback<List<Integer>> callback) {
            super("getDeviceGroupsBelongs", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupsCall
    extends MethodCall<List<DeviceGroupBean>> {
        private final List<Integer> groupIdList;

        GetDeviceGroupsCall(List<Integer> groupIdList, ServiceMethodCallback<List<DeviceGroupBean>> callback) {
            super("getDeviceGroups", (byte)1, callback);
            this.groupIdList = groupIdList;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.groupIdList != null) {
                protocol.writeFieldBegin("groupIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.groupIdList.size());
                for (Integer item0 : this.groupIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<DeviceGroupBean> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<DeviceGroupBean> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<DeviceGroupBean> value = new ArrayList<DeviceGroupBean>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                DeviceGroupBean item0 = (DeviceGroupBean)DeviceGroupBean.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceGroupCall
    extends MethodCall<DeviceGroupBean> {
        private final Integer deviceGroupId;

        GetDeviceGroupCall(Integer deviceGroupId, ServiceMethodCallback<DeviceGroupBean> callback) {
            super("getDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceGroupBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceGroupBean)DeviceGroupBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceByMacCall
    extends MethodCall<DeviceBean> {
        private final String mac;

        GetDeviceByMacCall(String mac, ServiceMethodCallback<DeviceBean> callback) {
            super("getDeviceByMac", (byte)1, callback);
            this.mac = mac;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.mac != null) {
                protocol.writeFieldBegin("mac", 1, (byte)11);
                protocol.writeString(this.mac);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class GetDeviceCall
    extends MethodCall<DeviceBean> {
        private final Integer deviceId;

        GetDeviceCall(Integer deviceId, ServiceMethodCallback<DeviceBean> callback) {
            super("getDevice", (byte)1, callback);
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceId", 1, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected DeviceBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (DeviceBean)DeviceBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class FuzzySearchPersonCall
    extends MethodCall<List<MatchEntry>> {
        private final String column;
        private final String pattern;
        private final StringMatchType matchType;
        private final Integer matchFlags;
        private final Integer parentGroupId;
        private final Integer maxMatchCount;
        private final Token token;

        FuzzySearchPersonCall(String column, String pattern, StringMatchType matchType, Integer matchFlags, Integer parentGroupId, Integer maxMatchCount, Token token, ServiceMethodCallback<List<MatchEntry>> callback) {
            super("fuzzySearchPerson", (byte)1, callback);
            this.column = column;
            this.pattern = pattern;
            this.matchType = matchType;
            if (matchFlags == null) {
                throw new NullPointerException("matchFlags");
            }
            this.matchFlags = matchFlags;
            if (parentGroupId == null) {
                throw new NullPointerException("parentGroupId");
            }
            this.parentGroupId = parentGroupId;
            if (maxMatchCount == null) {
                throw new NullPointerException("maxMatchCount");
            }
            this.maxMatchCount = maxMatchCount;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.column != null) {
                protocol.writeFieldBegin("column", 1, (byte)11);
                protocol.writeString(this.column);
                protocol.writeFieldEnd();
            }
            if (this.pattern != null) {
                protocol.writeFieldBegin("pattern", 2, (byte)11);
                protocol.writeString(this.pattern);
                protocol.writeFieldEnd();
            }
            if (this.matchType != null) {
                protocol.writeFieldBegin("matchType", 3, (byte)8);
                protocol.writeI32(this.matchType.value);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("matchFlags", 4, (byte)8);
            protocol.writeI32(this.matchFlags.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("parentGroupId", 5, (byte)8);
            protocol.writeI32(this.parentGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("maxMatchCount", 6, (byte)8);
            protocol.writeI32(this.maxMatchCount.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 7, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<MatchEntry> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<MatchEntry> result = null;
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<MatchEntry> value = new ArrayList<MatchEntry>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                MatchEntry item0 = (MatchEntry)MatchEntry.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (FuzzyMatchCountExceedLimitException)FuzzyMatchCountExceedLimitException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class FuzzySearchCall
    extends MethodCall<List<MatchEntry>> {
        private final String tablename;
        private final String column;
        private final String pattern;
        private final StringMatchType matchType;
        private final Integer matchFlags;
        private final Integer parentGroupId;
        private final Integer maxMatchCount;

        FuzzySearchCall(String tablename, String column, String pattern, StringMatchType matchType, Integer matchFlags, Integer parentGroupId, Integer maxMatchCount, ServiceMethodCallback<List<MatchEntry>> callback) {
            super("fuzzySearch", (byte)1, callback);
            this.tablename = tablename;
            this.column = column;
            this.pattern = pattern;
            this.matchType = matchType;
            if (matchFlags == null) {
                throw new NullPointerException("matchFlags");
            }
            this.matchFlags = matchFlags;
            if (parentGroupId == null) {
                throw new NullPointerException("parentGroupId");
            }
            this.parentGroupId = parentGroupId;
            if (maxMatchCount == null) {
                throw new NullPointerException("maxMatchCount");
            }
            this.maxMatchCount = maxMatchCount;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.tablename != null) {
                protocol.writeFieldBegin("tablename", 1, (byte)11);
                protocol.writeString(this.tablename);
                protocol.writeFieldEnd();
            }
            if (this.column != null) {
                protocol.writeFieldBegin("column", 2, (byte)11);
                protocol.writeString(this.column);
                protocol.writeFieldEnd();
            }
            if (this.pattern != null) {
                protocol.writeFieldBegin("pattern", 3, (byte)11);
                protocol.writeString(this.pattern);
                protocol.writeFieldEnd();
            }
            if (this.matchType != null) {
                protocol.writeFieldBegin("matchType", 4, (byte)8);
                protocol.writeI32(this.matchType.value);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("matchFlags", 5, (byte)8);
            protocol.writeI32(this.matchFlags.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("parentGroupId", 6, (byte)8);
            protocol.writeI32(this.parentGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("maxMatchCount", 7, (byte)8);
            protocol.writeI32(this.maxMatchCount.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<MatchEntry> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<MatchEntry> result = null;
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<MatchEntry> value = new ArrayList<MatchEntry>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                MatchEntry item0 = (MatchEntry)MatchEntry.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (FuzzyMatchCountExceedLimitException)FuzzyMatchCountExceedLimitException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class FaceRecognizePersonPermittedCall
    extends MethodCall<Integer> {
        private final ByteString imageData;
        private final Double threshold;
        private final Integer group;
        private final Integer deviceId;
        private final Boolean searchInPermited;

        FaceRecognizePersonPermittedCall(ByteString imageData, Double threshold, Integer group, Integer deviceId, Boolean searchInPermited, ServiceMethodCallback<Integer> callback) {
            super("faceRecognizePersonPermitted", (byte)1, callback);
            this.imageData = imageData;
            this.threshold = threshold;
            if (group == null) {
                throw new NullPointerException("group");
            }
            this.group = group;
            if (deviceId == null) {
                throw new NullPointerException("deviceId");
            }
            this.deviceId = deviceId;
            if (searchInPermited == null) {
                throw new NullPointerException("searchInPermited");
            }
            this.searchInPermited = searchInPermited;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageData != null) {
                protocol.writeFieldBegin("imageData", 1, (byte)11);
                protocol.writeBinary(this.imageData);
                protocol.writeFieldEnd();
            }
            if (this.threshold != null) {
                protocol.writeFieldBegin("threshold", 2, (byte)4);
                protocol.writeDouble(this.threshold.doubleValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("group", 3, (byte)8);
            protocol.writeI32(this.group.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deviceId", 4, (byte)8);
            protocol.writeI32(this.deviceId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("searchInPermited", 5, (byte)2);
            protocol.writeBool(this.searchInPermited.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ExistsPersonCall
    extends MethodCall<Boolean> {
        private final Integer persionId;

        ExistsPersonCall(Integer persionId, ServiceMethodCallback<Boolean> callback) {
            super("existsPerson", (byte)1, callback);
            if (persionId == null) {
                throw new NullPointerException("persionId");
            }
            this.persionId = persionId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("persionId", 1, (byte)8);
            protocol.writeI32(this.persionId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ExistsImageCall
    extends MethodCall<Boolean> {
        private final String md5;

        ExistsImageCall(String md5, ServiceMethodCallback<Boolean> callback) {
            super("existsImage", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ExistsFeatureCall
    extends MethodCall<Boolean> {
        private final String md5;

        ExistsFeatureCall(String md5, ServiceMethodCallback<Boolean> callback) {
            super("existsFeature", (byte)1, callback);
            this.md5 = md5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.md5 != null) {
                protocol.writeFieldBegin("md5", 1, (byte)11);
                protocol.writeString(this.md5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ExistsDeviceCall
    extends MethodCall<Boolean> {
        private final Integer id;

        ExistsDeviceCall(Integer id, ServiceMethodCallback<Boolean> callback) {
            super("existsDevice", (byte)1, callback);
            if (id == null) {
                throw new NullPointerException("id");
            }
            this.id = id;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("id", 1, (byte)8);
            protocol.writeI32(this.id.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DisablePersonListCall
    extends MethodCall<Void> {
        private final List<Integer> personIdList;
        private final Token token;

        DisablePersonListCall(List<Integer> personIdList, Token token, ServiceMethodCallback<Void> callback) {
            super("disablePersonList", (byte)1, callback);
            this.personIdList = personIdList;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personIdList != null) {
                protocol.writeFieldBegin("personIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.personIdList.size());
                for (Integer item0 : this.personIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class DisablePersonCall
    extends MethodCall<Void> {
        private final Integer personId;
        private final Integer moveToGroupId;
        private final Boolean deletePhoto;
        private final Boolean deleteFeature;
        private final Boolean deleteLog;
        private final Token token;

        DisablePersonCall(Integer personId, Integer moveToGroupId, Boolean deletePhoto, Boolean deleteFeature, Boolean deleteLog, Token token, ServiceMethodCallback<Void> callback) {
            super("disablePerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.moveToGroupId = moveToGroupId;
            if (deletePhoto == null) {
                throw new NullPointerException("deletePhoto");
            }
            this.deletePhoto = deletePhoto;
            if (deleteFeature == null) {
                throw new NullPointerException("deleteFeature");
            }
            this.deleteFeature = deleteFeature;
            if (deleteLog == null) {
                throw new NullPointerException("deleteLog");
            }
            this.deleteLog = deleteLog;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.moveToGroupId != null) {
                protocol.writeFieldBegin("moveToGroupId", 2, (byte)8);
                protocol.writeI32(this.moveToGroupId.intValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("deletePhoto", 3, (byte)2);
            protocol.writeBool(this.deletePhoto.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deleteFeature", 4, (byte)2);
            protocol.writeBool(this.deleteFeature.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deleteLog", 5, (byte)2);
            protocol.writeBool(this.deleteLog.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 6, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class DeletePersonsByPapersNumCall
    extends MethodCall<Integer> {
        private final List<String> papersNumList;
        private final Token token;

        DeletePersonsByPapersNumCall(List<String> papersNumList, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonsByPapersNum", (byte)1, callback);
            this.papersNumList = papersNumList;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.papersNumList != null) {
                protocol.writeFieldBegin("papersNumList", 1, (byte)15);
                protocol.writeListBegin((byte)11, this.papersNumList.size());
                for (String item0 : this.papersNumList) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonsByMobilePhoneCall
    extends MethodCall<Integer> {
        private final List<String> mobilePhoneList;
        private final Token token;

        DeletePersonsByMobilePhoneCall(List<String> mobilePhoneList, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonsByMobilePhone", (byte)1, callback);
            this.mobilePhoneList = mobilePhoneList;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.mobilePhoneList != null) {
                protocol.writeFieldBegin("mobilePhoneList", 1, (byte)15);
                protocol.writeListBegin((byte)11, this.mobilePhoneList.size());
                for (String item0 : this.mobilePhoneList) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonsCall
    extends MethodCall<Integer> {
        private final List<Integer> personIdList;
        private final Token token;

        DeletePersonsCall(List<Integer> personIdList, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersons", (byte)1, callback);
            this.personIdList = personIdList;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.personIdList != null) {
                protocol.writeFieldBegin("personIdList", 1, (byte)15);
                protocol.writeListBegin((byte)8, this.personIdList.size());
                for (Integer item0 : this.personIdList) {
                    protocol.writeI32(item0.intValue());
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonGroupPermitCall
    extends MethodCall<Integer> {
        private final Integer personGroupId;
        private final Token token;

        DeletePersonGroupPermitCall(Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonGroupPermit", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonGroupCall
    extends MethodCall<Integer> {
        private final Integer personGroupId;
        private final Token token;

        DeletePersonGroupCall(Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonByPapersNumCall
    extends MethodCall<Integer> {
        private final String papersNum;
        private final Token token;

        DeletePersonByPapersNumCall(String papersNum, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonByPapersNum", (byte)1, callback);
            this.papersNum = papersNum;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.papersNum != null) {
                protocol.writeFieldBegin("papersNum", 1, (byte)11);
                protocol.writeString(this.papersNum);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonByMobilePhoneCall
    extends MethodCall<Integer> {
        private final String mobilePhone;
        private final Token token;

        DeletePersonByMobilePhoneCall(String mobilePhone, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePersonByMobilePhone", (byte)1, callback);
            this.mobilePhone = mobilePhone;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.mobilePhone != null) {
                protocol.writeFieldBegin("mobilePhone", 1, (byte)11);
                protocol.writeString(this.mobilePhone);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePersonCall
    extends MethodCall<Integer> {
        private final Integer personId;
        private final Token token;

        DeletePersonCall(Integer personId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePerson", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeletePermitByIdCall
    extends MethodCall<Integer> {
        private final Integer deviceGroupId;
        private final Integer personGroupId;
        private final Token token;

        DeletePermitByIdCall(Integer deviceGroupId, Integer personGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deletePermitById", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("personGroupId", 2, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteLogByWhereCall
    extends MethodCall<Integer> {
        private final String where;
        private final Token token;

        DeleteLogByWhereCall(String where, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteLogByWhere", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteImageCall
    extends MethodCall<Integer> {
        private final String imageMd5;
        private final Token token;

        DeleteImageCall(String imageMd5, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteImage", (byte)1, callback);
            this.imageMd5 = imageMd5;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageMd5 != null) {
                protocol.writeFieldBegin("imageMd5", 1, (byte)11);
                protocol.writeString(this.imageMd5);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteGroupPermitOnDeviceGroupCall
    extends MethodCall<Integer> {
        private final Integer deviceGroupId;
        private final Token token;

        DeleteGroupPermitOnDeviceGroupCall(Integer deviceGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteGroupPermitOnDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteFeatureCall
    extends MethodCall<List<String>> {
        private final String featureMd5;
        private final Boolean deleteImage;
        private final Token token;

        DeleteFeatureCall(String featureMd5, Boolean deleteImage, Token token, ServiceMethodCallback<List<String>> callback) {
            super("deleteFeature", (byte)1, callback);
            this.featureMd5 = featureMd5;
            if (deleteImage == null) {
                throw new NullPointerException("deleteImage");
            }
            this.deleteImage = deleteImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.featureMd5 != null) {
                protocol.writeFieldBegin("featureMd5", 1, (byte)11);
                protocol.writeString(this.featureMd5);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("deleteImage", 2, (byte)2);
            protocol.writeBool(this.deleteImage.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<String> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<String> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteErrorLogByWhereCall
    extends MethodCall<Integer> {
        private final String where;
        private final Token token;

        DeleteErrorLogByWhereCall(String where, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteErrorLogByWhere", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteDeviceGroupCall
    extends MethodCall<Integer> {
        private final Integer deviceGroupId;
        private final Token token;

        DeleteDeviceGroupCall(Integer deviceGroupId, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteDeviceByMacCall
    extends MethodCall<Boolean> {
        private final String mac;
        private final Token token;

        DeleteDeviceByMacCall(String mac, Token token, ServiceMethodCallback<Boolean> callback) {
            super("deleteDeviceByMac", (byte)1, callback);
            this.mac = mac;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.mac != null) {
                protocol.writeFieldBegin("mac", 1, (byte)11);
                protocol.writeString(this.mac);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteDeviceCall
    extends MethodCall<Boolean> {
        private final Integer id;
        private final Token token;

        DeleteDeviceCall(Integer id, Token token, ServiceMethodCallback<Boolean> callback) {
            super("deleteDevice", (byte)1, callback);
            if (id == null) {
                throw new NullPointerException("id");
            }
            this.id = id;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("id", 1, (byte)8);
            protocol.writeI32(this.id.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Boolean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Boolean result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class DeleteAllFeaturesByPersonIdCall
    extends MethodCall<Integer> {
        private final Integer personId;
        private final Boolean deleteImage;
        private final Token token;

        DeleteAllFeaturesByPersonIdCall(Integer personId, Boolean deleteImage, Token token, ServiceMethodCallback<Integer> callback) {
            super("deleteAllFeaturesByPersonId", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            if (deleteImage == null) {
                throw new NullPointerException("deleteImage");
            }
            this.deleteImage = deleteImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deleteImage", 2, (byte)2);
            protocol.writeBool(this.deleteImage.booleanValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CreateTempPwdWithDurationCall
    extends MethodCall<String> {
        private final Integer targetId;
        private final TmpPwdTargetType targetType;
        private final Integer duration;
        private final Token token;

        CreateTempPwdWithDurationCall(Integer targetId, TmpPwdTargetType targetType, Integer duration, Token token, ServiceMethodCallback<String> callback) {
            super("createTempPwdWithDuration", (byte)1, callback);
            if (targetId == null) {
                throw new NullPointerException("targetId");
            }
            this.targetId = targetId;
            this.targetType = targetType;
            if (duration == null) {
                throw new NullPointerException("duration");
            }
            this.duration = duration;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("targetId", 1, (byte)8);
            protocol.writeI32(this.targetId.intValue());
            protocol.writeFieldEnd();
            if (this.targetType != null) {
                protocol.writeFieldBegin("targetType", 2, (byte)8);
                protocol.writeI32(this.targetType.value);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("duration", 3, (byte)8);
            protocol.writeI32(this.duration.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CreateTempPwdCall
    extends MethodCall<String> {
        private final Integer targetId;
        private final TmpPwdTargetType targetType;
        private final String expiryDate;
        private final Token token;

        CreateTempPwdCall(Integer targetId, TmpPwdTargetType targetType, String expiryDate, Token token, ServiceMethodCallback<String> callback) {
            super("createTempPwd", (byte)1, callback);
            if (targetId == null) {
                throw new NullPointerException("targetId");
            }
            this.targetId = targetId;
            this.targetType = targetType;
            this.expiryDate = expiryDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("targetId", 1, (byte)8);
            protocol.writeI32(this.targetId.intValue());
            protocol.writeFieldEnd();
            if (this.targetType != null) {
                protocol.writeFieldBegin("targetType", 2, (byte)8);
                protocol.writeI32(this.targetType.value);
                protocol.writeFieldEnd();
            }
            if (this.expiryDate != null) {
                protocol.writeFieldBegin("expiryDate", 3, (byte)11);
                protocol.writeString(this.expiryDate);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonLogTimeStrSafeCall
    extends MethodCall<Map<String, Integer>> {
        private final Integer personId;
        private final String startDate;
        private final String endDate;
        private final Token token;

        CountPersonLogTimeStrSafeCall(Integer personId, String startDate, String endDate, Token token, ServiceMethodCallback<Map<String, Integer>> callback) {
            super("countPersonLogTimeStrSafe", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.startDate = startDate;
            this.endDate = endDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.startDate != null) {
                protocol.writeFieldBegin("startDate", 2, (byte)11);
                protocol.writeString(this.startDate);
                protocol.writeFieldEnd();
            }
            if (this.endDate != null) {
                protocol.writeFieldBegin("endDate", 3, (byte)11);
                protocol.writeString(this.endDate);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, Integer> value = new HashMap<String, Integer>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                int value0 = protocol.readI32();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonLogTimeStrCall
    extends MethodCall<Map<String, Integer>> {
        private final Integer personId;
        private final String startDate;
        private final String endDate;

        CountPersonLogTimeStrCall(Integer personId, String startDate, String endDate, ServiceMethodCallback<Map<String, Integer>> callback) {
            super("countPersonLogTimeStr", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.startDate != null) {
                protocol.writeFieldBegin("startDate", 2, (byte)11);
                protocol.writeString(this.startDate);
                protocol.writeFieldEnd();
            }
            if (this.endDate != null) {
                protocol.writeFieldBegin("endDate", 3, (byte)11);
                protocol.writeString(this.endDate);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, Integer> value = new HashMap<String, Integer>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                int value0 = protocol.readI32();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonLogSafeCall
    extends MethodCall<Map<String, Integer>> {
        private final Integer personId;
        private final Long startDate;
        private final Long endDate;
        private final Token token;

        CountPersonLogSafeCall(Integer personId, Long startDate, Long endDate, Token token, ServiceMethodCallback<Map<String, Integer>> callback) {
            super("countPersonLogSafe", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.startDate = startDate;
            this.endDate = endDate;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.startDate != null) {
                protocol.writeFieldBegin("startDate", 2, (byte)10);
                protocol.writeI64(this.startDate.longValue());
                protocol.writeFieldEnd();
            }
            if (this.endDate != null) {
                protocol.writeFieldBegin("endDate", 3, (byte)10);
                protocol.writeI64(this.endDate.longValue());
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, Integer> value = new HashMap<String, Integer>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                int value0 = protocol.readI32();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonLogCall
    extends MethodCall<Map<String, Integer>> {
        private final Integer personId;
        private final Long startDate;
        private final Long endDate;

        CountPersonLogCall(Integer personId, Long startDate, Long endDate, ServiceMethodCallback<Map<String, Integer>> callback) {
            super("countPersonLog", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.startDate != null) {
                protocol.writeFieldBegin("startDate", 2, (byte)10);
                protocol.writeI64(this.startDate.longValue());
                protocol.writeFieldEnd();
            }
            if (this.endDate != null) {
                protocol.writeFieldBegin("endDate", 3, (byte)10);
                protocol.writeI64(this.endDate.longValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Map<String, Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            HashMap<String, Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            HashMap<String, Integer> value = new HashMap<String, Integer>(mapMetadata0.size);
                            for (int i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                int value0 = protocol.readI32();
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonGroupByWhereSafeCall
    extends MethodCall<Integer> {
        private final String where;
        private final Token token;

        CountPersonGroupByWhereSafeCall(String where, Token token, ServiceMethodCallback<Integer> callback) {
            super("countPersonGroupByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonGroupByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountPersonGroupByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countPersonGroupByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonByWhereSafeCall
    extends MethodCall<Integer> {
        private final String where;
        private final Token token;

        CountPersonByWhereSafeCall(String where, Token token, ServiceMethodCallback<Integer> callback) {
            super("countPersonByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountPersonByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountPersonByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countPersonByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByWhereSafeCall
    extends MethodCall<Integer> {
        private final String where;
        private final Token token;

        CountLogLightByWhereSafeCall(String where, Token token, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountLogLightByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByVerifyTimeTimestrSafeCall
    extends MethodCall<Integer> {
        private final String timestamp;
        private final Token token;

        CountLogLightByVerifyTimeTimestrSafeCall(String timestamp, Token token, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByVerifyTimeTimestrSafe", (byte)1, callback);
            this.timestamp = timestamp;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByVerifyTimeTimestrCall
    extends MethodCall<Integer> {
        private final String timestamp;

        CountLogLightByVerifyTimeTimestrCall(String timestamp, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByVerifyTimeTimestr", (byte)1, callback);
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.timestamp != null) {
                protocol.writeFieldBegin("timestamp", 1, (byte)11);
                protocol.writeString(this.timestamp);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByVerifyTimeSafeCall
    extends MethodCall<Integer> {
        private final Long timestamp;
        private final Token token;

        CountLogLightByVerifyTimeSafeCall(Long timestamp, Token token, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByVerifyTimeSafe", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogLightByVerifyTimeCall
    extends MethodCall<Integer> {
        private final Long timestamp;

        CountLogLightByVerifyTimeCall(Long timestamp, ServiceMethodCallback<Integer> callback) {
            super("countLogLightByVerifyTime", (byte)1, callback);
            if (timestamp == null) {
                throw new NullPointerException("timestamp");
            }
            this.timestamp = timestamp;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("timestamp", 1, (byte)10);
            protocol.writeI64(this.timestamp.longValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogByWhereSafeCall
    extends MethodCall<Integer> {
        private final String where;
        private final Token token;

        CountLogByWhereSafeCall(String where, Token token, ServiceMethodCallback<Integer> callback) {
            super("countLogByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountLogByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountLogByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countLogByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountErrorLogByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountErrorLogByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countErrorLogByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountDeviceGroupByWhereSafeCall
    extends MethodCall<Integer> {
        private final String where;
        private final Token token;

        CountDeviceGroupByWhereSafeCall(String where, Token token, ServiceMethodCallback<Integer> callback) {
            super("countDeviceGroupByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountDeviceGroupByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountDeviceGroupByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countDeviceGroupByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountDeviceByWhereSafeCall
    extends MethodCall<Integer> {
        private final String where;
        private final Token token;

        CountDeviceByWhereSafeCall(String where, Token token, ServiceMethodCallback<Integer> callback) {
            super("countDeviceByWhereSafe", (byte)1, callback);
            this.where = where;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class CountDeviceByWhereCall
    extends MethodCall<Integer> {
        private final String where;

        CountDeviceByWhereCall(String where, ServiceMethodCallback<Integer> callback) {
            super("countDeviceByWhere", (byte)1, callback);
            this.where = where;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.where != null) {
                protocol.writeFieldBegin("where", 1, (byte)11);
                protocol.writeString(this.where);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ChildListForPersonGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer personGroupId;

        ChildListForPersonGroupCall(Integer personGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("childListForPersonGroup", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ChildListForDeviceGroupCall
    extends MethodCall<List<Integer>> {
        private final Integer deviceGroupId;

        ChildListForDeviceGroupCall(Integer deviceGroupId, ServiceMethodCallback<List<Integer>> callback) {
            super("childListForDeviceGroup", (byte)1, callback);
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("deviceGroupId", 1, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected List<Integer> receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ArrayList<Integer> result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<Integer> value = new ArrayList<Integer>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                int item0 = protocol.readI32();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class BindBorderCall
    extends MethodCall<Void> {
        private final Integer personGroupId;
        private final Integer deviceGroupId;
        private final Token token;

        BindBorderCall(Integer personGroupId, Integer deviceGroupId, Token token, ServiceMethodCallback<Void> callback) {
            super("bindBorder", (byte)1, callback);
            if (personGroupId == null) {
                throw new NullPointerException("personGroupId");
            }
            this.personGroupId = personGroupId;
            if (deviceGroupId == null) {
                throw new NullPointerException("deviceGroupId");
            }
            this.deviceGroupId = deviceGroupId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personGroupId", 1, (byte)8);
            protocol.writeI32(this.personGroupId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldBegin("deviceGroupId", 2, (byte)8);
            protocol.writeI32(this.deviceGroupId.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }

    private static final class ApplyUserTokenCall
    extends MethodCall<Token> {
        private final Integer userid;
        private final String password;
        private final Boolean isMd5;

        ApplyUserTokenCall(Integer userid, String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
            super("applyUserToken", (byte)1, callback);
            if (userid == null) {
                throw new NullPointerException("userid");
            }
            this.userid = userid;
            this.password = password;
            if (isMd5 == null) {
                throw new NullPointerException("isMd5");
            }
            this.isMd5 = isMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("userid", 1, (byte)8);
            protocol.writeI32(this.userid.intValue());
            protocol.writeFieldEnd();
            if (this.password != null) {
                protocol.writeFieldBegin("password", 2, (byte)11);
                protocol.writeString(this.password);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("isMd5", 3, (byte)2);
            protocol.writeBool(this.isMd5.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Token receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (Token)Token.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyRootTokenCall
    extends MethodCall<Token> {
        private final String password;
        private final Boolean isMd5;

        ApplyRootTokenCall(String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
            super("applyRootToken", (byte)1, callback);
            this.password = password;
            if (isMd5 == null) {
                throw new NullPointerException("isMd5");
            }
            this.isMd5 = isMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.password != null) {
                protocol.writeFieldBegin("password", 1, (byte)11);
                protocol.writeString(this.password);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("isMd5", 2, (byte)2);
            protocol.writeBool(this.isMd5.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Token receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (Token)Token.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyPersonTokenCall
    extends MethodCall<Token> {
        private final Integer personId;
        private final String password;
        private final Boolean isMd5;

        ApplyPersonTokenCall(Integer personId, String password, Boolean isMd5, ServiceMethodCallback<Token> callback) {
            super("applyPersonToken", (byte)1, callback);
            if (personId == null) {
                throw new NullPointerException("personId");
            }
            this.personId = personId;
            this.password = password;
            if (isMd5 == null) {
                throw new NullPointerException("isMd5");
            }
            this.isMd5 = isMd5;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("personId", 1, (byte)8);
            protocol.writeI32(this.personId.intValue());
            protocol.writeFieldEnd();
            if (this.password != null) {
                protocol.writeFieldBegin("password", 2, (byte)11);
                protocol.writeString(this.password);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("isMd5", 3, (byte)2);
            protocol.writeBool(this.isMd5.booleanValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Token receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (Token)Token.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceSecurityException)ServiceSecurityException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyCmdSnCall
    extends MethodCall<Integer> {
        private final Token token;

        ApplyCmdSnCall(Token token, ServiceMethodCallback<Integer> callback) {
            super("applyCmdSn", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Integer receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Integer result = null;
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyAckChannelWithDurationCall
    extends MethodCall<String> {
        private final Integer duration;
        private final Token token;

        ApplyAckChannelWithDurationCall(Integer duration, Token token, ServiceMethodCallback<String> callback) {
            super("applyAckChannelWithDuration", (byte)1, callback);
            if (duration == null) {
                throw new NullPointerException("duration");
            }
            this.duration = duration;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            protocol.writeFieldBegin("duration", 1, (byte)8);
            protocol.writeI32(this.duration.intValue());
            protocol.writeFieldEnd();
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class ApplyAckChannelCall
    extends MethodCall<String> {
        private final Token token;

        ApplyAckChannelCall(Token token, ServiceMethodCallback<String> callback) {
            super("applyAckChannel", (byte)1, callback);
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.token != null) {
                protocol.writeFieldBegin("token", 1, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected String receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            String result = null;
            Object ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            result = value;
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddLogsWithFaceImageCall
    extends MethodCall<Void> {
        private final List<LogBean> logBeans;
        private final List<ByteString> faceImages;
        private final Token token;

        AddLogsWithFaceImageCall(List<LogBean> logBeans, List<ByteString> faceImages, Token token, ServiceMethodCallback<Void> callback) {
            super("addLogsWithFaceImage", (byte)1, callback);
            this.logBeans = logBeans;
            this.faceImages = faceImages;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBeans != null) {
                protocol.writeFieldBegin("logBeans", 1, (byte)15);
                protocol.writeListBegin((byte)12, this.logBeans.size());
                for (LogBean logBean : this.logBeans) {
                    LogBean.ADAPTER.write(protocol, (Object)logBean);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.faceImages != null) {
                protocol.writeFieldBegin("faceImages", 2, (byte)15);
                protocol.writeListBegin((byte)11, this.faceImages.size());
                for (ByteString byteString : this.faceImages) {
                    protocol.writeBinary(byteString);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddLogsFullCall
    extends MethodCall<Void> {
        private final List<LogBean> logBeans;
        private final List<FaceBean> faceBeans;
        private final List<ByteString> featureImages;
        private final Token token;

        AddLogsFullCall(List<LogBean> logBeans, List<FaceBean> faceBeans, List<ByteString> featureImages, Token token, ServiceMethodCallback<Void> callback) {
            super("addLogsFull", (byte)1, callback);
            this.logBeans = logBeans;
            this.faceBeans = faceBeans;
            this.featureImages = featureImages;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBeans != null) {
                protocol.writeFieldBegin("logBeans", 1, (byte)15);
                protocol.writeListBegin((byte)12, this.logBeans.size());
                for (LogBean logBean : this.logBeans) {
                    LogBean.ADAPTER.write(protocol, (Object)logBean);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.faceBeans != null) {
                protocol.writeFieldBegin("faceBeans", 2, (byte)15);
                protocol.writeListBegin((byte)12, this.faceBeans.size());
                for (FaceBean faceBean : this.faceBeans) {
                    FaceBean.ADAPTER.write(protocol, (Object)faceBean);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.featureImages != null) {
                protocol.writeFieldBegin("featureImages", 3, (byte)15);
                protocol.writeListBegin((byte)11, this.featureImages.size());
                for (ByteString byteString : this.featureImages) {
                    protocol.writeBinary(byteString);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddLogsCall
    extends MethodCall<Void> {
        private final List<LogBean> logBeans;
        private final Token token;

        AddLogsCall(List<LogBean> logBeans, Token token, ServiceMethodCallback<Void> callback) {
            super("addLogs", (byte)1, callback);
            this.logBeans = logBeans;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBeans != null) {
                protocol.writeFieldBegin("logBeans", 1, (byte)15);
                protocol.writeListBegin((byte)12, this.logBeans.size());
                for (LogBean item0 : this.logBeans) {
                    LogBean.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddLogWithFaceImageCall
    extends MethodCall<Void> {
        private final LogBean logBean;
        private final ByteString faceImage;
        private final Token token;

        AddLogWithFaceImageCall(LogBean logBean, ByteString faceImage, Token token, ServiceMethodCallback<Void> callback) {
            super("addLogWithFaceImage", (byte)1, callback);
            this.logBean = logBean;
            this.faceImage = faceImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBean != null) {
                protocol.writeFieldBegin("logBean", 1, (byte)12);
                LogBean.ADAPTER.write(protocol, (Object)this.logBean);
                protocol.writeFieldEnd();
            }
            if (this.faceImage != null) {
                protocol.writeFieldBegin("faceImage", 2, (byte)11);
                protocol.writeBinary(this.faceImage);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 3, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddLogFullCall
    extends MethodCall<Void> {
        private final LogBean logBean;
        private final FaceBean faceBean;
        private final ByteString featureImage;
        private final Token token;

        AddLogFullCall(LogBean logBean, FaceBean faceBean, ByteString featureImage, Token token, ServiceMethodCallback<Void> callback) {
            super("addLogFull", (byte)1, callback);
            this.logBean = logBean;
            this.faceBean = faceBean;
            this.featureImage = featureImage;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBean != null) {
                protocol.writeFieldBegin("logBean", 1, (byte)12);
                LogBean.ADAPTER.write(protocol, (Object)this.logBean);
                protocol.writeFieldEnd();
            }
            if (this.faceBean != null) {
                protocol.writeFieldBegin("faceBean", 2, (byte)12);
                FaceBean.ADAPTER.write(protocol, (Object)this.faceBean);
                protocol.writeFieldEnd();
            }
            if (this.featureImage != null) {
                protocol.writeFieldBegin("featureImage", 3, (byte)11);
                protocol.writeBinary(this.featureImage);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 4, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddLogCall
    extends MethodCall<Void> {
        private final LogBean logBean;
        private final Token token;

        AddLogCall(LogBean logBean, Token token, ServiceMethodCallback<Void> callback) {
            super("addLog", (byte)1, callback);
            this.logBean = logBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.logBean != null) {
                protocol.writeFieldBegin("logBean", 1, (byte)12);
                LogBean.ADAPTER.write(protocol, (Object)this.logBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Exception ex1 = null;
            Exception ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Exception value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            return null;
        }
    }

    private static final class AddImageCall
    extends MethodCall<ImageBean> {
        private final ByteString imageData;
        private final Integer deviceId;
        private final FaceBean faceBean;
        private final Integer personId;
        private final Token token;

        AddImageCall(ByteString imageData, Integer deviceId, FaceBean faceBean, Integer personId, Token token, ServiceMethodCallback<ImageBean> callback) {
            super("addImage", (byte)1, callback);
            this.imageData = imageData;
            this.deviceId = deviceId;
            this.faceBean = faceBean;
            this.personId = personId;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.imageData != null) {
                protocol.writeFieldBegin("imageData", 1, (byte)11);
                protocol.writeBinary(this.imageData);
                protocol.writeFieldEnd();
            }
            if (this.deviceId != null) {
                protocol.writeFieldBegin("deviceId", 2, (byte)8);
                protocol.writeI32(this.deviceId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.faceBean != null) {
                protocol.writeFieldBegin("faceBean", 3, (byte)12);
                FaceBean.ADAPTER.write(protocol, (Object)this.faceBean);
                protocol.writeFieldEnd();
            }
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 4, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 5, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected ImageBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (ImageBean)ImageBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddFeatureWithImageCall
    extends MethodCall<FeatureBean> {
        private final ByteString feature;
        private final String featureVersion;
        private final Integer personId;
        private final Boolean asIdPhotoIfAbsent;
        private final ByteString featurePhoto;
        private final FaceBean faceBean;
        private final String removed;
        private final Token token;

        AddFeatureWithImageCall(ByteString feature, String featureVersion, Integer personId, Boolean asIdPhotoIfAbsent, ByteString featurePhoto, FaceBean faceBean, String removed, Token token, ServiceMethodCallback<FeatureBean> callback) {
            super("addFeatureWithImage", (byte)1, callback);
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.personId = personId;
            if (asIdPhotoIfAbsent == null) {
                throw new NullPointerException("asIdPhotoIfAbsent");
            }
            this.asIdPhotoIfAbsent = asIdPhotoIfAbsent;
            this.featurePhoto = featurePhoto;
            this.faceBean = faceBean;
            this.removed = removed;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 1, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 2, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 3, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("asIdPhotoIfAbsent", 4, (byte)2);
            protocol.writeBool(this.asIdPhotoIfAbsent.booleanValue());
            protocol.writeFieldEnd();
            if (this.featurePhoto != null) {
                protocol.writeFieldBegin("featurePhoto", 5, (byte)11);
                protocol.writeBinary(this.featurePhoto);
                protocol.writeFieldEnd();
            }
            if (this.faceBean != null) {
                protocol.writeFieldBegin("faceBean", 6, (byte)12);
                FaceBean.ADAPTER.write(protocol, (Object)this.faceBean);
                protocol.writeFieldEnd();
            }
            if (this.removed != null) {
                protocol.writeFieldBegin("removed", 7, (byte)11);
                protocol.writeString(this.removed);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 8, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FeatureBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddFeatureMultiCall
    extends MethodCall<FeatureBean> {
        private final ByteString feature;
        private final String featureVersion;
        private final Integer personId;
        private final List<ByteString> photos;
        private final List<FaceBean> faces;
        private final String removed;
        private final Token token;

        AddFeatureMultiCall(ByteString feature, String featureVersion, Integer personId, List<ByteString> photos, List<FaceBean> faces, String removed, Token token, ServiceMethodCallback<FeatureBean> callback) {
            super("addFeatureMulti", (byte)1, callback);
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.personId = personId;
            this.photos = photos;
            this.faces = faces;
            this.removed = removed;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 1, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 2, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 3, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.photos != null) {
                protocol.writeFieldBegin("photos", 4, (byte)15);
                protocol.writeListBegin((byte)11, this.photos.size());
                for (ByteString byteString : this.photos) {
                    protocol.writeBinary(byteString);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.faces != null) {
                protocol.writeFieldBegin("faces", 5, (byte)15);
                protocol.writeListBegin((byte)12, this.faces.size());
                for (FaceBean faceBean : this.faces) {
                    FaceBean.ADAPTER.write(protocol, (Object)faceBean);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.removed != null) {
                protocol.writeFieldBegin("removed", 6, (byte)11);
                protocol.writeString(this.removed);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 7, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FeatureBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddFeatureCall
    extends MethodCall<FeatureBean> {
        private final ByteString feature;
        private final String featureVersion;
        private final Integer personId;
        private final List<FaceBean> faecBeans;
        private final String removed;
        private final Token token;

        AddFeatureCall(ByteString feature, String featureVersion, Integer personId, List<FaceBean> faecBeans, String removed, Token token, ServiceMethodCallback<FeatureBean> callback) {
            super("addFeature", (byte)1, callback);
            this.feature = feature;
            this.featureVersion = featureVersion;
            this.personId = personId;
            this.faecBeans = faecBeans;
            this.removed = removed;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.feature != null) {
                protocol.writeFieldBegin("feature", 1, (byte)11);
                protocol.writeBinary(this.feature);
                protocol.writeFieldEnd();
            }
            if (this.featureVersion != null) {
                protocol.writeFieldBegin("featureVersion", 2, (byte)11);
                protocol.writeString(this.featureVersion);
                protocol.writeFieldEnd();
            }
            if (this.personId != null) {
                protocol.writeFieldBegin("personId", 3, (byte)8);
                protocol.writeI32(this.personId.intValue());
                protocol.writeFieldEnd();
            }
            if (this.faecBeans != null) {
                protocol.writeFieldBegin("faecBeans", 4, (byte)15);
                protocol.writeListBegin((byte)12, this.faecBeans.size());
                for (FaceBean item0 : this.faecBeans) {
                    FaceBean.ADAPTER.write(protocol, (Object)item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            if (this.removed != null) {
                protocol.writeFieldBegin("removed", 5, (byte)11);
                protocol.writeString(this.removed);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 6, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected FeatureBean receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            Object result = null;
            Object ex1 = null;
            Object ex2 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 0: {
                        Object value;
                        if (field.typeId == 12) {
                            result = value = (FeatureBean)FeatureBean.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 1: {
                        Object value;
                        if (field.typeId == 12) {
                            ex1 = value = (DuplicateRecordException)DuplicateRecordException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        Object value;
                        if (field.typeId == 12) {
                            ex2 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (result != null) {
                return result;
            }
            if (ex1 != null) {
                throw ex1;
            }
            if (ex2 != null) {
                throw ex2;
            }
            throw new ThriftException(ThriftException.Kind.MISSING_RESULT, "Missing result");
        }
    }

    private static final class AddErrorLogCall
    extends MethodCall<Void> {
        private final ErrorLogBean errorLogBean;
        private final Token token;

        AddErrorLogCall(ErrorLogBean errorLogBean, Token token, ServiceMethodCallback<Void> callback) {
            super("addErrorLog", (byte)1, callback);
            this.errorLogBean = errorLogBean;
            this.token = token;
        }

        protected void send(Protocol protocol) throws IOException {
            protocol.writeStructBegin("args");
            if (this.errorLogBean != null) {
                protocol.writeFieldBegin("errorLogBean", 1, (byte)12);
                ErrorLogBean.ADAPTER.write(protocol, (Object)this.errorLogBean);
                protocol.writeFieldEnd();
            }
            if (this.token != null) {
                protocol.writeFieldBegin("token", 2, (byte)12);
                Token.ADAPTER.write(protocol, (Object)this.token);
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        protected Void receive(Protocol protocol, MessageMetadata metadata) throws Exception {
            ServiceRuntimeException ex1 = null;
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 12) {
                            ServiceRuntimeException value;
                            ex1 = value = (ServiceRuntimeException)ServiceRuntimeException.ADAPTER.read(protocol);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            if (ex1 != null) {
                throw ex1;
            }
            return null;
        }
    }
}

