/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.facelog.client.thrift;

import com.microsoft.thrifty.Adapter;
import com.microsoft.thrifty.Struct;
import com.microsoft.thrifty.StructBuilder;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.ListMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.util.ProtocolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PersonSummary
implements Struct {
    public static final Adapter<PersonSummary, Builder> ADAPTER = new PersonSummaryAdapter();
    public final String expiryDate;
    public final String extjson;
    public final List<String> featureIds;
    public final Integer personId;

    private PersonSummary(Builder builder) {
        this.expiryDate = builder.expiryDate;
        this.extjson = builder.extjson;
        this.featureIds = builder.featureIds == null ? null : Collections.unmodifiableList(builder.featureIds);
        this.personId = builder.personId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PersonSummary)) {
            return false;
        }
        PersonSummary that = (PersonSummary)other;
        return (this.expiryDate == that.expiryDate || this.expiryDate != null && this.expiryDate.equals(that.expiryDate)) && (this.extjson == that.extjson || this.extjson != null && this.extjson.equals(that.extjson)) && (this.featureIds == that.featureIds || this.featureIds != null && this.featureIds.equals(that.featureIds)) && (this.personId == that.personId || this.personId.equals(that.personId));
    }

    public int hashCode() {
        int code = 16777619;
        code ^= this.expiryDate == null ? 0 : this.expiryDate.hashCode();
        code *= -2128831035;
        code ^= this.extjson == null ? 0 : this.extjson.hashCode();
        code *= -2128831035;
        code ^= this.featureIds == null ? 0 : this.featureIds.hashCode();
        code *= -2128831035;
        code ^= this.personId.hashCode();
        return code *= -2128831035;
    }

    public String toString() {
        return "PersonSummary{expiryDate=" + this.expiryDate + ", extjson=" + this.extjson + ", featureIds=" + this.featureIds + ", personId=" + this.personId + "}";
    }

    public void write(Protocol protocol) throws IOException {
        ADAPTER.write(protocol, (Object)this);
    }

    private static final class PersonSummaryAdapter
    implements Adapter<PersonSummary, Builder> {
        private PersonSummaryAdapter() {
        }

        public void write(Protocol protocol, PersonSummary struct) throws IOException {
            protocol.writeStructBegin("PersonSummary");
            if (struct.expiryDate != null) {
                protocol.writeFieldBegin("expiryDate", 1, (byte)11);
                protocol.writeString(struct.expiryDate);
                protocol.writeFieldEnd();
            }
            if (struct.extjson != null) {
                protocol.writeFieldBegin("extjson", 2, (byte)11);
                protocol.writeString(struct.extjson);
                protocol.writeFieldEnd();
            }
            if (struct.featureIds != null) {
                protocol.writeFieldBegin("featureIds", 3, (byte)15);
                protocol.writeListBegin((byte)11, struct.featureIds.size());
                for (String item0 : struct.featureIds) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldBegin("personId", 4, (byte)8);
            protocol.writeI32(struct.personId.intValue());
            protocol.writeFieldEnd();
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        public PersonSummary read(Protocol protocol, Builder builder) throws IOException {
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 11) {
                            String value = protocol.readString();
                            builder.expiryDate(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        if (field.typeId == 11) {
                            String value = protocol.readString();
                            builder.extjson(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            builder.featureIds(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 4: {
                        if (field.typeId == 8) {
                            int value = protocol.readI32();
                            builder.personId(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            return builder.build();
        }

        public PersonSummary read(Protocol protocol) throws IOException {
            return this.read(protocol, new Builder());
        }
    }

    public static final class Builder
    implements StructBuilder<PersonSummary> {
        private String expiryDate;
        private String extjson;
        private List<String> featureIds;
        private Integer personId;

        public Builder() {
        }

        public Builder(PersonSummary struct) {
            this.expiryDate = struct.expiryDate;
            this.extjson = struct.extjson;
            this.featureIds = struct.featureIds;
            this.personId = struct.personId;
        }

        public Builder expiryDate(String expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public Builder extjson(String extjson) {
            this.extjson = extjson;
            return this;
        }

        public Builder featureIds(List<String> featureIds) {
            this.featureIds = featureIds;
            return this;
        }

        public Builder personId(Integer personId) {
            if (personId == null) {
                throw new NullPointerException("Required field 'personId' cannot be null");
            }
            this.personId = personId;
            return this;
        }

        public PersonSummary build() {
            if (this.personId == null) {
                throw new IllegalStateException("Required field 'personId' is missing");
            }
            return new PersonSummary(this);
        }

        public void reset() {
            this.expiryDate = null;
            this.extjson = null;
            this.featureIds = null;
            this.personId = null;
        }
    }
}

